# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCrossConnectsResult',
    'AwaitableGetCrossConnectsResult',
    'get_cross_connects',
    'get_cross_connects_output',
]

@pulumi.output_type
class GetCrossConnectsResult:
    """
    A collection of values returned by getCrossConnects.
    """
    def __init__(__self__, compartment_id=None, cross_connect_group_id=None, cross_connects=None, display_name=None, filters=None, id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if cross_connect_group_id and not isinstance(cross_connect_group_id, str):
            raise TypeError("Expected argument 'cross_connect_group_id' to be a str")
        pulumi.set(__self__, "cross_connect_group_id", cross_connect_group_id)
        if cross_connects and not isinstance(cross_connects, list):
            raise TypeError("Expected argument 'cross_connects' to be a list")
        pulumi.set(__self__, "cross_connects", cross_connects)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the cross-connect group.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="crossConnectGroupId")
    def cross_connect_group_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cross-connect group this cross-connect belongs to (if any).
        """
        return pulumi.get(self, "cross_connect_group_id")

    @property
    @pulumi.getter(name="crossConnects")
    def cross_connects(self) -> Sequence['outputs.GetCrossConnectsCrossConnectResult']:
        """
        The list of cross_connects.
        """
        return pulumi.get(self, "cross_connects")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetCrossConnectsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The cross-connect's current state.
        """
        return pulumi.get(self, "state")


class AwaitableGetCrossConnectsResult(GetCrossConnectsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCrossConnectsResult(
            compartment_id=self.compartment_id,
            cross_connect_group_id=self.cross_connect_group_id,
            cross_connects=self.cross_connects,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_cross_connects(compartment_id: Optional[str] = None,
                       cross_connect_group_id: Optional[str] = None,
                       display_name: Optional[str] = None,
                       filters: Optional[Sequence[pulumi.InputType['GetCrossConnectsFilterArgs']]] = None,
                       state: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCrossConnectsResult:
    """
    This data source provides the list of Cross Connects in Oracle Cloud Infrastructure Core service.

    Lists the cross-connects in the specified compartment. You can filter the list
    by specifying the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a cross-connect group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cross_connects = oci.Core.get_cross_connects(compartment_id=var["compartment_id"],
        cross_connect_group_id=oci_core_cross_connect_group["test_cross_connect_group"]["id"],
        display_name=var["cross_connect_display_name"],
        state=var["cross_connect_state"])
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str cross_connect_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cross-connect group.
    :param str display_name: A filter to return only resources that match the given display name exactly.
    :param str state: A filter to return only resources that match the specified lifecycle state. The value is case insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['crossConnectGroupId'] = cross_connect_group_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getCrossConnects:getCrossConnects', __args__, opts=opts, typ=GetCrossConnectsResult).value

    return AwaitableGetCrossConnectsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        cross_connect_group_id=pulumi.get(__ret__, 'cross_connect_group_id'),
        cross_connects=pulumi.get(__ret__, 'cross_connects'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_cross_connects)
def get_cross_connects_output(compartment_id: Optional[pulumi.Input[str]] = None,
                              cross_connect_group_id: Optional[pulumi.Input[Optional[str]]] = None,
                              display_name: Optional[pulumi.Input[Optional[str]]] = None,
                              filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetCrossConnectsFilterArgs']]]]] = None,
                              state: Optional[pulumi.Input[Optional[str]]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCrossConnectsResult]:
    """
    This data source provides the list of Cross Connects in Oracle Cloud Infrastructure Core service.

    Lists the cross-connects in the specified compartment. You can filter the list
    by specifying the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a cross-connect group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cross_connects = oci.Core.get_cross_connects(compartment_id=var["compartment_id"],
        cross_connect_group_id=oci_core_cross_connect_group["test_cross_connect_group"]["id"],
        display_name=var["cross_connect_display_name"],
        state=var["cross_connect_state"])
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str cross_connect_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cross-connect group.
    :param str display_name: A filter to return only resources that match the given display name exactly.
    :param str state: A filter to return only resources that match the specified lifecycle state. The value is case insensitive.
    """
    ...
