# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAutonomousCharacterSetsResult',
    'AwaitableGetAutonomousCharacterSetsResult',
    'get_autonomous_character_sets',
    'get_autonomous_character_sets_output',
]

@pulumi.output_type
class GetAutonomousCharacterSetsResult:
    """
    A collection of values returned by getAutonomousCharacterSets.
    """
    def __init__(__self__, autonomous_database_character_sets=None, character_set_type=None, filters=None, id=None, is_dedicated=None, is_shared=None):
        if autonomous_database_character_sets and not isinstance(autonomous_database_character_sets, list):
            raise TypeError("Expected argument 'autonomous_database_character_sets' to be a list")
        pulumi.set(__self__, "autonomous_database_character_sets", autonomous_database_character_sets)
        if character_set_type and not isinstance(character_set_type, str):
            raise TypeError("Expected argument 'character_set_type' to be a str")
        pulumi.set(__self__, "character_set_type", character_set_type)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_dedicated and not isinstance(is_dedicated, bool):
            raise TypeError("Expected argument 'is_dedicated' to be a bool")
        pulumi.set(__self__, "is_dedicated", is_dedicated)
        if is_shared and not isinstance(is_shared, bool):
            raise TypeError("Expected argument 'is_shared' to be a bool")
        pulumi.set(__self__, "is_shared", is_shared)

    @property
    @pulumi.getter(name="autonomousDatabaseCharacterSets")
    def autonomous_database_character_sets(self) -> Sequence['outputs.GetAutonomousCharacterSetsAutonomousDatabaseCharacterSetResult']:
        """
        The list of autonomous_database_character_sets.
        """
        return pulumi.get(self, "autonomous_database_character_sets")

    @property
    @pulumi.getter(name="characterSetType")
    def character_set_type(self) -> Optional[str]:
        return pulumi.get(self, "character_set_type")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAutonomousCharacterSetsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isDedicated")
    def is_dedicated(self) -> Optional[bool]:
        return pulumi.get(self, "is_dedicated")

    @property
    @pulumi.getter(name="isShared")
    def is_shared(self) -> Optional[bool]:
        return pulumi.get(self, "is_shared")


class AwaitableGetAutonomousCharacterSetsResult(GetAutonomousCharacterSetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutonomousCharacterSetsResult(
            autonomous_database_character_sets=self.autonomous_database_character_sets,
            character_set_type=self.character_set_type,
            filters=self.filters,
            id=self.id,
            is_dedicated=self.is_dedicated,
            is_shared=self.is_shared)


def get_autonomous_character_sets(character_set_type: Optional[str] = None,
                                  filters: Optional[Sequence[pulumi.InputType['GetAutonomousCharacterSetsFilterArgs']]] = None,
                                  is_dedicated: Optional[bool] = None,
                                  is_shared: Optional[bool] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutonomousCharacterSetsResult:
    """
    This data source provides the list of Autonomous Database Character Sets in Oracle Cloud Infrastructure Database service.

    Gets a list of supported character sets.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_database_character_sets = oci.Database.get_autonomous_character_sets(character_set_type=var["autonomous_database_character_set_character_set_type"],
        is_shared=var["autonomous_database_character_set_is_shared"])
    ```


    :param str character_set_type: Specifies whether this request pertains to database character sets or national character sets.
    :param bool is_dedicated: Specifies if the request is for an Autonomous Database Dedicated instance. The default request is for an Autonomous Database Dedicated instance.
    :param bool is_shared: Specifies whether this request is for Autonomous Database on Shared infrastructure. By default, this request will be for Autonomous Database on Dedicated Exadata Infrastructure.
    """
    __args__ = dict()
    __args__['characterSetType'] = character_set_type
    __args__['filters'] = filters
    __args__['isDedicated'] = is_dedicated
    __args__['isShared'] = is_shared
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getAutonomousCharacterSets:getAutonomousCharacterSets', __args__, opts=opts, typ=GetAutonomousCharacterSetsResult).value

    return AwaitableGetAutonomousCharacterSetsResult(
        autonomous_database_character_sets=pulumi.get(__ret__, 'autonomous_database_character_sets'),
        character_set_type=pulumi.get(__ret__, 'character_set_type'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_dedicated=pulumi.get(__ret__, 'is_dedicated'),
        is_shared=pulumi.get(__ret__, 'is_shared'))


@_utilities.lift_output_func(get_autonomous_character_sets)
def get_autonomous_character_sets_output(character_set_type: Optional[pulumi.Input[Optional[str]]] = None,
                                         filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetAutonomousCharacterSetsFilterArgs']]]]] = None,
                                         is_dedicated: Optional[pulumi.Input[Optional[bool]]] = None,
                                         is_shared: Optional[pulumi.Input[Optional[bool]]] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAutonomousCharacterSetsResult]:
    """
    This data source provides the list of Autonomous Database Character Sets in Oracle Cloud Infrastructure Database service.

    Gets a list of supported character sets.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_database_character_sets = oci.Database.get_autonomous_character_sets(character_set_type=var["autonomous_database_character_set_character_set_type"],
        is_shared=var["autonomous_database_character_set_is_shared"])
    ```


    :param str character_set_type: Specifies whether this request pertains to database character sets or national character sets.
    :param bool is_dedicated: Specifies if the request is for an Autonomous Database Dedicated instance. The default request is for an Autonomous Database Dedicated instance.
    :param bool is_shared: Specifies whether this request is for Autonomous Database on Shared infrastructure. By default, this request will be for Autonomous Database on Dedicated Exadata Infrastructure.
    """
    ...
