# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RunStatementArgs', 'RunStatement']

@pulumi.input_type
class RunStatementArgs:
    def __init__(__self__, *,
                 code: pulumi.Input[str],
                 run_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a RunStatement resource.
        :param pulumi.Input[str] code: The statement code to execute. Example: `println(sc.version)`
        :param pulumi.Input[str] run_id: The unique ID for the run 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        RunStatementArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            code=code,
            run_id=run_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             code: pulumi.Input[str],
             run_id: pulumi.Input[str],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'runId' in kwargs:
            run_id = kwargs['runId']

        _setter("code", code)
        _setter("run_id", run_id)

    @property
    @pulumi.getter
    def code(self) -> pulumi.Input[str]:
        """
        The statement code to execute. Example: `println(sc.version)`
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: pulumi.Input[str]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter(name="runId")
    def run_id(self) -> pulumi.Input[str]:
        """
        The unique ID for the run 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "run_id")

    @run_id.setter
    def run_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "run_id", value)


@pulumi.input_type
class _RunStatementState:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[str]] = None,
                 outputs: Optional[pulumi.Input[Sequence[pulumi.Input['RunStatementOutputArgs']]]] = None,
                 progress: Optional[pulumi.Input[float]] = None,
                 run_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_completed: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering RunStatement resources.
        :param pulumi.Input[str] code: The statement code to execute. Example: `println(sc.version)`
        :param pulumi.Input[Sequence[pulumi.Input['RunStatementOutputArgs']]] outputs: The execution output of a statement.
        :param pulumi.Input[float] progress: The execution progress.
        :param pulumi.Input[str] run_id: The unique ID for the run 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of this statement.
        :param pulumi.Input[str] time_completed: The date and time a statement execution was completed, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2022-05-31T21:10:29.600Z`
        :param pulumi.Input[str] time_created: The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        _RunStatementState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            code=code,
            outputs=outputs,
            progress=progress,
            run_id=run_id,
            state=state,
            time_completed=time_completed,
            time_created=time_created,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             code: Optional[pulumi.Input[str]] = None,
             outputs: Optional[pulumi.Input[Sequence[pulumi.Input['RunStatementOutputArgs']]]] = None,
             progress: Optional[pulumi.Input[float]] = None,
             run_id: Optional[pulumi.Input[str]] = None,
             state: Optional[pulumi.Input[str]] = None,
             time_completed: Optional[pulumi.Input[str]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'runId' in kwargs:
            run_id = kwargs['runId']
        if 'timeCompleted' in kwargs:
            time_completed = kwargs['timeCompleted']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']

        if code is not None:
            _setter("code", code)
        if outputs is not None:
            _setter("outputs", outputs)
        if progress is not None:
            _setter("progress", progress)
        if run_id is not None:
            _setter("run_id", run_id)
        if state is not None:
            _setter("state", state)
        if time_completed is not None:
            _setter("time_completed", time_completed)
        if time_created is not None:
            _setter("time_created", time_created)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[str]]:
        """
        The statement code to execute. Example: `println(sc.version)`
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter
    def outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RunStatementOutputArgs']]]]:
        """
        The execution output of a statement.
        """
        return pulumi.get(self, "outputs")

    @outputs.setter
    def outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RunStatementOutputArgs']]]]):
        pulumi.set(self, "outputs", value)

    @property
    @pulumi.getter
    def progress(self) -> Optional[pulumi.Input[float]]:
        """
        The execution progress.
        """
        return pulumi.get(self, "progress")

    @progress.setter
    def progress(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "progress", value)

    @property
    @pulumi.getter(name="runId")
    def run_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique ID for the run 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "run_id")

    @run_id.setter
    def run_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "run_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of this statement.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCompleted")
    def time_completed(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time a statement execution was completed, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2022-05-31T21:10:29.600Z`
        """
        return pulumi.get(self, "time_completed")

    @time_completed.setter
    def time_completed(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_completed", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)


class RunStatement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 code: Optional[pulumi.Input[str]] = None,
                 run_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Run Statement resource in Oracle Cloud Infrastructure Data Flow service.

        Executes a statement for a Session run.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_run_statement = oci.data_flow.RunStatement("testRunStatement",
            code=var["run_statement_code"],
            run_id=oci_dataflow_run["test_run"]["id"])
        ```

        ## Import

        RunStatements can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:DataFlow/runStatement:RunStatement test_run_statement "runs/{runId}/statements/{statementId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] code: The statement code to execute. Example: `println(sc.version)`
        :param pulumi.Input[str] run_id: The unique ID for the run 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RunStatementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Run Statement resource in Oracle Cloud Infrastructure Data Flow service.

        Executes a statement for a Session run.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_run_statement = oci.data_flow.RunStatement("testRunStatement",
            code=var["run_statement_code"],
            run_id=oci_dataflow_run["test_run"]["id"])
        ```

        ## Import

        RunStatements can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:DataFlow/runStatement:RunStatement test_run_statement "runs/{runId}/statements/{statementId}"
        ```

        :param str resource_name: The name of the resource.
        :param RunStatementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RunStatementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            RunStatementArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 code: Optional[pulumi.Input[str]] = None,
                 run_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RunStatementArgs.__new__(RunStatementArgs)

            if code is None and not opts.urn:
                raise TypeError("Missing required property 'code'")
            __props__.__dict__["code"] = code
            if run_id is None and not opts.urn:
                raise TypeError("Missing required property 'run_id'")
            __props__.__dict__["run_id"] = run_id
            __props__.__dict__["outputs"] = None
            __props__.__dict__["progress"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_completed"] = None
            __props__.__dict__["time_created"] = None
        super(RunStatement, __self__).__init__(
            'oci:DataFlow/runStatement:RunStatement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            code: Optional[pulumi.Input[str]] = None,
            outputs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RunStatementOutputArgs']]]]] = None,
            progress: Optional[pulumi.Input[float]] = None,
            run_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_completed: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None) -> 'RunStatement':
        """
        Get an existing RunStatement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] code: The statement code to execute. Example: `println(sc.version)`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RunStatementOutputArgs']]]] outputs: The execution output of a statement.
        :param pulumi.Input[float] progress: The execution progress.
        :param pulumi.Input[str] run_id: The unique ID for the run 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of this statement.
        :param pulumi.Input[str] time_completed: The date and time a statement execution was completed, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2022-05-31T21:10:29.600Z`
        :param pulumi.Input[str] time_created: The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RunStatementState.__new__(_RunStatementState)

        __props__.__dict__["code"] = code
        __props__.__dict__["outputs"] = outputs
        __props__.__dict__["progress"] = progress
        __props__.__dict__["run_id"] = run_id
        __props__.__dict__["state"] = state
        __props__.__dict__["time_completed"] = time_completed
        __props__.__dict__["time_created"] = time_created
        return RunStatement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def code(self) -> pulumi.Output[str]:
        """
        The statement code to execute. Example: `println(sc.version)`
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def outputs(self) -> pulumi.Output[Sequence['outputs.RunStatementOutput']]:
        """
        The execution output of a statement.
        """
        return pulumi.get(self, "outputs")

    @property
    @pulumi.getter
    def progress(self) -> pulumi.Output[float]:
        """
        The execution progress.
        """
        return pulumi.get(self, "progress")

    @property
    @pulumi.getter(name="runId")
    def run_id(self) -> pulumi.Output[str]:
        """
        The unique ID for the run 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "run_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of this statement.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCompleted")
    def time_completed(self) -> pulumi.Output[str]:
        """
        The date and time a statement execution was completed, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2022-05-31T21:10:29.600Z`
        """
        return pulumi.get(self, "time_completed")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

