# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SqlEndpointArgs', 'SqlEndpoint']

@pulumi.input_type
class SqlEndpointArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 driver_shape: pulumi.Input[str],
                 executor_shape: pulumi.Input[str],
                 max_executor_count: pulumi.Input[int],
                 metastore_id: pulumi.Input[str],
                 min_executor_count: pulumi.Input[int],
                 network_configuration: pulumi.Input['SqlEndpointNetworkConfigurationArgs'],
                 sql_endpoint_version: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 driver_shape_config: Optional[pulumi.Input['SqlEndpointDriverShapeConfigArgs']] = None,
                 executor_shape_config: Optional[pulumi.Input['SqlEndpointExecutorShapeConfigArgs']] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 spark_advanced_configurations: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        The set of arguments for constructing a SqlEndpoint resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The identifier of the compartment used with the SQL Endpoint.
        :param pulumi.Input[str] display_name: The SQL Endpoint name, which can be changed.
        :param pulumi.Input[str] driver_shape: The shape of the SQL Endpoint driver instance.
        :param pulumi.Input[str] executor_shape: The shape of the SQL Endpoint worker instance.
        :param pulumi.Input[int] max_executor_count: The maximum number of executors.
        :param pulumi.Input[str] metastore_id: Metastore OCID
        :param pulumi.Input[int] min_executor_count: The minimum number of executors.
        :param pulumi.Input['SqlEndpointNetworkConfigurationArgs'] network_configuration: The network configuration of a SQL Endpoint.
        :param pulumi.Input[str] sql_endpoint_version: The version of the SQL Endpoint.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: The description of CreateSQLEndpointDetails.
        :param pulumi.Input['SqlEndpointDriverShapeConfigArgs'] driver_shape_config: This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param pulumi.Input['SqlEndpointExecutorShapeConfigArgs'] executor_shape_config: This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[Mapping[str, Any]] spark_advanced_configurations: The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        """
        SqlEndpointArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            display_name=display_name,
            driver_shape=driver_shape,
            executor_shape=executor_shape,
            max_executor_count=max_executor_count,
            metastore_id=metastore_id,
            min_executor_count=min_executor_count,
            network_configuration=network_configuration,
            sql_endpoint_version=sql_endpoint_version,
            defined_tags=defined_tags,
            description=description,
            driver_shape_config=driver_shape_config,
            executor_shape_config=executor_shape_config,
            freeform_tags=freeform_tags,
            spark_advanced_configurations=spark_advanced_configurations,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: pulumi.Input[str],
             display_name: pulumi.Input[str],
             driver_shape: pulumi.Input[str],
             executor_shape: pulumi.Input[str],
             max_executor_count: pulumi.Input[int],
             metastore_id: pulumi.Input[str],
             min_executor_count: pulumi.Input[int],
             network_configuration: pulumi.Input['SqlEndpointNetworkConfigurationArgs'],
             sql_endpoint_version: pulumi.Input[str],
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             description: Optional[pulumi.Input[str]] = None,
             driver_shape_config: Optional[pulumi.Input['SqlEndpointDriverShapeConfigArgs']] = None,
             executor_shape_config: Optional[pulumi.Input['SqlEndpointExecutorShapeConfigArgs']] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             spark_advanced_configurations: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'driverShape' in kwargs:
            driver_shape = kwargs['driverShape']
        if 'executorShape' in kwargs:
            executor_shape = kwargs['executorShape']
        if 'maxExecutorCount' in kwargs:
            max_executor_count = kwargs['maxExecutorCount']
        if 'metastoreId' in kwargs:
            metastore_id = kwargs['metastoreId']
        if 'minExecutorCount' in kwargs:
            min_executor_count = kwargs['minExecutorCount']
        if 'networkConfiguration' in kwargs:
            network_configuration = kwargs['networkConfiguration']
        if 'sqlEndpointVersion' in kwargs:
            sql_endpoint_version = kwargs['sqlEndpointVersion']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'driverShapeConfig' in kwargs:
            driver_shape_config = kwargs['driverShapeConfig']
        if 'executorShapeConfig' in kwargs:
            executor_shape_config = kwargs['executorShapeConfig']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'sparkAdvancedConfigurations' in kwargs:
            spark_advanced_configurations = kwargs['sparkAdvancedConfigurations']

        _setter("compartment_id", compartment_id)
        _setter("display_name", display_name)
        _setter("driver_shape", driver_shape)
        _setter("executor_shape", executor_shape)
        _setter("max_executor_count", max_executor_count)
        _setter("metastore_id", metastore_id)
        _setter("min_executor_count", min_executor_count)
        _setter("network_configuration", network_configuration)
        _setter("sql_endpoint_version", sql_endpoint_version)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if description is not None:
            _setter("description", description)
        if driver_shape_config is not None:
            _setter("driver_shape_config", driver_shape_config)
        if executor_shape_config is not None:
            _setter("executor_shape_config", executor_shape_config)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if spark_advanced_configurations is not None:
            _setter("spark_advanced_configurations", spark_advanced_configurations)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The identifier of the compartment used with the SQL Endpoint.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        The SQL Endpoint name, which can be changed.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="driverShape")
    def driver_shape(self) -> pulumi.Input[str]:
        """
        The shape of the SQL Endpoint driver instance.
        """
        return pulumi.get(self, "driver_shape")

    @driver_shape.setter
    def driver_shape(self, value: pulumi.Input[str]):
        pulumi.set(self, "driver_shape", value)

    @property
    @pulumi.getter(name="executorShape")
    def executor_shape(self) -> pulumi.Input[str]:
        """
        The shape of the SQL Endpoint worker instance.
        """
        return pulumi.get(self, "executor_shape")

    @executor_shape.setter
    def executor_shape(self, value: pulumi.Input[str]):
        pulumi.set(self, "executor_shape", value)

    @property
    @pulumi.getter(name="maxExecutorCount")
    def max_executor_count(self) -> pulumi.Input[int]:
        """
        The maximum number of executors.
        """
        return pulumi.get(self, "max_executor_count")

    @max_executor_count.setter
    def max_executor_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_executor_count", value)

    @property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> pulumi.Input[str]:
        """
        Metastore OCID
        """
        return pulumi.get(self, "metastore_id")

    @metastore_id.setter
    def metastore_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "metastore_id", value)

    @property
    @pulumi.getter(name="minExecutorCount")
    def min_executor_count(self) -> pulumi.Input[int]:
        """
        The minimum number of executors.
        """
        return pulumi.get(self, "min_executor_count")

    @min_executor_count.setter
    def min_executor_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "min_executor_count", value)

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> pulumi.Input['SqlEndpointNetworkConfigurationArgs']:
        """
        The network configuration of a SQL Endpoint.
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: pulumi.Input['SqlEndpointNetworkConfigurationArgs']):
        pulumi.set(self, "network_configuration", value)

    @property
    @pulumi.getter(name="sqlEndpointVersion")
    def sql_endpoint_version(self) -> pulumi.Input[str]:
        """
        The version of the SQL Endpoint.
        """
        return pulumi.get(self, "sql_endpoint_version")

    @sql_endpoint_version.setter
    def sql_endpoint_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "sql_endpoint_version", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of CreateSQLEndpointDetails.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="driverShapeConfig")
    def driver_shape_config(self) -> Optional[pulumi.Input['SqlEndpointDriverShapeConfigArgs']]:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "driver_shape_config")

    @driver_shape_config.setter
    def driver_shape_config(self, value: Optional[pulumi.Input['SqlEndpointDriverShapeConfigArgs']]):
        pulumi.set(self, "driver_shape_config", value)

    @property
    @pulumi.getter(name="executorShapeConfig")
    def executor_shape_config(self) -> Optional[pulumi.Input['SqlEndpointExecutorShapeConfigArgs']]:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "executor_shape_config")

    @executor_shape_config.setter
    def executor_shape_config(self, value: Optional[pulumi.Input['SqlEndpointExecutorShapeConfigArgs']]):
        pulumi.set(self, "executor_shape_config", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="sparkAdvancedConfigurations")
    def spark_advanced_configurations(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        """
        return pulumi.get(self, "spark_advanced_configurations")

    @spark_advanced_configurations.setter
    def spark_advanced_configurations(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "spark_advanced_configurations", value)


@pulumi.input_type
class _SqlEndpointState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 driver_shape: Optional[pulumi.Input[str]] = None,
                 driver_shape_config: Optional[pulumi.Input['SqlEndpointDriverShapeConfigArgs']] = None,
                 executor_shape: Optional[pulumi.Input[str]] = None,
                 executor_shape_config: Optional[pulumi.Input['SqlEndpointExecutorShapeConfigArgs']] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 jdbc_endpoint_url: Optional[pulumi.Input[str]] = None,
                 lake_id: Optional[pulumi.Input[str]] = None,
                 last_accepted_request_token: Optional[pulumi.Input[str]] = None,
                 max_executor_count: Optional[pulumi.Input[int]] = None,
                 metastore_id: Optional[pulumi.Input[str]] = None,
                 min_executor_count: Optional[pulumi.Input[int]] = None,
                 network_configuration: Optional[pulumi.Input['SqlEndpointNetworkConfigurationArgs']] = None,
                 spark_advanced_configurations: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 sql_endpoint_version: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 state_message: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 warehouse_bucket_uri: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SqlEndpoint resources.
        :param pulumi.Input[str] compartment_id: (Updatable) The identifier of the compartment used with the SQL Endpoint.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: The description of CreateSQLEndpointDetails.
        :param pulumi.Input[str] display_name: The SQL Endpoint name, which can be changed.
        :param pulumi.Input[str] driver_shape: The shape of the SQL Endpoint driver instance.
        :param pulumi.Input['SqlEndpointDriverShapeConfigArgs'] driver_shape_config: This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param pulumi.Input[str] executor_shape: The shape of the SQL Endpoint worker instance.
        :param pulumi.Input['SqlEndpointExecutorShapeConfigArgs'] executor_shape_config: This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] jdbc_endpoint_url: The JDBC URL field. For example, jdbc:spark://{serviceFQDN}:443/default;SparkServerType=DFI
        :param pulumi.Input[str] lake_id: Oracle Cloud Infrastructure lake OCID
        :param pulumi.Input[str] last_accepted_request_token: This token is used by Splat, and indicates that the service accepts the request, and that the request is currently being processed.
        :param pulumi.Input[int] max_executor_count: The maximum number of executors.
        :param pulumi.Input[str] metastore_id: Metastore OCID
        :param pulumi.Input[int] min_executor_count: The minimum number of executors.
        :param pulumi.Input['SqlEndpointNetworkConfigurationArgs'] network_configuration: The network configuration of a SQL Endpoint.
        :param pulumi.Input[Mapping[str, Any]] spark_advanced_configurations: The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        :param pulumi.Input[str] sql_endpoint_version: The version of the SQL Endpoint.
        :param pulumi.Input[str] state: The current state of the Sql Endpoint.
        :param pulumi.Input[str] state_message: A message describing the reason why the resource is in it's current state. Helps bubble up errors in state changes. For example, it can be used to provide actionable information for a resource in the Failed state.
        :param pulumi.Input[Mapping[str, Any]] system_tags: The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        :param pulumi.Input[str] time_created: The time the Sql Endpoint was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time the Sql Endpoint was updated. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] warehouse_bucket_uri: The warehouse bucket URI. It is a Oracle Cloud Infrastructure Object Storage bucket URI as defined here https://docs.oracle.com/en/cloud/paas/atp-cloud/atpud/object-storage-uris.html
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        _SqlEndpointState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            description=description,
            display_name=display_name,
            driver_shape=driver_shape,
            driver_shape_config=driver_shape_config,
            executor_shape=executor_shape,
            executor_shape_config=executor_shape_config,
            freeform_tags=freeform_tags,
            jdbc_endpoint_url=jdbc_endpoint_url,
            lake_id=lake_id,
            last_accepted_request_token=last_accepted_request_token,
            max_executor_count=max_executor_count,
            metastore_id=metastore_id,
            min_executor_count=min_executor_count,
            network_configuration=network_configuration,
            spark_advanced_configurations=spark_advanced_configurations,
            sql_endpoint_version=sql_endpoint_version,
            state=state,
            state_message=state_message,
            system_tags=system_tags,
            time_created=time_created,
            time_updated=time_updated,
            warehouse_bucket_uri=warehouse_bucket_uri,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             description: Optional[pulumi.Input[str]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             driver_shape: Optional[pulumi.Input[str]] = None,
             driver_shape_config: Optional[pulumi.Input['SqlEndpointDriverShapeConfigArgs']] = None,
             executor_shape: Optional[pulumi.Input[str]] = None,
             executor_shape_config: Optional[pulumi.Input['SqlEndpointExecutorShapeConfigArgs']] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             jdbc_endpoint_url: Optional[pulumi.Input[str]] = None,
             lake_id: Optional[pulumi.Input[str]] = None,
             last_accepted_request_token: Optional[pulumi.Input[str]] = None,
             max_executor_count: Optional[pulumi.Input[int]] = None,
             metastore_id: Optional[pulumi.Input[str]] = None,
             min_executor_count: Optional[pulumi.Input[int]] = None,
             network_configuration: Optional[pulumi.Input['SqlEndpointNetworkConfigurationArgs']] = None,
             spark_advanced_configurations: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             sql_endpoint_version: Optional[pulumi.Input[str]] = None,
             state: Optional[pulumi.Input[str]] = None,
             state_message: Optional[pulumi.Input[str]] = None,
             system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             time_updated: Optional[pulumi.Input[str]] = None,
             warehouse_bucket_uri: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'driverShape' in kwargs:
            driver_shape = kwargs['driverShape']
        if 'driverShapeConfig' in kwargs:
            driver_shape_config = kwargs['driverShapeConfig']
        if 'executorShape' in kwargs:
            executor_shape = kwargs['executorShape']
        if 'executorShapeConfig' in kwargs:
            executor_shape_config = kwargs['executorShapeConfig']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'jdbcEndpointUrl' in kwargs:
            jdbc_endpoint_url = kwargs['jdbcEndpointUrl']
        if 'lakeId' in kwargs:
            lake_id = kwargs['lakeId']
        if 'lastAcceptedRequestToken' in kwargs:
            last_accepted_request_token = kwargs['lastAcceptedRequestToken']
        if 'maxExecutorCount' in kwargs:
            max_executor_count = kwargs['maxExecutorCount']
        if 'metastoreId' in kwargs:
            metastore_id = kwargs['metastoreId']
        if 'minExecutorCount' in kwargs:
            min_executor_count = kwargs['minExecutorCount']
        if 'networkConfiguration' in kwargs:
            network_configuration = kwargs['networkConfiguration']
        if 'sparkAdvancedConfigurations' in kwargs:
            spark_advanced_configurations = kwargs['sparkAdvancedConfigurations']
        if 'sqlEndpointVersion' in kwargs:
            sql_endpoint_version = kwargs['sqlEndpointVersion']
        if 'stateMessage' in kwargs:
            state_message = kwargs['stateMessage']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']
        if 'warehouseBucketUri' in kwargs:
            warehouse_bucket_uri = kwargs['warehouseBucketUri']

        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if description is not None:
            _setter("description", description)
        if display_name is not None:
            _setter("display_name", display_name)
        if driver_shape is not None:
            _setter("driver_shape", driver_shape)
        if driver_shape_config is not None:
            _setter("driver_shape_config", driver_shape_config)
        if executor_shape is not None:
            _setter("executor_shape", executor_shape)
        if executor_shape_config is not None:
            _setter("executor_shape_config", executor_shape_config)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if jdbc_endpoint_url is not None:
            _setter("jdbc_endpoint_url", jdbc_endpoint_url)
        if lake_id is not None:
            _setter("lake_id", lake_id)
        if last_accepted_request_token is not None:
            _setter("last_accepted_request_token", last_accepted_request_token)
        if max_executor_count is not None:
            _setter("max_executor_count", max_executor_count)
        if metastore_id is not None:
            _setter("metastore_id", metastore_id)
        if min_executor_count is not None:
            _setter("min_executor_count", min_executor_count)
        if network_configuration is not None:
            _setter("network_configuration", network_configuration)
        if spark_advanced_configurations is not None:
            _setter("spark_advanced_configurations", spark_advanced_configurations)
        if sql_endpoint_version is not None:
            _setter("sql_endpoint_version", sql_endpoint_version)
        if state is not None:
            _setter("state", state)
        if state_message is not None:
            _setter("state_message", state_message)
        if system_tags is not None:
            _setter("system_tags", system_tags)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_updated is not None:
            _setter("time_updated", time_updated)
        if warehouse_bucket_uri is not None:
            _setter("warehouse_bucket_uri", warehouse_bucket_uri)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The identifier of the compartment used with the SQL Endpoint.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of CreateSQLEndpointDetails.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The SQL Endpoint name, which can be changed.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="driverShape")
    def driver_shape(self) -> Optional[pulumi.Input[str]]:
        """
        The shape of the SQL Endpoint driver instance.
        """
        return pulumi.get(self, "driver_shape")

    @driver_shape.setter
    def driver_shape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "driver_shape", value)

    @property
    @pulumi.getter(name="driverShapeConfig")
    def driver_shape_config(self) -> Optional[pulumi.Input['SqlEndpointDriverShapeConfigArgs']]:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "driver_shape_config")

    @driver_shape_config.setter
    def driver_shape_config(self, value: Optional[pulumi.Input['SqlEndpointDriverShapeConfigArgs']]):
        pulumi.set(self, "driver_shape_config", value)

    @property
    @pulumi.getter(name="executorShape")
    def executor_shape(self) -> Optional[pulumi.Input[str]]:
        """
        The shape of the SQL Endpoint worker instance.
        """
        return pulumi.get(self, "executor_shape")

    @executor_shape.setter
    def executor_shape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "executor_shape", value)

    @property
    @pulumi.getter(name="executorShapeConfig")
    def executor_shape_config(self) -> Optional[pulumi.Input['SqlEndpointExecutorShapeConfigArgs']]:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "executor_shape_config")

    @executor_shape_config.setter
    def executor_shape_config(self, value: Optional[pulumi.Input['SqlEndpointExecutorShapeConfigArgs']]):
        pulumi.set(self, "executor_shape_config", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="jdbcEndpointUrl")
    def jdbc_endpoint_url(self) -> Optional[pulumi.Input[str]]:
        """
        The JDBC URL field. For example, jdbc:spark://{serviceFQDN}:443/default;SparkServerType=DFI
        """
        return pulumi.get(self, "jdbc_endpoint_url")

    @jdbc_endpoint_url.setter
    def jdbc_endpoint_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jdbc_endpoint_url", value)

    @property
    @pulumi.getter(name="lakeId")
    def lake_id(self) -> Optional[pulumi.Input[str]]:
        """
        Oracle Cloud Infrastructure lake OCID
        """
        return pulumi.get(self, "lake_id")

    @lake_id.setter
    def lake_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lake_id", value)

    @property
    @pulumi.getter(name="lastAcceptedRequestToken")
    def last_accepted_request_token(self) -> Optional[pulumi.Input[str]]:
        """
        This token is used by Splat, and indicates that the service accepts the request, and that the request is currently being processed.
        """
        return pulumi.get(self, "last_accepted_request_token")

    @last_accepted_request_token.setter
    def last_accepted_request_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_accepted_request_token", value)

    @property
    @pulumi.getter(name="maxExecutorCount")
    def max_executor_count(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of executors.
        """
        return pulumi.get(self, "max_executor_count")

    @max_executor_count.setter
    def max_executor_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_executor_count", value)

    @property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> Optional[pulumi.Input[str]]:
        """
        Metastore OCID
        """
        return pulumi.get(self, "metastore_id")

    @metastore_id.setter
    def metastore_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metastore_id", value)

    @property
    @pulumi.getter(name="minExecutorCount")
    def min_executor_count(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of executors.
        """
        return pulumi.get(self, "min_executor_count")

    @min_executor_count.setter
    def min_executor_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_executor_count", value)

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional[pulumi.Input['SqlEndpointNetworkConfigurationArgs']]:
        """
        The network configuration of a SQL Endpoint.
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: Optional[pulumi.Input['SqlEndpointNetworkConfigurationArgs']]):
        pulumi.set(self, "network_configuration", value)

    @property
    @pulumi.getter(name="sparkAdvancedConfigurations")
    def spark_advanced_configurations(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        """
        return pulumi.get(self, "spark_advanced_configurations")

    @spark_advanced_configurations.setter
    def spark_advanced_configurations(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "spark_advanced_configurations", value)

    @property
    @pulumi.getter(name="sqlEndpointVersion")
    def sql_endpoint_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the SQL Endpoint.
        """
        return pulumi.get(self, "sql_endpoint_version")

    @sql_endpoint_version.setter
    def sql_endpoint_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sql_endpoint_version", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the Sql Endpoint.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the reason why the resource is in it's current state. Helps bubble up errors in state changes. For example, it can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "state_message")

    @state_message.setter
    def state_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state_message", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the Sql Endpoint was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time the Sql Endpoint was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="warehouseBucketUri")
    def warehouse_bucket_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The warehouse bucket URI. It is a Oracle Cloud Infrastructure Object Storage bucket URI as defined here https://docs.oracle.com/en/cloud/paas/atp-cloud/atpud/object-storage-uris.html


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "warehouse_bucket_uri")

    @warehouse_bucket_uri.setter
    def warehouse_bucket_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "warehouse_bucket_uri", value)


class SqlEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 driver_shape: Optional[pulumi.Input[str]] = None,
                 driver_shape_config: Optional[pulumi.Input[pulumi.InputType['SqlEndpointDriverShapeConfigArgs']]] = None,
                 executor_shape: Optional[pulumi.Input[str]] = None,
                 executor_shape_config: Optional[pulumi.Input[pulumi.InputType['SqlEndpointExecutorShapeConfigArgs']]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 max_executor_count: Optional[pulumi.Input[int]] = None,
                 metastore_id: Optional[pulumi.Input[str]] = None,
                 min_executor_count: Optional[pulumi.Input[int]] = None,
                 network_configuration: Optional[pulumi.Input[pulumi.InputType['SqlEndpointNetworkConfigurationArgs']]] = None,
                 spark_advanced_configurations: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 sql_endpoint_version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Sql Endpoint resource in Oracle Cloud Infrastructure Data Flow service.
        ## Note

        Resource Discovery is not supported for this resource.

        Create a new Sql Endpoint.

        ## Import

        SqlEndpoints can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:DataFlow/sqlEndpoint:SqlEndpoint test_sql_endpoint "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The identifier of the compartment used with the SQL Endpoint.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: The description of CreateSQLEndpointDetails.
        :param pulumi.Input[str] display_name: The SQL Endpoint name, which can be changed.
        :param pulumi.Input[str] driver_shape: The shape of the SQL Endpoint driver instance.
        :param pulumi.Input[pulumi.InputType['SqlEndpointDriverShapeConfigArgs']] driver_shape_config: This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param pulumi.Input[str] executor_shape: The shape of the SQL Endpoint worker instance.
        :param pulumi.Input[pulumi.InputType['SqlEndpointExecutorShapeConfigArgs']] executor_shape_config: This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[int] max_executor_count: The maximum number of executors.
        :param pulumi.Input[str] metastore_id: Metastore OCID
        :param pulumi.Input[int] min_executor_count: The minimum number of executors.
        :param pulumi.Input[pulumi.InputType['SqlEndpointNetworkConfigurationArgs']] network_configuration: The network configuration of a SQL Endpoint.
        :param pulumi.Input[Mapping[str, Any]] spark_advanced_configurations: The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        :param pulumi.Input[str] sql_endpoint_version: The version of the SQL Endpoint.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SqlEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Sql Endpoint resource in Oracle Cloud Infrastructure Data Flow service.
        ## Note

        Resource Discovery is not supported for this resource.

        Create a new Sql Endpoint.

        ## Import

        SqlEndpoints can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:DataFlow/sqlEndpoint:SqlEndpoint test_sql_endpoint "id"
        ```

        :param str resource_name: The name of the resource.
        :param SqlEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SqlEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            SqlEndpointArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 driver_shape: Optional[pulumi.Input[str]] = None,
                 driver_shape_config: Optional[pulumi.Input[pulumi.InputType['SqlEndpointDriverShapeConfigArgs']]] = None,
                 executor_shape: Optional[pulumi.Input[str]] = None,
                 executor_shape_config: Optional[pulumi.Input[pulumi.InputType['SqlEndpointExecutorShapeConfigArgs']]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 max_executor_count: Optional[pulumi.Input[int]] = None,
                 metastore_id: Optional[pulumi.Input[str]] = None,
                 min_executor_count: Optional[pulumi.Input[int]] = None,
                 network_configuration: Optional[pulumi.Input[pulumi.InputType['SqlEndpointNetworkConfigurationArgs']]] = None,
                 spark_advanced_configurations: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 sql_endpoint_version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SqlEndpointArgs.__new__(SqlEndpointArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if driver_shape is None and not opts.urn:
                raise TypeError("Missing required property 'driver_shape'")
            __props__.__dict__["driver_shape"] = driver_shape
            if driver_shape_config is not None and not isinstance(driver_shape_config, SqlEndpointDriverShapeConfigArgs):
                driver_shape_config = driver_shape_config or {}
                def _setter(key, value):
                    driver_shape_config[key] = value
                SqlEndpointDriverShapeConfigArgs._configure(_setter, **driver_shape_config)
            __props__.__dict__["driver_shape_config"] = driver_shape_config
            if executor_shape is None and not opts.urn:
                raise TypeError("Missing required property 'executor_shape'")
            __props__.__dict__["executor_shape"] = executor_shape
            if executor_shape_config is not None and not isinstance(executor_shape_config, SqlEndpointExecutorShapeConfigArgs):
                executor_shape_config = executor_shape_config or {}
                def _setter(key, value):
                    executor_shape_config[key] = value
                SqlEndpointExecutorShapeConfigArgs._configure(_setter, **executor_shape_config)
            __props__.__dict__["executor_shape_config"] = executor_shape_config
            __props__.__dict__["freeform_tags"] = freeform_tags
            if max_executor_count is None and not opts.urn:
                raise TypeError("Missing required property 'max_executor_count'")
            __props__.__dict__["max_executor_count"] = max_executor_count
            if metastore_id is None and not opts.urn:
                raise TypeError("Missing required property 'metastore_id'")
            __props__.__dict__["metastore_id"] = metastore_id
            if min_executor_count is None and not opts.urn:
                raise TypeError("Missing required property 'min_executor_count'")
            __props__.__dict__["min_executor_count"] = min_executor_count
            if network_configuration is not None and not isinstance(network_configuration, SqlEndpointNetworkConfigurationArgs):
                network_configuration = network_configuration or {}
                def _setter(key, value):
                    network_configuration[key] = value
                SqlEndpointNetworkConfigurationArgs._configure(_setter, **network_configuration)
            if network_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'network_configuration'")
            __props__.__dict__["network_configuration"] = network_configuration
            __props__.__dict__["spark_advanced_configurations"] = spark_advanced_configurations
            if sql_endpoint_version is None and not opts.urn:
                raise TypeError("Missing required property 'sql_endpoint_version'")
            __props__.__dict__["sql_endpoint_version"] = sql_endpoint_version
            __props__.__dict__["jdbc_endpoint_url"] = None
            __props__.__dict__["lake_id"] = None
            __props__.__dict__["last_accepted_request_token"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["state_message"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["warehouse_bucket_uri"] = None
        super(SqlEndpoint, __self__).__init__(
            'oci:DataFlow/sqlEndpoint:SqlEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            driver_shape: Optional[pulumi.Input[str]] = None,
            driver_shape_config: Optional[pulumi.Input[pulumi.InputType['SqlEndpointDriverShapeConfigArgs']]] = None,
            executor_shape: Optional[pulumi.Input[str]] = None,
            executor_shape_config: Optional[pulumi.Input[pulumi.InputType['SqlEndpointExecutorShapeConfigArgs']]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            jdbc_endpoint_url: Optional[pulumi.Input[str]] = None,
            lake_id: Optional[pulumi.Input[str]] = None,
            last_accepted_request_token: Optional[pulumi.Input[str]] = None,
            max_executor_count: Optional[pulumi.Input[int]] = None,
            metastore_id: Optional[pulumi.Input[str]] = None,
            min_executor_count: Optional[pulumi.Input[int]] = None,
            network_configuration: Optional[pulumi.Input[pulumi.InputType['SqlEndpointNetworkConfigurationArgs']]] = None,
            spark_advanced_configurations: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            sql_endpoint_version: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            state_message: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            warehouse_bucket_uri: Optional[pulumi.Input[str]] = None) -> 'SqlEndpoint':
        """
        Get an existing SqlEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The identifier of the compartment used with the SQL Endpoint.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: The description of CreateSQLEndpointDetails.
        :param pulumi.Input[str] display_name: The SQL Endpoint name, which can be changed.
        :param pulumi.Input[str] driver_shape: The shape of the SQL Endpoint driver instance.
        :param pulumi.Input[pulumi.InputType['SqlEndpointDriverShapeConfigArgs']] driver_shape_config: This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param pulumi.Input[str] executor_shape: The shape of the SQL Endpoint worker instance.
        :param pulumi.Input[pulumi.InputType['SqlEndpointExecutorShapeConfigArgs']] executor_shape_config: This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] jdbc_endpoint_url: The JDBC URL field. For example, jdbc:spark://{serviceFQDN}:443/default;SparkServerType=DFI
        :param pulumi.Input[str] lake_id: Oracle Cloud Infrastructure lake OCID
        :param pulumi.Input[str] last_accepted_request_token: This token is used by Splat, and indicates that the service accepts the request, and that the request is currently being processed.
        :param pulumi.Input[int] max_executor_count: The maximum number of executors.
        :param pulumi.Input[str] metastore_id: Metastore OCID
        :param pulumi.Input[int] min_executor_count: The minimum number of executors.
        :param pulumi.Input[pulumi.InputType['SqlEndpointNetworkConfigurationArgs']] network_configuration: The network configuration of a SQL Endpoint.
        :param pulumi.Input[Mapping[str, Any]] spark_advanced_configurations: The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        :param pulumi.Input[str] sql_endpoint_version: The version of the SQL Endpoint.
        :param pulumi.Input[str] state: The current state of the Sql Endpoint.
        :param pulumi.Input[str] state_message: A message describing the reason why the resource is in it's current state. Helps bubble up errors in state changes. For example, it can be used to provide actionable information for a resource in the Failed state.
        :param pulumi.Input[Mapping[str, Any]] system_tags: The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        :param pulumi.Input[str] time_created: The time the Sql Endpoint was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time the Sql Endpoint was updated. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] warehouse_bucket_uri: The warehouse bucket URI. It is a Oracle Cloud Infrastructure Object Storage bucket URI as defined here https://docs.oracle.com/en/cloud/paas/atp-cloud/atpud/object-storage-uris.html
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SqlEndpointState.__new__(_SqlEndpointState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["driver_shape"] = driver_shape
        __props__.__dict__["driver_shape_config"] = driver_shape_config
        __props__.__dict__["executor_shape"] = executor_shape
        __props__.__dict__["executor_shape_config"] = executor_shape_config
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["jdbc_endpoint_url"] = jdbc_endpoint_url
        __props__.__dict__["lake_id"] = lake_id
        __props__.__dict__["last_accepted_request_token"] = last_accepted_request_token
        __props__.__dict__["max_executor_count"] = max_executor_count
        __props__.__dict__["metastore_id"] = metastore_id
        __props__.__dict__["min_executor_count"] = min_executor_count
        __props__.__dict__["network_configuration"] = network_configuration
        __props__.__dict__["spark_advanced_configurations"] = spark_advanced_configurations
        __props__.__dict__["sql_endpoint_version"] = sql_endpoint_version
        __props__.__dict__["state"] = state
        __props__.__dict__["state_message"] = state_message
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["warehouse_bucket_uri"] = warehouse_bucket_uri
        return SqlEndpoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The identifier of the compartment used with the SQL Endpoint.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of CreateSQLEndpointDetails.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The SQL Endpoint name, which can be changed.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="driverShape")
    def driver_shape(self) -> pulumi.Output[str]:
        """
        The shape of the SQL Endpoint driver instance.
        """
        return pulumi.get(self, "driver_shape")

    @property
    @pulumi.getter(name="driverShapeConfig")
    def driver_shape_config(self) -> pulumi.Output['outputs.SqlEndpointDriverShapeConfig']:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "driver_shape_config")

    @property
    @pulumi.getter(name="executorShape")
    def executor_shape(self) -> pulumi.Output[str]:
        """
        The shape of the SQL Endpoint worker instance.
        """
        return pulumi.get(self, "executor_shape")

    @property
    @pulumi.getter(name="executorShapeConfig")
    def executor_shape_config(self) -> pulumi.Output['outputs.SqlEndpointExecutorShapeConfig']:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "executor_shape_config")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="jdbcEndpointUrl")
    def jdbc_endpoint_url(self) -> pulumi.Output[str]:
        """
        The JDBC URL field. For example, jdbc:spark://{serviceFQDN}:443/default;SparkServerType=DFI
        """
        return pulumi.get(self, "jdbc_endpoint_url")

    @property
    @pulumi.getter(name="lakeId")
    def lake_id(self) -> pulumi.Output[str]:
        """
        Oracle Cloud Infrastructure lake OCID
        """
        return pulumi.get(self, "lake_id")

    @property
    @pulumi.getter(name="lastAcceptedRequestToken")
    def last_accepted_request_token(self) -> pulumi.Output[str]:
        """
        This token is used by Splat, and indicates that the service accepts the request, and that the request is currently being processed.
        """
        return pulumi.get(self, "last_accepted_request_token")

    @property
    @pulumi.getter(name="maxExecutorCount")
    def max_executor_count(self) -> pulumi.Output[int]:
        """
        The maximum number of executors.
        """
        return pulumi.get(self, "max_executor_count")

    @property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> pulumi.Output[str]:
        """
        Metastore OCID
        """
        return pulumi.get(self, "metastore_id")

    @property
    @pulumi.getter(name="minExecutorCount")
    def min_executor_count(self) -> pulumi.Output[int]:
        """
        The minimum number of executors.
        """
        return pulumi.get(self, "min_executor_count")

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> pulumi.Output['outputs.SqlEndpointNetworkConfiguration']:
        """
        The network configuration of a SQL Endpoint.
        """
        return pulumi.get(self, "network_configuration")

    @property
    @pulumi.getter(name="sparkAdvancedConfigurations")
    def spark_advanced_configurations(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        """
        return pulumi.get(self, "spark_advanced_configurations")

    @property
    @pulumi.getter(name="sqlEndpointVersion")
    def sql_endpoint_version(self) -> pulumi.Output[str]:
        """
        The version of the SQL Endpoint.
        """
        return pulumi.get(self, "sql_endpoint_version")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the Sql Endpoint.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> pulumi.Output[str]:
        """
        A message describing the reason why the resource is in it's current state. Helps bubble up errors in state changes. For example, it can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "state_message")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the Sql Endpoint was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time the Sql Endpoint was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="warehouseBucketUri")
    def warehouse_bucket_uri(self) -> pulumi.Output[str]:
        """
        The warehouse bucket URI. It is a Oracle Cloud Infrastructure Object Storage bucket URI as defined here https://docs.oracle.com/en/cloud/paas/atp-cloud/atpud/object-storage-uris.html


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "warehouse_bucket_uri")

