# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ModelDeploymentArgs', 'ModelDeployment']

@pulumi.input_type
class ModelDeploymentArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 model_deployment_configuration_details: pulumi.Input['ModelDeploymentModelDeploymentConfigurationDetailsArgs'],
                 project_id: pulumi.Input[str],
                 category_log_details: Optional[pulumi.Input['ModelDeploymentCategoryLogDetailsArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ModelDeployment resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the model deployment.
        :param pulumi.Input['ModelDeploymentModelDeploymentConfigurationDetailsArgs'] model_deployment_configuration_details: (Updatable) The model deployment configuration details.
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the model deployment.
        :param pulumi.Input['ModelDeploymentCategoryLogDetailsArgs'] category_log_details: (Updatable) The log details for each category.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) A short description of the model deployment.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource. Does not have to be unique, and can be modified. Avoid entering confidential information. Example: `My ModelDeployment`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] state: (Updatable) The target state for the Model Deployment. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ModelDeploymentArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            model_deployment_configuration_details=model_deployment_configuration_details,
            project_id=project_id,
            category_log_details=category_log_details,
            defined_tags=defined_tags,
            description=description,
            display_name=display_name,
            freeform_tags=freeform_tags,
            state=state,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: pulumi.Input[str],
             model_deployment_configuration_details: pulumi.Input['ModelDeploymentModelDeploymentConfigurationDetailsArgs'],
             project_id: pulumi.Input[str],
             category_log_details: Optional[pulumi.Input['ModelDeploymentCategoryLogDetailsArgs']] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             description: Optional[pulumi.Input[str]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             state: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'modelDeploymentConfigurationDetails' in kwargs:
            model_deployment_configuration_details = kwargs['modelDeploymentConfigurationDetails']
        if 'projectId' in kwargs:
            project_id = kwargs['projectId']
        if 'categoryLogDetails' in kwargs:
            category_log_details = kwargs['categoryLogDetails']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']

        _setter("compartment_id", compartment_id)
        _setter("model_deployment_configuration_details", model_deployment_configuration_details)
        _setter("project_id", project_id)
        if category_log_details is not None:
            _setter("category_log_details", category_log_details)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if description is not None:
            _setter("description", description)
        if display_name is not None:
            _setter("display_name", display_name)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if state is not None:
            _setter("state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the model deployment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="modelDeploymentConfigurationDetails")
    def model_deployment_configuration_details(self) -> pulumi.Input['ModelDeploymentModelDeploymentConfigurationDetailsArgs']:
        """
        (Updatable) The model deployment configuration details.
        """
        return pulumi.get(self, "model_deployment_configuration_details")

    @model_deployment_configuration_details.setter
    def model_deployment_configuration_details(self, value: pulumi.Input['ModelDeploymentModelDeploymentConfigurationDetailsArgs']):
        pulumi.set(self, "model_deployment_configuration_details", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the model deployment.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="categoryLogDetails")
    def category_log_details(self) -> Optional[pulumi.Input['ModelDeploymentCategoryLogDetailsArgs']]:
        """
        (Updatable) The log details for each category.
        """
        return pulumi.get(self, "category_log_details")

    @category_log_details.setter
    def category_log_details(self, value: Optional[pulumi.Input['ModelDeploymentCategoryLogDetailsArgs']]):
        pulumi.set(self, "category_log_details", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A short description of the model deployment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly display name for the resource. Does not have to be unique, and can be modified. Avoid entering confidential information. Example: `My ModelDeployment`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The target state for the Model Deployment. Could be set to `ACTIVE` or `INACTIVE`. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class _ModelDeploymentState:
    def __init__(__self__, *,
                 category_log_details: Optional[pulumi.Input['ModelDeploymentCategoryLogDetailsArgs']] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 created_by: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 model_deployment_configuration_details: Optional[pulumi.Input['ModelDeploymentModelDeploymentConfigurationDetailsArgs']] = None,
                 model_deployment_url: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ModelDeployment resources.
        :param pulumi.Input['ModelDeploymentCategoryLogDetailsArgs'] category_log_details: (Updatable) The log details for each category.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the model deployment.
        :param pulumi.Input[str] created_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the model deployment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) A short description of the model deployment.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource. Does not have to be unique, and can be modified. Avoid entering confidential information. Example: `My ModelDeployment`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] lifecycle_details: Details about the state of the model deployment.
        :param pulumi.Input['ModelDeploymentModelDeploymentConfigurationDetailsArgs'] model_deployment_configuration_details: (Updatable) The model deployment configuration details.
        :param pulumi.Input[str] model_deployment_url: The URL to interact with the model deployment.
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the model deployment.
        :param pulumi.Input[str] state: (Updatable) The target state for the Model Deployment. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_created: The date and time the resource was created, in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2019-08-25T21:10:29.41Z
        """
        _ModelDeploymentState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            category_log_details=category_log_details,
            compartment_id=compartment_id,
            created_by=created_by,
            defined_tags=defined_tags,
            description=description,
            display_name=display_name,
            freeform_tags=freeform_tags,
            lifecycle_details=lifecycle_details,
            model_deployment_configuration_details=model_deployment_configuration_details,
            model_deployment_url=model_deployment_url,
            project_id=project_id,
            state=state,
            time_created=time_created,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             category_log_details: Optional[pulumi.Input['ModelDeploymentCategoryLogDetailsArgs']] = None,
             compartment_id: Optional[pulumi.Input[str]] = None,
             created_by: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             description: Optional[pulumi.Input[str]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             lifecycle_details: Optional[pulumi.Input[str]] = None,
             model_deployment_configuration_details: Optional[pulumi.Input['ModelDeploymentModelDeploymentConfigurationDetailsArgs']] = None,
             model_deployment_url: Optional[pulumi.Input[str]] = None,
             project_id: Optional[pulumi.Input[str]] = None,
             state: Optional[pulumi.Input[str]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'categoryLogDetails' in kwargs:
            category_log_details = kwargs['categoryLogDetails']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'createdBy' in kwargs:
            created_by = kwargs['createdBy']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'modelDeploymentConfigurationDetails' in kwargs:
            model_deployment_configuration_details = kwargs['modelDeploymentConfigurationDetails']
        if 'modelDeploymentUrl' in kwargs:
            model_deployment_url = kwargs['modelDeploymentUrl']
        if 'projectId' in kwargs:
            project_id = kwargs['projectId']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']

        if category_log_details is not None:
            _setter("category_log_details", category_log_details)
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if created_by is not None:
            _setter("created_by", created_by)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if description is not None:
            _setter("description", description)
        if display_name is not None:
            _setter("display_name", display_name)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            _setter("lifecycle_details", lifecycle_details)
        if model_deployment_configuration_details is not None:
            _setter("model_deployment_configuration_details", model_deployment_configuration_details)
        if model_deployment_url is not None:
            _setter("model_deployment_url", model_deployment_url)
        if project_id is not None:
            _setter("project_id", project_id)
        if state is not None:
            _setter("state", state)
        if time_created is not None:
            _setter("time_created", time_created)

    @property
    @pulumi.getter(name="categoryLogDetails")
    def category_log_details(self) -> Optional[pulumi.Input['ModelDeploymentCategoryLogDetailsArgs']]:
        """
        (Updatable) The log details for each category.
        """
        return pulumi.get(self, "category_log_details")

    @category_log_details.setter
    def category_log_details(self, value: Optional[pulumi.Input['ModelDeploymentCategoryLogDetailsArgs']]):
        pulumi.set(self, "category_log_details", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the model deployment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the model deployment.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A short description of the model deployment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly display name for the resource. Does not have to be unique, and can be modified. Avoid entering confidential information. Example: `My ModelDeployment`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Details about the state of the model deployment.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="modelDeploymentConfigurationDetails")
    def model_deployment_configuration_details(self) -> Optional[pulumi.Input['ModelDeploymentModelDeploymentConfigurationDetailsArgs']]:
        """
        (Updatable) The model deployment configuration details.
        """
        return pulumi.get(self, "model_deployment_configuration_details")

    @model_deployment_configuration_details.setter
    def model_deployment_configuration_details(self, value: Optional[pulumi.Input['ModelDeploymentModelDeploymentConfigurationDetailsArgs']]):
        pulumi.set(self, "model_deployment_configuration_details", value)

    @property
    @pulumi.getter(name="modelDeploymentUrl")
    def model_deployment_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL to interact with the model deployment.
        """
        return pulumi.get(self, "model_deployment_url")

    @model_deployment_url.setter
    def model_deployment_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_deployment_url", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the model deployment.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The target state for the Model Deployment. Could be set to `ACTIVE` or `INACTIVE`. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the resource was created, in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2019-08-25T21:10:29.41Z
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)


class ModelDeployment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category_log_details: Optional[pulumi.Input[pulumi.InputType['ModelDeploymentCategoryLogDetailsArgs']]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 model_deployment_configuration_details: Optional[pulumi.Input[pulumi.InputType['ModelDeploymentModelDeploymentConfigurationDetailsArgs']]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Model Deployment resource in Oracle Cloud Infrastructure Datascience service.

        Creates a new model deployment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_model_deployment = oci.data_science.ModelDeployment("testModelDeployment",
            compartment_id=var["compartment_id"],
            model_deployment_configuration_details=oci.data_science.ModelDeploymentModelDeploymentConfigurationDetailsArgs(
                deployment_type=var["model_deployment_model_deployment_configuration_details_deployment_type"],
                model_configuration_details=oci.data_science.ModelDeploymentModelDeploymentConfigurationDetailsModelConfigurationDetailsArgs(
                    instance_configuration=oci.data_science.ModelDeploymentModelDeploymentConfigurationDetailsModelConfigurationDetailsInstanceConfigurationArgs(
                        instance_shape_name=oci_core_shape["test_shape"]["name"],
                        model_deployment_instance_shape_config_details=oci.data_science.ModelDeploymentModelDeploymentConfigurationDetailsModelConfigurationDetailsInstanceConfigurationModelDeploymentInstanceShapeConfigDetailsArgs(
                            memory_in_gbs=var["model_deployment_model_deployment_configuration_details_model_configuration_details_instance_configuration_model_deployment_instance_shape_config_details_memory_in_gbs"],
                            ocpus=var["model_deployment_model_deployment_configuration_details_model_configuration_details_instance_configuration_model_deployment_instance_shape_config_details_ocpus"],
                        ),
                    ),
                    model_id=oci_datascience_model["test_model"]["id"],
                    bandwidth_mbps=var["model_deployment_model_deployment_configuration_details_model_configuration_details_bandwidth_mbps"],
                    scaling_policy=oci.data_science.ModelDeploymentModelDeploymentConfigurationDetailsModelConfigurationDetailsScalingPolicyArgs(
                        instance_count=var["model_deployment_model_deployment_configuration_details_model_configuration_details_scaling_policy_instance_count"],
                        policy_type=var["model_deployment_model_deployment_configuration_details_model_configuration_details_scaling_policy_policy_type"],
                    ),
                ),
                environment_configuration_details=oci.data_science.ModelDeploymentModelDeploymentConfigurationDetailsEnvironmentConfigurationDetailsArgs(
                    environment_configuration_type=var["model_deployment_model_deployment_configuration_details_environment_configuration_details_environment_configuration_type"],
                    cmds=var["model_deployment_model_deployment_configuration_details_environment_configuration_details_cmd"],
                    entrypoints=var["model_deployment_model_deployment_configuration_details_environment_configuration_details_entrypoint"],
                    environment_variables=var["model_deployment_model_deployment_configuration_details_environment_configuration_details_environment_variables"],
                    health_check_port=var["model_deployment_model_deployment_configuration_details_environment_configuration_details_health_check_port"],
                    image=var["model_deployment_model_deployment_configuration_details_environment_configuration_details_image"],
                    image_digest=var["model_deployment_model_deployment_configuration_details_environment_configuration_details_image_digest"],
                    server_port=var["model_deployment_model_deployment_configuration_details_environment_configuration_details_server_port"],
                ),
            ),
            project_id=oci_datascience_project["test_project"]["id"],
            category_log_details=oci.data_science.ModelDeploymentCategoryLogDetailsArgs(
                access=oci.data_science.ModelDeploymentCategoryLogDetailsAccessArgs(
                    log_group_id=oci_logging_log_group["test_log_group"]["id"],
                    log_id=oci_logging_log["test_log"]["id"],
                ),
                predict=oci.data_science.ModelDeploymentCategoryLogDetailsPredictArgs(
                    log_group_id=oci_logging_log_group["test_log_group"]["id"],
                    log_id=oci_logging_log["test_log"]["id"],
                ),
            ),
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=var["model_deployment_description"],
            display_name=var["model_deployment_display_name"],
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        ModelDeployments can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:DataScience/modelDeployment:ModelDeployment test_model_deployment "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ModelDeploymentCategoryLogDetailsArgs']] category_log_details: (Updatable) The log details for each category.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the model deployment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) A short description of the model deployment.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource. Does not have to be unique, and can be modified. Avoid entering confidential information. Example: `My ModelDeployment`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[pulumi.InputType['ModelDeploymentModelDeploymentConfigurationDetailsArgs']] model_deployment_configuration_details: (Updatable) The model deployment configuration details.
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the model deployment.
        :param pulumi.Input[str] state: (Updatable) The target state for the Model Deployment. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ModelDeploymentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Model Deployment resource in Oracle Cloud Infrastructure Datascience service.

        Creates a new model deployment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_model_deployment = oci.data_science.ModelDeployment("testModelDeployment",
            compartment_id=var["compartment_id"],
            model_deployment_configuration_details=oci.data_science.ModelDeploymentModelDeploymentConfigurationDetailsArgs(
                deployment_type=var["model_deployment_model_deployment_configuration_details_deployment_type"],
                model_configuration_details=oci.data_science.ModelDeploymentModelDeploymentConfigurationDetailsModelConfigurationDetailsArgs(
                    instance_configuration=oci.data_science.ModelDeploymentModelDeploymentConfigurationDetailsModelConfigurationDetailsInstanceConfigurationArgs(
                        instance_shape_name=oci_core_shape["test_shape"]["name"],
                        model_deployment_instance_shape_config_details=oci.data_science.ModelDeploymentModelDeploymentConfigurationDetailsModelConfigurationDetailsInstanceConfigurationModelDeploymentInstanceShapeConfigDetailsArgs(
                            memory_in_gbs=var["model_deployment_model_deployment_configuration_details_model_configuration_details_instance_configuration_model_deployment_instance_shape_config_details_memory_in_gbs"],
                            ocpus=var["model_deployment_model_deployment_configuration_details_model_configuration_details_instance_configuration_model_deployment_instance_shape_config_details_ocpus"],
                        ),
                    ),
                    model_id=oci_datascience_model["test_model"]["id"],
                    bandwidth_mbps=var["model_deployment_model_deployment_configuration_details_model_configuration_details_bandwidth_mbps"],
                    scaling_policy=oci.data_science.ModelDeploymentModelDeploymentConfigurationDetailsModelConfigurationDetailsScalingPolicyArgs(
                        instance_count=var["model_deployment_model_deployment_configuration_details_model_configuration_details_scaling_policy_instance_count"],
                        policy_type=var["model_deployment_model_deployment_configuration_details_model_configuration_details_scaling_policy_policy_type"],
                    ),
                ),
                environment_configuration_details=oci.data_science.ModelDeploymentModelDeploymentConfigurationDetailsEnvironmentConfigurationDetailsArgs(
                    environment_configuration_type=var["model_deployment_model_deployment_configuration_details_environment_configuration_details_environment_configuration_type"],
                    cmds=var["model_deployment_model_deployment_configuration_details_environment_configuration_details_cmd"],
                    entrypoints=var["model_deployment_model_deployment_configuration_details_environment_configuration_details_entrypoint"],
                    environment_variables=var["model_deployment_model_deployment_configuration_details_environment_configuration_details_environment_variables"],
                    health_check_port=var["model_deployment_model_deployment_configuration_details_environment_configuration_details_health_check_port"],
                    image=var["model_deployment_model_deployment_configuration_details_environment_configuration_details_image"],
                    image_digest=var["model_deployment_model_deployment_configuration_details_environment_configuration_details_image_digest"],
                    server_port=var["model_deployment_model_deployment_configuration_details_environment_configuration_details_server_port"],
                ),
            ),
            project_id=oci_datascience_project["test_project"]["id"],
            category_log_details=oci.data_science.ModelDeploymentCategoryLogDetailsArgs(
                access=oci.data_science.ModelDeploymentCategoryLogDetailsAccessArgs(
                    log_group_id=oci_logging_log_group["test_log_group"]["id"],
                    log_id=oci_logging_log["test_log"]["id"],
                ),
                predict=oci.data_science.ModelDeploymentCategoryLogDetailsPredictArgs(
                    log_group_id=oci_logging_log_group["test_log_group"]["id"],
                    log_id=oci_logging_log["test_log"]["id"],
                ),
            ),
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=var["model_deployment_description"],
            display_name=var["model_deployment_display_name"],
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        ModelDeployments can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:DataScience/modelDeployment:ModelDeployment test_model_deployment "id"
        ```

        :param str resource_name: The name of the resource.
        :param ModelDeploymentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ModelDeploymentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            ModelDeploymentArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category_log_details: Optional[pulumi.Input[pulumi.InputType['ModelDeploymentCategoryLogDetailsArgs']]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 model_deployment_configuration_details: Optional[pulumi.Input[pulumi.InputType['ModelDeploymentModelDeploymentConfigurationDetailsArgs']]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ModelDeploymentArgs.__new__(ModelDeploymentArgs)

            if category_log_details is not None and not isinstance(category_log_details, ModelDeploymentCategoryLogDetailsArgs):
                category_log_details = category_log_details or {}
                def _setter(key, value):
                    category_log_details[key] = value
                ModelDeploymentCategoryLogDetailsArgs._configure(_setter, **category_log_details)
            __props__.__dict__["category_log_details"] = category_log_details
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if model_deployment_configuration_details is not None and not isinstance(model_deployment_configuration_details, ModelDeploymentModelDeploymentConfigurationDetailsArgs):
                model_deployment_configuration_details = model_deployment_configuration_details or {}
                def _setter(key, value):
                    model_deployment_configuration_details[key] = value
                ModelDeploymentModelDeploymentConfigurationDetailsArgs._configure(_setter, **model_deployment_configuration_details)
            if model_deployment_configuration_details is None and not opts.urn:
                raise TypeError("Missing required property 'model_deployment_configuration_details'")
            __props__.__dict__["model_deployment_configuration_details"] = model_deployment_configuration_details
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["state"] = state
            __props__.__dict__["created_by"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["model_deployment_url"] = None
            __props__.__dict__["time_created"] = None
        super(ModelDeployment, __self__).__init__(
            'oci:DataScience/modelDeployment:ModelDeployment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            category_log_details: Optional[pulumi.Input[pulumi.InputType['ModelDeploymentCategoryLogDetailsArgs']]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            created_by: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            model_deployment_configuration_details: Optional[pulumi.Input[pulumi.InputType['ModelDeploymentModelDeploymentConfigurationDetailsArgs']]] = None,
            model_deployment_url: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None) -> 'ModelDeployment':
        """
        Get an existing ModelDeployment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ModelDeploymentCategoryLogDetailsArgs']] category_log_details: (Updatable) The log details for each category.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the model deployment.
        :param pulumi.Input[str] created_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the model deployment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) A short description of the model deployment.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource. Does not have to be unique, and can be modified. Avoid entering confidential information. Example: `My ModelDeployment`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] lifecycle_details: Details about the state of the model deployment.
        :param pulumi.Input[pulumi.InputType['ModelDeploymentModelDeploymentConfigurationDetailsArgs']] model_deployment_configuration_details: (Updatable) The model deployment configuration details.
        :param pulumi.Input[str] model_deployment_url: The URL to interact with the model deployment.
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the model deployment.
        :param pulumi.Input[str] state: (Updatable) The target state for the Model Deployment. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_created: The date and time the resource was created, in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2019-08-25T21:10:29.41Z
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ModelDeploymentState.__new__(_ModelDeploymentState)

        __props__.__dict__["category_log_details"] = category_log_details
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["model_deployment_configuration_details"] = model_deployment_configuration_details
        __props__.__dict__["model_deployment_url"] = model_deployment_url
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        return ModelDeployment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="categoryLogDetails")
    def category_log_details(self) -> pulumi.Output['outputs.ModelDeploymentCategoryLogDetails']:
        """
        (Updatable) The log details for each category.
        """
        return pulumi.get(self, "category_log_details")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the model deployment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the model deployment.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) A short description of the model deployment.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly display name for the resource. Does not have to be unique, and can be modified. Avoid entering confidential information. Example: `My ModelDeployment`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Details about the state of the model deployment.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="modelDeploymentConfigurationDetails")
    def model_deployment_configuration_details(self) -> pulumi.Output['outputs.ModelDeploymentModelDeploymentConfigurationDetails']:
        """
        (Updatable) The model deployment configuration details.
        """
        return pulumi.get(self, "model_deployment_configuration_details")

    @property
    @pulumi.getter(name="modelDeploymentUrl")
    def model_deployment_url(self) -> pulumi.Output[str]:
        """
        The URL to interact with the model deployment.
        """
        return pulumi.get(self, "model_deployment_url")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the model deployment.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        (Updatable) The target state for the Model Deployment. Could be set to `ACTIVE` or `INACTIVE`. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the resource was created, in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2019-08-25T21:10:29.41Z
        """
        return pulumi.get(self, "time_created")

