# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PipelineRunArgs', 'PipelineRun']

@pulumi.input_type
class PipelineRunArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 pipeline_id: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 configuration_override_details: Optional[pulumi.Input['PipelineRunConfigurationOverrideDetailsArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 delete_related_job_runs: Optional[pulumi.Input[bool]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 log_configuration_override_details: Optional[pulumi.Input['PipelineRunLogConfigurationOverrideDetailsArgs']] = None,
                 step_override_details: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineRunStepOverrideDetailArgs']]]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        The set of arguments for constructing a PipelineRun resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the pipeline run.
        :param pulumi.Input[str] pipeline_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the pipeline for which pipeline run is created.
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the pipeline run with.
        :param pulumi.Input['PipelineRunConfigurationOverrideDetailsArgs'] configuration_override_details: The configuration details of a pipeline.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input['PipelineRunLogConfigurationOverrideDetailsArgs'] log_configuration_override_details: The pipeline log configuration details.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineRunStepOverrideDetailArgs']]] step_override_details: Array of step override details. Only Step Configuration is allowed to be overridden.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        PipelineRunArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            pipeline_id=pipeline_id,
            project_id=project_id,
            configuration_override_details=configuration_override_details,
            defined_tags=defined_tags,
            delete_related_job_runs=delete_related_job_runs,
            display_name=display_name,
            freeform_tags=freeform_tags,
            log_configuration_override_details=log_configuration_override_details,
            step_override_details=step_override_details,
            system_tags=system_tags,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: pulumi.Input[str],
             pipeline_id: pulumi.Input[str],
             project_id: pulumi.Input[str],
             configuration_override_details: Optional[pulumi.Input['PipelineRunConfigurationOverrideDetailsArgs']] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             delete_related_job_runs: Optional[pulumi.Input[bool]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             log_configuration_override_details: Optional[pulumi.Input['PipelineRunLogConfigurationOverrideDetailsArgs']] = None,
             step_override_details: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineRunStepOverrideDetailArgs']]]] = None,
             system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'pipelineId' in kwargs:
            pipeline_id = kwargs['pipelineId']
        if 'projectId' in kwargs:
            project_id = kwargs['projectId']
        if 'configurationOverrideDetails' in kwargs:
            configuration_override_details = kwargs['configurationOverrideDetails']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'deleteRelatedJobRuns' in kwargs:
            delete_related_job_runs = kwargs['deleteRelatedJobRuns']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'logConfigurationOverrideDetails' in kwargs:
            log_configuration_override_details = kwargs['logConfigurationOverrideDetails']
        if 'stepOverrideDetails' in kwargs:
            step_override_details = kwargs['stepOverrideDetails']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']

        _setter("compartment_id", compartment_id)
        _setter("pipeline_id", pipeline_id)
        _setter("project_id", project_id)
        if configuration_override_details is not None:
            _setter("configuration_override_details", configuration_override_details)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if delete_related_job_runs is not None:
            _setter("delete_related_job_runs", delete_related_job_runs)
        if display_name is not None:
            _setter("display_name", display_name)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if log_configuration_override_details is not None:
            _setter("log_configuration_override_details", log_configuration_override_details)
        if step_override_details is not None:
            _setter("step_override_details", step_override_details)
        if system_tags is not None:
            _setter("system_tags", system_tags)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the pipeline run.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the pipeline for which pipeline run is created.
        """
        return pulumi.get(self, "pipeline_id")

    @pipeline_id.setter
    def pipeline_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "pipeline_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the pipeline run with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="configurationOverrideDetails")
    def configuration_override_details(self) -> Optional[pulumi.Input['PipelineRunConfigurationOverrideDetailsArgs']]:
        """
        The configuration details of a pipeline.
        """
        return pulumi.get(self, "configuration_override_details")

    @configuration_override_details.setter
    def configuration_override_details(self, value: Optional[pulumi.Input['PipelineRunConfigurationOverrideDetailsArgs']]):
        pulumi.set(self, "configuration_override_details", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="deleteRelatedJobRuns")
    def delete_related_job_runs(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "delete_related_job_runs")

    @delete_related_job_runs.setter
    def delete_related_job_runs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_related_job_runs", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly display name for the resource.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="logConfigurationOverrideDetails")
    def log_configuration_override_details(self) -> Optional[pulumi.Input['PipelineRunLogConfigurationOverrideDetailsArgs']]:
        """
        The pipeline log configuration details.
        """
        return pulumi.get(self, "log_configuration_override_details")

    @log_configuration_override_details.setter
    def log_configuration_override_details(self, value: Optional[pulumi.Input['PipelineRunLogConfigurationOverrideDetailsArgs']]):
        pulumi.set(self, "log_configuration_override_details", value)

    @property
    @pulumi.getter(name="stepOverrideDetails")
    def step_override_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineRunStepOverrideDetailArgs']]]]:
        """
        Array of step override details. Only Step Configuration is allowed to be overridden.
        """
        return pulumi.get(self, "step_override_details")

    @step_override_details.setter
    def step_override_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineRunStepOverrideDetailArgs']]]]):
        pulumi.set(self, "step_override_details", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)


@pulumi.input_type
class _PipelineRunState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 configuration_details: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineRunConfigurationDetailArgs']]]] = None,
                 configuration_override_details: Optional[pulumi.Input['PipelineRunConfigurationOverrideDetailsArgs']] = None,
                 created_by: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 delete_related_job_runs: Optional[pulumi.Input[bool]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 log_configuration_override_details: Optional[pulumi.Input['PipelineRunLogConfigurationOverrideDetailsArgs']] = None,
                 log_details: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineRunLogDetailArgs']]]] = None,
                 pipeline_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 step_override_details: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineRunStepOverrideDetailArgs']]]] = None,
                 step_runs: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineRunStepRunArgs']]]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_accepted: Optional[pulumi.Input[str]] = None,
                 time_finished: Optional[pulumi.Input[str]] = None,
                 time_started: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering PipelineRun resources.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the pipeline run.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineRunConfigurationDetailArgs']]] configuration_details: The configuration details of a pipeline.
        :param pulumi.Input['PipelineRunConfigurationOverrideDetailsArgs'] configuration_override_details: The configuration details of a pipeline.
        :param pulumi.Input[str] created_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the pipeline run.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] lifecycle_details: Details of the state of the step run.
        :param pulumi.Input['PipelineRunLogConfigurationOverrideDetailsArgs'] log_configuration_override_details: The pipeline log configuration details.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineRunLogDetailArgs']]] log_details: Customer logging details for pipeline run.
        :param pulumi.Input[str] pipeline_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the pipeline for which pipeline run is created.
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the pipeline run with.
        :param pulumi.Input[str] state: The state of the step run.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineRunStepOverrideDetailArgs']]] step_override_details: Array of step override details. Only Step Configuration is allowed to be overridden.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineRunStepRunArgs']]] step_runs: Array of StepRun object for each step.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_accepted: The date and time the pipeline run was accepted in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] time_finished: The date and time the pipeline run request was finished in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] time_started: The date and time the pipeline run request was started in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] time_updated: The date and time the pipeline run was updated in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        _PipelineRunState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            configuration_details=configuration_details,
            configuration_override_details=configuration_override_details,
            created_by=created_by,
            defined_tags=defined_tags,
            delete_related_job_runs=delete_related_job_runs,
            display_name=display_name,
            freeform_tags=freeform_tags,
            lifecycle_details=lifecycle_details,
            log_configuration_override_details=log_configuration_override_details,
            log_details=log_details,
            pipeline_id=pipeline_id,
            project_id=project_id,
            state=state,
            step_override_details=step_override_details,
            step_runs=step_runs,
            system_tags=system_tags,
            time_accepted=time_accepted,
            time_finished=time_finished,
            time_started=time_started,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: Optional[pulumi.Input[str]] = None,
             configuration_details: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineRunConfigurationDetailArgs']]]] = None,
             configuration_override_details: Optional[pulumi.Input['PipelineRunConfigurationOverrideDetailsArgs']] = None,
             created_by: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             delete_related_job_runs: Optional[pulumi.Input[bool]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             lifecycle_details: Optional[pulumi.Input[str]] = None,
             log_configuration_override_details: Optional[pulumi.Input['PipelineRunLogConfigurationOverrideDetailsArgs']] = None,
             log_details: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineRunLogDetailArgs']]]] = None,
             pipeline_id: Optional[pulumi.Input[str]] = None,
             project_id: Optional[pulumi.Input[str]] = None,
             state: Optional[pulumi.Input[str]] = None,
             step_override_details: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineRunStepOverrideDetailArgs']]]] = None,
             step_runs: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineRunStepRunArgs']]]] = None,
             system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             time_accepted: Optional[pulumi.Input[str]] = None,
             time_finished: Optional[pulumi.Input[str]] = None,
             time_started: Optional[pulumi.Input[str]] = None,
             time_updated: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'configurationDetails' in kwargs:
            configuration_details = kwargs['configurationDetails']
        if 'configurationOverrideDetails' in kwargs:
            configuration_override_details = kwargs['configurationOverrideDetails']
        if 'createdBy' in kwargs:
            created_by = kwargs['createdBy']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'deleteRelatedJobRuns' in kwargs:
            delete_related_job_runs = kwargs['deleteRelatedJobRuns']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'logConfigurationOverrideDetails' in kwargs:
            log_configuration_override_details = kwargs['logConfigurationOverrideDetails']
        if 'logDetails' in kwargs:
            log_details = kwargs['logDetails']
        if 'pipelineId' in kwargs:
            pipeline_id = kwargs['pipelineId']
        if 'projectId' in kwargs:
            project_id = kwargs['projectId']
        if 'stepOverrideDetails' in kwargs:
            step_override_details = kwargs['stepOverrideDetails']
        if 'stepRuns' in kwargs:
            step_runs = kwargs['stepRuns']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']
        if 'timeAccepted' in kwargs:
            time_accepted = kwargs['timeAccepted']
        if 'timeFinished' in kwargs:
            time_finished = kwargs['timeFinished']
        if 'timeStarted' in kwargs:
            time_started = kwargs['timeStarted']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if configuration_details is not None:
            _setter("configuration_details", configuration_details)
        if configuration_override_details is not None:
            _setter("configuration_override_details", configuration_override_details)
        if created_by is not None:
            _setter("created_by", created_by)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if delete_related_job_runs is not None:
            _setter("delete_related_job_runs", delete_related_job_runs)
        if display_name is not None:
            _setter("display_name", display_name)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            _setter("lifecycle_details", lifecycle_details)
        if log_configuration_override_details is not None:
            _setter("log_configuration_override_details", log_configuration_override_details)
        if log_details is not None:
            _setter("log_details", log_details)
        if pipeline_id is not None:
            _setter("pipeline_id", pipeline_id)
        if project_id is not None:
            _setter("project_id", project_id)
        if state is not None:
            _setter("state", state)
        if step_override_details is not None:
            _setter("step_override_details", step_override_details)
        if step_runs is not None:
            _setter("step_runs", step_runs)
        if system_tags is not None:
            _setter("system_tags", system_tags)
        if time_accepted is not None:
            _setter("time_accepted", time_accepted)
        if time_finished is not None:
            _setter("time_finished", time_finished)
        if time_started is not None:
            _setter("time_started", time_started)
        if time_updated is not None:
            _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the pipeline run.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="configurationDetails")
    def configuration_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineRunConfigurationDetailArgs']]]]:
        """
        The configuration details of a pipeline.
        """
        return pulumi.get(self, "configuration_details")

    @configuration_details.setter
    def configuration_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineRunConfigurationDetailArgs']]]]):
        pulumi.set(self, "configuration_details", value)

    @property
    @pulumi.getter(name="configurationOverrideDetails")
    def configuration_override_details(self) -> Optional[pulumi.Input['PipelineRunConfigurationOverrideDetailsArgs']]:
        """
        The configuration details of a pipeline.
        """
        return pulumi.get(self, "configuration_override_details")

    @configuration_override_details.setter
    def configuration_override_details(self, value: Optional[pulumi.Input['PipelineRunConfigurationOverrideDetailsArgs']]):
        pulumi.set(self, "configuration_override_details", value)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the pipeline run.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="deleteRelatedJobRuns")
    def delete_related_job_runs(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "delete_related_job_runs")

    @delete_related_job_runs.setter
    def delete_related_job_runs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_related_job_runs", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly display name for the resource.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Details of the state of the step run.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="logConfigurationOverrideDetails")
    def log_configuration_override_details(self) -> Optional[pulumi.Input['PipelineRunLogConfigurationOverrideDetailsArgs']]:
        """
        The pipeline log configuration details.
        """
        return pulumi.get(self, "log_configuration_override_details")

    @log_configuration_override_details.setter
    def log_configuration_override_details(self, value: Optional[pulumi.Input['PipelineRunLogConfigurationOverrideDetailsArgs']]):
        pulumi.set(self, "log_configuration_override_details", value)

    @property
    @pulumi.getter(name="logDetails")
    def log_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineRunLogDetailArgs']]]]:
        """
        Customer logging details for pipeline run.
        """
        return pulumi.get(self, "log_details")

    @log_details.setter
    def log_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineRunLogDetailArgs']]]]):
        pulumi.set(self, "log_details", value)

    @property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the pipeline for which pipeline run is created.
        """
        return pulumi.get(self, "pipeline_id")

    @pipeline_id.setter
    def pipeline_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pipeline_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the pipeline run with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the step run.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="stepOverrideDetails")
    def step_override_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineRunStepOverrideDetailArgs']]]]:
        """
        Array of step override details. Only Step Configuration is allowed to be overridden.
        """
        return pulumi.get(self, "step_override_details")

    @step_override_details.setter
    def step_override_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineRunStepOverrideDetailArgs']]]]):
        pulumi.set(self, "step_override_details", value)

    @property
    @pulumi.getter(name="stepRuns")
    def step_runs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineRunStepRunArgs']]]]:
        """
        Array of StepRun object for each step.
        """
        return pulumi.get(self, "step_runs")

    @step_runs.setter
    def step_runs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineRunStepRunArgs']]]]):
        pulumi.set(self, "step_runs", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeAccepted")
    def time_accepted(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the pipeline run was accepted in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_accepted")

    @time_accepted.setter
    def time_accepted(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_accepted", value)

    @property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the pipeline run request was finished in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_finished")

    @time_finished.setter
    def time_finished(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_finished", value)

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the pipeline run request was started in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_started")

    @time_started.setter
    def time_started(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_started", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the pipeline run was updated in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class PipelineRun(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 configuration_override_details: Optional[pulumi.Input[pulumi.InputType['PipelineRunConfigurationOverrideDetailsArgs']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 delete_related_job_runs: Optional[pulumi.Input[bool]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 log_configuration_override_details: Optional[pulumi.Input[pulumi.InputType['PipelineRunLogConfigurationOverrideDetailsArgs']]] = None,
                 pipeline_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 step_override_details: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineRunStepOverrideDetailArgs']]]]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 __props__=None):
        """
        This resource provides the Pipeline Run resource in Oracle Cloud Infrastructure Data Science service.

        Creates a new PipelineRun.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_pipeline_run = oci.data_science.PipelineRun("testPipelineRun",
            compartment_id=var["compartment_id"],
            pipeline_id=oci_datascience_pipeline["test_pipeline"]["id"],
            configuration_override_details=oci.data_science.PipelineRunConfigurationOverrideDetailsArgs(
                type=var["pipeline_run_configuration_override_details_type"],
                command_line_arguments=var["pipeline_run_configuration_override_details_command_line_arguments"],
                environment_variables=var["pipeline_run_configuration_override_details_environment_variables"],
                maximum_runtime_in_minutes=var["pipeline_run_configuration_override_details_maximum_runtime_in_minutes"],
            ),
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=var["pipeline_run_display_name"],
            freeform_tags={
                "Department": "Finance",
            },
            log_configuration_override_details=oci.data_science.PipelineRunLogConfigurationOverrideDetailsArgs(
                enable_auto_log_creation=var["pipeline_run_log_configuration_override_details_enable_auto_log_creation"],
                enable_logging=var["pipeline_run_log_configuration_override_details_enable_logging"],
                log_group_id=oci_logging_log_group["test_log_group"]["id"],
                log_id=oci_logging_log["test_log"]["id"],
            ),
            project_id=oci_datascience_project["test_project"]["id"],
            step_override_details=[oci.data_science.PipelineRunStepOverrideDetailArgs(
                step_configuration_details=oci.data_science.PipelineRunStepOverrideDetailStepConfigurationDetailsArgs(
                    command_line_arguments=var["pipeline_run_step_override_details_step_configuration_details_command_line_arguments"],
                    environment_variables=var["pipeline_run_step_override_details_step_configuration_details_environment_variables"],
                    maximum_runtime_in_minutes=var["pipeline_run_step_override_details_step_configuration_details_maximum_runtime_in_minutes"],
                ),
                step_name=var["pipeline_run_step_override_details_step_name"],
            )],
            system_tags=var["pipeline_run_system_tags"])
        ```

        ## Import

        PipelineRuns can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:DataScience/pipelineRun:PipelineRun test_pipeline_run "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the pipeline run.
        :param pulumi.Input[pulumi.InputType['PipelineRunConfigurationOverrideDetailsArgs']] configuration_override_details: The configuration details of a pipeline.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[pulumi.InputType['PipelineRunLogConfigurationOverrideDetailsArgs']] log_configuration_override_details: The pipeline log configuration details.
        :param pulumi.Input[str] pipeline_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the pipeline for which pipeline run is created.
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the pipeline run with.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineRunStepOverrideDetailArgs']]]] step_override_details: Array of step override details. Only Step Configuration is allowed to be overridden.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PipelineRunArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Pipeline Run resource in Oracle Cloud Infrastructure Data Science service.

        Creates a new PipelineRun.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_pipeline_run = oci.data_science.PipelineRun("testPipelineRun",
            compartment_id=var["compartment_id"],
            pipeline_id=oci_datascience_pipeline["test_pipeline"]["id"],
            configuration_override_details=oci.data_science.PipelineRunConfigurationOverrideDetailsArgs(
                type=var["pipeline_run_configuration_override_details_type"],
                command_line_arguments=var["pipeline_run_configuration_override_details_command_line_arguments"],
                environment_variables=var["pipeline_run_configuration_override_details_environment_variables"],
                maximum_runtime_in_minutes=var["pipeline_run_configuration_override_details_maximum_runtime_in_minutes"],
            ),
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=var["pipeline_run_display_name"],
            freeform_tags={
                "Department": "Finance",
            },
            log_configuration_override_details=oci.data_science.PipelineRunLogConfigurationOverrideDetailsArgs(
                enable_auto_log_creation=var["pipeline_run_log_configuration_override_details_enable_auto_log_creation"],
                enable_logging=var["pipeline_run_log_configuration_override_details_enable_logging"],
                log_group_id=oci_logging_log_group["test_log_group"]["id"],
                log_id=oci_logging_log["test_log"]["id"],
            ),
            project_id=oci_datascience_project["test_project"]["id"],
            step_override_details=[oci.data_science.PipelineRunStepOverrideDetailArgs(
                step_configuration_details=oci.data_science.PipelineRunStepOverrideDetailStepConfigurationDetailsArgs(
                    command_line_arguments=var["pipeline_run_step_override_details_step_configuration_details_command_line_arguments"],
                    environment_variables=var["pipeline_run_step_override_details_step_configuration_details_environment_variables"],
                    maximum_runtime_in_minutes=var["pipeline_run_step_override_details_step_configuration_details_maximum_runtime_in_minutes"],
                ),
                step_name=var["pipeline_run_step_override_details_step_name"],
            )],
            system_tags=var["pipeline_run_system_tags"])
        ```

        ## Import

        PipelineRuns can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:DataScience/pipelineRun:PipelineRun test_pipeline_run "id"
        ```

        :param str resource_name: The name of the resource.
        :param PipelineRunArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PipelineRunArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            PipelineRunArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 configuration_override_details: Optional[pulumi.Input[pulumi.InputType['PipelineRunConfigurationOverrideDetailsArgs']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 delete_related_job_runs: Optional[pulumi.Input[bool]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 log_configuration_override_details: Optional[pulumi.Input[pulumi.InputType['PipelineRunLogConfigurationOverrideDetailsArgs']]] = None,
                 pipeline_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 step_override_details: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineRunStepOverrideDetailArgs']]]]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PipelineRunArgs.__new__(PipelineRunArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if configuration_override_details is not None and not isinstance(configuration_override_details, PipelineRunConfigurationOverrideDetailsArgs):
                configuration_override_details = configuration_override_details or {}
                def _setter(key, value):
                    configuration_override_details[key] = value
                PipelineRunConfigurationOverrideDetailsArgs._configure(_setter, **configuration_override_details)
            __props__.__dict__["configuration_override_details"] = configuration_override_details
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["delete_related_job_runs"] = delete_related_job_runs
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if log_configuration_override_details is not None and not isinstance(log_configuration_override_details, PipelineRunLogConfigurationOverrideDetailsArgs):
                log_configuration_override_details = log_configuration_override_details or {}
                def _setter(key, value):
                    log_configuration_override_details[key] = value
                PipelineRunLogConfigurationOverrideDetailsArgs._configure(_setter, **log_configuration_override_details)
            __props__.__dict__["log_configuration_override_details"] = log_configuration_override_details
            if pipeline_id is None and not opts.urn:
                raise TypeError("Missing required property 'pipeline_id'")
            __props__.__dict__["pipeline_id"] = pipeline_id
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["step_override_details"] = step_override_details
            __props__.__dict__["system_tags"] = system_tags
            __props__.__dict__["configuration_details"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["log_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["step_runs"] = None
            __props__.__dict__["time_accepted"] = None
            __props__.__dict__["time_finished"] = None
            __props__.__dict__["time_started"] = None
            __props__.__dict__["time_updated"] = None
        super(PipelineRun, __self__).__init__(
            'oci:DataScience/pipelineRun:PipelineRun',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            configuration_details: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineRunConfigurationDetailArgs']]]]] = None,
            configuration_override_details: Optional[pulumi.Input[pulumi.InputType['PipelineRunConfigurationOverrideDetailsArgs']]] = None,
            created_by: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            delete_related_job_runs: Optional[pulumi.Input[bool]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            log_configuration_override_details: Optional[pulumi.Input[pulumi.InputType['PipelineRunLogConfigurationOverrideDetailsArgs']]] = None,
            log_details: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineRunLogDetailArgs']]]]] = None,
            pipeline_id: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            step_override_details: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineRunStepOverrideDetailArgs']]]]] = None,
            step_runs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineRunStepRunArgs']]]]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_accepted: Optional[pulumi.Input[str]] = None,
            time_finished: Optional[pulumi.Input[str]] = None,
            time_started: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'PipelineRun':
        """
        Get an existing PipelineRun resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the pipeline run.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineRunConfigurationDetailArgs']]]] configuration_details: The configuration details of a pipeline.
        :param pulumi.Input[pulumi.InputType['PipelineRunConfigurationOverrideDetailsArgs']] configuration_override_details: The configuration details of a pipeline.
        :param pulumi.Input[str] created_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the pipeline run.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] lifecycle_details: Details of the state of the step run.
        :param pulumi.Input[pulumi.InputType['PipelineRunLogConfigurationOverrideDetailsArgs']] log_configuration_override_details: The pipeline log configuration details.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineRunLogDetailArgs']]]] log_details: Customer logging details for pipeline run.
        :param pulumi.Input[str] pipeline_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the pipeline for which pipeline run is created.
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the pipeline run with.
        :param pulumi.Input[str] state: The state of the step run.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineRunStepOverrideDetailArgs']]]] step_override_details: Array of step override details. Only Step Configuration is allowed to be overridden.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineRunStepRunArgs']]]] step_runs: Array of StepRun object for each step.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_accepted: The date and time the pipeline run was accepted in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] time_finished: The date and time the pipeline run request was finished in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] time_started: The date and time the pipeline run request was started in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] time_updated: The date and time the pipeline run was updated in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PipelineRunState.__new__(_PipelineRunState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["configuration_details"] = configuration_details
        __props__.__dict__["configuration_override_details"] = configuration_override_details
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["delete_related_job_runs"] = delete_related_job_runs
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["log_configuration_override_details"] = log_configuration_override_details
        __props__.__dict__["log_details"] = log_details
        __props__.__dict__["pipeline_id"] = pipeline_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["state"] = state
        __props__.__dict__["step_override_details"] = step_override_details
        __props__.__dict__["step_runs"] = step_runs
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_accepted"] = time_accepted
        __props__.__dict__["time_finished"] = time_finished
        __props__.__dict__["time_started"] = time_started
        __props__.__dict__["time_updated"] = time_updated
        return PipelineRun(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the pipeline run.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="configurationDetails")
    def configuration_details(self) -> pulumi.Output[Sequence['outputs.PipelineRunConfigurationDetail']]:
        """
        The configuration details of a pipeline.
        """
        return pulumi.get(self, "configuration_details")

    @property
    @pulumi.getter(name="configurationOverrideDetails")
    def configuration_override_details(self) -> pulumi.Output['outputs.PipelineRunConfigurationOverrideDetails']:
        """
        The configuration details of a pipeline.
        """
        return pulumi.get(self, "configuration_override_details")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the pipeline run.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="deleteRelatedJobRuns")
    def delete_related_job_runs(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "delete_related_job_runs")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly display name for the resource.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Details of the state of the step run.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="logConfigurationOverrideDetails")
    def log_configuration_override_details(self) -> pulumi.Output['outputs.PipelineRunLogConfigurationOverrideDetails']:
        """
        The pipeline log configuration details.
        """
        return pulumi.get(self, "log_configuration_override_details")

    @property
    @pulumi.getter(name="logDetails")
    def log_details(self) -> pulumi.Output[Sequence['outputs.PipelineRunLogDetail']]:
        """
        Customer logging details for pipeline run.
        """
        return pulumi.get(self, "log_details")

    @property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the pipeline for which pipeline run is created.
        """
        return pulumi.get(self, "pipeline_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the pipeline run with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state of the step run.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stepOverrideDetails")
    def step_override_details(self) -> pulumi.Output[Sequence['outputs.PipelineRunStepOverrideDetail']]:
        """
        Array of step override details. Only Step Configuration is allowed to be overridden.
        """
        return pulumi.get(self, "step_override_details")

    @property
    @pulumi.getter(name="stepRuns")
    def step_runs(self) -> pulumi.Output[Sequence['outputs.PipelineRunStepRun']]:
        """
        Array of StepRun object for each step.
        """
        return pulumi.get(self, "step_runs")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeAccepted")
    def time_accepted(self) -> pulumi.Output[str]:
        """
        The date and time the pipeline run was accepted in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_accepted")

    @property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> pulumi.Output[str]:
        """
        The date and time the pipeline run request was finished in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_finished")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> pulumi.Output[str]:
        """
        The date and time the pipeline run request was started in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_started")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The date and time the pipeline run was updated in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

