# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ConnectionAdditionalAttribute',
    'ConnectionBootstrapServer',
    'ConnectionIngressIp',
    'DeploymentDeploymentDiagnosticData',
    'DeploymentMaintenanceConfiguration',
    'DeploymentMaintenanceWindow',
    'DeploymentOggData',
    'GetConnectionAdditionalAttributeResult',
    'GetConnectionAssignmentsConnectionAssignmentCollectionResult',
    'GetConnectionAssignmentsConnectionAssignmentCollectionItemResult',
    'GetConnectionAssignmentsFilterResult',
    'GetConnectionBootstrapServerResult',
    'GetConnectionIngressIpResult',
    'GetConnectionsConnectionCollectionResult',
    'GetConnectionsConnectionCollectionItemResult',
    'GetConnectionsConnectionCollectionItemAdditionalAttributeResult',
    'GetConnectionsConnectionCollectionItemBootstrapServerResult',
    'GetConnectionsConnectionCollectionItemIngressIpResult',
    'GetConnectionsFilterResult',
    'GetDatabaseRegistrationsDatabaseRegistrationCollectionResult',
    'GetDatabaseRegistrationsDatabaseRegistrationCollectionItemResult',
    'GetDatabaseRegistrationsFilterResult',
    'GetDeploymentBackupsDeploymentBackupCollectionResult',
    'GetDeploymentBackupsDeploymentBackupCollectionItemResult',
    'GetDeploymentBackupsFilterResult',
    'GetDeploymentDeploymentDiagnosticDataResult',
    'GetDeploymentMaintenanceConfigurationResult',
    'GetDeploymentMaintenanceWindowResult',
    'GetDeploymentOggDataResult',
    'GetDeploymentTypeItemResult',
    'GetDeploymentTypesDeploymentTypeCollectionResult',
    'GetDeploymentTypesDeploymentTypeCollectionItemResult',
    'GetDeploymentTypesFilterResult',
    'GetDeploymentUpgradesDeploymentUpgradeCollectionResult',
    'GetDeploymentUpgradesDeploymentUpgradeCollectionItemResult',
    'GetDeploymentUpgradesFilterResult',
    'GetDeploymentVersionsDeploymentVersionCollectionResult',
    'GetDeploymentVersionsDeploymentVersionCollectionItemResult',
    'GetDeploymentVersionsFilterResult',
    'GetDeploymentsDeploymentCollectionResult',
    'GetDeploymentsDeploymentCollectionItemResult',
    'GetDeploymentsDeploymentCollectionItemDeploymentDiagnosticDataResult',
    'GetDeploymentsDeploymentCollectionItemMaintenanceConfigurationResult',
    'GetDeploymentsDeploymentCollectionItemMaintenanceWindowResult',
    'GetDeploymentsDeploymentCollectionItemOggDataResult',
    'GetDeploymentsFilterResult',
    'GetMessageItemResult',
    'GetMessagesDeploymentMessagesCollectionResult',
    'GetMessagesDeploymentMessagesCollectionItemResult',
    'GetMessagesFilterResult',
    'GetTrailFileItemResult',
    'GetTrailFilesFilterResult',
    'GetTrailFilesTrailFileCollectionResult',
    'GetTrailFilesTrailFileCollectionItemResult',
    'GetTrailSequenceItemResult',
    'GetTrailSequencesFilterResult',
    'GetTrailSequencesTrailSequenceCollectionResult',
    'GetTrailSequencesTrailSequenceCollectionItemResult',
]

@pulumi.output_type
class ConnectionAdditionalAttribute(dict):
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str name: (Updatable) The name of the property entry.
        :param str value: (Updatable) The value of the property entry.
        """
        ConnectionAdditionalAttribute._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             value: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if name is not None:
            _setter("name", name)
        if value is not None:
            _setter("value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        (Updatable) The name of the property entry.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        (Updatable) The value of the property entry.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ConnectionBootstrapServer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateIp":
            suggest = "private_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionBootstrapServer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionBootstrapServer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionBootstrapServer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host: Optional[str] = None,
                 port: Optional[int] = None,
                 private_ip: Optional[str] = None):
        """
        :param str host: (Updatable) The name or address of a host.
        :param int port: (Updatable) The port of an endpoint usually specified for a connection.
        :param str private_ip: (Updatable) The private IP address of the connection's endpoint in the customer's VCN, typically a database endpoint or a big data endpoint (e.g. Kafka bootstrap server). In case the privateIp is provided, the subnetId must also be provided. In case the privateIp (and the subnetId) is not provided it is assumed the datasource is publicly accessible. In case the connection is accessible only privately, the lack of privateIp will result in not being able to access the connection.
        """
        ConnectionBootstrapServer._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            host=host,
            port=port,
            private_ip=private_ip,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             host: Optional[str] = None,
             port: Optional[int] = None,
             private_ip: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'privateIp' in kwargs:
            private_ip = kwargs['privateIp']

        if host is not None:
            _setter("host", host)
        if port is not None:
            _setter("port", port)
        if private_ip is not None:
            _setter("private_ip", private_ip)

    @property
    @pulumi.getter
    def host(self) -> Optional[str]:
        """
        (Updatable) The name or address of a host.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        (Updatable) The port of an endpoint usually specified for a connection.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[str]:
        """
        (Updatable) The private IP address of the connection's endpoint in the customer's VCN, typically a database endpoint or a big data endpoint (e.g. Kafka bootstrap server). In case the privateIp is provided, the subnetId must also be provided. In case the privateIp (and the subnetId) is not provided it is assumed the datasource is publicly accessible. In case the connection is accessible only privately, the lack of privateIp will result in not being able to access the connection.
        """
        return pulumi.get(self, "private_ip")


@pulumi.output_type
class ConnectionIngressIp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ingressIp":
            suggest = "ingress_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionIngressIp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionIngressIp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionIngressIp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ingress_ip: Optional[str] = None):
        """
        :param str ingress_ip: A Private Endpoint IPv4 or IPv6 Address created in the customer's subnet.
        """
        ConnectionIngressIp._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ingress_ip=ingress_ip,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ingress_ip: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'ingressIp' in kwargs:
            ingress_ip = kwargs['ingressIp']

        if ingress_ip is not None:
            _setter("ingress_ip", ingress_ip)

    @property
    @pulumi.getter(name="ingressIp")
    def ingress_ip(self) -> Optional[str]:
        """
        A Private Endpoint IPv4 or IPv6 Address created in the customer's subnet.
        """
        return pulumi.get(self, "ingress_ip")


@pulumi.output_type
class DeploymentDeploymentDiagnosticData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diagnosticState":
            suggest = "diagnostic_state"
        elif key == "timeDiagnosticEnd":
            suggest = "time_diagnostic_end"
        elif key == "timeDiagnosticStart":
            suggest = "time_diagnostic_start"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentDeploymentDiagnosticData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentDeploymentDiagnosticData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentDeploymentDiagnosticData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: Optional[str] = None,
                 diagnostic_state: Optional[str] = None,
                 namespace: Optional[str] = None,
                 object: Optional[str] = None,
                 time_diagnostic_end: Optional[str] = None,
                 time_diagnostic_start: Optional[str] = None):
        """
        :param str bucket: Name of the bucket where the object is to be uploaded in the object storage
        :param str diagnostic_state: The state of the deployment diagnostic collection.
        :param str namespace: Name of namespace that serves as a container for all of your buckets
        :param str object: Name of the diagnostic collected and uploaded to object storage
        :param str time_diagnostic_end: The time until which the diagnostic collection should collect the logs. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param str time_diagnostic_start: The time from which the diagnostic collection should collect the logs. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        DeploymentDeploymentDiagnosticData._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            diagnostic_state=diagnostic_state,
            namespace=namespace,
            object=object,
            time_diagnostic_end=time_diagnostic_end,
            time_diagnostic_start=time_diagnostic_start,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: Optional[str] = None,
             diagnostic_state: Optional[str] = None,
             namespace: Optional[str] = None,
             object: Optional[str] = None,
             time_diagnostic_end: Optional[str] = None,
             time_diagnostic_start: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'diagnosticState' in kwargs:
            diagnostic_state = kwargs['diagnosticState']
        if 'timeDiagnosticEnd' in kwargs:
            time_diagnostic_end = kwargs['timeDiagnosticEnd']
        if 'timeDiagnosticStart' in kwargs:
            time_diagnostic_start = kwargs['timeDiagnosticStart']

        if bucket is not None:
            _setter("bucket", bucket)
        if diagnostic_state is not None:
            _setter("diagnostic_state", diagnostic_state)
        if namespace is not None:
            _setter("namespace", namespace)
        if object is not None:
            _setter("object", object)
        if time_diagnostic_end is not None:
            _setter("time_diagnostic_end", time_diagnostic_end)
        if time_diagnostic_start is not None:
            _setter("time_diagnostic_start", time_diagnostic_start)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[str]:
        """
        Name of the bucket where the object is to be uploaded in the object storage
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="diagnosticState")
    def diagnostic_state(self) -> Optional[str]:
        """
        The state of the deployment diagnostic collection.
        """
        return pulumi.get(self, "diagnostic_state")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        Name of namespace that serves as a container for all of your buckets
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> Optional[str]:
        """
        Name of the diagnostic collected and uploaded to object storage
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="timeDiagnosticEnd")
    def time_diagnostic_end(self) -> Optional[str]:
        """
        The time until which the diagnostic collection should collect the logs. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_diagnostic_end")

    @property
    @pulumi.getter(name="timeDiagnosticStart")
    def time_diagnostic_start(self) -> Optional[str]:
        """
        The time from which the diagnostic collection should collect the logs. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_diagnostic_start")


@pulumi.output_type
class DeploymentMaintenanceConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bundleReleaseUpgradePeriodInDays":
            suggest = "bundle_release_upgrade_period_in_days"
        elif key == "interimReleaseUpgradePeriodInDays":
            suggest = "interim_release_upgrade_period_in_days"
        elif key == "isInterimReleaseAutoUpgradeEnabled":
            suggest = "is_interim_release_auto_upgrade_enabled"
        elif key == "majorReleaseUpgradePeriodInDays":
            suggest = "major_release_upgrade_period_in_days"
        elif key == "securityPatchUpgradePeriodInDays":
            suggest = "security_patch_upgrade_period_in_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentMaintenanceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentMaintenanceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentMaintenanceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bundle_release_upgrade_period_in_days: Optional[int] = None,
                 interim_release_upgrade_period_in_days: Optional[int] = None,
                 is_interim_release_auto_upgrade_enabled: Optional[bool] = None,
                 major_release_upgrade_period_in_days: Optional[int] = None,
                 security_patch_upgrade_period_in_days: Optional[int] = None):
        """
        :param int bundle_release_upgrade_period_in_days: (Updatable) Defines auto upgrade period for bundle releases. Manually configured period cannot be longer than service defined period for bundle releases. This period must be shorter or equal to major release upgrade period. Not passing this field during create will equate to using the service default.
        :param int interim_release_upgrade_period_in_days: (Updatable) Defines auto upgrade period for interim releases. This period must be shorter or equal to bundle release upgrade period.
        :param bool is_interim_release_auto_upgrade_enabled: (Updatable) By default auto upgrade for interim releases are not enabled. If auto-upgrade is enabled for interim release,  you have to specify interimReleaseUpgradePeriodInDays too.
        :param int major_release_upgrade_period_in_days: (Updatable) Defines auto upgrade period for major releases. Manually configured period cannot be longer than service defined period for major releases. Not passing this field during create will equate to using the service default.
        :param int security_patch_upgrade_period_in_days: (Updatable) Defines auto upgrade period for releases with security fix. Manually configured period cannot be longer than service defined period for security releases. Not passing this field during create will equate to using the service default.
        """
        DeploymentMaintenanceConfiguration._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bundle_release_upgrade_period_in_days=bundle_release_upgrade_period_in_days,
            interim_release_upgrade_period_in_days=interim_release_upgrade_period_in_days,
            is_interim_release_auto_upgrade_enabled=is_interim_release_auto_upgrade_enabled,
            major_release_upgrade_period_in_days=major_release_upgrade_period_in_days,
            security_patch_upgrade_period_in_days=security_patch_upgrade_period_in_days,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bundle_release_upgrade_period_in_days: Optional[int] = None,
             interim_release_upgrade_period_in_days: Optional[int] = None,
             is_interim_release_auto_upgrade_enabled: Optional[bool] = None,
             major_release_upgrade_period_in_days: Optional[int] = None,
             security_patch_upgrade_period_in_days: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'bundleReleaseUpgradePeriodInDays' in kwargs:
            bundle_release_upgrade_period_in_days = kwargs['bundleReleaseUpgradePeriodInDays']
        if 'interimReleaseUpgradePeriodInDays' in kwargs:
            interim_release_upgrade_period_in_days = kwargs['interimReleaseUpgradePeriodInDays']
        if 'isInterimReleaseAutoUpgradeEnabled' in kwargs:
            is_interim_release_auto_upgrade_enabled = kwargs['isInterimReleaseAutoUpgradeEnabled']
        if 'majorReleaseUpgradePeriodInDays' in kwargs:
            major_release_upgrade_period_in_days = kwargs['majorReleaseUpgradePeriodInDays']
        if 'securityPatchUpgradePeriodInDays' in kwargs:
            security_patch_upgrade_period_in_days = kwargs['securityPatchUpgradePeriodInDays']

        if bundle_release_upgrade_period_in_days is not None:
            _setter("bundle_release_upgrade_period_in_days", bundle_release_upgrade_period_in_days)
        if interim_release_upgrade_period_in_days is not None:
            _setter("interim_release_upgrade_period_in_days", interim_release_upgrade_period_in_days)
        if is_interim_release_auto_upgrade_enabled is not None:
            _setter("is_interim_release_auto_upgrade_enabled", is_interim_release_auto_upgrade_enabled)
        if major_release_upgrade_period_in_days is not None:
            _setter("major_release_upgrade_period_in_days", major_release_upgrade_period_in_days)
        if security_patch_upgrade_period_in_days is not None:
            _setter("security_patch_upgrade_period_in_days", security_patch_upgrade_period_in_days)

    @property
    @pulumi.getter(name="bundleReleaseUpgradePeriodInDays")
    def bundle_release_upgrade_period_in_days(self) -> Optional[int]:
        """
        (Updatable) Defines auto upgrade period for bundle releases. Manually configured period cannot be longer than service defined period for bundle releases. This period must be shorter or equal to major release upgrade period. Not passing this field during create will equate to using the service default.
        """
        return pulumi.get(self, "bundle_release_upgrade_period_in_days")

    @property
    @pulumi.getter(name="interimReleaseUpgradePeriodInDays")
    def interim_release_upgrade_period_in_days(self) -> Optional[int]:
        """
        (Updatable) Defines auto upgrade period for interim releases. This period must be shorter or equal to bundle release upgrade period.
        """
        return pulumi.get(self, "interim_release_upgrade_period_in_days")

    @property
    @pulumi.getter(name="isInterimReleaseAutoUpgradeEnabled")
    def is_interim_release_auto_upgrade_enabled(self) -> Optional[bool]:
        """
        (Updatable) By default auto upgrade for interim releases are not enabled. If auto-upgrade is enabled for interim release,  you have to specify interimReleaseUpgradePeriodInDays too.
        """
        return pulumi.get(self, "is_interim_release_auto_upgrade_enabled")

    @property
    @pulumi.getter(name="majorReleaseUpgradePeriodInDays")
    def major_release_upgrade_period_in_days(self) -> Optional[int]:
        """
        (Updatable) Defines auto upgrade period for major releases. Manually configured period cannot be longer than service defined period for major releases. Not passing this field during create will equate to using the service default.
        """
        return pulumi.get(self, "major_release_upgrade_period_in_days")

    @property
    @pulumi.getter(name="securityPatchUpgradePeriodInDays")
    def security_patch_upgrade_period_in_days(self) -> Optional[int]:
        """
        (Updatable) Defines auto upgrade period for releases with security fix. Manually configured period cannot be longer than service defined period for security releases. Not passing this field during create will equate to using the service default.
        """
        return pulumi.get(self, "security_patch_upgrade_period_in_days")


@pulumi.output_type
class DeploymentMaintenanceWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startHour":
            suggest = "start_hour"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentMaintenanceWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentMaintenanceWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentMaintenanceWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day: str,
                 start_hour: int):
        """
        :param str day: (Updatable) Days of the week.
        :param int start_hour: (Updatable) Start hour for maintenance period. Hour is in UTC.
        """
        DeploymentMaintenanceWindow._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            day=day,
            start_hour=start_hour,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             day: str,
             start_hour: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'startHour' in kwargs:
            start_hour = kwargs['startHour']

        _setter("day", day)
        _setter("start_hour", start_hour)

    @property
    @pulumi.getter
    def day(self) -> str:
        """
        (Updatable) Days of the week.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter(name="startHour")
    def start_hour(self) -> int:
        """
        (Updatable) Start hour for maintenance period. Hour is in UTC.
        """
        return pulumi.get(self, "start_hour")


@pulumi.output_type
class DeploymentOggData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deploymentName":
            suggest = "deployment_name"
        elif key == "adminPassword":
            suggest = "admin_password"
        elif key == "adminUsername":
            suggest = "admin_username"
        elif key == "credentialStore":
            suggest = "credential_store"
        elif key == "identityDomainId":
            suggest = "identity_domain_id"
        elif key == "oggVersion":
            suggest = "ogg_version"
        elif key == "passwordSecretId":
            suggest = "password_secret_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentOggData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentOggData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentOggData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deployment_name: str,
                 admin_password: Optional[str] = None,
                 admin_username: Optional[str] = None,
                 certificate: Optional[str] = None,
                 credential_store: Optional[str] = None,
                 identity_domain_id: Optional[str] = None,
                 key: Optional[str] = None,
                 ogg_version: Optional[str] = None,
                 password_secret_id: Optional[str] = None):
        """
        :param str deployment_name: The name given to the GoldenGate service deployment. The name must be 1 to 32 characters long, must contain only alphanumeric characters and must start with a letter.
        :param str admin_password: (Updatable) The password associated with the GoldenGate deployment console username. The password must be 8 to 30 characters long and must contain at least 1 uppercase, 1 lowercase, 1 numeric, and 1 special character. Special characters such as ‘$’, ‘^’, or ‘?’ are not allowed. This field will be deprecated and replaced by "passwordSecretId".
        :param str admin_username: (Updatable) The GoldenGate deployment console username.
        :param str certificate: (Updatable) A PEM-encoded SSL certificate.
        :param str credential_store: (Updatable) The type of credential store for OGG.
        :param str identity_domain_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Identity Domain when IAM credential store is used.
        :param str key: (Updatable) A PEM-encoded private key.
        :param str ogg_version: (Updatable) Version of ogg to use by deployment. By updating version you can upgrade your deployment to a newer version. Downgrade to older version is not supported.
        :param str password_secret_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Secret where the deployment password is stored.
        """
        DeploymentOggData._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            deployment_name=deployment_name,
            admin_password=admin_password,
            admin_username=admin_username,
            certificate=certificate,
            credential_store=credential_store,
            identity_domain_id=identity_domain_id,
            key=key,
            ogg_version=ogg_version,
            password_secret_id=password_secret_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             deployment_name: str,
             admin_password: Optional[str] = None,
             admin_username: Optional[str] = None,
             certificate: Optional[str] = None,
             credential_store: Optional[str] = None,
             identity_domain_id: Optional[str] = None,
             key: Optional[str] = None,
             ogg_version: Optional[str] = None,
             password_secret_id: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'deploymentName' in kwargs:
            deployment_name = kwargs['deploymentName']
        if 'adminPassword' in kwargs:
            admin_password = kwargs['adminPassword']
        if 'adminUsername' in kwargs:
            admin_username = kwargs['adminUsername']
        if 'credentialStore' in kwargs:
            credential_store = kwargs['credentialStore']
        if 'identityDomainId' in kwargs:
            identity_domain_id = kwargs['identityDomainId']
        if 'oggVersion' in kwargs:
            ogg_version = kwargs['oggVersion']
        if 'passwordSecretId' in kwargs:
            password_secret_id = kwargs['passwordSecretId']

        _setter("deployment_name", deployment_name)
        if admin_password is not None:
            _setter("admin_password", admin_password)
        if admin_username is not None:
            _setter("admin_username", admin_username)
        if certificate is not None:
            _setter("certificate", certificate)
        if credential_store is not None:
            _setter("credential_store", credential_store)
        if identity_domain_id is not None:
            _setter("identity_domain_id", identity_domain_id)
        if key is not None:
            _setter("key", key)
        if ogg_version is not None:
            _setter("ogg_version", ogg_version)
        if password_secret_id is not None:
            _setter("password_secret_id", password_secret_id)

    @property
    @pulumi.getter(name="deploymentName")
    def deployment_name(self) -> str:
        """
        The name given to the GoldenGate service deployment. The name must be 1 to 32 characters long, must contain only alphanumeric characters and must start with a letter.
        """
        return pulumi.get(self, "deployment_name")

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[str]:
        """
        (Updatable) The password associated with the GoldenGate deployment console username. The password must be 8 to 30 characters long and must contain at least 1 uppercase, 1 lowercase, 1 numeric, and 1 special character. Special characters such as ‘$’, ‘^’, or ‘?’ are not allowed. This field will be deprecated and replaced by "passwordSecretId".
        """
        return pulumi.get(self, "admin_password")

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[str]:
        """
        (Updatable) The GoldenGate deployment console username.
        """
        return pulumi.get(self, "admin_username")

    @property
    @pulumi.getter
    def certificate(self) -> Optional[str]:
        """
        (Updatable) A PEM-encoded SSL certificate.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="credentialStore")
    def credential_store(self) -> Optional[str]:
        """
        (Updatable) The type of credential store for OGG.
        """
        return pulumi.get(self, "credential_store")

    @property
    @pulumi.getter(name="identityDomainId")
    def identity_domain_id(self) -> Optional[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Identity Domain when IAM credential store is used.
        """
        return pulumi.get(self, "identity_domain_id")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        (Updatable) A PEM-encoded private key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="oggVersion")
    def ogg_version(self) -> Optional[str]:
        """
        (Updatable) Version of ogg to use by deployment. By updating version you can upgrade your deployment to a newer version. Downgrade to older version is not supported.
        """
        return pulumi.get(self, "ogg_version")

    @property
    @pulumi.getter(name="passwordSecretId")
    def password_secret_id(self) -> Optional[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Secret where the deployment password is stored.
        """
        return pulumi.get(self, "password_secret_id")


@pulumi.output_type
class GetConnectionAdditionalAttributeResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: The name of the property entry.
        :param str value: The value of the property entry.
        """
        GetConnectionAdditionalAttributeResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             value: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the property entry.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the property entry.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetConnectionAssignmentsConnectionAssignmentCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetConnectionAssignmentsConnectionAssignmentCollectionItemResult']):
        GetConnectionAssignmentsConnectionAssignmentCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetConnectionAssignmentsConnectionAssignmentCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetConnectionAssignmentsConnectionAssignmentCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetConnectionAssignmentsConnectionAssignmentCollectionItemResult(dict):
    def __init__(__self__, *,
                 alias_name: str,
                 compartment_id: str,
                 connection_id: str,
                 deployment_id: str,
                 id: str,
                 state: str,
                 time_created: str,
                 time_updated: str):
        """
        :param str alias_name: Credential store alias.
        :param str compartment_id: The OCID of the compartment that contains the work request. Work requests should be scoped  to the same compartment as the resource the work request affects. If the work request concerns  multiple resources, and those resources are not in the same compartment, it is up to the service team  to pick the primary resource whose compartment should be used.
        :param str connection_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the connection.
        :param str deployment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deployment in which to list resources.
        :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the connection assignment being referenced.
        :param str state: A filter to return only connection assignments having the 'lifecycleState' given.
        :param str time_created: The time the resource was created. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param str time_updated: The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        GetConnectionAssignmentsConnectionAssignmentCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            alias_name=alias_name,
            compartment_id=compartment_id,
            connection_id=connection_id,
            deployment_id=deployment_id,
            id=id,
            state=state,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             alias_name: str,
             compartment_id: str,
             connection_id: str,
             deployment_id: str,
             id: str,
             state: str,
             time_created: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'aliasName' in kwargs:
            alias_name = kwargs['aliasName']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'connectionId' in kwargs:
            connection_id = kwargs['connectionId']
        if 'deploymentId' in kwargs:
            deployment_id = kwargs['deploymentId']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        _setter("alias_name", alias_name)
        _setter("compartment_id", compartment_id)
        _setter("connection_id", connection_id)
        _setter("deployment_id", deployment_id)
        _setter("id", id)
        _setter("state", state)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="aliasName")
    def alias_name(self) -> str:
        """
        Credential store alias.
        """
        return pulumi.get(self, "alias_name")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the work request. Work requests should be scoped  to the same compartment as the resource the work request affects. If the work request concerns  multiple resources, and those resources are not in the same compartment, it is up to the service team  to pick the primary resource whose compartment should be used.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the connection.
        """
        return pulumi.get(self, "connection_id")

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deployment in which to list resources.
        """
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the connection assignment being referenced.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only connection assignments having the 'lifecycleState' given.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the resource was created. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetConnectionAssignmentsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name of the connection in the assignment (aliasName).
        """
        GetConnectionAssignmentsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the connection in the assignment (aliasName).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetConnectionBootstrapServerResult(dict):
    def __init__(__self__, *,
                 host: str,
                 port: int,
                 private_ip: str):
        """
        :param str host: The name or address of a host.
        :param int port: The port of an endpoint usually specified for a connection.
        :param str private_ip: The private IP address of the connection's endpoint in the customer's VCN, typically a database endpoint or a big data endpoint (e.g. Kafka bootstrap server). In case the privateIp is provided, the subnetId must also be provided. In case the privateIp (and the subnetId) is not provided it is assumed the datasource is publicly accessible. In case the connection is accessible only privately, the lack of privateIp will result in not being able to access the connection.
        """
        GetConnectionBootstrapServerResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            host=host,
            port=port,
            private_ip=private_ip,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             host: str,
             port: int,
             private_ip: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'privateIp' in kwargs:
            private_ip = kwargs['privateIp']

        _setter("host", host)
        _setter("port", port)
        _setter("private_ip", private_ip)

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        The name or address of a host.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port of an endpoint usually specified for a connection.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> str:
        """
        The private IP address of the connection's endpoint in the customer's VCN, typically a database endpoint or a big data endpoint (e.g. Kafka bootstrap server). In case the privateIp is provided, the subnetId must also be provided. In case the privateIp (and the subnetId) is not provided it is assumed the datasource is publicly accessible. In case the connection is accessible only privately, the lack of privateIp will result in not being able to access the connection.
        """
        return pulumi.get(self, "private_ip")


@pulumi.output_type
class GetConnectionIngressIpResult(dict):
    def __init__(__self__, *,
                 ingress_ip: str):
        """
        :param str ingress_ip: A Private Endpoint IPv4 or IPv6 Address created in the customer's subnet.
        """
        GetConnectionIngressIpResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ingress_ip=ingress_ip,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ingress_ip: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'ingressIp' in kwargs:
            ingress_ip = kwargs['ingressIp']

        _setter("ingress_ip", ingress_ip)

    @property
    @pulumi.getter(name="ingressIp")
    def ingress_ip(self) -> str:
        """
        A Private Endpoint IPv4 or IPv6 Address created in the customer's subnet.
        """
        return pulumi.get(self, "ingress_ip")


@pulumi.output_type
class GetConnectionsConnectionCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetConnectionsConnectionCollectionItemResult']):
        GetConnectionsConnectionCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetConnectionsConnectionCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetConnectionsConnectionCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetConnectionsConnectionCollectionItemResult(dict):
    def __init__(__self__, *,
                 access_key_id: str,
                 account_key: str,
                 account_name: str,
                 additional_attributes: Sequence['outputs.GetConnectionsConnectionCollectionItemAdditionalAttributeResult'],
                 authentication_type: str,
                 azure_tenant_id: str,
                 bootstrap_servers: Sequence['outputs.GetConnectionsConnectionCollectionItemBootstrapServerResult'],
                 client_id: str,
                 client_secret: str,
                 compartment_id: str,
                 connection_factory: str,
                 connection_string: str,
                 connection_type: str,
                 connection_url: str,
                 consumer_properties: str,
                 core_site_xml: str,
                 database_id: str,
                 database_name: str,
                 db_system_id: str,
                 defined_tags: Mapping[str, Any],
                 deployment_id: str,
                 description: str,
                 display_name: str,
                 endpoint: str,
                 freeform_tags: Mapping[str, Any],
                 host: str,
                 id: str,
                 ingress_ips: Sequence['outputs.GetConnectionsConnectionCollectionItemIngressIpResult'],
                 jndi_connection_factory: str,
                 jndi_initial_context_factory: str,
                 jndi_provider_url: str,
                 jndi_security_credentials: str,
                 jndi_security_principal: str,
                 key_id: str,
                 key_store: str,
                 key_store_password: str,
                 lifecycle_details: str,
                 nsg_ids: Sequence[str],
                 password: str,
                 port: int,
                 private_ip: str,
                 private_key_file: str,
                 private_key_passphrase: str,
                 producer_properties: str,
                 public_key_fingerprint: str,
                 region: str,
                 sas_token: str,
                 secret_access_key: str,
                 security_protocol: str,
                 session_mode: str,
                 should_use_jndi: bool,
                 should_validate_server_certificate: bool,
                 ssl_ca: str,
                 ssl_cert: str,
                 ssl_crl: str,
                 ssl_key: str,
                 ssl_key_password: str,
                 ssl_mode: str,
                 state: str,
                 stream_pool_id: str,
                 subnet_id: str,
                 system_tags: Mapping[str, Any],
                 technology_type: str,
                 tenancy_id: str,
                 time_created: str,
                 time_updated: str,
                 trust_store: str,
                 trust_store_password: str,
                 url: str,
                 user_id: str,
                 username: str,
                 vault_id: str,
                 wallet: str):
        """
        :param str access_key_id: Access key ID to access the Amazon S3 bucket. e.g.: "this-is-not-the-secret"
        :param str account_name: Sets the Azure storage account name.
        :param Sequence['GetConnectionsConnectionCollectionItemAdditionalAttributeArgs'] additional_attributes: An array of name-value pair attribute entries. Used as additional parameters in connection string.
        :param str authentication_type: Used authentication mechanism to access Azure Data Lake Storage.
        :param str azure_tenant_id: Azure tenant ID of the application. This property is required when 'authenticationType' is set to 'AZURE_ACTIVE_DIRECTORY'. e.g.: 14593954-d337-4a61-a364-9f758c64f97f
        :param Sequence['GetConnectionsConnectionCollectionItemBootstrapServerArgs'] bootstrap_servers: Kafka bootstrap. Equivalent of bootstrap.servers configuration property in Kafka: list of KafkaBootstrapServer objects specified by host/port. Used for establishing the initial connection to the Kafka cluster. Example: `"server1.example.com:9092,server2.example.com:9092"`
        :param str client_id: Azure client ID of the application. This property is required when 'authenticationType' is set to 'AZURE_ACTIVE_DIRECTORY'. e.g.: 06ecaabf-8b80-4ec8-a0ec-20cbf463703d
        :param str compartment_id: The OCID of the compartment that contains the work request. Work requests should be scoped  to the same compartment as the resource the work request affects. If the work request concerns  multiple resources, and those resources are not in the same compartment, it is up to the service team  to pick the primary resource whose compartment should be used.
        :param str connection_factory: The of Java class implementing javax.jms.ConnectionFactory interface supplied by the Java Message Service provider. e.g.: 'com.stc.jmsjca.core.JConnectionFactoryXA'
        :param str connection_string: JDBC connection string. e.g.: 'jdbc:sqlserver://<synapse-workspace>.sql.azuresynapse.net:1433;database=<db-name>;encrypt=true;trustServerCertificate=false;hostNameInCertificate=*.sql.azuresynapse.net;loginTimeout=300;'
        :param str connection_type: The array of connection types.
        :param str connection_url: JDBC connection URL. e.g.: 'jdbc:snowflake://<account_name>.snowflakecomputing.com/?warehouse=<warehouse-name>&db=<db-name>'
        :param str database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Autonomous Json Database.
        :param str database_name: The name of the database.
        :param str db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database system being referenced.
        :param Mapping[str, Any] defined_tags: Tags defined for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace.bar-key": "value"}`
        :param str deployment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deployment being referenced.
        :param str description: Metadata about this specific object.
        :param str display_name: A filter to return only the resources that match the entire 'displayName' given.
        :param str endpoint: Azure Storage service endpoint. e.g: https://test.blob.core.windows.net
        :param Mapping[str, Any] freeform_tags: A simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        :param str host: The name or address of a host.
        :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the connection being referenced.
        :param Sequence['GetConnectionsConnectionCollectionItemIngressIpArgs'] ingress_ips: List of ingress IP addresses from where the GoldenGate deployment connects to this connection's privateIp.  Customers may optionally set up ingress security rules to restrict traffic from these IP addresses.
        :param str jndi_connection_factory: The Connection Factory can be looked up using this name. e.g.: 'ConnectionFactory'
        :param str jndi_initial_context_factory: The implementation of javax.naming.spi.InitialContextFactory interface that the client uses to obtain initial naming context. e.g.: 'org.apache.activemq.jndi.ActiveMQInitialContextFactory'
        :param str jndi_provider_url: The URL that Java Message Service will use to contact the JNDI provider. e.g.: 'tcp://myjms.host.domain:61616?jms.prefetchPolicy.all=1000'
        :param str jndi_security_principal: Specifies the identity of the principal (user) to be authenticated. e.g.: 'admin2'
        :param str key_id: Refers to the customer's master key OCID.  If provided, it references a key to manage secrets. Customers must add policies to permit GoldenGate to use this key.
        :param str lifecycle_details: Describes the object's current state in detail. For example, it can be used to provide actionable information for a resource in a Failed state.
        :param Sequence[str] nsg_ids: An array of Network Security Group OCIDs used to define network access for either Deployments or Connections.
        :param int port: The port of an endpoint usually specified for a connection.
        :param str private_ip: The private IP address of the connection's endpoint in the customer's VCN, typically a database endpoint or a big data endpoint (e.g. Kafka bootstrap server). In case the privateIp is provided, the subnetId must also be provided. In case the privateIp (and the subnetId) is not provided it is assumed the datasource is publicly accessible. In case the connection is accessible only privately, the lack of privateIp will result in not being able to access the connection.
        :param str region: The name of the region. e.g.: us-ashburn-1
        :param str security_protocol: Security protocol for PostgreSQL / Microsoft SQL Server..
        :param str session_mode: The mode of the database connection session to be established by the data client. 'REDIRECT' - for a RAC database, 'DIRECT' - for a non-RAC database. Connection to a RAC database involves a redirection received from the SCAN listeners to the database node to connect to. By default the mode would be DIRECT.
        :param bool should_use_jndi: If set to true, Java Naming and Directory Interface (JNDI) properties should be provided.
        :param bool should_validate_server_certificate: If set to true, the driver validates the certificate that is sent by the database server.
        :param str ssl_ca: Database Certificate - The base64 encoded content of pem file containing the server public key (for 1-way SSL).
        :param str ssl_mode: SSL mode for PostgreSQL.
        :param str state: A filter to return only connections having the 'lifecycleState' given.
        :param str stream_pool_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the stream pool being referenced.
        :param str subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet being referenced.
        :param Mapping[str, Any] system_tags: The system tags associated with this resource, if any. The system tags are set by Oracle Cloud Infrastructure services. Each key is predefined and scoped to namespaces.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{orcl-cloud: {free-tier-retain: true}}`
        :param str technology_type: The array of technology types.
        :param str tenancy_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the related Oracle Cloud Infrastructure tenancy.
        :param str time_created: The time the resource was created. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param str time_updated: The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param str url: Kafka Schema Registry URL. e.g.: 'https://server1.us.oracle.com:8081'
        :param str user_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure user who will access the Oracle NoSQL database/Object Storage. The user must have write access to the table they want to connect to.
        :param str username: The username Oracle GoldenGate uses to connect the associated system of the given technology. This username must already exist and be available by the system/application to be connected to and must conform to the case sensitivity requirements defined in it.
        :param str vault_id: Refers to the customer's vault OCID.  If provided, it references a vault where GoldenGate can manage secrets. Customers must add policies to permit GoldenGate to manage secrets contained within this vault.
        """
        GetConnectionsConnectionCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            access_key_id=access_key_id,
            account_key=account_key,
            account_name=account_name,
            additional_attributes=additional_attributes,
            authentication_type=authentication_type,
            azure_tenant_id=azure_tenant_id,
            bootstrap_servers=bootstrap_servers,
            client_id=client_id,
            client_secret=client_secret,
            compartment_id=compartment_id,
            connection_factory=connection_factory,
            connection_string=connection_string,
            connection_type=connection_type,
            connection_url=connection_url,
            consumer_properties=consumer_properties,
            core_site_xml=core_site_xml,
            database_id=database_id,
            database_name=database_name,
            db_system_id=db_system_id,
            defined_tags=defined_tags,
            deployment_id=deployment_id,
            description=description,
            display_name=display_name,
            endpoint=endpoint,
            freeform_tags=freeform_tags,
            host=host,
            id=id,
            ingress_ips=ingress_ips,
            jndi_connection_factory=jndi_connection_factory,
            jndi_initial_context_factory=jndi_initial_context_factory,
            jndi_provider_url=jndi_provider_url,
            jndi_security_credentials=jndi_security_credentials,
            jndi_security_principal=jndi_security_principal,
            key_id=key_id,
            key_store=key_store,
            key_store_password=key_store_password,
            lifecycle_details=lifecycle_details,
            nsg_ids=nsg_ids,
            password=password,
            port=port,
            private_ip=private_ip,
            private_key_file=private_key_file,
            private_key_passphrase=private_key_passphrase,
            producer_properties=producer_properties,
            public_key_fingerprint=public_key_fingerprint,
            region=region,
            sas_token=sas_token,
            secret_access_key=secret_access_key,
            security_protocol=security_protocol,
            session_mode=session_mode,
            should_use_jndi=should_use_jndi,
            should_validate_server_certificate=should_validate_server_certificate,
            ssl_ca=ssl_ca,
            ssl_cert=ssl_cert,
            ssl_crl=ssl_crl,
            ssl_key=ssl_key,
            ssl_key_password=ssl_key_password,
            ssl_mode=ssl_mode,
            state=state,
            stream_pool_id=stream_pool_id,
            subnet_id=subnet_id,
            system_tags=system_tags,
            technology_type=technology_type,
            tenancy_id=tenancy_id,
            time_created=time_created,
            time_updated=time_updated,
            trust_store=trust_store,
            trust_store_password=trust_store_password,
            url=url,
            user_id=user_id,
            username=username,
            vault_id=vault_id,
            wallet=wallet,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             access_key_id: str,
             account_key: str,
             account_name: str,
             additional_attributes: Sequence['outputs.GetConnectionsConnectionCollectionItemAdditionalAttributeResult'],
             authentication_type: str,
             azure_tenant_id: str,
             bootstrap_servers: Sequence['outputs.GetConnectionsConnectionCollectionItemBootstrapServerResult'],
             client_id: str,
             client_secret: str,
             compartment_id: str,
             connection_factory: str,
             connection_string: str,
             connection_type: str,
             connection_url: str,
             consumer_properties: str,
             core_site_xml: str,
             database_id: str,
             database_name: str,
             db_system_id: str,
             defined_tags: Mapping[str, Any],
             deployment_id: str,
             description: str,
             display_name: str,
             endpoint: str,
             freeform_tags: Mapping[str, Any],
             host: str,
             id: str,
             ingress_ips: Sequence['outputs.GetConnectionsConnectionCollectionItemIngressIpResult'],
             jndi_connection_factory: str,
             jndi_initial_context_factory: str,
             jndi_provider_url: str,
             jndi_security_credentials: str,
             jndi_security_principal: str,
             key_id: str,
             key_store: str,
             key_store_password: str,
             lifecycle_details: str,
             nsg_ids: Sequence[str],
             password: str,
             port: int,
             private_ip: str,
             private_key_file: str,
             private_key_passphrase: str,
             producer_properties: str,
             public_key_fingerprint: str,
             region: str,
             sas_token: str,
             secret_access_key: str,
             security_protocol: str,
             session_mode: str,
             should_use_jndi: bool,
             should_validate_server_certificate: bool,
             ssl_ca: str,
             ssl_cert: str,
             ssl_crl: str,
             ssl_key: str,
             ssl_key_password: str,
             ssl_mode: str,
             state: str,
             stream_pool_id: str,
             subnet_id: str,
             system_tags: Mapping[str, Any],
             technology_type: str,
             tenancy_id: str,
             time_created: str,
             time_updated: str,
             trust_store: str,
             trust_store_password: str,
             url: str,
             user_id: str,
             username: str,
             vault_id: str,
             wallet: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'accessKeyId' in kwargs:
            access_key_id = kwargs['accessKeyId']
        if 'accountKey' in kwargs:
            account_key = kwargs['accountKey']
        if 'accountName' in kwargs:
            account_name = kwargs['accountName']
        if 'additionalAttributes' in kwargs:
            additional_attributes = kwargs['additionalAttributes']
        if 'authenticationType' in kwargs:
            authentication_type = kwargs['authenticationType']
        if 'azureTenantId' in kwargs:
            azure_tenant_id = kwargs['azureTenantId']
        if 'bootstrapServers' in kwargs:
            bootstrap_servers = kwargs['bootstrapServers']
        if 'clientId' in kwargs:
            client_id = kwargs['clientId']
        if 'clientSecret' in kwargs:
            client_secret = kwargs['clientSecret']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'connectionFactory' in kwargs:
            connection_factory = kwargs['connectionFactory']
        if 'connectionString' in kwargs:
            connection_string = kwargs['connectionString']
        if 'connectionType' in kwargs:
            connection_type = kwargs['connectionType']
        if 'connectionUrl' in kwargs:
            connection_url = kwargs['connectionUrl']
        if 'consumerProperties' in kwargs:
            consumer_properties = kwargs['consumerProperties']
        if 'coreSiteXml' in kwargs:
            core_site_xml = kwargs['coreSiteXml']
        if 'databaseId' in kwargs:
            database_id = kwargs['databaseId']
        if 'databaseName' in kwargs:
            database_name = kwargs['databaseName']
        if 'dbSystemId' in kwargs:
            db_system_id = kwargs['dbSystemId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'deploymentId' in kwargs:
            deployment_id = kwargs['deploymentId']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'ingressIps' in kwargs:
            ingress_ips = kwargs['ingressIps']
        if 'jndiConnectionFactory' in kwargs:
            jndi_connection_factory = kwargs['jndiConnectionFactory']
        if 'jndiInitialContextFactory' in kwargs:
            jndi_initial_context_factory = kwargs['jndiInitialContextFactory']
        if 'jndiProviderUrl' in kwargs:
            jndi_provider_url = kwargs['jndiProviderUrl']
        if 'jndiSecurityCredentials' in kwargs:
            jndi_security_credentials = kwargs['jndiSecurityCredentials']
        if 'jndiSecurityPrincipal' in kwargs:
            jndi_security_principal = kwargs['jndiSecurityPrincipal']
        if 'keyId' in kwargs:
            key_id = kwargs['keyId']
        if 'keyStore' in kwargs:
            key_store = kwargs['keyStore']
        if 'keyStorePassword' in kwargs:
            key_store_password = kwargs['keyStorePassword']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'nsgIds' in kwargs:
            nsg_ids = kwargs['nsgIds']
        if 'privateIp' in kwargs:
            private_ip = kwargs['privateIp']
        if 'privateKeyFile' in kwargs:
            private_key_file = kwargs['privateKeyFile']
        if 'privateKeyPassphrase' in kwargs:
            private_key_passphrase = kwargs['privateKeyPassphrase']
        if 'producerProperties' in kwargs:
            producer_properties = kwargs['producerProperties']
        if 'publicKeyFingerprint' in kwargs:
            public_key_fingerprint = kwargs['publicKeyFingerprint']
        if 'sasToken' in kwargs:
            sas_token = kwargs['sasToken']
        if 'secretAccessKey' in kwargs:
            secret_access_key = kwargs['secretAccessKey']
        if 'securityProtocol' in kwargs:
            security_protocol = kwargs['securityProtocol']
        if 'sessionMode' in kwargs:
            session_mode = kwargs['sessionMode']
        if 'shouldUseJndi' in kwargs:
            should_use_jndi = kwargs['shouldUseJndi']
        if 'shouldValidateServerCertificate' in kwargs:
            should_validate_server_certificate = kwargs['shouldValidateServerCertificate']
        if 'sslCa' in kwargs:
            ssl_ca = kwargs['sslCa']
        if 'sslCert' in kwargs:
            ssl_cert = kwargs['sslCert']
        if 'sslCrl' in kwargs:
            ssl_crl = kwargs['sslCrl']
        if 'sslKey' in kwargs:
            ssl_key = kwargs['sslKey']
        if 'sslKeyPassword' in kwargs:
            ssl_key_password = kwargs['sslKeyPassword']
        if 'sslMode' in kwargs:
            ssl_mode = kwargs['sslMode']
        if 'streamPoolId' in kwargs:
            stream_pool_id = kwargs['streamPoolId']
        if 'subnetId' in kwargs:
            subnet_id = kwargs['subnetId']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']
        if 'technologyType' in kwargs:
            technology_type = kwargs['technologyType']
        if 'tenancyId' in kwargs:
            tenancy_id = kwargs['tenancyId']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']
        if 'trustStore' in kwargs:
            trust_store = kwargs['trustStore']
        if 'trustStorePassword' in kwargs:
            trust_store_password = kwargs['trustStorePassword']
        if 'userId' in kwargs:
            user_id = kwargs['userId']
        if 'vaultId' in kwargs:
            vault_id = kwargs['vaultId']

        _setter("access_key_id", access_key_id)
        _setter("account_key", account_key)
        _setter("account_name", account_name)
        _setter("additional_attributes", additional_attributes)
        _setter("authentication_type", authentication_type)
        _setter("azure_tenant_id", azure_tenant_id)
        _setter("bootstrap_servers", bootstrap_servers)
        _setter("client_id", client_id)
        _setter("client_secret", client_secret)
        _setter("compartment_id", compartment_id)
        _setter("connection_factory", connection_factory)
        _setter("connection_string", connection_string)
        _setter("connection_type", connection_type)
        _setter("connection_url", connection_url)
        _setter("consumer_properties", consumer_properties)
        _setter("core_site_xml", core_site_xml)
        _setter("database_id", database_id)
        _setter("database_name", database_name)
        _setter("db_system_id", db_system_id)
        _setter("defined_tags", defined_tags)
        _setter("deployment_id", deployment_id)
        _setter("description", description)
        _setter("display_name", display_name)
        _setter("endpoint", endpoint)
        _setter("freeform_tags", freeform_tags)
        _setter("host", host)
        _setter("id", id)
        _setter("ingress_ips", ingress_ips)
        _setter("jndi_connection_factory", jndi_connection_factory)
        _setter("jndi_initial_context_factory", jndi_initial_context_factory)
        _setter("jndi_provider_url", jndi_provider_url)
        _setter("jndi_security_credentials", jndi_security_credentials)
        _setter("jndi_security_principal", jndi_security_principal)
        _setter("key_id", key_id)
        _setter("key_store", key_store)
        _setter("key_store_password", key_store_password)
        _setter("lifecycle_details", lifecycle_details)
        _setter("nsg_ids", nsg_ids)
        _setter("password", password)
        _setter("port", port)
        _setter("private_ip", private_ip)
        _setter("private_key_file", private_key_file)
        _setter("private_key_passphrase", private_key_passphrase)
        _setter("producer_properties", producer_properties)
        _setter("public_key_fingerprint", public_key_fingerprint)
        _setter("region", region)
        _setter("sas_token", sas_token)
        _setter("secret_access_key", secret_access_key)
        _setter("security_protocol", security_protocol)
        _setter("session_mode", session_mode)
        _setter("should_use_jndi", should_use_jndi)
        _setter("should_validate_server_certificate", should_validate_server_certificate)
        _setter("ssl_ca", ssl_ca)
        _setter("ssl_cert", ssl_cert)
        _setter("ssl_crl", ssl_crl)
        _setter("ssl_key", ssl_key)
        _setter("ssl_key_password", ssl_key_password)
        _setter("ssl_mode", ssl_mode)
        _setter("state", state)
        _setter("stream_pool_id", stream_pool_id)
        _setter("subnet_id", subnet_id)
        _setter("system_tags", system_tags)
        _setter("technology_type", technology_type)
        _setter("tenancy_id", tenancy_id)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)
        _setter("trust_store", trust_store)
        _setter("trust_store_password", trust_store_password)
        _setter("url", url)
        _setter("user_id", user_id)
        _setter("username", username)
        _setter("vault_id", vault_id)
        _setter("wallet", wallet)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> str:
        """
        Access key ID to access the Amazon S3 bucket. e.g.: "this-is-not-the-secret"
        """
        return pulumi.get(self, "access_key_id")

    @property
    @pulumi.getter(name="accountKey")
    def account_key(self) -> str:
        return pulumi.get(self, "account_key")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> str:
        """
        Sets the Azure storage account name.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="additionalAttributes")
    def additional_attributes(self) -> Sequence['outputs.GetConnectionsConnectionCollectionItemAdditionalAttributeResult']:
        """
        An array of name-value pair attribute entries. Used as additional parameters in connection string.
        """
        return pulumi.get(self, "additional_attributes")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> str:
        """
        Used authentication mechanism to access Azure Data Lake Storage.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="azureTenantId")
    def azure_tenant_id(self) -> str:
        """
        Azure tenant ID of the application. This property is required when 'authenticationType' is set to 'AZURE_ACTIVE_DIRECTORY'. e.g.: 14593954-d337-4a61-a364-9f758c64f97f
        """
        return pulumi.get(self, "azure_tenant_id")

    @property
    @pulumi.getter(name="bootstrapServers")
    def bootstrap_servers(self) -> Sequence['outputs.GetConnectionsConnectionCollectionItemBootstrapServerResult']:
        """
        Kafka bootstrap. Equivalent of bootstrap.servers configuration property in Kafka: list of KafkaBootstrapServer objects specified by host/port. Used for establishing the initial connection to the Kafka cluster. Example: `"server1.example.com:9092,server2.example.com:9092"`
        """
        return pulumi.get(self, "bootstrap_servers")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        Azure client ID of the application. This property is required when 'authenticationType' is set to 'AZURE_ACTIVE_DIRECTORY'. e.g.: 06ecaabf-8b80-4ec8-a0ec-20cbf463703d
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> str:
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the work request. Work requests should be scoped  to the same compartment as the resource the work request affects. If the work request concerns  multiple resources, and those resources are not in the same compartment, it is up to the service team  to pick the primary resource whose compartment should be used.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectionFactory")
    def connection_factory(self) -> str:
        """
        The of Java class implementing javax.jms.ConnectionFactory interface supplied by the Java Message Service provider. e.g.: 'com.stc.jmsjca.core.JConnectionFactoryXA'
        """
        return pulumi.get(self, "connection_factory")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> str:
        """
        JDBC connection string. e.g.: 'jdbc:sqlserver://<synapse-workspace>.sql.azuresynapse.net:1433;database=<db-name>;encrypt=true;trustServerCertificate=false;hostNameInCertificate=*.sql.azuresynapse.net;loginTimeout=300;'
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> str:
        """
        The array of connection types.
        """
        return pulumi.get(self, "connection_type")

    @property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> str:
        """
        JDBC connection URL. e.g.: 'jdbc:snowflake://<account_name>.snowflakecomputing.com/?warehouse=<warehouse-name>&db=<db-name>'
        """
        return pulumi.get(self, "connection_url")

    @property
    @pulumi.getter(name="consumerProperties")
    def consumer_properties(self) -> str:
        return pulumi.get(self, "consumer_properties")

    @property
    @pulumi.getter(name="coreSiteXml")
    def core_site_xml(self) -> str:
        return pulumi.get(self, "core_site_xml")

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Autonomous Json Database.
        """
        return pulumi.get(self, "database_id")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        The name of the database.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database system being referenced.
        """
        return pulumi.get(self, "db_system_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Tags defined for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deployment being referenced.
        """
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Metadata about this specific object.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only the resources that match the entire 'displayName' given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        Azure Storage service endpoint. e.g: https://test.blob.core.windows.net
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        A simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        The name or address of a host.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the connection being referenced.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ingressIps")
    def ingress_ips(self) -> Sequence['outputs.GetConnectionsConnectionCollectionItemIngressIpResult']:
        """
        List of ingress IP addresses from where the GoldenGate deployment connects to this connection's privateIp.  Customers may optionally set up ingress security rules to restrict traffic from these IP addresses.
        """
        return pulumi.get(self, "ingress_ips")

    @property
    @pulumi.getter(name="jndiConnectionFactory")
    def jndi_connection_factory(self) -> str:
        """
        The Connection Factory can be looked up using this name. e.g.: 'ConnectionFactory'
        """
        return pulumi.get(self, "jndi_connection_factory")

    @property
    @pulumi.getter(name="jndiInitialContextFactory")
    def jndi_initial_context_factory(self) -> str:
        """
        The implementation of javax.naming.spi.InitialContextFactory interface that the client uses to obtain initial naming context. e.g.: 'org.apache.activemq.jndi.ActiveMQInitialContextFactory'
        """
        return pulumi.get(self, "jndi_initial_context_factory")

    @property
    @pulumi.getter(name="jndiProviderUrl")
    def jndi_provider_url(self) -> str:
        """
        The URL that Java Message Service will use to contact the JNDI provider. e.g.: 'tcp://myjms.host.domain:61616?jms.prefetchPolicy.all=1000'
        """
        return pulumi.get(self, "jndi_provider_url")

    @property
    @pulumi.getter(name="jndiSecurityCredentials")
    def jndi_security_credentials(self) -> str:
        return pulumi.get(self, "jndi_security_credentials")

    @property
    @pulumi.getter(name="jndiSecurityPrincipal")
    def jndi_security_principal(self) -> str:
        """
        Specifies the identity of the principal (user) to be authenticated. e.g.: 'admin2'
        """
        return pulumi.get(self, "jndi_security_principal")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        """
        Refers to the customer's master key OCID.  If provided, it references a key to manage secrets. Customers must add policies to permit GoldenGate to use this key.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="keyStore")
    def key_store(self) -> str:
        return pulumi.get(self, "key_store")

    @property
    @pulumi.getter(name="keyStorePassword")
    def key_store_password(self) -> str:
        return pulumi.get(self, "key_store_password")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Describes the object's current state in detail. For example, it can be used to provide actionable information for a resource in a Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[str]:
        """
        An array of Network Security Group OCIDs used to define network access for either Deployments or Connections.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port of an endpoint usually specified for a connection.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> str:
        """
        The private IP address of the connection's endpoint in the customer's VCN, typically a database endpoint or a big data endpoint (e.g. Kafka bootstrap server). In case the privateIp is provided, the subnetId must also be provided. In case the privateIp (and the subnetId) is not provided it is assumed the datasource is publicly accessible. In case the connection is accessible only privately, the lack of privateIp will result in not being able to access the connection.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="privateKeyFile")
    def private_key_file(self) -> str:
        return pulumi.get(self, "private_key_file")

    @property
    @pulumi.getter(name="privateKeyPassphrase")
    def private_key_passphrase(self) -> str:
        return pulumi.get(self, "private_key_passphrase")

    @property
    @pulumi.getter(name="producerProperties")
    def producer_properties(self) -> str:
        return pulumi.get(self, "producer_properties")

    @property
    @pulumi.getter(name="publicKeyFingerprint")
    def public_key_fingerprint(self) -> str:
        return pulumi.get(self, "public_key_fingerprint")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The name of the region. e.g.: us-ashburn-1
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> str:
        return pulumi.get(self, "sas_token")

    @property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> str:
        return pulumi.get(self, "secret_access_key")

    @property
    @pulumi.getter(name="securityProtocol")
    def security_protocol(self) -> str:
        """
        Security protocol for PostgreSQL / Microsoft SQL Server..
        """
        return pulumi.get(self, "security_protocol")

    @property
    @pulumi.getter(name="sessionMode")
    def session_mode(self) -> str:
        """
        The mode of the database connection session to be established by the data client. 'REDIRECT' - for a RAC database, 'DIRECT' - for a non-RAC database. Connection to a RAC database involves a redirection received from the SCAN listeners to the database node to connect to. By default the mode would be DIRECT.
        """
        return pulumi.get(self, "session_mode")

    @property
    @pulumi.getter(name="shouldUseJndi")
    def should_use_jndi(self) -> bool:
        """
        If set to true, Java Naming and Directory Interface (JNDI) properties should be provided.
        """
        return pulumi.get(self, "should_use_jndi")

    @property
    @pulumi.getter(name="shouldValidateServerCertificate")
    def should_validate_server_certificate(self) -> bool:
        """
        If set to true, the driver validates the certificate that is sent by the database server.
        """
        return pulumi.get(self, "should_validate_server_certificate")

    @property
    @pulumi.getter(name="sslCa")
    def ssl_ca(self) -> str:
        """
        Database Certificate - The base64 encoded content of pem file containing the server public key (for 1-way SSL).
        """
        return pulumi.get(self, "ssl_ca")

    @property
    @pulumi.getter(name="sslCert")
    def ssl_cert(self) -> str:
        return pulumi.get(self, "ssl_cert")

    @property
    @pulumi.getter(name="sslCrl")
    def ssl_crl(self) -> str:
        return pulumi.get(self, "ssl_crl")

    @property
    @pulumi.getter(name="sslKey")
    def ssl_key(self) -> str:
        return pulumi.get(self, "ssl_key")

    @property
    @pulumi.getter(name="sslKeyPassword")
    def ssl_key_password(self) -> str:
        return pulumi.get(self, "ssl_key_password")

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> str:
        """
        SSL mode for PostgreSQL.
        """
        return pulumi.get(self, "ssl_mode")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only connections having the 'lifecycleState' given.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="streamPoolId")
    def stream_pool_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the stream pool being referenced.
        """
        return pulumi.get(self, "stream_pool_id")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet being referenced.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle Cloud Infrastructure services. Each key is predefined and scoped to namespaces.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="technologyType")
    def technology_type(self) -> str:
        """
        The array of technology types.
        """
        return pulumi.get(self, "technology_type")

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the related Oracle Cloud Infrastructure tenancy.
        """
        return pulumi.get(self, "tenancy_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the resource was created. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="trustStore")
    def trust_store(self) -> str:
        return pulumi.get(self, "trust_store")

    @property
    @pulumi.getter(name="trustStorePassword")
    def trust_store_password(self) -> str:
        return pulumi.get(self, "trust_store_password")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Kafka Schema Registry URL. e.g.: 'https://server1.us.oracle.com:8081'
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure user who will access the Oracle NoSQL database/Object Storage. The user must have write access to the table they want to connect to.
        """
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The username Oracle GoldenGate uses to connect the associated system of the given technology. This username must already exist and be available by the system/application to be connected to and must conform to the case sensitivity requirements defined in it.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        Refers to the customer's vault OCID.  If provided, it references a vault where GoldenGate can manage secrets. Customers must add policies to permit GoldenGate to manage secrets contained within this vault.
        """
        return pulumi.get(self, "vault_id")

    @property
    @pulumi.getter
    def wallet(self) -> str:
        return pulumi.get(self, "wallet")


@pulumi.output_type
class GetConnectionsConnectionCollectionItemAdditionalAttributeResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: The name of the property entry.
        :param str value: The value of the property entry.
        """
        GetConnectionsConnectionCollectionItemAdditionalAttributeResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             value: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the property entry.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the property entry.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetConnectionsConnectionCollectionItemBootstrapServerResult(dict):
    def __init__(__self__, *,
                 host: str,
                 port: int,
                 private_ip: str):
        """
        :param str host: The name or address of a host.
        :param int port: The port of an endpoint usually specified for a connection.
        :param str private_ip: The private IP address of the connection's endpoint in the customer's VCN, typically a database endpoint or a big data endpoint (e.g. Kafka bootstrap server). In case the privateIp is provided, the subnetId must also be provided. In case the privateIp (and the subnetId) is not provided it is assumed the datasource is publicly accessible. In case the connection is accessible only privately, the lack of privateIp will result in not being able to access the connection.
        """
        GetConnectionsConnectionCollectionItemBootstrapServerResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            host=host,
            port=port,
            private_ip=private_ip,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             host: str,
             port: int,
             private_ip: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'privateIp' in kwargs:
            private_ip = kwargs['privateIp']

        _setter("host", host)
        _setter("port", port)
        _setter("private_ip", private_ip)

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        The name or address of a host.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port of an endpoint usually specified for a connection.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> str:
        """
        The private IP address of the connection's endpoint in the customer's VCN, typically a database endpoint or a big data endpoint (e.g. Kafka bootstrap server). In case the privateIp is provided, the subnetId must also be provided. In case the privateIp (and the subnetId) is not provided it is assumed the datasource is publicly accessible. In case the connection is accessible only privately, the lack of privateIp will result in not being able to access the connection.
        """
        return pulumi.get(self, "private_ip")


@pulumi.output_type
class GetConnectionsConnectionCollectionItemIngressIpResult(dict):
    def __init__(__self__, *,
                 ingress_ip: str):
        """
        :param str ingress_ip: A Private Endpoint IPv4 or IPv6 Address created in the customer's subnet.
        """
        GetConnectionsConnectionCollectionItemIngressIpResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ingress_ip=ingress_ip,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ingress_ip: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'ingressIp' in kwargs:
            ingress_ip = kwargs['ingressIp']

        _setter("ingress_ip", ingress_ip)

    @property
    @pulumi.getter(name="ingressIp")
    def ingress_ip(self) -> str:
        """
        A Private Endpoint IPv4 or IPv6 Address created in the customer's subnet.
        """
        return pulumi.get(self, "ingress_ip")


@pulumi.output_type
class GetConnectionsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name of the property entry.
        """
        GetConnectionsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the property entry.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDatabaseRegistrationsDatabaseRegistrationCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDatabaseRegistrationsDatabaseRegistrationCollectionItemResult']):
        GetDatabaseRegistrationsDatabaseRegistrationCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetDatabaseRegistrationsDatabaseRegistrationCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDatabaseRegistrationsDatabaseRegistrationCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDatabaseRegistrationsDatabaseRegistrationCollectionItemResult(dict):
    def __init__(__self__, *,
                 alias_name: str,
                 compartment_id: str,
                 connection_string: str,
                 database_id: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 display_name: str,
                 fqdn: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 ip_address: str,
                 key_id: str,
                 lifecycle_details: str,
                 password: str,
                 rce_private_ip: str,
                 secret_compartment_id: str,
                 secret_id: str,
                 session_mode: str,
                 state: str,
                 subnet_id: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_updated: str,
                 username: str,
                 vault_id: str,
                 wallet: str):
        """
        :param str alias_name: Credential store alias.
        :param str compartment_id: The OCID of the compartment that contains the work request. Work requests should be scoped  to the same compartment as the resource the work request affects. If the work request concerns  multiple resources, and those resources are not in the same compartment, it is up to the service team  to pick the primary resource whose compartment should be used.
        :param str connection_string: Connect descriptor or Easy Connect Naming method used to connect to a database.
        :param str database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database being referenced.
        :param Mapping[str, Any] defined_tags: Tags defined for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace.bar-key": "value"}`
        :param str description: Metadata about this specific object.
        :param str display_name: A filter to return only the resources that match the entire 'displayName' given.
        :param str fqdn: A three-label Fully Qualified Domain Name (FQDN) for a resource.
        :param Mapping[str, Any] freeform_tags: A simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the databaseRegistration being referenced.
        :param str ip_address: The private IP address in the customer's VCN of the customer's endpoint, typically a database.
        :param str key_id: Refers to the customer's master key OCID.  If provided, it references a key to manage secrets. Customers must add policies to permit GoldenGate to use this key.
        :param str lifecycle_details: Describes the object's current state in detail. For example, it can be used to provide actionable information for a resource in a Failed state.
        :param str rce_private_ip: A Private Endpoint IP address created in the customer's subnet.  A customer database can expect network traffic initiated by GoldenGate Service from this IP address.  It can also send network traffic to this IP address, typically in response to requests from GoldenGate Service.  The customer may use this IP address in Security Lists or Network Security Groups (NSG) as needed.
        :param str secret_compartment_id: The OCID of the compartment where the GoldenGate Secret will be created.  If provided, it references a key to manage secrets. Customers must add policies to permit GoldenGate to use this key.
        :param str secret_id: The OCID of the customer's GoldenGate Service Secret.  If provided, it references a key that customers will be required to ensure the policies are established  to permit GoldenGate to use this Secret.
        :param str session_mode: The mode of the database connection session to be established by the data client. 'REDIRECT' - for a RAC database, 'DIRECT' - for a non-RAC database. Connection to a RAC database involves a redirection received from the SCAN listeners to the database node to connect to. By default the mode would be DIRECT.
        :param str state: A filter to return only the resources that match the 'lifecycleState' given.
        :param str subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet being referenced.
        :param Mapping[str, Any] system_tags: The system tags associated with this resource, if any. The system tags are set by Oracle Cloud Infrastructure services. Each key is predefined and scoped to namespaces.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{orcl-cloud: {free-tier-retain: true}}`
        :param str time_created: The time the resource was created. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param str time_updated: The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param str username: The username Oracle GoldenGate uses to connect the associated system of the given technology. This username must already exist and be available by the system/application to be connected to and must conform to the case sensitivty requirments defined in it.
        :param str vault_id: Refers to the customer's vault OCID.  If provided, it references a vault where GoldenGate can manage secrets. Customers must add policies to permit GoldenGate to manage secrets contained within this vault.
        """
        GetDatabaseRegistrationsDatabaseRegistrationCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            alias_name=alias_name,
            compartment_id=compartment_id,
            connection_string=connection_string,
            database_id=database_id,
            defined_tags=defined_tags,
            description=description,
            display_name=display_name,
            fqdn=fqdn,
            freeform_tags=freeform_tags,
            id=id,
            ip_address=ip_address,
            key_id=key_id,
            lifecycle_details=lifecycle_details,
            password=password,
            rce_private_ip=rce_private_ip,
            secret_compartment_id=secret_compartment_id,
            secret_id=secret_id,
            session_mode=session_mode,
            state=state,
            subnet_id=subnet_id,
            system_tags=system_tags,
            time_created=time_created,
            time_updated=time_updated,
            username=username,
            vault_id=vault_id,
            wallet=wallet,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             alias_name: str,
             compartment_id: str,
             connection_string: str,
             database_id: str,
             defined_tags: Mapping[str, Any],
             description: str,
             display_name: str,
             fqdn: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             ip_address: str,
             key_id: str,
             lifecycle_details: str,
             password: str,
             rce_private_ip: str,
             secret_compartment_id: str,
             secret_id: str,
             session_mode: str,
             state: str,
             subnet_id: str,
             system_tags: Mapping[str, Any],
             time_created: str,
             time_updated: str,
             username: str,
             vault_id: str,
             wallet: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'aliasName' in kwargs:
            alias_name = kwargs['aliasName']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'connectionString' in kwargs:
            connection_string = kwargs['connectionString']
        if 'databaseId' in kwargs:
            database_id = kwargs['databaseId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'ipAddress' in kwargs:
            ip_address = kwargs['ipAddress']
        if 'keyId' in kwargs:
            key_id = kwargs['keyId']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'rcePrivateIp' in kwargs:
            rce_private_ip = kwargs['rcePrivateIp']
        if 'secretCompartmentId' in kwargs:
            secret_compartment_id = kwargs['secretCompartmentId']
        if 'secretId' in kwargs:
            secret_id = kwargs['secretId']
        if 'sessionMode' in kwargs:
            session_mode = kwargs['sessionMode']
        if 'subnetId' in kwargs:
            subnet_id = kwargs['subnetId']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']
        if 'vaultId' in kwargs:
            vault_id = kwargs['vaultId']

        _setter("alias_name", alias_name)
        _setter("compartment_id", compartment_id)
        _setter("connection_string", connection_string)
        _setter("database_id", database_id)
        _setter("defined_tags", defined_tags)
        _setter("description", description)
        _setter("display_name", display_name)
        _setter("fqdn", fqdn)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("ip_address", ip_address)
        _setter("key_id", key_id)
        _setter("lifecycle_details", lifecycle_details)
        _setter("password", password)
        _setter("rce_private_ip", rce_private_ip)
        _setter("secret_compartment_id", secret_compartment_id)
        _setter("secret_id", secret_id)
        _setter("session_mode", session_mode)
        _setter("state", state)
        _setter("subnet_id", subnet_id)
        _setter("system_tags", system_tags)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)
        _setter("username", username)
        _setter("vault_id", vault_id)
        _setter("wallet", wallet)

    @property
    @pulumi.getter(name="aliasName")
    def alias_name(self) -> str:
        """
        Credential store alias.
        """
        return pulumi.get(self, "alias_name")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the work request. Work requests should be scoped  to the same compartment as the resource the work request affects. If the work request concerns  multiple resources, and those resources are not in the same compartment, it is up to the service team  to pick the primary resource whose compartment should be used.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> str:
        """
        Connect descriptor or Easy Connect Naming method used to connect to a database.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database being referenced.
        """
        return pulumi.get(self, "database_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Tags defined for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Metadata about this specific object.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only the resources that match the entire 'displayName' given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def fqdn(self) -> str:
        """
        A three-label Fully Qualified Domain Name (FQDN) for a resource.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        A simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the databaseRegistration being referenced.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The private IP address in the customer's VCN of the customer's endpoint, typically a database.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        """
        Refers to the customer's master key OCID.  If provided, it references a key to manage secrets. Customers must add policies to permit GoldenGate to use this key.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Describes the object's current state in detail. For example, it can be used to provide actionable information for a resource in a Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="rcePrivateIp")
    def rce_private_ip(self) -> str:
        """
        A Private Endpoint IP address created in the customer's subnet.  A customer database can expect network traffic initiated by GoldenGate Service from this IP address.  It can also send network traffic to this IP address, typically in response to requests from GoldenGate Service.  The customer may use this IP address in Security Lists or Network Security Groups (NSG) as needed.
        """
        return pulumi.get(self, "rce_private_ip")

    @property
    @pulumi.getter(name="secretCompartmentId")
    def secret_compartment_id(self) -> str:
        """
        The OCID of the compartment where the GoldenGate Secret will be created.  If provided, it references a key to manage secrets. Customers must add policies to permit GoldenGate to use this key.
        """
        return pulumi.get(self, "secret_compartment_id")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> str:
        """
        The OCID of the customer's GoldenGate Service Secret.  If provided, it references a key that customers will be required to ensure the policies are established  to permit GoldenGate to use this Secret.
        """
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter(name="sessionMode")
    def session_mode(self) -> str:
        """
        The mode of the database connection session to be established by the data client. 'REDIRECT' - for a RAC database, 'DIRECT' - for a non-RAC database. Connection to a RAC database involves a redirection received from the SCAN listeners to the database node to connect to. By default the mode would be DIRECT.
        """
        return pulumi.get(self, "session_mode")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only the resources that match the 'lifecycleState' given.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet being referenced.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle Cloud Infrastructure services. Each key is predefined and scoped to namespaces.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the resource was created. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The username Oracle GoldenGate uses to connect the associated system of the given technology. This username must already exist and be available by the system/application to be connected to and must conform to the case sensitivty requirments defined in it.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        Refers to the customer's vault OCID.  If provided, it references a vault where GoldenGate can manage secrets. Customers must add policies to permit GoldenGate to manage secrets contained within this vault.
        """
        return pulumi.get(self, "vault_id")

    @property
    @pulumi.getter
    def wallet(self) -> str:
        return pulumi.get(self, "wallet")


@pulumi.output_type
class GetDatabaseRegistrationsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetDatabaseRegistrationsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDeploymentBackupsDeploymentBackupCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDeploymentBackupsDeploymentBackupCollectionItemResult']):
        GetDeploymentBackupsDeploymentBackupCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetDeploymentBackupsDeploymentBackupCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDeploymentBackupsDeploymentBackupCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDeploymentBackupsDeploymentBackupCollectionItemResult(dict):
    def __init__(__self__, *,
                 backup_type: str,
                 bucket: str,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 deployment_id: str,
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 is_automatic: bool,
                 lifecycle_details: str,
                 namespace: str,
                 object: str,
                 ogg_version: str,
                 size_in_bytes: float,
                 state: str,
                 system_tags: Mapping[str, Any],
                 time_backup_finished: str,
                 time_created: str,
                 time_of_backup: str,
                 time_updated: str):
        """
        :param str backup_type: Possible Deployment backup types.
        :param str bucket: Name of the bucket where the object is to be uploaded in the object storage
        :param str compartment_id: The OCID of the compartment that contains the work request. Work requests should be scoped  to the same compartment as the resource the work request affects. If the work request concerns  multiple resources, and those resources are not in the same compartment, it is up to the service team  to pick the primary resource whose compartment should be used.
        :param Mapping[str, Any] defined_tags: Tags defined for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace.bar-key": "value"}`
        :param str deployment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deployment in which to list resources.
        :param str display_name: A filter to return only the resources that match the entire 'displayName' given.
        :param Mapping[str, Any] freeform_tags: A simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup being referenced.
        :param bool is_automatic: True if this object is automatically created
        :param str lifecycle_details: Describes the object's current state in detail. For example, it can be used to provide actionable information for a resource in a Failed state.
        :param str namespace: Name of namespace that serves as a container for all of your buckets
        :param str object: Name of the object to be uploaded to object storage
        :param str ogg_version: Version of OGG
        :param float size_in_bytes: The size of the backup stored in object storage (in bytes)
        :param str state: A filter to return only the resources that match the 'lifecycleState' given.
        :param Mapping[str, Any] system_tags: The system tags associated with this resource, if any. The system tags are set by Oracle Cloud Infrastructure services. Each key is predefined and scoped to namespaces.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{orcl-cloud: {free-tier-retain: true}}`
        :param str time_backup_finished: The time of the resource backup finish. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param str time_created: The time the resource was created. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param str time_of_backup: The time of the resource backup. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param str time_updated: The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        GetDeploymentBackupsDeploymentBackupCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            backup_type=backup_type,
            bucket=bucket,
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            deployment_id=deployment_id,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            is_automatic=is_automatic,
            lifecycle_details=lifecycle_details,
            namespace=namespace,
            object=object,
            ogg_version=ogg_version,
            size_in_bytes=size_in_bytes,
            state=state,
            system_tags=system_tags,
            time_backup_finished=time_backup_finished,
            time_created=time_created,
            time_of_backup=time_of_backup,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             backup_type: str,
             bucket: str,
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             deployment_id: str,
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             is_automatic: bool,
             lifecycle_details: str,
             namespace: str,
             object: str,
             ogg_version: str,
             size_in_bytes: float,
             state: str,
             system_tags: Mapping[str, Any],
             time_backup_finished: str,
             time_created: str,
             time_of_backup: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'backupType' in kwargs:
            backup_type = kwargs['backupType']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'deploymentId' in kwargs:
            deployment_id = kwargs['deploymentId']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'isAutomatic' in kwargs:
            is_automatic = kwargs['isAutomatic']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'oggVersion' in kwargs:
            ogg_version = kwargs['oggVersion']
        if 'sizeInBytes' in kwargs:
            size_in_bytes = kwargs['sizeInBytes']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']
        if 'timeBackupFinished' in kwargs:
            time_backup_finished = kwargs['timeBackupFinished']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeOfBackup' in kwargs:
            time_of_backup = kwargs['timeOfBackup']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        _setter("backup_type", backup_type)
        _setter("bucket", bucket)
        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("deployment_id", deployment_id)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("is_automatic", is_automatic)
        _setter("lifecycle_details", lifecycle_details)
        _setter("namespace", namespace)
        _setter("object", object)
        _setter("ogg_version", ogg_version)
        _setter("size_in_bytes", size_in_bytes)
        _setter("state", state)
        _setter("system_tags", system_tags)
        _setter("time_backup_finished", time_backup_finished)
        _setter("time_created", time_created)
        _setter("time_of_backup", time_of_backup)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> str:
        """
        Possible Deployment backup types.
        """
        return pulumi.get(self, "backup_type")

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Name of the bucket where the object is to be uploaded in the object storage
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the work request. Work requests should be scoped  to the same compartment as the resource the work request affects. If the work request concerns  multiple resources, and those resources are not in the same compartment, it is up to the service team  to pick the primary resource whose compartment should be used.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Tags defined for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deployment in which to list resources.
        """
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only the resources that match the entire 'displayName' given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        A simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup being referenced.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAutomatic")
    def is_automatic(self) -> bool:
        """
        True if this object is automatically created
        """
        return pulumi.get(self, "is_automatic")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Describes the object's current state in detail. For example, it can be used to provide actionable information for a resource in a Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Name of namespace that serves as a container for all of your buckets
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Name of the object to be uploaded to object storage
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="oggVersion")
    def ogg_version(self) -> str:
        """
        Version of OGG
        """
        return pulumi.get(self, "ogg_version")

    @property
    @pulumi.getter(name="sizeInBytes")
    def size_in_bytes(self) -> float:
        """
        The size of the backup stored in object storage (in bytes)
        """
        return pulumi.get(self, "size_in_bytes")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only the resources that match the 'lifecycleState' given.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle Cloud Infrastructure services. Each key is predefined and scoped to namespaces.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeBackupFinished")
    def time_backup_finished(self) -> str:
        """
        The time of the resource backup finish. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_backup_finished")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the resource was created. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeOfBackup")
    def time_of_backup(self) -> str:
        """
        The time of the resource backup. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_of_backup")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetDeploymentBackupsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetDeploymentBackupsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDeploymentDeploymentDiagnosticDataResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 diagnostic_state: str,
                 namespace: str,
                 object: str,
                 time_diagnostic_end: str,
                 time_diagnostic_start: str):
        """
        :param str bucket: Name of the bucket where the object is to be uploaded in the object storage
        :param str diagnostic_state: The state of the deployment diagnostic collection.
        :param str namespace: Name of namespace that serves as a container for all of your buckets
        :param str object: Name of the diagnostic collected and uploaded to object storage
        :param str time_diagnostic_end: The time until which the diagnostic collection should collect the logs. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param str time_diagnostic_start: The time from which the diagnostic collection should collect the logs. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        GetDeploymentDeploymentDiagnosticDataResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            diagnostic_state=diagnostic_state,
            namespace=namespace,
            object=object,
            time_diagnostic_end=time_diagnostic_end,
            time_diagnostic_start=time_diagnostic_start,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: str,
             diagnostic_state: str,
             namespace: str,
             object: str,
             time_diagnostic_end: str,
             time_diagnostic_start: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'diagnosticState' in kwargs:
            diagnostic_state = kwargs['diagnosticState']
        if 'timeDiagnosticEnd' in kwargs:
            time_diagnostic_end = kwargs['timeDiagnosticEnd']
        if 'timeDiagnosticStart' in kwargs:
            time_diagnostic_start = kwargs['timeDiagnosticStart']

        _setter("bucket", bucket)
        _setter("diagnostic_state", diagnostic_state)
        _setter("namespace", namespace)
        _setter("object", object)
        _setter("time_diagnostic_end", time_diagnostic_end)
        _setter("time_diagnostic_start", time_diagnostic_start)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Name of the bucket where the object is to be uploaded in the object storage
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="diagnosticState")
    def diagnostic_state(self) -> str:
        """
        The state of the deployment diagnostic collection.
        """
        return pulumi.get(self, "diagnostic_state")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Name of namespace that serves as a container for all of your buckets
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Name of the diagnostic collected and uploaded to object storage
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="timeDiagnosticEnd")
    def time_diagnostic_end(self) -> str:
        """
        The time until which the diagnostic collection should collect the logs. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_diagnostic_end")

    @property
    @pulumi.getter(name="timeDiagnosticStart")
    def time_diagnostic_start(self) -> str:
        """
        The time from which the diagnostic collection should collect the logs. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_diagnostic_start")


@pulumi.output_type
class GetDeploymentMaintenanceConfigurationResult(dict):
    def __init__(__self__, *,
                 bundle_release_upgrade_period_in_days: int,
                 interim_release_upgrade_period_in_days: int,
                 is_interim_release_auto_upgrade_enabled: bool,
                 major_release_upgrade_period_in_days: int,
                 security_patch_upgrade_period_in_days: int):
        """
        :param int bundle_release_upgrade_period_in_days: Defines auto upgrade period for bundle releases. Manually configured period cannot be longer than service defined period for bundle releases. This period must be shorter or equal to major release upgrade period. Not passing this field during create will equate to using the service default.
        :param int interim_release_upgrade_period_in_days: Defines auto upgrade period for interim releases. This period must be shorter or equal to bundle release upgrade period.
        :param bool is_interim_release_auto_upgrade_enabled: By default auto upgrade for interim releases are not enabled. If auto-upgrade is enabled for interim release,  you have to specify interimReleaseUpgradePeriodInDays too.
        :param int major_release_upgrade_period_in_days: Defines auto upgrade period for major releases. Manually configured period cannot be longer than service defined period for major releases. Not passing this field during create will equate to using the service default.
        :param int security_patch_upgrade_period_in_days: Defines auto upgrade period for releases with security fix. Manually configured period cannot be longer than service defined period for security releases. Not passing this field during create will equate to using the service default.
        """
        GetDeploymentMaintenanceConfigurationResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bundle_release_upgrade_period_in_days=bundle_release_upgrade_period_in_days,
            interim_release_upgrade_period_in_days=interim_release_upgrade_period_in_days,
            is_interim_release_auto_upgrade_enabled=is_interim_release_auto_upgrade_enabled,
            major_release_upgrade_period_in_days=major_release_upgrade_period_in_days,
            security_patch_upgrade_period_in_days=security_patch_upgrade_period_in_days,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bundle_release_upgrade_period_in_days: int,
             interim_release_upgrade_period_in_days: int,
             is_interim_release_auto_upgrade_enabled: bool,
             major_release_upgrade_period_in_days: int,
             security_patch_upgrade_period_in_days: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'bundleReleaseUpgradePeriodInDays' in kwargs:
            bundle_release_upgrade_period_in_days = kwargs['bundleReleaseUpgradePeriodInDays']
        if 'interimReleaseUpgradePeriodInDays' in kwargs:
            interim_release_upgrade_period_in_days = kwargs['interimReleaseUpgradePeriodInDays']
        if 'isInterimReleaseAutoUpgradeEnabled' in kwargs:
            is_interim_release_auto_upgrade_enabled = kwargs['isInterimReleaseAutoUpgradeEnabled']
        if 'majorReleaseUpgradePeriodInDays' in kwargs:
            major_release_upgrade_period_in_days = kwargs['majorReleaseUpgradePeriodInDays']
        if 'securityPatchUpgradePeriodInDays' in kwargs:
            security_patch_upgrade_period_in_days = kwargs['securityPatchUpgradePeriodInDays']

        _setter("bundle_release_upgrade_period_in_days", bundle_release_upgrade_period_in_days)
        _setter("interim_release_upgrade_period_in_days", interim_release_upgrade_period_in_days)
        _setter("is_interim_release_auto_upgrade_enabled", is_interim_release_auto_upgrade_enabled)
        _setter("major_release_upgrade_period_in_days", major_release_upgrade_period_in_days)
        _setter("security_patch_upgrade_period_in_days", security_patch_upgrade_period_in_days)

    @property
    @pulumi.getter(name="bundleReleaseUpgradePeriodInDays")
    def bundle_release_upgrade_period_in_days(self) -> int:
        """
        Defines auto upgrade period for bundle releases. Manually configured period cannot be longer than service defined period for bundle releases. This period must be shorter or equal to major release upgrade period. Not passing this field during create will equate to using the service default.
        """
        return pulumi.get(self, "bundle_release_upgrade_period_in_days")

    @property
    @pulumi.getter(name="interimReleaseUpgradePeriodInDays")
    def interim_release_upgrade_period_in_days(self) -> int:
        """
        Defines auto upgrade period for interim releases. This period must be shorter or equal to bundle release upgrade period.
        """
        return pulumi.get(self, "interim_release_upgrade_period_in_days")

    @property
    @pulumi.getter(name="isInterimReleaseAutoUpgradeEnabled")
    def is_interim_release_auto_upgrade_enabled(self) -> bool:
        """
        By default auto upgrade for interim releases are not enabled. If auto-upgrade is enabled for interim release,  you have to specify interimReleaseUpgradePeriodInDays too.
        """
        return pulumi.get(self, "is_interim_release_auto_upgrade_enabled")

    @property
    @pulumi.getter(name="majorReleaseUpgradePeriodInDays")
    def major_release_upgrade_period_in_days(self) -> int:
        """
        Defines auto upgrade period for major releases. Manually configured period cannot be longer than service defined period for major releases. Not passing this field during create will equate to using the service default.
        """
        return pulumi.get(self, "major_release_upgrade_period_in_days")

    @property
    @pulumi.getter(name="securityPatchUpgradePeriodInDays")
    def security_patch_upgrade_period_in_days(self) -> int:
        """
        Defines auto upgrade period for releases with security fix. Manually configured period cannot be longer than service defined period for security releases. Not passing this field during create will equate to using the service default.
        """
        return pulumi.get(self, "security_patch_upgrade_period_in_days")


@pulumi.output_type
class GetDeploymentMaintenanceWindowResult(dict):
    def __init__(__self__, *,
                 day: str,
                 start_hour: int):
        """
        :param str day: Days of the week.
        :param int start_hour: Start hour for maintenance period. Hour is in UTC.
        """
        GetDeploymentMaintenanceWindowResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            day=day,
            start_hour=start_hour,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             day: str,
             start_hour: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'startHour' in kwargs:
            start_hour = kwargs['startHour']

        _setter("day", day)
        _setter("start_hour", start_hour)

    @property
    @pulumi.getter
    def day(self) -> str:
        """
        Days of the week.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter(name="startHour")
    def start_hour(self) -> int:
        """
        Start hour for maintenance period. Hour is in UTC.
        """
        return pulumi.get(self, "start_hour")


@pulumi.output_type
class GetDeploymentOggDataResult(dict):
    def __init__(__self__, *,
                 admin_password: str,
                 admin_username: str,
                 certificate: str,
                 credential_store: str,
                 deployment_name: str,
                 identity_domain_id: str,
                 key: str,
                 ogg_version: str,
                 password_secret_id: str):
        """
        :param str admin_username: The GoldenGate deployment console username.
        :param str certificate: A PEM-encoded SSL certificate.
        :param str credential_store: The type of credential store for OGG.
        :param str deployment_name: The name given to the GoldenGate service deployment. The name must be 1 to 32 characters long, must contain only alphanumeric characters and must start with a letter.
        :param str identity_domain_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Identity Domain when IAM credential store is used.
        :param str ogg_version: Version of OGG
        :param str password_secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Secret where the deployment password is stored.
        """
        GetDeploymentOggDataResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            admin_password=admin_password,
            admin_username=admin_username,
            certificate=certificate,
            credential_store=credential_store,
            deployment_name=deployment_name,
            identity_domain_id=identity_domain_id,
            key=key,
            ogg_version=ogg_version,
            password_secret_id=password_secret_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             admin_password: str,
             admin_username: str,
             certificate: str,
             credential_store: str,
             deployment_name: str,
             identity_domain_id: str,
             key: str,
             ogg_version: str,
             password_secret_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'adminPassword' in kwargs:
            admin_password = kwargs['adminPassword']
        if 'adminUsername' in kwargs:
            admin_username = kwargs['adminUsername']
        if 'credentialStore' in kwargs:
            credential_store = kwargs['credentialStore']
        if 'deploymentName' in kwargs:
            deployment_name = kwargs['deploymentName']
        if 'identityDomainId' in kwargs:
            identity_domain_id = kwargs['identityDomainId']
        if 'oggVersion' in kwargs:
            ogg_version = kwargs['oggVersion']
        if 'passwordSecretId' in kwargs:
            password_secret_id = kwargs['passwordSecretId']

        _setter("admin_password", admin_password)
        _setter("admin_username", admin_username)
        _setter("certificate", certificate)
        _setter("credential_store", credential_store)
        _setter("deployment_name", deployment_name)
        _setter("identity_domain_id", identity_domain_id)
        _setter("key", key)
        _setter("ogg_version", ogg_version)
        _setter("password_secret_id", password_secret_id)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> str:
        return pulumi.get(self, "admin_password")

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> str:
        """
        The GoldenGate deployment console username.
        """
        return pulumi.get(self, "admin_username")

    @property
    @pulumi.getter
    def certificate(self) -> str:
        """
        A PEM-encoded SSL certificate.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="credentialStore")
    def credential_store(self) -> str:
        """
        The type of credential store for OGG.
        """
        return pulumi.get(self, "credential_store")

    @property
    @pulumi.getter(name="deploymentName")
    def deployment_name(self) -> str:
        """
        The name given to the GoldenGate service deployment. The name must be 1 to 32 characters long, must contain only alphanumeric characters and must start with a letter.
        """
        return pulumi.get(self, "deployment_name")

    @property
    @pulumi.getter(name="identityDomainId")
    def identity_domain_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Identity Domain when IAM credential store is used.
        """
        return pulumi.get(self, "identity_domain_id")

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="oggVersion")
    def ogg_version(self) -> str:
        """
        Version of OGG
        """
        return pulumi.get(self, "ogg_version")

    @property
    @pulumi.getter(name="passwordSecretId")
    def password_secret_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Secret where the deployment password is stored.
        """
        return pulumi.get(self, "password_secret_id")


@pulumi.output_type
class GetDeploymentTypeItemResult(dict):
    def __init__(__self__, *,
                 category: str,
                 connection_types: Sequence[str],
                 deployment_type: str,
                 display_name: str,
                 source_technologies: Sequence[str],
                 target_technologies: Sequence[str]):
        """
        :param str category: The deployment category defines the broad separation of the deployment type into categories.  Currently the separation is 'DATA_REPLICATION' and 'STREAM_ANALYTICS'.
        :param Sequence[str] connection_types: An array of connectionTypes.
        :param str deployment_type: The type of deployment, the value determines the exact 'type' of service executed in the Deployment. NOTE: Use of the value 'OGG' is maintained for backward compatibility purposes.  Its use is discouraged in favor of the equivalent 'DATABASE_ORACLE' value.
        :param str display_name: A filter to return only the resources that match the entire 'displayName' given.
        :param Sequence[str] source_technologies: List of the supported technologies generally.  The value is a freeform text string generally consisting of a description of the technology and optionally the speific version(s) support.  For example, [ "Oracle Database 19c", "Oracle Exadata", "OCI Streaming" ]
        :param Sequence[str] target_technologies: List of the supported technologies generally.  The value is a freeform text string generally consisting of a description of the technology and optionally the speific version(s) support.  For example, [ "Oracle Database 19c", "Oracle Exadata", "OCI Streaming" ]
        """
        GetDeploymentTypeItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            category=category,
            connection_types=connection_types,
            deployment_type=deployment_type,
            display_name=display_name,
            source_technologies=source_technologies,
            target_technologies=target_technologies,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             category: str,
             connection_types: Sequence[str],
             deployment_type: str,
             display_name: str,
             source_technologies: Sequence[str],
             target_technologies: Sequence[str],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'connectionTypes' in kwargs:
            connection_types = kwargs['connectionTypes']
        if 'deploymentType' in kwargs:
            deployment_type = kwargs['deploymentType']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'sourceTechnologies' in kwargs:
            source_technologies = kwargs['sourceTechnologies']
        if 'targetTechnologies' in kwargs:
            target_technologies = kwargs['targetTechnologies']

        _setter("category", category)
        _setter("connection_types", connection_types)
        _setter("deployment_type", deployment_type)
        _setter("display_name", display_name)
        _setter("source_technologies", source_technologies)
        _setter("target_technologies", target_technologies)

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        The deployment category defines the broad separation of the deployment type into categories.  Currently the separation is 'DATA_REPLICATION' and 'STREAM_ANALYTICS'.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="connectionTypes")
    def connection_types(self) -> Sequence[str]:
        """
        An array of connectionTypes.
        """
        return pulumi.get(self, "connection_types")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> str:
        """
        The type of deployment, the value determines the exact 'type' of service executed in the Deployment. NOTE: Use of the value 'OGG' is maintained for backward compatibility purposes.  Its use is discouraged in favor of the equivalent 'DATABASE_ORACLE' value.
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only the resources that match the entire 'displayName' given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="sourceTechnologies")
    def source_technologies(self) -> Sequence[str]:
        """
        List of the supported technologies generally.  The value is a freeform text string generally consisting of a description of the technology and optionally the speific version(s) support.  For example, [ "Oracle Database 19c", "Oracle Exadata", "OCI Streaming" ]
        """
        return pulumi.get(self, "source_technologies")

    @property
    @pulumi.getter(name="targetTechnologies")
    def target_technologies(self) -> Sequence[str]:
        """
        List of the supported technologies generally.  The value is a freeform text string generally consisting of a description of the technology and optionally the speific version(s) support.  For example, [ "Oracle Database 19c", "Oracle Exadata", "OCI Streaming" ]
        """
        return pulumi.get(self, "target_technologies")


@pulumi.output_type
class GetDeploymentTypesDeploymentTypeCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDeploymentTypesDeploymentTypeCollectionItemResult']):
        """
        :param Sequence['GetDeploymentTypesDeploymentTypeCollectionItemArgs'] items: Array of DeploymentTypeSummary
        """
        GetDeploymentTypesDeploymentTypeCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetDeploymentTypesDeploymentTypeCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDeploymentTypesDeploymentTypeCollectionItemResult']:
        """
        Array of DeploymentTypeSummary
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDeploymentTypesDeploymentTypeCollectionItemResult(dict):
    def __init__(__self__, *,
                 category: str,
                 connection_types: Sequence[str],
                 deployment_type: str,
                 display_name: str,
                 ogg_version: str,
                 source_technologies: Sequence[str],
                 target_technologies: Sequence[str]):
        """
        :param str category: The deployment category defines the broad separation of the deployment type into categories.  Currently the separation is 'DATA_REPLICATION' and 'STREAM_ANALYTICS'.
        :param Sequence[str] connection_types: An array of connectionTypes.
        :param str deployment_type: The type of deployment, the value determines the exact 'type' of the service executed in the deployment. Default value is DATABASE_ORACLE.
        :param str display_name: A filter to return only the resources that match the entire 'displayName' given.
        :param str ogg_version: Allows to query by a specific GoldenGate version.
        :param Sequence[str] source_technologies: List of the supported technologies generally.  The value is a freeform text string generally consisting of a description of the technology and optionally the speific version(s) support.  For example, [ "Oracle Database 19c", "Oracle Exadata", "OCI Streaming" ]
        :param Sequence[str] target_technologies: List of the supported technologies generally.  The value is a freeform text string generally consisting of a description of the technology and optionally the speific version(s) support.  For example, [ "Oracle Database 19c", "Oracle Exadata", "OCI Streaming" ]
        """
        GetDeploymentTypesDeploymentTypeCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            category=category,
            connection_types=connection_types,
            deployment_type=deployment_type,
            display_name=display_name,
            ogg_version=ogg_version,
            source_technologies=source_technologies,
            target_technologies=target_technologies,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             category: str,
             connection_types: Sequence[str],
             deployment_type: str,
             display_name: str,
             ogg_version: str,
             source_technologies: Sequence[str],
             target_technologies: Sequence[str],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'connectionTypes' in kwargs:
            connection_types = kwargs['connectionTypes']
        if 'deploymentType' in kwargs:
            deployment_type = kwargs['deploymentType']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'oggVersion' in kwargs:
            ogg_version = kwargs['oggVersion']
        if 'sourceTechnologies' in kwargs:
            source_technologies = kwargs['sourceTechnologies']
        if 'targetTechnologies' in kwargs:
            target_technologies = kwargs['targetTechnologies']

        _setter("category", category)
        _setter("connection_types", connection_types)
        _setter("deployment_type", deployment_type)
        _setter("display_name", display_name)
        _setter("ogg_version", ogg_version)
        _setter("source_technologies", source_technologies)
        _setter("target_technologies", target_technologies)

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        The deployment category defines the broad separation of the deployment type into categories.  Currently the separation is 'DATA_REPLICATION' and 'STREAM_ANALYTICS'.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="connectionTypes")
    def connection_types(self) -> Sequence[str]:
        """
        An array of connectionTypes.
        """
        return pulumi.get(self, "connection_types")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> str:
        """
        The type of deployment, the value determines the exact 'type' of the service executed in the deployment. Default value is DATABASE_ORACLE.
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only the resources that match the entire 'displayName' given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="oggVersion")
    def ogg_version(self) -> str:
        """
        Allows to query by a specific GoldenGate version.
        """
        return pulumi.get(self, "ogg_version")

    @property
    @pulumi.getter(name="sourceTechnologies")
    def source_technologies(self) -> Sequence[str]:
        """
        List of the supported technologies generally.  The value is a freeform text string generally consisting of a description of the technology and optionally the speific version(s) support.  For example, [ "Oracle Database 19c", "Oracle Exadata", "OCI Streaming" ]
        """
        return pulumi.get(self, "source_technologies")

    @property
    @pulumi.getter(name="targetTechnologies")
    def target_technologies(self) -> Sequence[str]:
        """
        List of the supported technologies generally.  The value is a freeform text string generally consisting of a description of the technology and optionally the speific version(s) support.  For example, [ "Oracle Database 19c", "Oracle Exadata", "OCI Streaming" ]
        """
        return pulumi.get(self, "target_technologies")


@pulumi.output_type
class GetDeploymentTypesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetDeploymentTypesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDeploymentUpgradesDeploymentUpgradeCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDeploymentUpgradesDeploymentUpgradeCollectionItemResult']):
        GetDeploymentUpgradesDeploymentUpgradeCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetDeploymentUpgradesDeploymentUpgradeCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDeploymentUpgradesDeploymentUpgradeCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDeploymentUpgradesDeploymentUpgradeCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 deployment_id: str,
                 deployment_upgrade_type: str,
                 description: str,
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 is_cancel_allowed: bool,
                 is_reschedule_allowed: bool,
                 is_rollback_allowed: bool,
                 is_security_fix: bool,
                 is_snoozed: bool,
                 lifecycle_details: str,
                 lifecycle_sub_state: str,
                 ogg_version: str,
                 previous_ogg_version: str,
                 release_type: str,
                 state: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_finished: str,
                 time_ogg_version_supported_until: str,
                 time_released: str,
                 time_schedule: str,
                 time_schedule_max: str,
                 time_snoozed_until: str,
                 time_started: str,
                 time_updated: str):
        """
        :param str compartment_id: The OCID of the compartment that contains the work request. Work requests should be scoped  to the same compartment as the resource the work request affects. If the work request concerns  multiple resources, and those resources are not in the same compartment, it is up to the service team  to pick the primary resource whose compartment should be used.
        :param Mapping[str, Any] defined_tags: Tags defined for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace.bar-key": "value"}`
        :param str deployment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deployment in which to list resources.
        :param str deployment_upgrade_type: The type of the deployment upgrade: MANUAL or AUTOMATIC
        :param str description: Metadata about this specific object.
        :param str display_name: A filter to return only the resources that match the entire 'displayName' given.
        :param Mapping[str, Any] freeform_tags: A simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deployment upgrade being referenced.
        :param bool is_cancel_allowed: Indicates if cancel is allowed. Scheduled upgrade can be cancelled only if target version is not forced by service,  otherwise only reschedule allowed.
        :param bool is_reschedule_allowed: Indicates if reschedule is allowed. Upgrade can be rescheduled postponed until the end of the service defined auto-upgrade period.
        :param bool is_rollback_allowed: Indicates if rollback is allowed. In practice only the last upgrade can be rolled back.
               * Manual upgrade is allowed to rollback only until the old version isn't deprecated yet.
               * Automatic upgrade by default is not allowed, unless a serious issue does not justify.
        :param bool is_security_fix: Indicates if OGG release contains security fix.
        :param bool is_snoozed: Indicates if upgrade notifications are snoozed or not.
        :param str lifecycle_details: Describes the object's current state in detail. For example, it can be used to provide actionable information for a resource in a Failed state.
        :param str lifecycle_sub_state: Possible GGS lifecycle sub-states.
        :param str ogg_version: Version of OGG
        :param str previous_ogg_version: Version of OGG
        :param str release_type: The type of release.
        :param str state: A filter to return only the resources that match the 'lifecycleState' given.
        :param Mapping[str, Any] system_tags: The system tags associated with this resource, if any. The system tags are set by Oracle Cloud Infrastructure services. Each key is predefined and scoped to namespaces.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{orcl-cloud: {free-tier-retain: true}}`
        :param str time_created: The time the resource was created. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param str time_finished: The date and time the request was finished. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param str time_ogg_version_supported_until: The time until OGG version is supported. After this date has passed OGG version will not be available anymore. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param str time_released: The time the resource was released. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param str time_schedule: The time of upgrade schedule. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param str time_schedule_max: Indicates the latest time until the deployment upgrade could be rescheduled. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param str time_snoozed_until: The time the upgrade notifications are snoozed until. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param str time_started: The date and time the request was started. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param str time_updated: The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        GetDeploymentUpgradesDeploymentUpgradeCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            deployment_id=deployment_id,
            deployment_upgrade_type=deployment_upgrade_type,
            description=description,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            is_cancel_allowed=is_cancel_allowed,
            is_reschedule_allowed=is_reschedule_allowed,
            is_rollback_allowed=is_rollback_allowed,
            is_security_fix=is_security_fix,
            is_snoozed=is_snoozed,
            lifecycle_details=lifecycle_details,
            lifecycle_sub_state=lifecycle_sub_state,
            ogg_version=ogg_version,
            previous_ogg_version=previous_ogg_version,
            release_type=release_type,
            state=state,
            system_tags=system_tags,
            time_created=time_created,
            time_finished=time_finished,
            time_ogg_version_supported_until=time_ogg_version_supported_until,
            time_released=time_released,
            time_schedule=time_schedule,
            time_schedule_max=time_schedule_max,
            time_snoozed_until=time_snoozed_until,
            time_started=time_started,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             deployment_id: str,
             deployment_upgrade_type: str,
             description: str,
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             is_cancel_allowed: bool,
             is_reschedule_allowed: bool,
             is_rollback_allowed: bool,
             is_security_fix: bool,
             is_snoozed: bool,
             lifecycle_details: str,
             lifecycle_sub_state: str,
             ogg_version: str,
             previous_ogg_version: str,
             release_type: str,
             state: str,
             system_tags: Mapping[str, Any],
             time_created: str,
             time_finished: str,
             time_ogg_version_supported_until: str,
             time_released: str,
             time_schedule: str,
             time_schedule_max: str,
             time_snoozed_until: str,
             time_started: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'deploymentId' in kwargs:
            deployment_id = kwargs['deploymentId']
        if 'deploymentUpgradeType' in kwargs:
            deployment_upgrade_type = kwargs['deploymentUpgradeType']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'isCancelAllowed' in kwargs:
            is_cancel_allowed = kwargs['isCancelAllowed']
        if 'isRescheduleAllowed' in kwargs:
            is_reschedule_allowed = kwargs['isRescheduleAllowed']
        if 'isRollbackAllowed' in kwargs:
            is_rollback_allowed = kwargs['isRollbackAllowed']
        if 'isSecurityFix' in kwargs:
            is_security_fix = kwargs['isSecurityFix']
        if 'isSnoozed' in kwargs:
            is_snoozed = kwargs['isSnoozed']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'lifecycleSubState' in kwargs:
            lifecycle_sub_state = kwargs['lifecycleSubState']
        if 'oggVersion' in kwargs:
            ogg_version = kwargs['oggVersion']
        if 'previousOggVersion' in kwargs:
            previous_ogg_version = kwargs['previousOggVersion']
        if 'releaseType' in kwargs:
            release_type = kwargs['releaseType']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeFinished' in kwargs:
            time_finished = kwargs['timeFinished']
        if 'timeOggVersionSupportedUntil' in kwargs:
            time_ogg_version_supported_until = kwargs['timeOggVersionSupportedUntil']
        if 'timeReleased' in kwargs:
            time_released = kwargs['timeReleased']
        if 'timeSchedule' in kwargs:
            time_schedule = kwargs['timeSchedule']
        if 'timeScheduleMax' in kwargs:
            time_schedule_max = kwargs['timeScheduleMax']
        if 'timeSnoozedUntil' in kwargs:
            time_snoozed_until = kwargs['timeSnoozedUntil']
        if 'timeStarted' in kwargs:
            time_started = kwargs['timeStarted']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("deployment_id", deployment_id)
        _setter("deployment_upgrade_type", deployment_upgrade_type)
        _setter("description", description)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("is_cancel_allowed", is_cancel_allowed)
        _setter("is_reschedule_allowed", is_reschedule_allowed)
        _setter("is_rollback_allowed", is_rollback_allowed)
        _setter("is_security_fix", is_security_fix)
        _setter("is_snoozed", is_snoozed)
        _setter("lifecycle_details", lifecycle_details)
        _setter("lifecycle_sub_state", lifecycle_sub_state)
        _setter("ogg_version", ogg_version)
        _setter("previous_ogg_version", previous_ogg_version)
        _setter("release_type", release_type)
        _setter("state", state)
        _setter("system_tags", system_tags)
        _setter("time_created", time_created)
        _setter("time_finished", time_finished)
        _setter("time_ogg_version_supported_until", time_ogg_version_supported_until)
        _setter("time_released", time_released)
        _setter("time_schedule", time_schedule)
        _setter("time_schedule_max", time_schedule_max)
        _setter("time_snoozed_until", time_snoozed_until)
        _setter("time_started", time_started)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the work request. Work requests should be scoped  to the same compartment as the resource the work request affects. If the work request concerns  multiple resources, and those resources are not in the same compartment, it is up to the service team  to pick the primary resource whose compartment should be used.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Tags defined for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deployment in which to list resources.
        """
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter(name="deploymentUpgradeType")
    def deployment_upgrade_type(self) -> str:
        """
        The type of the deployment upgrade: MANUAL or AUTOMATIC
        """
        return pulumi.get(self, "deployment_upgrade_type")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Metadata about this specific object.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only the resources that match the entire 'displayName' given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        A simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deployment upgrade being referenced.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isCancelAllowed")
    def is_cancel_allowed(self) -> bool:
        """
        Indicates if cancel is allowed. Scheduled upgrade can be cancelled only if target version is not forced by service,  otherwise only reschedule allowed.
        """
        return pulumi.get(self, "is_cancel_allowed")

    @property
    @pulumi.getter(name="isRescheduleAllowed")
    def is_reschedule_allowed(self) -> bool:
        """
        Indicates if reschedule is allowed. Upgrade can be rescheduled postponed until the end of the service defined auto-upgrade period.
        """
        return pulumi.get(self, "is_reschedule_allowed")

    @property
    @pulumi.getter(name="isRollbackAllowed")
    def is_rollback_allowed(self) -> bool:
        """
        Indicates if rollback is allowed. In practice only the last upgrade can be rolled back.
        * Manual upgrade is allowed to rollback only until the old version isn't deprecated yet.
        * Automatic upgrade by default is not allowed, unless a serious issue does not justify.
        """
        return pulumi.get(self, "is_rollback_allowed")

    @property
    @pulumi.getter(name="isSecurityFix")
    def is_security_fix(self) -> bool:
        """
        Indicates if OGG release contains security fix.
        """
        return pulumi.get(self, "is_security_fix")

    @property
    @pulumi.getter(name="isSnoozed")
    def is_snoozed(self) -> bool:
        """
        Indicates if upgrade notifications are snoozed or not.
        """
        return pulumi.get(self, "is_snoozed")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Describes the object's current state in detail. For example, it can be used to provide actionable information for a resource in a Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="lifecycleSubState")
    def lifecycle_sub_state(self) -> str:
        """
        Possible GGS lifecycle sub-states.
        """
        return pulumi.get(self, "lifecycle_sub_state")

    @property
    @pulumi.getter(name="oggVersion")
    def ogg_version(self) -> str:
        """
        Version of OGG
        """
        return pulumi.get(self, "ogg_version")

    @property
    @pulumi.getter(name="previousOggVersion")
    def previous_ogg_version(self) -> str:
        """
        Version of OGG
        """
        return pulumi.get(self, "previous_ogg_version")

    @property
    @pulumi.getter(name="releaseType")
    def release_type(self) -> str:
        """
        The type of release.
        """
        return pulumi.get(self, "release_type")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only the resources that match the 'lifecycleState' given.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle Cloud Infrastructure services. Each key is predefined and scoped to namespaces.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the resource was created. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> str:
        """
        The date and time the request was finished. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_finished")

    @property
    @pulumi.getter(name="timeOggVersionSupportedUntil")
    def time_ogg_version_supported_until(self) -> str:
        """
        The time until OGG version is supported. After this date has passed OGG version will not be available anymore. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_ogg_version_supported_until")

    @property
    @pulumi.getter(name="timeReleased")
    def time_released(self) -> str:
        """
        The time the resource was released. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_released")

    @property
    @pulumi.getter(name="timeSchedule")
    def time_schedule(self) -> str:
        """
        The time of upgrade schedule. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_schedule")

    @property
    @pulumi.getter(name="timeScheduleMax")
    def time_schedule_max(self) -> str:
        """
        Indicates the latest time until the deployment upgrade could be rescheduled. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_schedule_max")

    @property
    @pulumi.getter(name="timeSnoozedUntil")
    def time_snoozed_until(self) -> str:
        """
        The time the upgrade notifications are snoozed until. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_snoozed_until")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> str:
        """
        The date and time the request was started. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_started")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetDeploymentUpgradesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetDeploymentUpgradesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDeploymentVersionsDeploymentVersionCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDeploymentVersionsDeploymentVersionCollectionItemResult']):
        """
        :param Sequence['GetDeploymentVersionsDeploymentVersionCollectionItemArgs'] items: Array of DeploymentVersionSummary.
        """
        GetDeploymentVersionsDeploymentVersionCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetDeploymentVersionsDeploymentVersionCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDeploymentVersionsDeploymentVersionCollectionItemResult']:
        """
        Array of DeploymentVersionSummary.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDeploymentVersionsDeploymentVersionCollectionItemResult(dict):
    def __init__(__self__, *,
                 deployment_type: str,
                 is_security_fix: bool,
                 ogg_version: str,
                 release_type: str,
                 time_released: str,
                 time_supported_until: str):
        """
        :param str deployment_type: The type of deployment, the value determines the exact 'type' of the service executed in the deployment. Default value is DATABASE_ORACLE.
        :param bool is_security_fix: Indicates if OGG release contains security fix.
        :param str ogg_version: Version of OGG
        :param str release_type: The type of release.
        :param str time_released: The time the resource was released. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param str time_supported_until: The time until OGG version is supported. After this date has passed OGG version will not be available anymore. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        GetDeploymentVersionsDeploymentVersionCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            deployment_type=deployment_type,
            is_security_fix=is_security_fix,
            ogg_version=ogg_version,
            release_type=release_type,
            time_released=time_released,
            time_supported_until=time_supported_until,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             deployment_type: str,
             is_security_fix: bool,
             ogg_version: str,
             release_type: str,
             time_released: str,
             time_supported_until: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'deploymentType' in kwargs:
            deployment_type = kwargs['deploymentType']
        if 'isSecurityFix' in kwargs:
            is_security_fix = kwargs['isSecurityFix']
        if 'oggVersion' in kwargs:
            ogg_version = kwargs['oggVersion']
        if 'releaseType' in kwargs:
            release_type = kwargs['releaseType']
        if 'timeReleased' in kwargs:
            time_released = kwargs['timeReleased']
        if 'timeSupportedUntil' in kwargs:
            time_supported_until = kwargs['timeSupportedUntil']

        _setter("deployment_type", deployment_type)
        _setter("is_security_fix", is_security_fix)
        _setter("ogg_version", ogg_version)
        _setter("release_type", release_type)
        _setter("time_released", time_released)
        _setter("time_supported_until", time_supported_until)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> str:
        """
        The type of deployment, the value determines the exact 'type' of the service executed in the deployment. Default value is DATABASE_ORACLE.
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter(name="isSecurityFix")
    def is_security_fix(self) -> bool:
        """
        Indicates if OGG release contains security fix.
        """
        return pulumi.get(self, "is_security_fix")

    @property
    @pulumi.getter(name="oggVersion")
    def ogg_version(self) -> str:
        """
        Version of OGG
        """
        return pulumi.get(self, "ogg_version")

    @property
    @pulumi.getter(name="releaseType")
    def release_type(self) -> str:
        """
        The type of release.
        """
        return pulumi.get(self, "release_type")

    @property
    @pulumi.getter(name="timeReleased")
    def time_released(self) -> str:
        """
        The time the resource was released. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_released")

    @property
    @pulumi.getter(name="timeSupportedUntil")
    def time_supported_until(self) -> str:
        """
        The time until OGG version is supported. After this date has passed OGG version will not be available anymore. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_supported_until")


@pulumi.output_type
class GetDeploymentVersionsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetDeploymentVersionsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDeploymentsDeploymentCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDeploymentsDeploymentCollectionItemResult']):
        GetDeploymentsDeploymentCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetDeploymentsDeploymentCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDeploymentsDeploymentCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDeploymentsDeploymentCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 cpu_core_count: int,
                 defined_tags: Mapping[str, Any],
                 deployment_backup_id: str,
                 deployment_diagnostic_datas: Sequence['outputs.GetDeploymentsDeploymentCollectionItemDeploymentDiagnosticDataResult'],
                 deployment_type: str,
                 deployment_url: str,
                 description: str,
                 display_name: str,
                 fqdn: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 is_auto_scaling_enabled: bool,
                 is_healthy: bool,
                 is_latest_version: bool,
                 is_public: bool,
                 is_storage_utilization_limit_exceeded: bool,
                 license_model: str,
                 lifecycle_details: str,
                 lifecycle_sub_state: str,
                 maintenance_configurations: Sequence['outputs.GetDeploymentsDeploymentCollectionItemMaintenanceConfigurationResult'],
                 maintenance_windows: Sequence['outputs.GetDeploymentsDeploymentCollectionItemMaintenanceWindowResult'],
                 next_maintenance_action_type: str,
                 next_maintenance_description: str,
                 nsg_ids: Sequence[str],
                 ogg_datas: Sequence['outputs.GetDeploymentsDeploymentCollectionItemOggDataResult'],
                 private_ip_address: str,
                 public_ip_address: str,
                 state: str,
                 storage_utilization_in_bytes: str,
                 subnet_id: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_of_next_maintenance: str,
                 time_ogg_version_supported_until: str,
                 time_updated: str,
                 time_upgrade_required: str):
        """
        :param str compartment_id: The OCID of the compartment that contains the work request. Work requests should be scoped  to the same compartment as the resource the work request affects. If the work request concerns  multiple resources, and those resources are not in the same compartment, it is up to the service team  to pick the primary resource whose compartment should be used.
        :param int cpu_core_count: The Minimum number of OCPUs to be made available for this Deployment.
        :param Mapping[str, Any] defined_tags: Tags defined for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace.bar-key": "value"}`
        :param str deployment_backup_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup being referenced.
        :param Sequence['GetDeploymentsDeploymentCollectionItemDeploymentDiagnosticDataArgs'] deployment_diagnostic_datas: Information regarding the deployment diagnostic collection
        :param str deployment_type: The type of deployment, which can be any one of the Allowed values.  NOTE: Use of the value 'OGG' is maintained for backward compatibility purposes.  Its use is discouraged in favor of 'DATABASE_ORACLE'.
        :param str deployment_url: The URL of a resource.
        :param str description: Metadata about this specific object.
        :param str display_name: A filter to return only the resources that match the entire 'displayName' given.
        :param str fqdn: A filter to return only the resources that match the 'fqdn' given.
        :param Mapping[str, Any] freeform_tags: A simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deployment being referenced.
        :param bool is_auto_scaling_enabled: Indicates if auto scaling is enabled for the Deployment's CPU core count.
        :param bool is_healthy: True if all of the aggregate resources are working correctly.
        :param bool is_latest_version: Indicates if the resource is the the latest available version.
        :param bool is_public: True if this object is publicly available.
        :param bool is_storage_utilization_limit_exceeded: Indicator will be true if the amount of storage being utilized exceeds the allowable storage utilization limit.  Exceeding the limit may be an indication of a misconfiguration of the deployment's GoldenGate service.
        :param str license_model: The Oracle license model that applies to a Deployment.
        :param str lifecycle_details: Describes the object's current state in detail. For example, it can be used to provide actionable information for a resource in a Failed state.
        :param str lifecycle_sub_state: A filter to return only the resources that match the 'lifecycleSubState' given.
        :param Sequence['GetDeploymentsDeploymentCollectionItemMaintenanceConfigurationArgs'] maintenance_configurations: Attributes for configuring automatic deployment maintenance.
        :param Sequence['GetDeploymentsDeploymentCollectionItemMaintenanceWindowArgs'] maintenance_windows: Defines the maintenance window, when automatic actions can be performed.
        :param str next_maintenance_action_type: Type of the next maintenance.
        :param str next_maintenance_description: Description of the next maintenance.
        :param Sequence[str] nsg_ids: An array of Network Security Group OCIDs used to define network access for either Deployments or Connections.
        :param Sequence['GetDeploymentsDeploymentCollectionItemOggDataArgs'] ogg_datas: Deployment Data for an OggDeployment
        :param str private_ip_address: The private IP address in the customer's VCN representing the access point for the associated endpoint service in the GoldenGate service VCN.
        :param str public_ip_address: The public IP address representing the access point for the Deployment.
        :param str state: A filter to return only the resources that match the 'lifecycleState' given.
        :param str storage_utilization_in_bytes: The amount of storage being utilized (in bytes)
        :param str subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet being referenced.
        :param Mapping[str, Any] system_tags: The system tags associated with this resource, if any. The system tags are set by Oracle Cloud Infrastructure services. Each key is predefined and scoped to namespaces.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{orcl-cloud: {free-tier-retain: true}}`
        :param str time_created: The time the resource was created. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param str time_of_next_maintenance: The time of next maintenance schedule. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param str time_ogg_version_supported_until: The time until OGG version is supported. After this date has passed OGG version will not be available anymore. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param str time_updated: The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param str time_upgrade_required: Note: Deprecated: Use timeOfNextMaintenance instead, or related upgrade records  to check, when deployment will be forced to upgrade to a newer version. Old description: The date the existing version in use will no longer be considered as usable and an upgrade will be required.  This date is typically 6 months after the version was released for use by GGS.  The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        GetDeploymentsDeploymentCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            cpu_core_count=cpu_core_count,
            defined_tags=defined_tags,
            deployment_backup_id=deployment_backup_id,
            deployment_diagnostic_datas=deployment_diagnostic_datas,
            deployment_type=deployment_type,
            deployment_url=deployment_url,
            description=description,
            display_name=display_name,
            fqdn=fqdn,
            freeform_tags=freeform_tags,
            id=id,
            is_auto_scaling_enabled=is_auto_scaling_enabled,
            is_healthy=is_healthy,
            is_latest_version=is_latest_version,
            is_public=is_public,
            is_storage_utilization_limit_exceeded=is_storage_utilization_limit_exceeded,
            license_model=license_model,
            lifecycle_details=lifecycle_details,
            lifecycle_sub_state=lifecycle_sub_state,
            maintenance_configurations=maintenance_configurations,
            maintenance_windows=maintenance_windows,
            next_maintenance_action_type=next_maintenance_action_type,
            next_maintenance_description=next_maintenance_description,
            nsg_ids=nsg_ids,
            ogg_datas=ogg_datas,
            private_ip_address=private_ip_address,
            public_ip_address=public_ip_address,
            state=state,
            storage_utilization_in_bytes=storage_utilization_in_bytes,
            subnet_id=subnet_id,
            system_tags=system_tags,
            time_created=time_created,
            time_of_next_maintenance=time_of_next_maintenance,
            time_ogg_version_supported_until=time_ogg_version_supported_until,
            time_updated=time_updated,
            time_upgrade_required=time_upgrade_required,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             cpu_core_count: int,
             defined_tags: Mapping[str, Any],
             deployment_backup_id: str,
             deployment_diagnostic_datas: Sequence['outputs.GetDeploymentsDeploymentCollectionItemDeploymentDiagnosticDataResult'],
             deployment_type: str,
             deployment_url: str,
             description: str,
             display_name: str,
             fqdn: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             is_auto_scaling_enabled: bool,
             is_healthy: bool,
             is_latest_version: bool,
             is_public: bool,
             is_storage_utilization_limit_exceeded: bool,
             license_model: str,
             lifecycle_details: str,
             lifecycle_sub_state: str,
             maintenance_configurations: Sequence['outputs.GetDeploymentsDeploymentCollectionItemMaintenanceConfigurationResult'],
             maintenance_windows: Sequence['outputs.GetDeploymentsDeploymentCollectionItemMaintenanceWindowResult'],
             next_maintenance_action_type: str,
             next_maintenance_description: str,
             nsg_ids: Sequence[str],
             ogg_datas: Sequence['outputs.GetDeploymentsDeploymentCollectionItemOggDataResult'],
             private_ip_address: str,
             public_ip_address: str,
             state: str,
             storage_utilization_in_bytes: str,
             subnet_id: str,
             system_tags: Mapping[str, Any],
             time_created: str,
             time_of_next_maintenance: str,
             time_ogg_version_supported_until: str,
             time_updated: str,
             time_upgrade_required: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'cpuCoreCount' in kwargs:
            cpu_core_count = kwargs['cpuCoreCount']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'deploymentBackupId' in kwargs:
            deployment_backup_id = kwargs['deploymentBackupId']
        if 'deploymentDiagnosticDatas' in kwargs:
            deployment_diagnostic_datas = kwargs['deploymentDiagnosticDatas']
        if 'deploymentType' in kwargs:
            deployment_type = kwargs['deploymentType']
        if 'deploymentUrl' in kwargs:
            deployment_url = kwargs['deploymentUrl']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'isAutoScalingEnabled' in kwargs:
            is_auto_scaling_enabled = kwargs['isAutoScalingEnabled']
        if 'isHealthy' in kwargs:
            is_healthy = kwargs['isHealthy']
        if 'isLatestVersion' in kwargs:
            is_latest_version = kwargs['isLatestVersion']
        if 'isPublic' in kwargs:
            is_public = kwargs['isPublic']
        if 'isStorageUtilizationLimitExceeded' in kwargs:
            is_storage_utilization_limit_exceeded = kwargs['isStorageUtilizationLimitExceeded']
        if 'licenseModel' in kwargs:
            license_model = kwargs['licenseModel']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'lifecycleSubState' in kwargs:
            lifecycle_sub_state = kwargs['lifecycleSubState']
        if 'maintenanceConfigurations' in kwargs:
            maintenance_configurations = kwargs['maintenanceConfigurations']
        if 'maintenanceWindows' in kwargs:
            maintenance_windows = kwargs['maintenanceWindows']
        if 'nextMaintenanceActionType' in kwargs:
            next_maintenance_action_type = kwargs['nextMaintenanceActionType']
        if 'nextMaintenanceDescription' in kwargs:
            next_maintenance_description = kwargs['nextMaintenanceDescription']
        if 'nsgIds' in kwargs:
            nsg_ids = kwargs['nsgIds']
        if 'oggDatas' in kwargs:
            ogg_datas = kwargs['oggDatas']
        if 'privateIpAddress' in kwargs:
            private_ip_address = kwargs['privateIpAddress']
        if 'publicIpAddress' in kwargs:
            public_ip_address = kwargs['publicIpAddress']
        if 'storageUtilizationInBytes' in kwargs:
            storage_utilization_in_bytes = kwargs['storageUtilizationInBytes']
        if 'subnetId' in kwargs:
            subnet_id = kwargs['subnetId']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeOfNextMaintenance' in kwargs:
            time_of_next_maintenance = kwargs['timeOfNextMaintenance']
        if 'timeOggVersionSupportedUntil' in kwargs:
            time_ogg_version_supported_until = kwargs['timeOggVersionSupportedUntil']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']
        if 'timeUpgradeRequired' in kwargs:
            time_upgrade_required = kwargs['timeUpgradeRequired']

        _setter("compartment_id", compartment_id)
        _setter("cpu_core_count", cpu_core_count)
        _setter("defined_tags", defined_tags)
        _setter("deployment_backup_id", deployment_backup_id)
        _setter("deployment_diagnostic_datas", deployment_diagnostic_datas)
        _setter("deployment_type", deployment_type)
        _setter("deployment_url", deployment_url)
        _setter("description", description)
        _setter("display_name", display_name)
        _setter("fqdn", fqdn)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("is_auto_scaling_enabled", is_auto_scaling_enabled)
        _setter("is_healthy", is_healthy)
        _setter("is_latest_version", is_latest_version)
        _setter("is_public", is_public)
        _setter("is_storage_utilization_limit_exceeded", is_storage_utilization_limit_exceeded)
        _setter("license_model", license_model)
        _setter("lifecycle_details", lifecycle_details)
        _setter("lifecycle_sub_state", lifecycle_sub_state)
        _setter("maintenance_configurations", maintenance_configurations)
        _setter("maintenance_windows", maintenance_windows)
        _setter("next_maintenance_action_type", next_maintenance_action_type)
        _setter("next_maintenance_description", next_maintenance_description)
        _setter("nsg_ids", nsg_ids)
        _setter("ogg_datas", ogg_datas)
        _setter("private_ip_address", private_ip_address)
        _setter("public_ip_address", public_ip_address)
        _setter("state", state)
        _setter("storage_utilization_in_bytes", storage_utilization_in_bytes)
        _setter("subnet_id", subnet_id)
        _setter("system_tags", system_tags)
        _setter("time_created", time_created)
        _setter("time_of_next_maintenance", time_of_next_maintenance)
        _setter("time_ogg_version_supported_until", time_ogg_version_supported_until)
        _setter("time_updated", time_updated)
        _setter("time_upgrade_required", time_upgrade_required)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the work request. Work requests should be scoped  to the same compartment as the resource the work request affects. If the work request concerns  multiple resources, and those resources are not in the same compartment, it is up to the service team  to pick the primary resource whose compartment should be used.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> int:
        """
        The Minimum number of OCPUs to be made available for this Deployment.
        """
        return pulumi.get(self, "cpu_core_count")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Tags defined for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="deploymentBackupId")
    def deployment_backup_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup being referenced.
        """
        return pulumi.get(self, "deployment_backup_id")

    @property
    @pulumi.getter(name="deploymentDiagnosticDatas")
    def deployment_diagnostic_datas(self) -> Sequence['outputs.GetDeploymentsDeploymentCollectionItemDeploymentDiagnosticDataResult']:
        """
        Information regarding the deployment diagnostic collection
        """
        return pulumi.get(self, "deployment_diagnostic_datas")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> str:
        """
        The type of deployment, which can be any one of the Allowed values.  NOTE: Use of the value 'OGG' is maintained for backward compatibility purposes.  Its use is discouraged in favor of 'DATABASE_ORACLE'.
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter(name="deploymentUrl")
    def deployment_url(self) -> str:
        """
        The URL of a resource.
        """
        return pulumi.get(self, "deployment_url")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Metadata about this specific object.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only the resources that match the entire 'displayName' given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def fqdn(self) -> str:
        """
        A filter to return only the resources that match the 'fqdn' given.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        A simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deployment being referenced.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAutoScalingEnabled")
    def is_auto_scaling_enabled(self) -> bool:
        """
        Indicates if auto scaling is enabled for the Deployment's CPU core count.
        """
        return pulumi.get(self, "is_auto_scaling_enabled")

    @property
    @pulumi.getter(name="isHealthy")
    def is_healthy(self) -> bool:
        """
        True if all of the aggregate resources are working correctly.
        """
        return pulumi.get(self, "is_healthy")

    @property
    @pulumi.getter(name="isLatestVersion")
    def is_latest_version(self) -> bool:
        """
        Indicates if the resource is the the latest available version.
        """
        return pulumi.get(self, "is_latest_version")

    @property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> bool:
        """
        True if this object is publicly available.
        """
        return pulumi.get(self, "is_public")

    @property
    @pulumi.getter(name="isStorageUtilizationLimitExceeded")
    def is_storage_utilization_limit_exceeded(self) -> bool:
        """
        Indicator will be true if the amount of storage being utilized exceeds the allowable storage utilization limit.  Exceeding the limit may be an indication of a misconfiguration of the deployment's GoldenGate service.
        """
        return pulumi.get(self, "is_storage_utilization_limit_exceeded")

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> str:
        """
        The Oracle license model that applies to a Deployment.
        """
        return pulumi.get(self, "license_model")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Describes the object's current state in detail. For example, it can be used to provide actionable information for a resource in a Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="lifecycleSubState")
    def lifecycle_sub_state(self) -> str:
        """
        A filter to return only the resources that match the 'lifecycleSubState' given.
        """
        return pulumi.get(self, "lifecycle_sub_state")

    @property
    @pulumi.getter(name="maintenanceConfigurations")
    def maintenance_configurations(self) -> Sequence['outputs.GetDeploymentsDeploymentCollectionItemMaintenanceConfigurationResult']:
        """
        Attributes for configuring automatic deployment maintenance.
        """
        return pulumi.get(self, "maintenance_configurations")

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Sequence['outputs.GetDeploymentsDeploymentCollectionItemMaintenanceWindowResult']:
        """
        Defines the maintenance window, when automatic actions can be performed.
        """
        return pulumi.get(self, "maintenance_windows")

    @property
    @pulumi.getter(name="nextMaintenanceActionType")
    def next_maintenance_action_type(self) -> str:
        """
        Type of the next maintenance.
        """
        return pulumi.get(self, "next_maintenance_action_type")

    @property
    @pulumi.getter(name="nextMaintenanceDescription")
    def next_maintenance_description(self) -> str:
        """
        Description of the next maintenance.
        """
        return pulumi.get(self, "next_maintenance_description")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[str]:
        """
        An array of Network Security Group OCIDs used to define network access for either Deployments or Connections.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="oggDatas")
    def ogg_datas(self) -> Sequence['outputs.GetDeploymentsDeploymentCollectionItemOggDataResult']:
        """
        Deployment Data for an OggDeployment
        """
        return pulumi.get(self, "ogg_datas")

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> str:
        """
        The private IP address in the customer's VCN representing the access point for the associated endpoint service in the GoldenGate service VCN.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> str:
        """
        The public IP address representing the access point for the Deployment.
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only the resources that match the 'lifecycleState' given.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageUtilizationInBytes")
    def storage_utilization_in_bytes(self) -> str:
        """
        The amount of storage being utilized (in bytes)
        """
        return pulumi.get(self, "storage_utilization_in_bytes")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet being referenced.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle Cloud Infrastructure services. Each key is predefined and scoped to namespaces.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the resource was created. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeOfNextMaintenance")
    def time_of_next_maintenance(self) -> str:
        """
        The time of next maintenance schedule. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_of_next_maintenance")

    @property
    @pulumi.getter(name="timeOggVersionSupportedUntil")
    def time_ogg_version_supported_until(self) -> str:
        """
        The time until OGG version is supported. After this date has passed OGG version will not be available anymore. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_ogg_version_supported_until")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="timeUpgradeRequired")
    def time_upgrade_required(self) -> str:
        """
        Note: Deprecated: Use timeOfNextMaintenance instead, or related upgrade records  to check, when deployment will be forced to upgrade to a newer version. Old description: The date the existing version in use will no longer be considered as usable and an upgrade will be required.  This date is typically 6 months after the version was released for use by GGS.  The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_upgrade_required")


@pulumi.output_type
class GetDeploymentsDeploymentCollectionItemDeploymentDiagnosticDataResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 diagnostic_state: str,
                 namespace: str,
                 object: str,
                 time_diagnostic_end: str,
                 time_diagnostic_start: str):
        """
        :param str bucket: Name of the bucket where the object is to be uploaded in the object storage
        :param str diagnostic_state: The state of the deployment diagnostic collection.
        :param str namespace: Name of namespace that serves as a container for all of your buckets
        :param str object: Name of the diagnostic collected and uploaded to object storage
        :param str time_diagnostic_end: The time until which the diagnostic collection should collect the logs. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param str time_diagnostic_start: The time from which the diagnostic collection should collect the logs. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        GetDeploymentsDeploymentCollectionItemDeploymentDiagnosticDataResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            diagnostic_state=diagnostic_state,
            namespace=namespace,
            object=object,
            time_diagnostic_end=time_diagnostic_end,
            time_diagnostic_start=time_diagnostic_start,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: str,
             diagnostic_state: str,
             namespace: str,
             object: str,
             time_diagnostic_end: str,
             time_diagnostic_start: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'diagnosticState' in kwargs:
            diagnostic_state = kwargs['diagnosticState']
        if 'timeDiagnosticEnd' in kwargs:
            time_diagnostic_end = kwargs['timeDiagnosticEnd']
        if 'timeDiagnosticStart' in kwargs:
            time_diagnostic_start = kwargs['timeDiagnosticStart']

        _setter("bucket", bucket)
        _setter("diagnostic_state", diagnostic_state)
        _setter("namespace", namespace)
        _setter("object", object)
        _setter("time_diagnostic_end", time_diagnostic_end)
        _setter("time_diagnostic_start", time_diagnostic_start)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Name of the bucket where the object is to be uploaded in the object storage
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="diagnosticState")
    def diagnostic_state(self) -> str:
        """
        The state of the deployment diagnostic collection.
        """
        return pulumi.get(self, "diagnostic_state")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Name of namespace that serves as a container for all of your buckets
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Name of the diagnostic collected and uploaded to object storage
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="timeDiagnosticEnd")
    def time_diagnostic_end(self) -> str:
        """
        The time until which the diagnostic collection should collect the logs. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_diagnostic_end")

    @property
    @pulumi.getter(name="timeDiagnosticStart")
    def time_diagnostic_start(self) -> str:
        """
        The time from which the diagnostic collection should collect the logs. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_diagnostic_start")


@pulumi.output_type
class GetDeploymentsDeploymentCollectionItemMaintenanceConfigurationResult(dict):
    def __init__(__self__, *,
                 bundle_release_upgrade_period_in_days: int,
                 interim_release_upgrade_period_in_days: int,
                 is_interim_release_auto_upgrade_enabled: bool,
                 major_release_upgrade_period_in_days: int,
                 security_patch_upgrade_period_in_days: int):
        """
        :param int bundle_release_upgrade_period_in_days: Defines auto upgrade period for bundle releases. Manually configured period cannot be longer than service defined period for bundle releases. This period must be shorter or equal to major release upgrade period. Not passing this field during create will equate to using the service default.
        :param int interim_release_upgrade_period_in_days: Defines auto upgrade period for interim releases. This period must be shorter or equal to bundle release upgrade period.
        :param bool is_interim_release_auto_upgrade_enabled: By default auto upgrade for interim releases are not enabled. If auto-upgrade is enabled for interim release,  you have to specify interimReleaseUpgradePeriodInDays too.
        :param int major_release_upgrade_period_in_days: Defines auto upgrade period for major releases. Manually configured period cannot be longer than service defined period for major releases. Not passing this field during create will equate to using the service default.
        :param int security_patch_upgrade_period_in_days: Defines auto upgrade period for releases with security fix. Manually configured period cannot be longer than service defined period for security releases. Not passing this field during create will equate to using the service default.
        """
        GetDeploymentsDeploymentCollectionItemMaintenanceConfigurationResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bundle_release_upgrade_period_in_days=bundle_release_upgrade_period_in_days,
            interim_release_upgrade_period_in_days=interim_release_upgrade_period_in_days,
            is_interim_release_auto_upgrade_enabled=is_interim_release_auto_upgrade_enabled,
            major_release_upgrade_period_in_days=major_release_upgrade_period_in_days,
            security_patch_upgrade_period_in_days=security_patch_upgrade_period_in_days,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bundle_release_upgrade_period_in_days: int,
             interim_release_upgrade_period_in_days: int,
             is_interim_release_auto_upgrade_enabled: bool,
             major_release_upgrade_period_in_days: int,
             security_patch_upgrade_period_in_days: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'bundleReleaseUpgradePeriodInDays' in kwargs:
            bundle_release_upgrade_period_in_days = kwargs['bundleReleaseUpgradePeriodInDays']
        if 'interimReleaseUpgradePeriodInDays' in kwargs:
            interim_release_upgrade_period_in_days = kwargs['interimReleaseUpgradePeriodInDays']
        if 'isInterimReleaseAutoUpgradeEnabled' in kwargs:
            is_interim_release_auto_upgrade_enabled = kwargs['isInterimReleaseAutoUpgradeEnabled']
        if 'majorReleaseUpgradePeriodInDays' in kwargs:
            major_release_upgrade_period_in_days = kwargs['majorReleaseUpgradePeriodInDays']
        if 'securityPatchUpgradePeriodInDays' in kwargs:
            security_patch_upgrade_period_in_days = kwargs['securityPatchUpgradePeriodInDays']

        _setter("bundle_release_upgrade_period_in_days", bundle_release_upgrade_period_in_days)
        _setter("interim_release_upgrade_period_in_days", interim_release_upgrade_period_in_days)
        _setter("is_interim_release_auto_upgrade_enabled", is_interim_release_auto_upgrade_enabled)
        _setter("major_release_upgrade_period_in_days", major_release_upgrade_period_in_days)
        _setter("security_patch_upgrade_period_in_days", security_patch_upgrade_period_in_days)

    @property
    @pulumi.getter(name="bundleReleaseUpgradePeriodInDays")
    def bundle_release_upgrade_period_in_days(self) -> int:
        """
        Defines auto upgrade period for bundle releases. Manually configured period cannot be longer than service defined period for bundle releases. This period must be shorter or equal to major release upgrade period. Not passing this field during create will equate to using the service default.
        """
        return pulumi.get(self, "bundle_release_upgrade_period_in_days")

    @property
    @pulumi.getter(name="interimReleaseUpgradePeriodInDays")
    def interim_release_upgrade_period_in_days(self) -> int:
        """
        Defines auto upgrade period for interim releases. This period must be shorter or equal to bundle release upgrade period.
        """
        return pulumi.get(self, "interim_release_upgrade_period_in_days")

    @property
    @pulumi.getter(name="isInterimReleaseAutoUpgradeEnabled")
    def is_interim_release_auto_upgrade_enabled(self) -> bool:
        """
        By default auto upgrade for interim releases are not enabled. If auto-upgrade is enabled for interim release,  you have to specify interimReleaseUpgradePeriodInDays too.
        """
        return pulumi.get(self, "is_interim_release_auto_upgrade_enabled")

    @property
    @pulumi.getter(name="majorReleaseUpgradePeriodInDays")
    def major_release_upgrade_period_in_days(self) -> int:
        """
        Defines auto upgrade period for major releases. Manually configured period cannot be longer than service defined period for major releases. Not passing this field during create will equate to using the service default.
        """
        return pulumi.get(self, "major_release_upgrade_period_in_days")

    @property
    @pulumi.getter(name="securityPatchUpgradePeriodInDays")
    def security_patch_upgrade_period_in_days(self) -> int:
        """
        Defines auto upgrade period for releases with security fix. Manually configured period cannot be longer than service defined period for security releases. Not passing this field during create will equate to using the service default.
        """
        return pulumi.get(self, "security_patch_upgrade_period_in_days")


@pulumi.output_type
class GetDeploymentsDeploymentCollectionItemMaintenanceWindowResult(dict):
    def __init__(__self__, *,
                 day: str,
                 start_hour: int):
        """
        :param str day: Days of the week.
        :param int start_hour: Start hour for maintenance period. Hour is in UTC.
        """
        GetDeploymentsDeploymentCollectionItemMaintenanceWindowResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            day=day,
            start_hour=start_hour,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             day: str,
             start_hour: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'startHour' in kwargs:
            start_hour = kwargs['startHour']

        _setter("day", day)
        _setter("start_hour", start_hour)

    @property
    @pulumi.getter
    def day(self) -> str:
        """
        Days of the week.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter(name="startHour")
    def start_hour(self) -> int:
        """
        Start hour for maintenance period. Hour is in UTC.
        """
        return pulumi.get(self, "start_hour")


@pulumi.output_type
class GetDeploymentsDeploymentCollectionItemOggDataResult(dict):
    def __init__(__self__, *,
                 admin_password: str,
                 admin_username: str,
                 certificate: str,
                 credential_store: str,
                 deployment_name: str,
                 identity_domain_id: str,
                 key: str,
                 ogg_version: str,
                 password_secret_id: str):
        """
        :param str admin_username: The GoldenGate deployment console username.
        :param str certificate: A PEM-encoded SSL certificate.
        :param str credential_store: The type of credential store for OGG.
        :param str deployment_name: The name given to the GoldenGate service deployment. The name must be 1 to 32 characters long, must contain only alphanumeric characters and must start with a letter.
        :param str identity_domain_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Identity Domain when IAM credential store is used.
        :param str ogg_version: Version of OGG
        :param str password_secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Secret where the deployment password is stored.
        """
        GetDeploymentsDeploymentCollectionItemOggDataResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            admin_password=admin_password,
            admin_username=admin_username,
            certificate=certificate,
            credential_store=credential_store,
            deployment_name=deployment_name,
            identity_domain_id=identity_domain_id,
            key=key,
            ogg_version=ogg_version,
            password_secret_id=password_secret_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             admin_password: str,
             admin_username: str,
             certificate: str,
             credential_store: str,
             deployment_name: str,
             identity_domain_id: str,
             key: str,
             ogg_version: str,
             password_secret_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'adminPassword' in kwargs:
            admin_password = kwargs['adminPassword']
        if 'adminUsername' in kwargs:
            admin_username = kwargs['adminUsername']
        if 'credentialStore' in kwargs:
            credential_store = kwargs['credentialStore']
        if 'deploymentName' in kwargs:
            deployment_name = kwargs['deploymentName']
        if 'identityDomainId' in kwargs:
            identity_domain_id = kwargs['identityDomainId']
        if 'oggVersion' in kwargs:
            ogg_version = kwargs['oggVersion']
        if 'passwordSecretId' in kwargs:
            password_secret_id = kwargs['passwordSecretId']

        _setter("admin_password", admin_password)
        _setter("admin_username", admin_username)
        _setter("certificate", certificate)
        _setter("credential_store", credential_store)
        _setter("deployment_name", deployment_name)
        _setter("identity_domain_id", identity_domain_id)
        _setter("key", key)
        _setter("ogg_version", ogg_version)
        _setter("password_secret_id", password_secret_id)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> str:
        return pulumi.get(self, "admin_password")

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> str:
        """
        The GoldenGate deployment console username.
        """
        return pulumi.get(self, "admin_username")

    @property
    @pulumi.getter
    def certificate(self) -> str:
        """
        A PEM-encoded SSL certificate.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="credentialStore")
    def credential_store(self) -> str:
        """
        The type of credential store for OGG.
        """
        return pulumi.get(self, "credential_store")

    @property
    @pulumi.getter(name="deploymentName")
    def deployment_name(self) -> str:
        """
        The name given to the GoldenGate service deployment. The name must be 1 to 32 characters long, must contain only alphanumeric characters and must start with a letter.
        """
        return pulumi.get(self, "deployment_name")

    @property
    @pulumi.getter(name="identityDomainId")
    def identity_domain_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Identity Domain when IAM credential store is used.
        """
        return pulumi.get(self, "identity_domain_id")

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="oggVersion")
    def ogg_version(self) -> str:
        """
        Version of OGG
        """
        return pulumi.get(self, "ogg_version")

    @property
    @pulumi.getter(name="passwordSecretId")
    def password_secret_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Secret where the deployment password is stored.
        """
        return pulumi.get(self, "password_secret_id")


@pulumi.output_type
class GetDeploymentsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetDeploymentsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetMessageItemResult(dict):
    def __init__(__self__, *,
                 deployment_message: str,
                 deployment_message_status: str,
                 id: str):
        """
        :param str deployment_message: The deployment Message in plain text with optional HTML anchor tags.
        :param str deployment_message_status: The deployment Message Status.
        :param str id: The deployment Message Id.
        """
        GetMessageItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            deployment_message=deployment_message,
            deployment_message_status=deployment_message_status,
            id=id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             deployment_message: str,
             deployment_message_status: str,
             id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'deploymentMessage' in kwargs:
            deployment_message = kwargs['deploymentMessage']
        if 'deploymentMessageStatus' in kwargs:
            deployment_message_status = kwargs['deploymentMessageStatus']

        _setter("deployment_message", deployment_message)
        _setter("deployment_message_status", deployment_message_status)
        _setter("id", id)

    @property
    @pulumi.getter(name="deploymentMessage")
    def deployment_message(self) -> str:
        """
        The deployment Message in plain text with optional HTML anchor tags.
        """
        return pulumi.get(self, "deployment_message")

    @property
    @pulumi.getter(name="deploymentMessageStatus")
    def deployment_message_status(self) -> str:
        """
        The deployment Message Status.
        """
        return pulumi.get(self, "deployment_message_status")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The deployment Message Id.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetMessagesDeploymentMessagesCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetMessagesDeploymentMessagesCollectionItemResult']):
        """
        :param Sequence['GetMessagesDeploymentMessagesCollectionItemArgs'] items: An array of DeploymentMessages.
        """
        GetMessagesDeploymentMessagesCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetMessagesDeploymentMessagesCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetMessagesDeploymentMessagesCollectionItemResult']:
        """
        An array of DeploymentMessages.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetMessagesDeploymentMessagesCollectionItemResult(dict):
    def __init__(__self__, *,
                 deployment_message: str,
                 deployment_message_status: str,
                 id: str):
        """
        :param str deployment_message: The deployment Message in plain text with optional HTML anchor tags.
        :param str deployment_message_status: The deployment Message Status.
        :param str id: The deployment Message Id.
        """
        GetMessagesDeploymentMessagesCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            deployment_message=deployment_message,
            deployment_message_status=deployment_message_status,
            id=id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             deployment_message: str,
             deployment_message_status: str,
             id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'deploymentMessage' in kwargs:
            deployment_message = kwargs['deploymentMessage']
        if 'deploymentMessageStatus' in kwargs:
            deployment_message_status = kwargs['deploymentMessageStatus']

        _setter("deployment_message", deployment_message)
        _setter("deployment_message_status", deployment_message_status)
        _setter("id", id)

    @property
    @pulumi.getter(name="deploymentMessage")
    def deployment_message(self) -> str:
        """
        The deployment Message in plain text with optional HTML anchor tags.
        """
        return pulumi.get(self, "deployment_message")

    @property
    @pulumi.getter(name="deploymentMessageStatus")
    def deployment_message_status(self) -> str:
        """
        The deployment Message Status.
        """
        return pulumi.get(self, "deployment_message_status")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The deployment Message Id.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetMessagesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetMessagesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetTrailFileItemResult(dict):
    def __init__(__self__, *,
                 consumers: Sequence[str],
                 display_name: str,
                 max_sequence_number: str,
                 min_sequence_number: str,
                 number_of_sequences: int,
                 producer: str,
                 size_in_bytes: float,
                 time_last_updated: str,
                 trail_file_id: str):
        """
        :param Sequence[str] consumers: array of consumer process names
        :param str display_name: A filter to return only the resources that match the entire 'displayName' given.
        :param str max_sequence_number: Maximum sequence number
        :param str min_sequence_number: Minimum sequence number
        :param int number_of_sequences: Number of sequences for a specific trail file
        :param str producer: Producer Process Name if any.
        :param float size_in_bytes: The size of the backup stored in object storage (in bytes)
        :param str time_last_updated: The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param str trail_file_id: A Trail File identifier
        """
        GetTrailFileItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            consumers=consumers,
            display_name=display_name,
            max_sequence_number=max_sequence_number,
            min_sequence_number=min_sequence_number,
            number_of_sequences=number_of_sequences,
            producer=producer,
            size_in_bytes=size_in_bytes,
            time_last_updated=time_last_updated,
            trail_file_id=trail_file_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             consumers: Sequence[str],
             display_name: str,
             max_sequence_number: str,
             min_sequence_number: str,
             number_of_sequences: int,
             producer: str,
             size_in_bytes: float,
             time_last_updated: str,
             trail_file_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'maxSequenceNumber' in kwargs:
            max_sequence_number = kwargs['maxSequenceNumber']
        if 'minSequenceNumber' in kwargs:
            min_sequence_number = kwargs['minSequenceNumber']
        if 'numberOfSequences' in kwargs:
            number_of_sequences = kwargs['numberOfSequences']
        if 'sizeInBytes' in kwargs:
            size_in_bytes = kwargs['sizeInBytes']
        if 'timeLastUpdated' in kwargs:
            time_last_updated = kwargs['timeLastUpdated']
        if 'trailFileId' in kwargs:
            trail_file_id = kwargs['trailFileId']

        _setter("consumers", consumers)
        _setter("display_name", display_name)
        _setter("max_sequence_number", max_sequence_number)
        _setter("min_sequence_number", min_sequence_number)
        _setter("number_of_sequences", number_of_sequences)
        _setter("producer", producer)
        _setter("size_in_bytes", size_in_bytes)
        _setter("time_last_updated", time_last_updated)
        _setter("trail_file_id", trail_file_id)

    @property
    @pulumi.getter
    def consumers(self) -> Sequence[str]:
        """
        array of consumer process names
        """
        return pulumi.get(self, "consumers")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only the resources that match the entire 'displayName' given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="maxSequenceNumber")
    def max_sequence_number(self) -> str:
        """
        Maximum sequence number
        """
        return pulumi.get(self, "max_sequence_number")

    @property
    @pulumi.getter(name="minSequenceNumber")
    def min_sequence_number(self) -> str:
        """
        Minimum sequence number
        """
        return pulumi.get(self, "min_sequence_number")

    @property
    @pulumi.getter(name="numberOfSequences")
    def number_of_sequences(self) -> int:
        """
        Number of sequences for a specific trail file
        """
        return pulumi.get(self, "number_of_sequences")

    @property
    @pulumi.getter
    def producer(self) -> str:
        """
        Producer Process Name if any.
        """
        return pulumi.get(self, "producer")

    @property
    @pulumi.getter(name="sizeInBytes")
    def size_in_bytes(self) -> float:
        """
        The size of the backup stored in object storage (in bytes)
        """
        return pulumi.get(self, "size_in_bytes")

    @property
    @pulumi.getter(name="timeLastUpdated")
    def time_last_updated(self) -> str:
        """
        The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_last_updated")

    @property
    @pulumi.getter(name="trailFileId")
    def trail_file_id(self) -> str:
        """
        A Trail File identifier
        """
        return pulumi.get(self, "trail_file_id")


@pulumi.output_type
class GetTrailFilesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetTrailFilesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetTrailFilesTrailFileCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetTrailFilesTrailFileCollectionItemResult'],
                 time_last_fetched: str):
        """
        :param Sequence['GetTrailFilesTrailFileCollectionItemArgs'] items: An array of TrailFiles.
        :param str time_last_fetched: The time the data was last fetched from the deployment. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        GetTrailFilesTrailFileCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
            time_last_fetched=time_last_fetched,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetTrailFilesTrailFileCollectionItemResult'],
             time_last_fetched: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'timeLastFetched' in kwargs:
            time_last_fetched = kwargs['timeLastFetched']

        _setter("items", items)
        _setter("time_last_fetched", time_last_fetched)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetTrailFilesTrailFileCollectionItemResult']:
        """
        An array of TrailFiles.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="timeLastFetched")
    def time_last_fetched(self) -> str:
        """
        The time the data was last fetched from the deployment. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_last_fetched")


@pulumi.output_type
class GetTrailFilesTrailFileCollectionItemResult(dict):
    def __init__(__self__, *,
                 consumers: Sequence[str],
                 display_name: str,
                 max_sequence_number: str,
                 min_sequence_number: str,
                 number_of_sequences: int,
                 producer: str,
                 size_in_bytes: float,
                 time_last_updated: str,
                 trail_file_id: str):
        """
        :param Sequence[str] consumers: array of consumer process names
        :param str display_name: A filter to return only the resources that match the entire 'displayName' given.
        :param str max_sequence_number: Maximum sequence number
        :param str min_sequence_number: Minimum sequence number
        :param int number_of_sequences: Number of sequences for a specific trail file
        :param str producer: Producer Process Name if any.
        :param float size_in_bytes: The size of the backup stored in object storage (in bytes)
        :param str time_last_updated: The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param str trail_file_id: A Trail File identifier
        """
        GetTrailFilesTrailFileCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            consumers=consumers,
            display_name=display_name,
            max_sequence_number=max_sequence_number,
            min_sequence_number=min_sequence_number,
            number_of_sequences=number_of_sequences,
            producer=producer,
            size_in_bytes=size_in_bytes,
            time_last_updated=time_last_updated,
            trail_file_id=trail_file_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             consumers: Sequence[str],
             display_name: str,
             max_sequence_number: str,
             min_sequence_number: str,
             number_of_sequences: int,
             producer: str,
             size_in_bytes: float,
             time_last_updated: str,
             trail_file_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'maxSequenceNumber' in kwargs:
            max_sequence_number = kwargs['maxSequenceNumber']
        if 'minSequenceNumber' in kwargs:
            min_sequence_number = kwargs['minSequenceNumber']
        if 'numberOfSequences' in kwargs:
            number_of_sequences = kwargs['numberOfSequences']
        if 'sizeInBytes' in kwargs:
            size_in_bytes = kwargs['sizeInBytes']
        if 'timeLastUpdated' in kwargs:
            time_last_updated = kwargs['timeLastUpdated']
        if 'trailFileId' in kwargs:
            trail_file_id = kwargs['trailFileId']

        _setter("consumers", consumers)
        _setter("display_name", display_name)
        _setter("max_sequence_number", max_sequence_number)
        _setter("min_sequence_number", min_sequence_number)
        _setter("number_of_sequences", number_of_sequences)
        _setter("producer", producer)
        _setter("size_in_bytes", size_in_bytes)
        _setter("time_last_updated", time_last_updated)
        _setter("trail_file_id", trail_file_id)

    @property
    @pulumi.getter
    def consumers(self) -> Sequence[str]:
        """
        array of consumer process names
        """
        return pulumi.get(self, "consumers")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only the resources that match the entire 'displayName' given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="maxSequenceNumber")
    def max_sequence_number(self) -> str:
        """
        Maximum sequence number
        """
        return pulumi.get(self, "max_sequence_number")

    @property
    @pulumi.getter(name="minSequenceNumber")
    def min_sequence_number(self) -> str:
        """
        Minimum sequence number
        """
        return pulumi.get(self, "min_sequence_number")

    @property
    @pulumi.getter(name="numberOfSequences")
    def number_of_sequences(self) -> int:
        """
        Number of sequences for a specific trail file
        """
        return pulumi.get(self, "number_of_sequences")

    @property
    @pulumi.getter
    def producer(self) -> str:
        """
        Producer Process Name if any.
        """
        return pulumi.get(self, "producer")

    @property
    @pulumi.getter(name="sizeInBytes")
    def size_in_bytes(self) -> float:
        """
        The size of the backup stored in object storage (in bytes)
        """
        return pulumi.get(self, "size_in_bytes")

    @property
    @pulumi.getter(name="timeLastUpdated")
    def time_last_updated(self) -> str:
        """
        The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_last_updated")

    @property
    @pulumi.getter(name="trailFileId")
    def trail_file_id(self) -> str:
        """
        A Trail File identifier
        """
        return pulumi.get(self, "trail_file_id")


@pulumi.output_type
class GetTrailSequenceItemResult(dict):
    def __init__(__self__, *,
                 display_name: str,
                 sequence_id: str,
                 size_in_bytes: float,
                 time_last_updated: str):
        """
        :param str display_name: A filter to return only the resources that match the entire 'displayName' given.
        :param str sequence_id: Sequence Id
        :param float size_in_bytes: The size of the backup stored in object storage (in bytes)
        :param str time_last_updated: The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        GetTrailSequenceItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            display_name=display_name,
            sequence_id=sequence_id,
            size_in_bytes=size_in_bytes,
            time_last_updated=time_last_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             display_name: str,
             sequence_id: str,
             size_in_bytes: float,
             time_last_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'sequenceId' in kwargs:
            sequence_id = kwargs['sequenceId']
        if 'sizeInBytes' in kwargs:
            size_in_bytes = kwargs['sizeInBytes']
        if 'timeLastUpdated' in kwargs:
            time_last_updated = kwargs['timeLastUpdated']

        _setter("display_name", display_name)
        _setter("sequence_id", sequence_id)
        _setter("size_in_bytes", size_in_bytes)
        _setter("time_last_updated", time_last_updated)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only the resources that match the entire 'displayName' given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="sequenceId")
    def sequence_id(self) -> str:
        """
        Sequence Id
        """
        return pulumi.get(self, "sequence_id")

    @property
    @pulumi.getter(name="sizeInBytes")
    def size_in_bytes(self) -> float:
        """
        The size of the backup stored in object storage (in bytes)
        """
        return pulumi.get(self, "size_in_bytes")

    @property
    @pulumi.getter(name="timeLastUpdated")
    def time_last_updated(self) -> str:
        """
        The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_last_updated")


@pulumi.output_type
class GetTrailSequencesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetTrailSequencesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetTrailSequencesTrailSequenceCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetTrailSequencesTrailSequenceCollectionItemResult'],
                 time_last_fetched: str):
        """
        :param Sequence['GetTrailSequencesTrailSequenceCollectionItemArgs'] items: An array of TrailSequences.
        :param str time_last_fetched: The time the data was last fetched from the deployment. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        GetTrailSequencesTrailSequenceCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
            time_last_fetched=time_last_fetched,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetTrailSequencesTrailSequenceCollectionItemResult'],
             time_last_fetched: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'timeLastFetched' in kwargs:
            time_last_fetched = kwargs['timeLastFetched']

        _setter("items", items)
        _setter("time_last_fetched", time_last_fetched)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetTrailSequencesTrailSequenceCollectionItemResult']:
        """
        An array of TrailSequences.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="timeLastFetched")
    def time_last_fetched(self) -> str:
        """
        The time the data was last fetched from the deployment. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_last_fetched")


@pulumi.output_type
class GetTrailSequencesTrailSequenceCollectionItemResult(dict):
    def __init__(__self__, *,
                 display_name: str,
                 sequence_id: str,
                 size_in_bytes: float,
                 time_last_updated: str):
        """
        :param str display_name: A filter to return only the resources that match the entire 'displayName' given.
        :param str sequence_id: Sequence Id
        :param float size_in_bytes: The size of the backup stored in object storage (in bytes)
        :param str time_last_updated: The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        GetTrailSequencesTrailSequenceCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            display_name=display_name,
            sequence_id=sequence_id,
            size_in_bytes=size_in_bytes,
            time_last_updated=time_last_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             display_name: str,
             sequence_id: str,
             size_in_bytes: float,
             time_last_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'sequenceId' in kwargs:
            sequence_id = kwargs['sequenceId']
        if 'sizeInBytes' in kwargs:
            size_in_bytes = kwargs['sizeInBytes']
        if 'timeLastUpdated' in kwargs:
            time_last_updated = kwargs['timeLastUpdated']

        _setter("display_name", display_name)
        _setter("sequence_id", sequence_id)
        _setter("size_in_bytes", size_in_bytes)
        _setter("time_last_updated", time_last_updated)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only the resources that match the entire 'displayName' given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="sequenceId")
    def sequence_id(self) -> str:
        """
        Sequence Id
        """
        return pulumi.get(self, "sequence_id")

    @property
    @pulumi.getter(name="sizeInBytes")
    def size_in_bytes(self) -> float:
        """
        The size of the backup stored in object storage (in bytes)
        """
        return pulumi.get(self, "size_in_bytes")

    @property
    @pulumi.getter(name="timeLastUpdated")
    def time_last_updated(self) -> str:
        """
        The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_last_updated")


