# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainsDynamicResourceGroupArgs', 'DomainsDynamicResourceGroup']

@pulumi.input_type
class DomainsDynamicResourceGroupArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[str],
                 idcs_endpoint: pulumi.Input[str],
                 matching_rule: pulumi.Input[str],
                 schemas: pulumi.Input[Sequence[pulumi.Input[str]]],
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsDynamicResourceGroupTagArgs']]]] = None,
                 urnietfparamsscimschemasoracleidcsextension_oci_tags: Optional[pulumi.Input['DomainsDynamicResourceGroupUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']] = None):
        """
        The set of arguments for constructing a DomainsDynamicResourceGroup resource.
        :param pulumi.Input[str] display_name: (Updatable) User-friendly, mutable identifier
               
               **SCIM++ Properties:**
               * idcsCsvAttributeName: Display Name
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Name, deprecatedColumnHeaderName:Display Name]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: always
               * type: string
               * uniqueness: global
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[str] matching_rule: (Updatable) Store as a string the matching-rule for this Dynamic Resource Group. This may match any number of Apps in this Domain, as well as matching any number of Oracle Cloud Infrastructure resources that are not in any Domain but that are in the Oracle Cloud Infrastructure Compartment that contains this Domain.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[str] description: (Updatable) text that explains the purpose of this Dynamic Resource Group
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: Description
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Description]]
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: always
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input['DomainsDynamicResourceGroupTagArgs']]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input['DomainsDynamicResourceGroupUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs'] urnietfparamsscimschemasoracleidcsextension_oci_tags: (Updatable) Oracle Cloud Infrastructure Tags.
        """
        DomainsDynamicResourceGroupArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            display_name=display_name,
            idcs_endpoint=idcs_endpoint,
            matching_rule=matching_rule,
            schemas=schemas,
            attribute_sets=attribute_sets,
            attributes=attributes,
            authorization=authorization,
            description=description,
            ocid=ocid,
            resource_type_schema_version=resource_type_schema_version,
            tags=tags,
            urnietfparamsscimschemasoracleidcsextension_oci_tags=urnietfparamsscimschemasoracleidcsextension_oci_tags,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             display_name: pulumi.Input[str],
             idcs_endpoint: pulumi.Input[str],
             matching_rule: pulumi.Input[str],
             schemas: pulumi.Input[Sequence[pulumi.Input[str]]],
             attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             attributes: Optional[pulumi.Input[str]] = None,
             authorization: Optional[pulumi.Input[str]] = None,
             description: Optional[pulumi.Input[str]] = None,
             ocid: Optional[pulumi.Input[str]] = None,
             resource_type_schema_version: Optional[pulumi.Input[str]] = None,
             tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsDynamicResourceGroupTagArgs']]]] = None,
             urnietfparamsscimschemasoracleidcsextension_oci_tags: Optional[pulumi.Input['DomainsDynamicResourceGroupUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'idcsEndpoint' in kwargs:
            idcs_endpoint = kwargs['idcsEndpoint']
        if 'matchingRule' in kwargs:
            matching_rule = kwargs['matchingRule']
        if 'attributeSets' in kwargs:
            attribute_sets = kwargs['attributeSets']
        if 'resourceTypeSchemaVersion' in kwargs:
            resource_type_schema_version = kwargs['resourceTypeSchemaVersion']
        if 'urnietfparamsscimschemasoracleidcsextensionOciTags' in kwargs:
            urnietfparamsscimschemasoracleidcsextension_oci_tags = kwargs['urnietfparamsscimschemasoracleidcsextensionOciTags']

        _setter("display_name", display_name)
        _setter("idcs_endpoint", idcs_endpoint)
        _setter("matching_rule", matching_rule)
        _setter("schemas", schemas)
        if attribute_sets is not None:
            _setter("attribute_sets", attribute_sets)
        if attributes is not None:
            _setter("attributes", attributes)
        if authorization is not None:
            _setter("authorization", authorization)
        if description is not None:
            _setter("description", description)
        if ocid is not None:
            _setter("ocid", ocid)
        if resource_type_schema_version is not None:
            _setter("resource_type_schema_version", resource_type_schema_version)
        if tags is not None:
            _setter("tags", tags)
        if urnietfparamsscimschemasoracleidcsextension_oci_tags is not None:
            _setter("urnietfparamsscimschemasoracleidcsextension_oci_tags", urnietfparamsscimschemasoracleidcsextension_oci_tags)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) User-friendly, mutable identifier

        **SCIM++ Properties:**
        * idcsCsvAttributeName: Display Name
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Name, deprecatedColumnHeaderName:Display Name]]
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: always
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Input[str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "idcs_endpoint", value)

    @property
    @pulumi.getter(name="matchingRule")
    def matching_rule(self) -> pulumi.Input[str]:
        """
        (Updatable) Store as a string the matching-rule for this Dynamic Resource Group. This may match any number of Apps in this Domain, as well as matching any number of Oracle Cloud Infrastructure resources that are not in any Domain but that are in the Oracle Cloud Infrastructure Compartment that contains this Domain.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "matching_rule")

    @matching_rule.setter
    def matching_rule(self, value: pulumi.Input[str]):
        pulumi.set(self, "matching_rule", value)

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @attribute_sets.setter
    def attribute_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "attribute_sets", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) text that explains the purpose of this Dynamic Resource Group

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCsvAttributeName: Description
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Description]]
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: always
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ocid", value)

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsDynamicResourceGroupTagArgs']]]]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsDynamicResourceGroupTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionOciTags")
    def urnietfparamsscimschemasoracleidcsextension_oci_tags(self) -> Optional[pulumi.Input['DomainsDynamicResourceGroupUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']]:
        """
        (Updatable) Oracle Cloud Infrastructure Tags.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextension_oci_tags")

    @urnietfparamsscimschemasoracleidcsextension_oci_tags.setter
    def urnietfparamsscimschemasoracleidcsextension_oci_tags(self, value: Optional[pulumi.Input['DomainsDynamicResourceGroupUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextension_oci_tags", value)


@pulumi.input_type
class _DomainsDynamicResourceGroupState:
    def __init__(__self__, *,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 compartment_ocid: Optional[pulumi.Input[str]] = None,
                 delete_in_progress: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 domain_ocid: Optional[pulumi.Input[str]] = None,
                 dynamic_group_app_roles: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsDynamicResourceGroupDynamicGroupAppRoleArgs']]]] = None,
                 grants: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsDynamicResourceGroupGrantArgs']]]] = None,
                 idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsDynamicResourceGroupIdcsCreatedByArgs']]]] = None,
                 idcs_endpoint: Optional[pulumi.Input[str]] = None,
                 idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsDynamicResourceGroupIdcsLastModifiedByArgs']]]] = None,
                 idcs_last_upgraded_in_release: Optional[pulumi.Input[str]] = None,
                 idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 matching_rule: Optional[pulumi.Input[str]] = None,
                 metas: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsDynamicResourceGroupMetaArgs']]]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsDynamicResourceGroupTagArgs']]]] = None,
                 tenancy_ocid: Optional[pulumi.Input[str]] = None,
                 urnietfparamsscimschemasoracleidcsextension_oci_tags: Optional[pulumi.Input['DomainsDynamicResourceGroupUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']] = None):
        """
        Input properties used for looking up and filtering DomainsDynamicResourceGroup resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] description: (Updatable) text that explains the purpose of this Dynamic Resource Group
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: Description
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Description]]
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: always
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] display_name: (Updatable) User-friendly, mutable identifier
               
               **SCIM++ Properties:**
               * idcsCsvAttributeName: Display Name
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Name, deprecatedColumnHeaderName:Display Name]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: always
               * type: string
               * uniqueness: global
        :param pulumi.Input[str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsDynamicResourceGroupDynamicGroupAppRoleArgs']]] dynamic_group_app_roles: (Updatable) A list of appRoles that are currently granted to this Dynamic Resource Group.  The Identity service will assert these AppRoles for any resource that satisfies the matching-rule of this DynamicResourceGroup.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsDynamicResourceGroupGrantArgs']]] grants: (Updatable) Grants assigned to group
               
               **SCIM++ Properties:**
               * idcsAddedSinceVersion: 3
               * idcsSearchable: true
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsDynamicResourceGroupIdcsCreatedByArgs']]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input['DomainsDynamicResourceGroupIdcsLastModifiedByArgs']]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] matching_rule: (Updatable) Store as a string the matching-rule for this Dynamic Resource Group. This may match any number of Apps in this Domain, as well as matching any number of Oracle Cloud Infrastructure resources that are not in any Domain but that are in the Oracle Cloud Infrastructure Compartment that contains this Domain.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsDynamicResourceGroupMetaArgs']]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsDynamicResourceGroupTagArgs']]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input['DomainsDynamicResourceGroupUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs'] urnietfparamsscimschemasoracleidcsextension_oci_tags: (Updatable) Oracle Cloud Infrastructure Tags.
        """
        _DomainsDynamicResourceGroupState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            attribute_sets=attribute_sets,
            attributes=attributes,
            authorization=authorization,
            compartment_ocid=compartment_ocid,
            delete_in_progress=delete_in_progress,
            description=description,
            display_name=display_name,
            domain_ocid=domain_ocid,
            dynamic_group_app_roles=dynamic_group_app_roles,
            grants=grants,
            idcs_created_bies=idcs_created_bies,
            idcs_endpoint=idcs_endpoint,
            idcs_last_modified_bies=idcs_last_modified_bies,
            idcs_last_upgraded_in_release=idcs_last_upgraded_in_release,
            idcs_prevented_operations=idcs_prevented_operations,
            matching_rule=matching_rule,
            metas=metas,
            ocid=ocid,
            resource_type_schema_version=resource_type_schema_version,
            schemas=schemas,
            tags=tags,
            tenancy_ocid=tenancy_ocid,
            urnietfparamsscimschemasoracleidcsextension_oci_tags=urnietfparamsscimschemasoracleidcsextension_oci_tags,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             attributes: Optional[pulumi.Input[str]] = None,
             authorization: Optional[pulumi.Input[str]] = None,
             compartment_ocid: Optional[pulumi.Input[str]] = None,
             delete_in_progress: Optional[pulumi.Input[bool]] = None,
             description: Optional[pulumi.Input[str]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             domain_ocid: Optional[pulumi.Input[str]] = None,
             dynamic_group_app_roles: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsDynamicResourceGroupDynamicGroupAppRoleArgs']]]] = None,
             grants: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsDynamicResourceGroupGrantArgs']]]] = None,
             idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsDynamicResourceGroupIdcsCreatedByArgs']]]] = None,
             idcs_endpoint: Optional[pulumi.Input[str]] = None,
             idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsDynamicResourceGroupIdcsLastModifiedByArgs']]]] = None,
             idcs_last_upgraded_in_release: Optional[pulumi.Input[str]] = None,
             idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             matching_rule: Optional[pulumi.Input[str]] = None,
             metas: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsDynamicResourceGroupMetaArgs']]]] = None,
             ocid: Optional[pulumi.Input[str]] = None,
             resource_type_schema_version: Optional[pulumi.Input[str]] = None,
             schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsDynamicResourceGroupTagArgs']]]] = None,
             tenancy_ocid: Optional[pulumi.Input[str]] = None,
             urnietfparamsscimschemasoracleidcsextension_oci_tags: Optional[pulumi.Input['DomainsDynamicResourceGroupUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'attributeSets' in kwargs:
            attribute_sets = kwargs['attributeSets']
        if 'compartmentOcid' in kwargs:
            compartment_ocid = kwargs['compartmentOcid']
        if 'deleteInProgress' in kwargs:
            delete_in_progress = kwargs['deleteInProgress']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'domainOcid' in kwargs:
            domain_ocid = kwargs['domainOcid']
        if 'dynamicGroupAppRoles' in kwargs:
            dynamic_group_app_roles = kwargs['dynamicGroupAppRoles']
        if 'idcsCreatedBies' in kwargs:
            idcs_created_bies = kwargs['idcsCreatedBies']
        if 'idcsEndpoint' in kwargs:
            idcs_endpoint = kwargs['idcsEndpoint']
        if 'idcsLastModifiedBies' in kwargs:
            idcs_last_modified_bies = kwargs['idcsLastModifiedBies']
        if 'idcsLastUpgradedInRelease' in kwargs:
            idcs_last_upgraded_in_release = kwargs['idcsLastUpgradedInRelease']
        if 'idcsPreventedOperations' in kwargs:
            idcs_prevented_operations = kwargs['idcsPreventedOperations']
        if 'matchingRule' in kwargs:
            matching_rule = kwargs['matchingRule']
        if 'resourceTypeSchemaVersion' in kwargs:
            resource_type_schema_version = kwargs['resourceTypeSchemaVersion']
        if 'tenancyOcid' in kwargs:
            tenancy_ocid = kwargs['tenancyOcid']
        if 'urnietfparamsscimschemasoracleidcsextensionOciTags' in kwargs:
            urnietfparamsscimschemasoracleidcsextension_oci_tags = kwargs['urnietfparamsscimschemasoracleidcsextensionOciTags']

        if attribute_sets is not None:
            _setter("attribute_sets", attribute_sets)
        if attributes is not None:
            _setter("attributes", attributes)
        if authorization is not None:
            _setter("authorization", authorization)
        if compartment_ocid is not None:
            _setter("compartment_ocid", compartment_ocid)
        if delete_in_progress is not None:
            _setter("delete_in_progress", delete_in_progress)
        if description is not None:
            _setter("description", description)
        if display_name is not None:
            _setter("display_name", display_name)
        if domain_ocid is not None:
            _setter("domain_ocid", domain_ocid)
        if dynamic_group_app_roles is not None:
            _setter("dynamic_group_app_roles", dynamic_group_app_roles)
        if grants is not None:
            _setter("grants", grants)
        if idcs_created_bies is not None:
            _setter("idcs_created_bies", idcs_created_bies)
        if idcs_endpoint is not None:
            _setter("idcs_endpoint", idcs_endpoint)
        if idcs_last_modified_bies is not None:
            _setter("idcs_last_modified_bies", idcs_last_modified_bies)
        if idcs_last_upgraded_in_release is not None:
            _setter("idcs_last_upgraded_in_release", idcs_last_upgraded_in_release)
        if idcs_prevented_operations is not None:
            _setter("idcs_prevented_operations", idcs_prevented_operations)
        if matching_rule is not None:
            _setter("matching_rule", matching_rule)
        if metas is not None:
            _setter("metas", metas)
        if ocid is not None:
            _setter("ocid", ocid)
        if resource_type_schema_version is not None:
            _setter("resource_type_schema_version", resource_type_schema_version)
        if schemas is not None:
            _setter("schemas", schemas)
        if tags is not None:
            _setter("tags", tags)
        if tenancy_ocid is not None:
            _setter("tenancy_ocid", tenancy_ocid)
        if urnietfparamsscimschemasoracleidcsextension_oci_tags is not None:
            _setter("urnietfparamsscimschemasoracleidcsextension_oci_tags", urnietfparamsscimschemasoracleidcsextension_oci_tags)

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @attribute_sets.setter
    def attribute_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "attribute_sets", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @compartment_ocid.setter
    def compartment_ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_ocid", value)

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @delete_in_progress.setter
    def delete_in_progress(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_in_progress", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) text that explains the purpose of this Dynamic Resource Group

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCsvAttributeName: Description
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Description]]
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: always
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) User-friendly, mutable identifier

        **SCIM++ Properties:**
        * idcsCsvAttributeName: Display Name
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Name, deprecatedColumnHeaderName:Display Name]]
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: always
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @domain_ocid.setter
    def domain_ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_ocid", value)

    @property
    @pulumi.getter(name="dynamicGroupAppRoles")
    def dynamic_group_app_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsDynamicResourceGroupDynamicGroupAppRoleArgs']]]]:
        """
        (Updatable) A list of appRoles that are currently granted to this Dynamic Resource Group.  The Identity service will assert these AppRoles for any resource that satisfies the matching-rule of this DynamicResourceGroup.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCompositeKey: [value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "dynamic_group_app_roles")

    @dynamic_group_app_roles.setter
    def dynamic_group_app_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsDynamicResourceGroupDynamicGroupAppRoleArgs']]]]):
        pulumi.set(self, "dynamic_group_app_roles", value)

    @property
    @pulumi.getter
    def grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsDynamicResourceGroupGrantArgs']]]]:
        """
        (Updatable) Grants assigned to group

        **SCIM++ Properties:**
        * idcsAddedSinceVersion: 3
        * idcsSearchable: true
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "grants")

    @grants.setter
    def grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsDynamicResourceGroupGrantArgs']]]]):
        pulumi.set(self, "grants", value)

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsDynamicResourceGroupIdcsCreatedByArgs']]]]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @idcs_created_bies.setter
    def idcs_created_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsDynamicResourceGroupIdcsCreatedByArgs']]]]):
        pulumi.set(self, "idcs_created_bies", value)

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idcs_endpoint", value)

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsDynamicResourceGroupIdcsLastModifiedByArgs']]]]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @idcs_last_modified_bies.setter
    def idcs_last_modified_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsDynamicResourceGroupIdcsLastModifiedByArgs']]]]):
        pulumi.set(self, "idcs_last_modified_bies", value)

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @idcs_last_upgraded_in_release.setter
    def idcs_last_upgraded_in_release(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idcs_last_upgraded_in_release", value)

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @idcs_prevented_operations.setter
    def idcs_prevented_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "idcs_prevented_operations", value)

    @property
    @pulumi.getter(name="matchingRule")
    def matching_rule(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Store as a string the matching-rule for this Dynamic Resource Group. This may match any number of Apps in this Domain, as well as matching any number of Oracle Cloud Infrastructure resources that are not in any Domain but that are in the Oracle Cloud Infrastructure Compartment that contains this Domain.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "matching_rule")

    @matching_rule.setter
    def matching_rule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "matching_rule", value)

    @property
    @pulumi.getter
    def metas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsDynamicResourceGroupMetaArgs']]]]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @metas.setter
    def metas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsDynamicResourceGroupMetaArgs']]]]):
        pulumi.set(self, "metas", value)

    @property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ocid", value)

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @property
    @pulumi.getter
    def schemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsDynamicResourceGroupTagArgs']]]]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsDynamicResourceGroupTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "tenancy_ocid")

    @tenancy_ocid.setter
    def tenancy_ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenancy_ocid", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionOciTags")
    def urnietfparamsscimschemasoracleidcsextension_oci_tags(self) -> Optional[pulumi.Input['DomainsDynamicResourceGroupUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']]:
        """
        (Updatable) Oracle Cloud Infrastructure Tags.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextension_oci_tags")

    @urnietfparamsscimschemasoracleidcsextension_oci_tags.setter
    def urnietfparamsscimschemasoracleidcsextension_oci_tags(self, value: Optional[pulumi.Input['DomainsDynamicResourceGroupUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextension_oci_tags", value)


class DomainsDynamicResourceGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 idcs_endpoint: Optional[pulumi.Input[str]] = None,
                 matching_rule: Optional[pulumi.Input[str]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsDynamicResourceGroupTagArgs']]]]] = None,
                 urnietfparamsscimschemasoracleidcsextension_oci_tags: Optional[pulumi.Input[pulumi.InputType['DomainsDynamicResourceGroupUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']]] = None,
                 __props__=None):
        """
        This resource provides the Dynamic Resource Group resource in Oracle Cloud Infrastructure Identity Domains service.

        Create a Dynamic Resource Group.

        ## Import

        DynamicResourceGroups can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Identity/domainsDynamicResourceGroup:DomainsDynamicResourceGroup test_dynamic_resource_group "idcsEndpoint/{idcsEndpoint}/dynamicResourceGroups/{dynamicResourceGroupId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[str] description: (Updatable) text that explains the purpose of this Dynamic Resource Group
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: Description
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Description]]
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: always
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] display_name: (Updatable) User-friendly, mutable identifier
               
               **SCIM++ Properties:**
               * idcsCsvAttributeName: Display Name
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Name, deprecatedColumnHeaderName:Display Name]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: always
               * type: string
               * uniqueness: global
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[str] matching_rule: (Updatable) Store as a string the matching-rule for this Dynamic Resource Group. This may match any number of Apps in this Domain, as well as matching any number of Oracle Cloud Infrastructure resources that are not in any Domain but that are in the Oracle Cloud Infrastructure Compartment that contains this Domain.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsDynamicResourceGroupTagArgs']]]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[pulumi.InputType['DomainsDynamicResourceGroupUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']] urnietfparamsscimschemasoracleidcsextension_oci_tags: (Updatable) Oracle Cloud Infrastructure Tags.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainsDynamicResourceGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Dynamic Resource Group resource in Oracle Cloud Infrastructure Identity Domains service.

        Create a Dynamic Resource Group.

        ## Import

        DynamicResourceGroups can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Identity/domainsDynamicResourceGroup:DomainsDynamicResourceGroup test_dynamic_resource_group "idcsEndpoint/{idcsEndpoint}/dynamicResourceGroups/{dynamicResourceGroupId}"
        ```

        :param str resource_name: The name of the resource.
        :param DomainsDynamicResourceGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainsDynamicResourceGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            DomainsDynamicResourceGroupArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 idcs_endpoint: Optional[pulumi.Input[str]] = None,
                 matching_rule: Optional[pulumi.Input[str]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsDynamicResourceGroupTagArgs']]]]] = None,
                 urnietfparamsscimschemasoracleidcsextension_oci_tags: Optional[pulumi.Input[pulumi.InputType['DomainsDynamicResourceGroupUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainsDynamicResourceGroupArgs.__new__(DomainsDynamicResourceGroupArgs)

            __props__.__dict__["attribute_sets"] = attribute_sets
            __props__.__dict__["attributes"] = attributes
            __props__.__dict__["authorization"] = authorization
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if idcs_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'idcs_endpoint'")
            __props__.__dict__["idcs_endpoint"] = idcs_endpoint
            if matching_rule is None and not opts.urn:
                raise TypeError("Missing required property 'matching_rule'")
            __props__.__dict__["matching_rule"] = matching_rule
            __props__.__dict__["ocid"] = ocid
            __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
            if schemas is None and not opts.urn:
                raise TypeError("Missing required property 'schemas'")
            __props__.__dict__["schemas"] = schemas
            __props__.__dict__["tags"] = tags
            if urnietfparamsscimschemasoracleidcsextension_oci_tags is not None and not isinstance(urnietfparamsscimschemasoracleidcsextension_oci_tags, DomainsDynamicResourceGroupUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs):
                urnietfparamsscimschemasoracleidcsextension_oci_tags = urnietfparamsscimschemasoracleidcsextension_oci_tags or {}
                def _setter(key, value):
                    urnietfparamsscimschemasoracleidcsextension_oci_tags[key] = value
                DomainsDynamicResourceGroupUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs._configure(_setter, **urnietfparamsscimschemasoracleidcsextension_oci_tags)
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextension_oci_tags"] = urnietfparamsscimschemasoracleidcsextension_oci_tags
            __props__.__dict__["compartment_ocid"] = None
            __props__.__dict__["delete_in_progress"] = None
            __props__.__dict__["domain_ocid"] = None
            __props__.__dict__["dynamic_group_app_roles"] = None
            __props__.__dict__["grants"] = None
            __props__.__dict__["idcs_created_bies"] = None
            __props__.__dict__["idcs_last_modified_bies"] = None
            __props__.__dict__["idcs_last_upgraded_in_release"] = None
            __props__.__dict__["idcs_prevented_operations"] = None
            __props__.__dict__["metas"] = None
            __props__.__dict__["tenancy_ocid"] = None
        super(DomainsDynamicResourceGroup, __self__).__init__(
            'oci:Identity/domainsDynamicResourceGroup:DomainsDynamicResourceGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            attributes: Optional[pulumi.Input[str]] = None,
            authorization: Optional[pulumi.Input[str]] = None,
            compartment_ocid: Optional[pulumi.Input[str]] = None,
            delete_in_progress: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            domain_ocid: Optional[pulumi.Input[str]] = None,
            dynamic_group_app_roles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsDynamicResourceGroupDynamicGroupAppRoleArgs']]]]] = None,
            grants: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsDynamicResourceGroupGrantArgs']]]]] = None,
            idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsDynamicResourceGroupIdcsCreatedByArgs']]]]] = None,
            idcs_endpoint: Optional[pulumi.Input[str]] = None,
            idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsDynamicResourceGroupIdcsLastModifiedByArgs']]]]] = None,
            idcs_last_upgraded_in_release: Optional[pulumi.Input[str]] = None,
            idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            matching_rule: Optional[pulumi.Input[str]] = None,
            metas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsDynamicResourceGroupMetaArgs']]]]] = None,
            ocid: Optional[pulumi.Input[str]] = None,
            resource_type_schema_version: Optional[pulumi.Input[str]] = None,
            schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsDynamicResourceGroupTagArgs']]]]] = None,
            tenancy_ocid: Optional[pulumi.Input[str]] = None,
            urnietfparamsscimschemasoracleidcsextension_oci_tags: Optional[pulumi.Input[pulumi.InputType['DomainsDynamicResourceGroupUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']]] = None) -> 'DomainsDynamicResourceGroup':
        """
        Get an existing DomainsDynamicResourceGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] description: (Updatable) text that explains the purpose of this Dynamic Resource Group
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: Description
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Description]]
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: always
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] display_name: (Updatable) User-friendly, mutable identifier
               
               **SCIM++ Properties:**
               * idcsCsvAttributeName: Display Name
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Name, deprecatedColumnHeaderName:Display Name]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: always
               * type: string
               * uniqueness: global
        :param pulumi.Input[str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsDynamicResourceGroupDynamicGroupAppRoleArgs']]]] dynamic_group_app_roles: (Updatable) A list of appRoles that are currently granted to this Dynamic Resource Group.  The Identity service will assert these AppRoles for any resource that satisfies the matching-rule of this DynamicResourceGroup.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsDynamicResourceGroupGrantArgs']]]] grants: (Updatable) Grants assigned to group
               
               **SCIM++ Properties:**
               * idcsAddedSinceVersion: 3
               * idcsSearchable: true
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsDynamicResourceGroupIdcsCreatedByArgs']]]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsDynamicResourceGroupIdcsLastModifiedByArgs']]]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] matching_rule: (Updatable) Store as a string the matching-rule for this Dynamic Resource Group. This may match any number of Apps in this Domain, as well as matching any number of Oracle Cloud Infrastructure resources that are not in any Domain but that are in the Oracle Cloud Infrastructure Compartment that contains this Domain.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsDynamicResourceGroupMetaArgs']]]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsDynamicResourceGroupTagArgs']]]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[pulumi.InputType['DomainsDynamicResourceGroupUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']] urnietfparamsscimschemasoracleidcsextension_oci_tags: (Updatable) Oracle Cloud Infrastructure Tags.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainsDynamicResourceGroupState.__new__(_DomainsDynamicResourceGroupState)

        __props__.__dict__["attribute_sets"] = attribute_sets
        __props__.__dict__["attributes"] = attributes
        __props__.__dict__["authorization"] = authorization
        __props__.__dict__["compartment_ocid"] = compartment_ocid
        __props__.__dict__["delete_in_progress"] = delete_in_progress
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["domain_ocid"] = domain_ocid
        __props__.__dict__["dynamic_group_app_roles"] = dynamic_group_app_roles
        __props__.__dict__["grants"] = grants
        __props__.__dict__["idcs_created_bies"] = idcs_created_bies
        __props__.__dict__["idcs_endpoint"] = idcs_endpoint
        __props__.__dict__["idcs_last_modified_bies"] = idcs_last_modified_bies
        __props__.__dict__["idcs_last_upgraded_in_release"] = idcs_last_upgraded_in_release
        __props__.__dict__["idcs_prevented_operations"] = idcs_prevented_operations
        __props__.__dict__["matching_rule"] = matching_rule
        __props__.__dict__["metas"] = metas
        __props__.__dict__["ocid"] = ocid
        __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
        __props__.__dict__["schemas"] = schemas
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenancy_ocid"] = tenancy_ocid
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextension_oci_tags"] = urnietfparamsscimschemasoracleidcsextension_oci_tags
        return DomainsDynamicResourceGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def authorization(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> pulumi.Output[bool]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) text that explains the purpose of this Dynamic Resource Group

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCsvAttributeName: Description
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Description]]
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: always
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) User-friendly, mutable identifier

        **SCIM++ Properties:**
        * idcsCsvAttributeName: Display Name
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Name, deprecatedColumnHeaderName:Display Name]]
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: always
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @property
    @pulumi.getter(name="dynamicGroupAppRoles")
    def dynamic_group_app_roles(self) -> pulumi.Output[Sequence['outputs.DomainsDynamicResourceGroupDynamicGroupAppRole']]:
        """
        (Updatable) A list of appRoles that are currently granted to this Dynamic Resource Group.  The Identity service will assert these AppRoles for any resource that satisfies the matching-rule of this DynamicResourceGroup.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCompositeKey: [value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "dynamic_group_app_roles")

    @property
    @pulumi.getter
    def grants(self) -> pulumi.Output[Sequence['outputs.DomainsDynamicResourceGroupGrant']]:
        """
        (Updatable) Grants assigned to group

        **SCIM++ Properties:**
        * idcsAddedSinceVersion: 3
        * idcsSearchable: true
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "grants")

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> pulumi.Output[Sequence['outputs.DomainsDynamicResourceGroupIdcsCreatedBy']]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Output[str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> pulumi.Output[Sequence['outputs.DomainsDynamicResourceGroupIdcsLastModifiedBy']]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> pulumi.Output[str]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @property
    @pulumi.getter(name="matchingRule")
    def matching_rule(self) -> pulumi.Output[str]:
        """
        (Updatable) Store as a string the matching-rule for this Dynamic Resource Group. This may match any number of Apps in this Domain, as well as matching any number of Oracle Cloud Infrastructure resources that are not in any Domain but that are in the Oracle Cloud Infrastructure Compartment that contains this Domain.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "matching_rule")

    @property
    @pulumi.getter
    def metas(self) -> pulumi.Output[Sequence['outputs.DomainsDynamicResourceGroupMeta']]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @property
    @pulumi.getter
    def ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.DomainsDynamicResourceGroupTag']]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "tenancy_ocid")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionOciTags")
    def urnietfparamsscimschemasoracleidcsextension_oci_tags(self) -> pulumi.Output['outputs.DomainsDynamicResourceGroupUrnietfparamsscimschemasoracleidcsextensionOciTags']:
        """
        (Updatable) Oracle Cloud Infrastructure Tags.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextension_oci_tags")

