# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainsSecurityQuestionSettingArgs', 'DomainsSecurityQuestionSetting']

@pulumi.input_type
class DomainsSecurityQuestionSettingArgs:
    def __init__(__self__, *,
                 idcs_endpoint: pulumi.Input[str],
                 max_field_length: pulumi.Input[int],
                 min_answer_length: pulumi.Input[int],
                 num_questions_to_ans: pulumi.Input[int],
                 num_questions_to_setup: pulumi.Input[int],
                 schemas: pulumi.Input[Sequence[pulumi.Input[str]]],
                 security_question_setting_id: pulumi.Input[str],
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSecurityQuestionSettingTagArgs']]]] = None):
        """
        The set of arguments for constructing a DomainsSecurityQuestionSetting resource.
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[int] max_field_length: (Updatable) Indicates the maximum length of following fields Security Questions, Answer and Hint
               
               **SCIM++ Properties:**
               * type: integer
               * multiValued: false
               * returned: default
               * caseExact: false
               * mutability: readWrite
               * required: true
               * uniqueness: none
               * idcsMinValue: 5
               * idcsMaxValue: 100
        :param pulumi.Input[int] min_answer_length: (Updatable) Indicates the minimum length of answer for security questions
               
               **SCIM++ Properties:**
               * type: integer
               * multiValued: false
               * required: true
               * caseExact: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * idcsMinValue: 1
               * idcsMaxValue: 8
        :param pulumi.Input[int] num_questions_to_ans: (Updatable) Indicates the number of security questions that a user must answer
               
               **SCIM++ Properties:**
               * type: integer
               * multiValued: false
               * returned: default
               * caseExact: false
               * mutability: readWrite
               * required: true
               * uniqueness: none
               * idcsMinValue: 1
               * idcsMaxValue: 5
        :param pulumi.Input[int] num_questions_to_setup: (Updatable) Indicates the number of security questions a user must setup
               
               **SCIM++ Properties:**
               * type: integer
               * multiValued: false
               * required: true
               * caseExact: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * idcsMinValue: 1
               * idcsMaxValue: 5
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] security_question_setting_id: ID of the resource
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * caseExact: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSecurityQuestionSettingTagArgs']]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        """
        DomainsSecurityQuestionSettingArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            idcs_endpoint=idcs_endpoint,
            max_field_length=max_field_length,
            min_answer_length=min_answer_length,
            num_questions_to_ans=num_questions_to_ans,
            num_questions_to_setup=num_questions_to_setup,
            schemas=schemas,
            security_question_setting_id=security_question_setting_id,
            attribute_sets=attribute_sets,
            attributes=attributes,
            authorization=authorization,
            external_id=external_id,
            ocid=ocid,
            resource_type_schema_version=resource_type_schema_version,
            tags=tags,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             idcs_endpoint: pulumi.Input[str],
             max_field_length: pulumi.Input[int],
             min_answer_length: pulumi.Input[int],
             num_questions_to_ans: pulumi.Input[int],
             num_questions_to_setup: pulumi.Input[int],
             schemas: pulumi.Input[Sequence[pulumi.Input[str]]],
             security_question_setting_id: pulumi.Input[str],
             attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             attributes: Optional[pulumi.Input[str]] = None,
             authorization: Optional[pulumi.Input[str]] = None,
             external_id: Optional[pulumi.Input[str]] = None,
             ocid: Optional[pulumi.Input[str]] = None,
             resource_type_schema_version: Optional[pulumi.Input[str]] = None,
             tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSecurityQuestionSettingTagArgs']]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'idcsEndpoint' in kwargs:
            idcs_endpoint = kwargs['idcsEndpoint']
        if 'maxFieldLength' in kwargs:
            max_field_length = kwargs['maxFieldLength']
        if 'minAnswerLength' in kwargs:
            min_answer_length = kwargs['minAnswerLength']
        if 'numQuestionsToAns' in kwargs:
            num_questions_to_ans = kwargs['numQuestionsToAns']
        if 'numQuestionsToSetup' in kwargs:
            num_questions_to_setup = kwargs['numQuestionsToSetup']
        if 'securityQuestionSettingId' in kwargs:
            security_question_setting_id = kwargs['securityQuestionSettingId']
        if 'attributeSets' in kwargs:
            attribute_sets = kwargs['attributeSets']
        if 'externalId' in kwargs:
            external_id = kwargs['externalId']
        if 'resourceTypeSchemaVersion' in kwargs:
            resource_type_schema_version = kwargs['resourceTypeSchemaVersion']

        _setter("idcs_endpoint", idcs_endpoint)
        _setter("max_field_length", max_field_length)
        _setter("min_answer_length", min_answer_length)
        _setter("num_questions_to_ans", num_questions_to_ans)
        _setter("num_questions_to_setup", num_questions_to_setup)
        _setter("schemas", schemas)
        _setter("security_question_setting_id", security_question_setting_id)
        if attribute_sets is not None:
            _setter("attribute_sets", attribute_sets)
        if attributes is not None:
            _setter("attributes", attributes)
        if authorization is not None:
            _setter("authorization", authorization)
        if external_id is not None:
            _setter("external_id", external_id)
        if ocid is not None:
            _setter("ocid", ocid)
        if resource_type_schema_version is not None:
            _setter("resource_type_schema_version", resource_type_schema_version)
        if tags is not None:
            _setter("tags", tags)

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Input[str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "idcs_endpoint", value)

    @property
    @pulumi.getter(name="maxFieldLength")
    def max_field_length(self) -> pulumi.Input[int]:
        """
        (Updatable) Indicates the maximum length of following fields Security Questions, Answer and Hint

        **SCIM++ Properties:**
        * type: integer
        * multiValued: false
        * returned: default
        * caseExact: false
        * mutability: readWrite
        * required: true
        * uniqueness: none
        * idcsMinValue: 5
        * idcsMaxValue: 100
        """
        return pulumi.get(self, "max_field_length")

    @max_field_length.setter
    def max_field_length(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_field_length", value)

    @property
    @pulumi.getter(name="minAnswerLength")
    def min_answer_length(self) -> pulumi.Input[int]:
        """
        (Updatable) Indicates the minimum length of answer for security questions

        **SCIM++ Properties:**
        * type: integer
        * multiValued: false
        * required: true
        * caseExact: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * idcsMinValue: 1
        * idcsMaxValue: 8
        """
        return pulumi.get(self, "min_answer_length")

    @min_answer_length.setter
    def min_answer_length(self, value: pulumi.Input[int]):
        pulumi.set(self, "min_answer_length", value)

    @property
    @pulumi.getter(name="numQuestionsToAns")
    def num_questions_to_ans(self) -> pulumi.Input[int]:
        """
        (Updatable) Indicates the number of security questions that a user must answer

        **SCIM++ Properties:**
        * type: integer
        * multiValued: false
        * returned: default
        * caseExact: false
        * mutability: readWrite
        * required: true
        * uniqueness: none
        * idcsMinValue: 1
        * idcsMaxValue: 5
        """
        return pulumi.get(self, "num_questions_to_ans")

    @num_questions_to_ans.setter
    def num_questions_to_ans(self, value: pulumi.Input[int]):
        pulumi.set(self, "num_questions_to_ans", value)

    @property
    @pulumi.getter(name="numQuestionsToSetup")
    def num_questions_to_setup(self) -> pulumi.Input[int]:
        """
        (Updatable) Indicates the number of security questions a user must setup

        **SCIM++ Properties:**
        * type: integer
        * multiValued: false
        * required: true
        * caseExact: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * idcsMinValue: 1
        * idcsMaxValue: 5
        """
        return pulumi.get(self, "num_questions_to_setup")

    @num_questions_to_setup.setter
    def num_questions_to_setup(self, value: pulumi.Input[int]):
        pulumi.set(self, "num_questions_to_setup", value)

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter(name="securityQuestionSettingId")
    def security_question_setting_id(self) -> pulumi.Input[str]:
        """
        ID of the resource
        """
        return pulumi.get(self, "security_question_setting_id")

    @security_question_setting_id.setter
    def security_question_setting_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "security_question_setting_id", value)

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @attribute_sets.setter
    def attribute_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "attribute_sets", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * caseExact: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ocid", value)

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSecurityQuestionSettingTagArgs']]]]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSecurityQuestionSettingTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _DomainsSecurityQuestionSettingState:
    def __init__(__self__, *,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 compartment_ocid: Optional[pulumi.Input[str]] = None,
                 delete_in_progress: Optional[pulumi.Input[bool]] = None,
                 domain_ocid: Optional[pulumi.Input[str]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSecurityQuestionSettingIdcsCreatedByArgs']]]] = None,
                 idcs_endpoint: Optional[pulumi.Input[str]] = None,
                 idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSecurityQuestionSettingIdcsLastModifiedByArgs']]]] = None,
                 idcs_last_upgraded_in_release: Optional[pulumi.Input[str]] = None,
                 idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_field_length: Optional[pulumi.Input[int]] = None,
                 metas: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSecurityQuestionSettingMetaArgs']]]] = None,
                 min_answer_length: Optional[pulumi.Input[int]] = None,
                 num_questions_to_ans: Optional[pulumi.Input[int]] = None,
                 num_questions_to_setup: Optional[pulumi.Input[int]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_question_setting_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSecurityQuestionSettingTagArgs']]]] = None,
                 tenancy_ocid: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DomainsSecurityQuestionSetting resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * caseExact: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSecurityQuestionSettingIdcsCreatedByArgs']]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSecurityQuestionSettingIdcsLastModifiedByArgs']]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[int] max_field_length: (Updatable) Indicates the maximum length of following fields Security Questions, Answer and Hint
               
               **SCIM++ Properties:**
               * type: integer
               * multiValued: false
               * returned: default
               * caseExact: false
               * mutability: readWrite
               * required: true
               * uniqueness: none
               * idcsMinValue: 5
               * idcsMaxValue: 100
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSecurityQuestionSettingMetaArgs']]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input[int] min_answer_length: (Updatable) Indicates the minimum length of answer for security questions
               
               **SCIM++ Properties:**
               * type: integer
               * multiValued: false
               * required: true
               * caseExact: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * idcsMinValue: 1
               * idcsMaxValue: 8
        :param pulumi.Input[int] num_questions_to_ans: (Updatable) Indicates the number of security questions that a user must answer
               
               **SCIM++ Properties:**
               * type: integer
               * multiValued: false
               * returned: default
               * caseExact: false
               * mutability: readWrite
               * required: true
               * uniqueness: none
               * idcsMinValue: 1
               * idcsMaxValue: 5
        :param pulumi.Input[int] num_questions_to_setup: (Updatable) Indicates the number of security questions a user must setup
               
               **SCIM++ Properties:**
               * type: integer
               * multiValued: false
               * required: true
               * caseExact: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * idcsMinValue: 1
               * idcsMaxValue: 5
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] security_question_setting_id: ID of the resource
        :param pulumi.Input[Sequence[pulumi.Input['DomainsSecurityQuestionSettingTagArgs']]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        _DomainsSecurityQuestionSettingState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            attribute_sets=attribute_sets,
            attributes=attributes,
            authorization=authorization,
            compartment_ocid=compartment_ocid,
            delete_in_progress=delete_in_progress,
            domain_ocid=domain_ocid,
            external_id=external_id,
            idcs_created_bies=idcs_created_bies,
            idcs_endpoint=idcs_endpoint,
            idcs_last_modified_bies=idcs_last_modified_bies,
            idcs_last_upgraded_in_release=idcs_last_upgraded_in_release,
            idcs_prevented_operations=idcs_prevented_operations,
            max_field_length=max_field_length,
            metas=metas,
            min_answer_length=min_answer_length,
            num_questions_to_ans=num_questions_to_ans,
            num_questions_to_setup=num_questions_to_setup,
            ocid=ocid,
            resource_type_schema_version=resource_type_schema_version,
            schemas=schemas,
            security_question_setting_id=security_question_setting_id,
            tags=tags,
            tenancy_ocid=tenancy_ocid,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             attributes: Optional[pulumi.Input[str]] = None,
             authorization: Optional[pulumi.Input[str]] = None,
             compartment_ocid: Optional[pulumi.Input[str]] = None,
             delete_in_progress: Optional[pulumi.Input[bool]] = None,
             domain_ocid: Optional[pulumi.Input[str]] = None,
             external_id: Optional[pulumi.Input[str]] = None,
             idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSecurityQuestionSettingIdcsCreatedByArgs']]]] = None,
             idcs_endpoint: Optional[pulumi.Input[str]] = None,
             idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSecurityQuestionSettingIdcsLastModifiedByArgs']]]] = None,
             idcs_last_upgraded_in_release: Optional[pulumi.Input[str]] = None,
             idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             max_field_length: Optional[pulumi.Input[int]] = None,
             metas: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSecurityQuestionSettingMetaArgs']]]] = None,
             min_answer_length: Optional[pulumi.Input[int]] = None,
             num_questions_to_ans: Optional[pulumi.Input[int]] = None,
             num_questions_to_setup: Optional[pulumi.Input[int]] = None,
             ocid: Optional[pulumi.Input[str]] = None,
             resource_type_schema_version: Optional[pulumi.Input[str]] = None,
             schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             security_question_setting_id: Optional[pulumi.Input[str]] = None,
             tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSecurityQuestionSettingTagArgs']]]] = None,
             tenancy_ocid: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'attributeSets' in kwargs:
            attribute_sets = kwargs['attributeSets']
        if 'compartmentOcid' in kwargs:
            compartment_ocid = kwargs['compartmentOcid']
        if 'deleteInProgress' in kwargs:
            delete_in_progress = kwargs['deleteInProgress']
        if 'domainOcid' in kwargs:
            domain_ocid = kwargs['domainOcid']
        if 'externalId' in kwargs:
            external_id = kwargs['externalId']
        if 'idcsCreatedBies' in kwargs:
            idcs_created_bies = kwargs['idcsCreatedBies']
        if 'idcsEndpoint' in kwargs:
            idcs_endpoint = kwargs['idcsEndpoint']
        if 'idcsLastModifiedBies' in kwargs:
            idcs_last_modified_bies = kwargs['idcsLastModifiedBies']
        if 'idcsLastUpgradedInRelease' in kwargs:
            idcs_last_upgraded_in_release = kwargs['idcsLastUpgradedInRelease']
        if 'idcsPreventedOperations' in kwargs:
            idcs_prevented_operations = kwargs['idcsPreventedOperations']
        if 'maxFieldLength' in kwargs:
            max_field_length = kwargs['maxFieldLength']
        if 'minAnswerLength' in kwargs:
            min_answer_length = kwargs['minAnswerLength']
        if 'numQuestionsToAns' in kwargs:
            num_questions_to_ans = kwargs['numQuestionsToAns']
        if 'numQuestionsToSetup' in kwargs:
            num_questions_to_setup = kwargs['numQuestionsToSetup']
        if 'resourceTypeSchemaVersion' in kwargs:
            resource_type_schema_version = kwargs['resourceTypeSchemaVersion']
        if 'securityQuestionSettingId' in kwargs:
            security_question_setting_id = kwargs['securityQuestionSettingId']
        if 'tenancyOcid' in kwargs:
            tenancy_ocid = kwargs['tenancyOcid']

        if attribute_sets is not None:
            _setter("attribute_sets", attribute_sets)
        if attributes is not None:
            _setter("attributes", attributes)
        if authorization is not None:
            _setter("authorization", authorization)
        if compartment_ocid is not None:
            _setter("compartment_ocid", compartment_ocid)
        if delete_in_progress is not None:
            _setter("delete_in_progress", delete_in_progress)
        if domain_ocid is not None:
            _setter("domain_ocid", domain_ocid)
        if external_id is not None:
            _setter("external_id", external_id)
        if idcs_created_bies is not None:
            _setter("idcs_created_bies", idcs_created_bies)
        if idcs_endpoint is not None:
            _setter("idcs_endpoint", idcs_endpoint)
        if idcs_last_modified_bies is not None:
            _setter("idcs_last_modified_bies", idcs_last_modified_bies)
        if idcs_last_upgraded_in_release is not None:
            _setter("idcs_last_upgraded_in_release", idcs_last_upgraded_in_release)
        if idcs_prevented_operations is not None:
            _setter("idcs_prevented_operations", idcs_prevented_operations)
        if max_field_length is not None:
            _setter("max_field_length", max_field_length)
        if metas is not None:
            _setter("metas", metas)
        if min_answer_length is not None:
            _setter("min_answer_length", min_answer_length)
        if num_questions_to_ans is not None:
            _setter("num_questions_to_ans", num_questions_to_ans)
        if num_questions_to_setup is not None:
            _setter("num_questions_to_setup", num_questions_to_setup)
        if ocid is not None:
            _setter("ocid", ocid)
        if resource_type_schema_version is not None:
            _setter("resource_type_schema_version", resource_type_schema_version)
        if schemas is not None:
            _setter("schemas", schemas)
        if security_question_setting_id is not None:
            _setter("security_question_setting_id", security_question_setting_id)
        if tags is not None:
            _setter("tags", tags)
        if tenancy_ocid is not None:
            _setter("tenancy_ocid", tenancy_ocid)

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @attribute_sets.setter
    def attribute_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "attribute_sets", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @compartment_ocid.setter
    def compartment_ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_ocid", value)

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @delete_in_progress.setter
    def delete_in_progress(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_in_progress", value)

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @domain_ocid.setter
    def domain_ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_ocid", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * caseExact: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSecurityQuestionSettingIdcsCreatedByArgs']]]]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @idcs_created_bies.setter
    def idcs_created_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSecurityQuestionSettingIdcsCreatedByArgs']]]]):
        pulumi.set(self, "idcs_created_bies", value)

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idcs_endpoint", value)

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSecurityQuestionSettingIdcsLastModifiedByArgs']]]]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @idcs_last_modified_bies.setter
    def idcs_last_modified_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSecurityQuestionSettingIdcsLastModifiedByArgs']]]]):
        pulumi.set(self, "idcs_last_modified_bies", value)

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @idcs_last_upgraded_in_release.setter
    def idcs_last_upgraded_in_release(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idcs_last_upgraded_in_release", value)

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @idcs_prevented_operations.setter
    def idcs_prevented_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "idcs_prevented_operations", value)

    @property
    @pulumi.getter(name="maxFieldLength")
    def max_field_length(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Indicates the maximum length of following fields Security Questions, Answer and Hint

        **SCIM++ Properties:**
        * type: integer
        * multiValued: false
        * returned: default
        * caseExact: false
        * mutability: readWrite
        * required: true
        * uniqueness: none
        * idcsMinValue: 5
        * idcsMaxValue: 100
        """
        return pulumi.get(self, "max_field_length")

    @max_field_length.setter
    def max_field_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_field_length", value)

    @property
    @pulumi.getter
    def metas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSecurityQuestionSettingMetaArgs']]]]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @metas.setter
    def metas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSecurityQuestionSettingMetaArgs']]]]):
        pulumi.set(self, "metas", value)

    @property
    @pulumi.getter(name="minAnswerLength")
    def min_answer_length(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Indicates the minimum length of answer for security questions

        **SCIM++ Properties:**
        * type: integer
        * multiValued: false
        * required: true
        * caseExact: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * idcsMinValue: 1
        * idcsMaxValue: 8
        """
        return pulumi.get(self, "min_answer_length")

    @min_answer_length.setter
    def min_answer_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_answer_length", value)

    @property
    @pulumi.getter(name="numQuestionsToAns")
    def num_questions_to_ans(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Indicates the number of security questions that a user must answer

        **SCIM++ Properties:**
        * type: integer
        * multiValued: false
        * returned: default
        * caseExact: false
        * mutability: readWrite
        * required: true
        * uniqueness: none
        * idcsMinValue: 1
        * idcsMaxValue: 5
        """
        return pulumi.get(self, "num_questions_to_ans")

    @num_questions_to_ans.setter
    def num_questions_to_ans(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_questions_to_ans", value)

    @property
    @pulumi.getter(name="numQuestionsToSetup")
    def num_questions_to_setup(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Indicates the number of security questions a user must setup

        **SCIM++ Properties:**
        * type: integer
        * multiValued: false
        * required: true
        * caseExact: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * idcsMinValue: 1
        * idcsMaxValue: 5
        """
        return pulumi.get(self, "num_questions_to_setup")

    @num_questions_to_setup.setter
    def num_questions_to_setup(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_questions_to_setup", value)

    @property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ocid", value)

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @property
    @pulumi.getter
    def schemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter(name="securityQuestionSettingId")
    def security_question_setting_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the resource
        """
        return pulumi.get(self, "security_question_setting_id")

    @security_question_setting_id.setter
    def security_question_setting_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_question_setting_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSecurityQuestionSettingTagArgs']]]]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsSecurityQuestionSettingTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "tenancy_ocid")

    @tenancy_ocid.setter
    def tenancy_ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenancy_ocid", value)


class DomainsSecurityQuestionSetting(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 idcs_endpoint: Optional[pulumi.Input[str]] = None,
                 max_field_length: Optional[pulumi.Input[int]] = None,
                 min_answer_length: Optional[pulumi.Input[int]] = None,
                 num_questions_to_ans: Optional[pulumi.Input[int]] = None,
                 num_questions_to_setup: Optional[pulumi.Input[int]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_question_setting_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsSecurityQuestionSettingTagArgs']]]]] = None,
                 __props__=None):
        """
        This resource provides the Security Question Setting resource in Oracle Cloud Infrastructure Identity Domains service.

        Replace a security question setting.

        ## Import

        SecurityQuestionSettings can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Identity/domainsSecurityQuestionSetting:DomainsSecurityQuestionSetting test_security_question_setting "idcsEndpoint/{idcsEndpoint}/securityQuestionSettings/{securityQuestionSettingId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * caseExact: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[int] max_field_length: (Updatable) Indicates the maximum length of following fields Security Questions, Answer and Hint
               
               **SCIM++ Properties:**
               * type: integer
               * multiValued: false
               * returned: default
               * caseExact: false
               * mutability: readWrite
               * required: true
               * uniqueness: none
               * idcsMinValue: 5
               * idcsMaxValue: 100
        :param pulumi.Input[int] min_answer_length: (Updatable) Indicates the minimum length of answer for security questions
               
               **SCIM++ Properties:**
               * type: integer
               * multiValued: false
               * required: true
               * caseExact: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * idcsMinValue: 1
               * idcsMaxValue: 8
        :param pulumi.Input[int] num_questions_to_ans: (Updatable) Indicates the number of security questions that a user must answer
               
               **SCIM++ Properties:**
               * type: integer
               * multiValued: false
               * returned: default
               * caseExact: false
               * mutability: readWrite
               * required: true
               * uniqueness: none
               * idcsMinValue: 1
               * idcsMaxValue: 5
        :param pulumi.Input[int] num_questions_to_setup: (Updatable) Indicates the number of security questions a user must setup
               
               **SCIM++ Properties:**
               * type: integer
               * multiValued: false
               * required: true
               * caseExact: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * idcsMinValue: 1
               * idcsMaxValue: 5
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] security_question_setting_id: ID of the resource
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsSecurityQuestionSettingTagArgs']]]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainsSecurityQuestionSettingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Security Question Setting resource in Oracle Cloud Infrastructure Identity Domains service.

        Replace a security question setting.

        ## Import

        SecurityQuestionSettings can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Identity/domainsSecurityQuestionSetting:DomainsSecurityQuestionSetting test_security_question_setting "idcsEndpoint/{idcsEndpoint}/securityQuestionSettings/{securityQuestionSettingId}"
        ```

        :param str resource_name: The name of the resource.
        :param DomainsSecurityQuestionSettingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainsSecurityQuestionSettingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            DomainsSecurityQuestionSettingArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 idcs_endpoint: Optional[pulumi.Input[str]] = None,
                 max_field_length: Optional[pulumi.Input[int]] = None,
                 min_answer_length: Optional[pulumi.Input[int]] = None,
                 num_questions_to_ans: Optional[pulumi.Input[int]] = None,
                 num_questions_to_setup: Optional[pulumi.Input[int]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_question_setting_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsSecurityQuestionSettingTagArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainsSecurityQuestionSettingArgs.__new__(DomainsSecurityQuestionSettingArgs)

            __props__.__dict__["attribute_sets"] = attribute_sets
            __props__.__dict__["attributes"] = attributes
            __props__.__dict__["authorization"] = authorization
            __props__.__dict__["external_id"] = external_id
            if idcs_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'idcs_endpoint'")
            __props__.__dict__["idcs_endpoint"] = idcs_endpoint
            if max_field_length is None and not opts.urn:
                raise TypeError("Missing required property 'max_field_length'")
            __props__.__dict__["max_field_length"] = max_field_length
            if min_answer_length is None and not opts.urn:
                raise TypeError("Missing required property 'min_answer_length'")
            __props__.__dict__["min_answer_length"] = min_answer_length
            if num_questions_to_ans is None and not opts.urn:
                raise TypeError("Missing required property 'num_questions_to_ans'")
            __props__.__dict__["num_questions_to_ans"] = num_questions_to_ans
            if num_questions_to_setup is None and not opts.urn:
                raise TypeError("Missing required property 'num_questions_to_setup'")
            __props__.__dict__["num_questions_to_setup"] = num_questions_to_setup
            __props__.__dict__["ocid"] = ocid
            __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
            if schemas is None and not opts.urn:
                raise TypeError("Missing required property 'schemas'")
            __props__.__dict__["schemas"] = schemas
            if security_question_setting_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_question_setting_id'")
            __props__.__dict__["security_question_setting_id"] = security_question_setting_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["compartment_ocid"] = None
            __props__.__dict__["delete_in_progress"] = None
            __props__.__dict__["domain_ocid"] = None
            __props__.__dict__["idcs_created_bies"] = None
            __props__.__dict__["idcs_last_modified_bies"] = None
            __props__.__dict__["idcs_last_upgraded_in_release"] = None
            __props__.__dict__["idcs_prevented_operations"] = None
            __props__.__dict__["metas"] = None
            __props__.__dict__["tenancy_ocid"] = None
        super(DomainsSecurityQuestionSetting, __self__).__init__(
            'oci:Identity/domainsSecurityQuestionSetting:DomainsSecurityQuestionSetting',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            attributes: Optional[pulumi.Input[str]] = None,
            authorization: Optional[pulumi.Input[str]] = None,
            compartment_ocid: Optional[pulumi.Input[str]] = None,
            delete_in_progress: Optional[pulumi.Input[bool]] = None,
            domain_ocid: Optional[pulumi.Input[str]] = None,
            external_id: Optional[pulumi.Input[str]] = None,
            idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsSecurityQuestionSettingIdcsCreatedByArgs']]]]] = None,
            idcs_endpoint: Optional[pulumi.Input[str]] = None,
            idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsSecurityQuestionSettingIdcsLastModifiedByArgs']]]]] = None,
            idcs_last_upgraded_in_release: Optional[pulumi.Input[str]] = None,
            idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            max_field_length: Optional[pulumi.Input[int]] = None,
            metas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsSecurityQuestionSettingMetaArgs']]]]] = None,
            min_answer_length: Optional[pulumi.Input[int]] = None,
            num_questions_to_ans: Optional[pulumi.Input[int]] = None,
            num_questions_to_setup: Optional[pulumi.Input[int]] = None,
            ocid: Optional[pulumi.Input[str]] = None,
            resource_type_schema_version: Optional[pulumi.Input[str]] = None,
            schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            security_question_setting_id: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsSecurityQuestionSettingTagArgs']]]]] = None,
            tenancy_ocid: Optional[pulumi.Input[str]] = None) -> 'DomainsSecurityQuestionSetting':
        """
        Get an existing DomainsSecurityQuestionSetting resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * caseExact: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsSecurityQuestionSettingIdcsCreatedByArgs']]]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsSecurityQuestionSettingIdcsLastModifiedByArgs']]]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[int] max_field_length: (Updatable) Indicates the maximum length of following fields Security Questions, Answer and Hint
               
               **SCIM++ Properties:**
               * type: integer
               * multiValued: false
               * returned: default
               * caseExact: false
               * mutability: readWrite
               * required: true
               * uniqueness: none
               * idcsMinValue: 5
               * idcsMaxValue: 100
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsSecurityQuestionSettingMetaArgs']]]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input[int] min_answer_length: (Updatable) Indicates the minimum length of answer for security questions
               
               **SCIM++ Properties:**
               * type: integer
               * multiValued: false
               * required: true
               * caseExact: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * idcsMinValue: 1
               * idcsMaxValue: 8
        :param pulumi.Input[int] num_questions_to_ans: (Updatable) Indicates the number of security questions that a user must answer
               
               **SCIM++ Properties:**
               * type: integer
               * multiValued: false
               * returned: default
               * caseExact: false
               * mutability: readWrite
               * required: true
               * uniqueness: none
               * idcsMinValue: 1
               * idcsMaxValue: 5
        :param pulumi.Input[int] num_questions_to_setup: (Updatable) Indicates the number of security questions a user must setup
               
               **SCIM++ Properties:**
               * type: integer
               * multiValued: false
               * required: true
               * caseExact: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
               * idcsMinValue: 1
               * idcsMaxValue: 5
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] security_question_setting_id: ID of the resource
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsSecurityQuestionSettingTagArgs']]]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainsSecurityQuestionSettingState.__new__(_DomainsSecurityQuestionSettingState)

        __props__.__dict__["attribute_sets"] = attribute_sets
        __props__.__dict__["attributes"] = attributes
        __props__.__dict__["authorization"] = authorization
        __props__.__dict__["compartment_ocid"] = compartment_ocid
        __props__.__dict__["delete_in_progress"] = delete_in_progress
        __props__.__dict__["domain_ocid"] = domain_ocid
        __props__.__dict__["external_id"] = external_id
        __props__.__dict__["idcs_created_bies"] = idcs_created_bies
        __props__.__dict__["idcs_endpoint"] = idcs_endpoint
        __props__.__dict__["idcs_last_modified_bies"] = idcs_last_modified_bies
        __props__.__dict__["idcs_last_upgraded_in_release"] = idcs_last_upgraded_in_release
        __props__.__dict__["idcs_prevented_operations"] = idcs_prevented_operations
        __props__.__dict__["max_field_length"] = max_field_length
        __props__.__dict__["metas"] = metas
        __props__.__dict__["min_answer_length"] = min_answer_length
        __props__.__dict__["num_questions_to_ans"] = num_questions_to_ans
        __props__.__dict__["num_questions_to_setup"] = num_questions_to_setup
        __props__.__dict__["ocid"] = ocid
        __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
        __props__.__dict__["schemas"] = schemas
        __props__.__dict__["security_question_setting_id"] = security_question_setting_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenancy_ocid"] = tenancy_ocid
        return DomainsSecurityQuestionSetting(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def authorization(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> pulumi.Output[bool]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Output[str]:
        """
        (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * caseExact: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> pulumi.Output[Sequence['outputs.DomainsSecurityQuestionSettingIdcsCreatedBy']]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Output[str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> pulumi.Output[Sequence['outputs.DomainsSecurityQuestionSettingIdcsLastModifiedBy']]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> pulumi.Output[str]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @property
    @pulumi.getter(name="maxFieldLength")
    def max_field_length(self) -> pulumi.Output[int]:
        """
        (Updatable) Indicates the maximum length of following fields Security Questions, Answer and Hint

        **SCIM++ Properties:**
        * type: integer
        * multiValued: false
        * returned: default
        * caseExact: false
        * mutability: readWrite
        * required: true
        * uniqueness: none
        * idcsMinValue: 5
        * idcsMaxValue: 100
        """
        return pulumi.get(self, "max_field_length")

    @property
    @pulumi.getter
    def metas(self) -> pulumi.Output[Sequence['outputs.DomainsSecurityQuestionSettingMeta']]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @property
    @pulumi.getter(name="minAnswerLength")
    def min_answer_length(self) -> pulumi.Output[int]:
        """
        (Updatable) Indicates the minimum length of answer for security questions

        **SCIM++ Properties:**
        * type: integer
        * multiValued: false
        * required: true
        * caseExact: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * idcsMinValue: 1
        * idcsMaxValue: 8
        """
        return pulumi.get(self, "min_answer_length")

    @property
    @pulumi.getter(name="numQuestionsToAns")
    def num_questions_to_ans(self) -> pulumi.Output[int]:
        """
        (Updatable) Indicates the number of security questions that a user must answer

        **SCIM++ Properties:**
        * type: integer
        * multiValued: false
        * returned: default
        * caseExact: false
        * mutability: readWrite
        * required: true
        * uniqueness: none
        * idcsMinValue: 1
        * idcsMaxValue: 5
        """
        return pulumi.get(self, "num_questions_to_ans")

    @property
    @pulumi.getter(name="numQuestionsToSetup")
    def num_questions_to_setup(self) -> pulumi.Output[int]:
        """
        (Updatable) Indicates the number of security questions a user must setup

        **SCIM++ Properties:**
        * type: integer
        * multiValued: false
        * required: true
        * caseExact: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        * idcsMinValue: 1
        * idcsMaxValue: 5
        """
        return pulumi.get(self, "num_questions_to_setup")

    @property
    @pulumi.getter
    def ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @property
    @pulumi.getter(name="securityQuestionSettingId")
    def security_question_setting_id(self) -> pulumi.Output[str]:
        """
        ID of the resource
        """
        return pulumi.get(self, "security_question_setting_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.DomainsSecurityQuestionSettingTag']]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "tenancy_ocid")

