# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'OdaInstanceRestrictedOperation',
    'OdaPrivateEndpointScanProxyScanListenerInfo',
    'GetOdaInstanceRestrictedOperationResult',
    'GetOdaInstancesFilterResult',
    'GetOdaInstancesOdaInstanceResult',
    'GetOdaInstancesOdaInstanceRestrictedOperationResult',
    'GetOdaPrivateEndpointAttachmentsFilterResult',
    'GetOdaPrivateEndpointAttachmentsOdaPrivateEndpointAttachmentCollectionResult',
    'GetOdaPrivateEndpointAttachmentsOdaPrivateEndpointAttachmentCollectionItemResult',
    'GetOdaPrivateEndpointScanProxiesFilterResult',
    'GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionResult',
    'GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionItemResult',
    'GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionItemScanListenerInfoResult',
    'GetOdaPrivateEndpointScanProxyScanListenerInfoResult',
    'GetOdaPrivateEndpointsFilterResult',
    'GetOdaPrivateEndpointsOdaPrivateEndpointCollectionResult',
    'GetOdaPrivateEndpointsOdaPrivateEndpointCollectionItemResult',
]

@pulumi.output_type
class OdaInstanceRestrictedOperation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operationName":
            suggest = "operation_name"
        elif key == "restrictingService":
            suggest = "restricting_service"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OdaInstanceRestrictedOperation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OdaInstanceRestrictedOperation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OdaInstanceRestrictedOperation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operation_name: Optional[str] = None,
                 restricting_service: Optional[str] = None):
        """
        :param str operation_name: Name of the restricted operation.
        :param str restricting_service: Name of the service restricting the operation.
        """
        OdaInstanceRestrictedOperation._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            operation_name=operation_name,
            restricting_service=restricting_service,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             operation_name: Optional[str] = None,
             restricting_service: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'operationName' in kwargs:
            operation_name = kwargs['operationName']
        if 'restrictingService' in kwargs:
            restricting_service = kwargs['restrictingService']

        if operation_name is not None:
            _setter("operation_name", operation_name)
        if restricting_service is not None:
            _setter("restricting_service", restricting_service)

    @property
    @pulumi.getter(name="operationName")
    def operation_name(self) -> Optional[str]:
        """
        Name of the restricted operation.
        """
        return pulumi.get(self, "operation_name")

    @property
    @pulumi.getter(name="restrictingService")
    def restricting_service(self) -> Optional[str]:
        """
        Name of the service restricting the operation.
        """
        return pulumi.get(self, "restricting_service")


@pulumi.output_type
class OdaPrivateEndpointScanProxyScanListenerInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scanListenerFqdn":
            suggest = "scan_listener_fqdn"
        elif key == "scanListenerIp":
            suggest = "scan_listener_ip"
        elif key == "scanListenerPort":
            suggest = "scan_listener_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OdaPrivateEndpointScanProxyScanListenerInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OdaPrivateEndpointScanProxyScanListenerInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OdaPrivateEndpointScanProxyScanListenerInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scan_listener_fqdn: Optional[str] = None,
                 scan_listener_ip: Optional[str] = None,
                 scan_listener_port: Optional[int] = None):
        """
        :param str scan_listener_fqdn: FQDN of the customer's Real Application Cluster (RAC)'s SCAN listeners.
        :param str scan_listener_ip: A SCAN listener's IP of the customer's Real Application Cluster (RAC).
        :param int scan_listener_port: The port that customer's Real Application Cluster (RAC)'s SCAN listeners are listening on.
        """
        OdaPrivateEndpointScanProxyScanListenerInfo._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            scan_listener_fqdn=scan_listener_fqdn,
            scan_listener_ip=scan_listener_ip,
            scan_listener_port=scan_listener_port,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             scan_listener_fqdn: Optional[str] = None,
             scan_listener_ip: Optional[str] = None,
             scan_listener_port: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'scanListenerFqdn' in kwargs:
            scan_listener_fqdn = kwargs['scanListenerFqdn']
        if 'scanListenerIp' in kwargs:
            scan_listener_ip = kwargs['scanListenerIp']
        if 'scanListenerPort' in kwargs:
            scan_listener_port = kwargs['scanListenerPort']

        if scan_listener_fqdn is not None:
            _setter("scan_listener_fqdn", scan_listener_fqdn)
        if scan_listener_ip is not None:
            _setter("scan_listener_ip", scan_listener_ip)
        if scan_listener_port is not None:
            _setter("scan_listener_port", scan_listener_port)

    @property
    @pulumi.getter(name="scanListenerFqdn")
    def scan_listener_fqdn(self) -> Optional[str]:
        """
        FQDN of the customer's Real Application Cluster (RAC)'s SCAN listeners.
        """
        return pulumi.get(self, "scan_listener_fqdn")

    @property
    @pulumi.getter(name="scanListenerIp")
    def scan_listener_ip(self) -> Optional[str]:
        """
        A SCAN listener's IP of the customer's Real Application Cluster (RAC).
        """
        return pulumi.get(self, "scan_listener_ip")

    @property
    @pulumi.getter(name="scanListenerPort")
    def scan_listener_port(self) -> Optional[int]:
        """
        The port that customer's Real Application Cluster (RAC)'s SCAN listeners are listening on.
        """
        return pulumi.get(self, "scan_listener_port")


@pulumi.output_type
class GetOdaInstanceRestrictedOperationResult(dict):
    def __init__(__self__, *,
                 operation_name: str,
                 restricting_service: str):
        """
        :param str operation_name: Name of the restricted operation.
        :param str restricting_service: Name of the service restricting the operation.
        """
        GetOdaInstanceRestrictedOperationResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            operation_name=operation_name,
            restricting_service=restricting_service,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             operation_name: str,
             restricting_service: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'operationName' in kwargs:
            operation_name = kwargs['operationName']
        if 'restrictingService' in kwargs:
            restricting_service = kwargs['restrictingService']

        _setter("operation_name", operation_name)
        _setter("restricting_service", restricting_service)

    @property
    @pulumi.getter(name="operationName")
    def operation_name(self) -> str:
        """
        Name of the restricted operation.
        """
        return pulumi.get(self, "operation_name")

    @property
    @pulumi.getter(name="restrictingService")
    def restricting_service(self) -> str:
        """
        Name of the service restricting the operation.
        """
        return pulumi.get(self, "restricting_service")


@pulumi.output_type
class GetOdaInstancesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetOdaInstancesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetOdaInstancesOdaInstanceResult(dict):
    def __init__(__self__, *,
                 attachment_ids: Sequence[str],
                 attachment_types: Sequence[str],
                 compartment_id: str,
                 connector_url: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 identity_app_console_url: str,
                 identity_app_guid: str,
                 identity_domain: str,
                 imported_package_ids: Sequence[str],
                 imported_package_names: Sequence[str],
                 is_role_based_access: bool,
                 lifecycle_sub_state: str,
                 restricted_operations: Sequence['outputs.GetOdaInstancesOdaInstanceRestrictedOperationResult'],
                 shape_name: str,
                 state: str,
                 state_message: str,
                 time_created: str,
                 time_updated: str,
                 web_app_url: str):
        """
        :param Sequence[str] attachment_ids: A list of attachment identifiers for this instance (if any). Use GetOdaInstanceAttachment to get the details of the attachments.
        :param Sequence[str] attachment_types: A list of attachment types for this instance (if any). Use attachmentIds to get the details of the attachments.
        :param str compartment_id: List the Digital Assistant instances that belong to this compartment.
        :param str connector_url: URL for the connector's endpoint.
        :param Mapping[str, Any] defined_tags: Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param str description: Description of the Digital Assistant instance.
        :param str display_name: List only the information for the Digital Assistant instance with this user-friendly name. These names don't have to be unique and may change.  Example: `My new resource`
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type, or scope. Example: `{"bar-key": "value"}`
        :param str id: Unique immutable identifier that was assigned when the instance was created.
        :param str identity_app_console_url: If isRoleBasedAccess is set to true, this property specifies the URL for the administration console used to manage the Identity Application instance Digital Assistant has created inside the user-specified identity domain.
        :param str identity_app_guid: If isRoleBasedAccess is set to true, this property specifies the GUID of the Identity Application instance Digital Assistant has created inside the user-specified identity domain. This identity application instance may be used to host user roll mappings to grant access to this Digital Assistant instance for users within the identity domain.
        :param str identity_domain: If isRoleBasedAccess is set to true, this property specifies the identity domain that is to be used to implement this type of authorzation. Digital Assistant will create an Identity Application instance and Application Roles within this identity domain. The caller may then perform and user roll mappings they like to grant access to users within the identity domain.
        :param Sequence[str] imported_package_ids: A list of package ids imported into this instance (if any). Use GetImportedPackage to get the details of the imported packages.
        :param Sequence[str] imported_package_names: A list of package names imported into this instance (if any). Use importedPackageIds field to get the details of the imported packages.
        :param bool is_role_based_access: Should this Digital Assistant instance use role-based authorization via an identity domain (true) or use the default policy-based authorization via IAM policies (false)
        :param str lifecycle_sub_state: The current sub-state of the Digital Assistant instance.
        :param Sequence['GetOdaInstancesOdaInstanceRestrictedOperationArgs'] restricted_operations: A list of restricted operations (across all attachments) for this instance (if any). Use GetOdaInstanceAttachment to get the details of the attachments.
        :param str shape_name: Shape or size of the instance.
        :param str state: List only the Digital Assistant instances that are in this lifecycle state.
        :param str state_message: A message that describes the current state in more detail. For example, actionable information about an instance that's in the `FAILED` state.
        :param str time_created: When the Digital Assistant instance was created. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        :param str time_updated: When the Digital Assistance instance was last updated. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        :param str web_app_url: URL for the Digital Assistant web application that's associated with the instance.
        """
        GetOdaInstancesOdaInstanceResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            attachment_ids=attachment_ids,
            attachment_types=attachment_types,
            compartment_id=compartment_id,
            connector_url=connector_url,
            defined_tags=defined_tags,
            description=description,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            identity_app_console_url=identity_app_console_url,
            identity_app_guid=identity_app_guid,
            identity_domain=identity_domain,
            imported_package_ids=imported_package_ids,
            imported_package_names=imported_package_names,
            is_role_based_access=is_role_based_access,
            lifecycle_sub_state=lifecycle_sub_state,
            restricted_operations=restricted_operations,
            shape_name=shape_name,
            state=state,
            state_message=state_message,
            time_created=time_created,
            time_updated=time_updated,
            web_app_url=web_app_url,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             attachment_ids: Sequence[str],
             attachment_types: Sequence[str],
             compartment_id: str,
             connector_url: str,
             defined_tags: Mapping[str, Any],
             description: str,
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             identity_app_console_url: str,
             identity_app_guid: str,
             identity_domain: str,
             imported_package_ids: Sequence[str],
             imported_package_names: Sequence[str],
             is_role_based_access: bool,
             lifecycle_sub_state: str,
             restricted_operations: Sequence['outputs.GetOdaInstancesOdaInstanceRestrictedOperationResult'],
             shape_name: str,
             state: str,
             state_message: str,
             time_created: str,
             time_updated: str,
             web_app_url: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'attachmentIds' in kwargs:
            attachment_ids = kwargs['attachmentIds']
        if 'attachmentTypes' in kwargs:
            attachment_types = kwargs['attachmentTypes']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'connectorUrl' in kwargs:
            connector_url = kwargs['connectorUrl']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'identityAppConsoleUrl' in kwargs:
            identity_app_console_url = kwargs['identityAppConsoleUrl']
        if 'identityAppGuid' in kwargs:
            identity_app_guid = kwargs['identityAppGuid']
        if 'identityDomain' in kwargs:
            identity_domain = kwargs['identityDomain']
        if 'importedPackageIds' in kwargs:
            imported_package_ids = kwargs['importedPackageIds']
        if 'importedPackageNames' in kwargs:
            imported_package_names = kwargs['importedPackageNames']
        if 'isRoleBasedAccess' in kwargs:
            is_role_based_access = kwargs['isRoleBasedAccess']
        if 'lifecycleSubState' in kwargs:
            lifecycle_sub_state = kwargs['lifecycleSubState']
        if 'restrictedOperations' in kwargs:
            restricted_operations = kwargs['restrictedOperations']
        if 'shapeName' in kwargs:
            shape_name = kwargs['shapeName']
        if 'stateMessage' in kwargs:
            state_message = kwargs['stateMessage']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']
        if 'webAppUrl' in kwargs:
            web_app_url = kwargs['webAppUrl']

        _setter("attachment_ids", attachment_ids)
        _setter("attachment_types", attachment_types)
        _setter("compartment_id", compartment_id)
        _setter("connector_url", connector_url)
        _setter("defined_tags", defined_tags)
        _setter("description", description)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("identity_app_console_url", identity_app_console_url)
        _setter("identity_app_guid", identity_app_guid)
        _setter("identity_domain", identity_domain)
        _setter("imported_package_ids", imported_package_ids)
        _setter("imported_package_names", imported_package_names)
        _setter("is_role_based_access", is_role_based_access)
        _setter("lifecycle_sub_state", lifecycle_sub_state)
        _setter("restricted_operations", restricted_operations)
        _setter("shape_name", shape_name)
        _setter("state", state)
        _setter("state_message", state_message)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)
        _setter("web_app_url", web_app_url)

    @property
    @pulumi.getter(name="attachmentIds")
    def attachment_ids(self) -> Sequence[str]:
        """
        A list of attachment identifiers for this instance (if any). Use GetOdaInstanceAttachment to get the details of the attachments.
        """
        return pulumi.get(self, "attachment_ids")

    @property
    @pulumi.getter(name="attachmentTypes")
    def attachment_types(self) -> Sequence[str]:
        """
        A list of attachment types for this instance (if any). Use attachmentIds to get the details of the attachments.
        """
        return pulumi.get(self, "attachment_types")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        List the Digital Assistant instances that belong to this compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectorUrl")
    def connector_url(self) -> str:
        """
        URL for the connector's endpoint.
        """
        return pulumi.get(self, "connector_url")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the Digital Assistant instance.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        List only the information for the Digital Assistant instance with this user-friendly name. These names don't have to be unique and may change.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type, or scope. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique immutable identifier that was assigned when the instance was created.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="identityAppConsoleUrl")
    def identity_app_console_url(self) -> str:
        """
        If isRoleBasedAccess is set to true, this property specifies the URL for the administration console used to manage the Identity Application instance Digital Assistant has created inside the user-specified identity domain.
        """
        return pulumi.get(self, "identity_app_console_url")

    @property
    @pulumi.getter(name="identityAppGuid")
    def identity_app_guid(self) -> str:
        """
        If isRoleBasedAccess is set to true, this property specifies the GUID of the Identity Application instance Digital Assistant has created inside the user-specified identity domain. This identity application instance may be used to host user roll mappings to grant access to this Digital Assistant instance for users within the identity domain.
        """
        return pulumi.get(self, "identity_app_guid")

    @property
    @pulumi.getter(name="identityDomain")
    def identity_domain(self) -> str:
        """
        If isRoleBasedAccess is set to true, this property specifies the identity domain that is to be used to implement this type of authorzation. Digital Assistant will create an Identity Application instance and Application Roles within this identity domain. The caller may then perform and user roll mappings they like to grant access to users within the identity domain.
        """
        return pulumi.get(self, "identity_domain")

    @property
    @pulumi.getter(name="importedPackageIds")
    def imported_package_ids(self) -> Sequence[str]:
        """
        A list of package ids imported into this instance (if any). Use GetImportedPackage to get the details of the imported packages.
        """
        return pulumi.get(self, "imported_package_ids")

    @property
    @pulumi.getter(name="importedPackageNames")
    def imported_package_names(self) -> Sequence[str]:
        """
        A list of package names imported into this instance (if any). Use importedPackageIds field to get the details of the imported packages.
        """
        return pulumi.get(self, "imported_package_names")

    @property
    @pulumi.getter(name="isRoleBasedAccess")
    def is_role_based_access(self) -> bool:
        """
        Should this Digital Assistant instance use role-based authorization via an identity domain (true) or use the default policy-based authorization via IAM policies (false)
        """
        return pulumi.get(self, "is_role_based_access")

    @property
    @pulumi.getter(name="lifecycleSubState")
    def lifecycle_sub_state(self) -> str:
        """
        The current sub-state of the Digital Assistant instance.
        """
        return pulumi.get(self, "lifecycle_sub_state")

    @property
    @pulumi.getter(name="restrictedOperations")
    def restricted_operations(self) -> Sequence['outputs.GetOdaInstancesOdaInstanceRestrictedOperationResult']:
        """
        A list of restricted operations (across all attachments) for this instance (if any). Use GetOdaInstanceAttachment to get the details of the attachments.
        """
        return pulumi.get(self, "restricted_operations")

    @property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> str:
        """
        Shape or size of the instance.
        """
        return pulumi.get(self, "shape_name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        List only the Digital Assistant instances that are in this lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> str:
        """
        A message that describes the current state in more detail. For example, actionable information about an instance that's in the `FAILED` state.
        """
        return pulumi.get(self, "state_message")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        When the Digital Assistant instance was created. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        When the Digital Assistance instance was last updated. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="webAppUrl")
    def web_app_url(self) -> str:
        """
        URL for the Digital Assistant web application that's associated with the instance.
        """
        return pulumi.get(self, "web_app_url")


@pulumi.output_type
class GetOdaInstancesOdaInstanceRestrictedOperationResult(dict):
    def __init__(__self__, *,
                 operation_name: str,
                 restricting_service: str):
        """
        :param str operation_name: Name of the restricted operation.
        :param str restricting_service: Name of the service restricting the operation.
        """
        GetOdaInstancesOdaInstanceRestrictedOperationResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            operation_name=operation_name,
            restricting_service=restricting_service,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             operation_name: str,
             restricting_service: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'operationName' in kwargs:
            operation_name = kwargs['operationName']
        if 'restrictingService' in kwargs:
            restricting_service = kwargs['restrictingService']

        _setter("operation_name", operation_name)
        _setter("restricting_service", restricting_service)

    @property
    @pulumi.getter(name="operationName")
    def operation_name(self) -> str:
        """
        Name of the restricted operation.
        """
        return pulumi.get(self, "operation_name")

    @property
    @pulumi.getter(name="restrictingService")
    def restricting_service(self) -> str:
        """
        Name of the service restricting the operation.
        """
        return pulumi.get(self, "restricting_service")


@pulumi.output_type
class GetOdaPrivateEndpointAttachmentsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetOdaPrivateEndpointAttachmentsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetOdaPrivateEndpointAttachmentsOdaPrivateEndpointAttachmentCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetOdaPrivateEndpointAttachmentsOdaPrivateEndpointAttachmentCollectionItemResult']):
        GetOdaPrivateEndpointAttachmentsOdaPrivateEndpointAttachmentCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetOdaPrivateEndpointAttachmentsOdaPrivateEndpointAttachmentCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetOdaPrivateEndpointAttachmentsOdaPrivateEndpointAttachmentCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetOdaPrivateEndpointAttachmentsOdaPrivateEndpointAttachmentCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 id: str,
                 oda_instance_id: str,
                 oda_private_endpoint_id: str,
                 state: str,
                 time_created: str,
                 time_updated: str):
        """
        :param str compartment_id: List the ODA Private Endpoint Attachments that belong to this compartment.
        :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ODA Private Endpoint Attachment.
        :param str oda_instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the attached ODA Instance.
        :param str oda_private_endpoint_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of ODA Private Endpoint.
        :param str state: List only the ODA Private Endpoint Attachments that are in this lifecycle state.
        :param str time_created: When the resource was created. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        :param str time_updated: When the resource was last updated. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        GetOdaPrivateEndpointAttachmentsOdaPrivateEndpointAttachmentCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            id=id,
            oda_instance_id=oda_instance_id,
            oda_private_endpoint_id=oda_private_endpoint_id,
            state=state,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             id: str,
             oda_instance_id: str,
             oda_private_endpoint_id: str,
             state: str,
             time_created: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'odaInstanceId' in kwargs:
            oda_instance_id = kwargs['odaInstanceId']
        if 'odaPrivateEndpointId' in kwargs:
            oda_private_endpoint_id = kwargs['odaPrivateEndpointId']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        _setter("compartment_id", compartment_id)
        _setter("id", id)
        _setter("oda_instance_id", oda_instance_id)
        _setter("oda_private_endpoint_id", oda_private_endpoint_id)
        _setter("state", state)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        List the ODA Private Endpoint Attachments that belong to this compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ODA Private Endpoint Attachment.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="odaInstanceId")
    def oda_instance_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the attached ODA Instance.
        """
        return pulumi.get(self, "oda_instance_id")

    @property
    @pulumi.getter(name="odaPrivateEndpointId")
    def oda_private_endpoint_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of ODA Private Endpoint.
        """
        return pulumi.get(self, "oda_private_endpoint_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        List only the ODA Private Endpoint Attachments that are in this lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        When the resource was created. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        When the resource was last updated. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetOdaPrivateEndpointScanProxiesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetOdaPrivateEndpointScanProxiesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionItemResult']):
        GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionItemResult(dict):
    def __init__(__self__, *,
                 id: str,
                 oda_private_endpoint_id: str,
                 protocol: str,
                 scan_listener_infos: Sequence['outputs.GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionItemScanListenerInfoResult'],
                 scan_listener_type: str,
                 state: str,
                 time_created: str):
        """
        :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ODA Private Endpoint Scan Proxy.
        :param str oda_private_endpoint_id: Unique ODA Private Endpoint identifier which is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param str protocol: The protocol used for communication between client, scanProxy and RAC's scan listeners
        :param Sequence['GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionItemScanListenerInfoArgs'] scan_listener_infos: The FQDN/IPs and port information of customer's Real Application Cluster (RAC)'s SCAN listeners.
        :param str scan_listener_type: Type indicating whether Scan listener is specified by its FQDN or list of IPs
        :param str state: List only the ODA Private Endpoint Scan Proxies that are in this lifecycle state.
        :param str time_created: When the resource was created. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            id=id,
            oda_private_endpoint_id=oda_private_endpoint_id,
            protocol=protocol,
            scan_listener_infos=scan_listener_infos,
            scan_listener_type=scan_listener_type,
            state=state,
            time_created=time_created,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             id: str,
             oda_private_endpoint_id: str,
             protocol: str,
             scan_listener_infos: Sequence['outputs.GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionItemScanListenerInfoResult'],
             scan_listener_type: str,
             state: str,
             time_created: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'odaPrivateEndpointId' in kwargs:
            oda_private_endpoint_id = kwargs['odaPrivateEndpointId']
        if 'scanListenerInfos' in kwargs:
            scan_listener_infos = kwargs['scanListenerInfos']
        if 'scanListenerType' in kwargs:
            scan_listener_type = kwargs['scanListenerType']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']

        _setter("id", id)
        _setter("oda_private_endpoint_id", oda_private_endpoint_id)
        _setter("protocol", protocol)
        _setter("scan_listener_infos", scan_listener_infos)
        _setter("scan_listener_type", scan_listener_type)
        _setter("state", state)
        _setter("time_created", time_created)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ODA Private Endpoint Scan Proxy.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="odaPrivateEndpointId")
    def oda_private_endpoint_id(self) -> str:
        """
        Unique ODA Private Endpoint identifier which is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "oda_private_endpoint_id")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocol used for communication between client, scanProxy and RAC's scan listeners
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="scanListenerInfos")
    def scan_listener_infos(self) -> Sequence['outputs.GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionItemScanListenerInfoResult']:
        """
        The FQDN/IPs and port information of customer's Real Application Cluster (RAC)'s SCAN listeners.
        """
        return pulumi.get(self, "scan_listener_infos")

    @property
    @pulumi.getter(name="scanListenerType")
    def scan_listener_type(self) -> str:
        """
        Type indicating whether Scan listener is specified by its FQDN or list of IPs
        """
        return pulumi.get(self, "scan_listener_type")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        List only the ODA Private Endpoint Scan Proxies that are in this lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        When the resource was created. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionItemScanListenerInfoResult(dict):
    def __init__(__self__, *,
                 scan_listener_fqdn: str,
                 scan_listener_ip: str,
                 scan_listener_port: int):
        """
        :param str scan_listener_fqdn: FQDN of the customer's Real Application Cluster (RAC)'s SCAN listeners.
        :param str scan_listener_ip: A SCAN listener's IP of the customer's Real Application Cluster (RAC).
        :param int scan_listener_port: The port that customer's Real Application Cluster (RAC)'s SCAN listeners are listening on.
        """
        GetOdaPrivateEndpointScanProxiesOdaPrivateEndpointScanProxyCollectionItemScanListenerInfoResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            scan_listener_fqdn=scan_listener_fqdn,
            scan_listener_ip=scan_listener_ip,
            scan_listener_port=scan_listener_port,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             scan_listener_fqdn: str,
             scan_listener_ip: str,
             scan_listener_port: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'scanListenerFqdn' in kwargs:
            scan_listener_fqdn = kwargs['scanListenerFqdn']
        if 'scanListenerIp' in kwargs:
            scan_listener_ip = kwargs['scanListenerIp']
        if 'scanListenerPort' in kwargs:
            scan_listener_port = kwargs['scanListenerPort']

        _setter("scan_listener_fqdn", scan_listener_fqdn)
        _setter("scan_listener_ip", scan_listener_ip)
        _setter("scan_listener_port", scan_listener_port)

    @property
    @pulumi.getter(name="scanListenerFqdn")
    def scan_listener_fqdn(self) -> str:
        """
        FQDN of the customer's Real Application Cluster (RAC)'s SCAN listeners.
        """
        return pulumi.get(self, "scan_listener_fqdn")

    @property
    @pulumi.getter(name="scanListenerIp")
    def scan_listener_ip(self) -> str:
        """
        A SCAN listener's IP of the customer's Real Application Cluster (RAC).
        """
        return pulumi.get(self, "scan_listener_ip")

    @property
    @pulumi.getter(name="scanListenerPort")
    def scan_listener_port(self) -> int:
        """
        The port that customer's Real Application Cluster (RAC)'s SCAN listeners are listening on.
        """
        return pulumi.get(self, "scan_listener_port")


@pulumi.output_type
class GetOdaPrivateEndpointScanProxyScanListenerInfoResult(dict):
    def __init__(__self__, *,
                 scan_listener_fqdn: str,
                 scan_listener_ip: str,
                 scan_listener_port: int):
        """
        :param str scan_listener_fqdn: FQDN of the customer's Real Application Cluster (RAC)'s SCAN listeners.
        :param str scan_listener_ip: A SCAN listener's IP of the customer's Real Application Cluster (RAC).
        :param int scan_listener_port: The port that customer's Real Application Cluster (RAC)'s SCAN listeners are listening on.
        """
        GetOdaPrivateEndpointScanProxyScanListenerInfoResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            scan_listener_fqdn=scan_listener_fqdn,
            scan_listener_ip=scan_listener_ip,
            scan_listener_port=scan_listener_port,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             scan_listener_fqdn: str,
             scan_listener_ip: str,
             scan_listener_port: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'scanListenerFqdn' in kwargs:
            scan_listener_fqdn = kwargs['scanListenerFqdn']
        if 'scanListenerIp' in kwargs:
            scan_listener_ip = kwargs['scanListenerIp']
        if 'scanListenerPort' in kwargs:
            scan_listener_port = kwargs['scanListenerPort']

        _setter("scan_listener_fqdn", scan_listener_fqdn)
        _setter("scan_listener_ip", scan_listener_ip)
        _setter("scan_listener_port", scan_listener_port)

    @property
    @pulumi.getter(name="scanListenerFqdn")
    def scan_listener_fqdn(self) -> str:
        """
        FQDN of the customer's Real Application Cluster (RAC)'s SCAN listeners.
        """
        return pulumi.get(self, "scan_listener_fqdn")

    @property
    @pulumi.getter(name="scanListenerIp")
    def scan_listener_ip(self) -> str:
        """
        A SCAN listener's IP of the customer's Real Application Cluster (RAC).
        """
        return pulumi.get(self, "scan_listener_ip")

    @property
    @pulumi.getter(name="scanListenerPort")
    def scan_listener_port(self) -> int:
        """
        The port that customer's Real Application Cluster (RAC)'s SCAN listeners are listening on.
        """
        return pulumi.get(self, "scan_listener_port")


@pulumi.output_type
class GetOdaPrivateEndpointsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetOdaPrivateEndpointsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetOdaPrivateEndpointsOdaPrivateEndpointCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetOdaPrivateEndpointsOdaPrivateEndpointCollectionItemResult']):
        GetOdaPrivateEndpointsOdaPrivateEndpointCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetOdaPrivateEndpointsOdaPrivateEndpointCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetOdaPrivateEndpointsOdaPrivateEndpointCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetOdaPrivateEndpointsOdaPrivateEndpointCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 nsg_ids: Sequence[str],
                 state: str,
                 subnet_id: str,
                 time_created: str,
                 time_updated: str):
        """
        :param str compartment_id: List the ODA Private Endpoints that belong to this compartment.
        :param Mapping[str, Any] defined_tags: Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param str description: Description of the ODA private endpoint.
        :param str display_name: List only the information for the Digital Assistant instance with this user-friendly name. These names don't have to be unique and may change.  Example: `My new resource`
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type, or scope. Example: `{"bar-key": "value"}`
        :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that was assigned when the ODA private endpoint was created.
        :param Sequence[str] nsg_ids: List of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of [network security groups](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/networksecuritygroups.htm)
        :param str state: List only the ODA Private Endpoints that are in this lifecycle state.
        :param str subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet that the private endpoint belongs to.
        :param str time_created: When the resource was created. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        :param str time_updated: When the resource was last updated. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        GetOdaPrivateEndpointsOdaPrivateEndpointCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            description=description,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            nsg_ids=nsg_ids,
            state=state,
            subnet_id=subnet_id,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             description: str,
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             nsg_ids: Sequence[str],
             state: str,
             subnet_id: str,
             time_created: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'nsgIds' in kwargs:
            nsg_ids = kwargs['nsgIds']
        if 'subnetId' in kwargs:
            subnet_id = kwargs['subnetId']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("description", description)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("nsg_ids", nsg_ids)
        _setter("state", state)
        _setter("subnet_id", subnet_id)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        List the ODA Private Endpoints that belong to this compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the ODA private endpoint.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        List only the information for the Digital Assistant instance with this user-friendly name. These names don't have to be unique and may change.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type, or scope. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that was assigned when the ODA private endpoint was created.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[str]:
        """
        List of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of [network security groups](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/networksecuritygroups.htm)
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        List only the ODA Private Endpoints that are in this lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet that the private endpoint belongs to.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        When the resource was created. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        When the resource was last updated. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_updated")


