# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ProfileLevelsConfiguration',
    'ProfileLevelsConfigurationItem',
    'ProfileTargetCompartments',
    'ProfileTargetTags',
    'ProfileTargetTagsItem',
    'RecommendationResourceCount',
    'RecommendationSupportedLevel',
    'RecommendationSupportedLevelItem',
    'ResourceActionAction',
    'GetCategoriesCategoryCollectionResult',
    'GetCategoriesCategoryCollectionItemResult',
    'GetCategoriesCategoryCollectionItemRecommendationCountResult',
    'GetCategoriesCategoryCollectionItemResourceCountResult',
    'GetCategoriesFilterResult',
    'GetCategoryRecommendationCountResult',
    'GetCategoryResourceCountResult',
    'GetEnrollmentStatusesEnrollmentStatusCollectionResult',
    'GetEnrollmentStatusesEnrollmentStatusCollectionItemResult',
    'GetEnrollmentStatusesFilterResult',
    'GetHistoriesFilterResult',
    'GetHistoriesHistoryCollectionResult',
    'GetHistoriesHistoryCollectionItemResult',
    'GetHistoriesHistoryCollectionItemActionResult',
    'GetProfileLevelItemResult',
    'GetProfileLevelItemMetricResult',
    'GetProfileLevelsConfigurationResult',
    'GetProfileLevelsConfigurationItemResult',
    'GetProfileLevelsFilterResult',
    'GetProfileLevelsProfileLevelCollectionResult',
    'GetProfileLevelsProfileLevelCollectionItemResult',
    'GetProfileLevelsProfileLevelCollectionItemMetricResult',
    'GetProfileTargetCompartmentResult',
    'GetProfileTargetTagResult',
    'GetProfileTargetTagItemResult',
    'GetProfilesFilterResult',
    'GetProfilesProfileCollectionResult',
    'GetProfilesProfileCollectionItemResult',
    'GetProfilesProfileCollectionItemLevelsConfigurationResult',
    'GetProfilesProfileCollectionItemLevelsConfigurationItemResult',
    'GetProfilesProfileCollectionItemTargetCompartmentResult',
    'GetProfilesProfileCollectionItemTargetTagResult',
    'GetProfilesProfileCollectionItemTargetTagItemResult',
    'GetRecommendationResourceCountResult',
    'GetRecommendationStrategiesFilterResult',
    'GetRecommendationStrategiesRecommendationStrategyCollectionResult',
    'GetRecommendationStrategiesRecommendationStrategyCollectionItemResult',
    'GetRecommendationStrategiesRecommendationStrategyCollectionItemStrategyResult',
    'GetRecommendationStrategiesRecommendationStrategyCollectionItemStrategyParametersDefinitionResult',
    'GetRecommendationStrategyItemResult',
    'GetRecommendationStrategyItemStrategyResult',
    'GetRecommendationStrategyItemStrategyParametersDefinitionResult',
    'GetRecommendationSupportedLevelResult',
    'GetRecommendationSupportedLevelItemResult',
    'GetRecommendationsFilterResult',
    'GetRecommendationsRecommendationCollectionResult',
    'GetRecommendationsRecommendationCollectionItemResult',
    'GetRecommendationsRecommendationCollectionItemResourceCountResult',
    'GetRecommendationsRecommendationCollectionItemSupportedLevelResult',
    'GetRecommendationsRecommendationCollectionItemSupportedLevelItemResult',
    'GetResourceActionActionResult',
    'GetResourceActionsFilterResult',
    'GetResourceActionsResourceActionCollectionResult',
    'GetResourceActionsResourceActionCollectionItemResult',
    'GetResourceActionsResourceActionCollectionItemActionResult',
]

@pulumi.output_type
class ProfileLevelsConfiguration(dict):
    def __init__(__self__, *,
                 items: Optional[Sequence['outputs.ProfileLevelsConfigurationItem']] = None):
        """
        :param Sequence['ProfileLevelsConfigurationItemArgs'] items: (Updatable) The list of tags specified in the current profile override.
        """
        ProfileLevelsConfiguration._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Optional[Sequence['outputs.ProfileLevelsConfigurationItem']] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if items is not None:
            _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Optional[Sequence['outputs.ProfileLevelsConfigurationItem']]:
        """
        (Updatable) The list of tags specified in the current profile override.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class ProfileLevelsConfigurationItem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recommendationId":
            suggest = "recommendation_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProfileLevelsConfigurationItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProfileLevelsConfigurationItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProfileLevelsConfigurationItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 level: Optional[str] = None,
                 recommendation_id: Optional[str] = None):
        """
        :param str level: (Updatable) The pre-defined profile level.
        :param str recommendation_id: (Updatable) The unique OCID of the recommendation.
        """
        ProfileLevelsConfigurationItem._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            level=level,
            recommendation_id=recommendation_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             level: Optional[str] = None,
             recommendation_id: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'recommendationId' in kwargs:
            recommendation_id = kwargs['recommendationId']

        if level is not None:
            _setter("level", level)
        if recommendation_id is not None:
            _setter("recommendation_id", recommendation_id)

    @property
    @pulumi.getter
    def level(self) -> Optional[str]:
        """
        (Updatable) The pre-defined profile level.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter(name="recommendationId")
    def recommendation_id(self) -> Optional[str]:
        """
        (Updatable) The unique OCID of the recommendation.
        """
        return pulumi.get(self, "recommendation_id")


@pulumi.output_type
class ProfileTargetCompartments(dict):
    def __init__(__self__, *,
                 items: Sequence[str]):
        """
        :param Sequence[str] items: (Updatable) The list of tags specified in the current profile override.
        """
        ProfileTargetCompartments._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence[str],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence[str]:
        """
        (Updatable) The list of tags specified in the current profile override.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class ProfileTargetTags(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.ProfileTargetTagsItem']):
        """
        :param Sequence['ProfileTargetTagsItemArgs'] items: (Updatable) The list of tags specified in the current profile override.
        """
        ProfileTargetTags._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.ProfileTargetTagsItem'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.ProfileTargetTagsItem']:
        """
        (Updatable) The list of tags specified in the current profile override.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class ProfileTargetTagsItem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tagDefinitionName":
            suggest = "tag_definition_name"
        elif key == "tagNamespaceName":
            suggest = "tag_namespace_name"
        elif key == "tagValueType":
            suggest = "tag_value_type"
        elif key == "tagValues":
            suggest = "tag_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProfileTargetTagsItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProfileTargetTagsItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProfileTargetTagsItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 tag_definition_name: str,
                 tag_namespace_name: str,
                 tag_value_type: str,
                 tag_values: Optional[Sequence[str]] = None):
        """
        :param str tag_definition_name: (Updatable) The name you use to refer to the tag, also known as the tag key.
        :param str tag_namespace_name: (Updatable) The name of the tag namespace.
        :param str tag_value_type: (Updatable) Specifies which tag value types in the `tagValues` field result in overrides of the recommendation criteria.
               
               When the value for this field is `ANY`, the `tagValues` field should be empty, which enforces overrides to the recommendation for resources with any tag values attached to them.
               
               When the value for this field value is `VALUE`, the `tagValues` field must include a specific value or list of values. Overrides to the recommendation criteria only occur for resources that match the values in the `tagValues` fields.
        :param Sequence[str] tag_values: (Updatable) The list of tag values. The tag value is the value that the user applying the tag adds to the tag key.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ProfileTargetTagsItem._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            tag_definition_name=tag_definition_name,
            tag_namespace_name=tag_namespace_name,
            tag_value_type=tag_value_type,
            tag_values=tag_values,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             tag_definition_name: str,
             tag_namespace_name: str,
             tag_value_type: str,
             tag_values: Optional[Sequence[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'tagDefinitionName' in kwargs:
            tag_definition_name = kwargs['tagDefinitionName']
        if 'tagNamespaceName' in kwargs:
            tag_namespace_name = kwargs['tagNamespaceName']
        if 'tagValueType' in kwargs:
            tag_value_type = kwargs['tagValueType']
        if 'tagValues' in kwargs:
            tag_values = kwargs['tagValues']

        _setter("tag_definition_name", tag_definition_name)
        _setter("tag_namespace_name", tag_namespace_name)
        _setter("tag_value_type", tag_value_type)
        if tag_values is not None:
            _setter("tag_values", tag_values)

    @property
    @pulumi.getter(name="tagDefinitionName")
    def tag_definition_name(self) -> str:
        """
        (Updatable) The name you use to refer to the tag, also known as the tag key.
        """
        return pulumi.get(self, "tag_definition_name")

    @property
    @pulumi.getter(name="tagNamespaceName")
    def tag_namespace_name(self) -> str:
        """
        (Updatable) The name of the tag namespace.
        """
        return pulumi.get(self, "tag_namespace_name")

    @property
    @pulumi.getter(name="tagValueType")
    def tag_value_type(self) -> str:
        """
        (Updatable) Specifies which tag value types in the `tagValues` field result in overrides of the recommendation criteria.

        When the value for this field is `ANY`, the `tagValues` field should be empty, which enforces overrides to the recommendation for resources with any tag values attached to them.

        When the value for this field value is `VALUE`, the `tagValues` field must include a specific value or list of values. Overrides to the recommendation criteria only occur for resources that match the values in the `tagValues` fields.
        """
        return pulumi.get(self, "tag_value_type")

    @property
    @pulumi.getter(name="tagValues")
    def tag_values(self) -> Optional[Sequence[str]]:
        """
        (Updatable) The list of tag values. The tag value is the value that the user applying the tag adds to the tag key.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "tag_values")


@pulumi.output_type
class RecommendationResourceCount(dict):
    def __init__(__self__, *,
                 count: Optional[int] = None,
                 status: Optional[str] = None):
        """
        :param int count: The count of resources.
        :param str status: (Updatable) The status of the recommendation.
        """
        RecommendationResourceCount._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            count=count,
            status=status,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             count: Optional[int] = None,
             status: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if count is not None:
            _setter("count", count)
        if status is not None:
            _setter("status", status)

    @property
    @pulumi.getter
    def count(self) -> Optional[int]:
        """
        The count of resources.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        (Updatable) The status of the recommendation.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class RecommendationSupportedLevel(dict):
    def __init__(__self__, *,
                 items: Optional[Sequence['outputs.RecommendationSupportedLevelItem']] = None):
        """
        :param Sequence['RecommendationSupportedLevelItemArgs'] items: The list of supported levels.
        """
        RecommendationSupportedLevel._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Optional[Sequence['outputs.RecommendationSupportedLevelItem']] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if items is not None:
            _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Optional[Sequence['outputs.RecommendationSupportedLevelItem']]:
        """
        The list of supported levels.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class RecommendationSupportedLevelItem(dict):
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        :param str name: The name of the profile level.
        """
        RecommendationSupportedLevelItem._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if name is not None:
            _setter("name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the profile level.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ResourceActionAction(dict):
    def __init__(__self__, *,
                 description: Optional[str] = None,
                 type: Optional[str] = None,
                 url: Optional[str] = None):
        """
        :param str description: Text describing the recommended action.
        :param str type: The status of the resource action.
        :param str url: The URL path to documentation that explains how to perform the action.
        """
        ResourceActionAction._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            description=description,
            type=type,
            url=url,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             description: Optional[str] = None,
             type: Optional[str] = None,
             url: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if description is not None:
            _setter("description", description)
        if type is not None:
            _setter("type", type)
        if url is not None:
            _setter("url", url)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Text describing the recommended action.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The status of the resource action.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        The URL path to documentation that explains how to perform the action.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetCategoriesCategoryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetCategoriesCategoryCollectionItemResult']):
        GetCategoriesCategoryCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetCategoriesCategoryCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetCategoriesCategoryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetCategoriesCategoryCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 compartment_name: str,
                 description: str,
                 estimated_cost_saving: float,
                 extended_metadata: Mapping[str, Any],
                 id: str,
                 name: str,
                 recommendation_counts: Sequence['outputs.GetCategoriesCategoryCollectionItemRecommendationCountResult'],
                 resource_counts: Sequence['outputs.GetCategoriesCategoryCollectionItemResourceCountResult'],
                 state: str,
                 time_created: str,
                 time_updated: str):
        """
        :param str compartment_id: The OCID of the compartment.
        :param str compartment_name: The name associated with the compartment.
        :param str description: Text describing the category.
        :param float estimated_cost_saving: The estimated cost savings, in dollars, for the category.
        :param Mapping[str, Any] extended_metadata: Additional metadata key/value pairs for the category.
        :param str id: The unique OCID of the category.
        :param str name: Optional. A filter that returns results that match the name specified.
        :param Sequence['GetCategoriesCategoryCollectionItemRecommendationCountArgs'] recommendation_counts: An array of `RecommendationCount` objects grouped by the level of importance assigned to the recommendation.
        :param Sequence['GetCategoriesCategoryCollectionItemResourceCountArgs'] resource_counts: An array of `ResourceCount` objects grouped by the status of the recommendation.
        :param str state: A filter that returns results that match the lifecycle state specified.
        :param str time_created: The date and time the category details were created, in the format defined by RFC3339.
        :param str time_updated: The date and time the category details were last updated, in the format defined by RFC3339.
        """
        GetCategoriesCategoryCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            compartment_name=compartment_name,
            description=description,
            estimated_cost_saving=estimated_cost_saving,
            extended_metadata=extended_metadata,
            id=id,
            name=name,
            recommendation_counts=recommendation_counts,
            resource_counts=resource_counts,
            state=state,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             compartment_name: str,
             description: str,
             estimated_cost_saving: float,
             extended_metadata: Mapping[str, Any],
             id: str,
             name: str,
             recommendation_counts: Sequence['outputs.GetCategoriesCategoryCollectionItemRecommendationCountResult'],
             resource_counts: Sequence['outputs.GetCategoriesCategoryCollectionItemResourceCountResult'],
             state: str,
             time_created: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'compartmentName' in kwargs:
            compartment_name = kwargs['compartmentName']
        if 'estimatedCostSaving' in kwargs:
            estimated_cost_saving = kwargs['estimatedCostSaving']
        if 'extendedMetadata' in kwargs:
            extended_metadata = kwargs['extendedMetadata']
        if 'recommendationCounts' in kwargs:
            recommendation_counts = kwargs['recommendationCounts']
        if 'resourceCounts' in kwargs:
            resource_counts = kwargs['resourceCounts']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        _setter("compartment_id", compartment_id)
        _setter("compartment_name", compartment_name)
        _setter("description", description)
        _setter("estimated_cost_saving", estimated_cost_saving)
        _setter("extended_metadata", extended_metadata)
        _setter("id", id)
        _setter("name", name)
        _setter("recommendation_counts", recommendation_counts)
        _setter("resource_counts", resource_counts)
        _setter("state", state)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentName")
    def compartment_name(self) -> str:
        """
        The name associated with the compartment.
        """
        return pulumi.get(self, "compartment_name")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Text describing the category.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="estimatedCostSaving")
    def estimated_cost_saving(self) -> float:
        """
        The estimated cost savings, in dollars, for the category.
        """
        return pulumi.get(self, "estimated_cost_saving")

    @property
    @pulumi.getter(name="extendedMetadata")
    def extended_metadata(self) -> Mapping[str, Any]:
        """
        Additional metadata key/value pairs for the category.
        """
        return pulumi.get(self, "extended_metadata")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The unique OCID of the category.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="recommendationCounts")
    def recommendation_counts(self) -> Sequence['outputs.GetCategoriesCategoryCollectionItemRecommendationCountResult']:
        """
        An array of `RecommendationCount` objects grouped by the level of importance assigned to the recommendation.
        """
        return pulumi.get(self, "recommendation_counts")

    @property
    @pulumi.getter(name="resourceCounts")
    def resource_counts(self) -> Sequence['outputs.GetCategoriesCategoryCollectionItemResourceCountResult']:
        """
        An array of `ResourceCount` objects grouped by the status of the recommendation.
        """
        return pulumi.get(self, "resource_counts")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter that returns results that match the lifecycle state specified.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the category details were created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the category details were last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetCategoriesCategoryCollectionItemRecommendationCountResult(dict):
    def __init__(__self__, *,
                 count: int,
                 importance: str):
        """
        :param int count: The count of resources.
        :param str importance: The level of importance assigned to the recommendation.
        """
        GetCategoriesCategoryCollectionItemRecommendationCountResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            count=count,
            importance=importance,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             count: int,
             importance: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("count", count)
        _setter("importance", importance)

    @property
    @pulumi.getter
    def count(self) -> int:
        """
        The count of resources.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def importance(self) -> str:
        """
        The level of importance assigned to the recommendation.
        """
        return pulumi.get(self, "importance")


@pulumi.output_type
class GetCategoriesCategoryCollectionItemResourceCountResult(dict):
    def __init__(__self__, *,
                 count: int,
                 status: str):
        """
        :param int count: The count of resources.
        :param str status: The recommendation status of the resource.
        """
        GetCategoriesCategoryCollectionItemResourceCountResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            count=count,
            status=status,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             count: int,
             status: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("count", count)
        _setter("status", status)

    @property
    @pulumi.getter
    def count(self) -> int:
        """
        The count of resources.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The recommendation status of the resource.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetCategoriesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Optional. A filter that returns results that match the name specified.
        """
        GetCategoriesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetCategoryRecommendationCountResult(dict):
    def __init__(__self__, *,
                 count: int,
                 importance: str):
        """
        :param int count: The count of resources.
        :param str importance: The level of importance assigned to the recommendation.
        """
        GetCategoryRecommendationCountResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            count=count,
            importance=importance,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             count: int,
             importance: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("count", count)
        _setter("importance", importance)

    @property
    @pulumi.getter
    def count(self) -> int:
        """
        The count of resources.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def importance(self) -> str:
        """
        The level of importance assigned to the recommendation.
        """
        return pulumi.get(self, "importance")


@pulumi.output_type
class GetCategoryResourceCountResult(dict):
    def __init__(__self__, *,
                 count: int,
                 status: str):
        """
        :param int count: The count of resources.
        :param str status: The recommendation status of the resource.
        """
        GetCategoryResourceCountResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            count=count,
            status=status,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             count: int,
             status: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("count", count)
        _setter("status", status)

    @property
    @pulumi.getter
    def count(self) -> int:
        """
        The count of resources.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The recommendation status of the resource.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetEnrollmentStatusesEnrollmentStatusCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetEnrollmentStatusesEnrollmentStatusCollectionItemResult']):
        GetEnrollmentStatusesEnrollmentStatusCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetEnrollmentStatusesEnrollmentStatusCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetEnrollmentStatusesEnrollmentStatusCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetEnrollmentStatusesEnrollmentStatusCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 enrollment_status_id: str,
                 id: str,
                 state: str,
                 status: str,
                 status_reason: str,
                 time_created: str,
                 time_updated: str):
        """
        :param str compartment_id: The OCID of the compartment.
        :param str id: The OCID of the enrollment status.
        :param str state: A filter that returns results that match the lifecycle state specified.
        :param str status: A filter that returns results that match the Cloud Advisor enrollment status specified.
        :param str status_reason: The reason for the enrollment status of the tenancy.
        :param str time_created: The date and time the enrollment status was created, in the format defined by RFC3339.
        :param str time_updated: The date and time the enrollment status was last updated, in the format defined by RFC3339.
        """
        GetEnrollmentStatusesEnrollmentStatusCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            enrollment_status_id=enrollment_status_id,
            id=id,
            state=state,
            status=status,
            status_reason=status_reason,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             enrollment_status_id: str,
             id: str,
             state: str,
             status: str,
             status_reason: str,
             time_created: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'enrollmentStatusId' in kwargs:
            enrollment_status_id = kwargs['enrollmentStatusId']
        if 'statusReason' in kwargs:
            status_reason = kwargs['statusReason']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        _setter("compartment_id", compartment_id)
        _setter("enrollment_status_id", enrollment_status_id)
        _setter("id", id)
        _setter("state", state)
        _setter("status", status)
        _setter("status_reason", status_reason)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="enrollmentStatusId")
    def enrollment_status_id(self) -> str:
        return pulumi.get(self, "enrollment_status_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the enrollment status.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter that returns results that match the lifecycle state specified.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        A filter that returns results that match the Cloud Advisor enrollment status specified.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> str:
        """
        The reason for the enrollment status of the tenancy.
        """
        return pulumi.get(self, "status_reason")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the enrollment status was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the enrollment status was last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetEnrollmentStatusesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetEnrollmentStatusesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetHistoriesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Optional. A filter that returns results that match the name specified.
        """
        GetHistoriesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetHistoriesHistoryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetHistoriesHistoryCollectionItemResult']):
        """
        :param Sequence['GetHistoriesHistoryCollectionItemArgs'] items: A collection of history summaries.
        """
        GetHistoriesHistoryCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetHistoriesHistoryCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetHistoriesHistoryCollectionItemResult']:
        """
        A collection of history summaries.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetHistoriesHistoryCollectionItemResult(dict):
    def __init__(__self__, *,
                 actions: Sequence['outputs.GetHistoriesHistoryCollectionItemActionResult'],
                 category_id: str,
                 compartment_id: str,
                 compartment_name: str,
                 estimated_cost_saving: float,
                 extended_metadata: Mapping[str, Any],
                 id: str,
                 metadata: Mapping[str, Any],
                 name: str,
                 recommendation_id: str,
                 recommendation_name: str,
                 resource_action_id: str,
                 resource_id: str,
                 resource_type: str,
                 state: str,
                 status: str,
                 time_created: str):
        """
        :param Sequence['GetHistoriesHistoryCollectionItemActionArgs'] actions: Details about the recommended action.
        :param str category_id: The unique OCID associated with the category.
        :param str compartment_id: The OCID of the compartment.
        :param str compartment_name: The name assigned to the compartment.
        :param float estimated_cost_saving: The estimated cost savings, in dollars, for the resource action.
        :param Mapping[str, Any] extended_metadata: Additional metadata key/value pairs that you provide. They serve the same purpose and functionality as fields in the `metadata` object.
        :param str id: The unique OCID associated with the recommendation history.
        :param Mapping[str, Any] metadata: Custom metadata key/value pairs for the resource action.
        :param str name: Optional. A filter that returns results that match the name specified.
        :param str recommendation_id: The unique OCID associated with the recommendation.
        :param str recommendation_name: Optional. A filter that returns results that match the recommendation name specified.
        :param str resource_action_id: The unique OCID associated with the resource action.
        :param str resource_id: The unique OCID associated with the resource.
        :param str resource_type: Optional. A filter that returns results that match the resource type specified.
        :param str state: A filter that returns results that match the lifecycle state specified.
        :param str status: A filter that returns recommendations that match the status specified.
        :param str time_created: The date and time the recommendation history was created, in the format defined by RFC3339.
        """
        GetHistoriesHistoryCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            actions=actions,
            category_id=category_id,
            compartment_id=compartment_id,
            compartment_name=compartment_name,
            estimated_cost_saving=estimated_cost_saving,
            extended_metadata=extended_metadata,
            id=id,
            metadata=metadata,
            name=name,
            recommendation_id=recommendation_id,
            recommendation_name=recommendation_name,
            resource_action_id=resource_action_id,
            resource_id=resource_id,
            resource_type=resource_type,
            state=state,
            status=status,
            time_created=time_created,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             actions: Sequence['outputs.GetHistoriesHistoryCollectionItemActionResult'],
             category_id: str,
             compartment_id: str,
             compartment_name: str,
             estimated_cost_saving: float,
             extended_metadata: Mapping[str, Any],
             id: str,
             metadata: Mapping[str, Any],
             name: str,
             recommendation_id: str,
             recommendation_name: str,
             resource_action_id: str,
             resource_id: str,
             resource_type: str,
             state: str,
             status: str,
             time_created: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'categoryId' in kwargs:
            category_id = kwargs['categoryId']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'compartmentName' in kwargs:
            compartment_name = kwargs['compartmentName']
        if 'estimatedCostSaving' in kwargs:
            estimated_cost_saving = kwargs['estimatedCostSaving']
        if 'extendedMetadata' in kwargs:
            extended_metadata = kwargs['extendedMetadata']
        if 'recommendationId' in kwargs:
            recommendation_id = kwargs['recommendationId']
        if 'recommendationName' in kwargs:
            recommendation_name = kwargs['recommendationName']
        if 'resourceActionId' in kwargs:
            resource_action_id = kwargs['resourceActionId']
        if 'resourceId' in kwargs:
            resource_id = kwargs['resourceId']
        if 'resourceType' in kwargs:
            resource_type = kwargs['resourceType']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']

        _setter("actions", actions)
        _setter("category_id", category_id)
        _setter("compartment_id", compartment_id)
        _setter("compartment_name", compartment_name)
        _setter("estimated_cost_saving", estimated_cost_saving)
        _setter("extended_metadata", extended_metadata)
        _setter("id", id)
        _setter("metadata", metadata)
        _setter("name", name)
        _setter("recommendation_id", recommendation_id)
        _setter("recommendation_name", recommendation_name)
        _setter("resource_action_id", resource_action_id)
        _setter("resource_id", resource_id)
        _setter("resource_type", resource_type)
        _setter("state", state)
        _setter("status", status)
        _setter("time_created", time_created)

    @property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GetHistoriesHistoryCollectionItemActionResult']:
        """
        Details about the recommended action.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="categoryId")
    def category_id(self) -> str:
        """
        The unique OCID associated with the category.
        """
        return pulumi.get(self, "category_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentName")
    def compartment_name(self) -> str:
        """
        The name assigned to the compartment.
        """
        return pulumi.get(self, "compartment_name")

    @property
    @pulumi.getter(name="estimatedCostSaving")
    def estimated_cost_saving(self) -> float:
        """
        The estimated cost savings, in dollars, for the resource action.
        """
        return pulumi.get(self, "estimated_cost_saving")

    @property
    @pulumi.getter(name="extendedMetadata")
    def extended_metadata(self) -> Mapping[str, Any]:
        """
        Additional metadata key/value pairs that you provide. They serve the same purpose and functionality as fields in the `metadata` object.
        """
        return pulumi.get(self, "extended_metadata")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The unique OCID associated with the recommendation history.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, Any]:
        """
        Custom metadata key/value pairs for the resource action.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="recommendationId")
    def recommendation_id(self) -> str:
        """
        The unique OCID associated with the recommendation.
        """
        return pulumi.get(self, "recommendation_id")

    @property
    @pulumi.getter(name="recommendationName")
    def recommendation_name(self) -> str:
        """
        Optional. A filter that returns results that match the recommendation name specified.
        """
        return pulumi.get(self, "recommendation_name")

    @property
    @pulumi.getter(name="resourceActionId")
    def resource_action_id(self) -> str:
        """
        The unique OCID associated with the resource action.
        """
        return pulumi.get(self, "resource_action_id")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The unique OCID associated with the resource.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        Optional. A filter that returns results that match the resource type specified.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter that returns results that match the lifecycle state specified.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        A filter that returns recommendations that match the status specified.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the recommendation history was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetHistoriesHistoryCollectionItemActionResult(dict):
    def __init__(__self__, *,
                 description: str,
                 type: str,
                 url: str):
        """
        :param str description: Text describing the recommended action.
        :param str type: The status of the resource action.
        :param str url: The URL path to documentation that explains how to perform the action.
        """
        GetHistoriesHistoryCollectionItemActionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            description=description,
            type=type,
            url=url,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             description: str,
             type: str,
             url: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("description", description)
        _setter("type", type)
        _setter("url", url)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Text describing the recommended action.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The status of the resource action.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The URL path to documentation that explains how to perform the action.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetProfileLevelItemResult(dict):
    def __init__(__self__, *,
                 default_interval: int,
                 metrics: Sequence['outputs.GetProfileLevelItemMetricResult'],
                 name: str,
                 recommendation_name: str,
                 time_created: str,
                 time_updated: str,
                 valid_intervals: Sequence[int]):
        """
        :param int default_interval: The default aggregation interval (in days) for profiles using this profile level.
        :param Sequence['GetProfileLevelItemMetricArgs'] metrics: The metrics that will be evaluated by profiles using this profile level.
        :param str name: Optional. A filter that returns results that match the name specified.
        :param str recommendation_name: Optional. A filter that returns results that match the recommendation name specified.
        :param str time_created: The date and time the category details were created, in the format defined by RFC3339.
        :param str time_updated: The date and time the category details were last updated, in the format defined by RFC3339.
        :param Sequence[int] valid_intervals: An array of aggregation intervals (in days) allowed for profiles using this profile level.
        """
        GetProfileLevelItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            default_interval=default_interval,
            metrics=metrics,
            name=name,
            recommendation_name=recommendation_name,
            time_created=time_created,
            time_updated=time_updated,
            valid_intervals=valid_intervals,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             default_interval: int,
             metrics: Sequence['outputs.GetProfileLevelItemMetricResult'],
             name: str,
             recommendation_name: str,
             time_created: str,
             time_updated: str,
             valid_intervals: Sequence[int],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'defaultInterval' in kwargs:
            default_interval = kwargs['defaultInterval']
        if 'recommendationName' in kwargs:
            recommendation_name = kwargs['recommendationName']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']
        if 'validIntervals' in kwargs:
            valid_intervals = kwargs['validIntervals']

        _setter("default_interval", default_interval)
        _setter("metrics", metrics)
        _setter("name", name)
        _setter("recommendation_name", recommendation_name)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)
        _setter("valid_intervals", valid_intervals)

    @property
    @pulumi.getter(name="defaultInterval")
    def default_interval(self) -> int:
        """
        The default aggregation interval (in days) for profiles using this profile level.
        """
        return pulumi.get(self, "default_interval")

    @property
    @pulumi.getter
    def metrics(self) -> Sequence['outputs.GetProfileLevelItemMetricResult']:
        """
        The metrics that will be evaluated by profiles using this profile level.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="recommendationName")
    def recommendation_name(self) -> str:
        """
        Optional. A filter that returns results that match the recommendation name specified.
        """
        return pulumi.get(self, "recommendation_name")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the category details were created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the category details were last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="validIntervals")
    def valid_intervals(self) -> Sequence[int]:
        """
        An array of aggregation intervals (in days) allowed for profiles using this profile level.
        """
        return pulumi.get(self, "valid_intervals")


@pulumi.output_type
class GetProfileLevelItemMetricResult(dict):
    def __init__(__self__, *,
                 name: str,
                 statistic: str,
                 target: float,
                 threshold: float):
        """
        :param str name: Optional. A filter that returns results that match the name specified.
        :param str statistic: The name of the statistic (e.g., `p95`).
        :param float target: Optional. The metric value that the recommendation will target.
        :param float threshold: The threshold that must be crossed for the recommendation to appear.
        """
        GetProfileLevelItemMetricResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            statistic=statistic,
            target=target,
            threshold=threshold,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             statistic: str,
             target: float,
             threshold: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("statistic", statistic)
        _setter("target", target)
        _setter("threshold", threshold)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def statistic(self) -> str:
        """
        The name of the statistic (e.g., `p95`).
        """
        return pulumi.get(self, "statistic")

    @property
    @pulumi.getter
    def target(self) -> float:
        """
        Optional. The metric value that the recommendation will target.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def threshold(self) -> float:
        """
        The threshold that must be crossed for the recommendation to appear.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class GetProfileLevelsConfigurationResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetProfileLevelsConfigurationItemResult']):
        """
        :param Sequence['GetProfileLevelsConfigurationItemArgs'] items: The list of tags specified in the current profile override.
        """
        GetProfileLevelsConfigurationResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetProfileLevelsConfigurationItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetProfileLevelsConfigurationItemResult']:
        """
        The list of tags specified in the current profile override.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetProfileLevelsConfigurationItemResult(dict):
    def __init__(__self__, *,
                 level: str,
                 recommendation_id: str):
        """
        :param str level: The pre-defined profile level.
        :param str recommendation_id: The unique OCID of the recommendation.
        """
        GetProfileLevelsConfigurationItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            level=level,
            recommendation_id=recommendation_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             level: str,
             recommendation_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'recommendationId' in kwargs:
            recommendation_id = kwargs['recommendationId']

        _setter("level", level)
        _setter("recommendation_id", recommendation_id)

    @property
    @pulumi.getter
    def level(self) -> str:
        """
        The pre-defined profile level.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter(name="recommendationId")
    def recommendation_id(self) -> str:
        """
        The unique OCID of the recommendation.
        """
        return pulumi.get(self, "recommendation_id")


@pulumi.output_type
class GetProfileLevelsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Optional. A filter that returns results that match the name specified.
        """
        GetProfileLevelsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetProfileLevelsProfileLevelCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetProfileLevelsProfileLevelCollectionItemResult']):
        """
        :param Sequence['GetProfileLevelsProfileLevelCollectionItemArgs'] items: A collection of profile levels.
        """
        GetProfileLevelsProfileLevelCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetProfileLevelsProfileLevelCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetProfileLevelsProfileLevelCollectionItemResult']:
        """
        A collection of profile levels.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetProfileLevelsProfileLevelCollectionItemResult(dict):
    def __init__(__self__, *,
                 default_interval: int,
                 metrics: Sequence['outputs.GetProfileLevelsProfileLevelCollectionItemMetricResult'],
                 name: str,
                 recommendation_name: str,
                 time_created: str,
                 time_updated: str,
                 valid_intervals: Sequence[int]):
        """
        :param int default_interval: The default aggregation interval (in days) for profiles using this profile level.
        :param Sequence['GetProfileLevelsProfileLevelCollectionItemMetricArgs'] metrics: The metrics that will be evaluated by profiles using this profile level.
        :param str name: Optional. A filter that returns results that match the name specified.
        :param str recommendation_name: Optional. A filter that returns results that match the recommendation name specified.
        :param str time_created: The date and time the category details were created, in the format defined by RFC3339.
        :param str time_updated: The date and time the category details were last updated, in the format defined by RFC3339.
        :param Sequence[int] valid_intervals: An array of aggregation intervals (in days) allowed for profiles using this profile level.
        """
        GetProfileLevelsProfileLevelCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            default_interval=default_interval,
            metrics=metrics,
            name=name,
            recommendation_name=recommendation_name,
            time_created=time_created,
            time_updated=time_updated,
            valid_intervals=valid_intervals,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             default_interval: int,
             metrics: Sequence['outputs.GetProfileLevelsProfileLevelCollectionItemMetricResult'],
             name: str,
             recommendation_name: str,
             time_created: str,
             time_updated: str,
             valid_intervals: Sequence[int],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'defaultInterval' in kwargs:
            default_interval = kwargs['defaultInterval']
        if 'recommendationName' in kwargs:
            recommendation_name = kwargs['recommendationName']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']
        if 'validIntervals' in kwargs:
            valid_intervals = kwargs['validIntervals']

        _setter("default_interval", default_interval)
        _setter("metrics", metrics)
        _setter("name", name)
        _setter("recommendation_name", recommendation_name)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)
        _setter("valid_intervals", valid_intervals)

    @property
    @pulumi.getter(name="defaultInterval")
    def default_interval(self) -> int:
        """
        The default aggregation interval (in days) for profiles using this profile level.
        """
        return pulumi.get(self, "default_interval")

    @property
    @pulumi.getter
    def metrics(self) -> Sequence['outputs.GetProfileLevelsProfileLevelCollectionItemMetricResult']:
        """
        The metrics that will be evaluated by profiles using this profile level.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="recommendationName")
    def recommendation_name(self) -> str:
        """
        Optional. A filter that returns results that match the recommendation name specified.
        """
        return pulumi.get(self, "recommendation_name")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the category details were created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the category details were last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="validIntervals")
    def valid_intervals(self) -> Sequence[int]:
        """
        An array of aggregation intervals (in days) allowed for profiles using this profile level.
        """
        return pulumi.get(self, "valid_intervals")


@pulumi.output_type
class GetProfileLevelsProfileLevelCollectionItemMetricResult(dict):
    def __init__(__self__, *,
                 name: str,
                 statistic: str,
                 target: float,
                 threshold: float):
        """
        :param str name: Optional. A filter that returns results that match the name specified.
        :param str statistic: The name of the statistic (e.g., `p95`).
        :param float target: Optional. The metric value that the recommendation will target.
        :param float threshold: The threshold that must be crossed for the recommendation to appear.
        """
        GetProfileLevelsProfileLevelCollectionItemMetricResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            statistic=statistic,
            target=target,
            threshold=threshold,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             statistic: str,
             target: float,
             threshold: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("statistic", statistic)
        _setter("target", target)
        _setter("threshold", threshold)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def statistic(self) -> str:
        """
        The name of the statistic (e.g., `p95`).
        """
        return pulumi.get(self, "statistic")

    @property
    @pulumi.getter
    def target(self) -> float:
        """
        Optional. The metric value that the recommendation will target.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def threshold(self) -> float:
        """
        The threshold that must be crossed for the recommendation to appear.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class GetProfileTargetCompartmentResult(dict):
    def __init__(__self__, *,
                 items: Sequence[str]):
        """
        :param Sequence[str] items: The list of tags specified in the current profile override.
        """
        GetProfileTargetCompartmentResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence[str],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence[str]:
        """
        The list of tags specified in the current profile override.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetProfileTargetTagResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetProfileTargetTagItemResult']):
        """
        :param Sequence['GetProfileTargetTagItemArgs'] items: The list of tags specified in the current profile override.
        """
        GetProfileTargetTagResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetProfileTargetTagItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetProfileTargetTagItemResult']:
        """
        The list of tags specified in the current profile override.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetProfileTargetTagItemResult(dict):
    def __init__(__self__, *,
                 tag_definition_name: str,
                 tag_namespace_name: str,
                 tag_value_type: str,
                 tag_values: Sequence[str]):
        """
        :param str tag_definition_name: The name you use to refer to the tag, also known as the tag key.
        :param str tag_namespace_name: The name of the tag namespace.
        :param str tag_value_type: Specifies which tag value types in the `tagValues` field result in overrides of the recommendation criteria.
        :param Sequence[str] tag_values: The list of tag values. The tag value is the value that the user applying the tag adds to the tag key.
        """
        GetProfileTargetTagItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            tag_definition_name=tag_definition_name,
            tag_namespace_name=tag_namespace_name,
            tag_value_type=tag_value_type,
            tag_values=tag_values,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             tag_definition_name: str,
             tag_namespace_name: str,
             tag_value_type: str,
             tag_values: Sequence[str],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'tagDefinitionName' in kwargs:
            tag_definition_name = kwargs['tagDefinitionName']
        if 'tagNamespaceName' in kwargs:
            tag_namespace_name = kwargs['tagNamespaceName']
        if 'tagValueType' in kwargs:
            tag_value_type = kwargs['tagValueType']
        if 'tagValues' in kwargs:
            tag_values = kwargs['tagValues']

        _setter("tag_definition_name", tag_definition_name)
        _setter("tag_namespace_name", tag_namespace_name)
        _setter("tag_value_type", tag_value_type)
        _setter("tag_values", tag_values)

    @property
    @pulumi.getter(name="tagDefinitionName")
    def tag_definition_name(self) -> str:
        """
        The name you use to refer to the tag, also known as the tag key.
        """
        return pulumi.get(self, "tag_definition_name")

    @property
    @pulumi.getter(name="tagNamespaceName")
    def tag_namespace_name(self) -> str:
        """
        The name of the tag namespace.
        """
        return pulumi.get(self, "tag_namespace_name")

    @property
    @pulumi.getter(name="tagValueType")
    def tag_value_type(self) -> str:
        """
        Specifies which tag value types in the `tagValues` field result in overrides of the recommendation criteria.
        """
        return pulumi.get(self, "tag_value_type")

    @property
    @pulumi.getter(name="tagValues")
    def tag_values(self) -> Sequence[str]:
        """
        The list of tag values. The tag value is the value that the user applying the tag adds to the tag key.
        """
        return pulumi.get(self, "tag_values")


@pulumi.output_type
class GetProfilesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Optional. A filter that returns results that match the name specified.
        """
        GetProfilesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetProfilesProfileCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetProfilesProfileCollectionItemResult']):
        """
        :param Sequence['GetProfilesProfileCollectionItemArgs'] items: The list of tags specified in the current profile override.
        """
        GetProfilesProfileCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetProfilesProfileCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetProfilesProfileCollectionItemResult']:
        """
        The list of tags specified in the current profile override.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetProfilesProfileCollectionItemResult(dict):
    def __init__(__self__, *,
                 aggregation_interval_in_days: int,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 levels_configurations: Sequence['outputs.GetProfilesProfileCollectionItemLevelsConfigurationResult'],
                 name: str,
                 state: str,
                 target_compartments: Sequence['outputs.GetProfilesProfileCollectionItemTargetCompartmentResult'],
                 target_tags: Sequence['outputs.GetProfilesProfileCollectionItemTargetTagResult'],
                 time_created: str,
                 time_updated: str):
        """
        :param int aggregation_interval_in_days: The time period over which to collect data for the recommendations, measured in number of days.
        :param str compartment_id: The OCID of the compartment.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"foo-namespace.bar-key": "value"}`
        :param str description: Text describing the profile. Avoid entering confidential information.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair applied without any predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        :param str id: The unique OCID of the profile.
        :param Sequence['GetProfilesProfileCollectionItemLevelsConfigurationArgs'] levels_configurations: A list of configuration levels for each recommendation.
        :param str name: Optional. A filter that returns results that match the name specified.
        :param str state: A filter that returns results that match the lifecycle state specified.
        :param Sequence['GetProfilesProfileCollectionItemTargetCompartmentArgs'] target_compartments: Optional. The compartments specified in the profile override for a recommendation.
        :param Sequence['GetProfilesProfileCollectionItemTargetTagArgs'] target_tags: Optional. The tags specified in the profile override for a recommendation.
        :param str time_created: The date and time the profile was created, in the format defined by RFC3339.
        :param str time_updated: The date and time the profile was last updated, in the format defined by RFC3339.
        """
        GetProfilesProfileCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            aggregation_interval_in_days=aggregation_interval_in_days,
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            description=description,
            freeform_tags=freeform_tags,
            id=id,
            levels_configurations=levels_configurations,
            name=name,
            state=state,
            target_compartments=target_compartments,
            target_tags=target_tags,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             aggregation_interval_in_days: int,
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             description: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             levels_configurations: Sequence['outputs.GetProfilesProfileCollectionItemLevelsConfigurationResult'],
             name: str,
             state: str,
             target_compartments: Sequence['outputs.GetProfilesProfileCollectionItemTargetCompartmentResult'],
             target_tags: Sequence['outputs.GetProfilesProfileCollectionItemTargetTagResult'],
             time_created: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'aggregationIntervalInDays' in kwargs:
            aggregation_interval_in_days = kwargs['aggregationIntervalInDays']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'levelsConfigurations' in kwargs:
            levels_configurations = kwargs['levelsConfigurations']
        if 'targetCompartments' in kwargs:
            target_compartments = kwargs['targetCompartments']
        if 'targetTags' in kwargs:
            target_tags = kwargs['targetTags']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        _setter("aggregation_interval_in_days", aggregation_interval_in_days)
        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("description", description)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("levels_configurations", levels_configurations)
        _setter("name", name)
        _setter("state", state)
        _setter("target_compartments", target_compartments)
        _setter("target_tags", target_tags)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="aggregationIntervalInDays")
    def aggregation_interval_in_days(self) -> int:
        """
        The time period over which to collect data for the recommendations, measured in number of days.
        """
        return pulumi.get(self, "aggregation_interval_in_days")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Text describing the profile. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair applied without any predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The unique OCID of the profile.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="levelsConfigurations")
    def levels_configurations(self) -> Sequence['outputs.GetProfilesProfileCollectionItemLevelsConfigurationResult']:
        """
        A list of configuration levels for each recommendation.
        """
        return pulumi.get(self, "levels_configurations")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter that returns results that match the lifecycle state specified.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="targetCompartments")
    def target_compartments(self) -> Sequence['outputs.GetProfilesProfileCollectionItemTargetCompartmentResult']:
        """
        Optional. The compartments specified in the profile override for a recommendation.
        """
        return pulumi.get(self, "target_compartments")

    @property
    @pulumi.getter(name="targetTags")
    def target_tags(self) -> Sequence['outputs.GetProfilesProfileCollectionItemTargetTagResult']:
        """
        Optional. The tags specified in the profile override for a recommendation.
        """
        return pulumi.get(self, "target_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the profile was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the profile was last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetProfilesProfileCollectionItemLevelsConfigurationResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetProfilesProfileCollectionItemLevelsConfigurationItemResult']):
        """
        :param Sequence['GetProfilesProfileCollectionItemLevelsConfigurationItemArgs'] items: The list of tags specified in the current profile override.
        """
        GetProfilesProfileCollectionItemLevelsConfigurationResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetProfilesProfileCollectionItemLevelsConfigurationItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetProfilesProfileCollectionItemLevelsConfigurationItemResult']:
        """
        The list of tags specified in the current profile override.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetProfilesProfileCollectionItemLevelsConfigurationItemResult(dict):
    def __init__(__self__, *,
                 level: str,
                 recommendation_id: str):
        """
        :param str level: The pre-defined profile level.
        :param str recommendation_id: The unique OCID of the recommendation.
        """
        GetProfilesProfileCollectionItemLevelsConfigurationItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            level=level,
            recommendation_id=recommendation_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             level: str,
             recommendation_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'recommendationId' in kwargs:
            recommendation_id = kwargs['recommendationId']

        _setter("level", level)
        _setter("recommendation_id", recommendation_id)

    @property
    @pulumi.getter
    def level(self) -> str:
        """
        The pre-defined profile level.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter(name="recommendationId")
    def recommendation_id(self) -> str:
        """
        The unique OCID of the recommendation.
        """
        return pulumi.get(self, "recommendation_id")


@pulumi.output_type
class GetProfilesProfileCollectionItemTargetCompartmentResult(dict):
    def __init__(__self__, *,
                 items: Sequence[str]):
        """
        :param Sequence[str] items: The list of tags specified in the current profile override.
        """
        GetProfilesProfileCollectionItemTargetCompartmentResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence[str],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence[str]:
        """
        The list of tags specified in the current profile override.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetProfilesProfileCollectionItemTargetTagResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetProfilesProfileCollectionItemTargetTagItemResult']):
        """
        :param Sequence['GetProfilesProfileCollectionItemTargetTagItemArgs'] items: The list of tags specified in the current profile override.
        """
        GetProfilesProfileCollectionItemTargetTagResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetProfilesProfileCollectionItemTargetTagItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetProfilesProfileCollectionItemTargetTagItemResult']:
        """
        The list of tags specified in the current profile override.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetProfilesProfileCollectionItemTargetTagItemResult(dict):
    def __init__(__self__, *,
                 tag_definition_name: str,
                 tag_namespace_name: str,
                 tag_value_type: str,
                 tag_values: Sequence[str]):
        """
        :param str tag_definition_name: The name you use to refer to the tag, also known as the tag key.
        :param str tag_namespace_name: The name of the tag namespace.
        :param str tag_value_type: Specifies which tag value types in the `tagValues` field result in overrides of the recommendation criteria.
        :param Sequence[str] tag_values: The list of tag values. The tag value is the value that the user applying the tag adds to the tag key.
        """
        GetProfilesProfileCollectionItemTargetTagItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            tag_definition_name=tag_definition_name,
            tag_namespace_name=tag_namespace_name,
            tag_value_type=tag_value_type,
            tag_values=tag_values,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             tag_definition_name: str,
             tag_namespace_name: str,
             tag_value_type: str,
             tag_values: Sequence[str],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'tagDefinitionName' in kwargs:
            tag_definition_name = kwargs['tagDefinitionName']
        if 'tagNamespaceName' in kwargs:
            tag_namespace_name = kwargs['tagNamespaceName']
        if 'tagValueType' in kwargs:
            tag_value_type = kwargs['tagValueType']
        if 'tagValues' in kwargs:
            tag_values = kwargs['tagValues']

        _setter("tag_definition_name", tag_definition_name)
        _setter("tag_namespace_name", tag_namespace_name)
        _setter("tag_value_type", tag_value_type)
        _setter("tag_values", tag_values)

    @property
    @pulumi.getter(name="tagDefinitionName")
    def tag_definition_name(self) -> str:
        """
        The name you use to refer to the tag, also known as the tag key.
        """
        return pulumi.get(self, "tag_definition_name")

    @property
    @pulumi.getter(name="tagNamespaceName")
    def tag_namespace_name(self) -> str:
        """
        The name of the tag namespace.
        """
        return pulumi.get(self, "tag_namespace_name")

    @property
    @pulumi.getter(name="tagValueType")
    def tag_value_type(self) -> str:
        """
        Specifies which tag value types in the `tagValues` field result in overrides of the recommendation criteria.
        """
        return pulumi.get(self, "tag_value_type")

    @property
    @pulumi.getter(name="tagValues")
    def tag_values(self) -> Sequence[str]:
        """
        The list of tag values. The tag value is the value that the user applying the tag adds to the tag key.
        """
        return pulumi.get(self, "tag_values")


@pulumi.output_type
class GetRecommendationResourceCountResult(dict):
    def __init__(__self__, *,
                 count: int,
                 status: str):
        """
        :param int count: The count of resources.
        :param str status: The current status of the recommendation.
        """
        GetRecommendationResourceCountResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            count=count,
            status=status,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             count: int,
             status: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("count", count)
        _setter("status", status)

    @property
    @pulumi.getter
    def count(self) -> int:
        """
        The count of resources.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The current status of the recommendation.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetRecommendationStrategiesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Optional. A filter that returns results that match the name specified.
        """
        GetRecommendationStrategiesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetRecommendationStrategiesRecommendationStrategyCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetRecommendationStrategiesRecommendationStrategyCollectionItemResult']):
        """
        :param Sequence['GetRecommendationStrategiesRecommendationStrategyCollectionItemArgs'] items: A collection of recommendation strategy summaries.
        """
        GetRecommendationStrategiesRecommendationStrategyCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetRecommendationStrategiesRecommendationStrategyCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetRecommendationStrategiesRecommendationStrategyCollectionItemResult']:
        """
        A collection of recommendation strategy summaries.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetRecommendationStrategiesRecommendationStrategyCollectionItemResult(dict):
    def __init__(__self__, *,
                 name: str,
                 strategies: Sequence['outputs.GetRecommendationStrategiesRecommendationStrategyCollectionItemStrategyResult']):
        """
        :param str name: Optional. A filter that returns results that match the name specified.
        :param Sequence['GetRecommendationStrategiesRecommendationStrategyCollectionItemStrategyArgs'] strategies: The list of strategies used.
        """
        GetRecommendationStrategiesRecommendationStrategyCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            strategies=strategies,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             strategies: Sequence['outputs.GetRecommendationStrategiesRecommendationStrategyCollectionItemStrategyResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("strategies", strategies)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def strategies(self) -> Sequence['outputs.GetRecommendationStrategiesRecommendationStrategyCollectionItemStrategyResult']:
        """
        The list of strategies used.
        """
        return pulumi.get(self, "strategies")


@pulumi.output_type
class GetRecommendationStrategiesRecommendationStrategyCollectionItemStrategyResult(dict):
    def __init__(__self__, *,
                 is_default: bool,
                 parameters_definitions: Sequence['outputs.GetRecommendationStrategiesRecommendationStrategyCollectionItemStrategyParametersDefinitionResult'],
                 strategy_name: str):
        """
        :param bool is_default: Whether this is the default recommendation strategy.
        :param Sequence['GetRecommendationStrategiesRecommendationStrategyCollectionItemStrategyParametersDefinitionArgs'] parameters_definitions: The list of strategies for the parameters.
        :param str strategy_name: The name of the strategy.
        """
        GetRecommendationStrategiesRecommendationStrategyCollectionItemStrategyResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_default=is_default,
            parameters_definitions=parameters_definitions,
            strategy_name=strategy_name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_default: bool,
             parameters_definitions: Sequence['outputs.GetRecommendationStrategiesRecommendationStrategyCollectionItemStrategyParametersDefinitionResult'],
             strategy_name: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isDefault' in kwargs:
            is_default = kwargs['isDefault']
        if 'parametersDefinitions' in kwargs:
            parameters_definitions = kwargs['parametersDefinitions']
        if 'strategyName' in kwargs:
            strategy_name = kwargs['strategyName']

        _setter("is_default", is_default)
        _setter("parameters_definitions", parameters_definitions)
        _setter("strategy_name", strategy_name)

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> bool:
        """
        Whether this is the default recommendation strategy.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter(name="parametersDefinitions")
    def parameters_definitions(self) -> Sequence['outputs.GetRecommendationStrategiesRecommendationStrategyCollectionItemStrategyParametersDefinitionResult']:
        """
        The list of strategies for the parameters.
        """
        return pulumi.get(self, "parameters_definitions")

    @property
    @pulumi.getter(name="strategyName")
    def strategy_name(self) -> str:
        """
        The name of the strategy.
        """
        return pulumi.get(self, "strategy_name")


@pulumi.output_type
class GetRecommendationStrategiesRecommendationStrategyCollectionItemStrategyParametersDefinitionResult(dict):
    def __init__(__self__, *,
                 default_values: Sequence[Any],
                 description: str,
                 is_required: bool,
                 name: str,
                 possible_values: Sequence[Any],
                 type: str):
        """
        :param Sequence[Any] default_values: A default value used for the strategy parameter.
        :param str description: Text describing the strategy parameter.
        :param bool is_required: Whether this parameter is required.
        :param str name: Optional. A filter that returns results that match the name specified.
        :param Sequence[Any] possible_values: The list of possible values used for these strategy parameters.
        :param str type: The type of strategy parameter.
        """
        GetRecommendationStrategiesRecommendationStrategyCollectionItemStrategyParametersDefinitionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            default_values=default_values,
            description=description,
            is_required=is_required,
            name=name,
            possible_values=possible_values,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             default_values: Sequence[Any],
             description: str,
             is_required: bool,
             name: str,
             possible_values: Sequence[Any],
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'defaultValues' in kwargs:
            default_values = kwargs['defaultValues']
        if 'isRequired' in kwargs:
            is_required = kwargs['isRequired']
        if 'possibleValues' in kwargs:
            possible_values = kwargs['possibleValues']

        _setter("default_values", default_values)
        _setter("description", description)
        _setter("is_required", is_required)
        _setter("name", name)
        _setter("possible_values", possible_values)
        _setter("type", type)

    @property
    @pulumi.getter(name="defaultValues")
    def default_values(self) -> Sequence[Any]:
        """
        A default value used for the strategy parameter.
        """
        return pulumi.get(self, "default_values")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Text describing the strategy parameter.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isRequired")
    def is_required(self) -> bool:
        """
        Whether this parameter is required.
        """
        return pulumi.get(self, "is_required")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="possibleValues")
    def possible_values(self) -> Sequence[Any]:
        """
        The list of possible values used for these strategy parameters.
        """
        return pulumi.get(self, "possible_values")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of strategy parameter.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRecommendationStrategyItemResult(dict):
    def __init__(__self__, *,
                 name: str,
                 strategies: Sequence['outputs.GetRecommendationStrategyItemStrategyResult']):
        """
        :param str name: Optional. A filter that returns results that match the name specified.
        :param Sequence['GetRecommendationStrategyItemStrategyArgs'] strategies: The list of strategies used.
        """
        GetRecommendationStrategyItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            strategies=strategies,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             strategies: Sequence['outputs.GetRecommendationStrategyItemStrategyResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("strategies", strategies)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def strategies(self) -> Sequence['outputs.GetRecommendationStrategyItemStrategyResult']:
        """
        The list of strategies used.
        """
        return pulumi.get(self, "strategies")


@pulumi.output_type
class GetRecommendationStrategyItemStrategyResult(dict):
    def __init__(__self__, *,
                 is_default: bool,
                 parameters_definitions: Sequence['outputs.GetRecommendationStrategyItemStrategyParametersDefinitionResult'],
                 strategy_name: str):
        """
        :param bool is_default: Whether this is the default recommendation strategy.
        :param Sequence['GetRecommendationStrategyItemStrategyParametersDefinitionArgs'] parameters_definitions: The list of strategies for the parameters.
        :param str strategy_name: The name of the strategy.
        """
        GetRecommendationStrategyItemStrategyResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_default=is_default,
            parameters_definitions=parameters_definitions,
            strategy_name=strategy_name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_default: bool,
             parameters_definitions: Sequence['outputs.GetRecommendationStrategyItemStrategyParametersDefinitionResult'],
             strategy_name: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isDefault' in kwargs:
            is_default = kwargs['isDefault']
        if 'parametersDefinitions' in kwargs:
            parameters_definitions = kwargs['parametersDefinitions']
        if 'strategyName' in kwargs:
            strategy_name = kwargs['strategyName']

        _setter("is_default", is_default)
        _setter("parameters_definitions", parameters_definitions)
        _setter("strategy_name", strategy_name)

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> bool:
        """
        Whether this is the default recommendation strategy.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter(name="parametersDefinitions")
    def parameters_definitions(self) -> Sequence['outputs.GetRecommendationStrategyItemStrategyParametersDefinitionResult']:
        """
        The list of strategies for the parameters.
        """
        return pulumi.get(self, "parameters_definitions")

    @property
    @pulumi.getter(name="strategyName")
    def strategy_name(self) -> str:
        """
        The name of the strategy.
        """
        return pulumi.get(self, "strategy_name")


@pulumi.output_type
class GetRecommendationStrategyItemStrategyParametersDefinitionResult(dict):
    def __init__(__self__, *,
                 default_values: Sequence[Any],
                 description: str,
                 is_required: bool,
                 name: str,
                 possible_values: Sequence[Any],
                 type: str):
        """
        :param Sequence[Any] default_values: A default value used for the strategy parameter.
        :param str description: Text describing the strategy parameter.
        :param bool is_required: Whether this parameter is required.
        :param str name: Optional. A filter that returns results that match the name specified.
        :param Sequence[Any] possible_values: The list of possible values used for these strategy parameters.
        :param str type: The type of strategy parameter.
        """
        GetRecommendationStrategyItemStrategyParametersDefinitionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            default_values=default_values,
            description=description,
            is_required=is_required,
            name=name,
            possible_values=possible_values,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             default_values: Sequence[Any],
             description: str,
             is_required: bool,
             name: str,
             possible_values: Sequence[Any],
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'defaultValues' in kwargs:
            default_values = kwargs['defaultValues']
        if 'isRequired' in kwargs:
            is_required = kwargs['isRequired']
        if 'possibleValues' in kwargs:
            possible_values = kwargs['possibleValues']

        _setter("default_values", default_values)
        _setter("description", description)
        _setter("is_required", is_required)
        _setter("name", name)
        _setter("possible_values", possible_values)
        _setter("type", type)

    @property
    @pulumi.getter(name="defaultValues")
    def default_values(self) -> Sequence[Any]:
        """
        A default value used for the strategy parameter.
        """
        return pulumi.get(self, "default_values")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Text describing the strategy parameter.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isRequired")
    def is_required(self) -> bool:
        """
        Whether this parameter is required.
        """
        return pulumi.get(self, "is_required")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="possibleValues")
    def possible_values(self) -> Sequence[Any]:
        """
        The list of possible values used for these strategy parameters.
        """
        return pulumi.get(self, "possible_values")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of strategy parameter.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRecommendationSupportedLevelResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetRecommendationSupportedLevelItemResult']):
        """
        :param Sequence['GetRecommendationSupportedLevelItemArgs'] items: The list of supported levels.
        """
        GetRecommendationSupportedLevelResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetRecommendationSupportedLevelItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetRecommendationSupportedLevelItemResult']:
        """
        The list of supported levels.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetRecommendationSupportedLevelItemResult(dict):
    def __init__(__self__, *,
                 name: str):
        """
        :param str name: The name of the profile level.
        """
        GetRecommendationSupportedLevelItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the profile level.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetRecommendationsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Optional. A filter that returns results that match the name specified.
        """
        GetRecommendationsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetRecommendationsRecommendationCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetRecommendationsRecommendationCollectionItemResult']):
        """
        :param Sequence['GetRecommendationsRecommendationCollectionItemArgs'] items: The list of supported levels.
        """
        GetRecommendationsRecommendationCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetRecommendationsRecommendationCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetRecommendationsRecommendationCollectionItemResult']:
        """
        The list of supported levels.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetRecommendationsRecommendationCollectionItemResult(dict):
    def __init__(__self__, *,
                 category_id: str,
                 compartment_id: str,
                 description: str,
                 estimated_cost_saving: float,
                 extended_metadata: Mapping[str, Any],
                 id: str,
                 importance: str,
                 name: str,
                 recommendation_id: str,
                 resource_counts: Sequence['outputs.GetRecommendationsRecommendationCollectionItemResourceCountResult'],
                 state: str,
                 status: str,
                 supported_levels: Sequence['outputs.GetRecommendationsRecommendationCollectionItemSupportedLevelResult'],
                 time_created: str,
                 time_status_begin: str,
                 time_status_end: str,
                 time_updated: str):
        """
        :param str category_id: The unique OCID associated with the category.
        :param str compartment_id: The OCID of the compartment.
        :param str description: Text describing the recommendation.
        :param float estimated_cost_saving: The estimated cost savings, in dollars, for the recommendation.
        :param Mapping[str, Any] extended_metadata: Additional metadata key/value pairs for the recommendation.
        :param str id: The unique OCID associated with the recommendation.
        :param str importance: The level of importance assigned to the recommendation.
        :param str name: Optional. A filter that returns results that match the name specified.
        :param Sequence['GetRecommendationsRecommendationCollectionItemResourceCountArgs'] resource_counts: An array of `ResourceCount` objects grouped by the status of the resource actions.
        :param str state: A filter that returns results that match the lifecycle state specified.
        :param str status: A filter that returns recommendations that match the status specified.
        :param Sequence['GetRecommendationsRecommendationCollectionItemSupportedLevelArgs'] supported_levels: Optional. The profile levels supported by a recommendation. For example, profile level values could be `Low`, `Medium`, and `High`. Not all recommendations support this field.
        :param str time_created: The date and time the recommendation details were created, in the format defined by RFC3339.
        :param str time_status_begin: The date and time that the recommendation entered its current status. The format is defined by RFC3339.
        :param str time_status_end: The date and time the current status will change. The format is defined by RFC3339.
        :param str time_updated: The date and time the recommendation details were last updated, in the format defined by RFC3339.
        """
        GetRecommendationsRecommendationCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            category_id=category_id,
            compartment_id=compartment_id,
            description=description,
            estimated_cost_saving=estimated_cost_saving,
            extended_metadata=extended_metadata,
            id=id,
            importance=importance,
            name=name,
            recommendation_id=recommendation_id,
            resource_counts=resource_counts,
            state=state,
            status=status,
            supported_levels=supported_levels,
            time_created=time_created,
            time_status_begin=time_status_begin,
            time_status_end=time_status_end,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             category_id: str,
             compartment_id: str,
             description: str,
             estimated_cost_saving: float,
             extended_metadata: Mapping[str, Any],
             id: str,
             importance: str,
             name: str,
             recommendation_id: str,
             resource_counts: Sequence['outputs.GetRecommendationsRecommendationCollectionItemResourceCountResult'],
             state: str,
             status: str,
             supported_levels: Sequence['outputs.GetRecommendationsRecommendationCollectionItemSupportedLevelResult'],
             time_created: str,
             time_status_begin: str,
             time_status_end: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'categoryId' in kwargs:
            category_id = kwargs['categoryId']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'estimatedCostSaving' in kwargs:
            estimated_cost_saving = kwargs['estimatedCostSaving']
        if 'extendedMetadata' in kwargs:
            extended_metadata = kwargs['extendedMetadata']
        if 'recommendationId' in kwargs:
            recommendation_id = kwargs['recommendationId']
        if 'resourceCounts' in kwargs:
            resource_counts = kwargs['resourceCounts']
        if 'supportedLevels' in kwargs:
            supported_levels = kwargs['supportedLevels']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeStatusBegin' in kwargs:
            time_status_begin = kwargs['timeStatusBegin']
        if 'timeStatusEnd' in kwargs:
            time_status_end = kwargs['timeStatusEnd']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        _setter("category_id", category_id)
        _setter("compartment_id", compartment_id)
        _setter("description", description)
        _setter("estimated_cost_saving", estimated_cost_saving)
        _setter("extended_metadata", extended_metadata)
        _setter("id", id)
        _setter("importance", importance)
        _setter("name", name)
        _setter("recommendation_id", recommendation_id)
        _setter("resource_counts", resource_counts)
        _setter("state", state)
        _setter("status", status)
        _setter("supported_levels", supported_levels)
        _setter("time_created", time_created)
        _setter("time_status_begin", time_status_begin)
        _setter("time_status_end", time_status_end)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="categoryId")
    def category_id(self) -> str:
        """
        The unique OCID associated with the category.
        """
        return pulumi.get(self, "category_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Text describing the recommendation.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="estimatedCostSaving")
    def estimated_cost_saving(self) -> float:
        """
        The estimated cost savings, in dollars, for the recommendation.
        """
        return pulumi.get(self, "estimated_cost_saving")

    @property
    @pulumi.getter(name="extendedMetadata")
    def extended_metadata(self) -> Mapping[str, Any]:
        """
        Additional metadata key/value pairs for the recommendation.
        """
        return pulumi.get(self, "extended_metadata")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The unique OCID associated with the recommendation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def importance(self) -> str:
        """
        The level of importance assigned to the recommendation.
        """
        return pulumi.get(self, "importance")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="recommendationId")
    def recommendation_id(self) -> str:
        return pulumi.get(self, "recommendation_id")

    @property
    @pulumi.getter(name="resourceCounts")
    def resource_counts(self) -> Sequence['outputs.GetRecommendationsRecommendationCollectionItemResourceCountResult']:
        """
        An array of `ResourceCount` objects grouped by the status of the resource actions.
        """
        return pulumi.get(self, "resource_counts")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter that returns results that match the lifecycle state specified.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        A filter that returns recommendations that match the status specified.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="supportedLevels")
    def supported_levels(self) -> Sequence['outputs.GetRecommendationsRecommendationCollectionItemSupportedLevelResult']:
        """
        Optional. The profile levels supported by a recommendation. For example, profile level values could be `Low`, `Medium`, and `High`. Not all recommendations support this field.
        """
        return pulumi.get(self, "supported_levels")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the recommendation details were created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeStatusBegin")
    def time_status_begin(self) -> str:
        """
        The date and time that the recommendation entered its current status. The format is defined by RFC3339.
        """
        return pulumi.get(self, "time_status_begin")

    @property
    @pulumi.getter(name="timeStatusEnd")
    def time_status_end(self) -> str:
        """
        The date and time the current status will change. The format is defined by RFC3339.
        """
        return pulumi.get(self, "time_status_end")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the recommendation details were last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetRecommendationsRecommendationCollectionItemResourceCountResult(dict):
    def __init__(__self__, *,
                 count: int,
                 status: str):
        """
        :param int count: The count of resources.
        :param str status: A filter that returns recommendations that match the status specified.
        """
        GetRecommendationsRecommendationCollectionItemResourceCountResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            count=count,
            status=status,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             count: int,
             status: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("count", count)
        _setter("status", status)

    @property
    @pulumi.getter
    def count(self) -> int:
        """
        The count of resources.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        A filter that returns recommendations that match the status specified.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetRecommendationsRecommendationCollectionItemSupportedLevelResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetRecommendationsRecommendationCollectionItemSupportedLevelItemResult']):
        """
        :param Sequence['GetRecommendationsRecommendationCollectionItemSupportedLevelItemArgs'] items: The list of supported levels.
        """
        GetRecommendationsRecommendationCollectionItemSupportedLevelResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetRecommendationsRecommendationCollectionItemSupportedLevelItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetRecommendationsRecommendationCollectionItemSupportedLevelItemResult']:
        """
        The list of supported levels.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetRecommendationsRecommendationCollectionItemSupportedLevelItemResult(dict):
    def __init__(__self__, *,
                 name: str):
        """
        :param str name: Optional. A filter that returns results that match the name specified.
        """
        GetRecommendationsRecommendationCollectionItemSupportedLevelItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetResourceActionActionResult(dict):
    def __init__(__self__, *,
                 description: str,
                 type: str,
                 url: str):
        """
        :param str description: Text describing the recommended action.
        :param str type: The status of the resource action.
        :param str url: The URL path to documentation that explains how to perform the action.
        """
        GetResourceActionActionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            description=description,
            type=type,
            url=url,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             description: str,
             type: str,
             url: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("description", description)
        _setter("type", type)
        _setter("url", url)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Text describing the recommended action.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The status of the resource action.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The URL path to documentation that explains how to perform the action.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetResourceActionsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Optional. A filter that returns results that match the name specified.
        """
        GetResourceActionsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetResourceActionsResourceActionCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetResourceActionsResourceActionCollectionItemResult']):
        GetResourceActionsResourceActionCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetResourceActionsResourceActionCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetResourceActionsResourceActionCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetResourceActionsResourceActionCollectionItemResult(dict):
    def __init__(__self__, *,
                 actions: Sequence['outputs.GetResourceActionsResourceActionCollectionItemActionResult'],
                 category_id: str,
                 compartment_id: str,
                 compartment_name: str,
                 estimated_cost_saving: float,
                 extended_metadata: Mapping[str, Any],
                 id: str,
                 metadata: Mapping[str, Any],
                 name: str,
                 recommendation_id: str,
                 resource_action_id: str,
                 resource_id: str,
                 resource_type: str,
                 state: str,
                 status: str,
                 time_created: str,
                 time_status_begin: str,
                 time_status_end: str,
                 time_updated: str):
        """
        :param Sequence['GetResourceActionsResourceActionCollectionItemActionArgs'] actions: Details about the recommended action.
        :param str category_id: The unique OCID associated with the category.
        :param str compartment_id: The OCID of the compartment.
        :param str compartment_name: The name associated with the compartment.
        :param float estimated_cost_saving: The estimated cost savings, in dollars, for the resource action.
        :param Mapping[str, Any] extended_metadata: Additional metadata key/value pairs that you provide. They serve the same purpose and functionality as fields in the `metadata` object.
        :param str id: The unique OCID associated with the resource action.
        :param Mapping[str, Any] metadata: Custom metadata key/value pairs for the resource action.
        :param str name: Optional. A filter that returns results that match the name specified.
        :param str recommendation_id: The unique OCID associated with the recommendation.
        :param str resource_id: The unique OCID associated with the resource.
        :param str resource_type: Optional. A filter that returns results that match the resource type specified.
        :param str state: A filter that returns results that match the lifecycle state specified.
        :param str status: A filter that returns recommendations that match the status specified.
        :param str time_created: The date and time the resource action details were created, in the format defined by RFC3339.
        :param str time_status_begin: The date and time that the resource action entered its current status. The format is defined by RFC3339.
        :param str time_status_end: The date and time the current status will change. The format is defined by RFC3339.
        :param str time_updated: The date and time the resource action details were last updated, in the format defined by RFC3339.
        """
        GetResourceActionsResourceActionCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            actions=actions,
            category_id=category_id,
            compartment_id=compartment_id,
            compartment_name=compartment_name,
            estimated_cost_saving=estimated_cost_saving,
            extended_metadata=extended_metadata,
            id=id,
            metadata=metadata,
            name=name,
            recommendation_id=recommendation_id,
            resource_action_id=resource_action_id,
            resource_id=resource_id,
            resource_type=resource_type,
            state=state,
            status=status,
            time_created=time_created,
            time_status_begin=time_status_begin,
            time_status_end=time_status_end,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             actions: Sequence['outputs.GetResourceActionsResourceActionCollectionItemActionResult'],
             category_id: str,
             compartment_id: str,
             compartment_name: str,
             estimated_cost_saving: float,
             extended_metadata: Mapping[str, Any],
             id: str,
             metadata: Mapping[str, Any],
             name: str,
             recommendation_id: str,
             resource_action_id: str,
             resource_id: str,
             resource_type: str,
             state: str,
             status: str,
             time_created: str,
             time_status_begin: str,
             time_status_end: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'categoryId' in kwargs:
            category_id = kwargs['categoryId']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'compartmentName' in kwargs:
            compartment_name = kwargs['compartmentName']
        if 'estimatedCostSaving' in kwargs:
            estimated_cost_saving = kwargs['estimatedCostSaving']
        if 'extendedMetadata' in kwargs:
            extended_metadata = kwargs['extendedMetadata']
        if 'recommendationId' in kwargs:
            recommendation_id = kwargs['recommendationId']
        if 'resourceActionId' in kwargs:
            resource_action_id = kwargs['resourceActionId']
        if 'resourceId' in kwargs:
            resource_id = kwargs['resourceId']
        if 'resourceType' in kwargs:
            resource_type = kwargs['resourceType']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeStatusBegin' in kwargs:
            time_status_begin = kwargs['timeStatusBegin']
        if 'timeStatusEnd' in kwargs:
            time_status_end = kwargs['timeStatusEnd']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        _setter("actions", actions)
        _setter("category_id", category_id)
        _setter("compartment_id", compartment_id)
        _setter("compartment_name", compartment_name)
        _setter("estimated_cost_saving", estimated_cost_saving)
        _setter("extended_metadata", extended_metadata)
        _setter("id", id)
        _setter("metadata", metadata)
        _setter("name", name)
        _setter("recommendation_id", recommendation_id)
        _setter("resource_action_id", resource_action_id)
        _setter("resource_id", resource_id)
        _setter("resource_type", resource_type)
        _setter("state", state)
        _setter("status", status)
        _setter("time_created", time_created)
        _setter("time_status_begin", time_status_begin)
        _setter("time_status_end", time_status_end)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GetResourceActionsResourceActionCollectionItemActionResult']:
        """
        Details about the recommended action.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="categoryId")
    def category_id(self) -> str:
        """
        The unique OCID associated with the category.
        """
        return pulumi.get(self, "category_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentName")
    def compartment_name(self) -> str:
        """
        The name associated with the compartment.
        """
        return pulumi.get(self, "compartment_name")

    @property
    @pulumi.getter(name="estimatedCostSaving")
    def estimated_cost_saving(self) -> float:
        """
        The estimated cost savings, in dollars, for the resource action.
        """
        return pulumi.get(self, "estimated_cost_saving")

    @property
    @pulumi.getter(name="extendedMetadata")
    def extended_metadata(self) -> Mapping[str, Any]:
        """
        Additional metadata key/value pairs that you provide. They serve the same purpose and functionality as fields in the `metadata` object.
        """
        return pulumi.get(self, "extended_metadata")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The unique OCID associated with the resource action.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, Any]:
        """
        Custom metadata key/value pairs for the resource action.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional. A filter that returns results that match the name specified.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="recommendationId")
    def recommendation_id(self) -> str:
        """
        The unique OCID associated with the recommendation.
        """
        return pulumi.get(self, "recommendation_id")

    @property
    @pulumi.getter(name="resourceActionId")
    def resource_action_id(self) -> str:
        return pulumi.get(self, "resource_action_id")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The unique OCID associated with the resource.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        Optional. A filter that returns results that match the resource type specified.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter that returns results that match the lifecycle state specified.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        A filter that returns recommendations that match the status specified.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the resource action details were created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeStatusBegin")
    def time_status_begin(self) -> str:
        """
        The date and time that the resource action entered its current status. The format is defined by RFC3339.
        """
        return pulumi.get(self, "time_status_begin")

    @property
    @pulumi.getter(name="timeStatusEnd")
    def time_status_end(self) -> str:
        """
        The date and time the current status will change. The format is defined by RFC3339.
        """
        return pulumi.get(self, "time_status_end")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the resource action details were last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetResourceActionsResourceActionCollectionItemActionResult(dict):
    def __init__(__self__, *,
                 description: str,
                 type: str,
                 url: str):
        """
        :param str description: Text describing the recommended action.
        :param str type: The status of the resource action.
        :param str url: The URL path to documentation that explains how to perform the action.
        """
        GetResourceActionsResourceActionCollectionItemActionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            description=description,
            type=type,
            url=url,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             description: str,
             type: str,
             url: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("description", description)
        _setter("type", type)
        _setter("url", url)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Text describing the recommended action.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The status of the resource action.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The URL path to documentation that explains how to perform the action.
        """
        return pulumi.get(self, "url")


