# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetServiceConnectorsResult',
    'AwaitableGetServiceConnectorsResult',
    'get_service_connectors',
    'get_service_connectors_output',
]

@pulumi.output_type
class GetServiceConnectorsResult:
    """
    A collection of values returned by getServiceConnectors.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, service_connector_collections=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if service_connector_collections and not isinstance(service_connector_collections, list):
            raise TypeError("Expected argument 'service_connector_collections' to be a list")
        pulumi.set(__self__, "service_connector_collections", service_connector_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the metric.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetServiceConnectorsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="serviceConnectorCollections")
    def service_connector_collections(self) -> Sequence['outputs.GetServiceConnectorsServiceConnectorCollectionResult']:
        """
        The list of service_connector_collection.
        """
        return pulumi.get(self, "service_connector_collections")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the service connector.
        """
        return pulumi.get(self, "state")


class AwaitableGetServiceConnectorsResult(GetServiceConnectorsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceConnectorsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            service_connector_collections=self.service_connector_collections,
            state=self.state)


def get_service_connectors(compartment_id: Optional[str] = None,
                           display_name: Optional[str] = None,
                           filters: Optional[Sequence[pulumi.InputType['GetServiceConnectorsFilterArgs']]] = None,
                           state: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceConnectorsResult:
    """
    This data source provides the list of Service Connectors in Oracle Cloud Infrastructure Service Connector Hub service.

    Lists service connectors in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_service_connectors = oci.Sch.get_service_connectors(compartment_id=var["compartment_id"],
        display_name=var["service_connector_display_name"],
        state=var["service_connector_state"])
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment for this request.
    :param str display_name: A filter to return only resources that match the given display name exactly.  Example: `example_service_connector`
    :param str state: A filter to return only resources that match the given lifecycle state.  Example: `ACTIVE`
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Sch/getServiceConnectors:getServiceConnectors', __args__, opts=opts, typ=GetServiceConnectorsResult).value

    return AwaitableGetServiceConnectorsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        service_connector_collections=pulumi.get(__ret__, 'service_connector_collections'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_service_connectors)
def get_service_connectors_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                  display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                  filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetServiceConnectorsFilterArgs']]]]] = None,
                                  state: Optional[pulumi.Input[Optional[str]]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetServiceConnectorsResult]:
    """
    This data source provides the list of Service Connectors in Oracle Cloud Infrastructure Service Connector Hub service.

    Lists service connectors in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_service_connectors = oci.Sch.get_service_connectors(compartment_id=var["compartment_id"],
        display_name=var["service_connector_display_name"],
        state=var["service_connector_state"])
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment for this request.
    :param str display_name: A filter to return only resources that match the given display name exactly.  Example: `example_service_connector`
    :param str state: A filter to return only resources that match the given lifecycle state.  Example: `ACTIVE`
    """
    ...
