# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'StreamPoolCustomEncryptionKey',
    'StreamPoolKafkaSettings',
    'StreamPoolPrivateEndpointSettings',
    'GetConnectHarnessesConnectHarnessResult',
    'GetConnectHarnessesFilterResult',
    'GetStreamPoolCustomEncryptionKeyResult',
    'GetStreamPoolKafkaSettingResult',
    'GetStreamPoolPrivateEndpointSettingResult',
    'GetStreamPoolsFilterResult',
    'GetStreamPoolsStreamPoolResult',
    'GetStreamPoolsStreamPoolCustomEncryptionKeyResult',
    'GetStreamPoolsStreamPoolKafkaSettingResult',
    'GetStreamPoolsStreamPoolPrivateEndpointSettingResult',
    'GetStreamsFilterResult',
    'GetStreamsStreamResult',
]

@pulumi.output_type
class StreamPoolCustomEncryptionKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "keyState":
            suggest = "key_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamPoolCustomEncryptionKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamPoolCustomEncryptionKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamPoolCustomEncryptionKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_id: str,
                 key_state: Optional[str] = None):
        """
        :param str kms_key_id: (Updatable) Custom Encryption Key (Master Key) ocid.
        :param str key_state: Life cycle State of the custom key
        """
        StreamPoolCustomEncryptionKey._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            kms_key_id=kms_key_id,
            key_state=key_state,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             kms_key_id: str,
             key_state: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'kmsKeyId' in kwargs:
            kms_key_id = kwargs['kmsKeyId']
        if 'keyState' in kwargs:
            key_state = kwargs['keyState']

        _setter("kms_key_id", kms_key_id)
        if key_state is not None:
            _setter("key_state", key_state)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> str:
        """
        (Updatable) Custom Encryption Key (Master Key) ocid.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="keyState")
    def key_state(self) -> Optional[str]:
        """
        Life cycle State of the custom key
        """
        return pulumi.get(self, "key_state")


@pulumi.output_type
class StreamPoolKafkaSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoCreateTopicsEnable":
            suggest = "auto_create_topics_enable"
        elif key == "bootstrapServers":
            suggest = "bootstrap_servers"
        elif key == "logRetentionHours":
            suggest = "log_retention_hours"
        elif key == "numPartitions":
            suggest = "num_partitions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamPoolKafkaSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamPoolKafkaSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamPoolKafkaSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_create_topics_enable: Optional[bool] = None,
                 bootstrap_servers: Optional[str] = None,
                 log_retention_hours: Optional[int] = None,
                 num_partitions: Optional[int] = None):
        """
        :param bool auto_create_topics_enable: (Updatable) Enable auto creation of topic on the server.
        :param str bootstrap_servers: (Updatable) Bootstrap servers.
        :param int log_retention_hours: (Updatable) The number of hours to keep a log file before deleting it (in hours).
        :param int num_partitions: (Updatable) The default number of log partitions per topic.
        """
        StreamPoolKafkaSettings._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            auto_create_topics_enable=auto_create_topics_enable,
            bootstrap_servers=bootstrap_servers,
            log_retention_hours=log_retention_hours,
            num_partitions=num_partitions,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             auto_create_topics_enable: Optional[bool] = None,
             bootstrap_servers: Optional[str] = None,
             log_retention_hours: Optional[int] = None,
             num_partitions: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'autoCreateTopicsEnable' in kwargs:
            auto_create_topics_enable = kwargs['autoCreateTopicsEnable']
        if 'bootstrapServers' in kwargs:
            bootstrap_servers = kwargs['bootstrapServers']
        if 'logRetentionHours' in kwargs:
            log_retention_hours = kwargs['logRetentionHours']
        if 'numPartitions' in kwargs:
            num_partitions = kwargs['numPartitions']

        if auto_create_topics_enable is not None:
            _setter("auto_create_topics_enable", auto_create_topics_enable)
        if bootstrap_servers is not None:
            _setter("bootstrap_servers", bootstrap_servers)
        if log_retention_hours is not None:
            _setter("log_retention_hours", log_retention_hours)
        if num_partitions is not None:
            _setter("num_partitions", num_partitions)

    @property
    @pulumi.getter(name="autoCreateTopicsEnable")
    def auto_create_topics_enable(self) -> Optional[bool]:
        """
        (Updatable) Enable auto creation of topic on the server.
        """
        return pulumi.get(self, "auto_create_topics_enable")

    @property
    @pulumi.getter(name="bootstrapServers")
    def bootstrap_servers(self) -> Optional[str]:
        """
        (Updatable) Bootstrap servers.
        """
        return pulumi.get(self, "bootstrap_servers")

    @property
    @pulumi.getter(name="logRetentionHours")
    def log_retention_hours(self) -> Optional[int]:
        """
        (Updatable) The number of hours to keep a log file before deleting it (in hours).
        """
        return pulumi.get(self, "log_retention_hours")

    @property
    @pulumi.getter(name="numPartitions")
    def num_partitions(self) -> Optional[int]:
        """
        (Updatable) The default number of log partitions per topic.
        """
        return pulumi.get(self, "num_partitions")


@pulumi.output_type
class StreamPoolPrivateEndpointSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nsgIds":
            suggest = "nsg_ids"
        elif key == "privateEndpointIp":
            suggest = "private_endpoint_ip"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamPoolPrivateEndpointSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamPoolPrivateEndpointSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamPoolPrivateEndpointSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 nsg_ids: Optional[Sequence[str]] = None,
                 private_endpoint_ip: Optional[str] = None,
                 subnet_id: Optional[str] = None):
        """
        :param Sequence[str] nsg_ids: The optional list of network security groups to be used with the private endpoint of the stream pool. That value cannot be changed.
        :param str private_endpoint_ip: The optional private IP you want to be associated with your private stream pool. That parameter can only be specified when the subnetId parameter is set. It cannot be changed. The private IP needs to be part of the CIDR range of the specified subnetId or the creation will fail. If not specified a random IP inside the subnet will be chosen. After the stream pool is created, a custom FQDN, pointing to this private IP, is created. The FQDN is then used to access the service instead of the private IP.
        :param str subnet_id: If specified, the stream pool will be private and only accessible from inside that subnet. Producing-to and consuming-from a stream inside a private stream pool can also only be done from inside the subnet. That value cannot be changed. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        StreamPoolPrivateEndpointSettings._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            nsg_ids=nsg_ids,
            private_endpoint_ip=private_endpoint_ip,
            subnet_id=subnet_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             nsg_ids: Optional[Sequence[str]] = None,
             private_endpoint_ip: Optional[str] = None,
             subnet_id: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'nsgIds' in kwargs:
            nsg_ids = kwargs['nsgIds']
        if 'privateEndpointIp' in kwargs:
            private_endpoint_ip = kwargs['privateEndpointIp']
        if 'subnetId' in kwargs:
            subnet_id = kwargs['subnetId']

        if nsg_ids is not None:
            _setter("nsg_ids", nsg_ids)
        if private_endpoint_ip is not None:
            _setter("private_endpoint_ip", private_endpoint_ip)
        if subnet_id is not None:
            _setter("subnet_id", subnet_id)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[Sequence[str]]:
        """
        The optional list of network security groups to be used with the private endpoint of the stream pool. That value cannot be changed.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="privateEndpointIp")
    def private_endpoint_ip(self) -> Optional[str]:
        """
        The optional private IP you want to be associated with your private stream pool. That parameter can only be specified when the subnetId parameter is set. It cannot be changed. The private IP needs to be part of the CIDR range of the specified subnetId or the creation will fail. If not specified a random IP inside the subnet will be chosen. After the stream pool is created, a custom FQDN, pointing to this private IP, is created. The FQDN is then used to access the service instead of the private IP.
        """
        return pulumi.get(self, "private_endpoint_ip")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[str]:
        """
        If specified, the stream pool will be private and only accessible from inside that subnet. Producing-to and consuming-from a stream inside a private stream pool can also only be done from inside the subnet. That value cannot be changed. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetConnectHarnessesConnectHarnessResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 lifecycle_state_details: str,
                 name: str,
                 state: str,
                 time_created: str):
        """
        :param str compartment_id: The OCID of the compartment.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations": {"CostCenter": "42"}}'
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair that is applied with no predefined name, type, or namespace. Exists for cross-compatibility only. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param str id: A filter to return only resources that match the given ID exactly.
        :param str lifecycle_state_details: Any additional details about the current state of the connect harness.
        :param str name: A filter to return only resources that match the given name exactly.
        :param str state: A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
        :param str time_created: The date and time the connect harness was created, expressed in in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2018-04-20T00:00:07.405Z`
        """
        GetConnectHarnessesConnectHarnessResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            freeform_tags=freeform_tags,
            id=id,
            lifecycle_state_details=lifecycle_state_details,
            name=name,
            state=state,
            time_created=time_created,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             freeform_tags: Mapping[str, Any],
             id: str,
             lifecycle_state_details: str,
             name: str,
             state: str,
             time_created: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'lifecycleStateDetails' in kwargs:
            lifecycle_state_details = kwargs['lifecycleStateDetails']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']

        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("lifecycle_state_details", lifecycle_state_details)
        _setter("name", name)
        _setter("state", state)
        _setter("time_created", time_created)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations": {"CostCenter": "42"}}'
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair that is applied with no predefined name, type, or namespace. Exists for cross-compatibility only. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A filter to return only resources that match the given ID exactly.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> str:
        """
        Any additional details about the current state of the connect harness.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that match the given name exactly.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the connect harness was created, expressed in in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2018-04-20T00:00:07.405Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetConnectHarnessesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: A filter to return only resources that match the given name exactly.
        """
        GetConnectHarnessesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that match the given name exactly.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetStreamPoolCustomEncryptionKeyResult(dict):
    def __init__(__self__, *,
                 key_state: str,
                 kms_key_id: str):
        """
        :param str key_state: Life cycle State of the custom key
        :param str kms_key_id: Custom Encryption Key (Master Key) ocid.
        """
        GetStreamPoolCustomEncryptionKeyResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            key_state=key_state,
            kms_key_id=kms_key_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             key_state: str,
             kms_key_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'keyState' in kwargs:
            key_state = kwargs['keyState']
        if 'kmsKeyId' in kwargs:
            kms_key_id = kwargs['kmsKeyId']

        _setter("key_state", key_state)
        _setter("kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="keyState")
    def key_state(self) -> str:
        """
        Life cycle State of the custom key
        """
        return pulumi.get(self, "key_state")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> str:
        """
        Custom Encryption Key (Master Key) ocid.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class GetStreamPoolKafkaSettingResult(dict):
    def __init__(__self__, *,
                 auto_create_topics_enable: bool,
                 bootstrap_servers: str,
                 log_retention_hours: int,
                 num_partitions: int):
        """
        :param bool auto_create_topics_enable: Enable auto creation of topic on the server.
        :param str bootstrap_servers: Bootstrap servers.
        :param int log_retention_hours: The number of hours to keep a log file before deleting it (in hours).
        :param int num_partitions: The default number of log partitions per topic.
        """
        GetStreamPoolKafkaSettingResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            auto_create_topics_enable=auto_create_topics_enable,
            bootstrap_servers=bootstrap_servers,
            log_retention_hours=log_retention_hours,
            num_partitions=num_partitions,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             auto_create_topics_enable: bool,
             bootstrap_servers: str,
             log_retention_hours: int,
             num_partitions: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'autoCreateTopicsEnable' in kwargs:
            auto_create_topics_enable = kwargs['autoCreateTopicsEnable']
        if 'bootstrapServers' in kwargs:
            bootstrap_servers = kwargs['bootstrapServers']
        if 'logRetentionHours' in kwargs:
            log_retention_hours = kwargs['logRetentionHours']
        if 'numPartitions' in kwargs:
            num_partitions = kwargs['numPartitions']

        _setter("auto_create_topics_enable", auto_create_topics_enable)
        _setter("bootstrap_servers", bootstrap_servers)
        _setter("log_retention_hours", log_retention_hours)
        _setter("num_partitions", num_partitions)

    @property
    @pulumi.getter(name="autoCreateTopicsEnable")
    def auto_create_topics_enable(self) -> bool:
        """
        Enable auto creation of topic on the server.
        """
        return pulumi.get(self, "auto_create_topics_enable")

    @property
    @pulumi.getter(name="bootstrapServers")
    def bootstrap_servers(self) -> str:
        """
        Bootstrap servers.
        """
        return pulumi.get(self, "bootstrap_servers")

    @property
    @pulumi.getter(name="logRetentionHours")
    def log_retention_hours(self) -> int:
        """
        The number of hours to keep a log file before deleting it (in hours).
        """
        return pulumi.get(self, "log_retention_hours")

    @property
    @pulumi.getter(name="numPartitions")
    def num_partitions(self) -> int:
        """
        The default number of log partitions per topic.
        """
        return pulumi.get(self, "num_partitions")


@pulumi.output_type
class GetStreamPoolPrivateEndpointSettingResult(dict):
    def __init__(__self__, *,
                 nsg_ids: Sequence[str],
                 private_endpoint_ip: str,
                 subnet_id: str):
        """
        :param Sequence[str] nsg_ids: The optional list of network security groups that are associated with the private endpoint of the stream pool.
        :param str private_endpoint_ip: The private IP associated with the stream pool in the associated subnetId. The stream pool's FQDN resolves to that IP and should be used - instead of the private IP - in order to not trigger any TLS issues.
        :param str subnet_id: The subnet id from which the private stream pool can be accessed. Trying to access the streams from another network location will result in an error.
        """
        GetStreamPoolPrivateEndpointSettingResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            nsg_ids=nsg_ids,
            private_endpoint_ip=private_endpoint_ip,
            subnet_id=subnet_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             nsg_ids: Sequence[str],
             private_endpoint_ip: str,
             subnet_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'nsgIds' in kwargs:
            nsg_ids = kwargs['nsgIds']
        if 'privateEndpointIp' in kwargs:
            private_endpoint_ip = kwargs['privateEndpointIp']
        if 'subnetId' in kwargs:
            subnet_id = kwargs['subnetId']

        _setter("nsg_ids", nsg_ids)
        _setter("private_endpoint_ip", private_endpoint_ip)
        _setter("subnet_id", subnet_id)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[str]:
        """
        The optional list of network security groups that are associated with the private endpoint of the stream pool.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="privateEndpointIp")
    def private_endpoint_ip(self) -> str:
        """
        The private IP associated with the stream pool in the associated subnetId. The stream pool's FQDN resolves to that IP and should be used - instead of the private IP - in order to not trigger any TLS issues.
        """
        return pulumi.get(self, "private_endpoint_ip")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The subnet id from which the private stream pool can be accessed. Trying to access the streams from another network location will result in an error.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetStreamPoolsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: A filter to return only resources that match the given name exactly.
        """
        GetStreamPoolsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that match the given name exactly.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetStreamPoolsStreamPoolResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 custom_encryption_keys: Sequence['outputs.GetStreamPoolsStreamPoolCustomEncryptionKeyResult'],
                 defined_tags: Mapping[str, Any],
                 endpoint_fqdn: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 is_private: bool,
                 kafka_settings: Sequence['outputs.GetStreamPoolsStreamPoolKafkaSettingResult'],
                 lifecycle_state_details: str,
                 name: str,
                 private_endpoint_settings: Sequence['outputs.GetStreamPoolsStreamPoolPrivateEndpointSettingResult'],
                 state: str,
                 time_created: str):
        """
        :param str compartment_id: The OCID of the compartment.
        :param Sequence['GetStreamPoolsStreamPoolCustomEncryptionKeyArgs'] custom_encryption_keys: Custom Encryption Key which will be used for encryption by all the streams in the pool.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations": {"CostCenter": "42"}}'
        :param str endpoint_fqdn: The FQDN used to access the streams inside the stream pool (same FQDN as the messagesEndpoint attribute of a [Stream](https://docs.cloud.oracle.com/iaas/api/#/en/streaming/20180418/Stream) object). If the stream pool is private, the FQDN is customized and can only be accessed from inside the associated subnetId, otherwise the FQDN is publicly resolvable. Depending on which protocol you attempt to use, you need to either prepend https or append the Kafka port.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair that is applied with no predefined name, type, or namespace. Exists for cross-compatibility only. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param str id: A filter to return only resources that match the given ID exactly.
        :param bool is_private: True if the stream pool is private, false otherwise. The associated endpoint and subnetId of a private stream pool can be retrieved through the [GetStreamPool](https://docs.cloud.oracle.com/iaas/api/#/en/streaming/20180418/StreamPool/GetStreamPool) API.
        :param Sequence['GetStreamPoolsStreamPoolKafkaSettingArgs'] kafka_settings: Settings for the Kafka compatibility layer.
        :param str lifecycle_state_details: Any additional details about the current state of the stream.
        :param str name: A filter to return only resources that match the given name exactly.
        :param Sequence['GetStreamPoolsStreamPoolPrivateEndpointSettingArgs'] private_endpoint_settings: Optional settings if the stream pool is private.
        :param str state: A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
        :param str time_created: The date and time the stream pool was created, expressed in in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2018-04-20T00:00:07.405Z`
        """
        GetStreamPoolsStreamPoolResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            custom_encryption_keys=custom_encryption_keys,
            defined_tags=defined_tags,
            endpoint_fqdn=endpoint_fqdn,
            freeform_tags=freeform_tags,
            id=id,
            is_private=is_private,
            kafka_settings=kafka_settings,
            lifecycle_state_details=lifecycle_state_details,
            name=name,
            private_endpoint_settings=private_endpoint_settings,
            state=state,
            time_created=time_created,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             custom_encryption_keys: Sequence['outputs.GetStreamPoolsStreamPoolCustomEncryptionKeyResult'],
             defined_tags: Mapping[str, Any],
             endpoint_fqdn: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             is_private: bool,
             kafka_settings: Sequence['outputs.GetStreamPoolsStreamPoolKafkaSettingResult'],
             lifecycle_state_details: str,
             name: str,
             private_endpoint_settings: Sequence['outputs.GetStreamPoolsStreamPoolPrivateEndpointSettingResult'],
             state: str,
             time_created: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'customEncryptionKeys' in kwargs:
            custom_encryption_keys = kwargs['customEncryptionKeys']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'endpointFqdn' in kwargs:
            endpoint_fqdn = kwargs['endpointFqdn']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'isPrivate' in kwargs:
            is_private = kwargs['isPrivate']
        if 'kafkaSettings' in kwargs:
            kafka_settings = kwargs['kafkaSettings']
        if 'lifecycleStateDetails' in kwargs:
            lifecycle_state_details = kwargs['lifecycleStateDetails']
        if 'privateEndpointSettings' in kwargs:
            private_endpoint_settings = kwargs['privateEndpointSettings']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']

        _setter("compartment_id", compartment_id)
        _setter("custom_encryption_keys", custom_encryption_keys)
        _setter("defined_tags", defined_tags)
        _setter("endpoint_fqdn", endpoint_fqdn)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("is_private", is_private)
        _setter("kafka_settings", kafka_settings)
        _setter("lifecycle_state_details", lifecycle_state_details)
        _setter("name", name)
        _setter("private_endpoint_settings", private_endpoint_settings)
        _setter("state", state)
        _setter("time_created", time_created)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="customEncryptionKeys")
    def custom_encryption_keys(self) -> Sequence['outputs.GetStreamPoolsStreamPoolCustomEncryptionKeyResult']:
        """
        Custom Encryption Key which will be used for encryption by all the streams in the pool.
        """
        return pulumi.get(self, "custom_encryption_keys")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations": {"CostCenter": "42"}}'
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="endpointFqdn")
    def endpoint_fqdn(self) -> str:
        """
        The FQDN used to access the streams inside the stream pool (same FQDN as the messagesEndpoint attribute of a [Stream](https://docs.cloud.oracle.com/iaas/api/#/en/streaming/20180418/Stream) object). If the stream pool is private, the FQDN is customized and can only be accessed from inside the associated subnetId, otherwise the FQDN is publicly resolvable. Depending on which protocol you attempt to use, you need to either prepend https or append the Kafka port.
        """
        return pulumi.get(self, "endpoint_fqdn")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair that is applied with no predefined name, type, or namespace. Exists for cross-compatibility only. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A filter to return only resources that match the given ID exactly.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isPrivate")
    def is_private(self) -> bool:
        """
        True if the stream pool is private, false otherwise. The associated endpoint and subnetId of a private stream pool can be retrieved through the [GetStreamPool](https://docs.cloud.oracle.com/iaas/api/#/en/streaming/20180418/StreamPool/GetStreamPool) API.
        """
        return pulumi.get(self, "is_private")

    @property
    @pulumi.getter(name="kafkaSettings")
    def kafka_settings(self) -> Sequence['outputs.GetStreamPoolsStreamPoolKafkaSettingResult']:
        """
        Settings for the Kafka compatibility layer.
        """
        return pulumi.get(self, "kafka_settings")

    @property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> str:
        """
        Any additional details about the current state of the stream.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that match the given name exactly.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateEndpointSettings")
    def private_endpoint_settings(self) -> Sequence['outputs.GetStreamPoolsStreamPoolPrivateEndpointSettingResult']:
        """
        Optional settings if the stream pool is private.
        """
        return pulumi.get(self, "private_endpoint_settings")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the stream pool was created, expressed in in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2018-04-20T00:00:07.405Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetStreamPoolsStreamPoolCustomEncryptionKeyResult(dict):
    def __init__(__self__, *,
                 key_state: str,
                 kms_key_id: str):
        """
        :param str key_state: Life cycle State of the custom key
        :param str kms_key_id: Custom Encryption Key (Master Key) ocid.
        """
        GetStreamPoolsStreamPoolCustomEncryptionKeyResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            key_state=key_state,
            kms_key_id=kms_key_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             key_state: str,
             kms_key_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'keyState' in kwargs:
            key_state = kwargs['keyState']
        if 'kmsKeyId' in kwargs:
            kms_key_id = kwargs['kmsKeyId']

        _setter("key_state", key_state)
        _setter("kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="keyState")
    def key_state(self) -> str:
        """
        Life cycle State of the custom key
        """
        return pulumi.get(self, "key_state")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> str:
        """
        Custom Encryption Key (Master Key) ocid.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class GetStreamPoolsStreamPoolKafkaSettingResult(dict):
    def __init__(__self__, *,
                 auto_create_topics_enable: bool,
                 bootstrap_servers: str,
                 log_retention_hours: int,
                 num_partitions: int):
        """
        :param bool auto_create_topics_enable: Enable auto creation of topic on the server.
        :param str bootstrap_servers: Bootstrap servers.
        :param int log_retention_hours: The number of hours to keep a log file before deleting it (in hours).
        :param int num_partitions: The default number of log partitions per topic.
        """
        GetStreamPoolsStreamPoolKafkaSettingResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            auto_create_topics_enable=auto_create_topics_enable,
            bootstrap_servers=bootstrap_servers,
            log_retention_hours=log_retention_hours,
            num_partitions=num_partitions,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             auto_create_topics_enable: bool,
             bootstrap_servers: str,
             log_retention_hours: int,
             num_partitions: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'autoCreateTopicsEnable' in kwargs:
            auto_create_topics_enable = kwargs['autoCreateTopicsEnable']
        if 'bootstrapServers' in kwargs:
            bootstrap_servers = kwargs['bootstrapServers']
        if 'logRetentionHours' in kwargs:
            log_retention_hours = kwargs['logRetentionHours']
        if 'numPartitions' in kwargs:
            num_partitions = kwargs['numPartitions']

        _setter("auto_create_topics_enable", auto_create_topics_enable)
        _setter("bootstrap_servers", bootstrap_servers)
        _setter("log_retention_hours", log_retention_hours)
        _setter("num_partitions", num_partitions)

    @property
    @pulumi.getter(name="autoCreateTopicsEnable")
    def auto_create_topics_enable(self) -> bool:
        """
        Enable auto creation of topic on the server.
        """
        return pulumi.get(self, "auto_create_topics_enable")

    @property
    @pulumi.getter(name="bootstrapServers")
    def bootstrap_servers(self) -> str:
        """
        Bootstrap servers.
        """
        return pulumi.get(self, "bootstrap_servers")

    @property
    @pulumi.getter(name="logRetentionHours")
    def log_retention_hours(self) -> int:
        """
        The number of hours to keep a log file before deleting it (in hours).
        """
        return pulumi.get(self, "log_retention_hours")

    @property
    @pulumi.getter(name="numPartitions")
    def num_partitions(self) -> int:
        """
        The default number of log partitions per topic.
        """
        return pulumi.get(self, "num_partitions")


@pulumi.output_type
class GetStreamPoolsStreamPoolPrivateEndpointSettingResult(dict):
    def __init__(__self__, *,
                 nsg_ids: Sequence[str],
                 private_endpoint_ip: str,
                 subnet_id: str):
        """
        :param Sequence[str] nsg_ids: The optional list of network security groups that are associated with the private endpoint of the stream pool.
        :param str private_endpoint_ip: The private IP associated with the stream pool in the associated subnetId. The stream pool's FQDN resolves to that IP and should be used - instead of the private IP - in order to not trigger any TLS issues.
        :param str subnet_id: The subnet id from which the private stream pool can be accessed. Trying to access the streams from another network location will result in an error.
        """
        GetStreamPoolsStreamPoolPrivateEndpointSettingResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            nsg_ids=nsg_ids,
            private_endpoint_ip=private_endpoint_ip,
            subnet_id=subnet_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             nsg_ids: Sequence[str],
             private_endpoint_ip: str,
             subnet_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'nsgIds' in kwargs:
            nsg_ids = kwargs['nsgIds']
        if 'privateEndpointIp' in kwargs:
            private_endpoint_ip = kwargs['privateEndpointIp']
        if 'subnetId' in kwargs:
            subnet_id = kwargs['subnetId']

        _setter("nsg_ids", nsg_ids)
        _setter("private_endpoint_ip", private_endpoint_ip)
        _setter("subnet_id", subnet_id)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[str]:
        """
        The optional list of network security groups that are associated with the private endpoint of the stream pool.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="privateEndpointIp")
    def private_endpoint_ip(self) -> str:
        """
        The private IP associated with the stream pool in the associated subnetId. The stream pool's FQDN resolves to that IP and should be used - instead of the private IP - in order to not trigger any TLS issues.
        """
        return pulumi.get(self, "private_endpoint_ip")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The subnet id from which the private stream pool can be accessed. Trying to access the streams from another network location will result in an error.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetStreamsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: A filter to return only resources that match the given name exactly.
        """
        GetStreamsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that match the given name exactly.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetStreamsStreamResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 lifecycle_state_details: str,
                 messages_endpoint: str,
                 name: str,
                 partitions: int,
                 retention_in_hours: int,
                 state: str,
                 stream_pool_id: str,
                 time_created: str):
        """
        :param str compartment_id: The OCID of the compartment. Is exclusive with the `streamPoolId` parameter. One of them is required.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations": {"CostCenter": "42"}}'
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair that is applied with no predefined name, type, or namespace. Exists for cross-compatibility only. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param str id: A filter to return only resources that match the given ID exactly.
        :param str lifecycle_state_details: Any additional details about the current state of the stream.
        :param str messages_endpoint: The endpoint to use when creating the StreamClient to consume or publish messages in the stream. If the associated stream pool is private, the endpoint is also private and can only be accessed from inside the stream pool's associated subnet.
        :param str name: A filter to return only resources that match the given name exactly.
        :param int partitions: The number of partitions in the stream.
        :param int retention_in_hours: The retention period of the stream, in hours. This property is read-only.
        :param str state: A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
        :param str stream_pool_id: The OCID of the stream pool. Is exclusive with the `compartmentId` parameter. One of them is required.
        :param str time_created: The date and time the stream was created, expressed in in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2018-04-20T00:00:07.405Z`
        """
        GetStreamsStreamResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            freeform_tags=freeform_tags,
            id=id,
            lifecycle_state_details=lifecycle_state_details,
            messages_endpoint=messages_endpoint,
            name=name,
            partitions=partitions,
            retention_in_hours=retention_in_hours,
            state=state,
            stream_pool_id=stream_pool_id,
            time_created=time_created,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             freeform_tags: Mapping[str, Any],
             id: str,
             lifecycle_state_details: str,
             messages_endpoint: str,
             name: str,
             partitions: int,
             retention_in_hours: int,
             state: str,
             stream_pool_id: str,
             time_created: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'lifecycleStateDetails' in kwargs:
            lifecycle_state_details = kwargs['lifecycleStateDetails']
        if 'messagesEndpoint' in kwargs:
            messages_endpoint = kwargs['messagesEndpoint']
        if 'retentionInHours' in kwargs:
            retention_in_hours = kwargs['retentionInHours']
        if 'streamPoolId' in kwargs:
            stream_pool_id = kwargs['streamPoolId']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']

        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("lifecycle_state_details", lifecycle_state_details)
        _setter("messages_endpoint", messages_endpoint)
        _setter("name", name)
        _setter("partitions", partitions)
        _setter("retention_in_hours", retention_in_hours)
        _setter("state", state)
        _setter("stream_pool_id", stream_pool_id)
        _setter("time_created", time_created)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment. Is exclusive with the `streamPoolId` parameter. One of them is required.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations": {"CostCenter": "42"}}'
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair that is applied with no predefined name, type, or namespace. Exists for cross-compatibility only. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A filter to return only resources that match the given ID exactly.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> str:
        """
        Any additional details about the current state of the stream.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @property
    @pulumi.getter(name="messagesEndpoint")
    def messages_endpoint(self) -> str:
        """
        The endpoint to use when creating the StreamClient to consume or publish messages in the stream. If the associated stream pool is private, the endpoint is also private and can only be accessed from inside the stream pool's associated subnet.
        """
        return pulumi.get(self, "messages_endpoint")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that match the given name exactly.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def partitions(self) -> int:
        """
        The number of partitions in the stream.
        """
        return pulumi.get(self, "partitions")

    @property
    @pulumi.getter(name="retentionInHours")
    def retention_in_hours(self) -> int:
        """
        The retention period of the stream, in hours. This property is read-only.
        """
        return pulumi.get(self, "retention_in_hours")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="streamPoolId")
    def stream_pool_id(self) -> str:
        """
        The OCID of the stream pool. Is exclusive with the `compartmentId` parameter. One of them is required.
        """
        return pulumi.get(self, "stream_pool_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the stream was created, expressed in in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2018-04-20T00:00:07.405Z`
        """
        return pulumi.get(self, "time_created")


