# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AppFirewallPolicyArgs', 'AppFirewallPolicy']

@pulumi.input_type
class AppFirewallPolicyArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['AppFirewallPolicyActionArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 request_access_control: Optional[pulumi.Input['AppFirewallPolicyRequestAccessControlArgs']] = None,
                 request_protection: Optional[pulumi.Input['AppFirewallPolicyRequestProtectionArgs']] = None,
                 request_rate_limiting: Optional[pulumi.Input['AppFirewallPolicyRequestRateLimitingArgs']] = None,
                 response_access_control: Optional[pulumi.Input['AppFirewallPolicyResponseAccessControlArgs']] = None,
                 response_protection: Optional[pulumi.Input['AppFirewallPolicyResponseProtectionArgs']] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        The set of arguments for constructing a AppFirewallPolicy resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Sequence[pulumi.Input['AppFirewallPolicyActionArgs']]] actions: (Updatable) Predefined actions for use in multiple different rules. Not all actions are supported in every module. Some actions terminate further execution of modules and rules in a module and some do not. Actions names must be unique within this array.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) WebAppFirewallPolicy display name, can be renamed.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input['AppFirewallPolicyRequestAccessControlArgs'] request_access_control: (Updatable) Module that allows inspection of HTTP request properties and to return a defined HTTP response. In this module, rules with the name 'Default Action' are not allowed, since this name is reserved for default action logs.
        :param pulumi.Input['AppFirewallPolicyRequestProtectionArgs'] request_protection: (Updatable) Module that allows to enable OCI-managed protection capabilities for incoming HTTP requests.
        :param pulumi.Input['AppFirewallPolicyRequestRateLimitingArgs'] request_rate_limiting: (Updatable) Module that allows inspection of HTTP connection properties and to limit requests frequency for a given key.
        :param pulumi.Input['AppFirewallPolicyResponseAccessControlArgs'] response_access_control: (Updatable) Module that allows inspection of HTTP response properties and to return a defined HTTP response.
        :param pulumi.Input['AppFirewallPolicyResponseProtectionArgs'] response_protection: (Updatable) Module that allows to enable OCI-managed protection capabilities for HTTP responses.
        :param pulumi.Input[Mapping[str, Any]] system_tags: (Updatable) Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        AppFirewallPolicyArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            actions=actions,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            request_access_control=request_access_control,
            request_protection=request_protection,
            request_rate_limiting=request_rate_limiting,
            response_access_control=response_access_control,
            response_protection=response_protection,
            system_tags=system_tags,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: pulumi.Input[str],
             actions: Optional[pulumi.Input[Sequence[pulumi.Input['AppFirewallPolicyActionArgs']]]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             request_access_control: Optional[pulumi.Input['AppFirewallPolicyRequestAccessControlArgs']] = None,
             request_protection: Optional[pulumi.Input['AppFirewallPolicyRequestProtectionArgs']] = None,
             request_rate_limiting: Optional[pulumi.Input['AppFirewallPolicyRequestRateLimitingArgs']] = None,
             response_access_control: Optional[pulumi.Input['AppFirewallPolicyResponseAccessControlArgs']] = None,
             response_protection: Optional[pulumi.Input['AppFirewallPolicyResponseProtectionArgs']] = None,
             system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'requestAccessControl' in kwargs:
            request_access_control = kwargs['requestAccessControl']
        if 'requestProtection' in kwargs:
            request_protection = kwargs['requestProtection']
        if 'requestRateLimiting' in kwargs:
            request_rate_limiting = kwargs['requestRateLimiting']
        if 'responseAccessControl' in kwargs:
            response_access_control = kwargs['responseAccessControl']
        if 'responseProtection' in kwargs:
            response_protection = kwargs['responseProtection']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']

        _setter("compartment_id", compartment_id)
        if actions is not None:
            _setter("actions", actions)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if display_name is not None:
            _setter("display_name", display_name)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if request_access_control is not None:
            _setter("request_access_control", request_access_control)
        if request_protection is not None:
            _setter("request_protection", request_protection)
        if request_rate_limiting is not None:
            _setter("request_rate_limiting", request_rate_limiting)
        if response_access_control is not None:
            _setter("response_access_control", response_access_control)
        if response_protection is not None:
            _setter("response_protection", response_protection)
        if system_tags is not None:
            _setter("system_tags", system_tags)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppFirewallPolicyActionArgs']]]]:
        """
        (Updatable) Predefined actions for use in multiple different rules. Not all actions are supported in every module. Some actions terminate further execution of modules and rules in a module and some do not. Actions names must be unique within this array.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppFirewallPolicyActionArgs']]]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) WebAppFirewallPolicy display name, can be renamed.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="requestAccessControl")
    def request_access_control(self) -> Optional[pulumi.Input['AppFirewallPolicyRequestAccessControlArgs']]:
        """
        (Updatable) Module that allows inspection of HTTP request properties and to return a defined HTTP response. In this module, rules with the name 'Default Action' are not allowed, since this name is reserved for default action logs.
        """
        return pulumi.get(self, "request_access_control")

    @request_access_control.setter
    def request_access_control(self, value: Optional[pulumi.Input['AppFirewallPolicyRequestAccessControlArgs']]):
        pulumi.set(self, "request_access_control", value)

    @property
    @pulumi.getter(name="requestProtection")
    def request_protection(self) -> Optional[pulumi.Input['AppFirewallPolicyRequestProtectionArgs']]:
        """
        (Updatable) Module that allows to enable OCI-managed protection capabilities for incoming HTTP requests.
        """
        return pulumi.get(self, "request_protection")

    @request_protection.setter
    def request_protection(self, value: Optional[pulumi.Input['AppFirewallPolicyRequestProtectionArgs']]):
        pulumi.set(self, "request_protection", value)

    @property
    @pulumi.getter(name="requestRateLimiting")
    def request_rate_limiting(self) -> Optional[pulumi.Input['AppFirewallPolicyRequestRateLimitingArgs']]:
        """
        (Updatable) Module that allows inspection of HTTP connection properties and to limit requests frequency for a given key.
        """
        return pulumi.get(self, "request_rate_limiting")

    @request_rate_limiting.setter
    def request_rate_limiting(self, value: Optional[pulumi.Input['AppFirewallPolicyRequestRateLimitingArgs']]):
        pulumi.set(self, "request_rate_limiting", value)

    @property
    @pulumi.getter(name="responseAccessControl")
    def response_access_control(self) -> Optional[pulumi.Input['AppFirewallPolicyResponseAccessControlArgs']]:
        """
        (Updatable) Module that allows inspection of HTTP response properties and to return a defined HTTP response.
        """
        return pulumi.get(self, "response_access_control")

    @response_access_control.setter
    def response_access_control(self, value: Optional[pulumi.Input['AppFirewallPolicyResponseAccessControlArgs']]):
        pulumi.set(self, "response_access_control", value)

    @property
    @pulumi.getter(name="responseProtection")
    def response_protection(self) -> Optional[pulumi.Input['AppFirewallPolicyResponseProtectionArgs']]:
        """
        (Updatable) Module that allows to enable OCI-managed protection capabilities for HTTP responses.
        """
        return pulumi.get(self, "response_protection")

    @response_protection.setter
    def response_protection(self, value: Optional[pulumi.Input['AppFirewallPolicyResponseProtectionArgs']]):
        pulumi.set(self, "response_protection", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)


@pulumi.input_type
class _AppFirewallPolicyState:
    def __init__(__self__, *,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['AppFirewallPolicyActionArgs']]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 request_access_control: Optional[pulumi.Input['AppFirewallPolicyRequestAccessControlArgs']] = None,
                 request_protection: Optional[pulumi.Input['AppFirewallPolicyRequestProtectionArgs']] = None,
                 request_rate_limiting: Optional[pulumi.Input['AppFirewallPolicyRequestRateLimitingArgs']] = None,
                 response_access_control: Optional[pulumi.Input['AppFirewallPolicyResponseAccessControlArgs']] = None,
                 response_protection: Optional[pulumi.Input['AppFirewallPolicyResponseProtectionArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AppFirewallPolicy resources.
        :param pulumi.Input[Sequence[pulumi.Input['AppFirewallPolicyActionArgs']]] actions: (Updatable) Predefined actions for use in multiple different rules. Not all actions are supported in every module. Some actions terminate further execution of modules and rules in a module and some do not. Actions names must be unique within this array.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) WebAppFirewallPolicy display name, can be renamed.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in FAILED state.
        :param pulumi.Input['AppFirewallPolicyRequestAccessControlArgs'] request_access_control: (Updatable) Module that allows inspection of HTTP request properties and to return a defined HTTP response. In this module, rules with the name 'Default Action' are not allowed, since this name is reserved for default action logs.
        :param pulumi.Input['AppFirewallPolicyRequestProtectionArgs'] request_protection: (Updatable) Module that allows to enable OCI-managed protection capabilities for incoming HTTP requests.
        :param pulumi.Input['AppFirewallPolicyRequestRateLimitingArgs'] request_rate_limiting: (Updatable) Module that allows inspection of HTTP connection properties and to limit requests frequency for a given key.
        :param pulumi.Input['AppFirewallPolicyResponseAccessControlArgs'] response_access_control: (Updatable) Module that allows inspection of HTTP response properties and to return a defined HTTP response.
        :param pulumi.Input['AppFirewallPolicyResponseProtectionArgs'] response_protection: (Updatable) Module that allows to enable OCI-managed protection capabilities for HTTP responses.
        :param pulumi.Input[str] state: The current state of the WebAppFirewallPolicy.
        :param pulumi.Input[Mapping[str, Any]] system_tags: (Updatable) Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_created: The time the WebAppFirewallPolicy was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time the WebAppFirewallPolicy was updated. An RFC3339 formatted datetime string.
        """
        _AppFirewallPolicyState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            actions=actions,
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            lifecycle_details=lifecycle_details,
            request_access_control=request_access_control,
            request_protection=request_protection,
            request_rate_limiting=request_rate_limiting,
            response_access_control=response_access_control,
            response_protection=response_protection,
            state=state,
            system_tags=system_tags,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             actions: Optional[pulumi.Input[Sequence[pulumi.Input['AppFirewallPolicyActionArgs']]]] = None,
             compartment_id: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             lifecycle_details: Optional[pulumi.Input[str]] = None,
             request_access_control: Optional[pulumi.Input['AppFirewallPolicyRequestAccessControlArgs']] = None,
             request_protection: Optional[pulumi.Input['AppFirewallPolicyRequestProtectionArgs']] = None,
             request_rate_limiting: Optional[pulumi.Input['AppFirewallPolicyRequestRateLimitingArgs']] = None,
             response_access_control: Optional[pulumi.Input['AppFirewallPolicyResponseAccessControlArgs']] = None,
             response_protection: Optional[pulumi.Input['AppFirewallPolicyResponseProtectionArgs']] = None,
             state: Optional[pulumi.Input[str]] = None,
             system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             time_updated: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'requestAccessControl' in kwargs:
            request_access_control = kwargs['requestAccessControl']
        if 'requestProtection' in kwargs:
            request_protection = kwargs['requestProtection']
        if 'requestRateLimiting' in kwargs:
            request_rate_limiting = kwargs['requestRateLimiting']
        if 'responseAccessControl' in kwargs:
            response_access_control = kwargs['responseAccessControl']
        if 'responseProtection' in kwargs:
            response_protection = kwargs['responseProtection']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        if actions is not None:
            _setter("actions", actions)
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if display_name is not None:
            _setter("display_name", display_name)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            _setter("lifecycle_details", lifecycle_details)
        if request_access_control is not None:
            _setter("request_access_control", request_access_control)
        if request_protection is not None:
            _setter("request_protection", request_protection)
        if request_rate_limiting is not None:
            _setter("request_rate_limiting", request_rate_limiting)
        if response_access_control is not None:
            _setter("response_access_control", response_access_control)
        if response_protection is not None:
            _setter("response_protection", response_protection)
        if state is not None:
            _setter("state", state)
        if system_tags is not None:
            _setter("system_tags", system_tags)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_updated is not None:
            _setter("time_updated", time_updated)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppFirewallPolicyActionArgs']]]]:
        """
        (Updatable) Predefined actions for use in multiple different rules. Not all actions are supported in every module. Some actions terminate further execution of modules and rules in a module and some do not. Actions names must be unique within this array.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppFirewallPolicyActionArgs']]]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) WebAppFirewallPolicy display name, can be renamed.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in FAILED state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="requestAccessControl")
    def request_access_control(self) -> Optional[pulumi.Input['AppFirewallPolicyRequestAccessControlArgs']]:
        """
        (Updatable) Module that allows inspection of HTTP request properties and to return a defined HTTP response. In this module, rules with the name 'Default Action' are not allowed, since this name is reserved for default action logs.
        """
        return pulumi.get(self, "request_access_control")

    @request_access_control.setter
    def request_access_control(self, value: Optional[pulumi.Input['AppFirewallPolicyRequestAccessControlArgs']]):
        pulumi.set(self, "request_access_control", value)

    @property
    @pulumi.getter(name="requestProtection")
    def request_protection(self) -> Optional[pulumi.Input['AppFirewallPolicyRequestProtectionArgs']]:
        """
        (Updatable) Module that allows to enable OCI-managed protection capabilities for incoming HTTP requests.
        """
        return pulumi.get(self, "request_protection")

    @request_protection.setter
    def request_protection(self, value: Optional[pulumi.Input['AppFirewallPolicyRequestProtectionArgs']]):
        pulumi.set(self, "request_protection", value)

    @property
    @pulumi.getter(name="requestRateLimiting")
    def request_rate_limiting(self) -> Optional[pulumi.Input['AppFirewallPolicyRequestRateLimitingArgs']]:
        """
        (Updatable) Module that allows inspection of HTTP connection properties and to limit requests frequency for a given key.
        """
        return pulumi.get(self, "request_rate_limiting")

    @request_rate_limiting.setter
    def request_rate_limiting(self, value: Optional[pulumi.Input['AppFirewallPolicyRequestRateLimitingArgs']]):
        pulumi.set(self, "request_rate_limiting", value)

    @property
    @pulumi.getter(name="responseAccessControl")
    def response_access_control(self) -> Optional[pulumi.Input['AppFirewallPolicyResponseAccessControlArgs']]:
        """
        (Updatable) Module that allows inspection of HTTP response properties and to return a defined HTTP response.
        """
        return pulumi.get(self, "response_access_control")

    @response_access_control.setter
    def response_access_control(self, value: Optional[pulumi.Input['AppFirewallPolicyResponseAccessControlArgs']]):
        pulumi.set(self, "response_access_control", value)

    @property
    @pulumi.getter(name="responseProtection")
    def response_protection(self) -> Optional[pulumi.Input['AppFirewallPolicyResponseProtectionArgs']]:
        """
        (Updatable) Module that allows to enable OCI-managed protection capabilities for HTTP responses.
        """
        return pulumi.get(self, "response_protection")

    @response_protection.setter
    def response_protection(self, value: Optional[pulumi.Input['AppFirewallPolicyResponseProtectionArgs']]):
        pulumi.set(self, "response_protection", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the WebAppFirewallPolicy.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the WebAppFirewallPolicy was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time the WebAppFirewallPolicy was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class AppFirewallPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AppFirewallPolicyActionArgs']]]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 request_access_control: Optional[pulumi.Input[pulumi.InputType['AppFirewallPolicyRequestAccessControlArgs']]] = None,
                 request_protection: Optional[pulumi.Input[pulumi.InputType['AppFirewallPolicyRequestProtectionArgs']]] = None,
                 request_rate_limiting: Optional[pulumi.Input[pulumi.InputType['AppFirewallPolicyRequestRateLimitingArgs']]] = None,
                 response_access_control: Optional[pulumi.Input[pulumi.InputType['AppFirewallPolicyResponseAccessControlArgs']]] = None,
                 response_protection: Optional[pulumi.Input[pulumi.InputType['AppFirewallPolicyResponseProtectionArgs']]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 __props__=None):
        """
        This resource provides the Web App Firewall Policy resource in Oracle Cloud Infrastructure Waf service.

        Creates a new WebAppFirewallPolicy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_web_app_firewall_policy = oci.waf.AppFirewallPolicy("testWebAppFirewallPolicy",
            compartment_id=var["compartment_id"],
            actions=[oci.waf.AppFirewallPolicyActionArgs(
                name=var["web_app_firewall_policy_actions_name"],
                type=var["web_app_firewall_policy_actions_type"],
                body=oci.waf.AppFirewallPolicyActionBodyArgs(
                    text=var["web_app_firewall_policy_actions_body_text"],
                    type=var["web_app_firewall_policy_actions_body_type"],
                ),
                code=var["web_app_firewall_policy_actions_code"],
                headers=[oci.waf.AppFirewallPolicyActionHeaderArgs(
                    name=var["web_app_firewall_policy_actions_headers_name"],
                    value=var["web_app_firewall_policy_actions_headers_value"],
                )],
            )],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=var["web_app_firewall_policy_display_name"],
            freeform_tags={
                "bar-key": "value",
            },
            request_access_control=oci.waf.AppFirewallPolicyRequestAccessControlArgs(
                default_action_name=var["web_app_firewall_policy_request_access_control_default_action_name"],
                rules=[oci.waf.AppFirewallPolicyRequestAccessControlRuleArgs(
                    action_name=var["web_app_firewall_policy_request_access_control_rules_action_name"],
                    name=var["web_app_firewall_policy_request_access_control_rules_name"],
                    type=var["web_app_firewall_policy_request_access_control_rules_type"],
                    condition=var["web_app_firewall_policy_request_access_control_rules_condition"],
                    condition_language=var["web_app_firewall_policy_request_access_control_rules_condition_language"],
                )],
            ),
            request_protection=oci.waf.AppFirewallPolicyRequestProtectionArgs(
                body_inspection_size_limit_exceeded_action_name=var["web_app_firewall_policy_request_protection_body_inspection_size_limit_exceeded_action_name"],
                body_inspection_size_limit_in_bytes=var["web_app_firewall_policy_request_protection_body_inspection_size_limit_in_bytes"],
                rules=[oci.waf.AppFirewallPolicyRequestProtectionRuleArgs(
                    action_name=var["web_app_firewall_policy_request_protection_rules_action_name"],
                    name=var["web_app_firewall_policy_request_protection_rules_name"],
                    protection_capabilities=[oci.waf.AppFirewallPolicyRequestProtectionRuleProtectionCapabilityArgs(
                        key=var["web_app_firewall_policy_request_protection_rules_protection_capabilities_key"],
                        version=var["web_app_firewall_policy_request_protection_rules_protection_capabilities_version"],
                        action_name=var["web_app_firewall_policy_request_protection_rules_protection_capabilities_action_name"],
                        collaborative_action_threshold=var["web_app_firewall_policy_request_protection_rules_protection_capabilities_collaborative_action_threshold"],
                        collaborative_weights=[oci.waf.AppFirewallPolicyRequestProtectionRuleProtectionCapabilityCollaborativeWeightArgs(
                            key=var["web_app_firewall_policy_request_protection_rules_protection_capabilities_collaborative_weights_key"],
                            weight=var["web_app_firewall_policy_request_protection_rules_protection_capabilities_collaborative_weights_weight"],
                        )],
                        exclusions=oci.waf.AppFirewallPolicyRequestProtectionRuleProtectionCapabilityExclusionsArgs(
                            args=var["web_app_firewall_policy_request_protection_rules_protection_capabilities_exclusions_args"],
                            request_cookies=var["web_app_firewall_policy_request_protection_rules_protection_capabilities_exclusions_request_cookies"],
                        ),
                    )],
                    type=var["web_app_firewall_policy_request_protection_rules_type"],
                    condition=var["web_app_firewall_policy_request_protection_rules_condition"],
                    condition_language=var["web_app_firewall_policy_request_protection_rules_condition_language"],
                    is_body_inspection_enabled=var["web_app_firewall_policy_request_protection_rules_is_body_inspection_enabled"],
                    protection_capability_settings=oci.waf.AppFirewallPolicyRequestProtectionRuleProtectionCapabilitySettingsArgs(
                        allowed_http_methods=var["web_app_firewall_policy_request_protection_rules_protection_capability_settings_allowed_http_methods"],
                        max_http_request_header_length=var["web_app_firewall_policy_request_protection_rules_protection_capability_settings_max_http_request_header_length"],
                        max_http_request_headers=var["web_app_firewall_policy_request_protection_rules_protection_capability_settings_max_http_request_headers"],
                        max_number_of_arguments=var["web_app_firewall_policy_request_protection_rules_protection_capability_settings_max_number_of_arguments"],
                        max_single_argument_length=var["web_app_firewall_policy_request_protection_rules_protection_capability_settings_max_single_argument_length"],
                        max_total_argument_length=var["web_app_firewall_policy_request_protection_rules_protection_capability_settings_max_total_argument_length"],
                    ),
                )],
            ),
            request_rate_limiting=oci.waf.AppFirewallPolicyRequestRateLimitingArgs(
                rules=[oci.waf.AppFirewallPolicyRequestRateLimitingRuleArgs(
                    action_name=var["web_app_firewall_policy_request_rate_limiting_rules_action_name"],
                    configurations=[oci.waf.AppFirewallPolicyRequestRateLimitingRuleConfigurationArgs(
                        period_in_seconds=var["web_app_firewall_policy_request_rate_limiting_rules_configurations_period_in_seconds"],
                        requests_limit=var["web_app_firewall_policy_request_rate_limiting_rules_configurations_requests_limit"],
                        action_duration_in_seconds=var["web_app_firewall_policy_request_rate_limiting_rules_configurations_action_duration_in_seconds"],
                    )],
                    name=var["web_app_firewall_policy_request_rate_limiting_rules_name"],
                    type=var["web_app_firewall_policy_request_rate_limiting_rules_type"],
                    condition=var["web_app_firewall_policy_request_rate_limiting_rules_condition"],
                    condition_language=var["web_app_firewall_policy_request_rate_limiting_rules_condition_language"],
                )],
            ),
            response_access_control=oci.waf.AppFirewallPolicyResponseAccessControlArgs(
                rules=[oci.waf.AppFirewallPolicyResponseAccessControlRuleArgs(
                    action_name=var["web_app_firewall_policy_response_access_control_rules_action_name"],
                    name=var["web_app_firewall_policy_response_access_control_rules_name"],
                    type=var["web_app_firewall_policy_response_access_control_rules_type"],
                    condition=var["web_app_firewall_policy_response_access_control_rules_condition"],
                    condition_language=var["web_app_firewall_policy_response_access_control_rules_condition_language"],
                )],
            ),
            response_protection=oci.waf.AppFirewallPolicyResponseProtectionArgs(
                rules=[oci.waf.AppFirewallPolicyResponseProtectionRuleArgs(
                    action_name=var["web_app_firewall_policy_response_protection_rules_action_name"],
                    name=var["web_app_firewall_policy_response_protection_rules_name"],
                    protection_capabilities=[oci.waf.AppFirewallPolicyResponseProtectionRuleProtectionCapabilityArgs(
                        key=var["web_app_firewall_policy_response_protection_rules_protection_capabilities_key"],
                        version=var["web_app_firewall_policy_response_protection_rules_protection_capabilities_version"],
                        action_name=var["web_app_firewall_policy_response_protection_rules_protection_capabilities_action_name"],
                        collaborative_action_threshold=var["web_app_firewall_policy_response_protection_rules_protection_capabilities_collaborative_action_threshold"],
                        collaborative_weights=[oci.waf.AppFirewallPolicyResponseProtectionRuleProtectionCapabilityCollaborativeWeightArgs(
                            key=var["web_app_firewall_policy_response_protection_rules_protection_capabilities_collaborative_weights_key"],
                            weight=var["web_app_firewall_policy_response_protection_rules_protection_capabilities_collaborative_weights_weight"],
                        )],
                        exclusions=oci.waf.AppFirewallPolicyResponseProtectionRuleProtectionCapabilityExclusionsArgs(
                            args=var["web_app_firewall_policy_response_protection_rules_protection_capabilities_exclusions_args"],
                            request_cookies=var["web_app_firewall_policy_response_protection_rules_protection_capabilities_exclusions_request_cookies"],
                        ),
                    )],
                    type=var["web_app_firewall_policy_response_protection_rules_type"],
                    condition=var["web_app_firewall_policy_response_protection_rules_condition"],
                    condition_language=var["web_app_firewall_policy_response_protection_rules_condition_language"],
                    is_body_inspection_enabled=var["web_app_firewall_policy_response_protection_rules_is_body_inspection_enabled"],
                    protection_capability_settings=oci.waf.AppFirewallPolicyResponseProtectionRuleProtectionCapabilitySettingsArgs(
                        allowed_http_methods=var["web_app_firewall_policy_response_protection_rules_protection_capability_settings_allowed_http_methods"],
                        max_http_request_header_length=var["web_app_firewall_policy_response_protection_rules_protection_capability_settings_max_http_request_header_length"],
                        max_http_request_headers=var["web_app_firewall_policy_response_protection_rules_protection_capability_settings_max_http_request_headers"],
                        max_number_of_arguments=var["web_app_firewall_policy_response_protection_rules_protection_capability_settings_max_number_of_arguments"],
                        max_single_argument_length=var["web_app_firewall_policy_response_protection_rules_protection_capability_settings_max_single_argument_length"],
                        max_total_argument_length=var["web_app_firewall_policy_response_protection_rules_protection_capability_settings_max_total_argument_length"],
                    ),
                )],
            ),
            system_tags=var["web_app_firewall_policy_system_tags"])
        ```

        ## Import

        WebAppFirewallPolicies can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Waf/appFirewallPolicy:AppFirewallPolicy test_web_app_firewall_policy "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AppFirewallPolicyActionArgs']]]] actions: (Updatable) Predefined actions for use in multiple different rules. Not all actions are supported in every module. Some actions terminate further execution of modules and rules in a module and some do not. Actions names must be unique within this array.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) WebAppFirewallPolicy display name, can be renamed.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[pulumi.InputType['AppFirewallPolicyRequestAccessControlArgs']] request_access_control: (Updatable) Module that allows inspection of HTTP request properties and to return a defined HTTP response. In this module, rules with the name 'Default Action' are not allowed, since this name is reserved for default action logs.
        :param pulumi.Input[pulumi.InputType['AppFirewallPolicyRequestProtectionArgs']] request_protection: (Updatable) Module that allows to enable OCI-managed protection capabilities for incoming HTTP requests.
        :param pulumi.Input[pulumi.InputType['AppFirewallPolicyRequestRateLimitingArgs']] request_rate_limiting: (Updatable) Module that allows inspection of HTTP connection properties and to limit requests frequency for a given key.
        :param pulumi.Input[pulumi.InputType['AppFirewallPolicyResponseAccessControlArgs']] response_access_control: (Updatable) Module that allows inspection of HTTP response properties and to return a defined HTTP response.
        :param pulumi.Input[pulumi.InputType['AppFirewallPolicyResponseProtectionArgs']] response_protection: (Updatable) Module that allows to enable OCI-managed protection capabilities for HTTP responses.
        :param pulumi.Input[Mapping[str, Any]] system_tags: (Updatable) Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppFirewallPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Web App Firewall Policy resource in Oracle Cloud Infrastructure Waf service.

        Creates a new WebAppFirewallPolicy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_web_app_firewall_policy = oci.waf.AppFirewallPolicy("testWebAppFirewallPolicy",
            compartment_id=var["compartment_id"],
            actions=[oci.waf.AppFirewallPolicyActionArgs(
                name=var["web_app_firewall_policy_actions_name"],
                type=var["web_app_firewall_policy_actions_type"],
                body=oci.waf.AppFirewallPolicyActionBodyArgs(
                    text=var["web_app_firewall_policy_actions_body_text"],
                    type=var["web_app_firewall_policy_actions_body_type"],
                ),
                code=var["web_app_firewall_policy_actions_code"],
                headers=[oci.waf.AppFirewallPolicyActionHeaderArgs(
                    name=var["web_app_firewall_policy_actions_headers_name"],
                    value=var["web_app_firewall_policy_actions_headers_value"],
                )],
            )],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=var["web_app_firewall_policy_display_name"],
            freeform_tags={
                "bar-key": "value",
            },
            request_access_control=oci.waf.AppFirewallPolicyRequestAccessControlArgs(
                default_action_name=var["web_app_firewall_policy_request_access_control_default_action_name"],
                rules=[oci.waf.AppFirewallPolicyRequestAccessControlRuleArgs(
                    action_name=var["web_app_firewall_policy_request_access_control_rules_action_name"],
                    name=var["web_app_firewall_policy_request_access_control_rules_name"],
                    type=var["web_app_firewall_policy_request_access_control_rules_type"],
                    condition=var["web_app_firewall_policy_request_access_control_rules_condition"],
                    condition_language=var["web_app_firewall_policy_request_access_control_rules_condition_language"],
                )],
            ),
            request_protection=oci.waf.AppFirewallPolicyRequestProtectionArgs(
                body_inspection_size_limit_exceeded_action_name=var["web_app_firewall_policy_request_protection_body_inspection_size_limit_exceeded_action_name"],
                body_inspection_size_limit_in_bytes=var["web_app_firewall_policy_request_protection_body_inspection_size_limit_in_bytes"],
                rules=[oci.waf.AppFirewallPolicyRequestProtectionRuleArgs(
                    action_name=var["web_app_firewall_policy_request_protection_rules_action_name"],
                    name=var["web_app_firewall_policy_request_protection_rules_name"],
                    protection_capabilities=[oci.waf.AppFirewallPolicyRequestProtectionRuleProtectionCapabilityArgs(
                        key=var["web_app_firewall_policy_request_protection_rules_protection_capabilities_key"],
                        version=var["web_app_firewall_policy_request_protection_rules_protection_capabilities_version"],
                        action_name=var["web_app_firewall_policy_request_protection_rules_protection_capabilities_action_name"],
                        collaborative_action_threshold=var["web_app_firewall_policy_request_protection_rules_protection_capabilities_collaborative_action_threshold"],
                        collaborative_weights=[oci.waf.AppFirewallPolicyRequestProtectionRuleProtectionCapabilityCollaborativeWeightArgs(
                            key=var["web_app_firewall_policy_request_protection_rules_protection_capabilities_collaborative_weights_key"],
                            weight=var["web_app_firewall_policy_request_protection_rules_protection_capabilities_collaborative_weights_weight"],
                        )],
                        exclusions=oci.waf.AppFirewallPolicyRequestProtectionRuleProtectionCapabilityExclusionsArgs(
                            args=var["web_app_firewall_policy_request_protection_rules_protection_capabilities_exclusions_args"],
                            request_cookies=var["web_app_firewall_policy_request_protection_rules_protection_capabilities_exclusions_request_cookies"],
                        ),
                    )],
                    type=var["web_app_firewall_policy_request_protection_rules_type"],
                    condition=var["web_app_firewall_policy_request_protection_rules_condition"],
                    condition_language=var["web_app_firewall_policy_request_protection_rules_condition_language"],
                    is_body_inspection_enabled=var["web_app_firewall_policy_request_protection_rules_is_body_inspection_enabled"],
                    protection_capability_settings=oci.waf.AppFirewallPolicyRequestProtectionRuleProtectionCapabilitySettingsArgs(
                        allowed_http_methods=var["web_app_firewall_policy_request_protection_rules_protection_capability_settings_allowed_http_methods"],
                        max_http_request_header_length=var["web_app_firewall_policy_request_protection_rules_protection_capability_settings_max_http_request_header_length"],
                        max_http_request_headers=var["web_app_firewall_policy_request_protection_rules_protection_capability_settings_max_http_request_headers"],
                        max_number_of_arguments=var["web_app_firewall_policy_request_protection_rules_protection_capability_settings_max_number_of_arguments"],
                        max_single_argument_length=var["web_app_firewall_policy_request_protection_rules_protection_capability_settings_max_single_argument_length"],
                        max_total_argument_length=var["web_app_firewall_policy_request_protection_rules_protection_capability_settings_max_total_argument_length"],
                    ),
                )],
            ),
            request_rate_limiting=oci.waf.AppFirewallPolicyRequestRateLimitingArgs(
                rules=[oci.waf.AppFirewallPolicyRequestRateLimitingRuleArgs(
                    action_name=var["web_app_firewall_policy_request_rate_limiting_rules_action_name"],
                    configurations=[oci.waf.AppFirewallPolicyRequestRateLimitingRuleConfigurationArgs(
                        period_in_seconds=var["web_app_firewall_policy_request_rate_limiting_rules_configurations_period_in_seconds"],
                        requests_limit=var["web_app_firewall_policy_request_rate_limiting_rules_configurations_requests_limit"],
                        action_duration_in_seconds=var["web_app_firewall_policy_request_rate_limiting_rules_configurations_action_duration_in_seconds"],
                    )],
                    name=var["web_app_firewall_policy_request_rate_limiting_rules_name"],
                    type=var["web_app_firewall_policy_request_rate_limiting_rules_type"],
                    condition=var["web_app_firewall_policy_request_rate_limiting_rules_condition"],
                    condition_language=var["web_app_firewall_policy_request_rate_limiting_rules_condition_language"],
                )],
            ),
            response_access_control=oci.waf.AppFirewallPolicyResponseAccessControlArgs(
                rules=[oci.waf.AppFirewallPolicyResponseAccessControlRuleArgs(
                    action_name=var["web_app_firewall_policy_response_access_control_rules_action_name"],
                    name=var["web_app_firewall_policy_response_access_control_rules_name"],
                    type=var["web_app_firewall_policy_response_access_control_rules_type"],
                    condition=var["web_app_firewall_policy_response_access_control_rules_condition"],
                    condition_language=var["web_app_firewall_policy_response_access_control_rules_condition_language"],
                )],
            ),
            response_protection=oci.waf.AppFirewallPolicyResponseProtectionArgs(
                rules=[oci.waf.AppFirewallPolicyResponseProtectionRuleArgs(
                    action_name=var["web_app_firewall_policy_response_protection_rules_action_name"],
                    name=var["web_app_firewall_policy_response_protection_rules_name"],
                    protection_capabilities=[oci.waf.AppFirewallPolicyResponseProtectionRuleProtectionCapabilityArgs(
                        key=var["web_app_firewall_policy_response_protection_rules_protection_capabilities_key"],
                        version=var["web_app_firewall_policy_response_protection_rules_protection_capabilities_version"],
                        action_name=var["web_app_firewall_policy_response_protection_rules_protection_capabilities_action_name"],
                        collaborative_action_threshold=var["web_app_firewall_policy_response_protection_rules_protection_capabilities_collaborative_action_threshold"],
                        collaborative_weights=[oci.waf.AppFirewallPolicyResponseProtectionRuleProtectionCapabilityCollaborativeWeightArgs(
                            key=var["web_app_firewall_policy_response_protection_rules_protection_capabilities_collaborative_weights_key"],
                            weight=var["web_app_firewall_policy_response_protection_rules_protection_capabilities_collaborative_weights_weight"],
                        )],
                        exclusions=oci.waf.AppFirewallPolicyResponseProtectionRuleProtectionCapabilityExclusionsArgs(
                            args=var["web_app_firewall_policy_response_protection_rules_protection_capabilities_exclusions_args"],
                            request_cookies=var["web_app_firewall_policy_response_protection_rules_protection_capabilities_exclusions_request_cookies"],
                        ),
                    )],
                    type=var["web_app_firewall_policy_response_protection_rules_type"],
                    condition=var["web_app_firewall_policy_response_protection_rules_condition"],
                    condition_language=var["web_app_firewall_policy_response_protection_rules_condition_language"],
                    is_body_inspection_enabled=var["web_app_firewall_policy_response_protection_rules_is_body_inspection_enabled"],
                    protection_capability_settings=oci.waf.AppFirewallPolicyResponseProtectionRuleProtectionCapabilitySettingsArgs(
                        allowed_http_methods=var["web_app_firewall_policy_response_protection_rules_protection_capability_settings_allowed_http_methods"],
                        max_http_request_header_length=var["web_app_firewall_policy_response_protection_rules_protection_capability_settings_max_http_request_header_length"],
                        max_http_request_headers=var["web_app_firewall_policy_response_protection_rules_protection_capability_settings_max_http_request_headers"],
                        max_number_of_arguments=var["web_app_firewall_policy_response_protection_rules_protection_capability_settings_max_number_of_arguments"],
                        max_single_argument_length=var["web_app_firewall_policy_response_protection_rules_protection_capability_settings_max_single_argument_length"],
                        max_total_argument_length=var["web_app_firewall_policy_response_protection_rules_protection_capability_settings_max_total_argument_length"],
                    ),
                )],
            ),
            system_tags=var["web_app_firewall_policy_system_tags"])
        ```

        ## Import

        WebAppFirewallPolicies can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Waf/appFirewallPolicy:AppFirewallPolicy test_web_app_firewall_policy "id"
        ```

        :param str resource_name: The name of the resource.
        :param AppFirewallPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppFirewallPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            AppFirewallPolicyArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AppFirewallPolicyActionArgs']]]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 request_access_control: Optional[pulumi.Input[pulumi.InputType['AppFirewallPolicyRequestAccessControlArgs']]] = None,
                 request_protection: Optional[pulumi.Input[pulumi.InputType['AppFirewallPolicyRequestProtectionArgs']]] = None,
                 request_rate_limiting: Optional[pulumi.Input[pulumi.InputType['AppFirewallPolicyRequestRateLimitingArgs']]] = None,
                 response_access_control: Optional[pulumi.Input[pulumi.InputType['AppFirewallPolicyResponseAccessControlArgs']]] = None,
                 response_protection: Optional[pulumi.Input[pulumi.InputType['AppFirewallPolicyResponseProtectionArgs']]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppFirewallPolicyArgs.__new__(AppFirewallPolicyArgs)

            __props__.__dict__["actions"] = actions
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if request_access_control is not None and not isinstance(request_access_control, AppFirewallPolicyRequestAccessControlArgs):
                request_access_control = request_access_control or {}
                def _setter(key, value):
                    request_access_control[key] = value
                AppFirewallPolicyRequestAccessControlArgs._configure(_setter, **request_access_control)
            __props__.__dict__["request_access_control"] = request_access_control
            if request_protection is not None and not isinstance(request_protection, AppFirewallPolicyRequestProtectionArgs):
                request_protection = request_protection or {}
                def _setter(key, value):
                    request_protection[key] = value
                AppFirewallPolicyRequestProtectionArgs._configure(_setter, **request_protection)
            __props__.__dict__["request_protection"] = request_protection
            if request_rate_limiting is not None and not isinstance(request_rate_limiting, AppFirewallPolicyRequestRateLimitingArgs):
                request_rate_limiting = request_rate_limiting or {}
                def _setter(key, value):
                    request_rate_limiting[key] = value
                AppFirewallPolicyRequestRateLimitingArgs._configure(_setter, **request_rate_limiting)
            __props__.__dict__["request_rate_limiting"] = request_rate_limiting
            if response_access_control is not None and not isinstance(response_access_control, AppFirewallPolicyResponseAccessControlArgs):
                response_access_control = response_access_control or {}
                def _setter(key, value):
                    response_access_control[key] = value
                AppFirewallPolicyResponseAccessControlArgs._configure(_setter, **response_access_control)
            __props__.__dict__["response_access_control"] = response_access_control
            if response_protection is not None and not isinstance(response_protection, AppFirewallPolicyResponseProtectionArgs):
                response_protection = response_protection or {}
                def _setter(key, value):
                    response_protection[key] = value
                AppFirewallPolicyResponseProtectionArgs._configure(_setter, **response_protection)
            __props__.__dict__["response_protection"] = response_protection
            __props__.__dict__["system_tags"] = system_tags
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(AppFirewallPolicy, __self__).__init__(
            'oci:Waf/appFirewallPolicy:AppFirewallPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            actions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AppFirewallPolicyActionArgs']]]]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            request_access_control: Optional[pulumi.Input[pulumi.InputType['AppFirewallPolicyRequestAccessControlArgs']]] = None,
            request_protection: Optional[pulumi.Input[pulumi.InputType['AppFirewallPolicyRequestProtectionArgs']]] = None,
            request_rate_limiting: Optional[pulumi.Input[pulumi.InputType['AppFirewallPolicyRequestRateLimitingArgs']]] = None,
            response_access_control: Optional[pulumi.Input[pulumi.InputType['AppFirewallPolicyResponseAccessControlArgs']]] = None,
            response_protection: Optional[pulumi.Input[pulumi.InputType['AppFirewallPolicyResponseProtectionArgs']]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'AppFirewallPolicy':
        """
        Get an existing AppFirewallPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AppFirewallPolicyActionArgs']]]] actions: (Updatable) Predefined actions for use in multiple different rules. Not all actions are supported in every module. Some actions terminate further execution of modules and rules in a module and some do not. Actions names must be unique within this array.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) WebAppFirewallPolicy display name, can be renamed.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in FAILED state.
        :param pulumi.Input[pulumi.InputType['AppFirewallPolicyRequestAccessControlArgs']] request_access_control: (Updatable) Module that allows inspection of HTTP request properties and to return a defined HTTP response. In this module, rules with the name 'Default Action' are not allowed, since this name is reserved for default action logs.
        :param pulumi.Input[pulumi.InputType['AppFirewallPolicyRequestProtectionArgs']] request_protection: (Updatable) Module that allows to enable OCI-managed protection capabilities for incoming HTTP requests.
        :param pulumi.Input[pulumi.InputType['AppFirewallPolicyRequestRateLimitingArgs']] request_rate_limiting: (Updatable) Module that allows inspection of HTTP connection properties and to limit requests frequency for a given key.
        :param pulumi.Input[pulumi.InputType['AppFirewallPolicyResponseAccessControlArgs']] response_access_control: (Updatable) Module that allows inspection of HTTP response properties and to return a defined HTTP response.
        :param pulumi.Input[pulumi.InputType['AppFirewallPolicyResponseProtectionArgs']] response_protection: (Updatable) Module that allows to enable OCI-managed protection capabilities for HTTP responses.
        :param pulumi.Input[str] state: The current state of the WebAppFirewallPolicy.
        :param pulumi.Input[Mapping[str, Any]] system_tags: (Updatable) Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_created: The time the WebAppFirewallPolicy was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time the WebAppFirewallPolicy was updated. An RFC3339 formatted datetime string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppFirewallPolicyState.__new__(_AppFirewallPolicyState)

        __props__.__dict__["actions"] = actions
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["request_access_control"] = request_access_control
        __props__.__dict__["request_protection"] = request_protection
        __props__.__dict__["request_rate_limiting"] = request_rate_limiting
        __props__.__dict__["response_access_control"] = response_access_control
        __props__.__dict__["response_protection"] = response_protection
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return AppFirewallPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def actions(self) -> pulumi.Output[Sequence['outputs.AppFirewallPolicyAction']]:
        """
        (Updatable) Predefined actions for use in multiple different rules. Not all actions are supported in every module. Some actions terminate further execution of modules and rules in a module and some do not. Actions names must be unique within this array.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) WebAppFirewallPolicy display name, can be renamed.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in FAILED state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="requestAccessControl")
    def request_access_control(self) -> pulumi.Output['outputs.AppFirewallPolicyRequestAccessControl']:
        """
        (Updatable) Module that allows inspection of HTTP request properties and to return a defined HTTP response. In this module, rules with the name 'Default Action' are not allowed, since this name is reserved for default action logs.
        """
        return pulumi.get(self, "request_access_control")

    @property
    @pulumi.getter(name="requestProtection")
    def request_protection(self) -> pulumi.Output['outputs.AppFirewallPolicyRequestProtection']:
        """
        (Updatable) Module that allows to enable OCI-managed protection capabilities for incoming HTTP requests.
        """
        return pulumi.get(self, "request_protection")

    @property
    @pulumi.getter(name="requestRateLimiting")
    def request_rate_limiting(self) -> pulumi.Output['outputs.AppFirewallPolicyRequestRateLimiting']:
        """
        (Updatable) Module that allows inspection of HTTP connection properties and to limit requests frequency for a given key.
        """
        return pulumi.get(self, "request_rate_limiting")

    @property
    @pulumi.getter(name="responseAccessControl")
    def response_access_control(self) -> pulumi.Output['outputs.AppFirewallPolicyResponseAccessControl']:
        """
        (Updatable) Module that allows inspection of HTTP response properties and to return a defined HTTP response.
        """
        return pulumi.get(self, "response_access_control")

    @property
    @pulumi.getter(name="responseProtection")
    def response_protection(self) -> pulumi.Output['outputs.AppFirewallPolicyResponseProtection']:
        """
        (Updatable) Module that allows to enable OCI-managed protection capabilities for HTTP responses.
        """
        return pulumi.get(self, "response_protection")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the WebAppFirewallPolicy.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the WebAppFirewallPolicy was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time the WebAppFirewallPolicy was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

