# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetTlsActivationIdsResult',
    'AwaitableGetTlsActivationIdsResult',
    'get_tls_activation_ids',
    'get_tls_activation_ids_output',
]

@pulumi.output_type
class GetTlsActivationIdsResult:
    """
    A collection of values returned by getTlsActivationIds.
    """
    def __init__(__self__, certificate_id=None, id=None, ids=None):
        if certificate_id and not isinstance(certificate_id, str):
            raise TypeError("Expected argument 'certificate_id' to be a str")
        pulumi.set(__self__, "certificate_id", certificate_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[str]:
        """
        ID of TLS certificate used to filter activations
        """
        return pulumi.get(self, "certificate_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        """
        List of IDs of the TLS Activations.
        """
        return pulumi.get(self, "ids")


class AwaitableGetTlsActivationIdsResult(GetTlsActivationIdsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTlsActivationIdsResult(
            certificate_id=self.certificate_id,
            id=self.id,
            ids=self.ids)


def get_tls_activation_ids(certificate_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTlsActivationIdsResult:
    """
    Use this data source to get the list of TLS Activation identifiers in Fastly.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_fastly as fastly

    example_tls_activation_ids = fastly.get_tls_activation_ids(certificate_id=fastly_tls_certificate["example"]["id"])
    example_tls_activation = [fastly.get_tls_activation(id=__value) for __key, __value in example_tls_activation_ids.ids]
    pulumi.export("activationDomains", [a.domain for a in example_tls_activation])
    ```


    :param str certificate_id: ID of TLS certificate used to filter activations
    """
    __args__ = dict()
    __args__['certificateId'] = certificate_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('fastly:index/getTlsActivationIds:getTlsActivationIds', __args__, opts=opts, typ=GetTlsActivationIdsResult).value

    return AwaitableGetTlsActivationIdsResult(
        certificate_id=pulumi.get(__ret__, 'certificate_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'))


@_utilities.lift_output_func(get_tls_activation_ids)
def get_tls_activation_ids_output(certificate_id: Optional[pulumi.Input[Optional[str]]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTlsActivationIdsResult]:
    """
    Use this data source to get the list of TLS Activation identifiers in Fastly.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_fastly as fastly

    example_tls_activation_ids = fastly.get_tls_activation_ids(certificate_id=fastly_tls_certificate["example"]["id"])
    example_tls_activation = [fastly.get_tls_activation(id=__value) for __key, __value in example_tls_activation_ids.ids]
    pulumi.export("activationDomains", [a.domain for a in example_tls_activation])
    ```


    :param str certificate_id: ID of TLS certificate used to filter activations
    """
    ...
