import logging
from pkg_resources import parse_version

import importlib_metadata

__version__ = importlib_metadata.version("dakarafeeder")
__date__ = "2019-12-05"

logger = logging.getLogger(__name__)


def check_version():
    """Display version number and check if on release
    """
    # log player versio
    logger.info("Dakara feeder %s (%s)", __version__, __date__)

    # check version is a release
    version = parse_version(__version__)
    if version.is_prerelease:
        logger.warning("You are running a dev version, use it at your own risks!")
