"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WithConfiguration = exports.LogLevel = void 0;
const path = require("path");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
var LogLevel;
(function (LogLevel) {
    LogLevel["NONE"] = "none";
    LogLevel["INFO"] = "info";
    LogLevel["WARN"] = "warn";
    LogLevel["ERROR"] = "error";
    LogLevel["DEBUG"] = "debug";
})(LogLevel = exports.LogLevel || (exports.LogLevel = {}));
class WithConfiguration extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const resourceType = 'Custom::WithConfiguration';
        const handler = new aws_lambda_1.SingletonFunction(this, 'Handler', {
            uuid: 'cloudcomponents-cdk-lambda-at-edge-pattern-with-configuration',
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'with-configuration')),
            handler: 'index.handler',
            lambdaPurpose: resourceType,
            timeout: core_1.Duration.minutes(5),
        });
        handler.addToRolePolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['lambda:GetFunction', 'lambda:UpdateFunctionCode'],
            resources: [props.function.functionArn],
        }));
        const cr = new core_1.CustomResource(this, 'WithConfiguration', {
            serviceToken: handler.functionArn,
            resourceType,
            properties: {
                Region: 'us-east-1',
                FunctionName: props.function.functionName,
                Configuration: JSON.stringify(props.configuration, null, 2),
            },
        });
        this.functionVersion = aws_lambda_1.Version.fromVersionArn(this, 'Version', cr.getAttString('FunctionArn'));
    }
}
exports.WithConfiguration = WithConfiguration;
//# sourceMappingURL=data:application/json;base64,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