"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MockSleep = exports.SleepImpl = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const synchronous_promise_1 = require("../sync/synchronous-promise");
/**
 * Performs a real sleep.
 */
class SleepImpl {
    /**
       * Synchronously sleeps for duration specified in millis.
       */
    sleep(timeMillis) {
        console.log(`Performing a real sleep of ${timeMillis} ms. Be sure to not commit code that performs a real sleep!`);
        new synchronous_promise_1.SynchronousPromise().wait('../../lib/sync/async-sleep', 'AsyncSleep', [timeMillis]);
    }
}
exports.SleepImpl = SleepImpl;
_a = JSII_RTTI_SYMBOL_1;
SleepImpl[_a] = { fqn: "@cdklabs/cdk-ssm-documents.SleepImpl", version: "0.0.23" };
/**
 * Mock ISleeper implementation. Simply logs that it is sleeping and returns immediately.
 */
class MockSleep {
    constructor() {
        this.sleepMilliInvocations = [];
    }
    sleep(timeMillis) {
        this.sleepMilliInvocations.push(timeMillis);
        console.log(`Mocked implementation! Not performing real sleep of ${timeMillis}`);
    }
}
exports.MockSleep = MockSleep;
_b = JSII_RTTI_SYMBOL_1;
MockSleep[_b] = { fqn: "@cdklabs/cdk-ssm-documents.MockSleep", version: "0.0.23" };
//# sourceMappingURL=data:application/json;base64,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