import { ExecuteAutomationStep, IExecuteAutomationHook } from '../..';
import { AutomationSimulationBase } from './automation-simulation-base';
/**
 * Properties for ExecuteAutomationStep
 */
export interface ExecuteAutomationSimulationProps {
    /**
     * Hook for simulating aws:executeAutomation.
     * @default - Uses AWS API to execute the document remotely.
     */
    readonly executeAutomationHook: IExecuteAutomationHook;
}
/**
 * AutomationStep implementation of [aws:executeAutomation](https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-executeAutomation.html)
 */
export declare class ExecuteAutomationSimulation extends AutomationSimulationBase {
    readonly action = "aws:executeAutomation";
    private executeAutomationStep;
    private props;
    constructor(step: ExecuteAutomationStep, props: ExecuteAutomationSimulationProps);
    executeStep(inputs: Record<string, any>): Record<string, any>;
}
