"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .accountinglineitem import AccountingLineitem, AccountingLineitemTypedDict
from .property_accountingsalesorder_billing_address import (
    PropertyAccountingSalesorderBillingAddress,
    PropertyAccountingSalesorderBillingAddressTypedDict,
)
from .property_accountingsalesorder_shipping_address import (
    PropertyAccountingSalesorderShippingAddress,
    PropertyAccountingSalesorderShippingAddressTypedDict,
)
from datetime import datetime
from enum import Enum
from pydantic.functional_validators import PlainValidator
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class AccountingSalesorderStatus(str, Enum, metaclass=utils.OpenEnumMeta):
    DRAFT = "DRAFT"
    VOIDED = "VOIDED"
    AUTHORIZED = "AUTHORIZED"
    PAID = "PAID"
    PARTIALLY_PAID = "PARTIALLY_PAID"
    PARTIALLY_REFUNDED = "PARTIALLY_REFUNDED"
    REFUNDED = "REFUNDED"


class AccountingSalesorderTypedDict(TypedDict):
    account_id: NotRequired[str]
    billing_address: NotRequired[PropertyAccountingSalesorderBillingAddressTypedDict]
    contact_id: NotRequired[str]
    created_at: NotRequired[datetime]
    currency: NotRequired[str]
    id: NotRequired[str]
    lineitems: NotRequired[List[AccountingLineitemTypedDict]]
    posted_at: NotRequired[datetime]
    raw: NotRequired[Dict[str, Any]]
    shipping_address: NotRequired[PropertyAccountingSalesorderShippingAddressTypedDict]
    status: NotRequired[AccountingSalesorderStatus]
    total_amount: NotRequired[float]
    updated_at: NotRequired[datetime]


class AccountingSalesorder(BaseModel):
    account_id: Optional[str] = None

    billing_address: Optional[PropertyAccountingSalesorderBillingAddress] = None

    contact_id: Optional[str] = None

    created_at: Optional[datetime] = None

    currency: Optional[str] = None

    id: Optional[str] = None

    lineitems: Optional[List[AccountingLineitem]] = None

    posted_at: Optional[datetime] = None

    raw: Optional[Dict[str, Any]] = None

    shipping_address: Optional[PropertyAccountingSalesorderShippingAddress] = None

    status: Annotated[
        Optional[AccountingSalesorderStatus], PlainValidator(validate_open_enum(False))
    ] = None

    total_amount: Optional[float] = None

    updated_at: Optional[datetime] = None
