"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .genaiembeddingcontent import GenaiEmbeddingContent, GenaiEmbeddingContentTypedDict
from enum import Enum
from pydantic.functional_validators import PlainValidator
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class EncondingFormat(str, Enum, metaclass=utils.OpenEnumMeta):
    FLOAT = "FLOAT"
    UINT8 = "UINT8"
    INT8 = "INT8"
    BINARY = "BINARY"
    UBINARY = "UBINARY"
    BASE64 = "BASE64"


class GenaiEmbeddingTypedDict(TypedDict):
    content: NotRequired[List[GenaiEmbeddingContentTypedDict]]
    dimension: NotRequired[float]
    embeddings: NotRequired[str]
    enconding_format: NotRequired[EncondingFormat]
    id: NotRequired[str]
    max_tokens: NotRequired[float]
    model_id: NotRequired[str]
    raw: NotRequired[Dict[str, Any]]
    tokens_used: NotRequired[float]
    type: NotRequired[str]


class GenaiEmbedding(BaseModel):
    content: Optional[List[GenaiEmbeddingContent]] = None

    dimension: Optional[float] = None

    embeddings: Optional[str] = None

    enconding_format: Annotated[
        Optional[EncondingFormat], PlainValidator(validate_open_enum(False))
    ] = None

    id: Optional[str] = None

    max_tokens: Optional[float] = None

    model_id: Optional[str] = None

    raw: Optional[Dict[str, Any]] = None

    tokens_used: Optional[float] = None

    type: Optional[str] = None
