"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from pydantic.functional_validators import PlainValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class HrisCompensationFrequency(str, Enum, metaclass=utils.OpenEnumMeta):
    ONE_TIME = "ONE_TIME"
    DAY = "DAY"
    QUARTER = "QUARTER"
    YEAR = "YEAR"
    HOUR = "HOUR"
    MONTH = "MONTH"
    WEEK = "WEEK"


class HrisCompensationType(str, Enum, metaclass=utils.OpenEnumMeta):
    SALARY = "SALARY"
    BONUS = "BONUS"
    STOCK_OPTIONS = "STOCK_OPTIONS"
    EQUITY = "EQUITY"
    OTHER = "OTHER"


class HrisCompensationTypedDict(TypedDict):
    amount: NotRequired[float]
    currency: NotRequired[str]
    frequency: NotRequired[HrisCompensationFrequency]
    group_id: NotRequired[str]
    type: NotRequired[HrisCompensationType]


class HrisCompensation(BaseModel):
    amount: Optional[float] = None

    currency: Optional[str] = None

    frequency: Annotated[
        Optional[HrisCompensationFrequency], PlainValidator(validate_open_enum(False))
    ] = None

    group_id: Optional[str] = None

    type: Annotated[
        Optional[HrisCompensationType], PlainValidator(validate_open_enum(False))
    ] = None
