"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .hriscompensation import HrisCompensation, HrisCompensationTypedDict
from .hrisemail import HrisEmail, HrisEmailTypedDict
from .hrisgroup import HrisGroup, HrisGroupTypedDict
from .hrislocation import HrisLocation, HrisLocationTypedDict
from .hrismetadata import HrisMetadata, HrisMetadataTypedDict
from .hristelephone import HrisTelephone, HrisTelephoneTypedDict
from .property_hrisemployee_address import (
    PropertyHrisEmployeeAddress,
    PropertyHrisEmployeeAddressTypedDict,
)
from .property_hrisemployee_employee_roles import PropertyHrisEmployeeEmployeeRoles
from datetime import datetime
from enum import Enum
from pydantic.functional_validators import PlainValidator
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class EmploymentStatus(str, Enum, metaclass=utils.OpenEnumMeta):
    ACTIVE = "ACTIVE"
    INACTIVE = "INACTIVE"


class HrisEmployeeEmploymentType(str, Enum, metaclass=utils.OpenEnumMeta):
    FULL_TIME = "FULL_TIME"
    PART_TIME = "PART_TIME"
    CONTRACTOR = "CONTRACTOR"
    INTERN = "INTERN"
    CONSULTANT = "CONSULTANT"
    VOLUNTEER = "VOLUNTEER"
    CASUAL = "CASUAL"
    SEASONAL = "SEASONAL"
    FREELANCE = "FREELANCE"
    OTHER = "OTHER"


class HrisEmployeeGender(str, Enum, metaclass=utils.OpenEnumMeta):
    MALE = "MALE"
    FEMALE = "FEMALE"
    INTERSEX = "INTERSEX"
    TRANS = "TRANS"
    NON_BINARY = "NON_BINARY"


class MaritalStatus(str, Enum, metaclass=utils.OpenEnumMeta):
    MARRIED = "MARRIED"
    SINGLE = "SINGLE"


class HrisEmployeeTypedDict(TypedDict):
    address: NotRequired[PropertyHrisEmployeeAddressTypedDict]
    bio: NotRequired[str]
    company_id: NotRequired[str]
    compensation: NotRequired[List[HrisCompensationTypedDict]]
    created_at: NotRequired[datetime]
    currency: NotRequired[str]
    date_of_birth: NotRequired[datetime]
    department: NotRequired[str]
    division: NotRequired[str]
    emails: NotRequired[List[HrisEmailTypedDict]]
    employee_number: NotRequired[str]
    employee_roles: NotRequired[List[PropertyHrisEmployeeEmployeeRoles]]
    employment_status: NotRequired[EmploymentStatus]
    employment_type: NotRequired[HrisEmployeeEmploymentType]
    gender: NotRequired[HrisEmployeeGender]
    groups: NotRequired[List[HrisGroupTypedDict]]
    r"""Which groups/teams/units that this employee/user belongs to.  May not have all of the Group fields present, but should have id, name, or email."""
    hired_at: NotRequired[datetime]
    id: NotRequired[str]
    image_url: NotRequired[str]
    language_locale: NotRequired[str]
    location: NotRequired[str]
    locations: NotRequired[List[HrisLocationTypedDict]]
    manager_id: NotRequired[str]
    marital_status: NotRequired[MaritalStatus]
    metadata: NotRequired[List[HrisMetadataTypedDict]]
    name: NotRequired[str]
    pronouns: NotRequired[str]
    raw: NotRequired[Dict[str, Any]]
    salutation: NotRequired[str]
    ssn_sin: NotRequired[str]
    storage_quota_allocated: NotRequired[float]
    storage_quota_available: NotRequired[float]
    storage_quota_used: NotRequired[float]
    telephones: NotRequired[List[HrisTelephoneTypedDict]]
    terminated_at: NotRequired[datetime]
    timezone: NotRequired[str]
    title: NotRequired[str]
    updated_at: NotRequired[datetime]


class HrisEmployee(BaseModel):
    address: Optional[PropertyHrisEmployeeAddress] = None

    bio: Optional[str] = None

    company_id: Optional[str] = None

    compensation: Optional[List[HrisCompensation]] = None

    created_at: Optional[datetime] = None

    currency: Optional[str] = None

    date_of_birth: Optional[datetime] = None

    department: Optional[str] = None

    division: Optional[str] = None

    emails: Optional[List[HrisEmail]] = None

    employee_number: Optional[str] = None

    employee_roles: Optional[
        List[
            Annotated[
                PropertyHrisEmployeeEmployeeRoles,
                PlainValidator(validate_open_enum(False)),
            ]
        ]
    ] = None

    employment_status: Annotated[
        Optional[EmploymentStatus], PlainValidator(validate_open_enum(False))
    ] = None

    employment_type: Annotated[
        Optional[HrisEmployeeEmploymentType], PlainValidator(validate_open_enum(False))
    ] = None

    gender: Annotated[
        Optional[HrisEmployeeGender], PlainValidator(validate_open_enum(False))
    ] = None

    groups: Optional[List[HrisGroup]] = None
    r"""Which groups/teams/units that this employee/user belongs to.  May not have all of the Group fields present, but should have id, name, or email."""

    hired_at: Optional[datetime] = None

    id: Optional[str] = None

    image_url: Optional[str] = None

    language_locale: Optional[str] = None

    location: Optional[str] = None

    locations: Optional[List[HrisLocation]] = None

    manager_id: Optional[str] = None

    marital_status: Annotated[
        Optional[MaritalStatus], PlainValidator(validate_open_enum(False))
    ] = None

    metadata: Optional[List[HrisMetadata]] = None

    name: Optional[str] = None

    pronouns: Optional[str] = None

    raw: Optional[Dict[str, Any]] = None

    salutation: Optional[str] = None

    ssn_sin: Optional[str] = None

    storage_quota_allocated: Optional[float] = None

    storage_quota_available: Optional[float] = None

    storage_quota_used: Optional[float] = None

    telephones: Optional[List[HrisTelephone]] = None

    terminated_at: Optional[datetime] = None

    timezone: Optional[str] = None

    title: Optional[str] = None

    updated_at: Optional[datetime] = None
