"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from enum import Enum
from pydantic.functional_validators import PlainValidator
from typing import Any, Dict, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class PaymentRefundStatus(str, Enum, metaclass=utils.OpenEnumMeta):
    SUCCEEDED = "SUCCEEDED"
    PENDING = "PENDING"
    FAILED = "FAILED"
    CANCELED = "CANCELED"


class PaymentRefundTypedDict(TypedDict):
    payment_id: str
    total_amount: float
    created_at: NotRequired[datetime]
    currency: NotRequired[str]
    id: NotRequired[str]
    notes: NotRequired[str]
    raw: NotRequired[Dict[str, Any]]
    reference: NotRequired[str]
    status: NotRequired[PaymentRefundStatus]
    updated_at: NotRequired[datetime]


class PaymentRefund(BaseModel):
    payment_id: str

    total_amount: float

    created_at: Optional[datetime] = None

    currency: Optional[str] = None

    id: Optional[str] = None

    notes: Optional[str] = None

    raw: Optional[Dict[str, Any]] = None

    reference: Optional[str] = None

    status: Annotated[
        Optional[PaymentRefundStatus], PlainValidator(validate_open_enum(False))
    ] = None

    updated_at: Optional[datetime] = None
