"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from enum import Enum
from pydantic.functional_validators import PlainValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class Priority(str, Enum, metaclass=utils.OpenEnumMeta):
    HIGH = "HIGH"
    MEDIUM = "MEDIUM"
    LOW = "LOW"


class PropertyCrmEventTaskStatus(str, Enum, metaclass=utils.OpenEnumMeta):
    COMPLETED = "COMPLETED"
    NOT_STARTED = "NOT_STARTED"
    WORK_IN_PROGRESS = "WORK_IN_PROGRESS"
    DEFERRED = "DEFERRED"


class PropertyCrmEventTaskTypedDict(TypedDict):
    r"""The task object, when type = task"""

    description: NotRequired[str]
    due_at: NotRequired[datetime]
    name: NotRequired[str]
    priority: NotRequired[Priority]
    status: NotRequired[PropertyCrmEventTaskStatus]


class PropertyCrmEventTask(BaseModel):
    r"""The task object, when type = task"""

    description: Optional[str] = None

    due_at: Optional[datetime] = None

    name: Optional[str] = None

    priority: Annotated[
        Optional[Priority], PlainValidator(validate_open_enum(False))
    ] = None

    status: Annotated[
        Optional[PropertyCrmEventTaskStatus], PlainValidator(validate_open_enum(False))
    ] = None
