"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from enum import Enum
from pydantic.functional_validators import PlainValidator
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk import utils
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import validate_open_enum


class TicketingTicketStatus(str, Enum, metaclass=utils.OpenEnumMeta):
    ACTIVE = "ACTIVE"
    CLOSED = "CLOSED"


class TicketingTicketTypedDict(TypedDict):
    category: NotRequired[str]
    category_id: NotRequired[str]
    closed_at: NotRequired[datetime]
    created_at: NotRequired[datetime]
    customer_id: NotRequired[str]
    description: NotRequired[str]
    id: NotRequired[str]
    priority: NotRequired[str]
    raw: NotRequired[Dict[str, Any]]
    source: NotRequired[str]
    source_ref: NotRequired[str]
    status: NotRequired[TicketingTicketStatus]
    subject: NotRequired[str]
    tags: NotRequired[List[str]]
    updated_at: NotRequired[datetime]
    url: NotRequired[str]
    user_id: NotRequired[str]


class TicketingTicket(BaseModel):
    category: Optional[str] = None

    category_id: Optional[str] = None

    closed_at: Optional[datetime] = None

    created_at: Optional[datetime] = None

    customer_id: Optional[str] = None

    description: Optional[str] = None

    id: Optional[str] = None

    priority: Optional[str] = None

    raw: Optional[Dict[str, Any]] = None

    source: Optional[str] = None

    source_ref: Optional[str] = None

    status: Annotated[
        Optional[TicketingTicketStatus], PlainValidator(validate_open_enum(False))
    ] = None

    subject: Optional[str] = None

    tags: Optional[List[str]] = None

    updated_at: Optional[datetime] = None

    url: Optional[str] = None

    user_id: Optional[str] = None
