"""
This file provides autocompletions for the ZOS-API and was automatically generated.
It should not be edited manually.
"""

from __future__ import annotations

from zospy.api._ZOSAPI.Analysis import SampleSizes
from zospy.api._ZOSAPI.Analysis.Settings import (
    IAS_,
    IAS_Field,
    IAS_Surface,
    IAS_Wavelength,
)

__all__ = (
    "IAS_PhysicalOpticsPropagation",
    "POPBeamTypes",
    "POPDataTypes",
    "POPFiberPositions",
    "POPFiberTypes",
    "POPProjectionTypes",
    "POPScaleTypes",
    "POPShowAsTypes",
    "POPZoomTypes",
)

class IAS_PhysicalOpticsPropagation(IAS_):
    def AutoCalculateBeamSampling(self) -> None: ...
    @property
    def BeamType(self) -> POPBeamTypes: ...
    @property
    def BeamTypeFilename(self) -> str: ...
    @property
    def ComputeFiberCouplingIntegral(self) -> bool: ...
    @property
    def ContourFormat(self) -> str: ...
    @property
    def DataType(self) -> POPDataTypes: ...
    @property
    def EndSurface(self) -> IAS_Surface: ...
    @property
    def FiberPosition(self) -> POPFiberPositions: ...
    @property
    def FiberType(self) -> POPFiberTypes: ...
    @property
    def FiberTypeFilename(self) -> str: ...
    @property
    def Field(self) -> IAS_Field: ...
    @property
    def IgnoreFiberPolarization(self) -> bool: ...
    @property
    def LogScale(self) -> POPScaleTypes: ...
    @property
    def NumberOfBeamTypeFiles(self) -> int: ...
    @property
    def NumberOfFiberParameters(self) -> int: ...
    @property
    def NumberOfFiberTypeFiles(self) -> int: ...
    @property
    def NumberOfParameters(self) -> int: ...
    @property
    def OutputBeamFile(self) -> str: ...
    @property
    def PeakIrradiance(self) -> float: ...
    @property
    def PlotScale(self) -> float: ...
    @property
    def Project(self) -> POPProjectionTypes: ...
    @property
    def RowOrColumn(self) -> int: ...
    @property
    def SaveBeamAtAllSurfaces(self) -> bool: ...
    @property
    def SaveOutputBeam(self) -> bool: ...
    @property
    def SeparateXY(self) -> bool: ...
    @property
    def ShowAs(self) -> POPShowAsTypes: ...
    @property
    def StartSurface(self) -> IAS_Surface: ...
    @property
    def SurfaceToBeam(self) -> float: ...
    @property
    def TiltAboutX(self) -> float: ...
    @property
    def TiltAboutY(self) -> float: ...
    @property
    def TotalPower(self) -> float: ...
    @property
    def UseDiskStorage(self) -> bool: ...
    @property
    def UsePeakIrradiance(self) -> bool: ...
    @property
    def UsePolarization(self) -> bool: ...
    @property
    def UseTotalPower(self) -> bool: ...
    @property
    def Wavelength(self) -> IAS_Wavelength: ...
    @property
    def XSampling(self) -> SampleSizes: ...
    @property
    def XWidth(self) -> float: ...
    @property
    def YSampling(self) -> SampleSizes: ...
    @property
    def YWidth(self) -> float: ...
    @property
    def ZeroPhaseLevel(self) -> float: ...
    @property
    def ZoomIn(self) -> POPZoomTypes: ...
    def GetBeamTypeFileName(self, fileIndex: int) -> str: ...
    def GetBeamTypeFiles(self) -> list[str]: ...
    def GetFiberParameterName(self, paramIdx: int) -> str: ...
    def GetFiberParameterValue(self, paramIdx: int) -> float: ...
    def GetFiberTypeFileName(self, fileIndex: int) -> str: ...
    def GetFiberTypeFiles(self) -> list[str]: ...
    def GetParameterName(self, paramIdx: int) -> str: ...
    def GetParameterValue(self, paramIdx: int) -> float: ...
    def ReadPowerFromFile(self) -> None: ...
    @BeamType.setter
    def BeamType(self, value: POPBeamTypes) -> None: ...
    @BeamTypeFilename.setter
    def BeamTypeFilename(self, value: str) -> None: ...
    @ComputeFiberCouplingIntegral.setter
    def ComputeFiberCouplingIntegral(self, value: bool) -> None: ...
    @ContourFormat.setter
    def ContourFormat(self, value: str) -> None: ...
    @DataType.setter
    def DataType(self, value: POPDataTypes) -> None: ...
    @FiberPosition.setter
    def FiberPosition(self, value: POPFiberPositions) -> None: ...
    @FiberType.setter
    def FiberType(self, value: POPFiberTypes) -> None: ...
    @FiberTypeFilename.setter
    def FiberTypeFilename(self, value: str) -> None: ...
    @IgnoreFiberPolarization.setter
    def IgnoreFiberPolarization(self, value: bool) -> None: ...
    @LogScale.setter
    def LogScale(self, value: POPScaleTypes) -> None: ...
    @OutputBeamFile.setter
    def OutputBeamFile(self, value: str) -> None: ...
    @PeakIrradiance.setter
    def PeakIrradiance(self, value: float) -> None: ...
    @PlotScale.setter
    def PlotScale(self, value: float) -> None: ...
    @Project.setter
    def Project(self, value: POPProjectionTypes) -> None: ...
    @RowOrColumn.setter
    def RowOrColumn(self, value: int) -> None: ...
    @SaveBeamAtAllSurfaces.setter
    def SaveBeamAtAllSurfaces(self, value: bool) -> None: ...
    @SaveOutputBeam.setter
    def SaveOutputBeam(self, value: bool) -> None: ...
    @SeparateXY.setter
    def SeparateXY(self, value: bool) -> None: ...
    @ShowAs.setter
    def ShowAs(self, value: POPShowAsTypes) -> None: ...
    @SurfaceToBeam.setter
    def SurfaceToBeam(self, value: float) -> None: ...
    @TiltAboutX.setter
    def TiltAboutX(self, value: float) -> None: ...
    @TiltAboutY.setter
    def TiltAboutY(self, value: float) -> None: ...
    @TotalPower.setter
    def TotalPower(self, value: float) -> None: ...
    @UseDiskStorage.setter
    def UseDiskStorage(self, value: bool) -> None: ...
    @UsePeakIrradiance.setter
    def UsePeakIrradiance(self, value: bool) -> None: ...
    @UsePolarization.setter
    def UsePolarization(self, value: bool) -> None: ...
    @UseTotalPower.setter
    def UseTotalPower(self, value: bool) -> None: ...
    @XSampling.setter
    def XSampling(self, value: SampleSizes) -> None: ...
    @XWidth.setter
    def XWidth(self, value: float) -> None: ...
    @YSampling.setter
    def YSampling(self, value: SampleSizes) -> None: ...
    @YWidth.setter
    def YWidth(self, value: float) -> None: ...
    @ZeroPhaseLevel.setter
    def ZeroPhaseLevel(self, value: float) -> None: ...
    @ZoomIn.setter
    def ZoomIn(self, value: POPZoomTypes) -> None: ...
    def SetFiberParameterValue(self, paramIdx: int, Value: float) -> None: ...
    def SetParameterValue(self, paramIdx: int, Value: float) -> None: ...

class POPBeamTypes:
    GaussianWaist = 0
    GaussianAngle = 1
    GaussianSizeAngle = 2
    TopHat = 3
    File = 4
    DLL = 5
    Multimode = 6
    AstigmaticGaussian = 7

class POPDataTypes:
    Irradiance = 0
    EXIrradiance = 1
    EYIrradiance = 2
    Phase = 3
    EXPhase = 4
    EYPhase = 5
    TransferMagnitude = 6
    TransferPhase = 7

class POPFiberPositions:
    ChiefRay = 0
    SurfaceVertex = 1

class POPFiberTypes:
    GaussianWaist = 0
    GaussianAngle = 1
    GaussianSizeAngle = 2
    TopHat = 3
    File = 4
    DLL = 5
    AstigmaticGaussian = 6

class POPProjectionTypes:
    AlongBeam = 0
    AlongNormal = 1
    AlongLocalZ = 2

class POPScaleTypes:
    Linear = 0
    Log_Minus_5 = 1
    Log_Minus_10 = 2
    Log_Minus_15 = 3

class POPShowAsTypes:
    Surface = 0
    Contour = 1
    GrayScale = 2
    InverseGrayScale = 3
    FalseColor = 4
    InverseFalseColor = 5
    CrossX = 6
    CrossY = 7
    Encircled = 8
    Ensquared = 9
    EnslittedX = 10
    EnslittedY = 11

class POPZoomTypes:
    NoZoom = 0
    X2 = 1
    X4 = 2
    X8 = 3
    X16 = 4
