"""
This file provides autocompletions for the ZOS-API and was automatically generated.
It should not be edited manually.
"""

from __future__ import annotations

from zospy.api._ZOSAPI.Analysis import GiaShowAsTypes, SampleSizes
from zospy.api._ZOSAPI.Analysis.Settings import (
    IAS_,
    IAS_Field,
    IAS_Surface,
    IAS_Wavelength,
    Parity,
    ReferenceGia,
    Rotations,
    ScanTypes,
    SourceGia,
)

__all__ = (
    "IAS_GeometricImageAnalysis",
    "IAS_ImageSimulation",
    "IAS_RelativeIllumination",
    "ISAberrationTypes",
    "ISFlipTypes",
    "ISSamplings",
    "ISShowAsTypes",
)

class IAS_GeometricImageAnalysis(IAS_):
    @property
    def DeleteVignetted(self) -> bool: ...
    @property
    def Field(self) -> IAS_Field: ...
    @property
    def FieldSize(self) -> float: ...
    @property
    def File(self) -> str: ...
    @property
    def ImageSize(self) -> float: ...
    @property
    def NA(self) -> float: ...
    @property
    def NumberOfPixels(self) -> int: ...
    @property
    def Parity(self) -> Parity: ...
    @property
    def RaysX1000(self) -> int: ...
    @property
    def Reference(self) -> ReferenceGia: ...
    @property
    def RemoveVignettingFactors(self) -> bool: ...
    @property
    def Rotation(self) -> float: ...
    @property
    def RowColumnNumber(self) -> int: ...
    @property
    def SaveAsBIMFile(self) -> str: ...
    @property
    def ScatterRays(self) -> bool: ...
    @property
    def ShowAs(self) -> GiaShowAsTypes: ...
    @property
    def Source(self) -> SourceGia: ...
    @property
    def Surface(self) -> IAS_Surface: ...
    @property
    def TotalWatts(self) -> float: ...
    @property
    def UsePixelInterpolation(self) -> bool: ...
    @property
    def UsePolarization(self) -> bool: ...
    @property
    def UseSymbols(self) -> bool: ...
    @property
    def Wavelength(self) -> IAS_Wavelength: ...
    def GetFileNames(self) -> list[str]: ...
    @DeleteVignetted.setter
    def DeleteVignetted(self, value: bool) -> None: ...
    @FieldSize.setter
    def FieldSize(self, value: float) -> None: ...
    @File.setter
    def File(self, value: str) -> None: ...
    @ImageSize.setter
    def ImageSize(self, value: float) -> None: ...
    @NA.setter
    def NA(self, value: float) -> None: ...
    @NumberOfPixels.setter
    def NumberOfPixels(self, value: int) -> None: ...
    @Parity.setter
    def Parity(self, value: Parity) -> None: ...
    @RaysX1000.setter
    def RaysX1000(self, value: int) -> None: ...
    @Reference.setter
    def Reference(self, value: ReferenceGia) -> None: ...
    @RemoveVignettingFactors.setter
    def RemoveVignettingFactors(self, value: bool) -> None: ...
    @Rotation.setter
    def Rotation(self, value: float) -> None: ...
    @RowColumnNumber.setter
    def RowColumnNumber(self, value: int) -> None: ...
    @SaveAsBIMFile.setter
    def SaveAsBIMFile(self, value: str) -> None: ...
    @ScatterRays.setter
    def ScatterRays(self, value: bool) -> None: ...
    @ShowAs.setter
    def ShowAs(self, value: GiaShowAsTypes) -> None: ...
    @Source.setter
    def Source(self, value: SourceGia) -> None: ...
    @TotalWatts.setter
    def TotalWatts(self, value: float) -> None: ...
    @UsePixelInterpolation.setter
    def UsePixelInterpolation(self, value: bool) -> None: ...
    @UsePolarization.setter
    def UsePolarization(self, value: bool) -> None: ...
    @UseSymbols.setter
    def UseSymbols(self, value: bool) -> None: ...
    def UseColumnRowCenter(self) -> bool: ...

class IAS_ImageSimulation(IAS_):
    @property
    def Aberrations(self) -> ISAberrationTypes: ...
    @property
    def ApplyFixedApertures(self) -> bool: ...
    @property
    def Field(self) -> IAS_Field: ...
    @property
    def FieldHeight(self) -> float: ...
    @property
    def FlipImage(self) -> ISFlipTypes: ...
    @property
    def FlipSource(self) -> ISFlipTypes: ...
    @property
    def GuardBand(self) -> ISSamplings: ...
    @property
    def ImageSampling(self) -> SampleSizes: ...
    @property
    def InputFile(self) -> str: ...
    @property
    def OutputFile(self) -> str: ...
    @property
    def Oversampling(self) -> ISSamplings: ...
    @property
    def PixelSize(self) -> float: ...
    @property
    def PSFXPoints(self) -> int: ...
    @property
    def PSFYPoints(self) -> int: ...
    @property
    def PupilSampling(self) -> SampleSizes: ...
    @property
    def Reference(self) -> ReferenceGia: ...
    @property
    def RotationSource(self) -> Rotations: ...
    @property
    def ShowAs(self) -> ISShowAsTypes: ...
    @property
    def SuppressFrame(self) -> bool: ...
    @property
    def UsePolarization(self) -> bool: ...
    @property
    def UseRelativeIllumination(self) -> bool: ...
    @property
    def XPixels(self) -> int: ...
    @property
    def YPixels(self) -> int: ...
    def GetInputFileNames(self) -> list[str]: ...
    def GetWavelength123(self) -> bool: ...
    def GetWavelengthNumber(self) -> int: ...
    def GetWavelengthRGB(self) -> bool: ...
    @Aberrations.setter
    def Aberrations(self, value: ISAberrationTypes) -> None: ...
    @ApplyFixedApertures.setter
    def ApplyFixedApertures(self, value: bool) -> None: ...
    @FieldHeight.setter
    def FieldHeight(self, value: float) -> None: ...
    @FlipImage.setter
    def FlipImage(self, value: ISFlipTypes) -> None: ...
    @FlipSource.setter
    def FlipSource(self, value: ISFlipTypes) -> None: ...
    @GuardBand.setter
    def GuardBand(self, value: ISSamplings) -> None: ...
    @ImageSampling.setter
    def ImageSampling(self, value: SampleSizes) -> None: ...
    @InputFile.setter
    def InputFile(self, value: str) -> None: ...
    @OutputFile.setter
    def OutputFile(self, value: str) -> None: ...
    @Oversampling.setter
    def Oversampling(self, value: ISSamplings) -> None: ...
    @PixelSize.setter
    def PixelSize(self, value: float) -> None: ...
    @PSFXPoints.setter
    def PSFXPoints(self, value: int) -> None: ...
    @PSFYPoints.setter
    def PSFYPoints(self, value: int) -> None: ...
    @PupilSampling.setter
    def PupilSampling(self, value: SampleSizes) -> None: ...
    @Reference.setter
    def Reference(self, value: ReferenceGia) -> None: ...
    @RotationSource.setter
    def RotationSource(self, value: Rotations) -> None: ...
    @ShowAs.setter
    def ShowAs(self, value: ISShowAsTypes) -> None: ...
    @SuppressFrame.setter
    def SuppressFrame(self, value: bool) -> None: ...
    @UsePolarization.setter
    def UsePolarization(self, value: bool) -> None: ...
    @UseRelativeIllumination.setter
    def UseRelativeIllumination(self, value: bool) -> None: ...
    @XPixels.setter
    def XPixels(self, value: int) -> None: ...
    @YPixels.setter
    def YPixels(self, value: int) -> None: ...
    def SetWavelength123(self) -> None: ...
    def SetWavelengthNumber(self, wlNum: int) -> None: ...
    def SetWavelengthRGB(self) -> None: ...

class IAS_RelativeIllumination(IAS_):
    @property
    def FieldDensity(self) -> int: ...
    @property
    def LogScale(self) -> bool: ...
    @property
    def RayDensity(self) -> int: ...
    @property
    def RemoveVignettingFactors(self) -> bool: ...
    @property
    def ScanType(self) -> ScanTypes: ...
    @property
    def UsePolarization(self) -> bool: ...
    @property
    def Wavelength(self) -> IAS_Wavelength: ...
    @FieldDensity.setter
    def FieldDensity(self, value: int) -> None: ...
    @LogScale.setter
    def LogScale(self, value: bool) -> None: ...
    @RayDensity.setter
    def RayDensity(self, value: int) -> None: ...
    @RemoveVignettingFactors.setter
    def RemoveVignettingFactors(self, value: bool) -> None: ...
    @ScanType.setter
    def ScanType(self, value: ScanTypes) -> None: ...
    @UsePolarization.setter
    def UsePolarization(self, value: bool) -> None: ...

class ISAberrationTypes:
    # None = 0
    Geometric = 1
    Diffraction = 2

class ISFlipTypes:
    # None = 0
    TopBottom = 1
    LeftRight = 2
    TopBottomLeftRight = 3

class ISSamplings:
    # None = 0
    X2 = 1
    X4 = 2
    X8 = 3
    X16 = 4
    X32 = 5
    X64 = 6

class ISShowAsTypes:
    SimulatedImage = 0
    SourceBitmap = 1
    PSFGrid = 2
