"""
This file provides autocompletions for the ZOS-API and was automatically generated.
It should not be edited manually.
"""

from __future__ import annotations

from zospy.api._ZOSAPI.Analysis import (
    HuygensSurfaceMftShowAsTypes,
    SampleSizes,
    SampleSizes_ContrastLoss,
    ShowAs,
)
from zospy.api._ZOSAPI.Analysis.Settings import (
    IAS_,
    IAS_Detector,
    IAS_Field,
    IAS_Surface,
    IAS_Wavelength,
    Rotations,
    ScanTypes,
)

__all__ = (
    "HuygensMtfTypes",
    "IAS_ContrastLossMap",
    "IAS_FftMtf",
    "IAS_FftMtfMap",
    "IAS_FftMtfvsField",
    "IAS_FftSurfaceMtf",
    "IAS_FftThroughFocusMtf",
    "IAS_GeometricMtf",
    "IAS_GeometricMtfMap",
    "IAS_GeometricMtfvsField",
    "IAS_GeometricThroughFocusMtf",
    "IAS_HuygensMtf",
    "IAS_HuygensMtfvsField",
    "IAS_HuygensSurfaceMtf",
    "IAS_HuygensThroughFocusMtf",
    "IAS_NSCGeometricMtf",
    "MtfDataTypes",
    "MtfTypes",
    "ShowAsTypes",
    "SurfaceMtfTypes",
)

class HuygensMtfTypes:
    Modulation = 0

class IAS_ContrastLossMap(IAS_):
    @property
    def Field(self) -> IAS_Field: ...
    @property
    def Frequency(self) -> float: ...
    @property
    def Normalize(self) -> bool: ...
    @property
    def SampleSize(self) -> SampleSizes_ContrastLoss: ...
    @property
    def ShowOPD(self) -> bool: ...
    @property
    def Wavelength(self) -> IAS_Wavelength: ...
    @Frequency.setter
    def Frequency(self, value: float) -> None: ...
    @Normalize.setter
    def Normalize(self, value: bool) -> None: ...
    @SampleSize.setter
    def SampleSize(self, value: SampleSizes_ContrastLoss) -> None: ...
    @ShowOPD.setter
    def ShowOPD(self, value: bool) -> None: ...

class IAS_FftMtf(IAS_):
    @property
    def Field(self) -> IAS_Field: ...
    @property
    def MaximumFrequency(self) -> float: ...
    @property
    def SampleSize(self) -> SampleSizes: ...
    @property
    def ShowDiffractionLimit(self) -> bool: ...
    @property
    def Surface(self) -> IAS_Surface: ...
    @property
    def Type(self) -> MtfTypes: ...
    @property
    def UseDashes(self) -> bool: ...
    @property
    def UsePolarization(self) -> bool: ...
    @property
    def Wavelength(self) -> IAS_Wavelength: ...
    @MaximumFrequency.setter
    def MaximumFrequency(self, value: float) -> None: ...
    @SampleSize.setter
    def SampleSize(self, value: SampleSizes) -> None: ...
    @ShowDiffractionLimit.setter
    def ShowDiffractionLimit(self, value: bool) -> None: ...
    @Type.setter
    def Type(self, value: MtfTypes) -> None: ...
    @UseDashes.setter
    def UseDashes(self, value: bool) -> None: ...
    @UsePolarization.setter
    def UsePolarization(self, value: bool) -> None: ...

class IAS_FftMtfMap(IAS_):
    @property
    def Frequency(self) -> float: ...
    @property
    def MTF_DataType(self) -> MtfDataTypes: ...
    @property
    def ReferenceField(self) -> IAS_Field: ...
    @property
    def RemoveVignetting(self) -> bool: ...
    @property
    def SampleSize(self) -> SampleSizes: ...
    @property
    def ShowAs(self) -> ShowAsTypes: ...
    @property
    def UsePolarization(self) -> bool: ...
    @property
    def Wavelength(self) -> IAS_Wavelength: ...
    @property
    def X_Field_Width(self) -> float: ...
    @property
    def X_Pixels(self) -> int: ...
    @property
    def Y_Field_Width(self) -> float: ...
    @property
    def Y_Pixels(self) -> int: ...
    @Frequency.setter
    def Frequency(self, value: float) -> None: ...
    @MTF_DataType.setter
    def MTF_DataType(self, value: MtfDataTypes) -> None: ...
    @RemoveVignetting.setter
    def RemoveVignetting(self, value: bool) -> None: ...
    @SampleSize.setter
    def SampleSize(self, value: SampleSizes) -> None: ...
    @ShowAs.setter
    def ShowAs(self, value: ShowAsTypes) -> None: ...
    @UsePolarization.setter
    def UsePolarization(self, value: bool) -> None: ...
    @X_Field_Width.setter
    def X_Field_Width(self, value: float) -> None: ...
    @X_Pixels.setter
    def X_Pixels(self, value: int) -> None: ...
    @Y_Field_Width.setter
    def Y_Field_Width(self, value: float) -> None: ...
    @Y_Pixels.setter
    def Y_Pixels(self, value: int) -> None: ...

class IAS_FftMtfvsField(IAS_):
    @property
    def FieldDensity(self) -> int: ...
    @property
    def Freq_1(self) -> float: ...
    @property
    def Freq_2(self) -> float: ...
    @property
    def Freq_3(self) -> float: ...
    @property
    def Freq_4(self) -> float: ...
    @property
    def Freq_5(self) -> float: ...
    @property
    def Freq_6(self) -> float: ...
    @property
    def RemoveVignetting(self) -> bool: ...
    @property
    def SampleSize(self) -> SampleSizes: ...
    @property
    def ScanType(self) -> ScanTypes: ...
    @property
    def UseDashes(self) -> bool: ...
    @property
    def UsePolarization(self) -> bool: ...
    @property
    def Wavelength(self) -> IAS_Wavelength: ...
    @FieldDensity.setter
    def FieldDensity(self, value: int) -> None: ...
    @Freq_1.setter
    def Freq_1(self, value: float) -> None: ...
    @Freq_2.setter
    def Freq_2(self, value: float) -> None: ...
    @Freq_3.setter
    def Freq_3(self, value: float) -> None: ...
    @Freq_4.setter
    def Freq_4(self, value: float) -> None: ...
    @Freq_5.setter
    def Freq_5(self, value: float) -> None: ...
    @Freq_6.setter
    def Freq_6(self, value: float) -> None: ...
    @RemoveVignetting.setter
    def RemoveVignetting(self, value: bool) -> None: ...
    @SampleSize.setter
    def SampleSize(self, value: SampleSizes) -> None: ...
    @ScanType.setter
    def ScanType(self, value: ScanTypes) -> None: ...
    @UseDashes.setter
    def UseDashes(self, value: bool) -> None: ...
    @UsePolarization.setter
    def UsePolarization(self, value: bool) -> None: ...

class IAS_FftSurfaceMtf(IAS_):
    @property
    def Field(self) -> IAS_Field: ...
    @property
    def Rotation(self) -> Rotations: ...
    @property
    def SampleSize(self) -> SampleSizes: ...
    @property
    def ScaleFactor(self) -> float: ...
    @property
    def ShowAs(self) -> ShowAs: ...
    @property
    def Type(self) -> SurfaceMtfTypes: ...
    @property
    def UsePolarization(self) -> bool: ...
    @property
    def Wavelength(self) -> IAS_Wavelength: ...
    @Rotation.setter
    def Rotation(self, value: Rotations) -> None: ...
    @SampleSize.setter
    def SampleSize(self, value: SampleSizes) -> None: ...
    @ScaleFactor.setter
    def ScaleFactor(self, value: float) -> None: ...
    @ShowAs.setter
    def ShowAs(self, value: ShowAs) -> None: ...
    @Type.setter
    def Type(self, value: SurfaceMtfTypes) -> None: ...
    @UsePolarization.setter
    def UsePolarization(self, value: bool) -> None: ...

class IAS_FftThroughFocusMtf(IAS_):
    @property
    def DeltaFocus(self) -> float: ...
    @property
    def Field(self) -> IAS_Field: ...
    @property
    def Frequency(self) -> float: ...
    @property
    def NumberOfSteps(self) -> int: ...
    @property
    def SampleSize(self) -> SampleSizes: ...
    @property
    def Type(self) -> MtfTypes: ...
    @property
    def UseDashes(self) -> bool: ...
    @property
    def UsePolarization(self) -> bool: ...
    @property
    def Wavelength(self) -> IAS_Wavelength: ...
    @DeltaFocus.setter
    def DeltaFocus(self, value: float) -> None: ...
    @Frequency.setter
    def Frequency(self, value: float) -> None: ...
    @NumberOfSteps.setter
    def NumberOfSteps(self, value: int) -> None: ...
    @SampleSize.setter
    def SampleSize(self, value: SampleSizes) -> None: ...
    @Type.setter
    def Type(self, value: MtfTypes) -> None: ...
    @UseDashes.setter
    def UseDashes(self, value: bool) -> None: ...
    @UsePolarization.setter
    def UsePolarization(self, value: bool) -> None: ...

class IAS_GeometricMtf(IAS_):
    @property
    def Field(self) -> IAS_Field: ...
    @property
    def MaximumFrequency(self) -> float: ...
    @property
    def MultiplyByDiffractionLimit(self) -> bool: ...
    @property
    def SampleSize(self) -> SampleSizes: ...
    @property
    def ScatterRays(self) -> bool: ...
    @property
    def UseDashes(self) -> bool: ...
    @property
    def UsePolarization(self) -> bool: ...
    @property
    def Wavelength(self) -> IAS_Wavelength: ...
    @MaximumFrequency.setter
    def MaximumFrequency(self, value: float) -> None: ...
    @MultiplyByDiffractionLimit.setter
    def MultiplyByDiffractionLimit(self, value: bool) -> None: ...
    @SampleSize.setter
    def SampleSize(self, value: SampleSizes) -> None: ...
    @ScatterRays.setter
    def ScatterRays(self, value: bool) -> None: ...
    @UseDashes.setter
    def UseDashes(self, value: bool) -> None: ...
    @UsePolarization.setter
    def UsePolarization(self, value: bool) -> None: ...

class IAS_GeometricMtfMap(IAS_):
    @property
    def Frequency(self) -> float: ...
    @property
    def MTF_DataType(self) -> MtfDataTypes: ...
    @property
    def ReferenceField(self) -> IAS_Field: ...
    @property
    def RemoveVignetting(self) -> bool: ...
    @property
    def SampleSize(self) -> SampleSizes: ...
    @property
    def ScatterRays(self) -> bool: ...
    @property
    def ShowAs(self) -> ShowAsTypes: ...
    @property
    def UsePolarization(self) -> bool: ...
    @property
    def Wavelength(self) -> IAS_Wavelength: ...
    @property
    def X_Field_Width(self) -> float: ...
    @property
    def X_Pixels(self) -> int: ...
    @property
    def Y_Field_Width(self) -> float: ...
    @property
    def Y_Pixels(self) -> int: ...
    @Frequency.setter
    def Frequency(self, value: float) -> None: ...
    @MTF_DataType.setter
    def MTF_DataType(self, value: MtfDataTypes) -> None: ...
    @RemoveVignetting.setter
    def RemoveVignetting(self, value: bool) -> None: ...
    @SampleSize.setter
    def SampleSize(self, value: SampleSizes) -> None: ...
    @ScatterRays.setter
    def ScatterRays(self, value: bool) -> None: ...
    @ShowAs.setter
    def ShowAs(self, value: ShowAsTypes) -> None: ...
    @UsePolarization.setter
    def UsePolarization(self, value: bool) -> None: ...
    @X_Field_Width.setter
    def X_Field_Width(self, value: float) -> None: ...
    @X_Pixels.setter
    def X_Pixels(self, value: int) -> None: ...
    @Y_Field_Width.setter
    def Y_Field_Width(self, value: float) -> None: ...
    @Y_Pixels.setter
    def Y_Pixels(self, value: int) -> None: ...

class IAS_GeometricMtfvsField(IAS_):
    @property
    def FieldDensity(self) -> int: ...
    @property
    def Freq_1(self) -> float: ...
    @property
    def Freq_2(self) -> float: ...
    @property
    def Freq_3(self) -> float: ...
    @property
    def Freq_4(self) -> float: ...
    @property
    def Freq_5(self) -> float: ...
    @property
    def Freq_6(self) -> float: ...
    @property
    def MultiplyByDiffractionLimit(self) -> bool: ...
    @property
    def RemoveVignetting(self) -> bool: ...
    @property
    def SampleSize(self) -> SampleSizes: ...
    @property
    def ScanType(self) -> ScanTypes: ...
    @property
    def ScatterRays(self) -> bool: ...
    @property
    def UseDashes(self) -> bool: ...
    @property
    def UsePolarization(self) -> bool: ...
    @property
    def Wavelength(self) -> IAS_Wavelength: ...
    @FieldDensity.setter
    def FieldDensity(self, value: int) -> None: ...
    @Freq_1.setter
    def Freq_1(self, value: float) -> None: ...
    @Freq_2.setter
    def Freq_2(self, value: float) -> None: ...
    @Freq_3.setter
    def Freq_3(self, value: float) -> None: ...
    @Freq_4.setter
    def Freq_4(self, value: float) -> None: ...
    @Freq_5.setter
    def Freq_5(self, value: float) -> None: ...
    @Freq_6.setter
    def Freq_6(self, value: float) -> None: ...
    @MultiplyByDiffractionLimit.setter
    def MultiplyByDiffractionLimit(self, value: bool) -> None: ...
    @RemoveVignetting.setter
    def RemoveVignetting(self, value: bool) -> None: ...
    @SampleSize.setter
    def SampleSize(self, value: SampleSizes) -> None: ...
    @ScanType.setter
    def ScanType(self, value: ScanTypes) -> None: ...
    @ScatterRays.setter
    def ScatterRays(self, value: bool) -> None: ...
    @UseDashes.setter
    def UseDashes(self, value: bool) -> None: ...
    @UsePolarization.setter
    def UsePolarization(self, value: bool) -> None: ...

class IAS_GeometricThroughFocusMtf(IAS_):
    @property
    def DeltaFocus(self) -> float: ...
    @property
    def Field(self) -> IAS_Field: ...
    @property
    def Frequency(self) -> float: ...
    @property
    def MultiplyByDiffractionLimit(self) -> bool: ...
    @property
    def NumberOfSteps(self) -> int: ...
    @property
    def SampleSize(self) -> SampleSizes: ...
    @property
    def ScatterRays(self) -> bool: ...
    @property
    def UseDashes(self) -> bool: ...
    @property
    def UsePolarization(self) -> bool: ...
    @property
    def Wavelength(self) -> IAS_Wavelength: ...
    @DeltaFocus.setter
    def DeltaFocus(self, value: float) -> None: ...
    @Frequency.setter
    def Frequency(self, value: float) -> None: ...
    @MultiplyByDiffractionLimit.setter
    def MultiplyByDiffractionLimit(self, value: bool) -> None: ...
    @NumberOfSteps.setter
    def NumberOfSteps(self, value: int) -> None: ...
    @SampleSize.setter
    def SampleSize(self, value: SampleSizes) -> None: ...
    @ScatterRays.setter
    def ScatterRays(self, value: bool) -> None: ...
    @UseDashes.setter
    def UseDashes(self, value: bool) -> None: ...
    @UsePolarization.setter
    def UsePolarization(self, value: bool) -> None: ...

class IAS_HuygensMtf(IAS_):
    @property
    def Configuration(self) -> int: ...
    @property
    def Field(self) -> IAS_Field: ...
    @property
    def ImageDelta(self) -> float: ...
    @property
    def ImageSampleSize(self) -> SampleSizes: ...
    @property
    def MaximumFrequency(self) -> float: ...
    @property
    def PupilSampleSize(self) -> SampleSizes: ...
    @property
    def Type(self) -> HuygensMtfTypes: ...
    @property
    def UseDashes(self) -> bool: ...
    @property
    def UsePolarization(self) -> bool: ...
    @property
    def Wavelength(self) -> IAS_Wavelength: ...
    @Configuration.setter
    def Configuration(self, value: int) -> None: ...
    @ImageDelta.setter
    def ImageDelta(self, value: float) -> None: ...
    @ImageSampleSize.setter
    def ImageSampleSize(self, value: SampleSizes) -> None: ...
    @MaximumFrequency.setter
    def MaximumFrequency(self, value: float) -> None: ...
    @PupilSampleSize.setter
    def PupilSampleSize(self, value: SampleSizes) -> None: ...
    @Type.setter
    def Type(self, value: HuygensMtfTypes) -> None: ...
    @UseDashes.setter
    def UseDashes(self, value: bool) -> None: ...
    @UsePolarization.setter
    def UsePolarization(self, value: bool) -> None: ...

class IAS_HuygensMtfvsField(IAS_):
    @property
    def FieldDensity(self) -> int: ...
    @property
    def Freq_1(self) -> float: ...
    @property
    def Freq_2(self) -> float: ...
    @property
    def Freq_3(self) -> float: ...
    @property
    def Freq_4(self) -> float: ...
    @property
    def Freq_5(self) -> float: ...
    @property
    def Freq_6(self) -> float: ...
    @property
    def RemoveVignetting(self) -> bool: ...
    @property
    def SampleSize(self) -> SampleSizes: ...
    @property
    def ScanType(self) -> ScanTypes: ...
    @property
    def UseDashes(self) -> bool: ...
    @property
    def UsePolarization(self) -> bool: ...
    @property
    def Wavelength(self) -> IAS_Wavelength: ...
    @FieldDensity.setter
    def FieldDensity(self, value: int) -> None: ...
    @Freq_1.setter
    def Freq_1(self, value: float) -> None: ...
    @Freq_2.setter
    def Freq_2(self, value: float) -> None: ...
    @Freq_3.setter
    def Freq_3(self, value: float) -> None: ...
    @Freq_4.setter
    def Freq_4(self, value: float) -> None: ...
    @Freq_5.setter
    def Freq_5(self, value: float) -> None: ...
    @Freq_6.setter
    def Freq_6(self, value: float) -> None: ...
    @RemoveVignetting.setter
    def RemoveVignetting(self, value: bool) -> None: ...
    @SampleSize.setter
    def SampleSize(self, value: SampleSizes) -> None: ...
    @ScanType.setter
    def ScanType(self, value: ScanTypes) -> None: ...
    @UseDashes.setter
    def UseDashes(self, value: bool) -> None: ...
    @UsePolarization.setter
    def UsePolarization(self, value: bool) -> None: ...

class IAS_HuygensSurfaceMtf(IAS_):
    @property
    def Configuration(self) -> int: ...
    @property
    def Field(self) -> IAS_Field: ...
    @property
    def ImageDelta(self) -> float: ...
    @property
    def ImageSampleSize(self) -> SampleSizes: ...
    @property
    def PupilSampleSize(self) -> SampleSizes: ...
    @property
    def ShowAs(self) -> HuygensSurfaceMftShowAsTypes: ...
    @property
    def Type(self) -> SurfaceMtfTypes: ...
    @property
    def UsePolarization(self) -> bool: ...
    @property
    def Wavelength(self) -> IAS_Wavelength: ...
    @Configuration.setter
    def Configuration(self, value: int) -> None: ...
    @ImageDelta.setter
    def ImageDelta(self, value: float) -> None: ...
    @ImageSampleSize.setter
    def ImageSampleSize(self, value: SampleSizes) -> None: ...
    @PupilSampleSize.setter
    def PupilSampleSize(self, value: SampleSizes) -> None: ...
    @ShowAs.setter
    def ShowAs(self, value: HuygensSurfaceMftShowAsTypes) -> None: ...
    @Type.setter
    def Type(self, value: SurfaceMtfTypes) -> None: ...
    @UsePolarization.setter
    def UsePolarization(self, value: bool) -> None: ...

class IAS_HuygensThroughFocusMtf(IAS_):
    @property
    def Configuration(self) -> int: ...
    @property
    def DeltaFocus(self) -> float: ...
    @property
    def Field(self) -> IAS_Field: ...
    @property
    def Frequency(self) -> float: ...
    @property
    def ImageDelta(self) -> float: ...
    @property
    def ImageSampleSize(self) -> SampleSizes: ...
    @property
    def NumberOfSteps(self) -> int: ...
    @property
    def PupilSampleSize(self) -> SampleSizes: ...
    @property
    def Type(self) -> HuygensMtfTypes: ...
    @property
    def UseDashes(self) -> bool: ...
    @property
    def UsePolarization(self) -> bool: ...
    @property
    def Wavelength(self) -> IAS_Wavelength: ...
    @Configuration.setter
    def Configuration(self, value: int) -> None: ...
    @DeltaFocus.setter
    def DeltaFocus(self, value: float) -> None: ...
    @Frequency.setter
    def Frequency(self, value: float) -> None: ...
    @ImageDelta.setter
    def ImageDelta(self, value: float) -> None: ...
    @ImageSampleSize.setter
    def ImageSampleSize(self, value: SampleSizes) -> None: ...
    @NumberOfSteps.setter
    def NumberOfSteps(self, value: int) -> None: ...
    @PupilSampleSize.setter
    def PupilSampleSize(self, value: SampleSizes) -> None: ...
    @Type.setter
    def Type(self, value: HuygensMtfTypes) -> None: ...
    @UseDashes.setter
    def UseDashes(self, value: bool) -> None: ...
    @UsePolarization.setter
    def UsePolarization(self, value: bool) -> None: ...

class IAS_NSCGeometricMtf(IAS_):
    @property
    def Detector(self) -> IAS_Detector: ...
    @property
    def Filter(self) -> str: ...
    @property
    def MaximumFrequency(self) -> float: ...
    @property
    def MaximumPlotScale(self) -> float: ...
    @property
    def MinimumPlotScale(self) -> float: ...
    @property
    def RayDatabaseFilename(self) -> str: ...
    @Filter.setter
    def Filter(self, value: str) -> None: ...
    @MaximumFrequency.setter
    def MaximumFrequency(self, value: float) -> None: ...
    @MaximumPlotScale.setter
    def MaximumPlotScale(self, value: float) -> None: ...
    @MinimumPlotScale.setter
    def MinimumPlotScale(self, value: float) -> None: ...
    @RayDatabaseFilename.setter
    def RayDatabaseFilename(self, value: str) -> None: ...

class MtfDataTypes:
    Average = 0
    Tangential = 1
    Sagittal = 2

class MtfTypes:
    Modulation = 0
    Real = 1
    Imaginary = 2
    Phase = 3
    SquareWave = 4

class ShowAsTypes:
    GreyScale = 0
    GreyScaleInverted = 1
    FalseColor = 2
    FalseColorInverted = 3

class SurfaceMtfTypes:
    MTF_Incoherent = 0
    Real_Incoherent = 1
    Imaginary_Incoherent = 2
    MTF_Coherent = 3
    Real_Coherent = 4
    Imaginary_Coherent = 5
