"""
This file provides autocompletions for the ZOS-API and was automatically generated.
It should not be edited manually.
"""

from __future__ import annotations

__all__ = (
    "ICoordinateTransform",
    "ICoordinateTransform",
    "IMatrixData",
    "IMatrixData",
    "IMetadata",
    "IMetadata",
    "ISettingsData",
    "ISettingsData",
    "IVectorData",
    "IVectorData",
    "SettingsDataType",
    "ZemaxColor",
    "ZemaxOpacity",
)

class ICoordinateTransform:
    @property
    def CentroidX(self) -> float: ...
    @property
    def CentroidY(self) -> float: ...
    @property
    def CentroidZ(self) -> float: ...
    @property
    def HasOffset(self) -> bool: ...
    @property
    def HasRotation(self) -> bool: ...
    @property
    def R11(self) -> float: ...
    @property
    def R12(self) -> float: ...
    @property
    def R13(self) -> float: ...
    @property
    def R21(self) -> float: ...
    @property
    def R22(self) -> float: ...
    @property
    def R23(self) -> float: ...
    @property
    def R31(self) -> float: ...
    @property
    def R32(self) -> float: ...
    @property
    def R33(self) -> float: ...
    @property
    def RotationAnglesSpecified(self) -> bool: ...
    @property
    def ThetaX(self) -> float: ...
    @property
    def ThetaY(self) -> float: ...
    @property
    def ThetaZ(self) -> float: ...
    @property
    def XOffset(self) -> float: ...
    @property
    def YOffset(self) -> float: ...
    @property
    def ZOffset(self) -> float: ...
    def GetAngleSet(self) -> list[float]: ...
    def GetDecenterVector(self) -> list[float]: ...
    def GetMatrix_3x3(self) -> list[list[float]]: ...
    def GetMatrix_4x4(self) -> list[list[float]]: ...
    @CentroidX.setter
    def CentroidX(self, value: float) -> None: ...
    @CentroidY.setter
    def CentroidY(self, value: float) -> None: ...
    @CentroidZ.setter
    def CentroidZ(self, value: float) -> None: ...
    @R11.setter
    def R11(self, value: float) -> None: ...
    @R12.setter
    def R12(self, value: float) -> None: ...
    @R13.setter
    def R13(self, value: float) -> None: ...
    @R21.setter
    def R21(self, value: float) -> None: ...
    @R22.setter
    def R22(self, value: float) -> None: ...
    @R23.setter
    def R23(self, value: float) -> None: ...
    @R31.setter
    def R31(self, value: float) -> None: ...
    @R32.setter
    def R32(self, value: float) -> None: ...
    @R33.setter
    def R33(self, value: float) -> None: ...
    @RotationAnglesSpecified.setter
    def RotationAnglesSpecified(self, value: bool) -> None: ...
    @ThetaX.setter
    def ThetaX(self, value: float) -> None: ...
    @ThetaY.setter
    def ThetaY(self, value: float) -> None: ...
    @ThetaZ.setter
    def ThetaZ(self, value: float) -> None: ...
    @XOffset.setter
    def XOffset(self, value: float) -> None: ...
    @YOffset.setter
    def YOffset(self, value: float) -> None: ...
    @ZOffset.setter
    def ZOffset(self, value: float) -> None: ...

class IMatrixData:
    @property
    def Cols(self) -> int: ...
    @property
    def Data(self) -> list[list[float]]: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def Rows(self) -> int: ...
    @property
    def TotalLength(self) -> int: ...
    def GetValueAt(self, Row: int, Col: int) -> float: ...
    def ReadData(self, Size: int) -> tuple[list[float]]: ...
    @Data.setter
    def Data(self, value: list[list[float]]) -> None: ...
    def SetValueAt(self, Row: int, Col: int, Value: float) -> None: ...
    def WriteData(self, Size: int, Data: list[float]) -> None: ...

class IMetadata:
    def ConvertFromBinary(self, data: list[Byte]) -> str: ...
    def ConvertToBinary(self, s: str) -> list[Byte]: ...
    def CreateGuid(self) -> str: ...
    @property
    def NumberOfKeys(self) -> int: ...
    def GetData(self, key: str) -> str: ...
    def GetKeyName(self, keyNumber: int) -> str: ...
    def RemoveData(self, key: str) -> bool: ...
    def SetData(self, key: str, value: str) -> None: ...

class ISettingsData:
    @property
    def NumberOfSettings(self) -> int: ...
    def GetBooleanArray(self, key: str, Size: int) -> tuple[bool, list[bool]]: ...
    def GetBooleanValue(self, key: str) -> tuple[bool, bool]: ...
    def GetByteArray(self, key: str, Size: int) -> tuple[bool, list[Byte]]: ...
    def GetByteValue(self, key: str) -> tuple[bool, Byte]: ...
    def GetDoubleArray(self, key: str, Size: int) -> tuple[bool, list[float]]: ...
    def GetDoubleValue(self, key: str) -> tuple[bool, float]: ...
    def GetEntryType(self, key: str) -> tuple[bool, SettingsDataType, bool, int]: ...
    def GetFloatArray(self, key: str, Size: int) -> tuple[bool, list[float]]: ...
    def GetFloatValue(self, key: str) -> tuple[bool, float]: ...
    def GetIntegerArray(self, key: str, Size: int) -> tuple[bool, list[int]]: ...
    def GetIntegerValue(self, key: str) -> tuple[bool, int]: ...
    def GetKeys(self) -> list[str]: ...
    def GetStringValue(self, key: str) -> tuple[bool, str]: ...
    def SetBooleanArray(self, key: str, Size: int, val: list[bool]) -> None: ...
    def SetBooleanValue(self, key: str, val: bool) -> None: ...
    def SetByteArray(self, key: str, Size: int, val: list[Byte]) -> None: ...
    def SetByteValue(self, key: str, val: Byte) -> None: ...
    def SetDoubleArray(self, key: str, Size: int, val: list[float]) -> None: ...
    def SetDoubleValue(self, key: str, val: float) -> None: ...
    def SetFloatArray(self, key: str, Size: int, val: list[float]) -> None: ...
    def SetFloatValue(self, key: str, val: float) -> None: ...
    def SetIntegerArray(self, key: str, Size: int, val: list[int]) -> None: ...
    def SetIntegerValue(self, key: str, val: int) -> None: ...
    def SetStringValue(self, key: str, val: str) -> None: ...

class IVectorData:
    @property
    def Data(self) -> list[float]: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def Length(self) -> int: ...
    def GetValueAt(self, position: int) -> float: ...
    def ReadData(self, Size: int) -> tuple[list[float]]: ...
    @Data.setter
    def Data(self, value: list[float]) -> None: ...
    def SetValueAt(self, position: int, Value: float) -> None: ...
    def WriteData(self, Size: int, Data: list[float]) -> None: ...

class SettingsDataType:
    # None = 0
    Integer = 1
    Double = 2
    Float = 3
    String = 4
    Byte = 5
    Boolean = 6

class ZemaxColor:
    Default = 0
    Color1 = 1
    Color2 = 2
    Color3 = 3
    Color4 = 4
    Color5 = 5
    Color6 = 6
    Color7 = 7
    Color8 = 8
    Color9 = 9
    Color10 = 10
    Color11 = 11
    Color12 = 12
    Color13 = 13
    Color14 = 14
    Color15 = 15
    Color16 = 16
    Color17 = 17
    Color18 = 18
    Color19 = 19
    Color20 = 20
    Color21 = 21
    Color22 = 22
    Color23 = 23
    Color24 = 24

class ZemaxOpacity:
    P100 = 0
    P90 = 1
    P80 = 2
    P70 = 3
    P60 = 4
    P50 = 5
    P40 = 6
    P30 = 7
    P20 = 8
    P10 = 9
    P00 = 10
