"""
This file provides autocompletions for the ZOS-API and was automatically generated.
It should not be edited manually.
"""

from __future__ import annotations

from zospy.api._ZOSAPI.Analysis import IMessage
from zospy.api._ZOSAPI.Common import (
    ICoordinateTransform,
    IMetadata,
    ZemaxColor,
    ZemaxOpacity,
)
from zospy.api._ZOSAPI.Editors import (
    IEditor,
    IEditorCell,
    IEditorRow,
    ReflectTransmitCode,
    SampleSides,
    Samplings,
)
from zospy.api._ZOSAPI.SystemData import ZemaxApertureType

__all__ = (
    "CoatingStatusType",
    "ConversionOrder",
    "CoordinateConversionResult",
    "CoordinateReturnType",
    "ILDEApertureData",
    "ILDEApertureData",
    "ILDECoatingData",
    "ILDECoatingData",
    "ILDECoatingSettings",
    "ILDECoatingSettings",
    "ILDECompositeData",
    "ILDECompositeData",
    "ILDEDrawData",
    "ILDEDrawData",
    "ILDEImportData",
    "ILDEImportData",
    "ILDEPhysicalOpticsData",
    "ILDEPhysicalOpticsData",
    "ILDERow",
    "ILDEScatteringData",
    "ILDEScatteringData",
    "ILDETiltDecenterData",
    "ILDETiltDecenterData",
    "ILDETool_AddCoatingsToAllSurfaces",
    "ILDETool_AddCoatingsToAllSurfaces",
    "ILDETypeData",
    "ILDETypeData",
    "ILensDataEditor",
    "InterpolationMethod",
    "ISTAR_CoordinateTransform",
    "ISTAR_CoordinateTransform",
    "ISTAR_Data",
    "ISTAR_Data",
    "ISTAR_Decenters",
    "ISTAR_Decenters",
    "ISTAR_Deformation",
    "ISTAR_Deformation",
    "ISTAR_DeformationFits",
    "ISTAR_DeformationFits",
    "ISTAR_Deformations",
    "ISTAR_Deformations",
    "ISTAR_DeformationsFEAData",
    "ISTAR_DeformationsFEAData",
    "ISTAR_FEAFitResults",
    "ISTAR_FEAFitResults",
    "ISTAR_FEAFitSettings",
    "ISTAR_FEAFitSettings",
    "ISTAR_PointWithDeformation",
    "ISTAR_PointWithDeformation",
    "ISTAR_PointWithDeformationAndWeight",
    "ISTAR_PointWithDeformationAndWeight",
    "ISTAR_PointWithTemperatureAndIndex",
    "ISTAR_PointWithTemperatureAndIndex",
    "ISTAR_RBM_Centroid",
    "ISTAR_RBM_Centroid",
    "ISTAR_RBM_ReferencePoint",
    "ISTAR_RBM_ReferencePoint",
    "ISTAR_RBMs",
    "ISTAR_RBMs",
    "ISTAR_RotationAngles",
    "ISTAR_RotationAngles",
    "ISTAR_Rotations",
    "ISTAR_Rotations",
    "ISTAR_RotationValues",
    "ISTAR_RotationValues",
    "ISTAR_Temperatures",
    "ISTAR_Temperatures",
    "ISTAR_TemperaturesFEAData",
    "ISTAR_TemperaturesFEAData",
    "ISTAR_TemperaturesFits",
    "ISTAR_TemperaturesFits",
    "ISurface",
    "ISurface",
    "ISurfaceABCD",
    "ISurfaceAlternateEven",
    "ISurfaceAlternateOdd",
    "ISurfaceAnnularZernikeSag",
    "ISurfaceAPBC",
    "ISurfaceApertureCircular",
    "ISurfaceApertureElliptical",
    "ISurfaceApertureFloating",
    "ISurfaceApertureNone",
    "ISurfaceApertureRectangular",
    "ISurfaceApertureSpider",
    "ISurfaceApertureType",
    "ISurfaceApertureType",
    "ISurfaceApertureUser",
    "ISurfaceAtmospheric",
    "ISurfaceBiconic",
    "ISurfaceBiconicZernike",
    "ISurfaceBinary1",
    "ISurfaceBinary2",
    "ISurfaceBinary3",
    "ISurfaceBinary4",
    "ISurfaceBirefringentIn",
    "ISurfaceBirefringentOut",
    "ISurfaceBlackBoxLens",
    "ISurfaceChebyShv",
    "ISurfaceCoeff_P_NthEvenPower",
    "ISurfaceCoeff_P_NthPower",
    "ISurfaceCoeff_R_NthEvenPower",
    "ISurfaceCoeff_R_NthPower",
    "ISurfaceCoeff_X_NthEvenPower",
    "ISurfaceCoeff_X_NthEvenPower_8",
    "ISurfaceCoeff_X1P1X2P2_NthEvenPower",
    "ISurfaceCoeff_Y_NthEvenPower",
    "ISurfaceCoeff_Y_NthEvenPower_8",
    "ISurfaceConjugate",
    "ISurfaceCoordinateBreak",
    "ISurfaceCubicSpline",
    "ISurfaceCylinderFrensel",
    "ISurfaceCylinderFresnel",
    "ISurfaceData",
    "ISurfaceDiffractionGrating",
    "ISurfaceEllipticalGrating1",
    "ISurfaceEllipticalGrating2",
    "ISurfaceEvenAspheric",
    "ISurfaceExtendedAsphere",
    "ISurfaceExtendedCubicSpline",
    "ISurfaceExtendedFresnel",
    "ISurfaceExtendedOddAsphere",
    "ISurfaceExtendedPolynomial",
    "ISurfaceExtendedToroidalGrating",
    "ISurfaceFreeformNthZernike",
    "ISurfaceFreeformXYPolynomial",
    "ISurfaceFresnel",
    "ISurfaceGeneralizedFresnel",
    "ISurfaceGradient1",
    "ISurfaceGradient10",
    "ISurfaceGradient12",
    "ISurfaceGradient2",
    "ISurfaceGradient3",
    "ISurfaceGradient4",
    "ISurfaceGradient5",
    "ISurfaceGradient6",
    "ISurfaceGradient7",
    "ISurfaceGradient9",
    "ISurfaceGradium",
    "ISurfaceGridGradient",
    "ISurfaceGridPhase",
    "ISurfaceGridSag",
    "ISurfaceHologram1",
    "ISurfaceHologram2",
    "ISurfaceIrregular",
    "ISurfaceJonesMatrix",
    "ISurfaceNonSequential",
    "ISurfaceNthEvenOrderTerms",
    "ISurfaceNthOrderTerms",
    "ISurfaceNthThickness",
    "ISurfaceNthZernike",
    "ISurfaceOddAsphere",
    "ISurfaceOddCosine",
    "ISurfaceOffAxisConicFreeform",
    "ISurfaceOpticallyFabricatedHologram",
    "ISurfaceParaxial",
    "ISurfaceParaxialXY",
    "ISurfacePeriodic",
    "ISurfacePolynomial",
    "ISurfaceQTypeAsphere",
    "ISurfaceQTypeFreeform",
    "ISurfaceRadialGrating",
    "ISurfaceRadialNurbs",
    "ISurfaceRetroReflect",
    "ISurfaceScatteringABg",
    "ISurfaceScatteringABgFile",
    "ISurfaceScatteringBSDF",
    "ISurfaceScatteringCatalog",
    "ISurfaceScatteringGaussian",
    "ISurfaceScatteringLambertian",
    "ISurfaceScatteringNone",
    "ISurfaceScatteringType",
    "ISurfaceScatteringType",
    "ISurfaceScatteringUser",
    "ISurfaceSlide",
    "ISurfaceStandard",
    "ISurfaceSuperconic",
    "ISurfaceTilted",
    "ISurfaceToroidal",
    "ISurfaceToroidalGrat",
    "ISurfaceToroidalHologram",
    "ISurfaceToroidalNurbs",
    "ISurfaceTrueFreeform",
    "ISurfaceTypeSettings",
    "ISurfaceTypeSettings",
    "ISurfaceVariableLineSpaceGrating",
    "ISurfaceXYPolynomial",
    "ISurfaceZernikeAnnularPhase",
    "ISurfaceZernikeFringePhase",
    "ISurfaceZernikeFringeSag",
    "ISurfaceZernikeStandardPhase",
    "ISurfaceZernikeStandardSag",
    "ISurfaceZonePlate",
    "NodesDataType",
    "PilotRadiusMode",
    "PointCloudFileFormat",
    "PupilApodizationType",
    "QTypes",
    "STARDeformationOption",
    "SubstrateType",
    "SurfaceApertureTypes",
    "SurfaceColumn",
    "SurfaceEdgeDraw",
    "SurfaceScatteringTypes",
    "SurfaceType",
    "TiltDecenterOrderType",
    "TiltDecenterPickupType",
    "TiltType",
    "XYSampling",
)

class CoatingStatusType:
    Fixed = 0
    Variable = 1
    Pickup = 2

class ConversionOrder:
    Forward = 0
    Reverse = 1

class CoordinateConversionResult:
    Success = 0
    Error_MultiConfig = -5
    Error_TiltDecenter = -4
    Error_IgnoredSurface = -3
    Error_CoordianteBreak = -2
    Error_InvalidRange = -1

class CoordinateReturnType:
    # None = 0
    OrientationOnly = 1
    OrientationXY = 2
    OrientationXYZ = 3

class ILDEApertureData:
    def ChangeApertureTypeSettings(self, settings: ISurfaceApertureType) -> bool: ...
    def CreateApertureTypeSettings(self, type: SurfaceApertureTypes) -> ISurfaceApertureType: ...
    @property
    def CurrentType(self) -> SurfaceApertureTypes: ...
    @property
    def CurrentTypeSettings(self) -> ISurfaceApertureType: ...
    @property
    def DisableClearSemiDiameterMarginsForThisSurface(self) -> bool: ...
    @property
    def IsPickedUp(self) -> bool: ...
    @property
    def PickupFrom(self) -> int: ...
    @DisableClearSemiDiameterMarginsForThisSurface.setter
    def DisableClearSemiDiameterMarginsForThisSurface(self, value: bool) -> None: ...
    @PickupFrom.setter
    def PickupFrom(self, value: int) -> None: ...
    def SetPickupNone(self) -> None: ...

class ILDECoatingData:
    @property
    def Coating(self) -> str: ...
    @property
    def NumberOfLayers(self) -> int: ...
    @property
    def UseLayerMultiplierAndOffsets(self) -> bool: ...
    def GetAvailableCoatings(self) -> list[str]: ...
    def GetLayerSettings(self, Layer: int) -> ILDECoatingSettings: ...
    @Coating.setter
    def Coating(self, value: str) -> None: ...
    @UseLayerMultiplierAndOffsets.setter
    def UseLayerMultiplierAndOffsets(self, value: bool) -> None: ...
    def SetAllExtinctionFixed(self) -> None: ...
    def SetAllExtinctionVariable(self) -> None: ...
    def SetAllExtinctionZero(self) -> None: ...
    def SetAllIndexFixed(self) -> None: ...
    def SetAllIndexVariable(self) -> None: ...
    def SetAllIndexZero(self) -> None: ...
    def SetAllThicknessFixed(self) -> None: ...
    def SetAllThicknessOne(self) -> None: ...
    def SetAllThicknessVariable(self) -> None: ...
    def SetLayerSettings(self, Layer: int, settings: ILDECoatingSettings) -> bool: ...

class ILDECoatingSettings:
    @property
    def ExtinctionOffset(self) -> float: ...
    @property
    def ExtinctionPickupFrom(self) -> int: ...
    @property
    def ExtinctionStatus(self) -> CoatingStatusType: ...
    @property
    def IndexOffset(self) -> float: ...
    @property
    def IndexPickupFrom(self) -> int: ...
    @property
    def IndexStatus(self) -> CoatingStatusType: ...
    @property
    def Layer(self) -> int: ...
    @property
    def ThicknessMultiplier(self) -> float: ...
    @property
    def ThicknessPickupFrom(self) -> int: ...
    @property
    def ThicknessStatus(self) -> CoatingStatusType: ...
    @ExtinctionOffset.setter
    def ExtinctionOffset(self, value: float) -> None: ...
    @IndexOffset.setter
    def IndexOffset(self, value: float) -> None: ...
    @ThicknessMultiplier.setter
    def ThicknessMultiplier(self, value: float) -> None: ...
    def SetExtinctionStatusFixed(self) -> None: ...
    def SetExtinctionStatusPickup(self, fromLayer: int) -> bool: ...
    def SetExtinctionStatusVariable(self) -> None: ...
    def SetIndexStatusFixed(self) -> None: ...
    def SetIndexStatusPickup(self, fromLayer: int) -> bool: ...
    def SetIndexStatusVariable(self) -> None: ...
    def SetThicknessStatusFixed(self) -> None: ...
    def SetThicknessStatusPickup(self, fromLayer: int) -> bool: ...
    def SetThicknessStatusVariable(self) -> None: ...

class ILDECompositeData:
    @property
    def IsCompositeSurface(self) -> bool: ...
    @IsCompositeSurface.setter
    def IsCompositeSurface(self, value: bool) -> None: ...
    def SetOffAxisTiltAndDecenter(self) -> None: ...

class ILDEDrawData:
    @property
    def DoNotDrawEdgesFromThisSurface(self) -> bool: ...
    @property
    def DoNotDrawThisSurface(self) -> bool: ...
    @property
    def DrawEdgesAs(self) -> SurfaceEdgeDraw: ...
    @property
    def DrawLocalAxis(self) -> bool: ...
    @property
    def HasMirrorSettings(self) -> bool: ...
    @property
    def HideRaysToThisSurface(self) -> bool: ...
    @property
    def MirrorSubstrate(self) -> SubstrateType: ...
    @property
    def MirrorThickness(self) -> float: ...
    @property
    def SkipRaysToThisSurface(self) -> bool: ...
    @DoNotDrawEdgesFromThisSurface.setter
    def DoNotDrawEdgesFromThisSurface(self, value: bool) -> None: ...
    @DoNotDrawThisSurface.setter
    def DoNotDrawThisSurface(self, value: bool) -> None: ...
    @DrawEdgesAs.setter
    def DrawEdgesAs(self, value: SurfaceEdgeDraw) -> None: ...
    @DrawLocalAxis.setter
    def DrawLocalAxis(self, value: bool) -> None: ...
    @HideRaysToThisSurface.setter
    def HideRaysToThisSurface(self, value: bool) -> None: ...
    @MirrorSubstrate.setter
    def MirrorSubstrate(self, value: SubstrateType) -> None: ...
    @MirrorThickness.setter
    def MirrorThickness(self, value: float) -> None: ...
    @SkipRaysToThisSurface.setter
    def SkipRaysToThisSurface(self, value: bool) -> None: ...

class ILDEImportData:
    def CopyImportDataFrom(self, source: ILDEImportData) -> bool: ...
    @property
    def DefaultImportDirectory(self) -> str: ...
    def GetImportFiles(self, directory: str) -> list[str]: ...
    def ImportDataFile(self, dataFile: str) -> bool: ...

class ILDEPhysicalOpticsData:
    @property
    def AutoResample(self) -> bool: ...
    @property
    def DoNotRescaleBeamSizeUsingRayData(self) -> bool: ...
    @property
    def DrawThisLensOnShadedModel(self) -> bool: ...
    @property
    def OutputPilotRadius(self) -> PilotRadiusMode: ...
    @property
    def ReComputePilotBeamParameters(self) -> bool: ...
    @property
    def ResampleAfterRefraction(self) -> bool: ...
    @property
    def UseAngularSpectrumPropagator(self) -> bool: ...
    @property
    def UseRaysToPropagateToNextSurface(self) -> bool: ...
    @property
    def UseXaxisReference(self) -> bool: ...
    @property
    def XRadius(self) -> float: ...
    @property
    def XSampling(self) -> XYSampling: ...
    @property
    def XWidth(self) -> float: ...
    @property
    def YRadius(self) -> float: ...
    @property
    def YSampling(self) -> XYSampling: ...
    @property
    def YWidth(self) -> float: ...
    @AutoResample.setter
    def AutoResample(self, value: bool) -> None: ...
    @DoNotRescaleBeamSizeUsingRayData.setter
    def DoNotRescaleBeamSizeUsingRayData(self, value: bool) -> None: ...
    @DrawThisLensOnShadedModel.setter
    def DrawThisLensOnShadedModel(self, value: bool) -> None: ...
    @OutputPilotRadius.setter
    def OutputPilotRadius(self, value: PilotRadiusMode) -> None: ...
    @ReComputePilotBeamParameters.setter
    def ReComputePilotBeamParameters(self, value: bool) -> None: ...
    @ResampleAfterRefraction.setter
    def ResampleAfterRefraction(self, value: bool) -> None: ...
    @UseAngularSpectrumPropagator.setter
    def UseAngularSpectrumPropagator(self, value: bool) -> None: ...
    @UseRaysToPropagateToNextSurface.setter
    def UseRaysToPropagateToNextSurface(self, value: bool) -> None: ...
    @UseXaxisReference.setter
    def UseXaxisReference(self, value: bool) -> None: ...
    @XRadius.setter
    def XRadius(self, value: float) -> None: ...
    @XSampling.setter
    def XSampling(self, value: XYSampling) -> None: ...
    @XWidth.setter
    def XWidth(self, value: float) -> None: ...
    @YRadius.setter
    def YRadius(self, value: float) -> None: ...
    @YSampling.setter
    def YSampling(self, value: XYSampling) -> None: ...
    @YWidth.setter
    def YWidth(self, value: float) -> None: ...

class ILDERow(IEditorRow):
    def AvailableSurfaceTypes(self) -> list[SurfaceType]: ...
    def ChangeType(self, settings: ISurfaceTypeSettings) -> bool: ...
    @property
    def ApertureData(self) -> ILDEApertureData: ...
    @property
    def ChipZone(self) -> float: ...
    @property
    def ChipZoneCell(self) -> IEditorCell: ...
    @property
    def Coating(self) -> str: ...
    @property
    def CoatingCell(self) -> IEditorCell: ...
    @property
    def CoatingData(self) -> ILDECoatingData: ...
    @property
    def Comment(self) -> str: ...
    @property
    def CommentCell(self) -> IEditorCell: ...
    @property
    def CompositeData(self) -> ILDECompositeData: ...
    @property
    def Conic(self) -> float: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def CurrentTypeSettings(self) -> ISurfaceTypeSettings: ...
    @property
    def DrawData(self) -> ILDEDrawData: ...
    @property
    def ImportData(self) -> ILDEImportData: ...
    @property
    def IsActive(self) -> bool: ...
    @property
    def IsImage(self) -> bool: ...
    @property
    def IsObject(self) -> bool: ...
    @property
    def IsStop(self) -> bool: ...
    @property
    def Material(self) -> str: ...
    @property
    def MaterialCatalog(self) -> str: ...
    @property
    def MaterialCell(self) -> IEditorCell: ...
    @property
    def MechanicalSemiDiameter(self) -> float: ...
    @property
    def MechanicalSemiDiameterCell(self) -> IEditorCell: ...
    @property
    def PhysicalOpticsData(self) -> ILDEPhysicalOpticsData: ...
    @property
    def Radius(self) -> float: ...
    @property
    def RadiusCell(self) -> IEditorCell: ...
    @property
    def ScatteringData(self) -> ILDEScatteringData: ...
    @property
    def SemiDiameter(self) -> float: ...
    @property
    def SemiDiameterCell(self) -> IEditorCell: ...
    @property
    def STARData(self) -> ISTAR_Data: ...
    @property
    def SurfaceData(self) -> ISurface: ...
    @property
    def SurfaceId(self) -> int: ...
    @property
    def SurfaceNumber(self) -> int: ...
    @property
    def TCE(self) -> float: ...
    @property
    def TCECell(self) -> IEditorCell: ...
    @property
    def Thickness(self) -> float: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def TiltDecenterData(self) -> ILDETiltDecenterData: ...
    @property
    def Type(self) -> SurfaceType: ...
    @property
    def TypeData(self) -> ILDETypeData: ...
    @property
    def TypeName(self) -> str: ...
    def GetMetadata(self) -> IMetadata: ...
    def GetSurfaceCell(self, Col: SurfaceColumn) -> IEditorCell: ...
    def GetSurfaceTypeSettings(self, type: SurfaceType) -> ISurfaceTypeSettings: ...
    @ChipZone.setter
    def ChipZone(self, value: float) -> None: ...
    @Coating.setter
    def Coating(self, value: str) -> None: ...
    @Comment.setter
    def Comment(self, value: str) -> None: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @IsStop.setter
    def IsStop(self, value: bool) -> None: ...
    @Material.setter
    def Material(self, value: str) -> None: ...
    @MechanicalSemiDiameter.setter
    def MechanicalSemiDiameter(self, value: float) -> None: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    @SemiDiameter.setter
    def SemiDiameter(self, value: float) -> None: ...
    @TCE.setter
    def TCE(self, value: float) -> None: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...

class ILDEScatteringData:
    def ChangeScatteringTypeSettings(self, settings: ISurfaceScatteringType) -> bool: ...
    def CreateScatteringTypeSettings(self, type: SurfaceScatteringTypes) -> ISurfaceScatteringType: ...
    @property
    def CurrentType(self) -> SurfaceScatteringTypes: ...
    @property
    def CurrentTypeSettings(self) -> ISurfaceScatteringType: ...

class ILDETiltDecenterData:
    @property
    def AfterSurfaceDecenterX(self) -> float: ...
    @property
    def AfterSurfaceDecenterY(self) -> float: ...
    @property
    def AfterSurfaceMode(self) -> TiltDecenterPickupType: ...
    @property
    def AfterSurfaceModeSurface(self) -> int: ...
    @property
    def AfterSurfaceModeSurfaceIsThis(self) -> bool: ...
    @property
    def AfterSurfaceOrder(self) -> TiltDecenterOrderType: ...
    @property
    def AfterSurfaceTiltX(self) -> float: ...
    @property
    def AfterSurfaceTiltY(self) -> float: ...
    @property
    def AfterSurfaceTiltZ(self) -> float: ...
    @property
    def BeforeAfterSurfaceEnabled(self) -> bool: ...
    @property
    def BeforeSurfaceDecenterX(self) -> float: ...
    @property
    def BeforeSurfaceDecenterY(self) -> float: ...
    @property
    def BeforeSurfaceOrder(self) -> TiltDecenterOrderType: ...
    @property
    def BeforeSurfaceTiltX(self) -> float: ...
    @property
    def BeforeSurfaceTiltY(self) -> float: ...
    @property
    def BeforeSurfaceTiltZ(self) -> float: ...
    @property
    def CoordinateReturn(self) -> CoordinateReturnType: ...
    @property
    def CoordinateReturnEnabled(self) -> bool: ...
    @property
    def CoordinateReturnToSurface(self) -> int: ...
    @AfterSurfaceDecenterX.setter
    def AfterSurfaceDecenterX(self, value: float) -> None: ...
    @AfterSurfaceDecenterY.setter
    def AfterSurfaceDecenterY(self, value: float) -> None: ...
    @AfterSurfaceOrder.setter
    def AfterSurfaceOrder(self, value: TiltDecenterOrderType) -> None: ...
    @AfterSurfaceTiltX.setter
    def AfterSurfaceTiltX(self, value: float) -> None: ...
    @AfterSurfaceTiltY.setter
    def AfterSurfaceTiltY(self, value: float) -> None: ...
    @AfterSurfaceTiltZ.setter
    def AfterSurfaceTiltZ(self, value: float) -> None: ...
    @BeforeSurfaceDecenterX.setter
    def BeforeSurfaceDecenterX(self, value: float) -> None: ...
    @BeforeSurfaceDecenterY.setter
    def BeforeSurfaceDecenterY(self, value: float) -> None: ...
    @BeforeSurfaceOrder.setter
    def BeforeSurfaceOrder(self, value: TiltDecenterOrderType) -> None: ...
    @BeforeSurfaceTiltX.setter
    def BeforeSurfaceTiltX(self, value: float) -> None: ...
    @BeforeSurfaceTiltY.setter
    def BeforeSurfaceTiltY(self, value: float) -> None: ...
    @BeforeSurfaceTiltZ.setter
    def BeforeSurfaceTiltZ(self, value: float) -> None: ...
    @CoordinateReturn.setter
    def CoordinateReturn(self, value: CoordinateReturnType) -> None: ...
    @CoordinateReturnToSurface.setter
    def CoordinateReturnToSurface(self, value: int) -> None: ...
    def SetAfterSurfaceModeExplicit(self) -> None: ...
    def SetAfterSurfaceModePickup(self, fromSurface: int) -> bool: ...
    def SetAfterSurfaceModePickupThis(self) -> bool: ...
    def SetAfterSurfaceModeReverse(self, fromSurface: int) -> bool: ...
    def SetAfterSurfaceModeReverseThis(self) -> bool: ...

class ILDETool_AddCoatingsToAllSurfaces:
    @property
    def AvailableCoatings(self) -> list[str]: ...
    @property
    def CoatingToAdd(self) -> str: ...
    @CoatingToAdd.setter
    def CoatingToAdd(self, value: str) -> None: ...

class ILDETypeData:
    @property
    def CanBeGCR(self) -> bool: ...
    @property
    def CanBeStop(self) -> bool: ...
    @property
    def IgnoreSurface(self) -> bool: ...
    @property
    def IsGlobalCoordinateReference(self) -> bool: ...
    @property
    def IsStop(self) -> bool: ...
    @property
    def RowColor(self) -> ZemaxColor: ...
    @property
    def SurfaceCannotBeHyperhemispheric(self) -> bool: ...
    @property
    def SurfaceColor(self) -> ZemaxColor: ...
    @property
    def SurfaceOpacity(self) -> ZemaxOpacity: ...
    @IgnoreSurface.setter
    def IgnoreSurface(self, value: bool) -> None: ...
    @IsGlobalCoordinateReference.setter
    def IsGlobalCoordinateReference(self, value: bool) -> None: ...
    @IsStop.setter
    def IsStop(self, value: bool) -> None: ...
    @RowColor.setter
    def RowColor(self, value: ZemaxColor) -> None: ...
    @SurfaceCannotBeHyperhemispheric.setter
    def SurfaceCannotBeHyperhemispheric(self, value: bool) -> None: ...
    @SurfaceColor.setter
    def SurfaceColor(self, value: ZemaxColor) -> None: ...
    @SurfaceOpacity.setter
    def SurfaceOpacity(self, value: ZemaxOpacity) -> None: ...

class ILensDataEditor(IEditor):
    def AddSurface(self) -> ILDERow: ...
    def CanConvertSurfaceToFreeform(self, fromSurface: int) -> bool: ...
    def CanExportPointCloud(self, Surface: int) -> bool: ...
    def CopySurfaces(self, fromSurfaceNumber: int, NumberOfSurfaces: int, toSurfaceNumber: int) -> int: ...
    def CopySurfacesFrom(
        self, fromEditor: ILensDataEditor, fromSurfaceNumber: int, NumberOfSurfaces: int, toSurfaceNumber: int
    ) -> int: ...
    def FindLabel(self, label: int) -> tuple[bool, int]: ...
    @property
    def FirstColumn(self) -> SurfaceColumn: ...
    @property
    def LastColumn(self) -> SurfaceColumn: ...
    @property
    def NumberOfNonSequentialSurfaces(self) -> int: ...
    @property
    def NumberOfSurfaces(self) -> int: ...
    @property
    def RowToSurfaceOffset(self) -> int: ...
    @property
    def StopSurface(self) -> int: ...
    def GetApodization(self, px: float, py: float) -> float: ...
    def GetClosestGlass(self, Surface: int) -> str: ...
    def GetFirstOrderData(self) -> tuple[float, float, float, float, float]: ...
    def GetGlass(self, Surface: int) -> tuple[bool, str, float, float, float]: ...
    def GetGlobalMatrix(
        self, Surface: int
    ) -> tuple[bool, float, float, float, float, float, float, float, float, float, float, float, float]: ...
    def GetId(self, surface: int) -> int: ...
    def GetIndex(self, Surface: int, NumberOfWavelengths: int) -> tuple[int, list[float]]: ...
    def GetLabel(self, Surface: int) -> tuple[bool, int]: ...
    def GetPupil(self) -> tuple[ZemaxApertureType, float, float, float, float, float, PupilApodizationType, float]: ...
    def GetSag(self, Surface: int, X: float, Y: float) -> tuple[bool, float, float]: ...
    def GetSurfaceAt(self, SurfaceNumber: int) -> ILDERow: ...
    def GetTool_AddCoatingsToAllSurfaces(self) -> ILDETool_AddCoatingsToAllSurfaces: ...
    def HideLDE(self) -> None: ...
    def InsertNewSurfaceAt(self, SurfaceNumber: int) -> ILDERow: ...
    def RemoveSurfaceAt(self, SurfaceNumber: int) -> bool: ...
    def RemoveSurfacesAt(self, SurfaceNumber: int, numSurfaces: int) -> int: ...
    def RunTool_AddCoatingsToAllSurfaces(self, settings: ILDETool_AddCoatingsToAllSurfaces) -> None: ...
    def RunTool_AddFoldMirror(self, Surface: int, tilt: TiltType, reflectAngle: float) -> IMessage: ...
    def RunTool_ConvertGlobalToLocalCoordinates(
        self, FirstSurface: int, LastSurface: int, order: ConversionOrder
    ) -> CoordinateConversionResult: ...
    def RunTool_ConvertLocalToGlobalCoordinates(
        self, FirstSurface: int, LastSurface: int, referenceSurface: int
    ) -> CoordinateConversionResult: ...
    def RunTool_ConvertSemiDiametersToCircularApertures(self) -> None: ...
    def RunTool_ConvertSemiDiametersToFloatingApertures(self) -> None: ...
    def RunTool_ConvertSemiDiametersToMaximumApertures(self) -> None: ...
    def RunTool_ConvertSurfaceInPlaceToFreeform(
        self, fromSurface: int, gridNx: int, gridNy: int, limitToClearAperture: bool
    ) -> IMessage: ...
    def RunTool_ConvertSurfaceToFreeform(
        self, fromSurface: int, freeformSurface: int, gridNx: int, gridNy: int, limitToClearAperture: bool
    ) -> IMessage: ...
    def RunTool_DeleteFoldMirror(self, foldSurface: int) -> IMessage: ...
    def RunTool_ExportPointCloudFile(
        self,
        Surface: int,
        filename: str,
        gridNx: int,
        gridNy: int,
        includeSurfaceNormals: bool,
        format: PointCloudFileFormat,
    ) -> IMessage: ...
    def RunTool_MakeDoublePass(self, reflectAtSurface: int) -> IMessage: ...
    def RunTool_MakeFocal(self, focalLength: float) -> IMessage: ...
    def RunTool_RemoveAllApertures(self) -> None: ...
    def RunTool_ReplaceVignettingWithApertures(self) -> None: ...
    def RunTool_ReverseElements(self, firstSurface: int, lastSurface: int) -> IMessage: ...
    def SetLabel(self, Surface: int, label: int) -> bool: ...
    def ShowLDE(self) -> bool: ...

class InterpolationMethod:
    BicubicSpline = 0
    Linear = 1

class ISTAR_CoordinateTransform:
    def ConvertAnglesToRotationMatrix(self, thetaX: float, thetaY: float, thetaZ: float) -> list[list[float]]: ...
    def Disable(self) -> None: ...
    def Enable(self) -> None: ...
    @property
    def Decenters(self) -> ISTAR_Decenters: ...
    @property
    def IsEnabled(self) -> bool: ...
    @property
    def Rotations(self) -> ISTAR_Rotations: ...
    @property
    def SurfaceNumber(self) -> int: ...
    @property
    def Transform(self) -> ICoordinateTransform: ...
    def IsInDefaultFrameOfReference(self) -> bool: ...
    def ResetToDefaultFrameOfReference(self) -> None: ...
    def SetDecenter(self, DX: float, DY: float, DZ: float) -> None: ...
    def SetRotationMatrix(
        self, R11: float, R12: float, R13: float, R21: float, R22: float, R23: float, R31: float, R32: float, R33: float
    ) -> None: ...
    def SetTransformValues(
        self,
        R11: float,
        R12: float,
        R13: float,
        R21: float,
        R22: float,
        R23: float,
        R31: float,
        R32: float,
        R33: float,
        DX: float,
        DY: float,
        DZ: float,
    ) -> None: ...
    def SetTransformValuesWithAngles(
        self, ThetaX: float, ThetaY: float, ThetaZ: float, DX: float, DY: float, DZ: float
    ) -> None: ...

class ISTAR_Data:
    @property
    def Deformations(self) -> ISTAR_Deformations: ...
    @property
    def SurfaceNumber(self) -> int: ...
    @property
    def Temperatures(self) -> ISTAR_Temperatures: ...

class ISTAR_Decenters:
    @property
    def X(self) -> float: ...
    @property
    def Y(self) -> float: ...
    @property
    def Z(self) -> float: ...

class ISTAR_Deformation:
    @property
    def DX(self) -> float: ...
    @property
    def DY(self) -> float: ...
    @property
    def DZ(self) -> float: ...
    @DX.setter
    def DX(self, value: float) -> None: ...
    @DY.setter
    def DY(self, value: float) -> None: ...
    @DZ.setter
    def DZ(self, value: float) -> None: ...

class ISTAR_DeformationFits:
    @property
    def FitResultsAverage(self) -> ISTAR_FEAFitResults: ...
    @property
    def FitResultsDX(self) -> ISTAR_FEAFitResults: ...
    @property
    def FitResultsDY(self) -> ISTAR_FEAFitResults: ...
    @property
    def FitResultsDZ(self) -> ISTAR_FEAFitResults: ...
    @property
    def IsSurfaceDeformationEnabled(self) -> bool: ...
    @property
    def Options(self) -> STARDeformationOption: ...
    @property
    def Settings(self) -> ISTAR_FEAFitSettings: ...
    @property
    def SurfaceNumber(self) -> int: ...
    def GetFittedDeformation_1(
        self, X: float, Y: float, option: STARDeformationOption
    ) -> ISTAR_PointWithDeformation: ...
    def ListFittedDeformationSafe_1(
        self, xCoor: list[float], yCoor: list[float], option: STARDeformationOption
    ) -> list[ISTAR_PointWithDeformation]: ...
    def MeshFittedDeformationSafe_1(
        self,
        num_X_pts: int,
        num_Y_pts: int,
        X1_edge: float,
        Y1_edge: float,
        X2_edge: float,
        Y2_edge: float,
        option: STARDeformationOption,
    ) -> list[ISTAR_PointWithDeformation]: ...
    def Refit(self) -> None: ...
    @Options.setter
    def Options(self, value: STARDeformationOption) -> None: ...

class ISTAR_Deformations:
    @property
    def CoordinateTransform(self) -> ISTAR_CoordinateTransform: ...
    @property
    def FEAData(self) -> ISTAR_DeformationsFEAData: ...
    @property
    def Fits(self) -> ISTAR_DeformationFits: ...
    @property
    def RBMs(self) -> ISTAR_RBMs: ...
    @property
    def SurfaceNumber(self) -> int: ...
    def IsDataLocalCS(self) -> bool: ...
    def SetDataIsGlobal(self) -> None: ...
    def SetDataIsLocal(self) -> None: ...

class ISTAR_DeformationsFEAData:
    @property
    def AreDeformationsImported(self) -> bool: ...
    @property
    def Filename(self) -> str: ...
    @property
    def NumberOfDataPoints(self) -> int: ...
    @property
    def SurfaceNumber(self) -> int: ...
    def GetFEAPointsSafe(self) -> list[ISTAR_PointWithDeformation]: ...
    def GetFEAPointsSafeOld(self) -> list[ISTAR_PointWithDeformation]: ...
    def GetFEAPointsWithAutoWeightsSafe(self, weightVariation: int) -> list[ISTAR_PointWithDeformationAndWeight]: ...
    def GetTransformedFEAPointsSafe(self, coordinateOption: int) -> list[ISTAR_PointWithDeformation]: ...
    def GetTransformValues(self, transformType: int) -> ICoordinateTransform: ...
    def ImportDeformations(self, filename: str) -> None: ...
    def UnloadData(self) -> None: ...

class ISTAR_FEAFitResults:
    @property
    def FitAccuracy(self) -> float: ...
    @property
    def FitAverage(self) -> float: ...
    @property
    def FitFill(self) -> float: ...
    @property
    def FitLevels(self) -> float: ...
    @property
    def FitNorm(self) -> float: ...
    @property
    def FitPV(self) -> float: ...
    @property
    def FitRMS(self) -> float: ...
    @property
    def Points(self) -> float: ...

class ISTAR_FEAFitSettings:
    @property
    def Grid1(self) -> int: ...
    @property
    def Grid2(self) -> int: ...
    @property
    def Grid3(self) -> int: ...
    @property
    def MBAMaxLevel(self) -> int: ...
    @property
    def MBAMinFill(self) -> float: ...
    @property
    def MBATol(self) -> float: ...
    @property
    def SurfaceNumber(self) -> int: ...
    @property
    def Type(self) -> int: ...
    @Grid1.setter
    def Grid1(self, value: int) -> None: ...
    @Grid2.setter
    def Grid2(self, value: int) -> None: ...
    @Grid3.setter
    def Grid3(self, value: int) -> None: ...
    @MBAMaxLevel.setter
    def MBAMaxLevel(self, value: int) -> None: ...
    @MBAMinFill.setter
    def MBAMinFill(self, value: float) -> None: ...
    @MBATol.setter
    def MBATol(self, value: float) -> None: ...
    def SetAllValues(
        self, grid1: int, grid2: int, grid3: int, mbaMaxLevel: int, mbaTol: float, mbaMinFill: float
    ) -> None: ...

class ISTAR_PointWithDeformation:
    @property
    def DX(self) -> float: ...
    @property
    def DY(self) -> float: ...
    @property
    def DZ(self) -> float: ...
    @property
    def X(self) -> float: ...
    @property
    def Y(self) -> float: ...
    @property
    def Z(self) -> float: ...
    @DX.setter
    def DX(self, value: float) -> None: ...
    @DY.setter
    def DY(self, value: float) -> None: ...
    @DZ.setter
    def DZ(self, value: float) -> None: ...
    @X.setter
    def X(self, value: float) -> None: ...
    @Y.setter
    def Y(self, value: float) -> None: ...
    @Z.setter
    def Z(self, value: float) -> None: ...

class ISTAR_PointWithDeformationAndWeight:
    @property
    def DX(self) -> float: ...
    @property
    def DY(self) -> float: ...
    @property
    def DZ(self) -> float: ...
    @property
    def Weight(self) -> float: ...
    @property
    def X(self) -> float: ...
    @property
    def Y(self) -> float: ...
    @property
    def Z(self) -> float: ...
    @DX.setter
    def DX(self, value: float) -> None: ...
    @DY.setter
    def DY(self, value: float) -> None: ...
    @DZ.setter
    def DZ(self, value: float) -> None: ...
    @Weight.setter
    def Weight(self, value: float) -> None: ...
    @X.setter
    def X(self, value: float) -> None: ...
    @Y.setter
    def Y(self, value: float) -> None: ...
    @Z.setter
    def Z(self, value: float) -> None: ...

class ISTAR_PointWithTemperatureAndIndex:
    @property
    def Index(self) -> float: ...
    @property
    def T(self) -> float: ...
    @property
    def X(self) -> float: ...
    @property
    def Y(self) -> float: ...
    @property
    def Z(self) -> float: ...
    @Index.setter
    def Index(self, value: float) -> None: ...
    @T.setter
    def T(self, value: float) -> None: ...
    @X.setter
    def X(self, value: float) -> None: ...
    @Y.setter
    def Y(self, value: float) -> None: ...
    @Z.setter
    def Z(self, value: float) -> None: ...

class ISTAR_RBM_Centroid:
    @property
    def X(self) -> float: ...
    @property
    def Y(self) -> float: ...
    @property
    def Z(self) -> float: ...

class ISTAR_RBM_ReferencePoint:
    @property
    def X(self) -> float: ...
    @property
    def Y(self) -> float: ...
    @property
    def Z(self) -> float: ...

class ISTAR_RBMs:
    def Disable(self) -> None: ...
    def Enable(self) -> None: ...
    @property
    def Centroid(self) -> ISTAR_RBM_Centroid: ...
    @property
    def Decenters(self) -> ISTAR_Decenters: ...
    @property
    def IsEnabled(self) -> bool: ...
    @property
    def Rotations(self) -> ISTAR_Rotations: ...
    @property
    def SurfaceNumber(self) -> int: ...
    @property
    def Transform(self) -> ICoordinateTransform: ...
    def GetReferencePoint(self) -> ISTAR_RBM_ReferencePoint: ...
    def GetTransformValues(self) -> None: ...
    def SetReferencePoint(self, refX: float, refY: float, refZ: float) -> None: ...

class ISTAR_RotationAngles:
    @property
    def Alpha(self) -> float: ...
    @property
    def Beta(self) -> float: ...
    @property
    def Gamma(self) -> float: ...
    @property
    def ThetaX(self) -> float: ...
    @property
    def ThetaY(self) -> float: ...
    @property
    def ThetaZ(self) -> float: ...

class ISTAR_Rotations:
    @property
    def Angles(self) -> ISTAR_RotationAngles: ...
    @property
    def Values(self) -> ISTAR_RotationValues: ...

class ISTAR_RotationValues:
    @property
    def R11(self) -> float: ...
    @property
    def R12(self) -> float: ...
    @property
    def R13(self) -> float: ...
    @property
    def R21(self) -> float: ...
    @property
    def R22(self) -> float: ...
    @property
    def R23(self) -> float: ...
    @property
    def R31(self) -> float: ...
    @property
    def R32(self) -> float: ...
    @property
    def R33(self) -> float: ...

class ISTAR_Temperatures:
    @property
    def CoordinateTransform(self) -> ISTAR_CoordinateTransform: ...
    @property
    def FEAData(self) -> ISTAR_TemperaturesFEAData: ...
    @property
    def Fits(self) -> ISTAR_TemperaturesFits: ...
    @property
    def GRINStep(self) -> float: ...
    @property
    def PrimaryWavelengthValue(self) -> float: ...
    @property
    def SurfaceNumber(self) -> int: ...
    def GetThermalFEAFitType(self) -> int: ...
    def GetWorkingWavelength(self) -> int: ...
    def IsDataLocalCS(self) -> bool: ...
    @GRINStep.setter
    def GRINStep(self, value: float) -> None: ...
    def SetDataIsGlobal(self) -> None: ...
    def SetDataIsLocal(self) -> None: ...
    def SetThermalFEAFitType(self, FitType: int) -> None: ...
    def SetWorkingWavelength(self, wavelength_number: int) -> None: ...

class ISTAR_TemperaturesFEAData:
    def AreTemperaturesApplied(self) -> bool: ...
    @property
    def AreTemperaturesImported(self) -> bool: ...
    @property
    def Filename(self) -> str: ...
    @property
    def NumberOfDataPoints(self) -> int: ...
    @property
    def SurfaceNumber(self) -> int: ...
    def GetFEAPointsSafe(self) -> list[ISTAR_PointWithTemperatureAndIndex]: ...
    def GetFEAPointsSafeOld(self) -> list[ISTAR_PointWithTemperatureAndIndex]: ...
    def GetTransformedFEAPointsSafe(self, coordinateOption: int) -> list[ISTAR_PointWithTemperatureAndIndex]: ...
    def GetTransformValues(self, transformType: int) -> ICoordinateTransform: ...
    def ImportTemperatures(self, filename: str) -> None: ...
    def UnloadData(self) -> None: ...

class ISTAR_TemperaturesFits:
    def ApplyTemperatures(self) -> None: ...
    @property
    def FitResultsIndex(self) -> ISTAR_FEAFitResults: ...
    @property
    def GRINStep(self) -> float: ...
    @property
    def IsTemperatureProfileEnabled(self) -> bool: ...
    @property
    def Settings(self) -> ISTAR_FEAFitSettings: ...
    @property
    def SurfaceNumber(self) -> int: ...
    def GetFittedIndex(self, X: float, Y: float, Z: float) -> float: ...
    def GetFittedTemperature(self, X: float, Y: float, Z: float) -> float: ...
    def ListFittedIndexSafe(
        self, xCoor: list[float], yCoor: list[float], zCoor: list[float]
    ) -> list[ISTAR_PointWithTemperatureAndIndex]: ...
    def MeshFittedIndexSafe(
        self,
        num_X_pts: int,
        num_Y_pts: int,
        num_Z_pts: int,
        X1_edge: float,
        Y1_edge: float,
        Z1_edge: float,
        X2_edge: float,
        Y2_edge: float,
        Z2_edge: float,
    ) -> list[ISTAR_PointWithTemperatureAndIndex]: ...
    def Refit(self) -> None: ...
    def RemoveTemperatures(self) -> None: ...
    @GRINStep.setter
    def GRINStep(self, value: float) -> None: ...

class ISurface:
    @property
    def Id(self) -> int: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def Row(self) -> ILDERow: ...
    @property
    def Type(self) -> SurfaceType: ...

class ISurfaceABCD(ISurface):
    @property
    def Ax(self) -> float: ...
    @property
    def AxCell(self) -> IEditorCell: ...
    @property
    def Ay(self) -> float: ...
    @property
    def AyCell(self) -> IEditorCell: ...
    @property
    def Bx(self) -> float: ...
    @property
    def BxCell(self) -> IEditorCell: ...
    @property
    def By(self) -> float: ...
    @property
    def ByCell(self) -> IEditorCell: ...
    @property
    def Cx(self) -> float: ...
    @property
    def CxCell(self) -> IEditorCell: ...
    @property
    def Cy(self) -> float: ...
    @property
    def CyCell(self) -> IEditorCell: ...
    @property
    def Dx(self) -> float: ...
    @property
    def DxCell(self) -> IEditorCell: ...
    @property
    def Dy(self) -> float: ...
    @property
    def DyCell(self) -> IEditorCell: ...
    @Ax.setter
    def Ax(self, value: float) -> None: ...
    @Ay.setter
    def Ay(self, value: float) -> None: ...
    @Bx.setter
    def Bx(self, value: float) -> None: ...
    @By.setter
    def By(self, value: float) -> None: ...
    @Cx.setter
    def Cx(self, value: float) -> None: ...
    @Cy.setter
    def Cy(self, value: float) -> None: ...
    @Dx.setter
    def Dx(self, value: float) -> None: ...
    @Dy.setter
    def Dy(self, value: float) -> None: ...

class ISurfaceAlternateEven(ISurfaceNthEvenOrderTerms, ISurface):
    pass

class ISurfaceAlternateOdd(ISurfaceNthOrderTerms, ISurface):
    pass

class ISurfaceAnnularZernikeSag(ISurfaceNthEvenOrderTerms, ISurface):
    @property
    def Extrapolate(self) -> int: ...
    @property
    def ExtrapolateCell(self) -> IEditorCell: ...
    @property
    def NormRadius(self) -> float: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    @property
    def Obscuration(self) -> float: ...
    @property
    def ObscurationCell(self) -> IEditorCell: ...
    def GetZernikeTerm(self, termN: int) -> float: ...
    def GetZernikeTermCell(self, termN: int) -> IEditorCell: ...
    @Extrapolate.setter
    def Extrapolate(self, value: int) -> None: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    @Obscuration.setter
    def Obscuration(self, value: float) -> None: ...
    def SetZernikeTerm(self, termN: int, Value: float) -> None: ...

class ISurfaceAPBC(ISurface):
    def AnCell(self, n: int) -> IEditorCell: ...
    def BnCell(self, n: int) -> IEditorCell: ...
    def CnCell(self, n: int) -> IEditorCell: ...
    def GetAn(self, n: int) -> float: ...
    def GetBn(self, n: int) -> float: ...
    def GetCn(self, n: int) -> float: ...
    def GetPn(self, n: int) -> float: ...
    def PnCell(self, n: int) -> IEditorCell: ...
    def SetAn(self, n: int, Value: float) -> None: ...
    def SetBn(self, n: int, Value: float) -> None: ...
    def SetCn(self, n: int, Value: float) -> None: ...
    def SetPn(self, n: int, Value: float) -> None: ...

class ISurfaceApertureCircular(ISurfaceApertureType):
    @property
    def ApertureXDecenter(self) -> float: ...
    @property
    def ApertureYDecenter(self) -> float: ...
    @property
    def MaximumRadius(self) -> float: ...
    @property
    def MinimumRadius(self) -> float: ...
    @ApertureXDecenter.setter
    def ApertureXDecenter(self, value: float) -> None: ...
    @ApertureYDecenter.setter
    def ApertureYDecenter(self, value: float) -> None: ...
    @MaximumRadius.setter
    def MaximumRadius(self, value: float) -> None: ...
    @MinimumRadius.setter
    def MinimumRadius(self, value: float) -> None: ...

class ISurfaceApertureElliptical(ISurfaceApertureType):
    @property
    def ApertureXDecenter(self) -> float: ...
    @property
    def ApertureYDecenter(self) -> float: ...
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def YHalfWidth(self) -> float: ...
    @ApertureXDecenter.setter
    def ApertureXDecenter(self, value: float) -> None: ...
    @ApertureYDecenter.setter
    def ApertureYDecenter(self, value: float) -> None: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...

class ISurfaceApertureFloating(ISurfaceApertureType):
    pass

class ISurfaceApertureNone(ISurfaceApertureType):
    pass

class ISurfaceApertureRectangular(ISurfaceApertureType):
    @property
    def ApertureXDecenter(self) -> float: ...
    @property
    def ApertureYDecenter(self) -> float: ...
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def YHalfWidth(self) -> float: ...
    @ApertureXDecenter.setter
    def ApertureXDecenter(self, value: float) -> None: ...
    @ApertureYDecenter.setter
    def ApertureYDecenter(self, value: float) -> None: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...

class ISurfaceApertureSpider(ISurfaceApertureType):
    @property
    def ApertureXDecenter(self) -> float: ...
    @property
    def ApertureYDecenter(self) -> float: ...
    @property
    def NumberOfArms(self) -> int: ...
    @property
    def WidthOfArms(self) -> float: ...
    @ApertureXDecenter.setter
    def ApertureXDecenter(self, value: float) -> None: ...
    @ApertureYDecenter.setter
    def ApertureYDecenter(self, value: float) -> None: ...
    @NumberOfArms.setter
    def NumberOfArms(self, value: int) -> None: ...
    @WidthOfArms.setter
    def WidthOfArms(self, value: float) -> None: ...

class ISurfaceApertureType:
    @property
    def _S_CircularAperture(self) -> ISurfaceApertureCircular: ...
    @property
    def _S_CircularObscuration(self) -> ISurfaceApertureCircular: ...
    @property
    def _S_EllipticalAperture(self) -> ISurfaceApertureElliptical: ...
    @property
    def _S_EllipticalObscuration(self) -> ISurfaceApertureElliptical: ...
    @property
    def _S_FloatingAperture(self) -> ISurfaceApertureFloating: ...
    @property
    def _S_None(self) -> ISurfaceApertureNone: ...
    @property
    def _S_RectangularAperture(self) -> ISurfaceApertureRectangular: ...
    @property
    def _S_RectangularObscuration(self) -> ISurfaceApertureRectangular: ...
    @property
    def _S_Spider(self) -> ISurfaceApertureSpider: ...
    @property
    def _S_UserAperture(self) -> ISurfaceApertureUser: ...
    @property
    def _S_UserObscuration(self) -> ISurfaceApertureUser: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def Type(self) -> SurfaceApertureTypes: ...

class ISurfaceApertureUser(ISurfaceApertureType):
    @property
    def ApertureFile(self) -> str: ...
    @property
    def ApertureXDecenter(self) -> float: ...
    @property
    def ApertureYDecenter(self) -> float: ...
    @property
    def UDASCale(self) -> float: ...
    def GetAvailableFiles(self) -> list[str]: ...
    @ApertureFile.setter
    def ApertureFile(self, value: str) -> None: ...
    @ApertureXDecenter.setter
    def ApertureXDecenter(self, value: float) -> None: ...
    @ApertureYDecenter.setter
    def ApertureYDecenter(self, value: float) -> None: ...
    @UDASCale.setter
    def UDASCale(self, value: float) -> None: ...

class ISurfaceAtmospheric(ISurface):
    @property
    def Height(self) -> float: ...
    @property
    def HeightCell(self) -> IEditorCell: ...
    @property
    def Humidity(self) -> float: ...
    @property
    def HumidityCell(self) -> IEditorCell: ...
    @property
    def IsAbsolute(self) -> bool: ...
    @property
    def IsAbsoluteCell(self) -> IEditorCell: ...
    @property
    def Latitude(self) -> float: ...
    @property
    def LatitudeCell(self) -> IEditorCell: ...
    @property
    def Pressure(self) -> float: ...
    @property
    def PressureCell(self) -> IEditorCell: ...
    @property
    def Temperature(self) -> float: ...
    @property
    def TemperatureCell(self) -> IEditorCell: ...
    @property
    def Zenith(self) -> float: ...
    @property
    def ZenithCell(self) -> IEditorCell: ...
    @Height.setter
    def Height(self, value: float) -> None: ...
    @Humidity.setter
    def Humidity(self, value: float) -> None: ...
    @IsAbsolute.setter
    def IsAbsolute(self, value: bool) -> None: ...
    @Latitude.setter
    def Latitude(self, value: float) -> None: ...
    @Pressure.setter
    def Pressure(self, value: float) -> None: ...
    @Temperature.setter
    def Temperature(self, value: float) -> None: ...
    @Zenith.setter
    def Zenith(self, value: float) -> None: ...

class ISurfaceBiconic(ISurface):
    @property
    def XConic(self) -> float: ...
    @property
    def XConicCell(self) -> IEditorCell: ...
    @property
    def XRadius(self) -> float: ...
    @property
    def XRadiusCell(self) -> IEditorCell: ...
    @XConic.setter
    def XConic(self, value: float) -> None: ...
    @XRadius.setter
    def XRadius(self, value: float) -> None: ...

class ISurfaceBiconicZernike(ISurface):
    @property
    def Extrapolate(self) -> int: ...
    @property
    def ExtrapolateCell(self) -> IEditorCell: ...
    @property
    def NormRadius(self) -> float: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    @property
    def XConic(self) -> float: ...
    @property
    def XConicCell(self) -> IEditorCell: ...
    @property
    def XRadius(self) -> float: ...
    @property
    def XRadiusCell(self) -> IEditorCell: ...
    def GetCellXn(self, n: int) -> IEditorCell: ...
    def GetCellYn(self, n: int) -> IEditorCell: ...
    def GetCellZn(self, n: int) -> IEditorCell: ...
    def GetXn(self, n: int) -> float: ...
    def GetYn(self, n: int) -> float: ...
    def GetZn(self, n: int) -> float: ...
    @Extrapolate.setter
    def Extrapolate(self, value: int) -> None: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    @XConic.setter
    def XConic(self, value: float) -> None: ...
    @XRadius.setter
    def XRadius(self, value: float) -> None: ...
    def SetXn(self, n: int, v: float) -> None: ...
    def SetYn(self, n: int, v: float) -> None: ...
    def SetZn(self, n: int, v: float) -> None: ...

class ISurfaceBinary1(ISurfaceXYPolynomial, ISurface, ISurfaceNthEvenOrderTerms):
    @property
    def DiffractOrder(self) -> float: ...
    @property
    def DiffractOrderCell(self) -> IEditorCell: ...
    @property
    def IsAbsolute(self) -> bool: ...
    @property
    def IsAbsoluteCell(self) -> IEditorCell: ...
    @property
    def NormRadius(self) -> float: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @DiffractOrder.setter
    def DiffractOrder(self, value: float) -> None: ...
    @IsAbsolute.setter
    def IsAbsolute(self, value: bool) -> None: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...

class ISurfaceBinary2(ISurfaceCoeff_P_NthEvenPower, ISurface, ISurfaceNthEvenOrderTerms):
    @property
    def DiffractOrder(self) -> float: ...
    @property
    def DiffractOrderCell(self) -> IEditorCell: ...
    @property
    def NormRadius(self) -> float: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @DiffractOrder.setter
    def DiffractOrder(self, value: float) -> None: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...

class ISurfaceBinary3(ISurface):
    @property
    def A1(self) -> float: ...
    @property
    def A1Cell(self) -> IEditorCell: ...
    @property
    def A2(self) -> float: ...
    @property
    def A2Cell(self) -> IEditorCell: ...
    @property
    def Break(self) -> bool: ...
    @property
    def BreakCell(self) -> IEditorCell: ...
    @property
    def K2(self) -> float: ...
    @property
    def K2Cell(self) -> IEditorCell: ...
    @property
    def M1(self) -> float: ...
    @property
    def M1Cell(self) -> IEditorCell: ...
    @property
    def M2(self) -> float: ...
    @property
    def M2Cell(self) -> IEditorCell: ...
    @property
    def R2(self) -> float: ...
    @property
    def R2Cell(self) -> IEditorCell: ...
    @property
    def SinDeltaZero(self) -> float: ...
    @property
    def SinDeltaZeroCell(self) -> IEditorCell: ...
    @A1.setter
    def A1(self, value: float) -> None: ...
    @A2.setter
    def A2(self, value: float) -> None: ...
    @Break.setter
    def Break(self, value: bool) -> None: ...
    @K2.setter
    def K2(self, value: float) -> None: ...
    @M1.setter
    def M1(self, value: float) -> None: ...
    @M2.setter
    def M2(self, value: float) -> None: ...
    @R2.setter
    def R2(self, value: float) -> None: ...
    @SinDeltaZero.setter
    def SinDeltaZero(self, value: float) -> None: ...

class ISurfaceBinary4(ISurface):
    def AsphereInZone_P_NthEvenPowerCell(self, zoneN: int, n: int) -> IEditorCell: ...
    def ConicInZoneCell(self, zoneN: int) -> IEditorCell: ...
    @property
    def NumberOfAsphericTerms(self) -> int: ...
    @property
    def NumberOfAsphericTermsCell(self) -> IEditorCell: ...
    @property
    def NumberOfPhaseTerms(self) -> int: ...
    @property
    def NumberOfPhaseTermsCell(self) -> IEditorCell: ...
    @property
    def NumberOfRadialZones(self) -> int: ...
    @property
    def NumberOfRadialZonesCell(self) -> IEditorCell: ...
    @property
    def SineDeltaZero(self) -> float: ...
    @property
    def SineDeltaZeroCell(self) -> IEditorCell: ...
    def GetAsphereInZone_P_NthEvenPower(self, zoneN: int, n: int) -> float: ...
    def GetConicInZone(self, zoneN: int) -> float: ...
    def GetOrderInZone(self, zoneN: int) -> float: ...
    def GetPhaseInZone_P_NthEvenPower(self, zoneN: int, n: int) -> float: ...
    def GetRadialApertureInZone(self, zoneN: int) -> float: ...
    def GetRadiusInZone(self, zoneN: int) -> float: ...
    def OrderInZoneCell(self, zoneN: int) -> IEditorCell: ...
    def PhaseInZone_P_NthEvenPowerCell(self, zoneN: int, n: int) -> IEditorCell: ...
    def RadialApertureInZoneCell(self, zoneN: int) -> IEditorCell: ...
    def RadiusInZoneCell(self, zoneN: int) -> IEditorCell: ...
    @NumberOfAsphericTerms.setter
    def NumberOfAsphericTerms(self, value: int) -> None: ...
    @NumberOfPhaseTerms.setter
    def NumberOfPhaseTerms(self, value: int) -> None: ...
    @NumberOfRadialZones.setter
    def NumberOfRadialZones(self, value: int) -> None: ...
    @SineDeltaZero.setter
    def SineDeltaZero(self, value: float) -> None: ...
    def SetAsphereInZone_P_NthEvenPower(self, zoneN: int, n: int, Value: float) -> None: ...
    def SetConicInZone(self, zoneN: int, Value: float) -> None: ...
    def SetOrderInZone(self, zoneN: int, Value: float) -> None: ...
    def SetPhaseInZone_P_NthEvenPower(self, zoneN: int, n: int, Value: float) -> None: ...
    def SetRadialApertureInZone(self, zoneN: int, Value: float) -> None: ...
    def SetRadiusInZone(self, zoneN: int, Value: float) -> None: ...

class ISurfaceBirefringentIn(ISurface):
    def aCell(self, n: int) -> IEditorCell: ...
    def CmnCell(self, m: int, n: int) -> IEditorCell: ...
    def CxCell(self, n: int) -> IEditorCell: ...
    def CyCell(self, n: int) -> IEditorCell: ...
    def CzCell(self, n: int) -> IEditorCell: ...
    @property
    def A(self) -> float: ...
    def Get_a(self, n: int) -> float: ...
    @property
    def ACell(self) -> IEditorCell: ...
    @property
    def az(self) -> float: ...
    @property
    def azCell(self) -> IEditorCell: ...
    @property
    def B(self) -> float: ...
    @property
    def BCell(self) -> IEditorCell: ...
    @property
    def DeltaT(self) -> float: ...
    @property
    def DeltaTCell(self) -> IEditorCell: ...
    @property
    def DrawAxis(self) -> float: ...
    @property
    def DrawAxisCell(self) -> IEditorCell: ...
    @property
    def E(self) -> float: ...
    @property
    def ECell(self) -> IEditorCell: ...
    @property
    def GradientMode(self) -> int: ...
    @property
    def GradientModeCell(self) -> IEditorCell: ...
    @property
    def IgnoreParaxialRays(self) -> bool: ...
    @property
    def IgnoreParaxialRaysCell(self) -> IEditorCell: ...
    @property
    def Mode(self) -> int: ...
    @property
    def ModeCell(self) -> IEditorCell: ...
    @property
    def O(self) -> float: ...
    @property
    def OCell(self) -> IEditorCell: ...
    @property
    def RadiusOfRotation(self) -> float: ...
    @property
    def RadiusOfRotationCell(self) -> IEditorCell: ...
    @property
    def Shape(self) -> int: ...
    @property
    def ShapeCell(self) -> IEditorCell: ...
    @property
    def X_Cosine(self) -> float: ...
    @property
    def X_CosineCell(self) -> IEditorCell: ...
    @property
    def Y_Cosine(self) -> float: ...
    @property
    def Y_CosineCell(self) -> IEditorCell: ...
    @property
    def Z_Cosine(self) -> float: ...
    @property
    def Z_CosineCell(self) -> IEditorCell: ...
    @property
    def Z0(self) -> float: ...
    @property
    def Z0Cell(self) -> IEditorCell: ...
    @property
    def Zn(self) -> float: ...
    @property
    def ZnCell(self) -> IEditorCell: ...
    def GetCmn(self, m: int, n: int) -> float: ...
    def GetCx(self, n: int) -> float: ...
    def GetCy(self, n: int) -> float: ...
    def GetCz(self, n: int) -> float: ...
    def GetMode7Cx(self, n: int) -> float: ...
    def GetNthEvenOrderTerm(self, n: int) -> float: ...
    def GetPhi(self, n: int) -> float: ...
    def Mode7CxCell(self, n: int) -> IEditorCell: ...
    def NthEvenOrderTermCell(self, n: int) -> IEditorCell: ...
    def PhiCell(self, n: int) -> IEditorCell: ...
    @A.setter
    def A(self, value: float) -> None: ...
    def Set_a(self, n: int, Value: float) -> None: ...
    @az.setter
    def az(self, value: float) -> None: ...
    @B.setter
    def B(self, value: float) -> None: ...
    @DeltaT.setter
    def DeltaT(self, value: float) -> None: ...
    @DrawAxis.setter
    def DrawAxis(self, value: float) -> None: ...
    @E.setter
    def E(self, value: float) -> None: ...
    @GradientMode.setter
    def GradientMode(self, value: int) -> None: ...
    @IgnoreParaxialRays.setter
    def IgnoreParaxialRays(self, value: bool) -> None: ...
    @Mode.setter
    def Mode(self, value: int) -> None: ...
    @O.setter
    def O(self, value: float) -> None: ...
    @RadiusOfRotation.setter
    def RadiusOfRotation(self, value: float) -> None: ...
    @Shape.setter
    def Shape(self, value: int) -> None: ...
    @X_Cosine.setter
    def X_Cosine(self, value: float) -> None: ...
    @Y_Cosine.setter
    def Y_Cosine(self, value: float) -> None: ...
    @Z_Cosine.setter
    def Z_Cosine(self, value: float) -> None: ...
    @Z0.setter
    def Z0(self, value: float) -> None: ...
    @Zn.setter
    def Zn(self, value: float) -> None: ...
    def SetCmn(self, m: int, n: int, Value: float) -> None: ...
    def SetCx(self, n: int, Value: float) -> None: ...
    def SetCy(self, n: int, Value: float) -> None: ...
    def SetCz(self, n: int, Value: float) -> None: ...
    def SetMode7Cx(self, n: int, Value: float) -> None: ...
    def SetNthEvenOrderTerm(self, n: int, Value: float) -> None: ...
    def SetPhi(self, n: int, Value: float) -> None: ...

class ISurfaceBirefringentOut(ISurfaceNthEvenOrderTerms, ISurface):
    @property
    def RadiusOfRotation(self) -> float: ...
    @property
    def RadiusOfRotationCell(self) -> IEditorCell: ...
    @property
    def Shape(self) -> int: ...
    @property
    def ShapeCell(self) -> IEditorCell: ...
    @RadiusOfRotation.setter
    def RadiusOfRotation(self, value: float) -> None: ...
    @Shape.setter
    def Shape(self, value: int) -> None: ...

class ISurfaceBlackBoxLens(ISurface):
    @property
    def BlackBoxLensFilename(self) -> str: ...
    @property
    def NumberOfAvailableBlackBoxLensFilenames(self) -> int: ...
    def GetBlackBoxLensFilenameAt(self, idx: int) -> str: ...
    @BlackBoxLensFilename.setter
    def BlackBoxLensFilename(self, value: str) -> None: ...

class ISurfaceChebyShv(ISurface):
    def CxyCell(self, orderX: int, orderY: int) -> IEditorCell: ...
    @property
    def Norm_X_Length(self) -> float: ...
    @property
    def Norm_X_LengthCell(self) -> IEditorCell: ...
    @property
    def Norm_Y_Length(self) -> float: ...
    @property
    def Norm_Y_LengthCell(self) -> IEditorCell: ...
    @property
    def NumberOf_X_Orders(self) -> int: ...
    @property
    def NumberOf_X_OrdersCell(self) -> IEditorCell: ...
    @property
    def NumberOf_Y_Orders(self) -> int: ...
    @property
    def NumberOf_Y_OrdersCell(self) -> IEditorCell: ...
    def GetCxy(self, orderX: int, orderY: int) -> float: ...
    @Norm_X_Length.setter
    def Norm_X_Length(self, value: float) -> None: ...
    @Norm_Y_Length.setter
    def Norm_Y_Length(self, value: float) -> None: ...
    @NumberOf_X_Orders.setter
    def NumberOf_X_Orders(self, value: int) -> None: ...
    @NumberOf_Y_Orders.setter
    def NumberOf_Y_Orders(self, value: int) -> None: ...
    def SetCxy(self, orderX: int, orderY: int, Value: float) -> None: ...

class ISurfaceCoeff_P_NthEvenPower(ISurface):
    def Coeff_P_NthEvenPowerCell(self, n: int) -> IEditorCell: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    def GetCoeff_P_NthEvenPower(self, n: int) -> float: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    def SetCoeff_P_NthEvenPower(self, n: int, Value: float) -> None: ...

class ISurfaceCoeff_P_NthPower(ISurface):
    def Coeff_P_NthPowerCell(self, n: int) -> IEditorCell: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    def GetCoeff_P_NthPower(self, n: int) -> float: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    def SetCoeff_P_NthPower(self, n: int, Value: float) -> None: ...

class ISurfaceCoeff_R_NthEvenPower(ISurface):
    def Coeff_R_NthEvenPowerCell(self, n: int) -> IEditorCell: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    def GetCoeff_R_NthEvenPower(self, n: int) -> float: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    def SetCoeff_R_NthEvenPower(self, n: int, Value: float) -> None: ...

class ISurfaceCoeff_R_NthPower(ISurface):
    def Coeff_R_NthPowerCell(self, n: int) -> IEditorCell: ...
    def GetCoeff_R_NthPower(self, n: int) -> float: ...
    def SetCoeff_R_NthPower(self, n: int, Value: float) -> None: ...

class ISurfaceCoeff_X_NthEvenPower(ISurface):
    def Coeff_X_NthEvenPowerCell(self, n: int) -> IEditorCell: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    def GetCoeff_X_NthEvenPower(self, n: int) -> float: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    def SetCoeff_X_NthEvenPower(self, n: int, Value: float) -> None: ...

class ISurfaceCoeff_X_NthEvenPower_8(ISurface):
    def Coeff_X_NthEvenPowerCell(self, n: int) -> IEditorCell: ...
    def GetCoeff_X_NthEvenPower(self, n: int) -> float: ...
    def SetCoeff_X_NthEvenPower(self, n: int, Value: float) -> None: ...

class ISurfaceCoeff_X1P1X2P2_NthEvenPower(ISurface):
    def Coeff_P1_NthEvenPowerCell(self, n: int) -> IEditorCell: ...
    def Coeff_P2_NthEvenPowerCell(self, n: int) -> IEditorCell: ...
    def Coeff_X1_NthEvenPowerCell(self, n: int) -> IEditorCell: ...
    def Coeff_X2_NthEvenPowerCell(self, n: int) -> IEditorCell: ...
    def GetCoeff_P1_NthEvenPower(self, n: int) -> float: ...
    def GetCoeff_P2_NthEvenPower(self, n: int) -> float: ...
    def GetCoeff_X1_NthEvenPower(self, n: int) -> float: ...
    def GetCoeff_X2_NthEvenPower(self, n: int) -> float: ...
    def SetCoeff_P1_NthEvenPower(self, n: int, Value: float) -> None: ...
    def SetCoeff_P2_NthEvenPower(self, n: int, Value: float) -> None: ...
    def SetCoeff_X1_NthEvenPower(self, n: int, Value: float) -> None: ...
    def SetCoeff_X2_NthEvenPower(self, n: int, Value: float) -> None: ...

class ISurfaceCoeff_Y_NthEvenPower(ISurface):
    def Coeff_Y_NthEvenPowerCell(self, n: int) -> IEditorCell: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    def GetCoeff_Y_NthEvenPower(self, n: int) -> float: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    def SetCoeff_Y_NthEvenPower(self, n: int, Value: float) -> None: ...

class ISurfaceCoeff_Y_NthEvenPower_8(ISurface):
    def Coeff_Y_NthEvenPowerCell(self, n: int) -> IEditorCell: ...
    def GetCoeff_Y_NthEvenPower(self, n: int) -> float: ...
    def SetCoeff_Y_NthEvenPower(self, n: int, Value: float) -> None: ...

class ISurfaceConjugate(ISurface):
    @property
    def X1(self) -> float: ...
    @property
    def X1_Cell(self) -> IEditorCell: ...
    @property
    def X2(self) -> float: ...
    @property
    def X2_Cell(self) -> IEditorCell: ...
    @property
    def Y1(self) -> float: ...
    @property
    def Y1_Cell(self) -> IEditorCell: ...
    @property
    def Y2(self) -> float: ...
    @property
    def Y2_Cell(self) -> IEditorCell: ...
    @property
    def Z1(self) -> float: ...
    @property
    def Z1_Cell(self) -> IEditorCell: ...
    @property
    def Z2(self) -> float: ...
    @property
    def Z2_Cell(self) -> IEditorCell: ...
    @X1.setter
    def X1(self, value: float) -> None: ...
    @X2.setter
    def X2(self, value: float) -> None: ...
    @Y1.setter
    def Y1(self, value: float) -> None: ...
    @Y2.setter
    def Y2(self, value: float) -> None: ...
    @Z1.setter
    def Z1(self, value: float) -> None: ...
    @Z2.setter
    def Z2(self, value: float) -> None: ...

class ISurfaceCoordinateBreak(ISurface):
    @property
    def Decenter_X(self) -> float: ...
    @property
    def Decenter_X_Cell(self) -> IEditorCell: ...
    @property
    def Decenter_Y(self) -> float: ...
    @property
    def Decenter_Y_Cell(self) -> IEditorCell: ...
    @property
    def Order(self) -> int: ...
    @property
    def OrderCell(self) -> IEditorCell: ...
    @property
    def TiltAbout_X(self) -> float: ...
    @property
    def TiltAbout_X_Cell(self) -> IEditorCell: ...
    @property
    def TiltAbout_Y(self) -> float: ...
    @property
    def TiltAbout_Y_Cell(self) -> IEditorCell: ...
    @property
    def TiltAbout_Z(self) -> float: ...
    @property
    def TiltAbout_Z_Cell(self) -> IEditorCell: ...
    @Decenter_X.setter
    def Decenter_X(self, value: float) -> None: ...
    @Decenter_Y.setter
    def Decenter_Y(self, value: float) -> None: ...
    @Order.setter
    def Order(self, value: int) -> None: ...
    @TiltAbout_X.setter
    def TiltAbout_X(self, value: float) -> None: ...
    @TiltAbout_Y.setter
    def TiltAbout_Y(self, value: float) -> None: ...
    @TiltAbout_Z.setter
    def TiltAbout_Z(self, value: float) -> None: ...

class ISurfaceCubicSpline(ISurface):
    def Get_Z_nEighths(self, n: int) -> float: ...
    def Set_Z_nEighths(self, n: int, Value: float) -> None: ...
    def Z_nEigthsCell(self, n: int) -> IEditorCell: ...

class ISurfaceCylinderFrensel(ISurface, ISurfaceNthEvenOrderTerms, ISurfaceCoeff_Y_NthEvenPower):
    @property
    def Conic(self) -> float: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def Curvature(self) -> float: ...
    @property
    def CurvatureCell(self) -> IEditorCell: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @Curvature.setter
    def Curvature(self, value: float) -> None: ...

class ISurfaceCylinderFresnel(ISurface, ISurfaceNthEvenOrderTerms, ISurfaceCoeff_Y_NthEvenPower):
    @property
    def Conic(self) -> float: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def Curvature(self) -> float: ...
    @property
    def CurvatureCell(self) -> IEditorCell: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @Curvature.setter
    def Curvature(self, value: float) -> None: ...

class ISurfaceData(ISurface):
    def GetNthExtraData(self, n: int) -> float: ...
    def NthExtraDataCell(self, n: int) -> IEditorCell: ...
    def SetNthExtraData(self, n: int, Value: float) -> None: ...

class ISurfaceDiffractionGrating(ISurface):
    @property
    def DiffractionOrder(self) -> float: ...
    @property
    def DiffractionOrderCell(self) -> IEditorCell: ...
    @property
    def LinesPerMicroMeter(self) -> float: ...
    @property
    def LinesPerMicroMeterCell(self) -> IEditorCell: ...
    @DiffractionOrder.setter
    def DiffractionOrder(self, value: float) -> None: ...
    @LinesPerMicroMeter.setter
    def LinesPerMicroMeter(self, value: float) -> None: ...

class ISurfaceEllipticalGrating1(ISurfaceXYPolynomial, ISurface):
    @property
    def a(self) -> float: ...
    @property
    def aCell(self) -> IEditorCell: ...
    @property
    def Alpha(self) -> float: ...
    @property
    def AlphaCell(self) -> IEditorCell: ...
    @property
    def b(self) -> float: ...
    @property
    def bCell(self) -> IEditorCell: ...
    @property
    def Beta(self) -> float: ...
    @property
    def BetaCell(self) -> IEditorCell: ...
    @property
    def c(self) -> float: ...
    @property
    def cCell(self) -> IEditorCell: ...
    @property
    def Delta(self) -> float: ...
    @property
    def DeltaCell(self) -> IEditorCell: ...
    @property
    def DiffractionOrder(self) -> float: ...
    @property
    def DiffractionOrderCell(self) -> IEditorCell: ...
    @property
    def Epsilon(self) -> float: ...
    @property
    def EpsilonCell(self) -> IEditorCell: ...
    @property
    def Gamma(self) -> float: ...
    @property
    def GammaCell(self) -> IEditorCell: ...
    @property
    def LinesPerMicroMeter(self) -> float: ...
    @property
    def LinesPerMicroMeterCell(self) -> IEditorCell: ...
    @property
    def NormRadius(self) -> float: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @a.setter
    def a(self, value: float) -> None: ...
    @Alpha.setter
    def Alpha(self, value: float) -> None: ...
    @b.setter
    def b(self, value: float) -> None: ...
    @Beta.setter
    def Beta(self, value: float) -> None: ...
    @c.setter
    def c(self, value: float) -> None: ...
    @Delta.setter
    def Delta(self, value: float) -> None: ...
    @DiffractionOrder.setter
    def DiffractionOrder(self, value: float) -> None: ...
    @Epsilon.setter
    def Epsilon(self, value: float) -> None: ...
    @Gamma.setter
    def Gamma(self, value: float) -> None: ...
    @LinesPerMicroMeter.setter
    def LinesPerMicroMeter(self, value: float) -> None: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...

class ISurfaceEllipticalGrating2(ISurfaceXYPolynomial, ISurface):
    @property
    def a(self) -> float: ...
    @property
    def aCell(self) -> IEditorCell: ...
    @property
    def b(self) -> float: ...
    @property
    def bCell(self) -> IEditorCell: ...
    @property
    def c(self) -> float: ...
    @property
    def cCell(self) -> IEditorCell: ...
    @property
    def DiffractionOrder(self) -> float: ...
    @property
    def DiffractionOrderCell(self) -> IEditorCell: ...
    @property
    def LinesPerMicroMeter(self) -> float: ...
    @property
    def LinesPerMicroMeterCell(self) -> IEditorCell: ...
    @property
    def NormRadius(self) -> float: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def Theta(self) -> float: ...
    @property
    def ThetaCell(self) -> IEditorCell: ...
    @a.setter
    def a(self, value: float) -> None: ...
    @b.setter
    def b(self, value: float) -> None: ...
    @c.setter
    def c(self, value: float) -> None: ...
    @DiffractionOrder.setter
    def DiffractionOrder(self, value: float) -> None: ...
    @LinesPerMicroMeter.setter
    def LinesPerMicroMeter(self, value: float) -> None: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...
    @Theta.setter
    def Theta(self, value: float) -> None: ...

class ISurfaceEvenAspheric(ISurface, ISurfaceNthEvenOrderTerms):
    pass

class ISurfaceExtendedAsphere(ISurfaceCoeff_P_NthEvenPower, ISurface):
    @property
    def NormRadius(self) -> float: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...

class ISurfaceExtendedCubicSpline(ISurface):
    @property
    def NumberOfSteps(self) -> int: ...
    @property
    def NumberOfStepsCell(self) -> IEditorCell: ...
    @property
    def StepSize(self) -> float: ...
    @property
    def StepSizeCell(self) -> IEditorCell: ...
    def GetSagAtNthStep(self, n: int) -> float: ...
    def SagAtNthStepCell(self, n: int) -> IEditorCell: ...
    @NumberOfSteps.setter
    def NumberOfSteps(self, value: int) -> None: ...
    @StepSize.setter
    def StepSize(self, value: float) -> None: ...
    def SetSagAtNthStep(self, n: int, Value: float) -> None: ...

class ISurfaceExtendedFresnel(ISurface, ISurfaceNthEvenOrderTerms, ISurfaceCoeff_R_NthEvenPower):
    @property
    def Conic(self) -> float: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def Curvature(self) -> float: ...
    @property
    def CurvatureCell(self) -> IEditorCell: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @Curvature.setter
    def Curvature(self, value: float) -> None: ...

class ISurfaceExtendedOddAsphere(ISurface, ISurfaceCoeff_P_NthPower):
    @property
    def NormRadius(self) -> float: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...

class ISurfaceExtendedPolynomial(ISurfaceXYPolynomial, ISurface):
    @property
    def NormRadius(self) -> float: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...

class ISurfaceExtendedToroidalGrating(ISurfaceXYPolynomial, ISurface, ISurfaceNthEvenOrderTerms):
    @property
    def DiffractionOrder(self) -> float: ...
    @property
    def DiffractionOrderCell(self) -> IEditorCell: ...
    @property
    def LinesPerMicroMeter(self) -> float: ...
    @property
    def LinesPerMicroMeterCell(self) -> IEditorCell: ...
    @property
    def NormRadius(self) -> float: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def RadiusOfRotation(self) -> float: ...
    @property
    def RadiusOfRotationCell(self) -> IEditorCell: ...
    @DiffractionOrder.setter
    def DiffractionOrder(self, value: float) -> None: ...
    @LinesPerMicroMeter.setter
    def LinesPerMicroMeter(self, value: float) -> None: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...
    @RadiusOfRotation.setter
    def RadiusOfRotation(self, value: float) -> None: ...

class ISurfaceFreeformNthZernike(ISurface):
    @property
    def NormRadius(self) -> float: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def NumberOfZernikeTerms(self) -> int: ...
    @property
    def NumberOfZernikeTermsCell(self) -> IEditorCell: ...
    def GetNthZernikeCoefficient(self, n: int) -> float: ...
    def NthZernikeCoefficientCell(self, n: int) -> IEditorCell: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...
    @NumberOfZernikeTerms.setter
    def NumberOfZernikeTerms(self, value: int) -> None: ...
    def SetNthZernikeCoefficient(self, n: int, Value: float) -> None: ...

class ISurfaceFreeformXYPolynomial(ISurface):
    @property
    def NumberOfPolynomialTerms(self) -> int: ...
    @property
    def NumberOfPolynomialTermsCell(self) -> IEditorCell: ...
    @property
    def X0Y1(self) -> float: ...
    @property
    def X0Y10(self) -> float: ...
    @property
    def X0Y10Cell(self) -> IEditorCell: ...
    @property
    def X0Y11(self) -> float: ...
    @property
    def X0Y11Cell(self) -> IEditorCell: ...
    @property
    def X0Y12(self) -> float: ...
    @property
    def X0Y12Cell(self) -> IEditorCell: ...
    @property
    def X0Y13(self) -> float: ...
    @property
    def X0Y13Cell(self) -> IEditorCell: ...
    @property
    def X0Y14(self) -> float: ...
    @property
    def X0Y14Cell(self) -> IEditorCell: ...
    @property
    def X0Y15(self) -> float: ...
    @property
    def X0Y15Cell(self) -> IEditorCell: ...
    @property
    def X0Y16(self) -> float: ...
    @property
    def X0Y16Cell(self) -> IEditorCell: ...
    @property
    def X0Y17(self) -> float: ...
    @property
    def X0Y17Cell(self) -> IEditorCell: ...
    @property
    def X0Y18(self) -> float: ...
    @property
    def X0Y18Cell(self) -> IEditorCell: ...
    @property
    def X0Y19(self) -> float: ...
    @property
    def X0Y19Cell(self) -> IEditorCell: ...
    @property
    def X0Y1Cell(self) -> IEditorCell: ...
    @property
    def X0Y2(self) -> float: ...
    @property
    def X0Y20(self) -> float: ...
    @property
    def X0Y20Cell(self) -> IEditorCell: ...
    @property
    def X0Y2Cell(self) -> IEditorCell: ...
    @property
    def X0Y3(self) -> float: ...
    @property
    def X0Y3Cell(self) -> IEditorCell: ...
    @property
    def X0Y4(self) -> float: ...
    @property
    def X0Y4Cell(self) -> IEditorCell: ...
    @property
    def X0Y5(self) -> float: ...
    @property
    def X0Y5Cell(self) -> IEditorCell: ...
    @property
    def X0Y6(self) -> float: ...
    @property
    def X0Y6Cell(self) -> IEditorCell: ...
    @property
    def X0Y7(self) -> float: ...
    @property
    def X0Y7Cell(self) -> IEditorCell: ...
    @property
    def X0Y8(self) -> float: ...
    @property
    def X0Y8Cell(self) -> IEditorCell: ...
    @property
    def X0Y9(self) -> float: ...
    @property
    def X0Y9Cell(self) -> IEditorCell: ...
    @property
    def X10Y0(self) -> float: ...
    @property
    def X10Y0Cell(self) -> IEditorCell: ...
    @property
    def X10Y1(self) -> float: ...
    @property
    def X10Y10(self) -> float: ...
    @property
    def X10Y10Cell(self) -> IEditorCell: ...
    @property
    def X10Y11(self) -> float: ...
    @property
    def X10Y11Cell(self) -> IEditorCell: ...
    @property
    def X10Y1Cell(self) -> IEditorCell: ...
    @property
    def X10Y2(self) -> float: ...
    @property
    def X10Y2Cell(self) -> IEditorCell: ...
    @property
    def X10Y3(self) -> float: ...
    @property
    def X10Y3Cell(self) -> IEditorCell: ...
    @property
    def X10Y4(self) -> float: ...
    @property
    def X10Y4Cell(self) -> IEditorCell: ...
    @property
    def X10Y5(self) -> float: ...
    @property
    def X10Y5Cell(self) -> IEditorCell: ...
    @property
    def X10Y6(self) -> float: ...
    @property
    def X10Y6Cell(self) -> IEditorCell: ...
    @property
    def X10Y7(self) -> float: ...
    @property
    def X10Y7Cell(self) -> IEditorCell: ...
    @property
    def X10Y8(self) -> float: ...
    @property
    def X10Y8Cell(self) -> IEditorCell: ...
    @property
    def X10Y9(self) -> float: ...
    @property
    def X10Y9Cell(self) -> IEditorCell: ...
    @property
    def X11Y0(self) -> float: ...
    @property
    def X11Y0Cell(self) -> IEditorCell: ...
    @property
    def X11Y1(self) -> float: ...
    @property
    def X11Y10(self) -> float: ...
    @property
    def X11Y10Cell(self) -> IEditorCell: ...
    @property
    def X11Y1Cell(self) -> IEditorCell: ...
    @property
    def X11Y2(self) -> float: ...
    @property
    def X11Y2Cell(self) -> IEditorCell: ...
    @property
    def X11Y3(self) -> float: ...
    @property
    def X11Y3Cell(self) -> IEditorCell: ...
    @property
    def X11Y4(self) -> float: ...
    @property
    def X11Y4Cell(self) -> IEditorCell: ...
    @property
    def X11Y5(self) -> float: ...
    @property
    def X11Y5Cell(self) -> IEditorCell: ...
    @property
    def X11Y6(self) -> float: ...
    @property
    def X11Y6Cell(self) -> IEditorCell: ...
    @property
    def X11Y7(self) -> float: ...
    @property
    def X11Y7Cell(self) -> IEditorCell: ...
    @property
    def X11Y8(self) -> float: ...
    @property
    def X11Y8Cell(self) -> IEditorCell: ...
    @property
    def X11Y9(self) -> float: ...
    @property
    def X11Y9Cell(self) -> IEditorCell: ...
    @property
    def X12Y0(self) -> float: ...
    @property
    def X12Y0Cell(self) -> IEditorCell: ...
    @property
    def X12Y1(self) -> float: ...
    @property
    def X12Y1Cell(self) -> IEditorCell: ...
    @property
    def X12Y2(self) -> float: ...
    @property
    def X12Y2Cell(self) -> IEditorCell: ...
    @property
    def X12Y3(self) -> float: ...
    @property
    def X12Y3Cell(self) -> IEditorCell: ...
    @property
    def X12Y4(self) -> float: ...
    @property
    def X12Y4Cell(self) -> IEditorCell: ...
    @property
    def X12Y5(self) -> float: ...
    @property
    def X12Y5Cell(self) -> IEditorCell: ...
    @property
    def X12Y6(self) -> float: ...
    @property
    def X12Y6Cell(self) -> IEditorCell: ...
    @property
    def X12Y7(self) -> float: ...
    @property
    def X12Y7Cell(self) -> IEditorCell: ...
    @property
    def X12Y8(self) -> float: ...
    @property
    def X12Y8Cell(self) -> IEditorCell: ...
    @property
    def X12Y9(self) -> float: ...
    @property
    def X12Y9Cell(self) -> IEditorCell: ...
    @property
    def X13Y0(self) -> float: ...
    @property
    def X13Y0Cell(self) -> IEditorCell: ...
    @property
    def X13Y1(self) -> float: ...
    @property
    def X13Y1Cell(self) -> IEditorCell: ...
    @property
    def X13Y2(self) -> float: ...
    @property
    def X13Y2Cell(self) -> IEditorCell: ...
    @property
    def X13Y3(self) -> float: ...
    @property
    def X13Y3Cell(self) -> IEditorCell: ...
    @property
    def X13Y4(self) -> float: ...
    @property
    def X13Y4Cell(self) -> IEditorCell: ...
    @property
    def X13Y5(self) -> float: ...
    @property
    def X13Y5Cell(self) -> IEditorCell: ...
    @property
    def X13Y6(self) -> float: ...
    @property
    def X13Y6Cell(self) -> IEditorCell: ...
    @property
    def X13Y7(self) -> float: ...
    @property
    def X13Y7Cell(self) -> IEditorCell: ...
    @property
    def X13Y8(self) -> float: ...
    @property
    def X13Y8Cell(self) -> IEditorCell: ...
    @property
    def X14Y0(self) -> float: ...
    @property
    def X14Y0Cell(self) -> IEditorCell: ...
    @property
    def X14Y1(self) -> float: ...
    @property
    def X14Y1Cell(self) -> IEditorCell: ...
    @property
    def X14Y2(self) -> float: ...
    @property
    def X14Y2Cell(self) -> IEditorCell: ...
    @property
    def X14Y3(self) -> float: ...
    @property
    def X14Y3Cell(self) -> IEditorCell: ...
    @property
    def X14Y4(self) -> float: ...
    @property
    def X14Y4Cell(self) -> IEditorCell: ...
    @property
    def X14Y5(self) -> float: ...
    @property
    def X14Y5Cell(self) -> IEditorCell: ...
    @property
    def X14Y6(self) -> float: ...
    @property
    def X14Y6Cell(self) -> IEditorCell: ...
    @property
    def X14Y7(self) -> float: ...
    @property
    def X14Y7Cell(self) -> IEditorCell: ...
    @property
    def X15Y0(self) -> float: ...
    @property
    def X15Y0Cell(self) -> IEditorCell: ...
    @property
    def X15Y1(self) -> float: ...
    @property
    def X15Y1Cell(self) -> IEditorCell: ...
    @property
    def X15Y2(self) -> float: ...
    @property
    def X15Y2Cell(self) -> IEditorCell: ...
    @property
    def X15Y3(self) -> float: ...
    @property
    def X15Y3Cell(self) -> IEditorCell: ...
    @property
    def X15Y4(self) -> float: ...
    @property
    def X15Y4Cell(self) -> IEditorCell: ...
    @property
    def X15Y5(self) -> float: ...
    @property
    def X15Y5Cell(self) -> IEditorCell: ...
    @property
    def X15Y6(self) -> float: ...
    @property
    def X15Y6Cell(self) -> IEditorCell: ...
    @property
    def X16Y0(self) -> float: ...
    @property
    def X16Y0Cell(self) -> IEditorCell: ...
    @property
    def X16Y1(self) -> float: ...
    @property
    def X16Y1Cell(self) -> IEditorCell: ...
    @property
    def X16Y2(self) -> float: ...
    @property
    def X16Y2Cell(self) -> IEditorCell: ...
    @property
    def X16Y3(self) -> float: ...
    @property
    def X16Y3Cell(self) -> IEditorCell: ...
    @property
    def X16Y4(self) -> float: ...
    @property
    def X16Y4Cell(self) -> IEditorCell: ...
    @property
    def X16Y5(self) -> float: ...
    @property
    def X16Y5Cell(self) -> IEditorCell: ...
    @property
    def X17Y0(self) -> float: ...
    @property
    def X17Y0Cell(self) -> IEditorCell: ...
    @property
    def X17Y1(self) -> float: ...
    @property
    def X17Y1Cell(self) -> IEditorCell: ...
    @property
    def X17Y2(self) -> float: ...
    @property
    def X17Y2Cell(self) -> IEditorCell: ...
    @property
    def X17Y3(self) -> float: ...
    @property
    def X17Y3Cell(self) -> IEditorCell: ...
    @property
    def X17Y4(self) -> float: ...
    @property
    def X17Y4Cell(self) -> IEditorCell: ...
    @property
    def X18Y0(self) -> float: ...
    @property
    def X18Y0Cell(self) -> IEditorCell: ...
    @property
    def X18Y1(self) -> float: ...
    @property
    def X18Y1Cell(self) -> IEditorCell: ...
    @property
    def X18Y2(self) -> float: ...
    @property
    def X18Y2Cell(self) -> IEditorCell: ...
    @property
    def X18Y3(self) -> float: ...
    @property
    def X18Y3Cell(self) -> IEditorCell: ...
    @property
    def X19Y0(self) -> float: ...
    @property
    def X19Y0Cell(self) -> IEditorCell: ...
    @property
    def X19Y1(self) -> float: ...
    @property
    def X19Y1Cell(self) -> IEditorCell: ...
    @property
    def X19Y2(self) -> float: ...
    @property
    def X19Y2Cell(self) -> IEditorCell: ...
    @property
    def X1Y0(self) -> float: ...
    @property
    def X1Y0Cell(self) -> IEditorCell: ...
    @property
    def X1Y1(self) -> float: ...
    @property
    def X1Y10(self) -> float: ...
    @property
    def X1Y10Cell(self) -> IEditorCell: ...
    @property
    def X1Y11(self) -> float: ...
    @property
    def X1Y11Cell(self) -> IEditorCell: ...
    @property
    def X1Y12(self) -> float: ...
    @property
    def X1Y12Cell(self) -> IEditorCell: ...
    @property
    def X1Y13(self) -> float: ...
    @property
    def X1Y13Cell(self) -> IEditorCell: ...
    @property
    def X1Y14(self) -> float: ...
    @property
    def X1Y14Cell(self) -> IEditorCell: ...
    @property
    def X1Y15(self) -> float: ...
    @property
    def X1Y15Cell(self) -> IEditorCell: ...
    @property
    def X1Y16(self) -> float: ...
    @property
    def X1Y16Cell(self) -> IEditorCell: ...
    @property
    def X1Y17(self) -> float: ...
    @property
    def X1Y17Cell(self) -> IEditorCell: ...
    @property
    def X1Y18(self) -> float: ...
    @property
    def X1Y18Cell(self) -> IEditorCell: ...
    @property
    def X1Y19(self) -> float: ...
    @property
    def X1Y19Cell(self) -> IEditorCell: ...
    @property
    def X1Y1Cell(self) -> IEditorCell: ...
    @property
    def X1Y2(self) -> float: ...
    @property
    def X1Y2Cell(self) -> IEditorCell: ...
    @property
    def X1Y3(self) -> float: ...
    @property
    def X1Y3Cell(self) -> IEditorCell: ...
    @property
    def X1Y4(self) -> float: ...
    @property
    def X1Y4Cell(self) -> IEditorCell: ...
    @property
    def X1Y5(self) -> float: ...
    @property
    def X1Y5Cell(self) -> IEditorCell: ...
    @property
    def X1Y6(self) -> float: ...
    @property
    def X1Y6Cell(self) -> IEditorCell: ...
    @property
    def X1Y7(self) -> float: ...
    @property
    def X1Y7Cell(self) -> IEditorCell: ...
    @property
    def X1Y8(self) -> float: ...
    @property
    def X1Y8Cell(self) -> IEditorCell: ...
    @property
    def X1Y9(self) -> float: ...
    @property
    def X1Y9Cell(self) -> IEditorCell: ...
    @property
    def X20Y0(self) -> float: ...
    @property
    def X20Y0Cell(self) -> IEditorCell: ...
    @property
    def X20Y1(self) -> float: ...
    @property
    def X20Y1Cell(self) -> IEditorCell: ...
    @property
    def X21Y0(self) -> float: ...
    @property
    def X21Y0Cell(self) -> IEditorCell: ...
    @property
    def X2Y0(self) -> float: ...
    @property
    def X2Y0Cell(self) -> IEditorCell: ...
    @property
    def X2Y1(self) -> float: ...
    @property
    def X2Y10(self) -> float: ...
    @property
    def X2Y10Cell(self) -> IEditorCell: ...
    @property
    def X2Y11(self) -> float: ...
    @property
    def X2Y11Cell(self) -> IEditorCell: ...
    @property
    def X2Y12(self) -> float: ...
    @property
    def X2Y12Cell(self) -> IEditorCell: ...
    @property
    def X2Y13(self) -> float: ...
    @property
    def X2Y13Cell(self) -> IEditorCell: ...
    @property
    def X2Y14(self) -> float: ...
    @property
    def X2Y14Cell(self) -> IEditorCell: ...
    @property
    def X2Y15(self) -> float: ...
    @property
    def X2Y15Cell(self) -> IEditorCell: ...
    @property
    def X2Y16(self) -> float: ...
    @property
    def X2Y16Cell(self) -> IEditorCell: ...
    @property
    def X2Y17(self) -> float: ...
    @property
    def X2Y17Cell(self) -> IEditorCell: ...
    @property
    def X2Y18(self) -> float: ...
    @property
    def X2Y18Cell(self) -> IEditorCell: ...
    @property
    def X2Y19(self) -> float: ...
    @property
    def X2Y19Cell(self) -> IEditorCell: ...
    @property
    def X2Y1Cell(self) -> IEditorCell: ...
    @property
    def X2Y2(self) -> float: ...
    @property
    def X2Y2Cell(self) -> IEditorCell: ...
    @property
    def X2Y3(self) -> float: ...
    @property
    def X2Y3Cell(self) -> IEditorCell: ...
    @property
    def X2Y4(self) -> float: ...
    @property
    def X2Y4Cell(self) -> IEditorCell: ...
    @property
    def X2Y5(self) -> float: ...
    @property
    def X2Y5Cell(self) -> IEditorCell: ...
    @property
    def X2Y6(self) -> float: ...
    @property
    def X2Y6Cell(self) -> IEditorCell: ...
    @property
    def X2Y7(self) -> float: ...
    @property
    def X2Y7Cell(self) -> IEditorCell: ...
    @property
    def X2Y8(self) -> float: ...
    @property
    def X2Y8Cell(self) -> IEditorCell: ...
    @property
    def X2Y9(self) -> float: ...
    @property
    def X2Y9Cell(self) -> IEditorCell: ...
    @property
    def X3Y0(self) -> float: ...
    @property
    def X3Y0Cell(self) -> IEditorCell: ...
    @property
    def X3Y1(self) -> float: ...
    @property
    def X3Y10(self) -> float: ...
    @property
    def X3Y10Cell(self) -> IEditorCell: ...
    @property
    def X3Y11(self) -> float: ...
    @property
    def X3Y11Cell(self) -> IEditorCell: ...
    @property
    def X3Y12(self) -> float: ...
    @property
    def X3Y12Cell(self) -> IEditorCell: ...
    @property
    def X3Y13(self) -> float: ...
    @property
    def X3Y13Cell(self) -> IEditorCell: ...
    @property
    def X3Y14(self) -> float: ...
    @property
    def X3Y14Cell(self) -> IEditorCell: ...
    @property
    def X3Y15(self) -> float: ...
    @property
    def X3Y15Cell(self) -> IEditorCell: ...
    @property
    def X3Y16(self) -> float: ...
    @property
    def X3Y16Cell(self) -> IEditorCell: ...
    @property
    def X3Y17(self) -> float: ...
    @property
    def X3Y17Cell(self) -> IEditorCell: ...
    @property
    def X3Y18(self) -> float: ...
    @property
    def X3Y18Cell(self) -> IEditorCell: ...
    @property
    def X3Y1Cell(self) -> IEditorCell: ...
    @property
    def X3Y2(self) -> float: ...
    @property
    def X3Y2Cell(self) -> IEditorCell: ...
    @property
    def X3Y3(self) -> float: ...
    @property
    def X3Y3Cell(self) -> IEditorCell: ...
    @property
    def X3Y4(self) -> float: ...
    @property
    def X3Y4Cell(self) -> IEditorCell: ...
    @property
    def X3Y5(self) -> float: ...
    @property
    def X3Y5Cell(self) -> IEditorCell: ...
    @property
    def X3Y6(self) -> float: ...
    @property
    def X3Y6Cell(self) -> IEditorCell: ...
    @property
    def X3Y7(self) -> float: ...
    @property
    def X3Y7Cell(self) -> IEditorCell: ...
    @property
    def X3Y8(self) -> float: ...
    @property
    def X3Y8Cell(self) -> IEditorCell: ...
    @property
    def X3Y9(self) -> float: ...
    @property
    def X3Y9Cell(self) -> IEditorCell: ...
    @property
    def X4Y0(self) -> float: ...
    @property
    def X4Y0Cell(self) -> IEditorCell: ...
    @property
    def X4Y1(self) -> float: ...
    @property
    def X4Y10(self) -> float: ...
    @property
    def X4Y10Cell(self) -> IEditorCell: ...
    @property
    def X4Y11(self) -> float: ...
    @property
    def X4Y11Cell(self) -> IEditorCell: ...
    @property
    def X4Y12(self) -> float: ...
    @property
    def X4Y12Cell(self) -> IEditorCell: ...
    @property
    def X4Y13(self) -> float: ...
    @property
    def X4Y13Cell(self) -> IEditorCell: ...
    @property
    def X4Y14(self) -> float: ...
    @property
    def X4Y14Cell(self) -> IEditorCell: ...
    @property
    def X4Y15(self) -> float: ...
    @property
    def X4Y15Cell(self) -> IEditorCell: ...
    @property
    def X4Y16(self) -> float: ...
    @property
    def X4Y16Cell(self) -> IEditorCell: ...
    @property
    def X4Y17(self) -> float: ...
    @property
    def X4Y17Cell(self) -> IEditorCell: ...
    @property
    def X4Y1Cell(self) -> IEditorCell: ...
    @property
    def X4Y2(self) -> float: ...
    @property
    def X4Y2Cell(self) -> IEditorCell: ...
    @property
    def X4Y3(self) -> float: ...
    @property
    def X4Y3Cell(self) -> IEditorCell: ...
    @property
    def X4Y4(self) -> float: ...
    @property
    def X4Y4Cell(self) -> IEditorCell: ...
    @property
    def X4Y5(self) -> float: ...
    @property
    def X4Y5Cell(self) -> IEditorCell: ...
    @property
    def X4Y6(self) -> float: ...
    @property
    def X4Y6Cell(self) -> IEditorCell: ...
    @property
    def X4Y7(self) -> float: ...
    @property
    def X4Y7Cell(self) -> IEditorCell: ...
    @property
    def X4Y8(self) -> float: ...
    @property
    def X4Y8Cell(self) -> IEditorCell: ...
    @property
    def X4Y9(self) -> float: ...
    @property
    def X4Y9Cell(self) -> IEditorCell: ...
    @property
    def X5Y0(self) -> float: ...
    @property
    def X5Y0Cell(self) -> IEditorCell: ...
    @property
    def X5Y1(self) -> float: ...
    @property
    def X5Y10(self) -> float: ...
    @property
    def X5Y10Cell(self) -> IEditorCell: ...
    @property
    def X5Y11(self) -> float: ...
    @property
    def X5Y11Cell(self) -> IEditorCell: ...
    @property
    def X5Y12(self) -> float: ...
    @property
    def X5Y12Cell(self) -> IEditorCell: ...
    @property
    def X5Y13(self) -> float: ...
    @property
    def X5Y13Cell(self) -> IEditorCell: ...
    @property
    def X5Y14(self) -> float: ...
    @property
    def X5Y14Cell(self) -> IEditorCell: ...
    @property
    def X5Y15(self) -> float: ...
    @property
    def X5Y15Cell(self) -> IEditorCell: ...
    @property
    def X5Y16(self) -> float: ...
    @property
    def X5Y16Cell(self) -> IEditorCell: ...
    @property
    def X5Y1Cell(self) -> IEditorCell: ...
    @property
    def X5Y2(self) -> float: ...
    @property
    def X5Y2Cell(self) -> IEditorCell: ...
    @property
    def X5Y3(self) -> float: ...
    @property
    def X5Y3Cell(self) -> IEditorCell: ...
    @property
    def X5Y4(self) -> float: ...
    @property
    def X5Y4Cell(self) -> IEditorCell: ...
    @property
    def X5Y5(self) -> float: ...
    @property
    def X5Y5Cell(self) -> IEditorCell: ...
    @property
    def X5Y6(self) -> float: ...
    @property
    def X5Y6Cell(self) -> IEditorCell: ...
    @property
    def X5Y7(self) -> float: ...
    @property
    def X5Y7Cell(self) -> IEditorCell: ...
    @property
    def X5Y8(self) -> float: ...
    @property
    def X5Y8Cell(self) -> IEditorCell: ...
    @property
    def X5Y9(self) -> float: ...
    @property
    def X5Y9Cell(self) -> IEditorCell: ...
    @property
    def X6Y0(self) -> float: ...
    @property
    def X6Y0Cell(self) -> IEditorCell: ...
    @property
    def X6Y1(self) -> float: ...
    @property
    def X6Y10(self) -> float: ...
    @property
    def X6Y10Cell(self) -> IEditorCell: ...
    @property
    def X6Y11(self) -> float: ...
    @property
    def X6Y11Cell(self) -> IEditorCell: ...
    @property
    def X6Y12(self) -> float: ...
    @property
    def X6Y12Cell(self) -> IEditorCell: ...
    @property
    def X6Y13(self) -> float: ...
    @property
    def X6Y13Cell(self) -> IEditorCell: ...
    @property
    def X6Y14(self) -> float: ...
    @property
    def X6Y14Cell(self) -> IEditorCell: ...
    @property
    def X6Y15(self) -> float: ...
    @property
    def X6Y15Cell(self) -> IEditorCell: ...
    @property
    def X6Y1Cell(self) -> IEditorCell: ...
    @property
    def X6Y2(self) -> float: ...
    @property
    def X6Y2Cell(self) -> IEditorCell: ...
    @property
    def X6Y3(self) -> float: ...
    @property
    def X6Y3Cell(self) -> IEditorCell: ...
    @property
    def X6Y4(self) -> float: ...
    @property
    def X6Y4Cell(self) -> IEditorCell: ...
    @property
    def X6Y5(self) -> float: ...
    @property
    def X6Y5Cell(self) -> IEditorCell: ...
    @property
    def X6Y6(self) -> float: ...
    @property
    def X6Y6Cell(self) -> IEditorCell: ...
    @property
    def X6Y7(self) -> float: ...
    @property
    def X6Y7Cell(self) -> IEditorCell: ...
    @property
    def X6Y8(self) -> float: ...
    @property
    def X6Y8Cell(self) -> IEditorCell: ...
    @property
    def X6Y9(self) -> float: ...
    @property
    def X6Y9Cell(self) -> IEditorCell: ...
    @property
    def X7Y0(self) -> float: ...
    @property
    def X7Y0Cell(self) -> IEditorCell: ...
    @property
    def X7Y1(self) -> float: ...
    @property
    def X7Y10(self) -> float: ...
    @property
    def X7Y10Cell(self) -> IEditorCell: ...
    @property
    def X7Y11(self) -> float: ...
    @property
    def X7Y11Cell(self) -> IEditorCell: ...
    @property
    def X7Y12(self) -> float: ...
    @property
    def X7Y12Cell(self) -> IEditorCell: ...
    @property
    def X7Y13(self) -> float: ...
    @property
    def X7Y13Cell(self) -> IEditorCell: ...
    @property
    def X7Y14(self) -> float: ...
    @property
    def X7Y14Cell(self) -> IEditorCell: ...
    @property
    def X7Y1Cell(self) -> IEditorCell: ...
    @property
    def X7Y2(self) -> float: ...
    @property
    def X7Y2Cell(self) -> IEditorCell: ...
    @property
    def X7Y3(self) -> float: ...
    @property
    def X7Y3Cell(self) -> IEditorCell: ...
    @property
    def X7Y4(self) -> float: ...
    @property
    def X7Y4Cell(self) -> IEditorCell: ...
    @property
    def X7Y5(self) -> float: ...
    @property
    def X7Y5Cell(self) -> IEditorCell: ...
    @property
    def X7Y6(self) -> float: ...
    @property
    def X7Y6Cell(self) -> IEditorCell: ...
    @property
    def X7Y7(self) -> float: ...
    @property
    def X7Y7Cell(self) -> IEditorCell: ...
    @property
    def X7Y8(self) -> float: ...
    @property
    def X7Y8Cell(self) -> IEditorCell: ...
    @property
    def X7Y9(self) -> float: ...
    @property
    def X7Y9Cell(self) -> IEditorCell: ...
    @property
    def X8Y0(self) -> float: ...
    @property
    def X8Y0Cell(self) -> IEditorCell: ...
    @property
    def X8Y1(self) -> float: ...
    @property
    def X8Y10(self) -> float: ...
    @property
    def X8Y10Cell(self) -> IEditorCell: ...
    @property
    def X8Y11(self) -> float: ...
    @property
    def X8Y11Cell(self) -> IEditorCell: ...
    @property
    def X8Y12(self) -> float: ...
    @property
    def X8Y12Cell(self) -> IEditorCell: ...
    @property
    def X8Y13(self) -> float: ...
    @property
    def X8Y13Cell(self) -> IEditorCell: ...
    @property
    def X8Y1Cell(self) -> IEditorCell: ...
    @property
    def X8Y2(self) -> float: ...
    @property
    def X8Y2Cell(self) -> IEditorCell: ...
    @property
    def X8Y3(self) -> float: ...
    @property
    def X8Y3Cell(self) -> IEditorCell: ...
    @property
    def X8Y4(self) -> float: ...
    @property
    def X8Y4Cell(self) -> IEditorCell: ...
    @property
    def X8Y5(self) -> float: ...
    @property
    def X8Y5Cell(self) -> IEditorCell: ...
    @property
    def X8Y6(self) -> float: ...
    @property
    def X8Y6Cell(self) -> IEditorCell: ...
    @property
    def X8Y7(self) -> float: ...
    @property
    def X8Y7Cell(self) -> IEditorCell: ...
    @property
    def X8Y8(self) -> float: ...
    @property
    def X8Y8Cell(self) -> IEditorCell: ...
    @property
    def X8Y9(self) -> float: ...
    @property
    def X8Y9Cell(self) -> IEditorCell: ...
    @property
    def X9Y0(self) -> float: ...
    @property
    def X9Y0Cell(self) -> IEditorCell: ...
    @property
    def X9Y1(self) -> float: ...
    @property
    def X9Y10(self) -> float: ...
    @property
    def X9Y10Cell(self) -> IEditorCell: ...
    @property
    def X9Y11(self) -> float: ...
    @property
    def X9Y11Cell(self) -> IEditorCell: ...
    @property
    def X9Y12(self) -> float: ...
    @property
    def X9Y12Cell(self) -> IEditorCell: ...
    @property
    def X9Y1Cell(self) -> IEditorCell: ...
    @property
    def X9Y2(self) -> float: ...
    @property
    def X9Y2Cell(self) -> IEditorCell: ...
    @property
    def X9Y3(self) -> float: ...
    @property
    def X9Y3Cell(self) -> IEditorCell: ...
    @property
    def X9Y4(self) -> float: ...
    @property
    def X9Y4Cell(self) -> IEditorCell: ...
    @property
    def X9Y5(self) -> float: ...
    @property
    def X9Y5Cell(self) -> IEditorCell: ...
    @property
    def X9Y6(self) -> float: ...
    @property
    def X9Y6Cell(self) -> IEditorCell: ...
    @property
    def X9Y7(self) -> float: ...
    @property
    def X9Y7Cell(self) -> IEditorCell: ...
    @property
    def X9Y8(self) -> float: ...
    @property
    def X9Y8Cell(self) -> IEditorCell: ...
    @property
    def X9Y9(self) -> float: ...
    @property
    def X9Y9Cell(self) -> IEditorCell: ...
    @NumberOfPolynomialTerms.setter
    def NumberOfPolynomialTerms(self, value: int) -> None: ...
    @X0Y1.setter
    def X0Y1(self, value: float) -> None: ...
    @X0Y10.setter
    def X0Y10(self, value: float) -> None: ...
    @X0Y11.setter
    def X0Y11(self, value: float) -> None: ...
    @X0Y12.setter
    def X0Y12(self, value: float) -> None: ...
    @X0Y13.setter
    def X0Y13(self, value: float) -> None: ...
    @X0Y14.setter
    def X0Y14(self, value: float) -> None: ...
    @X0Y15.setter
    def X0Y15(self, value: float) -> None: ...
    @X0Y16.setter
    def X0Y16(self, value: float) -> None: ...
    @X0Y17.setter
    def X0Y17(self, value: float) -> None: ...
    @X0Y18.setter
    def X0Y18(self, value: float) -> None: ...
    @X0Y19.setter
    def X0Y19(self, value: float) -> None: ...
    @X0Y2.setter
    def X0Y2(self, value: float) -> None: ...
    @X0Y20.setter
    def X0Y20(self, value: float) -> None: ...
    @X0Y3.setter
    def X0Y3(self, value: float) -> None: ...
    @X0Y4.setter
    def X0Y4(self, value: float) -> None: ...
    @X0Y5.setter
    def X0Y5(self, value: float) -> None: ...
    @X0Y6.setter
    def X0Y6(self, value: float) -> None: ...
    @X0Y7.setter
    def X0Y7(self, value: float) -> None: ...
    @X0Y8.setter
    def X0Y8(self, value: float) -> None: ...
    @X0Y9.setter
    def X0Y9(self, value: float) -> None: ...
    @X10Y0.setter
    def X10Y0(self, value: float) -> None: ...
    @X10Y1.setter
    def X10Y1(self, value: float) -> None: ...
    @X10Y10.setter
    def X10Y10(self, value: float) -> None: ...
    @X10Y11.setter
    def X10Y11(self, value: float) -> None: ...
    @X10Y2.setter
    def X10Y2(self, value: float) -> None: ...
    @X10Y3.setter
    def X10Y3(self, value: float) -> None: ...
    @X10Y4.setter
    def X10Y4(self, value: float) -> None: ...
    @X10Y5.setter
    def X10Y5(self, value: float) -> None: ...
    @X10Y6.setter
    def X10Y6(self, value: float) -> None: ...
    @X10Y7.setter
    def X10Y7(self, value: float) -> None: ...
    @X10Y8.setter
    def X10Y8(self, value: float) -> None: ...
    @X10Y9.setter
    def X10Y9(self, value: float) -> None: ...
    @X11Y0.setter
    def X11Y0(self, value: float) -> None: ...
    @X11Y1.setter
    def X11Y1(self, value: float) -> None: ...
    @X11Y10.setter
    def X11Y10(self, value: float) -> None: ...
    @X11Y2.setter
    def X11Y2(self, value: float) -> None: ...
    @X11Y3.setter
    def X11Y3(self, value: float) -> None: ...
    @X11Y4.setter
    def X11Y4(self, value: float) -> None: ...
    @X11Y5.setter
    def X11Y5(self, value: float) -> None: ...
    @X11Y6.setter
    def X11Y6(self, value: float) -> None: ...
    @X11Y7.setter
    def X11Y7(self, value: float) -> None: ...
    @X11Y8.setter
    def X11Y8(self, value: float) -> None: ...
    @X11Y9.setter
    def X11Y9(self, value: float) -> None: ...
    @X12Y0.setter
    def X12Y0(self, value: float) -> None: ...
    @X12Y1.setter
    def X12Y1(self, value: float) -> None: ...
    @X12Y2.setter
    def X12Y2(self, value: float) -> None: ...
    @X12Y3.setter
    def X12Y3(self, value: float) -> None: ...
    @X12Y4.setter
    def X12Y4(self, value: float) -> None: ...
    @X12Y5.setter
    def X12Y5(self, value: float) -> None: ...
    @X12Y6.setter
    def X12Y6(self, value: float) -> None: ...
    @X12Y7.setter
    def X12Y7(self, value: float) -> None: ...
    @X12Y8.setter
    def X12Y8(self, value: float) -> None: ...
    @X12Y9.setter
    def X12Y9(self, value: float) -> None: ...
    @X13Y0.setter
    def X13Y0(self, value: float) -> None: ...
    @X13Y1.setter
    def X13Y1(self, value: float) -> None: ...
    @X13Y2.setter
    def X13Y2(self, value: float) -> None: ...
    @X13Y3.setter
    def X13Y3(self, value: float) -> None: ...
    @X13Y4.setter
    def X13Y4(self, value: float) -> None: ...
    @X13Y5.setter
    def X13Y5(self, value: float) -> None: ...
    @X13Y6.setter
    def X13Y6(self, value: float) -> None: ...
    @X13Y7.setter
    def X13Y7(self, value: float) -> None: ...
    @X13Y8.setter
    def X13Y8(self, value: float) -> None: ...
    @X14Y0.setter
    def X14Y0(self, value: float) -> None: ...
    @X14Y1.setter
    def X14Y1(self, value: float) -> None: ...
    @X14Y2.setter
    def X14Y2(self, value: float) -> None: ...
    @X14Y3.setter
    def X14Y3(self, value: float) -> None: ...
    @X14Y4.setter
    def X14Y4(self, value: float) -> None: ...
    @X14Y5.setter
    def X14Y5(self, value: float) -> None: ...
    @X14Y6.setter
    def X14Y6(self, value: float) -> None: ...
    @X14Y7.setter
    def X14Y7(self, value: float) -> None: ...
    @X15Y0.setter
    def X15Y0(self, value: float) -> None: ...
    @X15Y1.setter
    def X15Y1(self, value: float) -> None: ...
    @X15Y2.setter
    def X15Y2(self, value: float) -> None: ...
    @X15Y3.setter
    def X15Y3(self, value: float) -> None: ...
    @X15Y4.setter
    def X15Y4(self, value: float) -> None: ...
    @X15Y5.setter
    def X15Y5(self, value: float) -> None: ...
    @X15Y6.setter
    def X15Y6(self, value: float) -> None: ...
    @X16Y0.setter
    def X16Y0(self, value: float) -> None: ...
    @X16Y1.setter
    def X16Y1(self, value: float) -> None: ...
    @X16Y2.setter
    def X16Y2(self, value: float) -> None: ...
    @X16Y3.setter
    def X16Y3(self, value: float) -> None: ...
    @X16Y4.setter
    def X16Y4(self, value: float) -> None: ...
    @X16Y5.setter
    def X16Y5(self, value: float) -> None: ...
    @X17Y0.setter
    def X17Y0(self, value: float) -> None: ...
    @X17Y1.setter
    def X17Y1(self, value: float) -> None: ...
    @X17Y2.setter
    def X17Y2(self, value: float) -> None: ...
    @X17Y3.setter
    def X17Y3(self, value: float) -> None: ...
    @X17Y4.setter
    def X17Y4(self, value: float) -> None: ...
    @X18Y0.setter
    def X18Y0(self, value: float) -> None: ...
    @X18Y1.setter
    def X18Y1(self, value: float) -> None: ...
    @X18Y2.setter
    def X18Y2(self, value: float) -> None: ...
    @X18Y3.setter
    def X18Y3(self, value: float) -> None: ...
    @X19Y0.setter
    def X19Y0(self, value: float) -> None: ...
    @X19Y1.setter
    def X19Y1(self, value: float) -> None: ...
    @X19Y2.setter
    def X19Y2(self, value: float) -> None: ...
    @X1Y0.setter
    def X1Y0(self, value: float) -> None: ...
    @X1Y1.setter
    def X1Y1(self, value: float) -> None: ...
    @X1Y10.setter
    def X1Y10(self, value: float) -> None: ...
    @X1Y11.setter
    def X1Y11(self, value: float) -> None: ...
    @X1Y12.setter
    def X1Y12(self, value: float) -> None: ...
    @X1Y13.setter
    def X1Y13(self, value: float) -> None: ...
    @X1Y14.setter
    def X1Y14(self, value: float) -> None: ...
    @X1Y15.setter
    def X1Y15(self, value: float) -> None: ...
    @X1Y16.setter
    def X1Y16(self, value: float) -> None: ...
    @X1Y17.setter
    def X1Y17(self, value: float) -> None: ...
    @X1Y18.setter
    def X1Y18(self, value: float) -> None: ...
    @X1Y19.setter
    def X1Y19(self, value: float) -> None: ...
    @X1Y2.setter
    def X1Y2(self, value: float) -> None: ...
    @X1Y3.setter
    def X1Y3(self, value: float) -> None: ...
    @X1Y4.setter
    def X1Y4(self, value: float) -> None: ...
    @X1Y5.setter
    def X1Y5(self, value: float) -> None: ...
    @X1Y6.setter
    def X1Y6(self, value: float) -> None: ...
    @X1Y7.setter
    def X1Y7(self, value: float) -> None: ...
    @X1Y8.setter
    def X1Y8(self, value: float) -> None: ...
    @X1Y9.setter
    def X1Y9(self, value: float) -> None: ...
    @X20Y0.setter
    def X20Y0(self, value: float) -> None: ...
    @X20Y1.setter
    def X20Y1(self, value: float) -> None: ...
    @X21Y0.setter
    def X21Y0(self, value: float) -> None: ...
    @X2Y0.setter
    def X2Y0(self, value: float) -> None: ...
    @X2Y1.setter
    def X2Y1(self, value: float) -> None: ...
    @X2Y10.setter
    def X2Y10(self, value: float) -> None: ...
    @X2Y11.setter
    def X2Y11(self, value: float) -> None: ...
    @X2Y12.setter
    def X2Y12(self, value: float) -> None: ...
    @X2Y13.setter
    def X2Y13(self, value: float) -> None: ...
    @X2Y14.setter
    def X2Y14(self, value: float) -> None: ...
    @X2Y15.setter
    def X2Y15(self, value: float) -> None: ...
    @X2Y16.setter
    def X2Y16(self, value: float) -> None: ...
    @X2Y17.setter
    def X2Y17(self, value: float) -> None: ...
    @X2Y18.setter
    def X2Y18(self, value: float) -> None: ...
    @X2Y19.setter
    def X2Y19(self, value: float) -> None: ...
    @X2Y2.setter
    def X2Y2(self, value: float) -> None: ...
    @X2Y3.setter
    def X2Y3(self, value: float) -> None: ...
    @X2Y4.setter
    def X2Y4(self, value: float) -> None: ...
    @X2Y5.setter
    def X2Y5(self, value: float) -> None: ...
    @X2Y6.setter
    def X2Y6(self, value: float) -> None: ...
    @X2Y7.setter
    def X2Y7(self, value: float) -> None: ...
    @X2Y8.setter
    def X2Y8(self, value: float) -> None: ...
    @X2Y9.setter
    def X2Y9(self, value: float) -> None: ...
    @X3Y0.setter
    def X3Y0(self, value: float) -> None: ...
    @X3Y1.setter
    def X3Y1(self, value: float) -> None: ...
    @X3Y10.setter
    def X3Y10(self, value: float) -> None: ...
    @X3Y11.setter
    def X3Y11(self, value: float) -> None: ...
    @X3Y12.setter
    def X3Y12(self, value: float) -> None: ...
    @X3Y13.setter
    def X3Y13(self, value: float) -> None: ...
    @X3Y14.setter
    def X3Y14(self, value: float) -> None: ...
    @X3Y15.setter
    def X3Y15(self, value: float) -> None: ...
    @X3Y16.setter
    def X3Y16(self, value: float) -> None: ...
    @X3Y17.setter
    def X3Y17(self, value: float) -> None: ...
    @X3Y18.setter
    def X3Y18(self, value: float) -> None: ...
    @X3Y2.setter
    def X3Y2(self, value: float) -> None: ...
    @X3Y3.setter
    def X3Y3(self, value: float) -> None: ...
    @X3Y4.setter
    def X3Y4(self, value: float) -> None: ...
    @X3Y5.setter
    def X3Y5(self, value: float) -> None: ...
    @X3Y6.setter
    def X3Y6(self, value: float) -> None: ...
    @X3Y7.setter
    def X3Y7(self, value: float) -> None: ...
    @X3Y8.setter
    def X3Y8(self, value: float) -> None: ...
    @X3Y9.setter
    def X3Y9(self, value: float) -> None: ...
    @X4Y0.setter
    def X4Y0(self, value: float) -> None: ...
    @X4Y1.setter
    def X4Y1(self, value: float) -> None: ...
    @X4Y10.setter
    def X4Y10(self, value: float) -> None: ...
    @X4Y11.setter
    def X4Y11(self, value: float) -> None: ...
    @X4Y12.setter
    def X4Y12(self, value: float) -> None: ...
    @X4Y13.setter
    def X4Y13(self, value: float) -> None: ...
    @X4Y14.setter
    def X4Y14(self, value: float) -> None: ...
    @X4Y15.setter
    def X4Y15(self, value: float) -> None: ...
    @X4Y16.setter
    def X4Y16(self, value: float) -> None: ...
    @X4Y17.setter
    def X4Y17(self, value: float) -> None: ...
    @X4Y2.setter
    def X4Y2(self, value: float) -> None: ...
    @X4Y3.setter
    def X4Y3(self, value: float) -> None: ...
    @X4Y4.setter
    def X4Y4(self, value: float) -> None: ...
    @X4Y5.setter
    def X4Y5(self, value: float) -> None: ...
    @X4Y6.setter
    def X4Y6(self, value: float) -> None: ...
    @X4Y7.setter
    def X4Y7(self, value: float) -> None: ...
    @X4Y8.setter
    def X4Y8(self, value: float) -> None: ...
    @X4Y9.setter
    def X4Y9(self, value: float) -> None: ...
    @X5Y0.setter
    def X5Y0(self, value: float) -> None: ...
    @X5Y1.setter
    def X5Y1(self, value: float) -> None: ...
    @X5Y10.setter
    def X5Y10(self, value: float) -> None: ...
    @X5Y11.setter
    def X5Y11(self, value: float) -> None: ...
    @X5Y12.setter
    def X5Y12(self, value: float) -> None: ...
    @X5Y13.setter
    def X5Y13(self, value: float) -> None: ...
    @X5Y14.setter
    def X5Y14(self, value: float) -> None: ...
    @X5Y15.setter
    def X5Y15(self, value: float) -> None: ...
    @X5Y16.setter
    def X5Y16(self, value: float) -> None: ...
    @X5Y2.setter
    def X5Y2(self, value: float) -> None: ...
    @X5Y3.setter
    def X5Y3(self, value: float) -> None: ...
    @X5Y4.setter
    def X5Y4(self, value: float) -> None: ...
    @X5Y5.setter
    def X5Y5(self, value: float) -> None: ...
    @X5Y6.setter
    def X5Y6(self, value: float) -> None: ...
    @X5Y7.setter
    def X5Y7(self, value: float) -> None: ...
    @X5Y8.setter
    def X5Y8(self, value: float) -> None: ...
    @X5Y9.setter
    def X5Y9(self, value: float) -> None: ...
    @X6Y0.setter
    def X6Y0(self, value: float) -> None: ...
    @X6Y1.setter
    def X6Y1(self, value: float) -> None: ...
    @X6Y10.setter
    def X6Y10(self, value: float) -> None: ...
    @X6Y11.setter
    def X6Y11(self, value: float) -> None: ...
    @X6Y12.setter
    def X6Y12(self, value: float) -> None: ...
    @X6Y13.setter
    def X6Y13(self, value: float) -> None: ...
    @X6Y14.setter
    def X6Y14(self, value: float) -> None: ...
    @X6Y15.setter
    def X6Y15(self, value: float) -> None: ...
    @X6Y2.setter
    def X6Y2(self, value: float) -> None: ...
    @X6Y3.setter
    def X6Y3(self, value: float) -> None: ...
    @X6Y4.setter
    def X6Y4(self, value: float) -> None: ...
    @X6Y5.setter
    def X6Y5(self, value: float) -> None: ...
    @X6Y6.setter
    def X6Y6(self, value: float) -> None: ...
    @X6Y7.setter
    def X6Y7(self, value: float) -> None: ...
    @X6Y8.setter
    def X6Y8(self, value: float) -> None: ...
    @X6Y9.setter
    def X6Y9(self, value: float) -> None: ...
    @X7Y0.setter
    def X7Y0(self, value: float) -> None: ...
    @X7Y1.setter
    def X7Y1(self, value: float) -> None: ...
    @X7Y10.setter
    def X7Y10(self, value: float) -> None: ...
    @X7Y11.setter
    def X7Y11(self, value: float) -> None: ...
    @X7Y12.setter
    def X7Y12(self, value: float) -> None: ...
    @X7Y13.setter
    def X7Y13(self, value: float) -> None: ...
    @X7Y14.setter
    def X7Y14(self, value: float) -> None: ...
    @X7Y2.setter
    def X7Y2(self, value: float) -> None: ...
    @X7Y3.setter
    def X7Y3(self, value: float) -> None: ...
    @X7Y4.setter
    def X7Y4(self, value: float) -> None: ...
    @X7Y5.setter
    def X7Y5(self, value: float) -> None: ...
    @X7Y6.setter
    def X7Y6(self, value: float) -> None: ...
    @X7Y7.setter
    def X7Y7(self, value: float) -> None: ...
    @X7Y8.setter
    def X7Y8(self, value: float) -> None: ...
    @X7Y9.setter
    def X7Y9(self, value: float) -> None: ...
    @X8Y0.setter
    def X8Y0(self, value: float) -> None: ...
    @X8Y1.setter
    def X8Y1(self, value: float) -> None: ...
    @X8Y10.setter
    def X8Y10(self, value: float) -> None: ...
    @X8Y11.setter
    def X8Y11(self, value: float) -> None: ...
    @X8Y12.setter
    def X8Y12(self, value: float) -> None: ...
    @X8Y13.setter
    def X8Y13(self, value: float) -> None: ...
    @X8Y2.setter
    def X8Y2(self, value: float) -> None: ...
    @X8Y3.setter
    def X8Y3(self, value: float) -> None: ...
    @X8Y4.setter
    def X8Y4(self, value: float) -> None: ...
    @X8Y5.setter
    def X8Y5(self, value: float) -> None: ...
    @X8Y6.setter
    def X8Y6(self, value: float) -> None: ...
    @X8Y7.setter
    def X8Y7(self, value: float) -> None: ...
    @X8Y8.setter
    def X8Y8(self, value: float) -> None: ...
    @X8Y9.setter
    def X8Y9(self, value: float) -> None: ...
    @X9Y0.setter
    def X9Y0(self, value: float) -> None: ...
    @X9Y1.setter
    def X9Y1(self, value: float) -> None: ...
    @X9Y10.setter
    def X9Y10(self, value: float) -> None: ...
    @X9Y11.setter
    def X9Y11(self, value: float) -> None: ...
    @X9Y12.setter
    def X9Y12(self, value: float) -> None: ...
    @X9Y2.setter
    def X9Y2(self, value: float) -> None: ...
    @X9Y3.setter
    def X9Y3(self, value: float) -> None: ...
    @X9Y4.setter
    def X9Y4(self, value: float) -> None: ...
    @X9Y5.setter
    def X9Y5(self, value: float) -> None: ...
    @X9Y6.setter
    def X9Y6(self, value: float) -> None: ...
    @X9Y7.setter
    def X9Y7(self, value: float) -> None: ...
    @X9Y8.setter
    def X9Y8(self, value: float) -> None: ...
    @X9Y9.setter
    def X9Y9(self, value: float) -> None: ...

class ISurfaceFresnel(ISurfaceNthEvenOrderTerms, ISurface):
    pass

class ISurfaceGeneralizedFresnel(ISurfaceXYPolynomial, ISurface, ISurfaceNthEvenOrderTerms):
    @property
    def NormRadius(self) -> float: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...

class ISurfaceGradient1(ISurface):
    @property
    def DeltaT(self) -> float: ...
    @property
    def DeltaTCell(self) -> IEditorCell: ...
    @property
    def n0(self) -> float: ...
    @property
    def n0Cell(self) -> IEditorCell: ...
    @property
    def Nr1(self) -> float: ...
    @property
    def Nr1Cell(self) -> IEditorCell: ...
    @property
    def Nr2(self) -> float: ...
    @property
    def Nr2Cell(self) -> IEditorCell: ...
    @DeltaT.setter
    def DeltaT(self, value: float) -> None: ...
    @n0.setter
    def n0(self, value: float) -> None: ...
    @Nr1.setter
    def Nr1(self, value: float) -> None: ...
    @Nr2.setter
    def Nr2(self, value: float) -> None: ...

class ISurfaceGradient10(ISurface):
    @property
    def DeltaT(self) -> float: ...
    @property
    def DeltaTCell(self) -> IEditorCell: ...
    @property
    def n0(self) -> float: ...
    @property
    def n0Cell(self) -> IEditorCell: ...
    @property
    def Ny1(self) -> float: ...
    @property
    def Ny1Cell(self) -> IEditorCell: ...
    @property
    def Ny2(self) -> float: ...
    @property
    def Ny2Cell(self) -> IEditorCell: ...
    @property
    def Ny3(self) -> float: ...
    @property
    def Ny3Cell(self) -> IEditorCell: ...
    @property
    def Ny4(self) -> float: ...
    @property
    def Ny4Cell(self) -> IEditorCell: ...
    @property
    def Ny5(self) -> float: ...
    @property
    def Ny5Cell(self) -> IEditorCell: ...
    @property
    def Ny6(self) -> float: ...
    @property
    def Ny6Cell(self) -> IEditorCell: ...
    @DeltaT.setter
    def DeltaT(self, value: float) -> None: ...
    @n0.setter
    def n0(self, value: float) -> None: ...
    @Ny1.setter
    def Ny1(self, value: float) -> None: ...
    @Ny2.setter
    def Ny2(self, value: float) -> None: ...
    @Ny3.setter
    def Ny3(self, value: float) -> None: ...
    @Ny4.setter
    def Ny4(self, value: float) -> None: ...
    @Ny5.setter
    def Ny5(self, value: float) -> None: ...
    @Ny6.setter
    def Ny6(self, value: float) -> None: ...

class ISurfaceGradient12(ISurface):
    @property
    def DeltaT(self) -> float: ...
    @property
    def DeltaTCell(self) -> IEditorCell: ...
    @property
    def n0(self) -> float: ...
    @property
    def n0Cell(self) -> IEditorCell: ...
    @property
    def Order(self) -> int: ...
    @property
    def OrderCell(self) -> IEditorCell: ...
    def GetNthNx(self, n: int) -> float: ...
    def GetNthNy(self, n: int) -> float: ...
    def GetNthNz(self, n: int) -> float: ...
    def NthNxCell(self, n: int) -> IEditorCell: ...
    def NthNyCell(self, n: int) -> IEditorCell: ...
    def NthNzCell(self, n: int) -> IEditorCell: ...
    @DeltaT.setter
    def DeltaT(self, value: float) -> None: ...
    @n0.setter
    def n0(self, value: float) -> None: ...
    @Order.setter
    def Order(self, value: int) -> None: ...
    def SetNthNx(self, n: int, Value: float) -> None: ...
    def SetNthNy(self, n: int, Value: float) -> None: ...
    def SetNthNz(self, n: int, Value: float) -> None: ...

class ISurfaceGradient2(ISurface):
    @property
    def DeltaT(self) -> float: ...
    @property
    def DeltaTCell(self) -> IEditorCell: ...
    @property
    def n0(self) -> float: ...
    @property
    def n0Cell(self) -> IEditorCell: ...
    @property
    def Nr10(self) -> float: ...
    @property
    def Nr10Cell(self) -> IEditorCell: ...
    @property
    def Nr12(self) -> float: ...
    @property
    def Nr12Cell(self) -> IEditorCell: ...
    @property
    def Nr2(self) -> float: ...
    @property
    def Nr2Cell(self) -> IEditorCell: ...
    @property
    def Nr4(self) -> float: ...
    @property
    def Nr4Cell(self) -> IEditorCell: ...
    @property
    def Nr6(self) -> float: ...
    @property
    def Nr6Cell(self) -> IEditorCell: ...
    @property
    def Nr8(self) -> float: ...
    @property
    def Nr8Cell(self) -> IEditorCell: ...
    @DeltaT.setter
    def DeltaT(self, value: float) -> None: ...
    @n0.setter
    def n0(self, value: float) -> None: ...
    @Nr10.setter
    def Nr10(self, value: float) -> None: ...
    @Nr12.setter
    def Nr12(self, value: float) -> None: ...
    @Nr2.setter
    def Nr2(self, value: float) -> None: ...
    @Nr4.setter
    def Nr4(self, value: float) -> None: ...
    @Nr6.setter
    def Nr6(self, value: float) -> None: ...
    @Nr8.setter
    def Nr8(self, value: float) -> None: ...

class ISurfaceGradient3(ISurface):
    @property
    def DeltaT(self) -> float: ...
    @property
    def DeltaTCell(self) -> IEditorCell: ...
    @property
    def n0(self) -> float: ...
    @property
    def n0Cell(self) -> IEditorCell: ...
    @property
    def Nr2(self) -> float: ...
    @property
    def Nr2Cell(self) -> IEditorCell: ...
    @property
    def Nr4(self) -> float: ...
    @property
    def Nr4Cell(self) -> IEditorCell: ...
    @property
    def Nr6(self) -> float: ...
    @property
    def Nr6Cell(self) -> IEditorCell: ...
    @property
    def Nz1(self) -> float: ...
    @property
    def Nz1Cell(self) -> IEditorCell: ...
    @property
    def Nz2(self) -> float: ...
    @property
    def Nz2Cell(self) -> IEditorCell: ...
    @property
    def Nz3(self) -> float: ...
    @property
    def Nz3Cell(self) -> IEditorCell: ...
    @DeltaT.setter
    def DeltaT(self, value: float) -> None: ...
    @n0.setter
    def n0(self, value: float) -> None: ...
    @Nr2.setter
    def Nr2(self, value: float) -> None: ...
    @Nr4.setter
    def Nr4(self, value: float) -> None: ...
    @Nr6.setter
    def Nr6(self, value: float) -> None: ...
    @Nz1.setter
    def Nz1(self, value: float) -> None: ...
    @Nz2.setter
    def Nz2(self, value: float) -> None: ...
    @Nz3.setter
    def Nz3(self, value: float) -> None: ...

class ISurfaceGradient4(ISurface):
    @property
    def DeltaT(self) -> float: ...
    @property
    def DeltaTCell(self) -> IEditorCell: ...
    @property
    def n0(self) -> float: ...
    @property
    def n0Cell(self) -> IEditorCell: ...
    @property
    def Nx1(self) -> float: ...
    @property
    def Nx1Cell(self) -> IEditorCell: ...
    @property
    def Nx2(self) -> float: ...
    @property
    def Nx2Cell(self) -> IEditorCell: ...
    @property
    def Ny1(self) -> float: ...
    @property
    def Ny1Cell(self) -> IEditorCell: ...
    @property
    def Ny2(self) -> float: ...
    @property
    def Ny2Cell(self) -> IEditorCell: ...
    @property
    def Nz1(self) -> float: ...
    @property
    def Nz1Cell(self) -> IEditorCell: ...
    @property
    def Nz2(self) -> float: ...
    @property
    def Nz2Cell(self) -> IEditorCell: ...
    @DeltaT.setter
    def DeltaT(self, value: float) -> None: ...
    @n0.setter
    def n0(self, value: float) -> None: ...
    @Nx1.setter
    def Nx1(self, value: float) -> None: ...
    @Nx2.setter
    def Nx2(self, value: float) -> None: ...
    @Ny1.setter
    def Ny1(self, value: float) -> None: ...
    @Ny2.setter
    def Ny2(self, value: float) -> None: ...
    @Nz1.setter
    def Nz1(self, value: float) -> None: ...
    @Nz2.setter
    def Nz2(self, value: float) -> None: ...

class ISurfaceGradient5(ISurface):
    @property
    def DeltaT(self) -> float: ...
    @property
    def DeltaTCell(self) -> IEditorCell: ...
    @property
    def n0(self) -> float: ...
    @property
    def n0Cell(self) -> IEditorCell: ...
    @property
    def Nr2(self) -> float: ...
    @property
    def Nr2Cell(self) -> IEditorCell: ...
    @property
    def Nr4(self) -> float: ...
    @property
    def Nr4Cell(self) -> IEditorCell: ...
    @property
    def Nz1(self) -> float: ...
    @property
    def Nz1Cell(self) -> IEditorCell: ...
    @property
    def Nz2(self) -> float: ...
    @property
    def Nz2Cell(self) -> IEditorCell: ...
    @property
    def Nz3(self) -> float: ...
    @property
    def Nz3Cell(self) -> IEditorCell: ...
    @property
    def Nz4(self) -> float: ...
    @property
    def Nz4Cell(self) -> IEditorCell: ...
    @property
    def X_Tangent(self) -> float: ...
    @property
    def X_TangentCell(self) -> IEditorCell: ...
    @property
    def Y_Tangent(self) -> float: ...
    @property
    def Y_TangentCell(self) -> IEditorCell: ...
    @DeltaT.setter
    def DeltaT(self, value: float) -> None: ...
    @n0.setter
    def n0(self, value: float) -> None: ...
    @Nr2.setter
    def Nr2(self, value: float) -> None: ...
    @Nr4.setter
    def Nr4(self, value: float) -> None: ...
    @Nz1.setter
    def Nz1(self, value: float) -> None: ...
    @Nz2.setter
    def Nz2(self, value: float) -> None: ...
    @Nz3.setter
    def Nz3(self, value: float) -> None: ...
    @Nz4.setter
    def Nz4(self, value: float) -> None: ...
    @X_Tangent.setter
    def X_Tangent(self, value: float) -> None: ...
    @Y_Tangent.setter
    def Y_Tangent(self, value: float) -> None: ...

class ISurfaceGradient6(ISurface):
    @property
    def DeltaT(self) -> float: ...
    @property
    def DeltaTCell(self) -> IEditorCell: ...
    @DeltaT.setter
    def DeltaT(self, value: float) -> None: ...

class ISurfaceGradient7(ISurface):
    @property
    def Alpha(self) -> float: ...
    @property
    def AlphaCell(self) -> IEditorCell: ...
    @property
    def Beta(self) -> float: ...
    @property
    def BetaCell(self) -> IEditorCell: ...
    @property
    def DeltaT(self) -> float: ...
    @property
    def DeltaTCell(self) -> IEditorCell: ...
    @property
    def n0(self) -> float: ...
    @property
    def n0Cell(self) -> IEditorCell: ...
    @property
    def R(self) -> float: ...
    @property
    def RCell(self) -> IEditorCell: ...
    @Alpha.setter
    def Alpha(self, value: float) -> None: ...
    @Beta.setter
    def Beta(self, value: float) -> None: ...
    @DeltaT.setter
    def DeltaT(self, value: float) -> None: ...
    @n0.setter
    def n0(self, value: float) -> None: ...
    @R.setter
    def R(self, value: float) -> None: ...

class ISurfaceGradient9(ISurface):
    @property
    def DeltaT(self) -> float: ...
    @property
    def DeltaTCell(self) -> IEditorCell: ...
    @property
    def X_Tangent(self) -> float: ...
    @property
    def X_TangentCell(self) -> IEditorCell: ...
    @property
    def Y_Tangent(self) -> float: ...
    @property
    def Y_TangentCell(self) -> IEditorCell: ...
    @DeltaT.setter
    def DeltaT(self, value: float) -> None: ...
    @X_Tangent.setter
    def X_Tangent(self, value: float) -> None: ...
    @Y_Tangent.setter
    def Y_Tangent(self, value: float) -> None: ...

class ISurfaceGradium(ISurface):
    @property
    def BouleThickness(self) -> float: ...
    @property
    def BouleThicknessCell(self) -> IEditorCell: ...
    @property
    def Capping(self) -> float: ...
    @property
    def CappingCell(self) -> IEditorCell: ...
    @property
    def Dec_x(self) -> float: ...
    @property
    def Dec_x_Cell(self) -> IEditorCell: ...
    @property
    def Dec_y(self) -> float: ...
    @property
    def Dec_y_Cell(self) -> IEditorCell: ...
    @property
    def DeltaT(self) -> float: ...
    @property
    def DeltaTCell(self) -> IEditorCell: ...
    @property
    def DeltaZ(self) -> float: ...
    @property
    def DeltaZCell(self) -> IEditorCell: ...
    @property
    def Ref_n(self) -> float: ...
    @property
    def Ref_n_Cell(self) -> IEditorCell: ...
    @property
    def Tilt_x(self) -> float: ...
    @property
    def Tilt_x_Cell(self) -> IEditorCell: ...
    @property
    def Tilt_y(self) -> float: ...
    @property
    def Tilt_y_Cell(self) -> IEditorCell: ...
    @BouleThickness.setter
    def BouleThickness(self, value: float) -> None: ...
    @Capping.setter
    def Capping(self, value: float) -> None: ...
    @Dec_x.setter
    def Dec_x(self, value: float) -> None: ...
    @Dec_y.setter
    def Dec_y(self, value: float) -> None: ...
    @DeltaT.setter
    def DeltaT(self, value: float) -> None: ...
    @DeltaZ.setter
    def DeltaZ(self, value: float) -> None: ...
    @Ref_n.setter
    def Ref_n(self, value: float) -> None: ...
    @Tilt_x.setter
    def Tilt_x(self, value: float) -> None: ...
    @Tilt_y.setter
    def Tilt_y(self, value: float) -> None: ...

class ISurfaceGridGradient(ISurface):
    @property
    def DeltaT(self) -> float: ...
    @property
    def DeltaTCell(self) -> IEditorCell: ...
    @DeltaT.setter
    def DeltaT(self, value: float) -> None: ...

class ISurfaceGridPhase(ISurface):
    @property
    def DiffractOrder(self) -> float: ...
    @property
    def DiffractOrderCell(self) -> IEditorCell: ...
    @property
    def Interpolate(self) -> InterpolationMethod: ...
    @property
    def InterpolateCell(self) -> IEditorCell: ...
    @property
    def ShearDistance(self) -> float: ...
    @property
    def ShearDistanceCell(self) -> IEditorCell: ...
    @DiffractOrder.setter
    def DiffractOrder(self, value: float) -> None: ...
    @Interpolate.setter
    def Interpolate(self, value: InterpolationMethod) -> None: ...
    @ShearDistance.setter
    def ShearDistance(self, value: float) -> None: ...

class ISurfaceGridSag(ISurfaceNthEvenOrderTerms, ISurface, ISurfaceNthZernike):
    @property
    def Interpolate(self) -> InterpolationMethod: ...
    @property
    def InterpolateCell(self) -> IEditorCell: ...
    @property
    def ZernikeDecenter_X(self) -> float: ...
    @property
    def ZernikeDecenter_X_Cell(self) -> IEditorCell: ...
    @property
    def ZernikeDecenter_Y(self) -> float: ...
    @property
    def ZernikeDecenter_Y_Cell(self) -> IEditorCell: ...
    @Interpolate.setter
    def Interpolate(self, value: InterpolationMethod) -> None: ...
    @ZernikeDecenter_X.setter
    def ZernikeDecenter_X(self, value: float) -> None: ...
    @ZernikeDecenter_Y.setter
    def ZernikeDecenter_Y(self, value: float) -> None: ...

class ISurfaceHologram1(ISurface):
    @property
    def ConsiderFresnel(self) -> int: ...
    @property
    def ConsiderFresnelCell(self) -> IEditorCell: ...
    @property
    def Construct_X1(self) -> float: ...
    @property
    def Construct_X1_Cell(self) -> IEditorCell: ...
    @property
    def Construct_X2(self) -> float: ...
    @property
    def Construct_X2_Cell(self) -> IEditorCell: ...
    @property
    def Construct_Y1(self) -> float: ...
    @property
    def Construct_Y1_Cell(self) -> IEditorCell: ...
    @property
    def Construct_Y2(self) -> float: ...
    @property
    def Construct_Y2_Cell(self) -> IEditorCell: ...
    @property
    def Construct_Z1(self) -> float: ...
    @property
    def Construct_Z1_Cell(self) -> IEditorCell: ...
    @property
    def Construct_Z2(self) -> float: ...
    @property
    def Construct_Z2_Cell(self) -> IEditorCell: ...
    @property
    def ConstructWave(self) -> float: ...
    @property
    def ConstructWaveCell(self) -> IEditorCell: ...
    @property
    def DiffractOrder(self) -> float: ...
    @property
    def DiffractOrderCell(self) -> IEditorCell: ...
    @property
    def dn(self) -> float: ...
    @property
    def dnCell(self) -> IEditorCell: ...
    @property
    def HologramThickness(self) -> float: ...
    @property
    def HologramThicknessCell(self) -> IEditorCell: ...
    @property
    def IndexShift(self) -> float: ...
    @property
    def IndexShiftCell(self) -> IEditorCell: ...
    @property
    def IsVolumeHologram(self) -> int: ...
    @property
    def IsVolumeHologramCell(self) -> IEditorCell: ...
    @property
    def n(self) -> float: ...
    @property
    def n1(self) -> float: ...
    @property
    def n1Cell(self) -> IEditorCell: ...
    @property
    def n2(self) -> float: ...
    @property
    def n2Cell(self) -> IEditorCell: ...
    @property
    def nCell(self) -> IEditorCell: ...
    @property
    def Shrinkage(self) -> float: ...
    @property
    def ShrinkageCell(self) -> IEditorCell: ...
    @ConsiderFresnel.setter
    def ConsiderFresnel(self, value: int) -> None: ...
    @Construct_X1.setter
    def Construct_X1(self, value: float) -> None: ...
    @Construct_X2.setter
    def Construct_X2(self, value: float) -> None: ...
    @Construct_Y1.setter
    def Construct_Y1(self, value: float) -> None: ...
    @Construct_Y2.setter
    def Construct_Y2(self, value: float) -> None: ...
    @Construct_Z1.setter
    def Construct_Z1(self, value: float) -> None: ...
    @Construct_Z2.setter
    def Construct_Z2(self, value: float) -> None: ...
    @ConstructWave.setter
    def ConstructWave(self, value: float) -> None: ...
    @DiffractOrder.setter
    def DiffractOrder(self, value: float) -> None: ...
    @dn.setter
    def dn(self, value: float) -> None: ...
    @HologramThickness.setter
    def HologramThickness(self, value: float) -> None: ...
    @IndexShift.setter
    def IndexShift(self, value: float) -> None: ...
    @IsVolumeHologram.setter
    def IsVolumeHologram(self, value: int) -> None: ...
    @n.setter
    def n(self, value: float) -> None: ...
    @n1.setter
    def n1(self, value: float) -> None: ...
    @n2.setter
    def n2(self, value: float) -> None: ...
    @Shrinkage.setter
    def Shrinkage(self, value: float) -> None: ...

class ISurfaceHologram2(ISurface):
    @property
    def ConsiderFresnel(self) -> int: ...
    @property
    def ConsiderFresnelCell(self) -> IEditorCell: ...
    @property
    def Construct_X1(self) -> float: ...
    @property
    def Construct_X1_Cell(self) -> IEditorCell: ...
    @property
    def Construct_X2(self) -> float: ...
    @property
    def Construct_X2_Cell(self) -> IEditorCell: ...
    @property
    def Construct_Y1(self) -> float: ...
    @property
    def Construct_Y1_Cell(self) -> IEditorCell: ...
    @property
    def Construct_Y2(self) -> float: ...
    @property
    def Construct_Y2_Cell(self) -> IEditorCell: ...
    @property
    def Construct_Z1(self) -> float: ...
    @property
    def Construct_Z1_Cell(self) -> IEditorCell: ...
    @property
    def Construct_Z2(self) -> float: ...
    @property
    def Construct_Z2_Cell(self) -> IEditorCell: ...
    @property
    def ConstructWave(self) -> float: ...
    @property
    def ConstructWaveCell(self) -> IEditorCell: ...
    @property
    def DiffractOrder(self) -> float: ...
    @property
    def DiffractOrderCell(self) -> IEditorCell: ...
    @property
    def dn(self) -> float: ...
    @property
    def dnCell(self) -> IEditorCell: ...
    @property
    def HologramThickness(self) -> float: ...
    @property
    def HologramThicknessCell(self) -> IEditorCell: ...
    @property
    def IndexShift(self) -> float: ...
    @property
    def IndexShiftCell(self) -> IEditorCell: ...
    @property
    def IsVolumeHologram(self) -> int: ...
    @property
    def IsVolumeHologramCell(self) -> IEditorCell: ...
    @property
    def n(self) -> float: ...
    @property
    def n1(self) -> float: ...
    @property
    def n1Cell(self) -> IEditorCell: ...
    @property
    def n2(self) -> float: ...
    @property
    def n2Cell(self) -> IEditorCell: ...
    @property
    def nCell(self) -> IEditorCell: ...
    @property
    def Shrinkage(self) -> float: ...
    @property
    def ShrinkageCell(self) -> IEditorCell: ...
    @ConsiderFresnel.setter
    def ConsiderFresnel(self, value: int) -> None: ...
    @Construct_X1.setter
    def Construct_X1(self, value: float) -> None: ...
    @Construct_X2.setter
    def Construct_X2(self, value: float) -> None: ...
    @Construct_Y1.setter
    def Construct_Y1(self, value: float) -> None: ...
    @Construct_Y2.setter
    def Construct_Y2(self, value: float) -> None: ...
    @Construct_Z1.setter
    def Construct_Z1(self, value: float) -> None: ...
    @Construct_Z2.setter
    def Construct_Z2(self, value: float) -> None: ...
    @ConstructWave.setter
    def ConstructWave(self, value: float) -> None: ...
    @DiffractOrder.setter
    def DiffractOrder(self, value: float) -> None: ...
    @dn.setter
    def dn(self, value: float) -> None: ...
    @HologramThickness.setter
    def HologramThickness(self, value: float) -> None: ...
    @IndexShift.setter
    def IndexShift(self, value: float) -> None: ...
    @IsVolumeHologram.setter
    def IsVolumeHologram(self, value: int) -> None: ...
    @n.setter
    def n(self, value: float) -> None: ...
    @n1.setter
    def n1(self, value: float) -> None: ...
    @n2.setter
    def n2(self, value: float) -> None: ...
    @Shrinkage.setter
    def Shrinkage(self, value: float) -> None: ...

class ISurfaceIrregular(ISurface):
    @property
    def Angle(self) -> float: ...
    @property
    def AngleCell(self) -> IEditorCell: ...
    @property
    def Astigmatism(self) -> float: ...
    @property
    def AstigmatismCell(self) -> IEditorCell: ...
    @property
    def Coma(self) -> float: ...
    @property
    def ComaCell(self) -> IEditorCell: ...
    @property
    def Decenter_X(self) -> float: ...
    @property
    def Decenter_X_Cell(self) -> IEditorCell: ...
    @property
    def Decenter_Y(self) -> float: ...
    @property
    def Decenter_Y_Cell(self) -> IEditorCell: ...
    @property
    def Spherical(self) -> float: ...
    @property
    def SphericalCell(self) -> IEditorCell: ...
    @property
    def TiltAbout_X(self) -> float: ...
    @property
    def TiltAbout_X_Cell(self) -> IEditorCell: ...
    @property
    def TiltAbout_Y(self) -> float: ...
    @property
    def TiltAbout_Y_Cell(self) -> IEditorCell: ...
    @Angle.setter
    def Angle(self, value: float) -> None: ...
    @Astigmatism.setter
    def Astigmatism(self, value: float) -> None: ...
    @Coma.setter
    def Coma(self, value: float) -> None: ...
    @Decenter_X.setter
    def Decenter_X(self, value: float) -> None: ...
    @Decenter_Y.setter
    def Decenter_Y(self, value: float) -> None: ...
    @Spherical.setter
    def Spherical(self, value: float) -> None: ...
    @TiltAbout_X.setter
    def TiltAbout_X(self, value: float) -> None: ...
    @TiltAbout_Y.setter
    def TiltAbout_Y(self, value: float) -> None: ...

class ISurfaceJonesMatrix(ISurface):
    @property
    def Ai(self) -> float: ...
    @property
    def Ai_Cell(self) -> IEditorCell: ...
    @property
    def Ar(self) -> float: ...
    @property
    def Ar_Cell(self) -> IEditorCell: ...
    @property
    def Bi(self) -> float: ...
    @property
    def Bi_Cell(self) -> IEditorCell: ...
    @property
    def Br(self) -> float: ...
    @property
    def Br_Cell(self) -> IEditorCell: ...
    @property
    def Ci(self) -> float: ...
    @property
    def Ci_Cell(self) -> IEditorCell: ...
    @property
    def Cr(self) -> float: ...
    @property
    def Cr_Cell(self) -> IEditorCell: ...
    @property
    def Di(self) -> float: ...
    @property
    def Di_Cell(self) -> IEditorCell: ...
    @property
    def Dr(self) -> float: ...
    @property
    def Dr_Cell(self) -> IEditorCell: ...
    @Ai.setter
    def Ai(self, value: float) -> None: ...
    @Ar.setter
    def Ar(self, value: float) -> None: ...
    @Bi.setter
    def Bi(self, value: float) -> None: ...
    @Br.setter
    def Br(self, value: float) -> None: ...
    @Ci.setter
    def Ci(self, value: float) -> None: ...
    @Cr.setter
    def Cr(self, value: float) -> None: ...
    @Di.setter
    def Di(self, value: float) -> None: ...
    @Dr.setter
    def Dr(self, value: float) -> None: ...

class ISurfaceNonSequential(ISurface):
    @property
    def DrawPorts(self) -> int: ...
    @property
    def DrawPortsCell(self) -> IEditorCell: ...
    @property
    def ExitLocation_X(self) -> float: ...
    @property
    def ExitLocation_X_Cell(self) -> IEditorCell: ...
    @property
    def ExitLocation_Y(self) -> float: ...
    @property
    def ExitLocation_Y_Cell(self) -> IEditorCell: ...
    @property
    def ExitLocation_Z(self) -> float: ...
    @property
    def ExitLocation_Z_Cell(self) -> IEditorCell: ...
    @property
    def ExitTilt_X(self) -> float: ...
    @property
    def ExitTilt_X_Cell(self) -> IEditorCell: ...
    @property
    def ExitTilt_Y(self) -> float: ...
    @property
    def ExitTilt_Y_Cell(self) -> IEditorCell: ...
    @property
    def ExitTilt_Z(self) -> float: ...
    @property
    def ExitTilt_Z_Cell(self) -> IEditorCell: ...
    @property
    def Order(self) -> int: ...
    @property
    def OrderCell(self) -> IEditorCell: ...
    @property
    def ReverseRays(self) -> int: ...
    @property
    def ReverseRaysCell(self) -> IEditorCell: ...
    @DrawPorts.setter
    def DrawPorts(self, value: int) -> None: ...
    @ExitLocation_X.setter
    def ExitLocation_X(self, value: float) -> None: ...
    @ExitLocation_Y.setter
    def ExitLocation_Y(self, value: float) -> None: ...
    @ExitLocation_Z.setter
    def ExitLocation_Z(self, value: float) -> None: ...
    @ExitTilt_X.setter
    def ExitTilt_X(self, value: float) -> None: ...
    @ExitTilt_Y.setter
    def ExitTilt_Y(self, value: float) -> None: ...
    @ExitTilt_Z.setter
    def ExitTilt_Z(self, value: float) -> None: ...
    @Order.setter
    def Order(self, value: int) -> None: ...
    @ReverseRays.setter
    def ReverseRays(self, value: int) -> None: ...

class ISurfaceNthEvenOrderTerms(ISurface):
    def GetNthEvenOrderTerm(self, n: int) -> float: ...
    def NthEvenOrderTermCell(self, n: int) -> IEditorCell: ...
    def SetNthEvenOrderTerm(self, n: int, Value: float) -> None: ...

class ISurfaceNthOrderTerms(ISurface):
    def GetNthOrderTerm(self, n: int) -> float: ...
    def NthOrderTermCell(self, n: int) -> IEditorCell: ...
    def SetNthOrderTerm(self, n: int, Value: float) -> None: ...

class ISurfaceNthThickness(ISurface):
    @property
    def NumberOfTerms(self) -> int: ...
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    def GetNthThickness(self, n: int) -> float: ...
    def NthThicknessCell(self, n: int) -> IEditorCell: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    def SetNthThickness(self, n: int, Value: float) -> None: ...

class ISurfaceNthZernike(ISurface):
    @property
    def NormRadius(self) -> float: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    def GetNthZernikeCoefficient(self, n: int) -> float: ...
    def NthZernikeCoefficientCell(self, n: int) -> IEditorCell: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    def SetNthZernikeCoefficient(self, n: int, Value: float) -> None: ...

class ISurfaceOddAsphere(ISurfaceNthOrderTerms, ISurface):
    pass

class ISurfaceOddCosine(ISurfaceCoeff_R_NthPower, ISurface, ISurfaceAPBC):
    @property
    def NormRadius(self) -> float: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...

class ISurfaceOffAxisConicFreeform(ISurfaceXYPolynomial, ISurface):
    @property
    def NormRadius(self) -> float: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def Offset(self) -> float: ...
    @property
    def OffsetCell(self) -> IEditorCell: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...
    @Offset.setter
    def Offset(self, value: float) -> None: ...

class ISurfaceOpticallyFabricatedHologram(ISurfaceXYPolynomial, ISurface):
    @property
    def a(self) -> float: ...
    @property
    def aCell(self) -> IEditorCell: ...
    @property
    def b(self) -> float: ...
    @property
    def bCell(self) -> IEditorCell: ...
    @property
    def c(self) -> float: ...
    @property
    def cCell(self) -> IEditorCell: ...
    @property
    def Conic(self) -> float: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def ConsiderFresnel(self) -> int: ...
    @property
    def ConsiderFresnelCell(self) -> IEditorCell: ...
    @property
    def Curvature(self) -> float: ...
    @property
    def CurvatureCell(self) -> IEditorCell: ...
    @property
    def DiffractOrder(self) -> float: ...
    @property
    def DiffractOrderCell(self) -> IEditorCell: ...
    @property
    def dn(self) -> float: ...
    @property
    def dnCell(self) -> IEditorCell: ...
    @property
    def HologramThickness(self) -> float: ...
    @property
    def HologramThicknessCell(self) -> IEditorCell: ...
    @property
    def HologramType(self) -> int: ...
    @property
    def HologramTypeCell(self) -> IEditorCell: ...
    @property
    def IndexShift(self) -> float: ...
    @property
    def IndexShiftCell(self) -> IEditorCell: ...
    @property
    def n(self) -> float: ...
    @property
    def nCell(self) -> IEditorCell: ...
    @property
    def NormRadius(self) -> float: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def OPDMode(self) -> int: ...
    @property
    def OPDModeCell(self) -> IEditorCell: ...
    @property
    def Rotation_R(self) -> float: ...
    @property
    def Rotation_R_Cell(self) -> IEditorCell: ...
    @property
    def Shape(self) -> int: ...
    @property
    def ShapeCell(self) -> IEditorCell: ...
    @property
    def Shrinkage(self) -> float: ...
    @property
    def ShrinkageCell(self) -> IEditorCell: ...
    @a.setter
    def a(self, value: float) -> None: ...
    @b.setter
    def b(self, value: float) -> None: ...
    @c.setter
    def c(self, value: float) -> None: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @ConsiderFresnel.setter
    def ConsiderFresnel(self, value: int) -> None: ...
    @Curvature.setter
    def Curvature(self, value: float) -> None: ...
    @DiffractOrder.setter
    def DiffractOrder(self, value: float) -> None: ...
    @dn.setter
    def dn(self, value: float) -> None: ...
    @HologramThickness.setter
    def HologramThickness(self, value: float) -> None: ...
    @HologramType.setter
    def HologramType(self, value: int) -> None: ...
    @IndexShift.setter
    def IndexShift(self, value: float) -> None: ...
    @n.setter
    def n(self, value: float) -> None: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...
    @OPDMode.setter
    def OPDMode(self, value: int) -> None: ...
    @Rotation_R.setter
    def Rotation_R(self, value: float) -> None: ...
    @Shape.setter
    def Shape(self, value: int) -> None: ...
    @Shrinkage.setter
    def Shrinkage(self, value: float) -> None: ...

class ISurfaceParaxial(ISurface):
    @property
    def FocalLength(self) -> float: ...
    @property
    def FocalLengthCell(self) -> IEditorCell: ...
    @property
    def OPDMode(self) -> int: ...
    @property
    def OPDModeCell(self) -> IEditorCell: ...
    @FocalLength.setter
    def FocalLength(self, value: float) -> None: ...
    @OPDMode.setter
    def OPDMode(self, value: int) -> None: ...

class ISurfaceParaxialXY(ISurface):
    @property
    def X_Power(self) -> float: ...
    @property
    def X_PowerCell(self) -> IEditorCell: ...
    @property
    def Y_Power(self) -> float: ...
    @property
    def Y_PowerCell(self) -> IEditorCell: ...
    @X_Power.setter
    def X_Power(self, value: float) -> None: ...
    @Y_Power.setter
    def Y_Power(self, value: float) -> None: ...

class ISurfacePeriodic(ISurface):
    @property
    def Amplitude(self) -> float: ...
    @property
    def AmplitudeCell(self) -> IEditorCell: ...
    @property
    def X_Frequency(self) -> float: ...
    @property
    def X_FrequencyCell(self) -> IEditorCell: ...
    @property
    def Y_Frequency(self) -> float: ...
    @property
    def Y_FrequencyCell(self) -> IEditorCell: ...
    @Amplitude.setter
    def Amplitude(self, value: float) -> None: ...
    @X_Frequency.setter
    def X_Frequency(self, value: float) -> None: ...
    @Y_Frequency.setter
    def Y_Frequency(self, value: float) -> None: ...

class ISurfacePolynomial(ISurfaceCoeff_X_NthEvenPower_8, ISurface, ISurfaceCoeff_Y_NthEvenPower_8):
    pass

class ISurfaceQTypeAsphere(ISurface):
    def AnCell(self, n: int) -> IEditorCell: ...
    @property
    def NormRadius(self) -> float: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    @property
    def QType(self) -> QTypes: ...
    @property
    def TypeCell(self) -> IEditorCell: ...
    def GetAn(self, n: int) -> float: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    @QType.setter
    def QType(self, value: QTypes) -> None: ...
    def SetAn(self, n: int, Value: float) -> None: ...

class ISurfaceQTypeFreeform(ISurface):
    def AmnCell(self, m: int, n: int) -> IEditorCell: ...
    def BmnCell(self, m: int, n: int) -> IEditorCell: ...
    @property
    def DecenterX(self) -> float: ...
    @property
    def DecenterXCell(self) -> IEditorCell: ...
    @property
    def DecenterY(self) -> float: ...
    @property
    def DecenterYCell(self) -> IEditorCell: ...
    @property
    def MaxPolynomialPower(self) -> int: ...
    @property
    def MaxPolynomialPowerCell(self) -> IEditorCell: ...
    @property
    def NormRadius(self) -> float: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    def GetAmn(self, m: int, n: int) -> float: ...
    def GetBmn(self, m: int, n: int) -> float: ...
    @DecenterX.setter
    def DecenterX(self, value: float) -> None: ...
    @DecenterY.setter
    def DecenterY(self, value: float) -> None: ...
    @MaxPolynomialPower.setter
    def MaxPolynomialPower(self, value: int) -> None: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...
    def SetAmn(self, m: int, n: int, Value: float) -> None: ...
    def SetBmn(self, m: int, n: int, Value: float) -> None: ...

class ISurfaceRadialGrating(ISurfaceNthEvenOrderTerms, ISurface, ISurfaceCoeff_P_NthPower):
    @property
    def DeffractOrder(self) -> float: ...
    @property
    def DeffractOrderCell(self) -> IEditorCell: ...
    @property
    def GratingMode(self) -> int: ...
    @property
    def GratingModeCell(self) -> IEditorCell: ...
    @property
    def NormRadius(self) -> float: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @DeffractOrder.setter
    def DeffractOrder(self, value: float) -> None: ...
    @GratingMode.setter
    def GratingMode(self, value: int) -> None: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...

class ISurfaceRadialNurbs(ISurface):
    @property
    def NumberOfTerms(self) -> int: ...
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    def GetWn(self, n: int) -> float: ...
    def GetYn(self, n: int) -> float: ...
    def GetZn(self, n: int) -> float: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    def SetWn(self, n: int, Value: float) -> None: ...
    def SetYn(self, n: int, Value: float) -> None: ...
    def SetZn(self, n: int, Value: float) -> None: ...
    def WnCell(self, n: int) -> IEditorCell: ...
    def YnCell(self, n: int) -> IEditorCell: ...
    def ZnCell(self, n: int) -> IEditorCell: ...

class ISurfaceRetroReflect(ISurface):
    pass

class ISurfaceScatteringABg(ISurfaceScatteringType):
    @property
    def ABgName(self) -> str: ...
    def GetAvailableABgNames(self) -> list[str]: ...
    @ABgName.setter
    def ABgName(self, value: str) -> None: ...

class ISurfaceScatteringABgFile(ISurfaceScatteringType):
    @property
    def FileName(self) -> str: ...
    def GetAvailableFileNames(self) -> list[str]: ...
    @FileName.setter
    def FileName(self, value: str) -> None: ...

class ISurfaceScatteringBSDF(ISurfaceScatteringType):
    @property
    def Angle(self) -> float: ...
    @property
    def FileName(self) -> str: ...
    @property
    def ScatterFraction(self) -> float: ...
    def GetAvailableFileNames(self) -> list[str]: ...
    @Angle.setter
    def Angle(self, value: float) -> None: ...
    @FileName.setter
    def FileName(self, value: str) -> None: ...
    @ScatterFraction.setter
    def ScatterFraction(self, value: float) -> None: ...

class ISurfaceScatteringCatalog(ISurfaceScatteringType):
    @property
    def Angle(self) -> float: ...
    @property
    def SampleSide(self) -> SampleSides: ...
    @property
    def Sampling(self) -> Samplings: ...
    def GetAvailableFiles(self) -> list[str]: ...
    def GetFile(self) -> str: ...
    def GetSampleSides(self) -> list[SampleSides]: ...
    @Angle.setter
    def Angle(self, value: float) -> None: ...
    @SampleSide.setter
    def SampleSide(self, value: SampleSides) -> None: ...
    @Sampling.setter
    def Sampling(self, value: Samplings) -> None: ...
    def SetFile(self, File: str) -> ReflectTransmitCode: ...

class ISurfaceScatteringGaussian(ISurfaceScatteringType):
    @property
    def ScatterFraction(self) -> float: ...
    @property
    def Sigma(self) -> float: ...
    @ScatterFraction.setter
    def ScatterFraction(self, value: float) -> None: ...
    @Sigma.setter
    def Sigma(self, value: float) -> None: ...

class ISurfaceScatteringLambertian(ISurfaceScatteringType):
    @property
    def ScatterFraction(self) -> float: ...
    @ScatterFraction.setter
    def ScatterFraction(self, value: float) -> None: ...

class ISurfaceScatteringNone(ISurfaceScatteringType):
    pass

class ISurfaceScatteringType:
    @property
    def _S_ABg(self) -> ISurfaceScatteringABg: ...
    @property
    def _S_ABgFile(self) -> ISurfaceScatteringABgFile: ...
    @property
    def _S_BSDF(self) -> ISurfaceScatteringBSDF: ...
    @property
    def _S_Catalog(self) -> ISurfaceScatteringCatalog: ...
    @property
    def _S_Gaussian(self) -> ISurfaceScatteringGaussian: ...
    @property
    def _S_Lambertian(self) -> ISurfaceScatteringLambertian: ...
    @property
    def _S_None(self) -> ISurfaceScatteringNone: ...
    @property
    def _S_User(self) -> ISurfaceScatteringUser: ...
    @property
    def Type(self) -> SurfaceScatteringTypes: ...

class ISurfaceScatteringUser(ISurfaceScatteringType):
    @property
    def DLLName(self) -> str: ...
    @property
    def NumberOfParameters(self) -> int: ...
    def GetAvailableDLLNames(self) -> list[str]: ...
    def GetParameterName(self, paramIdx: int) -> str: ...
    def GetParameterValue(self, paramIdx: int) -> float: ...
    @DLLName.setter
    def DLLName(self, value: str) -> None: ...
    def SetParameterValue(self, paramIdx: int, Value: float) -> bool: ...

class ISurfaceSlide(ISurface):
    @property
    def Mode(self) -> int: ...
    @property
    def ModeCell(self) -> IEditorCell: ...
    @property
    def X_HalfWidth(self) -> float: ...
    @property
    def X_HalfWidthCell(self) -> IEditorCell: ...
    @property
    def Y_HalfWidth(self) -> float: ...
    @property
    def Y_HalfWidthCell(self) -> IEditorCell: ...
    @Mode.setter
    def Mode(self, value: int) -> None: ...
    @X_HalfWidth.setter
    def X_HalfWidth(self, value: float) -> None: ...
    @Y_HalfWidth.setter
    def Y_HalfWidth(self, value: float) -> None: ...

class ISurfaceStandard(ISurface):
    pass

class ISurfaceSuperconic(ISurface):
    @property
    def NumberOfTerms(self) -> int: ...
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    def GetUn(self, n: int) -> float: ...
    def GetVn(self, n: int) -> float: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    def SetUn(self, n: int, Value: float) -> None: ...
    def SetVn(self, n: int, Value: float) -> None: ...
    def UnCell(self, n: int) -> IEditorCell: ...
    def VnCell(self, n: int) -> IEditorCell: ...

class ISurfaceTilted(ISurface):
    @property
    def X_Tangent(self) -> float: ...
    @property
    def X_TangentCell(self) -> IEditorCell: ...
    @property
    def Y_Tangent(self) -> float: ...
    @property
    def Y_TangentCell(self) -> IEditorCell: ...
    @X_Tangent.setter
    def X_Tangent(self, value: float) -> None: ...
    @Y_Tangent.setter
    def Y_Tangent(self, value: float) -> None: ...

class ISurfaceToroidal(ISurfaceNthEvenOrderTerms, ISurface, ISurfaceNthZernike):
    @property
    def Extrapolate(self) -> int: ...
    @property
    def ExtrapolateCell(self) -> IEditorCell: ...
    @property
    def RadiusOfRotation(self) -> float: ...
    @property
    def RadiusOfRotationCell(self) -> IEditorCell: ...
    @Extrapolate.setter
    def Extrapolate(self, value: int) -> None: ...
    @RadiusOfRotation.setter
    def RadiusOfRotation(self, value: float) -> None: ...

class ISurfaceToroidalGrat(ISurface):
    @property
    def DiffractionOrder(self) -> float: ...
    @property
    def DiffractionOrderCell(self) -> IEditorCell: ...
    @property
    def LinesPerMicroMeter(self) -> float: ...
    @property
    def LinesPerMicroMeterCell(self) -> IEditorCell: ...
    @property
    def RadiusOfRotation(self) -> float: ...
    @property
    def RadiusOfRotationCell(self) -> IEditorCell: ...
    @DiffractionOrder.setter
    def DiffractionOrder(self, value: float) -> None: ...
    @LinesPerMicroMeter.setter
    def LinesPerMicroMeter(self, value: float) -> None: ...
    @RadiusOfRotation.setter
    def RadiusOfRotation(self, value: float) -> None: ...

class ISurfaceToroidalHologram(ISurfaceNthEvenOrderTerms, ISurface):
    @property
    def ConsiderFresnel(self) -> int: ...
    @property
    def ConsiderFresnelCell(self) -> IEditorCell: ...
    @property
    def Const_X1(self) -> float: ...
    @property
    def Const_X1_Cell(self) -> IEditorCell: ...
    @property
    def Const_X2(self) -> float: ...
    @property
    def Const_X2_Cell(self) -> IEditorCell: ...
    @property
    def Const_Y1(self) -> float: ...
    @property
    def Const_Y1_Cell(self) -> IEditorCell: ...
    @property
    def Const_Y2(self) -> float: ...
    @property
    def Const_Y2_Cell(self) -> IEditorCell: ...
    @property
    def Const_Z1(self) -> float: ...
    @property
    def Const_Z1_Cell(self) -> IEditorCell: ...
    @property
    def Const_Z2(self) -> float: ...
    @property
    def Const_Z2_Cell(self) -> IEditorCell: ...
    @property
    def ConstWave(self) -> float: ...
    @property
    def ConstWaveCell(self) -> IEditorCell: ...
    @property
    def dn(self) -> float: ...
    @property
    def dnCell(self) -> IEditorCell: ...
    @property
    def Flag(self) -> int: ...
    @property
    def FlagCell(self) -> IEditorCell: ...
    @property
    def HologramThickness(self) -> float: ...
    @property
    def HologramThicknessCell(self) -> IEditorCell: ...
    @property
    def IndexShift(self) -> float: ...
    @property
    def IndexShiftCell(self) -> IEditorCell: ...
    @property
    def IsVolumeHologram(self) -> int: ...
    @property
    def IsVolumeHologramCell(self) -> IEditorCell: ...
    @property
    def n(self) -> float: ...
    @property
    def n1(self) -> float: ...
    @property
    def n1Cell(self) -> IEditorCell: ...
    @property
    def n2(self) -> float: ...
    @property
    def n2Cell(self) -> IEditorCell: ...
    @property
    def nCell(self) -> IEditorCell: ...
    @property
    def Order(self) -> float: ...
    @property
    def OrderCell(self) -> IEditorCell: ...
    @property
    def RadiusOfRotation(self) -> float: ...
    @property
    def RadiusOfRotationCell(self) -> IEditorCell: ...
    @property
    def Shrinkage(self) -> float: ...
    @property
    def ShrinkageCell(self) -> IEditorCell: ...
    @ConsiderFresnel.setter
    def ConsiderFresnel(self, value: int) -> None: ...
    @Const_X1.setter
    def Const_X1(self, value: float) -> None: ...
    @Const_X2.setter
    def Const_X2(self, value: float) -> None: ...
    @Const_Y1.setter
    def Const_Y1(self, value: float) -> None: ...
    @Const_Y2.setter
    def Const_Y2(self, value: float) -> None: ...
    @Const_Z1.setter
    def Const_Z1(self, value: float) -> None: ...
    @Const_Z2.setter
    def Const_Z2(self, value: float) -> None: ...
    @ConstWave.setter
    def ConstWave(self, value: float) -> None: ...
    @dn.setter
    def dn(self, value: float) -> None: ...
    @Flag.setter
    def Flag(self, value: int) -> None: ...
    @HologramThickness.setter
    def HologramThickness(self, value: float) -> None: ...
    @IndexShift.setter
    def IndexShift(self, value: float) -> None: ...
    @IsVolumeHologram.setter
    def IsVolumeHologram(self, value: int) -> None: ...
    @n.setter
    def n(self, value: float) -> None: ...
    @n1.setter
    def n1(self, value: float) -> None: ...
    @n2.setter
    def n2(self, value: float) -> None: ...
    @Order.setter
    def Order(self, value: float) -> None: ...
    @RadiusOfRotation.setter
    def RadiusOfRotation(self, value: float) -> None: ...
    @Shrinkage.setter
    def Shrinkage(self, value: float) -> None: ...

class ISurfaceToroidalNurbs(ISurface):
    @property
    def Maximum_X(self) -> float: ...
    @property
    def Maximum_X_Cell(self) -> IEditorCell: ...
    @property
    def MaximumAngle(self) -> float: ...
    @property
    def MaximumAngleCell(self) -> IEditorCell: ...
    @property
    def Minimum_X(self) -> float: ...
    @property
    def Minimum_X_Cell(self) -> IEditorCell: ...
    @property
    def MinimumAngle(self) -> float: ...
    @property
    def MinimumAngleCell(self) -> IEditorCell: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    @property
    def RadiusOfRotation(self) -> float: ...
    @property
    def RadiusOfRotationCell(self) -> IEditorCell: ...
    def GetWn(self, n: int) -> float: ...
    def GetYn(self, n: int) -> float: ...
    def GetZn(self, n: int) -> float: ...
    @Maximum_X.setter
    def Maximum_X(self, value: float) -> None: ...
    @MaximumAngle.setter
    def MaximumAngle(self, value: float) -> None: ...
    @Minimum_X.setter
    def Minimum_X(self, value: float) -> None: ...
    @MinimumAngle.setter
    def MinimumAngle(self, value: float) -> None: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    @RadiusOfRotation.setter
    def RadiusOfRotation(self, value: float) -> None: ...
    def SetWn(self, n: int, Value: float) -> None: ...
    def SetYn(self, n: int, Value: float) -> None: ...
    def SetZn(self, n: int, Value: float) -> None: ...
    def WnCell(self, n: int) -> IEditorCell: ...
    def YnCell(self, n: int) -> IEditorCell: ...
    def ZnCell(self, n: int) -> IEditorCell: ...

class ISurfaceTrueFreeform(
    ISurfaceNthEvenOrderTerms, ISurface, ISurfaceFreeformNthZernike, ISurfaceFreeformXYPolynomial
):
    @property
    def ConicX(self) -> float: ...
    @property
    def ConicXCell(self) -> IEditorCell: ...
    @property
    def NumVariablePoints(self) -> int: ...
    @property
    def NumVariablePointsCell(self) -> IEditorCell: ...
    @property
    def RadiusX(self) -> float: ...
    @property
    def RadiusXCell(self) -> IEditorCell: ...
    @property
    def ZernikeDecenter_X(self) -> float: ...
    @property
    def ZernikeDecenter_X_Cell(self) -> IEditorCell: ...
    @property
    def ZernikeDecenter_Y(self) -> float: ...
    @property
    def ZernikeDecenter_Y_Cell(self) -> IEditorCell: ...
    @ConicX.setter
    def ConicX(self, value: float) -> None: ...
    @RadiusX.setter
    def RadiusX(self, value: float) -> None: ...
    @ZernikeDecenter_X.setter
    def ZernikeDecenter_X(self, value: float) -> None: ...
    @ZernikeDecenter_Y.setter
    def ZernikeDecenter_Y(self, value: float) -> None: ...

class ISurfaceTypeSettings:
    @property
    def Filename(self) -> str: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def RequiresFile(self) -> bool: ...
    @property
    def Type(self) -> SurfaceType: ...
    def GetFileNames(self) -> list[str]: ...
    @Filename.setter
    def Filename(self, value: str) -> None: ...

class ISurfaceVariableLineSpaceGrating(ISurface):
    @property
    def CosineAlpha(self) -> float: ...
    @property
    def CosineAlphaCell(self) -> IEditorCell: ...
    @property
    def CosineBeta(self) -> float: ...
    @property
    def CosineBetaCell(self) -> IEditorCell: ...
    @property
    def DiffractOrder(self) -> float: ...
    @property
    def DiffractOrderCell(self) -> IEditorCell: ...
    @property
    def FocalRadius_L(self) -> float: ...
    @property
    def FocalRadius_L_Cell(self) -> IEditorCell: ...
    @property
    def LambdaZero(self) -> float: ...
    @property
    def LambdaZeroCell(self) -> IEditorCell: ...
    @CosineAlpha.setter
    def CosineAlpha(self, value: float) -> None: ...
    @CosineBeta.setter
    def CosineBeta(self, value: float) -> None: ...
    @DiffractOrder.setter
    def DiffractOrder(self, value: float) -> None: ...
    @FocalRadius_L.setter
    def FocalRadius_L(self, value: float) -> None: ...
    @LambdaZero.setter
    def LambdaZero(self, value: float) -> None: ...

class ISurfaceXYPolynomial(ISurface):
    @property
    def NumberOfTerms(self) -> int: ...
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    @property
    def X0Y1(self) -> float: ...
    @property
    def X0Y10(self) -> float: ...
    @property
    def X0Y10Cell(self) -> IEditorCell: ...
    @property
    def X0Y11(self) -> float: ...
    @property
    def X0Y11Cell(self) -> IEditorCell: ...
    @property
    def X0Y12(self) -> float: ...
    @property
    def X0Y12Cell(self) -> IEditorCell: ...
    @property
    def X0Y13(self) -> float: ...
    @property
    def X0Y13Cell(self) -> IEditorCell: ...
    @property
    def X0Y14(self) -> float: ...
    @property
    def X0Y14Cell(self) -> IEditorCell: ...
    @property
    def X0Y15(self) -> float: ...
    @property
    def X0Y15Cell(self) -> IEditorCell: ...
    @property
    def X0Y16(self) -> float: ...
    @property
    def X0Y16Cell(self) -> IEditorCell: ...
    @property
    def X0Y17(self) -> float: ...
    @property
    def X0Y17Cell(self) -> IEditorCell: ...
    @property
    def X0Y18(self) -> float: ...
    @property
    def X0Y18Cell(self) -> IEditorCell: ...
    @property
    def X0Y19(self) -> float: ...
    @property
    def X0Y19Cell(self) -> IEditorCell: ...
    @property
    def X0Y1Cell(self) -> IEditorCell: ...
    @property
    def X0Y2(self) -> float: ...
    @property
    def X0Y20(self) -> float: ...
    @property
    def X0Y20Cell(self) -> IEditorCell: ...
    @property
    def X0Y2Cell(self) -> IEditorCell: ...
    @property
    def X0Y3(self) -> float: ...
    @property
    def X0Y3Cell(self) -> IEditorCell: ...
    @property
    def X0Y4(self) -> float: ...
    @property
    def X0Y4Cell(self) -> IEditorCell: ...
    @property
    def X0Y5(self) -> float: ...
    @property
    def X0Y5Cell(self) -> IEditorCell: ...
    @property
    def X0Y6(self) -> float: ...
    @property
    def X0Y6Cell(self) -> IEditorCell: ...
    @property
    def X0Y7(self) -> float: ...
    @property
    def X0Y7Cell(self) -> IEditorCell: ...
    @property
    def X0Y8(self) -> float: ...
    @property
    def X0Y8Cell(self) -> IEditorCell: ...
    @property
    def X0Y9(self) -> float: ...
    @property
    def X0Y9Cell(self) -> IEditorCell: ...
    @property
    def X10Y0(self) -> float: ...
    @property
    def X10Y0Cell(self) -> IEditorCell: ...
    @property
    def X10Y1(self) -> float: ...
    @property
    def X10Y10(self) -> float: ...
    @property
    def X10Y10Cell(self) -> IEditorCell: ...
    @property
    def X10Y11(self) -> float: ...
    @property
    def X10Y11Cell(self) -> IEditorCell: ...
    @property
    def X10Y1Cell(self) -> IEditorCell: ...
    @property
    def X10Y2(self) -> float: ...
    @property
    def X10Y2Cell(self) -> IEditorCell: ...
    @property
    def X10Y3(self) -> float: ...
    @property
    def X10Y3Cell(self) -> IEditorCell: ...
    @property
    def X10Y4(self) -> float: ...
    @property
    def X10Y4Cell(self) -> IEditorCell: ...
    @property
    def X10Y5(self) -> float: ...
    @property
    def X10Y5Cell(self) -> IEditorCell: ...
    @property
    def X10Y6(self) -> float: ...
    @property
    def X10Y6Cell(self) -> IEditorCell: ...
    @property
    def X10Y7(self) -> float: ...
    @property
    def X10Y7Cell(self) -> IEditorCell: ...
    @property
    def X10Y8(self) -> float: ...
    @property
    def X10Y8Cell(self) -> IEditorCell: ...
    @property
    def X10Y9(self) -> float: ...
    @property
    def X10Y9Cell(self) -> IEditorCell: ...
    @property
    def X11Y0(self) -> float: ...
    @property
    def X11Y0Cell(self) -> IEditorCell: ...
    @property
    def X11Y1(self) -> float: ...
    @property
    def X11Y10(self) -> float: ...
    @property
    def X11Y10Cell(self) -> IEditorCell: ...
    @property
    def X11Y1Cell(self) -> IEditorCell: ...
    @property
    def X11Y2(self) -> float: ...
    @property
    def X11Y2Cell(self) -> IEditorCell: ...
    @property
    def X11Y3(self) -> float: ...
    @property
    def X11Y3Cell(self) -> IEditorCell: ...
    @property
    def X11Y4(self) -> float: ...
    @property
    def X11Y4Cell(self) -> IEditorCell: ...
    @property
    def X11Y5(self) -> float: ...
    @property
    def X11Y5Cell(self) -> IEditorCell: ...
    @property
    def X11Y6(self) -> float: ...
    @property
    def X11Y6Cell(self) -> IEditorCell: ...
    @property
    def X11Y7(self) -> float: ...
    @property
    def X11Y7Cell(self) -> IEditorCell: ...
    @property
    def X11Y8(self) -> float: ...
    @property
    def X11Y8Cell(self) -> IEditorCell: ...
    @property
    def X11Y9(self) -> float: ...
    @property
    def X11Y9Cell(self) -> IEditorCell: ...
    @property
    def X12Y0(self) -> float: ...
    @property
    def X12Y0Cell(self) -> IEditorCell: ...
    @property
    def X12Y1(self) -> float: ...
    @property
    def X12Y1Cell(self) -> IEditorCell: ...
    @property
    def X12Y2(self) -> float: ...
    @property
    def X12Y2Cell(self) -> IEditorCell: ...
    @property
    def X12Y3(self) -> float: ...
    @property
    def X12Y3Cell(self) -> IEditorCell: ...
    @property
    def X12Y4(self) -> float: ...
    @property
    def X12Y4Cell(self) -> IEditorCell: ...
    @property
    def X12Y5(self) -> float: ...
    @property
    def X12Y5Cell(self) -> IEditorCell: ...
    @property
    def X12Y6(self) -> float: ...
    @property
    def X12Y6Cell(self) -> IEditorCell: ...
    @property
    def X12Y7(self) -> float: ...
    @property
    def X12Y7Cell(self) -> IEditorCell: ...
    @property
    def X12Y8(self) -> float: ...
    @property
    def X12Y8Cell(self) -> IEditorCell: ...
    @property
    def X12Y9(self) -> float: ...
    @property
    def X12Y9Cell(self) -> IEditorCell: ...
    @property
    def X13Y0(self) -> float: ...
    @property
    def X13Y0Cell(self) -> IEditorCell: ...
    @property
    def X13Y1(self) -> float: ...
    @property
    def X13Y1Cell(self) -> IEditorCell: ...
    @property
    def X13Y2(self) -> float: ...
    @property
    def X13Y2Cell(self) -> IEditorCell: ...
    @property
    def X13Y3(self) -> float: ...
    @property
    def X13Y3Cell(self) -> IEditorCell: ...
    @property
    def X13Y4(self) -> float: ...
    @property
    def X13Y4Cell(self) -> IEditorCell: ...
    @property
    def X13Y5(self) -> float: ...
    @property
    def X13Y5Cell(self) -> IEditorCell: ...
    @property
    def X13Y6(self) -> float: ...
    @property
    def X13Y6Cell(self) -> IEditorCell: ...
    @property
    def X13Y7(self) -> float: ...
    @property
    def X13Y7Cell(self) -> IEditorCell: ...
    @property
    def X13Y8(self) -> float: ...
    @property
    def X13Y8Cell(self) -> IEditorCell: ...
    @property
    def X14Y0(self) -> float: ...
    @property
    def X14Y0Cell(self) -> IEditorCell: ...
    @property
    def X14Y1(self) -> float: ...
    @property
    def X14Y1Cell(self) -> IEditorCell: ...
    @property
    def X14Y2(self) -> float: ...
    @property
    def X14Y2Cell(self) -> IEditorCell: ...
    @property
    def X14Y3(self) -> float: ...
    @property
    def X14Y3Cell(self) -> IEditorCell: ...
    @property
    def X14Y4(self) -> float: ...
    @property
    def X14Y4Cell(self) -> IEditorCell: ...
    @property
    def X14Y5(self) -> float: ...
    @property
    def X14Y5Cell(self) -> IEditorCell: ...
    @property
    def X14Y6(self) -> float: ...
    @property
    def X14Y6Cell(self) -> IEditorCell: ...
    @property
    def X14Y7(self) -> float: ...
    @property
    def X14Y7Cell(self) -> IEditorCell: ...
    @property
    def X15Y0(self) -> float: ...
    @property
    def X15Y0Cell(self) -> IEditorCell: ...
    @property
    def X15Y1(self) -> float: ...
    @property
    def X15Y1Cell(self) -> IEditorCell: ...
    @property
    def X15Y2(self) -> float: ...
    @property
    def X15Y2Cell(self) -> IEditorCell: ...
    @property
    def X15Y3(self) -> float: ...
    @property
    def X15Y3Cell(self) -> IEditorCell: ...
    @property
    def X15Y4(self) -> float: ...
    @property
    def X15Y4Cell(self) -> IEditorCell: ...
    @property
    def X15Y5(self) -> float: ...
    @property
    def X15Y5Cell(self) -> IEditorCell: ...
    @property
    def X15Y6(self) -> float: ...
    @property
    def X15Y6Cell(self) -> IEditorCell: ...
    @property
    def X16Y0(self) -> float: ...
    @property
    def X16Y0Cell(self) -> IEditorCell: ...
    @property
    def X16Y1(self) -> float: ...
    @property
    def X16Y1Cell(self) -> IEditorCell: ...
    @property
    def X16Y2(self) -> float: ...
    @property
    def X16Y2Cell(self) -> IEditorCell: ...
    @property
    def X16Y3(self) -> float: ...
    @property
    def X16Y3Cell(self) -> IEditorCell: ...
    @property
    def X16Y4(self) -> float: ...
    @property
    def X16Y4Cell(self) -> IEditorCell: ...
    @property
    def X16Y5(self) -> float: ...
    @property
    def X16Y5Cell(self) -> IEditorCell: ...
    @property
    def X17Y0(self) -> float: ...
    @property
    def X17Y0Cell(self) -> IEditorCell: ...
    @property
    def X17Y1(self) -> float: ...
    @property
    def X17Y1Cell(self) -> IEditorCell: ...
    @property
    def X17Y2(self) -> float: ...
    @property
    def X17Y2Cell(self) -> IEditorCell: ...
    @property
    def X17Y3(self) -> float: ...
    @property
    def X17Y3Cell(self) -> IEditorCell: ...
    @property
    def X17Y4(self) -> float: ...
    @property
    def X17Y4Cell(self) -> IEditorCell: ...
    @property
    def X18Y0(self) -> float: ...
    @property
    def X18Y0Cell(self) -> IEditorCell: ...
    @property
    def X18Y1(self) -> float: ...
    @property
    def X18Y1Cell(self) -> IEditorCell: ...
    @property
    def X18Y2(self) -> float: ...
    @property
    def X18Y2Cell(self) -> IEditorCell: ...
    @property
    def X18Y3(self) -> float: ...
    @property
    def X18Y3Cell(self) -> IEditorCell: ...
    @property
    def X19Y0(self) -> float: ...
    @property
    def X19Y0Cell(self) -> IEditorCell: ...
    @property
    def X19Y1(self) -> float: ...
    @property
    def X19Y1Cell(self) -> IEditorCell: ...
    @property
    def X19Y2(self) -> float: ...
    @property
    def X19Y2Cell(self) -> IEditorCell: ...
    @property
    def X1Y0(self) -> float: ...
    @property
    def X1Y0Cell(self) -> IEditorCell: ...
    @property
    def X1Y1(self) -> float: ...
    @property
    def X1Y10(self) -> float: ...
    @property
    def X1Y10Cell(self) -> IEditorCell: ...
    @property
    def X1Y11(self) -> float: ...
    @property
    def X1Y11Cell(self) -> IEditorCell: ...
    @property
    def X1Y12(self) -> float: ...
    @property
    def X1Y12Cell(self) -> IEditorCell: ...
    @property
    def X1Y13(self) -> float: ...
    @property
    def X1Y13Cell(self) -> IEditorCell: ...
    @property
    def X1Y14(self) -> float: ...
    @property
    def X1Y14Cell(self) -> IEditorCell: ...
    @property
    def X1Y15(self) -> float: ...
    @property
    def X1Y15Cell(self) -> IEditorCell: ...
    @property
    def X1Y16(self) -> float: ...
    @property
    def X1Y16Cell(self) -> IEditorCell: ...
    @property
    def X1Y17(self) -> float: ...
    @property
    def X1Y17Cell(self) -> IEditorCell: ...
    @property
    def X1Y18(self) -> float: ...
    @property
    def X1Y18Cell(self) -> IEditorCell: ...
    @property
    def X1Y19(self) -> float: ...
    @property
    def X1Y19Cell(self) -> IEditorCell: ...
    @property
    def X1Y1Cell(self) -> IEditorCell: ...
    @property
    def X1Y2(self) -> float: ...
    @property
    def X1Y2Cell(self) -> IEditorCell: ...
    @property
    def X1Y3(self) -> float: ...
    @property
    def X1Y3Cell(self) -> IEditorCell: ...
    @property
    def X1Y4(self) -> float: ...
    @property
    def X1Y4Cell(self) -> IEditorCell: ...
    @property
    def X1Y5(self) -> float: ...
    @property
    def X1Y5Cell(self) -> IEditorCell: ...
    @property
    def X1Y6(self) -> float: ...
    @property
    def X1Y6Cell(self) -> IEditorCell: ...
    @property
    def X1Y7(self) -> float: ...
    @property
    def X1Y7Cell(self) -> IEditorCell: ...
    @property
    def X1Y8(self) -> float: ...
    @property
    def X1Y8Cell(self) -> IEditorCell: ...
    @property
    def X1Y9(self) -> float: ...
    @property
    def X1Y9Cell(self) -> IEditorCell: ...
    @property
    def X20Y0(self) -> float: ...
    @property
    def X20Y0Cell(self) -> IEditorCell: ...
    @property
    def X20Y1(self) -> float: ...
    @property
    def X20Y1Cell(self) -> IEditorCell: ...
    @property
    def X21Y0(self) -> float: ...
    @property
    def X21Y0Cell(self) -> IEditorCell: ...
    @property
    def X2Y0(self) -> float: ...
    @property
    def X2Y0Cell(self) -> IEditorCell: ...
    @property
    def X2Y1(self) -> float: ...
    @property
    def X2Y10(self) -> float: ...
    @property
    def X2Y10Cell(self) -> IEditorCell: ...
    @property
    def X2Y11(self) -> float: ...
    @property
    def X2Y11Cell(self) -> IEditorCell: ...
    @property
    def X2Y12(self) -> float: ...
    @property
    def X2Y12Cell(self) -> IEditorCell: ...
    @property
    def X2Y13(self) -> float: ...
    @property
    def X2Y13Cell(self) -> IEditorCell: ...
    @property
    def X2Y14(self) -> float: ...
    @property
    def X2Y14Cell(self) -> IEditorCell: ...
    @property
    def X2Y15(self) -> float: ...
    @property
    def X2Y15Cell(self) -> IEditorCell: ...
    @property
    def X2Y16(self) -> float: ...
    @property
    def X2Y16Cell(self) -> IEditorCell: ...
    @property
    def X2Y17(self) -> float: ...
    @property
    def X2Y17Cell(self) -> IEditorCell: ...
    @property
    def X2Y18(self) -> float: ...
    @property
    def X2Y18Cell(self) -> IEditorCell: ...
    @property
    def X2Y19(self) -> float: ...
    @property
    def X2Y19Cell(self) -> IEditorCell: ...
    @property
    def X2Y1Cell(self) -> IEditorCell: ...
    @property
    def X2Y2(self) -> float: ...
    @property
    def X2Y2Cell(self) -> IEditorCell: ...
    @property
    def X2Y3(self) -> float: ...
    @property
    def X2Y3Cell(self) -> IEditorCell: ...
    @property
    def X2Y4(self) -> float: ...
    @property
    def X2Y4Cell(self) -> IEditorCell: ...
    @property
    def X2Y5(self) -> float: ...
    @property
    def X2Y5Cell(self) -> IEditorCell: ...
    @property
    def X2Y6(self) -> float: ...
    @property
    def X2Y6Cell(self) -> IEditorCell: ...
    @property
    def X2Y7(self) -> float: ...
    @property
    def X2Y7Cell(self) -> IEditorCell: ...
    @property
    def X2Y8(self) -> float: ...
    @property
    def X2Y8Cell(self) -> IEditorCell: ...
    @property
    def X2Y9(self) -> float: ...
    @property
    def X2Y9Cell(self) -> IEditorCell: ...
    @property
    def X3Y0(self) -> float: ...
    @property
    def X3Y0Cell(self) -> IEditorCell: ...
    @property
    def X3Y1(self) -> float: ...
    @property
    def X3Y10(self) -> float: ...
    @property
    def X3Y10Cell(self) -> IEditorCell: ...
    @property
    def X3Y11(self) -> float: ...
    @property
    def X3Y11Cell(self) -> IEditorCell: ...
    @property
    def X3Y12(self) -> float: ...
    @property
    def X3Y12Cell(self) -> IEditorCell: ...
    @property
    def X3Y13(self) -> float: ...
    @property
    def X3Y13Cell(self) -> IEditorCell: ...
    @property
    def X3Y14(self) -> float: ...
    @property
    def X3Y14Cell(self) -> IEditorCell: ...
    @property
    def X3Y15(self) -> float: ...
    @property
    def X3Y15Cell(self) -> IEditorCell: ...
    @property
    def X3Y16(self) -> float: ...
    @property
    def X3Y16Cell(self) -> IEditorCell: ...
    @property
    def X3Y17(self) -> float: ...
    @property
    def X3Y17Cell(self) -> IEditorCell: ...
    @property
    def X3Y18(self) -> float: ...
    @property
    def X3Y18Cell(self) -> IEditorCell: ...
    @property
    def X3Y1Cell(self) -> IEditorCell: ...
    @property
    def X3Y2(self) -> float: ...
    @property
    def X3Y2Cell(self) -> IEditorCell: ...
    @property
    def X3Y3(self) -> float: ...
    @property
    def X3Y3Cell(self) -> IEditorCell: ...
    @property
    def X3Y4(self) -> float: ...
    @property
    def X3Y4Cell(self) -> IEditorCell: ...
    @property
    def X3Y5(self) -> float: ...
    @property
    def X3Y5Cell(self) -> IEditorCell: ...
    @property
    def X3Y6(self) -> float: ...
    @property
    def X3Y6Cell(self) -> IEditorCell: ...
    @property
    def X3Y7(self) -> float: ...
    @property
    def X3Y7Cell(self) -> IEditorCell: ...
    @property
    def X3Y8(self) -> float: ...
    @property
    def X3Y8Cell(self) -> IEditorCell: ...
    @property
    def X3Y9(self) -> float: ...
    @property
    def X3Y9Cell(self) -> IEditorCell: ...
    @property
    def X4Y0(self) -> float: ...
    @property
    def X4Y0Cell(self) -> IEditorCell: ...
    @property
    def X4Y1(self) -> float: ...
    @property
    def X4Y10(self) -> float: ...
    @property
    def X4Y10Cell(self) -> IEditorCell: ...
    @property
    def X4Y11(self) -> float: ...
    @property
    def X4Y11Cell(self) -> IEditorCell: ...
    @property
    def X4Y12(self) -> float: ...
    @property
    def X4Y12Cell(self) -> IEditorCell: ...
    @property
    def X4Y13(self) -> float: ...
    @property
    def X4Y13Cell(self) -> IEditorCell: ...
    @property
    def X4Y14(self) -> float: ...
    @property
    def X4Y14Cell(self) -> IEditorCell: ...
    @property
    def X4Y15(self) -> float: ...
    @property
    def X4Y15Cell(self) -> IEditorCell: ...
    @property
    def X4Y16(self) -> float: ...
    @property
    def X4Y16Cell(self) -> IEditorCell: ...
    @property
    def X4Y17(self) -> float: ...
    @property
    def X4Y17Cell(self) -> IEditorCell: ...
    @property
    def X4Y1Cell(self) -> IEditorCell: ...
    @property
    def X4Y2(self) -> float: ...
    @property
    def X4Y2Cell(self) -> IEditorCell: ...
    @property
    def X4Y3(self) -> float: ...
    @property
    def X4Y3Cell(self) -> IEditorCell: ...
    @property
    def X4Y4(self) -> float: ...
    @property
    def X4Y4Cell(self) -> IEditorCell: ...
    @property
    def X4Y5(self) -> float: ...
    @property
    def X4Y5Cell(self) -> IEditorCell: ...
    @property
    def X4Y6(self) -> float: ...
    @property
    def X4Y6Cell(self) -> IEditorCell: ...
    @property
    def X4Y7(self) -> float: ...
    @property
    def X4Y7Cell(self) -> IEditorCell: ...
    @property
    def X4Y8(self) -> float: ...
    @property
    def X4Y8Cell(self) -> IEditorCell: ...
    @property
    def X4Y9(self) -> float: ...
    @property
    def X4Y9Cell(self) -> IEditorCell: ...
    @property
    def X5Y0(self) -> float: ...
    @property
    def X5Y0Cell(self) -> IEditorCell: ...
    @property
    def X5Y1(self) -> float: ...
    @property
    def X5Y10(self) -> float: ...
    @property
    def X5Y10Cell(self) -> IEditorCell: ...
    @property
    def X5Y11(self) -> float: ...
    @property
    def X5Y11Cell(self) -> IEditorCell: ...
    @property
    def X5Y12(self) -> float: ...
    @property
    def X5Y12Cell(self) -> IEditorCell: ...
    @property
    def X5Y13(self) -> float: ...
    @property
    def X5Y13Cell(self) -> IEditorCell: ...
    @property
    def X5Y14(self) -> float: ...
    @property
    def X5Y14Cell(self) -> IEditorCell: ...
    @property
    def X5Y15(self) -> float: ...
    @property
    def X5Y15Cell(self) -> IEditorCell: ...
    @property
    def X5Y16(self) -> float: ...
    @property
    def X5Y16Cell(self) -> IEditorCell: ...
    @property
    def X5Y1Cell(self) -> IEditorCell: ...
    @property
    def X5Y2(self) -> float: ...
    @property
    def X5Y2Cell(self) -> IEditorCell: ...
    @property
    def X5Y3(self) -> float: ...
    @property
    def X5Y3Cell(self) -> IEditorCell: ...
    @property
    def X5Y4(self) -> float: ...
    @property
    def X5Y4Cell(self) -> IEditorCell: ...
    @property
    def X5Y5(self) -> float: ...
    @property
    def X5Y5Cell(self) -> IEditorCell: ...
    @property
    def X5Y6(self) -> float: ...
    @property
    def X5Y6Cell(self) -> IEditorCell: ...
    @property
    def X5Y7(self) -> float: ...
    @property
    def X5Y7Cell(self) -> IEditorCell: ...
    @property
    def X5Y8(self) -> float: ...
    @property
    def X5Y8Cell(self) -> IEditorCell: ...
    @property
    def X5Y9(self) -> float: ...
    @property
    def X5Y9Cell(self) -> IEditorCell: ...
    @property
    def X6Y0(self) -> float: ...
    @property
    def X6Y0Cell(self) -> IEditorCell: ...
    @property
    def X6Y1(self) -> float: ...
    @property
    def X6Y10(self) -> float: ...
    @property
    def X6Y10Cell(self) -> IEditorCell: ...
    @property
    def X6Y11(self) -> float: ...
    @property
    def X6Y11Cell(self) -> IEditorCell: ...
    @property
    def X6Y12(self) -> float: ...
    @property
    def X6Y12Cell(self) -> IEditorCell: ...
    @property
    def X6Y13(self) -> float: ...
    @property
    def X6Y13Cell(self) -> IEditorCell: ...
    @property
    def X6Y14(self) -> float: ...
    @property
    def X6Y14Cell(self) -> IEditorCell: ...
    @property
    def X6Y15(self) -> float: ...
    @property
    def X6Y15Cell(self) -> IEditorCell: ...
    @property
    def X6Y1Cell(self) -> IEditorCell: ...
    @property
    def X6Y2(self) -> float: ...
    @property
    def X6Y2Cell(self) -> IEditorCell: ...
    @property
    def X6Y3(self) -> float: ...
    @property
    def X6Y3Cell(self) -> IEditorCell: ...
    @property
    def X6Y4(self) -> float: ...
    @property
    def X6Y4Cell(self) -> IEditorCell: ...
    @property
    def X6Y5(self) -> float: ...
    @property
    def X6Y5Cell(self) -> IEditorCell: ...
    @property
    def X6Y6(self) -> float: ...
    @property
    def X6Y6Cell(self) -> IEditorCell: ...
    @property
    def X6Y7(self) -> float: ...
    @property
    def X6Y7Cell(self) -> IEditorCell: ...
    @property
    def X6Y8(self) -> float: ...
    @property
    def X6Y8Cell(self) -> IEditorCell: ...
    @property
    def X6Y9(self) -> float: ...
    @property
    def X6Y9Cell(self) -> IEditorCell: ...
    @property
    def X7Y0(self) -> float: ...
    @property
    def X7Y0Cell(self) -> IEditorCell: ...
    @property
    def X7Y1(self) -> float: ...
    @property
    def X7Y10(self) -> float: ...
    @property
    def X7Y10Cell(self) -> IEditorCell: ...
    @property
    def X7Y11(self) -> float: ...
    @property
    def X7Y11Cell(self) -> IEditorCell: ...
    @property
    def X7Y12(self) -> float: ...
    @property
    def X7Y12Cell(self) -> IEditorCell: ...
    @property
    def X7Y13(self) -> float: ...
    @property
    def X7Y13Cell(self) -> IEditorCell: ...
    @property
    def X7Y14(self) -> float: ...
    @property
    def X7Y14Cell(self) -> IEditorCell: ...
    @property
    def X7Y1Cell(self) -> IEditorCell: ...
    @property
    def X7Y2(self) -> float: ...
    @property
    def X7Y2Cell(self) -> IEditorCell: ...
    @property
    def X7Y3(self) -> float: ...
    @property
    def X7Y3Cell(self) -> IEditorCell: ...
    @property
    def X7Y4(self) -> float: ...
    @property
    def X7Y4Cell(self) -> IEditorCell: ...
    @property
    def X7Y5(self) -> float: ...
    @property
    def X7Y5Cell(self) -> IEditorCell: ...
    @property
    def X7Y6(self) -> float: ...
    @property
    def X7Y6Cell(self) -> IEditorCell: ...
    @property
    def X7Y7(self) -> float: ...
    @property
    def X7Y7Cell(self) -> IEditorCell: ...
    @property
    def X7Y8(self) -> float: ...
    @property
    def X7Y8Cell(self) -> IEditorCell: ...
    @property
    def X7Y9(self) -> float: ...
    @property
    def X7Y9Cell(self) -> IEditorCell: ...
    @property
    def X8Y0(self) -> float: ...
    @property
    def X8Y0Cell(self) -> IEditorCell: ...
    @property
    def X8Y1(self) -> float: ...
    @property
    def X8Y10(self) -> float: ...
    @property
    def X8Y10Cell(self) -> IEditorCell: ...
    @property
    def X8Y11(self) -> float: ...
    @property
    def X8Y11Cell(self) -> IEditorCell: ...
    @property
    def X8Y12(self) -> float: ...
    @property
    def X8Y12Cell(self) -> IEditorCell: ...
    @property
    def X8Y13(self) -> float: ...
    @property
    def X8Y13Cell(self) -> IEditorCell: ...
    @property
    def X8Y1Cell(self) -> IEditorCell: ...
    @property
    def X8Y2(self) -> float: ...
    @property
    def X8Y2Cell(self) -> IEditorCell: ...
    @property
    def X8Y3(self) -> float: ...
    @property
    def X8Y3Cell(self) -> IEditorCell: ...
    @property
    def X8Y4(self) -> float: ...
    @property
    def X8Y4Cell(self) -> IEditorCell: ...
    @property
    def X8Y5(self) -> float: ...
    @property
    def X8Y5Cell(self) -> IEditorCell: ...
    @property
    def X8Y6(self) -> float: ...
    @property
    def X8Y6Cell(self) -> IEditorCell: ...
    @property
    def X8Y7(self) -> float: ...
    @property
    def X8Y7Cell(self) -> IEditorCell: ...
    @property
    def X8Y8(self) -> float: ...
    @property
    def X8Y8Cell(self) -> IEditorCell: ...
    @property
    def X8Y9(self) -> float: ...
    @property
    def X8Y9Cell(self) -> IEditorCell: ...
    @property
    def X9Y0(self) -> float: ...
    @property
    def X9Y0Cell(self) -> IEditorCell: ...
    @property
    def X9Y1(self) -> float: ...
    @property
    def X9Y10(self) -> float: ...
    @property
    def X9Y10Cell(self) -> IEditorCell: ...
    @property
    def X9Y11(self) -> float: ...
    @property
    def X9Y11Cell(self) -> IEditorCell: ...
    @property
    def X9Y12(self) -> float: ...
    @property
    def X9Y12Cell(self) -> IEditorCell: ...
    @property
    def X9Y1Cell(self) -> IEditorCell: ...
    @property
    def X9Y2(self) -> float: ...
    @property
    def X9Y2Cell(self) -> IEditorCell: ...
    @property
    def X9Y3(self) -> float: ...
    @property
    def X9Y3Cell(self) -> IEditorCell: ...
    @property
    def X9Y4(self) -> float: ...
    @property
    def X9Y4Cell(self) -> IEditorCell: ...
    @property
    def X9Y5(self) -> float: ...
    @property
    def X9Y5Cell(self) -> IEditorCell: ...
    @property
    def X9Y6(self) -> float: ...
    @property
    def X9Y6Cell(self) -> IEditorCell: ...
    @property
    def X9Y7(self) -> float: ...
    @property
    def X9Y7Cell(self) -> IEditorCell: ...
    @property
    def X9Y8(self) -> float: ...
    @property
    def X9Y8Cell(self) -> IEditorCell: ...
    @property
    def X9Y9(self) -> float: ...
    @property
    def X9Y9Cell(self) -> IEditorCell: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    @X0Y1.setter
    def X0Y1(self, value: float) -> None: ...
    @X0Y10.setter
    def X0Y10(self, value: float) -> None: ...
    @X0Y11.setter
    def X0Y11(self, value: float) -> None: ...
    @X0Y12.setter
    def X0Y12(self, value: float) -> None: ...
    @X0Y13.setter
    def X0Y13(self, value: float) -> None: ...
    @X0Y14.setter
    def X0Y14(self, value: float) -> None: ...
    @X0Y15.setter
    def X0Y15(self, value: float) -> None: ...
    @X0Y16.setter
    def X0Y16(self, value: float) -> None: ...
    @X0Y17.setter
    def X0Y17(self, value: float) -> None: ...
    @X0Y18.setter
    def X0Y18(self, value: float) -> None: ...
    @X0Y19.setter
    def X0Y19(self, value: float) -> None: ...
    @X0Y2.setter
    def X0Y2(self, value: float) -> None: ...
    @X0Y20.setter
    def X0Y20(self, value: float) -> None: ...
    @X0Y3.setter
    def X0Y3(self, value: float) -> None: ...
    @X0Y4.setter
    def X0Y4(self, value: float) -> None: ...
    @X0Y5.setter
    def X0Y5(self, value: float) -> None: ...
    @X0Y6.setter
    def X0Y6(self, value: float) -> None: ...
    @X0Y7.setter
    def X0Y7(self, value: float) -> None: ...
    @X0Y8.setter
    def X0Y8(self, value: float) -> None: ...
    @X0Y9.setter
    def X0Y9(self, value: float) -> None: ...
    @X10Y0.setter
    def X10Y0(self, value: float) -> None: ...
    @X10Y1.setter
    def X10Y1(self, value: float) -> None: ...
    @X10Y10.setter
    def X10Y10(self, value: float) -> None: ...
    @X10Y11.setter
    def X10Y11(self, value: float) -> None: ...
    @X10Y2.setter
    def X10Y2(self, value: float) -> None: ...
    @X10Y3.setter
    def X10Y3(self, value: float) -> None: ...
    @X10Y4.setter
    def X10Y4(self, value: float) -> None: ...
    @X10Y5.setter
    def X10Y5(self, value: float) -> None: ...
    @X10Y6.setter
    def X10Y6(self, value: float) -> None: ...
    @X10Y7.setter
    def X10Y7(self, value: float) -> None: ...
    @X10Y8.setter
    def X10Y8(self, value: float) -> None: ...
    @X10Y9.setter
    def X10Y9(self, value: float) -> None: ...
    @X11Y0.setter
    def X11Y0(self, value: float) -> None: ...
    @X11Y1.setter
    def X11Y1(self, value: float) -> None: ...
    @X11Y10.setter
    def X11Y10(self, value: float) -> None: ...
    @X11Y2.setter
    def X11Y2(self, value: float) -> None: ...
    @X11Y3.setter
    def X11Y3(self, value: float) -> None: ...
    @X11Y4.setter
    def X11Y4(self, value: float) -> None: ...
    @X11Y5.setter
    def X11Y5(self, value: float) -> None: ...
    @X11Y6.setter
    def X11Y6(self, value: float) -> None: ...
    @X11Y7.setter
    def X11Y7(self, value: float) -> None: ...
    @X11Y8.setter
    def X11Y8(self, value: float) -> None: ...
    @X11Y9.setter
    def X11Y9(self, value: float) -> None: ...
    @X12Y0.setter
    def X12Y0(self, value: float) -> None: ...
    @X12Y1.setter
    def X12Y1(self, value: float) -> None: ...
    @X12Y2.setter
    def X12Y2(self, value: float) -> None: ...
    @X12Y3.setter
    def X12Y3(self, value: float) -> None: ...
    @X12Y4.setter
    def X12Y4(self, value: float) -> None: ...
    @X12Y5.setter
    def X12Y5(self, value: float) -> None: ...
    @X12Y6.setter
    def X12Y6(self, value: float) -> None: ...
    @X12Y7.setter
    def X12Y7(self, value: float) -> None: ...
    @X12Y8.setter
    def X12Y8(self, value: float) -> None: ...
    @X12Y9.setter
    def X12Y9(self, value: float) -> None: ...
    @X13Y0.setter
    def X13Y0(self, value: float) -> None: ...
    @X13Y1.setter
    def X13Y1(self, value: float) -> None: ...
    @X13Y2.setter
    def X13Y2(self, value: float) -> None: ...
    @X13Y3.setter
    def X13Y3(self, value: float) -> None: ...
    @X13Y4.setter
    def X13Y4(self, value: float) -> None: ...
    @X13Y5.setter
    def X13Y5(self, value: float) -> None: ...
    @X13Y6.setter
    def X13Y6(self, value: float) -> None: ...
    @X13Y7.setter
    def X13Y7(self, value: float) -> None: ...
    @X13Y8.setter
    def X13Y8(self, value: float) -> None: ...
    @X14Y0.setter
    def X14Y0(self, value: float) -> None: ...
    @X14Y1.setter
    def X14Y1(self, value: float) -> None: ...
    @X14Y2.setter
    def X14Y2(self, value: float) -> None: ...
    @X14Y3.setter
    def X14Y3(self, value: float) -> None: ...
    @X14Y4.setter
    def X14Y4(self, value: float) -> None: ...
    @X14Y5.setter
    def X14Y5(self, value: float) -> None: ...
    @X14Y6.setter
    def X14Y6(self, value: float) -> None: ...
    @X14Y7.setter
    def X14Y7(self, value: float) -> None: ...
    @X15Y0.setter
    def X15Y0(self, value: float) -> None: ...
    @X15Y1.setter
    def X15Y1(self, value: float) -> None: ...
    @X15Y2.setter
    def X15Y2(self, value: float) -> None: ...
    @X15Y3.setter
    def X15Y3(self, value: float) -> None: ...
    @X15Y4.setter
    def X15Y4(self, value: float) -> None: ...
    @X15Y5.setter
    def X15Y5(self, value: float) -> None: ...
    @X15Y6.setter
    def X15Y6(self, value: float) -> None: ...
    @X16Y0.setter
    def X16Y0(self, value: float) -> None: ...
    @X16Y1.setter
    def X16Y1(self, value: float) -> None: ...
    @X16Y2.setter
    def X16Y2(self, value: float) -> None: ...
    @X16Y3.setter
    def X16Y3(self, value: float) -> None: ...
    @X16Y4.setter
    def X16Y4(self, value: float) -> None: ...
    @X16Y5.setter
    def X16Y5(self, value: float) -> None: ...
    @X17Y0.setter
    def X17Y0(self, value: float) -> None: ...
    @X17Y1.setter
    def X17Y1(self, value: float) -> None: ...
    @X17Y2.setter
    def X17Y2(self, value: float) -> None: ...
    @X17Y3.setter
    def X17Y3(self, value: float) -> None: ...
    @X17Y4.setter
    def X17Y4(self, value: float) -> None: ...
    @X18Y0.setter
    def X18Y0(self, value: float) -> None: ...
    @X18Y1.setter
    def X18Y1(self, value: float) -> None: ...
    @X18Y2.setter
    def X18Y2(self, value: float) -> None: ...
    @X18Y3.setter
    def X18Y3(self, value: float) -> None: ...
    @X19Y0.setter
    def X19Y0(self, value: float) -> None: ...
    @X19Y1.setter
    def X19Y1(self, value: float) -> None: ...
    @X19Y2.setter
    def X19Y2(self, value: float) -> None: ...
    @X1Y0.setter
    def X1Y0(self, value: float) -> None: ...
    @X1Y1.setter
    def X1Y1(self, value: float) -> None: ...
    @X1Y10.setter
    def X1Y10(self, value: float) -> None: ...
    @X1Y11.setter
    def X1Y11(self, value: float) -> None: ...
    @X1Y12.setter
    def X1Y12(self, value: float) -> None: ...
    @X1Y13.setter
    def X1Y13(self, value: float) -> None: ...
    @X1Y14.setter
    def X1Y14(self, value: float) -> None: ...
    @X1Y15.setter
    def X1Y15(self, value: float) -> None: ...
    @X1Y16.setter
    def X1Y16(self, value: float) -> None: ...
    @X1Y17.setter
    def X1Y17(self, value: float) -> None: ...
    @X1Y18.setter
    def X1Y18(self, value: float) -> None: ...
    @X1Y19.setter
    def X1Y19(self, value: float) -> None: ...
    @X1Y2.setter
    def X1Y2(self, value: float) -> None: ...
    @X1Y3.setter
    def X1Y3(self, value: float) -> None: ...
    @X1Y4.setter
    def X1Y4(self, value: float) -> None: ...
    @X1Y5.setter
    def X1Y5(self, value: float) -> None: ...
    @X1Y6.setter
    def X1Y6(self, value: float) -> None: ...
    @X1Y7.setter
    def X1Y7(self, value: float) -> None: ...
    @X1Y8.setter
    def X1Y8(self, value: float) -> None: ...
    @X1Y9.setter
    def X1Y9(self, value: float) -> None: ...
    @X20Y0.setter
    def X20Y0(self, value: float) -> None: ...
    @X20Y1.setter
    def X20Y1(self, value: float) -> None: ...
    @X21Y0.setter
    def X21Y0(self, value: float) -> None: ...
    @X2Y0.setter
    def X2Y0(self, value: float) -> None: ...
    @X2Y1.setter
    def X2Y1(self, value: float) -> None: ...
    @X2Y10.setter
    def X2Y10(self, value: float) -> None: ...
    @X2Y11.setter
    def X2Y11(self, value: float) -> None: ...
    @X2Y12.setter
    def X2Y12(self, value: float) -> None: ...
    @X2Y13.setter
    def X2Y13(self, value: float) -> None: ...
    @X2Y14.setter
    def X2Y14(self, value: float) -> None: ...
    @X2Y15.setter
    def X2Y15(self, value: float) -> None: ...
    @X2Y16.setter
    def X2Y16(self, value: float) -> None: ...
    @X2Y17.setter
    def X2Y17(self, value: float) -> None: ...
    @X2Y18.setter
    def X2Y18(self, value: float) -> None: ...
    @X2Y19.setter
    def X2Y19(self, value: float) -> None: ...
    @X2Y2.setter
    def X2Y2(self, value: float) -> None: ...
    @X2Y3.setter
    def X2Y3(self, value: float) -> None: ...
    @X2Y4.setter
    def X2Y4(self, value: float) -> None: ...
    @X2Y5.setter
    def X2Y5(self, value: float) -> None: ...
    @X2Y6.setter
    def X2Y6(self, value: float) -> None: ...
    @X2Y7.setter
    def X2Y7(self, value: float) -> None: ...
    @X2Y8.setter
    def X2Y8(self, value: float) -> None: ...
    @X2Y9.setter
    def X2Y9(self, value: float) -> None: ...
    @X3Y0.setter
    def X3Y0(self, value: float) -> None: ...
    @X3Y1.setter
    def X3Y1(self, value: float) -> None: ...
    @X3Y10.setter
    def X3Y10(self, value: float) -> None: ...
    @X3Y11.setter
    def X3Y11(self, value: float) -> None: ...
    @X3Y12.setter
    def X3Y12(self, value: float) -> None: ...
    @X3Y13.setter
    def X3Y13(self, value: float) -> None: ...
    @X3Y14.setter
    def X3Y14(self, value: float) -> None: ...
    @X3Y15.setter
    def X3Y15(self, value: float) -> None: ...
    @X3Y16.setter
    def X3Y16(self, value: float) -> None: ...
    @X3Y17.setter
    def X3Y17(self, value: float) -> None: ...
    @X3Y18.setter
    def X3Y18(self, value: float) -> None: ...
    @X3Y2.setter
    def X3Y2(self, value: float) -> None: ...
    @X3Y3.setter
    def X3Y3(self, value: float) -> None: ...
    @X3Y4.setter
    def X3Y4(self, value: float) -> None: ...
    @X3Y5.setter
    def X3Y5(self, value: float) -> None: ...
    @X3Y6.setter
    def X3Y6(self, value: float) -> None: ...
    @X3Y7.setter
    def X3Y7(self, value: float) -> None: ...
    @X3Y8.setter
    def X3Y8(self, value: float) -> None: ...
    @X3Y9.setter
    def X3Y9(self, value: float) -> None: ...
    @X4Y0.setter
    def X4Y0(self, value: float) -> None: ...
    @X4Y1.setter
    def X4Y1(self, value: float) -> None: ...
    @X4Y10.setter
    def X4Y10(self, value: float) -> None: ...
    @X4Y11.setter
    def X4Y11(self, value: float) -> None: ...
    @X4Y12.setter
    def X4Y12(self, value: float) -> None: ...
    @X4Y13.setter
    def X4Y13(self, value: float) -> None: ...
    @X4Y14.setter
    def X4Y14(self, value: float) -> None: ...
    @X4Y15.setter
    def X4Y15(self, value: float) -> None: ...
    @X4Y16.setter
    def X4Y16(self, value: float) -> None: ...
    @X4Y17.setter
    def X4Y17(self, value: float) -> None: ...
    @X4Y2.setter
    def X4Y2(self, value: float) -> None: ...
    @X4Y3.setter
    def X4Y3(self, value: float) -> None: ...
    @X4Y4.setter
    def X4Y4(self, value: float) -> None: ...
    @X4Y5.setter
    def X4Y5(self, value: float) -> None: ...
    @X4Y6.setter
    def X4Y6(self, value: float) -> None: ...
    @X4Y7.setter
    def X4Y7(self, value: float) -> None: ...
    @X4Y8.setter
    def X4Y8(self, value: float) -> None: ...
    @X4Y9.setter
    def X4Y9(self, value: float) -> None: ...
    @X5Y0.setter
    def X5Y0(self, value: float) -> None: ...
    @X5Y1.setter
    def X5Y1(self, value: float) -> None: ...
    @X5Y10.setter
    def X5Y10(self, value: float) -> None: ...
    @X5Y11.setter
    def X5Y11(self, value: float) -> None: ...
    @X5Y12.setter
    def X5Y12(self, value: float) -> None: ...
    @X5Y13.setter
    def X5Y13(self, value: float) -> None: ...
    @X5Y14.setter
    def X5Y14(self, value: float) -> None: ...
    @X5Y15.setter
    def X5Y15(self, value: float) -> None: ...
    @X5Y16.setter
    def X5Y16(self, value: float) -> None: ...
    @X5Y2.setter
    def X5Y2(self, value: float) -> None: ...
    @X5Y3.setter
    def X5Y3(self, value: float) -> None: ...
    @X5Y4.setter
    def X5Y4(self, value: float) -> None: ...
    @X5Y5.setter
    def X5Y5(self, value: float) -> None: ...
    @X5Y6.setter
    def X5Y6(self, value: float) -> None: ...
    @X5Y7.setter
    def X5Y7(self, value: float) -> None: ...
    @X5Y8.setter
    def X5Y8(self, value: float) -> None: ...
    @X5Y9.setter
    def X5Y9(self, value: float) -> None: ...
    @X6Y0.setter
    def X6Y0(self, value: float) -> None: ...
    @X6Y1.setter
    def X6Y1(self, value: float) -> None: ...
    @X6Y10.setter
    def X6Y10(self, value: float) -> None: ...
    @X6Y11.setter
    def X6Y11(self, value: float) -> None: ...
    @X6Y12.setter
    def X6Y12(self, value: float) -> None: ...
    @X6Y13.setter
    def X6Y13(self, value: float) -> None: ...
    @X6Y14.setter
    def X6Y14(self, value: float) -> None: ...
    @X6Y15.setter
    def X6Y15(self, value: float) -> None: ...
    @X6Y2.setter
    def X6Y2(self, value: float) -> None: ...
    @X6Y3.setter
    def X6Y3(self, value: float) -> None: ...
    @X6Y4.setter
    def X6Y4(self, value: float) -> None: ...
    @X6Y5.setter
    def X6Y5(self, value: float) -> None: ...
    @X6Y6.setter
    def X6Y6(self, value: float) -> None: ...
    @X6Y7.setter
    def X6Y7(self, value: float) -> None: ...
    @X6Y8.setter
    def X6Y8(self, value: float) -> None: ...
    @X6Y9.setter
    def X6Y9(self, value: float) -> None: ...
    @X7Y0.setter
    def X7Y0(self, value: float) -> None: ...
    @X7Y1.setter
    def X7Y1(self, value: float) -> None: ...
    @X7Y10.setter
    def X7Y10(self, value: float) -> None: ...
    @X7Y11.setter
    def X7Y11(self, value: float) -> None: ...
    @X7Y12.setter
    def X7Y12(self, value: float) -> None: ...
    @X7Y13.setter
    def X7Y13(self, value: float) -> None: ...
    @X7Y14.setter
    def X7Y14(self, value: float) -> None: ...
    @X7Y2.setter
    def X7Y2(self, value: float) -> None: ...
    @X7Y3.setter
    def X7Y3(self, value: float) -> None: ...
    @X7Y4.setter
    def X7Y4(self, value: float) -> None: ...
    @X7Y5.setter
    def X7Y5(self, value: float) -> None: ...
    @X7Y6.setter
    def X7Y6(self, value: float) -> None: ...
    @X7Y7.setter
    def X7Y7(self, value: float) -> None: ...
    @X7Y8.setter
    def X7Y8(self, value: float) -> None: ...
    @X7Y9.setter
    def X7Y9(self, value: float) -> None: ...
    @X8Y0.setter
    def X8Y0(self, value: float) -> None: ...
    @X8Y1.setter
    def X8Y1(self, value: float) -> None: ...
    @X8Y10.setter
    def X8Y10(self, value: float) -> None: ...
    @X8Y11.setter
    def X8Y11(self, value: float) -> None: ...
    @X8Y12.setter
    def X8Y12(self, value: float) -> None: ...
    @X8Y13.setter
    def X8Y13(self, value: float) -> None: ...
    @X8Y2.setter
    def X8Y2(self, value: float) -> None: ...
    @X8Y3.setter
    def X8Y3(self, value: float) -> None: ...
    @X8Y4.setter
    def X8Y4(self, value: float) -> None: ...
    @X8Y5.setter
    def X8Y5(self, value: float) -> None: ...
    @X8Y6.setter
    def X8Y6(self, value: float) -> None: ...
    @X8Y7.setter
    def X8Y7(self, value: float) -> None: ...
    @X8Y8.setter
    def X8Y8(self, value: float) -> None: ...
    @X8Y9.setter
    def X8Y9(self, value: float) -> None: ...
    @X9Y0.setter
    def X9Y0(self, value: float) -> None: ...
    @X9Y1.setter
    def X9Y1(self, value: float) -> None: ...
    @X9Y10.setter
    def X9Y10(self, value: float) -> None: ...
    @X9Y11.setter
    def X9Y11(self, value: float) -> None: ...
    @X9Y12.setter
    def X9Y12(self, value: float) -> None: ...
    @X9Y2.setter
    def X9Y2(self, value: float) -> None: ...
    @X9Y3.setter
    def X9Y3(self, value: float) -> None: ...
    @X9Y4.setter
    def X9Y4(self, value: float) -> None: ...
    @X9Y5.setter
    def X9Y5(self, value: float) -> None: ...
    @X9Y6.setter
    def X9Y6(self, value: float) -> None: ...
    @X9Y7.setter
    def X9Y7(self, value: float) -> None: ...
    @X9Y8.setter
    def X9Y8(self, value: float) -> None: ...
    @X9Y9.setter
    def X9Y9(self, value: float) -> None: ...

class ISurfaceZernikeAnnularPhase(ISurfaceNthZernike, ISurface):
    @property
    def DiffractOrder(self) -> float: ...
    @property
    def DiffractOrderCell(self) -> IEditorCell: ...
    @property
    def Extrapolate(self) -> int: ...
    @property
    def ExtrapolateCell(self) -> IEditorCell: ...
    @property
    def Obscuration(self) -> float: ...
    @property
    def ObscurationCell(self) -> IEditorCell: ...
    @DiffractOrder.setter
    def DiffractOrder(self, value: float) -> None: ...
    @Extrapolate.setter
    def Extrapolate(self, value: int) -> None: ...
    @Obscuration.setter
    def Obscuration(self, value: float) -> None: ...

class ISurfaceZernikeFringePhase(ISurfaceNthZernike, ISurface):
    @property
    def DiffractOrder(self) -> float: ...
    @property
    def DiffractOrderCell(self) -> IEditorCell: ...
    @property
    def Extrapolate(self) -> int: ...
    @property
    def ExtrapolateCell(self) -> IEditorCell: ...
    @DiffractOrder.setter
    def DiffractOrder(self, value: float) -> None: ...
    @Extrapolate.setter
    def Extrapolate(self, value: int) -> None: ...

class ISurfaceZernikeFringeSag(ISurfaceNthZernike, ISurface, ISurfaceNthEvenOrderTerms):
    @property
    def Extrapolate(self) -> int: ...
    @property
    def ExtrapolateCell(self) -> IEditorCell: ...
    @property
    def ZernikeDecenter_X(self) -> float: ...
    @property
    def ZernikeDecenter_X_Cell(self) -> IEditorCell: ...
    @property
    def ZernikeDecenter_Y(self) -> float: ...
    @property
    def ZernikeDecenter_Y_Cell(self) -> IEditorCell: ...
    @Extrapolate.setter
    def Extrapolate(self, value: int) -> None: ...
    @ZernikeDecenter_X.setter
    def ZernikeDecenter_X(self, value: float) -> None: ...
    @ZernikeDecenter_Y.setter
    def ZernikeDecenter_Y(self, value: float) -> None: ...

class ISurfaceZernikeStandardPhase(ISurfaceNthZernike, ISurface):
    @property
    def DiffractOrder(self) -> float: ...
    @property
    def DiffractOrderCell(self) -> IEditorCell: ...
    @property
    def Extrapolate(self) -> int: ...
    @property
    def ExtrapolateCell(self) -> IEditorCell: ...
    @DiffractOrder.setter
    def DiffractOrder(self, value: float) -> None: ...
    @Extrapolate.setter
    def Extrapolate(self, value: int) -> None: ...

class ISurfaceZernikeStandardSag(ISurfaceNthZernike, ISurface, ISurfaceNthEvenOrderTerms):
    @property
    def Extrapolate(self) -> int: ...
    @property
    def ExtrapolateCell(self) -> IEditorCell: ...
    @property
    def ZernikeDecenter_X(self) -> float: ...
    @property
    def ZernikeDecenter_X_Cell(self) -> IEditorCell: ...
    @property
    def ZernikeDecenter_Y(self) -> float: ...
    @property
    def ZernikeDecenter_Y_Cell(self) -> IEditorCell: ...
    @Extrapolate.setter
    def Extrapolate(self, value: int) -> None: ...
    @ZernikeDecenter_X.setter
    def ZernikeDecenter_X(self, value: float) -> None: ...
    @ZernikeDecenter_Y.setter
    def ZernikeDecenter_Y(self, value: float) -> None: ...

class ISurfaceZonePlate(ISurfaceNthThickness, ISurface):
    @property
    def Delta_R(self) -> float: ...
    @property
    def Delta_R_Cell(self) -> IEditorCell: ...
    @property
    def Mode(self) -> float: ...
    @property
    def ModeCell(self) -> IEditorCell: ...
    @property
    def ReferenceWave(self) -> float: ...
    @property
    def ReferenceWaveCell(self) -> IEditorCell: ...
    @Delta_R.setter
    def Delta_R(self, value: float) -> None: ...
    @Mode.setter
    def Mode(self, value: float) -> None: ...
    @ReferenceWave.setter
    def ReferenceWave(self, value: float) -> None: ...

class NodesDataType:
    SurfaceDeformationNoRBM = 1
    RefractiveIndex = 2
    TemperatureAndRefractiveIndex = 3
    SurfaceDeformation = 4

class PilotRadiusMode:
    BestFit = 0
    Shorter = 1
    Longer = 2
    X = 3
    Y = 4
    Plane = 5
    User = 6

class PointCloudFileFormat:
    ASCII = 0
    Binary = 1
    CompressedBinary = 2

class PupilApodizationType:
    # None = 0
    Gaussian = 1
    Tangential = 2

class QTypes:
    Qbfs = 0
    Qcon = 1

class STARDeformationOption:
    DeformationWithRBMs = 0
    DeformationWithoutRBMs = 1
    OnlyRBMs = 2
    NoDeformation = 3

class SubstrateType:
    # None = 0
    Flat = 1
    Curved = 2

class SurfaceApertureTypes:
    # None = 0
    CircularAperture = 1
    CircularObscuration = 2
    Spider = 3
    RectangularAperture = 4
    RectangularObscuration = 5
    EllipticalAperture = 6
    EllipticalObscuration = 7
    UserAperture = 8
    UserObscuration = 9
    FloatingAperture = 10

class SurfaceColumn:
    Comment = 1
    Radius = 2
    Thickness = 3
    Material = 4
    Coating = 5
    SemiDiameter = 6
    ChipZone = 7
    MechanicalSemiDiameter = 8
    Conic = 9
    TCE = 10
    Par0 = 11
    Par1 = 12
    Par2 = 13
    Par3 = 14
    Par4 = 15
    Par5 = 16
    Par6 = 17
    Par7 = 18
    Par8 = 19
    Par9 = 20
    Par10 = 21
    Par11 = 22
    Par12 = 23
    Par13 = 24
    Par14 = 25
    Par15 = 26
    Par16 = 27
    Par17 = 28
    Par18 = 29
    Par19 = 30
    Par20 = 31
    Par21 = 32
    Par22 = 33
    Par23 = 34
    Par24 = 35
    Par25 = 36
    Par26 = 37
    Par27 = 38
    Par28 = 39
    Par29 = 40
    Par30 = 41
    Par31 = 42
    Par32 = 43
    Par33 = 44
    Par34 = 45
    Par35 = 46
    Par36 = 47
    Par37 = 48
    Par38 = 49
    Par39 = 50
    Par40 = 51
    Par41 = 52
    Par42 = 53
    Par43 = 54
    Par44 = 55
    Par45 = 56
    Par46 = 57
    Par47 = 58
    Par48 = 59
    Par49 = 60
    Par50 = 61
    Par51 = 62
    Par52 = 63
    Par53 = 64
    Par54 = 65
    Par55 = 66
    Par56 = 67
    Par57 = 68
    Par58 = 69
    Par59 = 70
    Par60 = 71
    Par61 = 72
    Par62 = 73
    Par63 = 74
    Par64 = 75
    Par65 = 76
    Par66 = 77
    Par67 = 78
    Par68 = 79
    Par69 = 80
    Par70 = 81
    Par71 = 82
    Par72 = 83
    Par73 = 84
    Par74 = 85
    Par75 = 86
    Par76 = 87
    Par77 = 88
    Par78 = 89
    Par79 = 90
    Par80 = 91
    Par81 = 92
    Par82 = 93
    Par83 = 94
    Par84 = 95
    Par85 = 96
    Par86 = 97
    Par87 = 98
    Par88 = 99
    Par89 = 100
    Par90 = 101
    Par91 = 102
    Par92 = 103
    Par93 = 104
    Par94 = 105
    Par95 = 106
    Par96 = 107
    Par97 = 108
    Par98 = 109
    Par99 = 110
    Par100 = 111
    Par101 = 112
    Par102 = 113
    Par103 = 114
    Par104 = 115
    Par105 = 116
    Par106 = 117
    Par107 = 118
    Par108 = 119
    Par109 = 120
    Par110 = 121
    Par111 = 122
    Par112 = 123
    Par113 = 124
    Par114 = 125
    Par115 = 126
    Par116 = 127
    Par117 = 128
    Par118 = 129
    Par119 = 130
    Par120 = 131
    Par121 = 132
    Par122 = 133
    Par123 = 134
    Par124 = 135
    Par125 = 136
    Par126 = 137
    Par127 = 138
    Par128 = 139
    Par129 = 140
    Par130 = 141
    Par131 = 142
    Par132 = 143
    Par133 = 144
    Par134 = 145
    Par135 = 146
    Par136 = 147
    Par137 = 148
    Par138 = 149
    Par139 = 150
    Par140 = 151
    Par141 = 152
    Par142 = 153
    Par143 = 154
    Par144 = 155
    Par145 = 156
    Par146 = 157
    Par147 = 158
    Par148 = 159
    Par149 = 160
    Par150 = 161
    Par151 = 162
    Par152 = 163
    Par153 = 164
    Par154 = 165
    Par155 = 166
    Par156 = 167
    Par157 = 168
    Par158 = 169
    Par159 = 170
    Par160 = 171
    Par161 = 172
    Par162 = 173
    Par163 = 174
    Par164 = 175
    Par165 = 176
    Par166 = 177
    Par167 = 178
    Par168 = 179
    Par169 = 180
    Par170 = 181
    Par171 = 182
    Par172 = 183
    Par173 = 184
    Par174 = 185
    Par175 = 186
    Par176 = 187
    Par177 = 188
    Par178 = 189
    Par179 = 190
    Par180 = 191
    Par181 = 192
    Par182 = 193
    Par183 = 194
    Par184 = 195
    Par185 = 196
    Par186 = 197
    Par187 = 198
    Par188 = 199
    Par189 = 200
    Par190 = 201
    Par191 = 202
    Par192 = 203
    Par193 = 204
    Par194 = 205
    Par195 = 206
    Par196 = 207
    Par197 = 208
    Par198 = 209
    Par199 = 210
    Par200 = 211
    Par201 = 212
    Par202 = 213
    Par203 = 214
    Par204 = 215
    Par205 = 216
    Par206 = 217
    Par207 = 218
    Par208 = 219
    Par209 = 220
    Par210 = 221
    Par211 = 222
    Par212 = 223
    Par213 = 224
    Par214 = 225
    Par215 = 226
    Par216 = 227
    Par217 = 228
    Par218 = 229
    Par219 = 230
    Par220 = 231
    Par221 = 232
    Par222 = 233
    Par223 = 234
    Par224 = 235
    Par225 = 236
    Par226 = 237
    Par227 = 238
    Par228 = 239
    Par229 = 240
    Par230 = 241
    Par231 = 242
    Par232 = 243
    Par233 = 244
    Par234 = 245
    Par235 = 246
    Par236 = 247
    Par237 = 248
    Par238 = 249
    Par239 = 250
    Par240 = 251
    Par241 = 252
    Par242 = 253
    Par243 = 254
    Par244 = 255
    Par245 = 256
    Par246 = 257
    Par247 = 258
    Par248 = 259
    Par249 = 260
    Par250 = 261
    Par251 = 262
    Par252 = 263
    Par253 = 264
    Par254 = 265

class SurfaceEdgeDraw:
    Squared = 0
    Tapered = 1
    Flat = 2

class SurfaceScatteringTypes:
    # None = 0
    Lambertian = 1
    Gaussian = 2
    ABg = 3
    ABgFile = 4
    BSDF = 5
    User = 6
    ISScatterCatalog = 7

class SurfaceType:
    ABCD = 0
    AlternateEven = 1
    AlternateOdd = 2
    AnnularZernikeSag = 3
    Atmospheric = 4
    Biconic = 5
    BiconicZernike = 6
    Binary1 = 7
    Binary2 = 8
    Binary3 = 9
    Binary4 = 10
    BirefringentIn = 11
    BirefringentOut = 12
    BlackBoxLens = 13
    ChebyShv = 14
    Conjugate = 15
    CoordinateBreak = 16
    CubicSpline = 17
    CylinderFrensel = 18
    CylinderFresnel = 18
    Data = 19
    DiffractionGrating = 20
    EllipticalGrating1 = 21
    EllipticalGrating2 = 22
    EvenAspheric = 23
    ExtendedToroidalGrating = 24
    ExtendedAsphere = 25
    ExtendedCubicSpline = 26
    ExtendedFresnel = 27
    ExtendedOddAsphere = 28
    ExtendedPolynomial = 29
    Fresnel = 30
    GeneralizedFresnel = 31
    Gradient1 = 32
    Gradient2 = 33
    Gradient3 = 34
    Gradient4 = 35
    Gradient5 = 36
    Gradient6 = 37
    Gradient7 = 38
    Gradient9 = 39
    Gradient10 = 40
    Gradient12 = 41
    Gradium = 42
    GridGradient = 43
    GridPhase = 44
    GridSag = 45
    Hologram1 = 46
    Hologram2 = 47
    Irregular = 48
    JonesMatrix = 49
    NonSequential = 50
    OddAsphere = 51
    OddCosine = 52
    OffAxisConicFreeform = 53
    OpticallyFabricatedHologram = 54
    Paraxial = 55
    ParaxialXY = 56
    Periodic = 57
    Polynomial = 58
    QTypeAsphere = 59
    QTypeFreeform = 60
    RadialGrating = 61
    RadialNurbs = 62
    RetroReflect = 63
    SlideSurface = 64
    Standard = 65
    Superconic = 66
    Tilted = 67
    Toroidal = 68
    ToroidalGrat = 69
    ToroidalHologram = 70
    ToroidalNurbs = 71
    UserDefined = 72
    VariableLineSpaceGrating = 73
    ZernikeAnnularPhase = 74
    ZernikeFringePhase = 75
    ZernikeFringeSag = 76
    ZernikeStandardPhase = 77
    ZernikeStandardSag = 78
    ZonePlate = 79
    Freeform = 80

class TiltDecenterOrderType:
    Decenter_Tilt = 0
    Tilt_Decenter = 1

class TiltDecenterPickupType:
    Explicit = 0
    PickupSurface = 1
    ReverseSurface = 2

class TiltType:
    XTilt = 0
    YTilt = 1

class XYSampling:
    S32 = 0
    S64 = 1
    S128 = 2
    S256 = 3
    S512 = 4
    S1024 = 5
    S2048 = 6
    S4096 = 7
    S8192 = 8
    S16384 = 9
