"""
This file provides autocompletions for the ZOS-API and was automatically generated.
It should not be edited manually.
"""

from __future__ import annotations

from zospy.api._ZOSAPI.Analysis import IMessage, SampleSizes
from zospy.api._ZOSAPI.Common import IMetadata, ZemaxColor, ZemaxOpacity
from zospy.api._ZOSAPI.Editors import (
    IEditor,
    IEditorCell,
    IEditorRow,
    ReflectTransmitCode,
    SampleSides,
    Samplings,
)

__all__ = (
    "ApertureShapes",
    "ArrayMode",
    "BirefringentMode",
    "BirefringentReflections",
    "DetectorDataType",
    "DetectorShowAsType",
    "DiffractionSplitType",
    "DiffractiveFaceChoices",
    "DrawingResolutionType",
    "EfficiencySpectrumType",
    "EndCapOptions",
    "FaceIsType",
    "HologramTypes",
    "IFaceData",
    "IFaceData",
    "IImportanceSamplingSettings",
    "IImportanceSamplingSettings",
    "IIMS_Birefringent",
    "IIMS_GRIN",
    "IIMS_Isotropic",
    "IIndexModelSettings",
    "IIndexModelSettings",
    "INCECADData",
    "INCECADData",
    "INCECoatScatterData",
    "INCECoatScatterData",
    "INCECoatScatterFaceData",
    "INCECoatScatterFaceData",
    "INCEDiffractionData",
    "INCEDiffractionData",
    "INCEDrawData",
    "INCEDrawData",
    "INCEIndexData",
    "INCEIndexData",
    "INCERow",
    "INCEScatterToData",
    "INCEScatterToData",
    "INCESourcesData",
    "INCESourcesData",
    "INCETypeData",
    "INCETypeData",
    "INCEVolumePhysicsData",
    "INCEVolumePhysicsData",
    "INonSeqEditor",
    "InterpolateChoices",
    "IObject",
    "IObject",
    "IObjectAnnularAsphericLens",
    "IObjectAnnularAxialLens",
    "IObjectAnnularVolume",
    "IObjectAnnulus",
    "IObjectArray",
    "IObjectArrayRing",
    "IObjectAsphericSurface",
    "IObjectAsphericSurface2",
    "IObjectAxiconSurface",
    "IObjectBiconicLens",
    "IObjectBiconicSurface",
    "IObjectBiconicZernike",
    "IObjectBiconicZernikeSurface",
    "IObjectBinary1",
    "IObjectBinary2",
    "IObjectBinary2A",
    "IObjectBoolean",
    "IObjectBooleanNative",
    "IObjectCADAssemblyAutodeskInventor",
    "IObjectCADAssemblyCreoParametric",
    "IObjectCADAssemblySolidWorks",
    "IObjectCADPartAutodeskInventor",
    "IObjectCADPartCreoParametric",
    "IObjectCADPartSolidWorks",
    "IObjectCADPartSTEPIGESSAT",
    "IObjectCADPartSTL",
    "IObjectCADPartZPD",
    "IObjectCompoundLens",
    "IObjectCone",
    "IObjectCPC",
    "IObjectCPCRectangular",
    "IObjectCylinder2Pipe",
    "IObjectCylinder2Volume",
    "IObjectCylinderPipe",
    "IObjectCylinderVolume",
    "IObjectDetector",
    "IObjectDetectorColor",
    "IObjectDetectorPolar",
    "IObjectDetectorRectangle",
    "IObjectDetectorSurface",
    "IObjectDetectorVolume",
    "IObjectDiffractionGrating",
    "IObjectDualBEFSurface",
    "IObjectEllipse",
    "IObjectEllipticalVolume",
    "IObjectEvenAsphereLens",
    "IObjectExtendedOddAsphereLens",
    "IObjectExtendedPolynomialLens",
    "IObjectExtendedPolynomialSurface",
    "IObjectExtruded",
    "IObjectFacetedSurface",
    "IObjectFreeformZ",
    "IObjectFresnel1",
    "IObjectFresnel2",
    "IObjectGridSagFrontBack",
    "IObjectGridSagLens",
    "IObjectGridSagSurface",
    "IObjectHexagonalLensletArray",
    "IObjectHologramLens",
    "IObjectHologramSurface",
    "IObjectJonesMatrix",
    "IObjectLensletArray1",
    "IObjectLensletArray2",
    "IObjectMEMS",
    "IObjectNullObject",
    "IObjectOddAsphereLens",
    "IObjectOffAxisMirror",
    "IObjectParaxialLens",
    "IObjectPolygon",
    "IObjectQTypeAsphereSurface",
    "IObjectRayRotator",
    "IObjectRectangle",
    "IObjectRectangularCorner",
    "IObjectRectangularPipe",
    "IObjectRectangularPipeGrating",
    "IObjectRectangularRoof",
    "IObjectRectangularTorusSurface",
    "IObjectRectangularTorusVolume",
    "IObjectRectangularVolume",
    "IObjectRectangularVolumeGrating",
    "IObjectReverseRadianceDetector",
    "IObjectReverseRadianceTarget",
    "IObjectScatteringSettings",
    "IObjectScatteringSettings",
    "IObjectSlide",
    "IObjectSourceDiffractive",
    "IObjectSourceDiode",
    "IObjectSourceDLL",
    "IObjectSourceEllipse",
    "IObjectSourceEULUMDATFile",
    "IObjectSourceFilament",
    "IObjectSourceFile",
    "IObjectSourceGaussian",
    "IObjectSourceIESNAFile",
    "IObjectSourceImported",
    "IObjectSourceObject",
    "IObjectSourcePoint",
    "IObjectSourceRadial",
    "IObjectSourceRay",
    "IObjectSourceRectangle",
    "IObjectSources",
    "IObjectSourceTube",
    "IObjectSourceTwoAngle",
    "IObjectSourceVolumeCylindrical",
    "IObjectSourceVolumeElliptical",
    "IObjectSourceVolumeRectangular",
    "IObjectSphere",
    "IObjectStandardLens",
    "IObjectStandardSurface",
    "IObjectSwept",
    "IObjectTabulatedFactedRadial",
    "IObjectTabulatedFactedToroid",
    "IObjectTabulatedFrenselRadial",
    "IObjectToroidalHologram",
    "IObjectToroidalLens",
    "IObjectToroidalSurface",
    "IObjectToroidalSurfaceOddASphere",
    "IObjectTorusSurface",
    "IObjectTorusVolume",
    "IObjectTriangle",
    "IObjectTriangularCorner",
    "IObjectTypeSettings",
    "IObjectTypeSettings",
    "IObjectUserDefinedObject",
    "IObjectWolterSurface",
    "IObjectXYPolynomial",
    "IObjectZernikeSurface",
    "IOSS_ABg",
    "IOSS_ABgFile",
    "IOSS_BSDF",
    "IOSS_Gaussian",
    "IOSS_ISScatterCatalog",
    "IOSS_Lambertian",
    "IOSS_None",
    "IOSS_User",
    "ISCS_BlackBodySpectrum",
    "ISCS_CIE1931Chromaticity",
    "ISCS_CIE1931RGB",
    "ISCS_CIE1931Tristimulus",
    "ISCS_CIE1976",
    "ISCS_ColorTemperature",
    "ISCS_D65White",
    "ISCS_SpectrumFile",
    "ISCS_SystemWavelengths",
    "ISCS_UniformPowerSpectrum",
    "ISourceColorSettings",
    "ISourceColorSettings",
    "IVMPS_AngleScattering",
    "IVMPS_DLLDefinedScattering",
    "IVMPS_PhotoluminscenceModel",
    "IVolumePhysicsModelSettings",
    "IVolumePhysicsModelSettings",
    "IVPMS_None",
    "NCEIndexType",
    "ObjectColumn",
    "ObjectScatteringTypes",
    "ObjectType",
    "OrderChoices",
    "PixelAddressing",
    "PolarDetectorDataType",
    "RaysIgnoreObjectType",
    "RayTraceModes",
    "ScatterToType",
    "ShapeChoices",
    "SourceBulkScatterMode",
    "SourceColorMode",
    "SourceSamplingMethod",
    "UniformAngleChoices",
    "VolumePhysicsModelType",
)

class ApertureShapes:
    Annular = 0
    Elliptical = 1
    Rectangular = 2
    CyliderWithRectangular = 3

class ArrayMode:
    # None = 0
    Rectangular = 1
    Circular = 2
    Hexapolar = 3
    Hexagonal = 4

class BirefringentMode:
    TraceOrdinayAndExtraordinary = 0
    TraceOrdinaryOnly = 1
    TraceExtraordinaryOnly = 2
    Waveplate = 3

class BirefringentReflections:
    TraceReflectedAndRefracted = 0
    TraceRefractedOnly = 1
    TraceReflectedOnly = 2

class DetectorDataType:
    Real = 0
    Imaginary = 1
    Amplitude = 2
    Power = 3

class DetectorShowAsType:
    GreyScaleFlux = 0
    InverseGreyScaleFlux = 1
    FalseColorFlux = 2
    InverseFalseColorFlux = 3
    GreyScaleIrradiance = 4
    InverseGreyScaleIrradiance = 5
    FalseColorIrradiance = 6
    InverseFalseColorIrradiance = 7

class DiffractionSplitType:
    DontSplitByOrder = 0
    SplitByTable = 1
    SplitByDLL = 2

class DiffractiveFaceChoices:
    FrontFace = 1
    BackFace = 2

class DrawingResolutionType:
    Standard = 0
    Medium = 1
    High = 2
    Presentation = 3
    Custom = 4

class EfficiencySpectrumType:
    QuantumYield = 0
    Excitation = 1

class EndCapOptions:
    # None = 0
    First = 1
    Second = 2
    Both = 3

class FaceIsType:
    ObjectDefault = 0
    Reflective = 1
    Absorbing = 2

class HologramTypes:
    Type_1 = 1
    Type_2 = 2

class IFaceData:
    def FillData(
        self,
        size: int,
        X: list[float],
        Y: list[float],
        Z: list[float],
        XNorm: list[float],
        YNorm: list[float],
        ZNorm: list[float],
    ) -> bool: ...
    @property
    def AbsorbedFlux(self) -> float: ...
    @property
    def AbsorbedIrradiance(self) -> float: ...
    @property
    def ConvertToGlobal(self) -> bool: ...
    @property
    def CurrentFace(self) -> int: ...
    @property
    def Flux(self) -> float: ...
    @property
    def Irradiance(self) -> float: ...
    @property
    def NumberOfFaces(self) -> int: ...
    @property
    def NumberOfVertices(self) -> int: ...
    def GetVertex(self, vertexNumber: int) -> tuple[bool, float, float, float]: ...
    def GetVertexNormal(self, vertexNumber: int) -> tuple[bool, float, float, float]: ...
    @ConvertToGlobal.setter
    def ConvertToGlobal(self, value: bool) -> None: ...
    @CurrentFace.setter
    def CurrentFace(self, value: int) -> None: ...

class IImportanceSamplingSettings:
    @property
    def Limit(self) -> float: ...
    @property
    def Size(self) -> float: ...
    @property
    def Towards(self) -> int: ...
    @Limit.setter
    def Limit(self, value: float) -> None: ...
    @Size.setter
    def Size(self, value: float) -> None: ...
    @Towards.setter
    def Towards(self, value: int) -> None: ...

class IIMS_Birefringent(IIndexModelSettings):
    @property
    def Ax(self) -> float: ...
    @property
    def AxisLength(self) -> float: ...
    @property
    def Ay(self) -> float: ...
    @property
    def Az(self) -> float: ...
    @property
    def Mode(self) -> BirefringentMode: ...
    @property
    def Reflections(self) -> BirefringentReflections: ...
    @Ax.setter
    def Ax(self, value: float) -> None: ...
    @AxisLength.setter
    def AxisLength(self, value: float) -> None: ...
    @Ay.setter
    def Ay(self, value: float) -> None: ...
    @Az.setter
    def Az(self, value: float) -> None: ...
    @Mode.setter
    def Mode(self, value: BirefringentMode) -> None: ...
    @Reflections.setter
    def Reflections(self, value: BirefringentReflections) -> None: ...

class IIMS_GRIN(IIndexModelSettings):
    @property
    def DLL(self) -> str: ...
    @property
    def File(self) -> str: ...
    @property
    def MaximumStepSize(self) -> float: ...
    @property
    def NumberOfParameters(self) -> int: ...
    @property
    def UsesFile(self) -> bool: ...
    def GetAvailableDLLs(self) -> list[str]: ...
    def GetAvailableFiles(self) -> list[str]: ...
    def GetParameterName(self, paramIdx: int) -> str: ...
    def GetParameterValue(self, paramIdx: int) -> float: ...
    @DLL.setter
    def DLL(self, value: str) -> None: ...
    @File.setter
    def File(self, value: str) -> None: ...
    @MaximumStepSize.setter
    def MaximumStepSize(self, value: float) -> None: ...
    def SetParameterValue(self, paramIdx: int, Value: float) -> bool: ...

class IIMS_Isotropic(IIndexModelSettings):
    pass

class IIndexModelSettings:
    @property
    def _S_Birefringent(self) -> IIMS_Birefringent: ...
    @property
    def _S_GRIN(self) -> IIMS_GRIN: ...
    @property
    def _S_Isotropic(self) -> IIMS_Isotropic: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def Type(self) -> NCEIndexType: ...

class INCECADData:
    @property
    def ChordTolerance(self) -> float: ...
    @property
    def CurrentConfiguration(self) -> int: ...
    @property
    def FaceAngle(self) -> float: ...
    @property
    def FaceMode(self) -> int: ...
    @property
    def HasChordTolerance(self) -> bool: ...
    @property
    def HasEdgeLength(self) -> bool: ...
    @property
    def HasFaceData(self) -> bool: ...
    @property
    def HasFaceParameters(self) -> bool: ...
    @property
    def HasMergeSurfaces(self) -> bool: ...
    @property
    def HasPartData(self) -> bool: ...
    @property
    def HasSurfaceTolerance(self) -> bool: ...
    @property
    def HasTraceMode(self) -> bool: ...
    @property
    def IsCADAvailable(self) -> bool: ...
    @property
    def MaxEdgeLength(self) -> float: ...
    @property
    def MergeSurfaces(self) -> bool: ...
    @property
    def NumberOfConfigurations(self) -> int: ...
    @property
    def NumberOfParts(self) -> int: ...
    @property
    def NumberOfSurfaces(self) -> int: ...
    @property
    def SurfaceTolerance(self) -> int: ...
    @property
    def TraceMode(self) -> RayTraceModes: ...
    def GetConfigurationName(self, configIdx: int) -> str: ...
    def GetPartExposed(self, partIdx: int) -> bool: ...
    def GetPartName(self, partIdx: int) -> str: ...
    def GetSurfaceFace(self, surfaceIdx: int) -> int: ...
    def GetSurfaceName(self, surfaceIdx: int) -> str: ...
    @ChordTolerance.setter
    def ChordTolerance(self, value: float) -> None: ...
    @CurrentConfiguration.setter
    def CurrentConfiguration(self, value: int) -> None: ...
    @FaceAngle.setter
    def FaceAngle(self, value: float) -> None: ...
    @FaceMode.setter
    def FaceMode(self, value: int) -> None: ...
    @MaxEdgeLength.setter
    def MaxEdgeLength(self, value: float) -> None: ...
    @MergeSurfaces.setter
    def MergeSurfaces(self, value: bool) -> None: ...
    @SurfaceTolerance.setter
    def SurfaceTolerance(self, value: int) -> None: ...
    @TraceMode.setter
    def TraceMode(self, value: RayTraceModes) -> None: ...
    def SetAllPartsExposed(self, exposed: bool) -> bool: ...
    def SetPartExposed(self, partIdx: int, exposed: bool) -> bool: ...
    def SetSurfaceFace(self, surfaceIdx: int, face: int) -> bool: ...
    def SetSurfaceName(self, surfaceIdx: int, name: str) -> bool: ...

class INCECoatScatterData:
    def CopySettingsToAllFaces(self, fromFace: INCECoatScatterFaceData) -> None: ...
    @property
    def IsCoatScatterAvailable(self) -> bool: ...
    @property
    def NumberOfFaces(self) -> int: ...
    def GetFaceData(self, faceNumber: int) -> INCECoatScatterFaceData: ...

class INCECoatScatterFaceData:
    def ChangeScatterModelSettings(self, newSettings: IObjectScatteringSettings) -> bool: ...
    def CopySettingsFrom(self, fromFace: INCECoatScatterFaceData) -> None: ...
    def CreateScatterModelSettings(self, type: ObjectScatteringTypes) -> IObjectScatteringSettings: ...
    def DeleteProfile(self) -> bool: ...
    @property
    def Coating(self) -> str: ...
    @property
    def CurrentScatterModel(self) -> ObjectScatteringTypes: ...
    @property
    def CurrentScatterModelSettings(self) -> IObjectScatteringSettings: ...
    @property
    def FaceIs(self) -> FaceIsType: ...
    @property
    def FaceName(self) -> str: ...
    @property
    def FaceNumber(self) -> int: ...
    @property
    def IsCustom(self) -> bool: ...
    @property
    def IsProfile(self) -> bool: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def NumberOfRays(self) -> int: ...
    @property
    def ProfileName(self) -> str: ...
    @property
    def ThinWindowScattering(self) -> bool: ...
    def GetAvailableCoatings(self) -> list[str]: ...
    def GetAvailableProfiles(self) -> list[str]: ...
    def SaveProfile(self, profileName: str) -> bool: ...
    @Coating.setter
    def Coating(self, value: str) -> None: ...
    @FaceIs.setter
    def FaceIs(self, value: FaceIsType) -> None: ...
    @NumberOfRays.setter
    def NumberOfRays(self, value: int) -> None: ...
    @ThinWindowScattering.setter
    def ThinWindowScattering(self, value: bool) -> None: ...
    def UseCustomSettings(self) -> bool: ...
    def UseProfile(self, profile: str) -> bool: ...

class INCEDiffractionData:
    @property
    def DLL(self) -> str: ...
    @property
    def IsDiffractionAvailable(self) -> bool: ...
    @property
    def IsDLLRequired(self) -> bool: ...
    @property
    def NumberOfParameters(self) -> int: ...
    @property
    def Split(self) -> DiffractionSplitType: ...
    @property
    def StartOrder(self) -> int: ...
    @property
    def StopOrder(self) -> int: ...
    def GetAvailableDLLs(self) -> list[str]: ...
    def GetReflectParameterName(self, paramIdx: int) -> str: ...
    def GetReflectParameterValue(self, paramIdx: int) -> float: ...
    def GetTransmitParamaterName(self, paramIdx: int) -> str: ...
    def GetTransmitParameterValue(self, paramIdx: int) -> float: ...
    @DLL.setter
    def DLL(self, value: str) -> None: ...
    @Split.setter
    def Split(self, value: DiffractionSplitType) -> None: ...
    @StartOrder.setter
    def StartOrder(self, value: int) -> None: ...
    @StopOrder.setter
    def StopOrder(self, value: int) -> None: ...
    def SetReflectParameterValue(self, paramIdx: int, Value: float) -> bool: ...
    def SetTransmitParameterValue(self, paramIdx: int, Value: float) -> bool: ...

class INCEDrawData:
    @property
    def DoNotDrawObject(self) -> bool: ...
    @property
    def DrawingResolution(self) -> DrawingResolutionType: ...
    @property
    def DrawLocalAxis(self) -> bool: ...
    @property
    def ExportAsTriangles(self) -> bool: ...
    @property
    def IncreaseResolutionOnShadedModelLayouts(self) -> bool: ...
    @property
    def NumSegments1(self) -> int: ...
    @property
    def NumSegments2(self) -> int: ...
    @property
    def ObjectColor(self) -> ZemaxColor: ...
    @property
    def Opacity(self) -> ZemaxOpacity: ...
    @property
    def Segments1Type(self) -> str: ...
    @property
    def Segments2Type(self) -> str: ...
    @property
    def SupportsDrawingResolution(self) -> bool: ...
    def MakeAllObjectsDrawLikeThisOne(self) -> bool: ...
    @DoNotDrawObject.setter
    def DoNotDrawObject(self, value: bool) -> None: ...
    @DrawingResolution.setter
    def DrawingResolution(self, value: DrawingResolutionType) -> None: ...
    @DrawLocalAxis.setter
    def DrawLocalAxis(self, value: bool) -> None: ...
    @ExportAsTriangles.setter
    def ExportAsTriangles(self, value: bool) -> None: ...
    @IncreaseResolutionOnShadedModelLayouts.setter
    def IncreaseResolutionOnShadedModelLayouts(self, value: bool) -> None: ...
    @NumSegments1.setter
    def NumSegments1(self, value: int) -> None: ...
    @NumSegments2.setter
    def NumSegments2(self, value: int) -> None: ...
    @ObjectColor.setter
    def ObjectColor(self, value: ZemaxColor) -> None: ...
    @Opacity.setter
    def Opacity(self, value: ZemaxOpacity) -> None: ...

class INCEIndexData:
    @property
    def IndexType(self) -> NCEIndexType: ...
    @property
    def IsIndexAvailable(self) -> bool: ...
    @property
    def ModelSettings(self) -> IIndexModelSettings: ...
    @IndexType.setter
    def IndexType(self, value: NCEIndexType) -> None: ...

class INCERow(IEditorRow):
    def AvailableObjectTypes(self) -> list[ObjectType]: ...
    def AvailableParameters(self) -> list[str]: ...
    def ChangeType(self, settings: IObjectTypeSettings) -> bool: ...
    @property
    def CADData(self) -> INCECADData: ...
    @property
    def CoatScatterData(self) -> INCECoatScatterData: ...
    @property
    def Comment(self) -> str: ...
    @property
    def CommentCell(self) -> IEditorCell: ...
    @property
    def CurrentTypeSettings(self) -> IObjectTypeSettings: ...
    @property
    def DiffractionData(self) -> INCEDiffractionData: ...
    @property
    def DrawData(self) -> INCEDrawData: ...
    @property
    def IndexData(self) -> INCEIndexData: ...
    @property
    def InsideOf(self) -> int: ...
    @property
    def InsideOfCell(self) -> IEditorCell: ...
    @property
    def IsActive(self) -> bool: ...
    @property
    def Material(self) -> str: ...
    @property
    def MaterialCell(self) -> IEditorCell: ...
    @property
    def ObjectData(self) -> IObject: ...
    @property
    def ObjectId(self) -> int: ...
    @property
    def ObjectNumber(self) -> int: ...
    @property
    def RefObject(self) -> int: ...
    @property
    def RefObjectCell(self) -> IEditorCell: ...
    @property
    def ScatterToData(self) -> INCEScatterToData: ...
    @property
    def SourcesData(self) -> INCESourcesData: ...
    @property
    def TiltAboutX(self) -> float: ...
    @property
    def TiltAboutXCell(self) -> IEditorCell: ...
    @property
    def TiltAboutY(self) -> float: ...
    @property
    def TiltAboutYCell(self) -> IEditorCell: ...
    @property
    def TiltAboutZ(self) -> float: ...
    @property
    def TiltAboutZCell(self) -> IEditorCell: ...
    @property
    def Type(self) -> ObjectType: ...
    @property
    def TypeData(self) -> INCETypeData: ...
    @property
    def TypeName(self) -> str: ...
    @property
    def VolumePhysicsData(self) -> INCEVolumePhysicsData: ...
    @property
    def XPosition(self) -> float: ...
    @property
    def XPositionCell(self) -> IEditorCell: ...
    @property
    def YPosition(self) -> float: ...
    @property
    def YPositionCell(self) -> IEditorCell: ...
    @property
    def ZPosition(self) -> float: ...
    @property
    def ZPositionCell(self) -> IEditorCell: ...
    def GetFacetedObjectData(self) -> IFaceData: ...
    def GetMetadata(self) -> IMetadata: ...
    def GetObjectCell(self, Col: ObjectColumn) -> IEditorCell: ...
    def GetObjectTypeSettings(self, type: ObjectType) -> IObjectTypeSettings: ...
    @Comment.setter
    def Comment(self, value: str) -> None: ...
    @InsideOf.setter
    def InsideOf(self, value: int) -> None: ...
    @Material.setter
    def Material(self, value: str) -> None: ...
    @RefObject.setter
    def RefObject(self, value: int) -> None: ...
    @TiltAboutX.setter
    def TiltAboutX(self, value: float) -> None: ...
    @TiltAboutY.setter
    def TiltAboutY(self, value: float) -> None: ...
    @TiltAboutZ.setter
    def TiltAboutZ(self, value: float) -> None: ...
    @XPosition.setter
    def XPosition(self, value: float) -> None: ...
    @YPosition.setter
    def YPosition(self, value: float) -> None: ...
    @ZPosition.setter
    def ZPosition(self, value: float) -> None: ...

class INCEScatterToData:
    @property
    def IsScatterToAvailable(self) -> bool: ...
    @property
    def NumberOfRayData(self) -> int: ...
    @property
    def ScatterToList(self) -> str: ...
    @property
    def ScatterToMethod(self) -> ScatterToType: ...
    def GetRayData(self, rayIndex: int) -> IImportanceSamplingSettings: ...
    @ScatterToList.setter
    def ScatterToList(self, value: str) -> None: ...
    @ScatterToMethod.setter
    def ScatterToMethod(self, value: ScatterToType) -> None: ...
    def SetRayData(self, rayIndex: int, Data: IImportanceSamplingSettings) -> bool: ...

class INCESourcesData:
    @property
    def ArrayNumber(self) -> int: ...
    @property
    def ArrayNumberX(self) -> int: ...
    @property
    def ArrayNumberY(self) -> int: ...
    @property
    def ArrayRadius(self) -> float: ...
    @property
    def ArrayRings(self) -> int: ...
    @property
    def ArraySpacing(self) -> float: ...
    @property
    def ArraySpacingX(self) -> float: ...
    @property
    def ArraySpacingY(self) -> float: ...
    @property
    def ArrayType(self) -> ArrayMode: ...
    @property
    def BulkScatter(self) -> SourceBulkScatterMode: ...
    @property
    def CoherenceLength(self) -> float: ...
    @property
    def InitialPhaseDeg(self) -> float: ...
    @property
    def IsSourcesAvailable(self) -> bool: ...
    @property
    def Jx(self) -> float: ...
    @property
    def Jy(self) -> float: ...
    @property
    def PrePropagation(self) -> float: ...
    @property
    def RandomPolarization(self) -> bool: ...
    @property
    def ReverseRays(self) -> bool: ...
    @property
    def SamplingMethod(self) -> SourceSamplingMethod: ...
    @property
    def SourceColor(self) -> SourceColorMode: ...
    @property
    def SourceColorSettings(self) -> ISourceColorSettings: ...
    @property
    def XPhase(self) -> float: ...
    @property
    def YPhase(self) -> float: ...
    @ArrayNumber.setter
    def ArrayNumber(self, value: int) -> None: ...
    @ArrayNumberX.setter
    def ArrayNumberX(self, value: int) -> None: ...
    @ArrayNumberY.setter
    def ArrayNumberY(self, value: int) -> None: ...
    @ArrayRadius.setter
    def ArrayRadius(self, value: float) -> None: ...
    @ArrayRings.setter
    def ArrayRings(self, value: int) -> None: ...
    @ArraySpacing.setter
    def ArraySpacing(self, value: float) -> None: ...
    @ArraySpacingX.setter
    def ArraySpacingX(self, value: float) -> None: ...
    @ArraySpacingY.setter
    def ArraySpacingY(self, value: float) -> None: ...
    @ArrayType.setter
    def ArrayType(self, value: ArrayMode) -> None: ...
    @BulkScatter.setter
    def BulkScatter(self, value: SourceBulkScatterMode) -> None: ...
    @CoherenceLength.setter
    def CoherenceLength(self, value: float) -> None: ...
    @InitialPhaseDeg.setter
    def InitialPhaseDeg(self, value: float) -> None: ...
    @Jx.setter
    def Jx(self, value: float) -> None: ...
    @Jy.setter
    def Jy(self, value: float) -> None: ...
    @PrePropagation.setter
    def PrePropagation(self, value: float) -> None: ...
    @RandomPolarization.setter
    def RandomPolarization(self, value: bool) -> None: ...
    @ReverseRays.setter
    def ReverseRays(self, value: bool) -> None: ...
    @SamplingMethod.setter
    def SamplingMethod(self, value: SourceSamplingMethod) -> None: ...
    @SourceColor.setter
    def SourceColor(self, value: SourceColorMode) -> None: ...
    @XPhase.setter
    def XPhase(self, value: float) -> None: ...
    @YPhase.setter
    def YPhase(self, value: float) -> None: ...

class INCETypeData:
    @property
    def AreUDASettingsAvailable(self) -> bool: ...
    @property
    def ConsiderObjects(self) -> str: ...
    @property
    def ConvertImportedFilesToZOF(self) -> bool: ...
    @property
    def DetectorShowAs(self) -> DetectorShowAsType: ...
    @property
    def FastRayTrace(self) -> bool: ...
    @property
    def IgnoreObjects(self) -> str: ...
    @property
    def NormalizeCoherentPower(self) -> bool: ...
    @property
    def NumberOfSpectralData(self) -> int: ...
    @property
    def ObjectIsADetector(self) -> bool: ...
    @property
    def RaysIgnoreObject(self) -> RaysIgnoreObjectType: ...
    @property
    def RecordPixelSpectralData(self) -> bool: ...
    @property
    def RecordSpectralData(self) -> bool: ...
    @property
    def RowColor(self) -> ZemaxColor: ...
    @property
    def SpectralDataMaxWave(self) -> float: ...
    @property
    def SpectralDataMinWave(self) -> float: ...
    @property
    def UDAFile(self) -> str: ...
    @property
    def UDAScale(self) -> float: ...
    @property
    def UseConsiderIgnoreWhenSplitting(self) -> bool: ...
    @property
    def UseFastApproximateRayTrace(self) -> bool: ...
    @property
    def UseGlobalXYZRotationOrder(self) -> bool: ...
    @property
    def UsePixelInterpolation(self) -> bool: ...
    @property
    def UserDefinedAperture(self) -> bool: ...
    def GetAvailableUDAFiles(self) -> list[str]: ...
    def GetUDAFileFullPath(self) -> str: ...
    @ConsiderObjects.setter
    def ConsiderObjects(self, value: str) -> None: ...
    @ConvertImportedFilesToZOF.setter
    def ConvertImportedFilesToZOF(self, value: bool) -> None: ...
    @DetectorShowAs.setter
    def DetectorShowAs(self, value: DetectorShowAsType) -> None: ...
    @FastRayTrace.setter
    def FastRayTrace(self, value: bool) -> None: ...
    @IgnoreObjects.setter
    def IgnoreObjects(self, value: str) -> None: ...
    @NormalizeCoherentPower.setter
    def NormalizeCoherentPower(self, value: bool) -> None: ...
    @NumberOfSpectralData.setter
    def NumberOfSpectralData(self, value: int) -> None: ...
    @ObjectIsADetector.setter
    def ObjectIsADetector(self, value: bool) -> None: ...
    @RaysIgnoreObject.setter
    def RaysIgnoreObject(self, value: RaysIgnoreObjectType) -> None: ...
    @RecordPixelSpectralData.setter
    def RecordPixelSpectralData(self, value: bool) -> None: ...
    @RecordSpectralData.setter
    def RecordSpectralData(self, value: bool) -> None: ...
    @RowColor.setter
    def RowColor(self, value: ZemaxColor) -> None: ...
    @SpectralDataMaxWave.setter
    def SpectralDataMaxWave(self, value: float) -> None: ...
    @SpectralDataMinWave.setter
    def SpectralDataMinWave(self, value: float) -> None: ...
    @UDAFile.setter
    def UDAFile(self, value: str) -> None: ...
    @UDAScale.setter
    def UDAScale(self, value: float) -> None: ...
    @UseConsiderIgnoreWhenSplitting.setter
    def UseConsiderIgnoreWhenSplitting(self, value: bool) -> None: ...
    @UseFastApproximateRayTrace.setter
    def UseFastApproximateRayTrace(self, value: bool) -> None: ...
    @UseGlobalXYZRotationOrder.setter
    def UseGlobalXYZRotationOrder(self, value: bool) -> None: ...
    @UsePixelInterpolation.setter
    def UsePixelInterpolation(self, value: bool) -> None: ...
    @UserDefinedAperture.setter
    def UserDefinedAperture(self, value: bool) -> None: ...

class INCEVolumePhysicsData:
    @property
    def IsVolumePhysicsAvailable(self) -> bool: ...
    @property
    def Model(self) -> VolumePhysicsModelType: ...
    @property
    def ModelSettings(self) -> IVolumePhysicsModelSettings: ...
    @property
    def WavelengthShift(self) -> str: ...
    @Model.setter
    def Model(self, value: VolumePhysicsModelType) -> None: ...
    @WavelengthShift.setter
    def WavelengthShift(self, value: str) -> None: ...

class INonSeqEditor(IEditor):
    def AddObject(self) -> INCERow: ...
    def AllAvailableObjectNames(self) -> list[str]: ...
    def AvailableDetectorNames(self) -> list[str]: ...
    def AvailableObjectNames(self) -> list[str]: ...
    def AvailableSourceNames(self) -> list[str]: ...
    def CopyObjects(self, fromObjectNumber: int, NumberOfObjects: int, toObjectNumber: int) -> int: ...
    def CopyObjectsFrom(
        self, fromEditor: INonSeqEditor, fromObjectNumber: int, NumberOfObjects: int, toObjectNumber: int
    ) -> int: ...
    @property
    def ActiveSurface(self) -> int: ...
    @property
    def FirstColumn(self) -> ObjectColumn: ...
    @property
    def LastColumn(self) -> ObjectColumn: ...
    @property
    def NumberOfObjects(self) -> int: ...
    @property
    def RowToObjectOffset(self) -> int: ...
    def GetAllCoherentData(
        self, ObjectNumber: int, Data: DetectorDataType, numPixels: int
    ) -> tuple[bool, list[float]]: ...
    def GetAllCoherentDataSafe(self, ObjectNumber: int, Data: DetectorDataType) -> list[list[float]]: ...
    def GetAllColorDetectorData(
        self, ObjectNumber: int, angleSpace: bool, Data: int, numPixels: int
    ) -> tuple[bool, list[float]]: ...
    def GetAllColorDetectorDataSafe(self, ObjectNumber: int, angleSpace: bool, Data: int) -> list[list[float]]: ...
    def GetAllDetectorData(self, ObjectNumber: int, Data: int, numPixels: int) -> tuple[bool, list[float]]: ...
    def GetAllDetectorDataSafe(self, ObjectNumber: int, Data: int) -> list[list[float]]: ...
    def GetAllPolarDetectorData(
        self, ObjectNumber: int, Data: PolarDetectorDataType, numPixels: int
    ) -> tuple[bool, list[float]]: ...
    def GetAllPolarDetectorDataSafe(self, ObjectNumber: int, Data: PolarDetectorDataType) -> list[list[float]]: ...
    def GetClosestGlass(self, ObjectNumber: int) -> str: ...
    def GetCoherentData(self, ObjectNumber: int, pixel: int, Data: DetectorDataType) -> tuple[bool, float]: ...
    def GetColorDetectorData(
        self, ObjectNumber: int, pixel: int, angleSpace: bool, Data: int, numIgnoredPixels: int, Wavelength: float
    ) -> tuple[bool, float]: ...
    def GetDetectorData(self, ObjectNumber: int, pixel: int, Data: int) -> tuple[bool, float]: ...
    def GetDetectorDimensions(self, ObjectNumber: int) -> tuple[bool, int, int]: ...
    def GetDetectorSize(self, ObjectNumber: int) -> int: ...
    def GetGlass(self, ObjectNumber: int) -> tuple[bool, str, float, float, float]: ...
    def GetId(self, objectNumber: int) -> int: ...
    def GetIndex(self, ObjectNumber: int, NumberOfWavelengths: int) -> tuple[int, list[float]]: ...
    def GetMatrix(
        self, ObjectNumber: int
    ) -> tuple[bool, float, float, float, float, float, float, float, float, float, float, float, float]: ...
    def GetObjectAt(self, ObjectNumber: int) -> INCERow: ...
    def GetPolarDetectorData(
        self, ObjectNumber: int, pixel: int, Data: PolarDetectorDataType
    ) -> tuple[bool, float]: ...
    def HideNCE(self) -> None: ...
    def InsertNewObjectAt(self, ObjectNumber: int) -> INCERow: ...
    def LoadDetector(self, ObjectNumber: int, fileName: str, appendData: bool) -> bool: ...
    def ModifyReferenceObjects(self, first: int, last: int, reference: int) -> IMessage: ...
    def NextNSCGroup(self) -> bool: ...
    def ObjectNameFromObjectType(self, objectType: ObjectType) -> str: ...
    def ObjectTypeFromObjectName(self, objectName: str) -> ObjectType: ...
    def PrevNSCGroup(self) -> bool: ...
    def ReloadAllObjects(self) -> None: ...
    def ReloadObject(self, ObjectNumber: int) -> None: ...
    def RemoveObjectAt(self, ObjectNumber: int) -> bool: ...
    def RemoveObjectsAt(self, ObjectNumber: int, numObjects: int) -> int: ...
    def ReplicateObject(
        self,
        ObjectNumber: int,
        NumX: int,
        NumY: int,
        NumZ: int,
        DeltaX: float,
        DeltaY: float,
        DeltaZ: float,
        AddPickupSolves: bool,
        RelativeReferences: bool,
    ) -> IMessage: ...
    def SaveDetector(self, ObjectNumber: int, fileName: str) -> bool: ...
    def SetActiveSurface(self, SurfaceNumber: int) -> bool: ...
    def ShowNCE(self) -> bool: ...

class InterpolateChoices:
    Bicubic = 0
    Linear = 1

class IObject:
    @property
    def Id(self) -> int: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def Row(self) -> INCERow: ...
    @property
    def Type(self) -> ObjectType: ...

class IObjectAnnularAsphericLens(IObject):
    @property
    def FrontConic(self) -> float: ...
    @property
    def FrontConicCell(self) -> IEditorCell: ...
    @property
    def FrontRadius(self) -> float: ...
    @property
    def FrontRadiusCell(self) -> IEditorCell: ...
    @property
    def FrontRPower10(self) -> float: ...
    @property
    def FrontRPower10Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower12(self) -> float: ...
    @property
    def FrontRPower12Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower14(self) -> float: ...
    @property
    def FrontRPower14Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower16(self) -> float: ...
    @property
    def FrontRPower16Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower2(self) -> float: ...
    @property
    def FrontRPower2Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower4(self) -> float: ...
    @property
    def FrontRPower4Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower6(self) -> float: ...
    @property
    def FrontRPower6Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower8(self) -> float: ...
    @property
    def FrontRPower8Cell(self) -> IEditorCell: ...
    @property
    def MaxBackAperture(self) -> float: ...
    @property
    def MaxBackApertureCell(self) -> IEditorCell: ...
    @property
    def MaxFrontAperture(self) -> float: ...
    @property
    def MaxFrontApertureCell(self) -> IEditorCell: ...
    @property
    def MinBackAperture(self) -> float: ...
    @property
    def MinBackApertureCell(self) -> IEditorCell: ...
    @property
    def MinFrontAperture(self) -> float: ...
    @property
    def MinFrontApertureCell(self) -> IEditorCell: ...
    @property
    def RearConic(self) -> float: ...
    @property
    def RearConicCell(self) -> IEditorCell: ...
    @property
    def RearRadius(self) -> float: ...
    @property
    def RearRadiusCell(self) -> IEditorCell: ...
    @property
    def RearRPower10(self) -> float: ...
    @property
    def RearRPower10Cell(self) -> IEditorCell: ...
    @property
    def RearRPower12(self) -> float: ...
    @property
    def RearRPower12Cell(self) -> IEditorCell: ...
    @property
    def RearRPower14(self) -> float: ...
    @property
    def RearRPower14Cell(self) -> IEditorCell: ...
    @property
    def RearRPower16(self) -> float: ...
    @property
    def RearRPower16Cell(self) -> IEditorCell: ...
    @property
    def RearRPower2(self) -> float: ...
    @property
    def RearRPower2Cell(self) -> IEditorCell: ...
    @property
    def RearRPower4(self) -> float: ...
    @property
    def RearRPower4Cell(self) -> IEditorCell: ...
    @property
    def RearRPower6(self) -> float: ...
    @property
    def RearRPower6Cell(self) -> IEditorCell: ...
    @property
    def RearRPower8(self) -> float: ...
    @property
    def RearRPower8Cell(self) -> IEditorCell: ...
    @property
    def Thickness(self) -> float: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def ThkAperture(self) -> float: ...
    @property
    def ThkApertureCell(self) -> IEditorCell: ...
    @FrontConic.setter
    def FrontConic(self, value: float) -> None: ...
    @FrontRadius.setter
    def FrontRadius(self, value: float) -> None: ...
    @FrontRPower10.setter
    def FrontRPower10(self, value: float) -> None: ...
    @FrontRPower12.setter
    def FrontRPower12(self, value: float) -> None: ...
    @FrontRPower14.setter
    def FrontRPower14(self, value: float) -> None: ...
    @FrontRPower16.setter
    def FrontRPower16(self, value: float) -> None: ...
    @FrontRPower2.setter
    def FrontRPower2(self, value: float) -> None: ...
    @FrontRPower4.setter
    def FrontRPower4(self, value: float) -> None: ...
    @FrontRPower6.setter
    def FrontRPower6(self, value: float) -> None: ...
    @FrontRPower8.setter
    def FrontRPower8(self, value: float) -> None: ...
    @MaxBackAperture.setter
    def MaxBackAperture(self, value: float) -> None: ...
    @MaxFrontAperture.setter
    def MaxFrontAperture(self, value: float) -> None: ...
    @MinBackAperture.setter
    def MinBackAperture(self, value: float) -> None: ...
    @MinFrontAperture.setter
    def MinFrontAperture(self, value: float) -> None: ...
    @RearConic.setter
    def RearConic(self, value: float) -> None: ...
    @RearRadius.setter
    def RearRadius(self, value: float) -> None: ...
    @RearRPower10.setter
    def RearRPower10(self, value: float) -> None: ...
    @RearRPower12.setter
    def RearRPower12(self, value: float) -> None: ...
    @RearRPower14.setter
    def RearRPower14(self, value: float) -> None: ...
    @RearRPower16.setter
    def RearRPower16(self, value: float) -> None: ...
    @RearRPower2.setter
    def RearRPower2(self, value: float) -> None: ...
    @RearRPower4.setter
    def RearRPower4(self, value: float) -> None: ...
    @RearRPower6.setter
    def RearRPower6(self, value: float) -> None: ...
    @RearRPower8.setter
    def RearRPower8(self, value: float) -> None: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @ThkAperture.setter
    def ThkAperture(self, value: float) -> None: ...

class IObjectAnnularAxialLens(IObject):
    @property
    def Aperture(self) -> float: ...
    @property
    def ApertureCell(self) -> IEditorCell: ...
    @property
    def Decenter(self) -> float: ...
    @property
    def DecenterCell(self) -> IEditorCell: ...
    @property
    def FrontConic(self) -> float: ...
    @property
    def FrontConicCell(self) -> IEditorCell: ...
    @property
    def FrontRadius(self) -> float: ...
    @property
    def FrontRadiusCell(self) -> IEditorCell: ...
    @property
    def FrontRPower10(self) -> float: ...
    @property
    def FrontRPower10Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower12(self) -> float: ...
    @property
    def FrontRPower12Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower14(self) -> float: ...
    @property
    def FrontRPower14Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower16(self) -> float: ...
    @property
    def FrontRPower16Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower2(self) -> float: ...
    @property
    def FrontRPower2Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower4(self) -> float: ...
    @property
    def FrontRPower4Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower6(self) -> float: ...
    @property
    def FrontRPower6Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower8(self) -> float: ...
    @property
    def FrontRPower8Cell(self) -> IEditorCell: ...
    @property
    def RearConic(self) -> float: ...
    @property
    def RearConicCell(self) -> IEditorCell: ...
    @property
    def RearRadius(self) -> float: ...
    @property
    def RearRadiusCell(self) -> IEditorCell: ...
    @property
    def RearRPower10(self) -> float: ...
    @property
    def RearRPower10Cell(self) -> IEditorCell: ...
    @property
    def RearRPower12(self) -> float: ...
    @property
    def RearRPower12Cell(self) -> IEditorCell: ...
    @property
    def RearRPower14(self) -> float: ...
    @property
    def RearRPower14Cell(self) -> IEditorCell: ...
    @property
    def RearRPower16(self) -> float: ...
    @property
    def RearRPower16Cell(self) -> IEditorCell: ...
    @property
    def RearRPower2(self) -> float: ...
    @property
    def RearRPower2Cell(self) -> IEditorCell: ...
    @property
    def RearRPower4(self) -> float: ...
    @property
    def RearRPower4Cell(self) -> IEditorCell: ...
    @property
    def RearRPower6(self) -> float: ...
    @property
    def RearRPower6Cell(self) -> IEditorCell: ...
    @property
    def RearRPower8(self) -> float: ...
    @property
    def RearRPower8Cell(self) -> IEditorCell: ...
    @property
    def Revolution(self) -> float: ...
    @property
    def RevolutionCell(self) -> IEditorCell: ...
    @property
    def Thickness(self) -> float: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @Aperture.setter
    def Aperture(self, value: float) -> None: ...
    @Decenter.setter
    def Decenter(self, value: float) -> None: ...
    @FrontConic.setter
    def FrontConic(self, value: float) -> None: ...
    @FrontRadius.setter
    def FrontRadius(self, value: float) -> None: ...
    @FrontRPower10.setter
    def FrontRPower10(self, value: float) -> None: ...
    @FrontRPower12.setter
    def FrontRPower12(self, value: float) -> None: ...
    @FrontRPower14.setter
    def FrontRPower14(self, value: float) -> None: ...
    @FrontRPower16.setter
    def FrontRPower16(self, value: float) -> None: ...
    @FrontRPower2.setter
    def FrontRPower2(self, value: float) -> None: ...
    @FrontRPower4.setter
    def FrontRPower4(self, value: float) -> None: ...
    @FrontRPower6.setter
    def FrontRPower6(self, value: float) -> None: ...
    @FrontRPower8.setter
    def FrontRPower8(self, value: float) -> None: ...
    @RearConic.setter
    def RearConic(self, value: float) -> None: ...
    @RearRadius.setter
    def RearRadius(self, value: float) -> None: ...
    @RearRPower10.setter
    def RearRPower10(self, value: float) -> None: ...
    @RearRPower12.setter
    def RearRPower12(self, value: float) -> None: ...
    @RearRPower14.setter
    def RearRPower14(self, value: float) -> None: ...
    @RearRPower16.setter
    def RearRPower16(self, value: float) -> None: ...
    @RearRPower2.setter
    def RearRPower2(self, value: float) -> None: ...
    @RearRPower4.setter
    def RearRPower4(self, value: float) -> None: ...
    @RearRPower6.setter
    def RearRPower6(self, value: float) -> None: ...
    @RearRPower8.setter
    def RearRPower8(self, value: float) -> None: ...
    @Revolution.setter
    def Revolution(self, value: float) -> None: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...

class IObjectAnnularVolume(IObject):
    @property
    def BackXAngle(self) -> float: ...
    @property
    def BackXAngleCell(self) -> IEditorCell: ...
    @property
    def BackYAngle(self) -> float: ...
    @property
    def BackYAngleCell(self) -> IEditorCell: ...
    @property
    def FrontXAngle(self) -> float: ...
    @property
    def FrontXAngleCell(self) -> IEditorCell: ...
    @property
    def FrontXMax(self) -> float: ...
    @property
    def FrontXMaxCell(self) -> IEditorCell: ...
    @property
    def FrontXMin(self) -> float: ...
    @property
    def FrontXMinCell(self) -> IEditorCell: ...
    @property
    def FrontYAngle(self) -> float: ...
    @property
    def FrontYAngleCell(self) -> IEditorCell: ...
    @property
    def FrontYMax(self) -> float: ...
    @property
    def FrontYMaxCell(self) -> IEditorCell: ...
    @property
    def FrontYMin(self) -> float: ...
    @property
    def FrontYMinCell(self) -> IEditorCell: ...
    @property
    def RearXMax(self) -> float: ...
    @property
    def RearXMaxCell(self) -> IEditorCell: ...
    @property
    def RearXMin(self) -> float: ...
    @property
    def RearXMinCell(self) -> IEditorCell: ...
    @property
    def RearYMax(self) -> float: ...
    @property
    def RearYMaxCell(self) -> IEditorCell: ...
    @property
    def RearYMin(self) -> float: ...
    @property
    def RearYMinCell(self) -> IEditorCell: ...
    @property
    def ZLength(self) -> float: ...
    @property
    def ZLengthCell(self) -> IEditorCell: ...
    @BackXAngle.setter
    def BackXAngle(self, value: float) -> None: ...
    @BackYAngle.setter
    def BackYAngle(self, value: float) -> None: ...
    @FrontXAngle.setter
    def FrontXAngle(self, value: float) -> None: ...
    @FrontXMax.setter
    def FrontXMax(self, value: float) -> None: ...
    @FrontXMin.setter
    def FrontXMin(self, value: float) -> None: ...
    @FrontYAngle.setter
    def FrontYAngle(self, value: float) -> None: ...
    @FrontYMax.setter
    def FrontYMax(self, value: float) -> None: ...
    @FrontYMin.setter
    def FrontYMin(self, value: float) -> None: ...
    @RearXMax.setter
    def RearXMax(self, value: float) -> None: ...
    @RearXMin.setter
    def RearXMin(self, value: float) -> None: ...
    @RearYMax.setter
    def RearYMax(self, value: float) -> None: ...
    @RearYMin.setter
    def RearYMin(self, value: float) -> None: ...
    @ZLength.setter
    def ZLength(self, value: float) -> None: ...

class IObjectAnnulus(IObject):
    @property
    def MaxXHalfWidth(self) -> float: ...
    @property
    def MaxXHalfWidthCell(self) -> IEditorCell: ...
    @property
    def MaxYHalfWidth(self) -> float: ...
    @property
    def MaxYHalfWidthCell(self) -> IEditorCell: ...
    @property
    def MinXHalfWidth(self) -> float: ...
    @property
    def MinXHalfWidthCell(self) -> IEditorCell: ...
    @property
    def MinYHalfWidth(self) -> float: ...
    @property
    def MinYHalfWidthCell(self) -> IEditorCell: ...
    @MaxXHalfWidth.setter
    def MaxXHalfWidth(self, value: float) -> None: ...
    @MaxYHalfWidth.setter
    def MaxYHalfWidth(self, value: float) -> None: ...
    @MinXHalfWidth.setter
    def MinXHalfWidth(self, value: float) -> None: ...
    @MinYHalfWidth.setter
    def MinYHalfWidth(self, value: float) -> None: ...

class IObjectArray(IObject):
    @property
    def Delta1X(self) -> float: ...
    @property
    def Delta1XCell(self) -> IEditorCell: ...
    @property
    def Delta1Y(self) -> float: ...
    @property
    def Delta1YCell(self) -> IEditorCell: ...
    @property
    def Delta1Z(self) -> float: ...
    @property
    def Delta1ZCell(self) -> IEditorCell: ...
    @property
    def Delta2X(self) -> float: ...
    @property
    def Delta2XCell(self) -> IEditorCell: ...
    @property
    def Delta2Y(self) -> float: ...
    @property
    def Delta2YCell(self) -> IEditorCell: ...
    @property
    def Delta2Z(self) -> float: ...
    @property
    def Delta2ZCell(self) -> IEditorCell: ...
    @property
    def Delta3X(self) -> float: ...
    @property
    def Delta3XCell(self) -> IEditorCell: ...
    @property
    def Delta3Y(self) -> float: ...
    @property
    def Delta3YCell(self) -> IEditorCell: ...
    @property
    def Delta3Z(self) -> float: ...
    @property
    def Delta3ZCell(self) -> IEditorCell: ...
    @property
    def Delta4X(self) -> float: ...
    @property
    def Delta4XCell(self) -> IEditorCell: ...
    @property
    def Delta4Y(self) -> float: ...
    @property
    def Delta4YCell(self) -> IEditorCell: ...
    @property
    def Delta4Z(self) -> float: ...
    @property
    def Delta4ZCell(self) -> IEditorCell: ...
    @property
    def DrawBoundary(self) -> int: ...
    @property
    def DrawBoundaryCell(self) -> IEditorCell: ...
    @property
    def DrawLimit(self) -> int: ...
    @property
    def DrawLimitCell(self) -> IEditorCell: ...
    @property
    def MaximumX(self) -> float: ...
    @property
    def MaximumXCell(self) -> IEditorCell: ...
    @property
    def MaximumY(self) -> float: ...
    @property
    def MaximumYCell(self) -> IEditorCell: ...
    @property
    def MaximumZ(self) -> float: ...
    @property
    def MaximumZCell(self) -> IEditorCell: ...
    @property
    def NumberX(self) -> int: ...
    @property
    def NumberXCell(self) -> IEditorCell: ...
    @property
    def NumberY(self) -> int: ...
    @property
    def NumberYCell(self) -> IEditorCell: ...
    @property
    def NumberZ(self) -> int: ...
    @property
    def NumberZCell(self) -> IEditorCell: ...
    @property
    def ParentObjectNumber(self) -> int: ...
    @property
    def ParentObjectNumberCell(self) -> IEditorCell: ...
    @property
    def TiltX(self) -> float: ...
    @property
    def TiltXCell(self) -> IEditorCell: ...
    @property
    def TiltY(self) -> float: ...
    @property
    def TiltYCell(self) -> IEditorCell: ...
    @property
    def TiltZ(self) -> float: ...
    @property
    def TiltZCell(self) -> IEditorCell: ...
    @property
    def XminusX(self) -> float: ...
    @property
    def XminusXCell(self) -> IEditorCell: ...
    @property
    def XminusY(self) -> float: ...
    @property
    def XminusYCell(self) -> IEditorCell: ...
    @property
    def XminusZ(self) -> float: ...
    @property
    def XminusZCell(self) -> IEditorCell: ...
    @property
    def YminusX(self) -> float: ...
    @property
    def YminusXCell(self) -> IEditorCell: ...
    @property
    def YminusY(self) -> float: ...
    @property
    def YminusYCell(self) -> IEditorCell: ...
    @property
    def YminusZ(self) -> float: ...
    @property
    def YminusZCell(self) -> IEditorCell: ...
    @property
    def ZminusX(self) -> float: ...
    @property
    def ZminusXCell(self) -> IEditorCell: ...
    @property
    def ZminusY(self) -> float: ...
    @property
    def ZminusYCell(self) -> IEditorCell: ...
    @property
    def ZminusZ(self) -> float: ...
    @property
    def ZminusZCell(self) -> IEditorCell: ...
    @Delta1X.setter
    def Delta1X(self, value: float) -> None: ...
    @Delta1Y.setter
    def Delta1Y(self, value: float) -> None: ...
    @Delta1Z.setter
    def Delta1Z(self, value: float) -> None: ...
    @Delta2X.setter
    def Delta2X(self, value: float) -> None: ...
    @Delta2Y.setter
    def Delta2Y(self, value: float) -> None: ...
    @Delta2Z.setter
    def Delta2Z(self, value: float) -> None: ...
    @Delta3X.setter
    def Delta3X(self, value: float) -> None: ...
    @Delta3Y.setter
    def Delta3Y(self, value: float) -> None: ...
    @Delta3Z.setter
    def Delta3Z(self, value: float) -> None: ...
    @Delta4X.setter
    def Delta4X(self, value: float) -> None: ...
    @Delta4Y.setter
    def Delta4Y(self, value: float) -> None: ...
    @Delta4Z.setter
    def Delta4Z(self, value: float) -> None: ...
    @DrawBoundary.setter
    def DrawBoundary(self, value: int) -> None: ...
    @DrawLimit.setter
    def DrawLimit(self, value: int) -> None: ...
    @MaximumX.setter
    def MaximumX(self, value: float) -> None: ...
    @MaximumY.setter
    def MaximumY(self, value: float) -> None: ...
    @MaximumZ.setter
    def MaximumZ(self, value: float) -> None: ...
    @NumberX.setter
    def NumberX(self, value: int) -> None: ...
    @NumberY.setter
    def NumberY(self, value: int) -> None: ...
    @NumberZ.setter
    def NumberZ(self, value: int) -> None: ...
    @ParentObjectNumber.setter
    def ParentObjectNumber(self, value: int) -> None: ...
    @TiltX.setter
    def TiltX(self, value: float) -> None: ...
    @TiltY.setter
    def TiltY(self, value: float) -> None: ...
    @TiltZ.setter
    def TiltZ(self, value: float) -> None: ...
    @XminusX.setter
    def XminusX(self, value: float) -> None: ...
    @XminusY.setter
    def XminusY(self, value: float) -> None: ...
    @XminusZ.setter
    def XminusZ(self, value: float) -> None: ...
    @YminusX.setter
    def YminusX(self, value: float) -> None: ...
    @YminusY.setter
    def YminusY(self, value: float) -> None: ...
    @YminusZ.setter
    def YminusZ(self, value: float) -> None: ...
    @ZminusX.setter
    def ZminusX(self, value: float) -> None: ...
    @ZminusY.setter
    def ZminusY(self, value: float) -> None: ...
    @ZminusZ.setter
    def ZminusZ(self, value: float) -> None: ...

class IObjectArrayRing(IObject):
    @property
    def Alpha(self) -> float: ...
    @property
    def AlphaCell(self) -> IEditorCell: ...
    @property
    def Beta(self) -> float: ...
    @property
    def BetaCell(self) -> IEditorCell: ...
    @property
    def Delta(self) -> float: ...
    @property
    def DeltaCell(self) -> IEditorCell: ...
    @property
    def Epsilon(self) -> float: ...
    @property
    def EpsilonCell(self) -> IEditorCell: ...
    @property
    def Gamma(self) -> float: ...
    @property
    def GammaCell(self) -> IEditorCell: ...
    @property
    def Mode(self) -> int: ...
    @property
    def ModeCell(self) -> IEditorCell: ...
    @property
    def NumberOfElements(self) -> int: ...
    @property
    def NumberOfElementsCell(self) -> IEditorCell: ...
    @property
    def ParentObjectNumber(self) -> int: ...
    @property
    def ParentObjectNumberCell(self) -> IEditorCell: ...
    @property
    def RadiusA(self) -> float: ...
    @property
    def RadiusACell(self) -> IEditorCell: ...
    @Alpha.setter
    def Alpha(self, value: float) -> None: ...
    @Beta.setter
    def Beta(self, value: float) -> None: ...
    @Delta.setter
    def Delta(self, value: float) -> None: ...
    @Epsilon.setter
    def Epsilon(self, value: float) -> None: ...
    @Gamma.setter
    def Gamma(self, value: float) -> None: ...
    @Mode.setter
    def Mode(self, value: int) -> None: ...
    @NumberOfElements.setter
    def NumberOfElements(self, value: int) -> None: ...
    @ParentObjectNumber.setter
    def ParentObjectNumber(self, value: int) -> None: ...
    @RadiusA.setter
    def RadiusA(self, value: float) -> None: ...

class IObjectAsphericSurface(IObject):
    @property
    def Conic(self) -> float: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def MaxAperture(self) -> float: ...
    @property
    def MaxApertureCell(self) -> IEditorCell: ...
    @property
    def MinAperture(self) -> float: ...
    @property
    def MinApertureCell(self) -> IEditorCell: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    @property
    def Radius(self) -> float: ...
    @property
    def RadiusCell(self) -> IEditorCell: ...
    def GetRPowerI(self, i: int) -> float: ...
    def RPowerICell(self, i: int) -> IEditorCell: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @MaxAperture.setter
    def MaxAperture(self, value: float) -> None: ...
    @MinAperture.setter
    def MinAperture(self, value: float) -> None: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    def SetRPowerI(self, i: int, v: float) -> None: ...

class IObjectAsphericSurface2(IObject):
    @property
    def Conic(self) -> float: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def DecenterX(self) -> float: ...
    @property
    def DecenterXCell(self) -> IEditorCell: ...
    @property
    def DecenterY(self) -> float: ...
    @property
    def DecenterYCell(self) -> IEditorCell: ...
    @property
    def IsRectangle(self) -> bool: ...
    @property
    def IsRectangleCell(self) -> IEditorCell: ...
    @property
    def MaxX(self) -> float: ...
    @property
    def MaxXCell(self) -> IEditorCell: ...
    @property
    def MaxY(self) -> float: ...
    @property
    def MaxYCell(self) -> IEditorCell: ...
    @property
    def MinX(self) -> float: ...
    @property
    def MinXCell(self) -> IEditorCell: ...
    @property
    def MinY(self) -> float: ...
    @property
    def MinYCell(self) -> IEditorCell: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    @property
    def Radius(self) -> float: ...
    @property
    def RadiusCell(self) -> IEditorCell: ...
    def GetRPowerI(self, i: int) -> float: ...
    def RPowerICell(self, i: int) -> IEditorCell: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @DecenterX.setter
    def DecenterX(self, value: float) -> None: ...
    @DecenterY.setter
    def DecenterY(self, value: float) -> None: ...
    @IsRectangle.setter
    def IsRectangle(self, value: bool) -> None: ...
    @MaxX.setter
    def MaxX(self, value: float) -> None: ...
    @MaxY.setter
    def MaxY(self, value: float) -> None: ...
    @MinX.setter
    def MinX(self, value: float) -> None: ...
    @MinY.setter
    def MinY(self, value: float) -> None: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    def SetRPowerI(self, i: int, v: float) -> None: ...

class IObjectAxiconSurface(IObject):
    @property
    def Cy(self) -> float: ...
    @property
    def CyCell(self) -> IEditorCell: ...
    @property
    def Cz(self) -> float: ...
    @property
    def CzCell(self) -> IEditorCell: ...
    @property
    def Length(self) -> float: ...
    @property
    def LengthCell(self) -> IEditorCell: ...
    @Cy.setter
    def Cy(self, value: float) -> None: ...
    @Cz.setter
    def Cz(self, value: float) -> None: ...
    @Length.setter
    def Length(self, value: float) -> None: ...

class IObjectBiconicLens(IObject):
    @property
    def KX1(self) -> float: ...
    @property
    def KX1Cell(self) -> IEditorCell: ...
    @property
    def KX2(self) -> float: ...
    @property
    def KX2Cell(self) -> IEditorCell: ...
    @property
    def KY1(self) -> float: ...
    @property
    def KY1Cell(self) -> IEditorCell: ...
    @property
    def KY2(self) -> float: ...
    @property
    def KY2Cell(self) -> IEditorCell: ...
    @property
    def RadialHeight(self) -> float: ...
    @property
    def RadialHeightCell(self) -> IEditorCell: ...
    @property
    def RX1(self) -> float: ...
    @property
    def RX1Cell(self) -> IEditorCell: ...
    @property
    def RX2(self) -> float: ...
    @property
    def RX2Cell(self) -> IEditorCell: ...
    @property
    def RY1(self) -> float: ...
    @property
    def RY1Cell(self) -> IEditorCell: ...
    @property
    def RY2(self) -> float: ...
    @property
    def RY2Cell(self) -> IEditorCell: ...
    @property
    def Thickness(self) -> float: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @KX1.setter
    def KX1(self, value: float) -> None: ...
    @KX2.setter
    def KX2(self, value: float) -> None: ...
    @KY1.setter
    def KY1(self, value: float) -> None: ...
    @KY2.setter
    def KY2(self, value: float) -> None: ...
    @RadialHeight.setter
    def RadialHeight(self, value: float) -> None: ...
    @RX1.setter
    def RX1(self, value: float) -> None: ...
    @RX2.setter
    def RX2(self, value: float) -> None: ...
    @RY1.setter
    def RY1(self, value: float) -> None: ...
    @RY2.setter
    def RY2(self, value: float) -> None: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...

class IObjectBiconicSurface(IObject):
    @property
    def ConicX(self) -> float: ...
    @property
    def ConicXCell(self) -> IEditorCell: ...
    @property
    def ConicY(self) -> float: ...
    @property
    def ConicYCell(self) -> IEditorCell: ...
    @property
    def IsBottomHyper(self) -> bool: ...
    @property
    def IsBottomHyperCell(self) -> IEditorCell: ...
    @property
    def IsRectangle(self) -> bool: ...
    @property
    def IsRectangleCell(self) -> IEditorCell: ...
    @property
    def IsTopHyper(self) -> bool: ...
    @property
    def IsTopHyperCell(self) -> IEditorCell: ...
    @property
    def MaxXAperture(self) -> float: ...
    @property
    def MaxXApertureCell(self) -> IEditorCell: ...
    @property
    def MaxYAperture(self) -> float: ...
    @property
    def MaxYApertureCell(self) -> IEditorCell: ...
    @property
    def MinXAperture(self) -> float: ...
    @property
    def MinXApertureCell(self) -> IEditorCell: ...
    @property
    def MinYAperture(self) -> float: ...
    @property
    def MinYApertureCell(self) -> IEditorCell: ...
    @property
    def RadiusX(self) -> float: ...
    @property
    def RadiusXCell(self) -> IEditorCell: ...
    @property
    def RadiusY(self) -> float: ...
    @property
    def RadiusYCell(self) -> IEditorCell: ...
    @ConicX.setter
    def ConicX(self, value: float) -> None: ...
    @ConicY.setter
    def ConicY(self, value: float) -> None: ...
    @IsBottomHyper.setter
    def IsBottomHyper(self, value: bool) -> None: ...
    @IsRectangle.setter
    def IsRectangle(self, value: bool) -> None: ...
    @IsTopHyper.setter
    def IsTopHyper(self, value: bool) -> None: ...
    @MaxXAperture.setter
    def MaxXAperture(self, value: float) -> None: ...
    @MaxYAperture.setter
    def MaxYAperture(self, value: float) -> None: ...
    @MinXAperture.setter
    def MinXAperture(self, value: float) -> None: ...
    @MinYAperture.setter
    def MinYAperture(self, value: float) -> None: ...
    @RadiusX.setter
    def RadiusX(self, value: float) -> None: ...
    @RadiusY.setter
    def RadiusY(self, value: float) -> None: ...

class IObjectBiconicZernike(IObject):
    @property
    def FrontConic(self) -> float: ...
    @property
    def FrontConicCell(self) -> IEditorCell: ...
    @property
    def FrontRadius(self) -> float: ...
    @property
    def FrontRadiusCell(self) -> IEditorCell: ...
    @property
    def NormRadius(self) -> float: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def NumberZernikeTerms(self) -> int: ...
    @property
    def NumberZernikeTermsCell(self) -> IEditorCell: ...
    @property
    def RadialHeight(self) -> float: ...
    @property
    def RadialHeightCell(self) -> IEditorCell: ...
    @property
    def RearConicX(self) -> float: ...
    @property
    def RearConicXCell(self) -> IEditorCell: ...
    @property
    def RearConicY(self) -> float: ...
    @property
    def RearConicYCell(self) -> IEditorCell: ...
    @property
    def RearRadiusX(self) -> float: ...
    @property
    def RearRadiusXCell(self) -> IEditorCell: ...
    @property
    def RearRadiusY(self) -> float: ...
    @property
    def RearRadiusYCell(self) -> IEditorCell: ...
    @property
    def Thickness(self) -> float: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    def GetXPowerI(self, i: int) -> float: ...
    def GetYPowerI(self, i: int) -> float: ...
    def GetZPowerI(self, i: int) -> float: ...
    @FrontConic.setter
    def FrontConic(self, value: float) -> None: ...
    @FrontRadius.setter
    def FrontRadius(self, value: float) -> None: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...
    @NumberZernikeTerms.setter
    def NumberZernikeTerms(self, value: int) -> None: ...
    @RadialHeight.setter
    def RadialHeight(self, value: float) -> None: ...
    @RearConicX.setter
    def RearConicX(self, value: float) -> None: ...
    @RearConicY.setter
    def RearConicY(self, value: float) -> None: ...
    @RearRadiusX.setter
    def RearRadiusX(self, value: float) -> None: ...
    @RearRadiusY.setter
    def RearRadiusY(self, value: float) -> None: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    def SetXPowerI(self, i: int, v: float) -> None: ...
    def SetYPowerI(self, i: int, v: float) -> None: ...
    def SetZPowerI(self, i: int, v: float) -> None: ...
    def XPowerICell(self, i: int) -> IEditorCell: ...
    def YPowerICell(self, i: int) -> IEditorCell: ...
    def ZPowerICell(self, i: int) -> IEditorCell: ...

class IObjectBiconicZernikeSurface(IObject):
    @property
    def BiconicDecX(self) -> float: ...
    @property
    def BiconicDecXCell(self) -> IEditorCell: ...
    @property
    def BiconicDecY(self) -> float: ...
    @property
    def BiconicDecYCell(self) -> IEditorCell: ...
    @property
    def ConicX(self) -> float: ...
    @property
    def ConicXCell(self) -> IEditorCell: ...
    @property
    def ConicY(self) -> float: ...
    @property
    def ConicYCell(self) -> IEditorCell: ...
    @property
    def NormRadius(self) -> float: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def NumberZernikeTerms(self) -> int: ...
    @property
    def NumberZernikeTermsCell(self) -> IEditorCell: ...
    @property
    def RadiusX(self) -> float: ...
    @property
    def RadiusXCell(self) -> IEditorCell: ...
    @property
    def RadiusY(self) -> float: ...
    @property
    def RadiusYCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidth(self) -> float: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @property
    def ZernikeDecX(self) -> float: ...
    @property
    def ZernikeDecXCell(self) -> IEditorCell: ...
    @property
    def ZernikeDecY(self) -> float: ...
    @property
    def ZernikeDecYCell(self) -> IEditorCell: ...
    def GetXPowerI(self, i: int) -> float: ...
    def GetYPowerI(self, i: int) -> float: ...
    def GetZPowerI(self, i: int) -> float: ...
    @BiconicDecX.setter
    def BiconicDecX(self, value: float) -> None: ...
    @BiconicDecY.setter
    def BiconicDecY(self, value: float) -> None: ...
    @ConicX.setter
    def ConicX(self, value: float) -> None: ...
    @ConicY.setter
    def ConicY(self, value: float) -> None: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...
    @NumberZernikeTerms.setter
    def NumberZernikeTerms(self, value: int) -> None: ...
    @RadiusX.setter
    def RadiusX(self, value: float) -> None: ...
    @RadiusY.setter
    def RadiusY(self, value: float) -> None: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...
    @ZernikeDecX.setter
    def ZernikeDecX(self, value: float) -> None: ...
    @ZernikeDecY.setter
    def ZernikeDecY(self, value: float) -> None: ...
    def SetXPowerI(self, i: int, v: float) -> None: ...
    def SetYPowerI(self, i: int, v: float) -> None: ...
    def SetZPowerI(self, i: int, v: float) -> None: ...
    def XPowerICell(self, i: int) -> IEditorCell: ...
    def YPowerICell(self, i: int) -> IEditorCell: ...
    def ZPowerICell(self, i: int) -> IEditorCell: ...

class IObjectBinary1(IObjectXYPolynomial, IObject):
    @property
    def Clear1(self) -> float: ...
    @property
    def Clear1Cell(self) -> IEditorCell: ...
    @property
    def Clear2(self) -> float: ...
    @property
    def Clear2Cell(self) -> IEditorCell: ...
    @property
    def Conic1(self) -> float: ...
    @property
    def Conic1Cell(self) -> IEditorCell: ...
    @property
    def Conic2(self) -> float: ...
    @property
    def Conic2Cell(self) -> IEditorCell: ...
    @property
    def Edge1(self) -> float: ...
    @property
    def Edge1Cell(self) -> IEditorCell: ...
    @property
    def Edge2(self) -> float: ...
    @property
    def Edge2Cell(self) -> IEditorCell: ...
    @property
    def MaxTermNumber(self) -> int: ...
    @property
    def MaxTermNumberCell(self) -> IEditorCell: ...
    @property
    def NormRadius(self) -> float: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def Order(self) -> float: ...
    @property
    def OrderCell(self) -> IEditorCell: ...
    @property
    def Radius1(self) -> float: ...
    @property
    def Radius1Cell(self) -> IEditorCell: ...
    @property
    def Radius2(self) -> float: ...
    @property
    def Radius2Cell(self) -> IEditorCell: ...
    @property
    def Thickness(self) -> float: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @Clear1.setter
    def Clear1(self, value: float) -> None: ...
    @Clear2.setter
    def Clear2(self, value: float) -> None: ...
    @Conic1.setter
    def Conic1(self, value: float) -> None: ...
    @Conic2.setter
    def Conic2(self, value: float) -> None: ...
    @Edge1.setter
    def Edge1(self, value: float) -> None: ...
    @Edge2.setter
    def Edge2(self, value: float) -> None: ...
    @MaxTermNumber.setter
    def MaxTermNumber(self, value: int) -> None: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...
    @Order.setter
    def Order(self, value: float) -> None: ...
    @Radius1.setter
    def Radius1(self, value: float) -> None: ...
    @Radius2.setter
    def Radius2(self, value: float) -> None: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...

class IObjectBinary2(IObject):
    @property
    def Clear1(self) -> float: ...
    @property
    def Clear1Cell(self) -> IEditorCell: ...
    @property
    def Clear2(self) -> float: ...
    @property
    def Clear2Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower10(self) -> float: ...
    @property
    def CoeffOnPPower10Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower12(self) -> float: ...
    @property
    def CoeffOnPPower12Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower14(self) -> float: ...
    @property
    def CoeffOnPPower14Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower16(self) -> float: ...
    @property
    def CoeffOnPPower16Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower18(self) -> float: ...
    @property
    def CoeffOnPPower18Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower2(self) -> float: ...
    @property
    def CoeffOnPPower20(self) -> float: ...
    @property
    def CoeffOnPPower20Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower22(self) -> float: ...
    @property
    def CoeffOnPPower22Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower24(self) -> float: ...
    @property
    def CoeffOnPPower24Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower26(self) -> float: ...
    @property
    def CoeffOnPPower26Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower28(self) -> float: ...
    @property
    def CoeffOnPPower28Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower2Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower30(self) -> float: ...
    @property
    def CoeffOnPPower30Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower32(self) -> float: ...
    @property
    def CoeffOnPPower32Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower4(self) -> float: ...
    @property
    def CoeffOnPPower4Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower6(self) -> float: ...
    @property
    def CoeffOnPPower6Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower8(self) -> float: ...
    @property
    def CoeffOnPPower8Cell(self) -> IEditorCell: ...
    @property
    def Conic1(self) -> float: ...
    @property
    def Conic1Cell(self) -> IEditorCell: ...
    @property
    def Conic2(self) -> float: ...
    @property
    def Conic2Cell(self) -> IEditorCell: ...
    @property
    def Edge1(self) -> float: ...
    @property
    def Edge1Cell(self) -> IEditorCell: ...
    @property
    def Edge2(self) -> float: ...
    @property
    def Edge2Cell(self) -> IEditorCell: ...
    @property
    def MaxTermNumber(self) -> int: ...
    @property
    def MaxTermNumberCell(self) -> IEditorCell: ...
    @property
    def NormRadius(self) -> float: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def Order(self) -> float: ...
    @property
    def OrderCell(self) -> IEditorCell: ...
    @property
    def Radius1(self) -> float: ...
    @property
    def Radius1Cell(self) -> IEditorCell: ...
    @property
    def Radius2(self) -> float: ...
    @property
    def Radius2Cell(self) -> IEditorCell: ...
    @property
    def Thickness(self) -> float: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @Clear1.setter
    def Clear1(self, value: float) -> None: ...
    @Clear2.setter
    def Clear2(self, value: float) -> None: ...
    @CoeffOnPPower10.setter
    def CoeffOnPPower10(self, value: float) -> None: ...
    @CoeffOnPPower12.setter
    def CoeffOnPPower12(self, value: float) -> None: ...
    @CoeffOnPPower14.setter
    def CoeffOnPPower14(self, value: float) -> None: ...
    @CoeffOnPPower16.setter
    def CoeffOnPPower16(self, value: float) -> None: ...
    @CoeffOnPPower18.setter
    def CoeffOnPPower18(self, value: float) -> None: ...
    @CoeffOnPPower2.setter
    def CoeffOnPPower2(self, value: float) -> None: ...
    @CoeffOnPPower20.setter
    def CoeffOnPPower20(self, value: float) -> None: ...
    @CoeffOnPPower22.setter
    def CoeffOnPPower22(self, value: float) -> None: ...
    @CoeffOnPPower24.setter
    def CoeffOnPPower24(self, value: float) -> None: ...
    @CoeffOnPPower26.setter
    def CoeffOnPPower26(self, value: float) -> None: ...
    @CoeffOnPPower28.setter
    def CoeffOnPPower28(self, value: float) -> None: ...
    @CoeffOnPPower30.setter
    def CoeffOnPPower30(self, value: float) -> None: ...
    @CoeffOnPPower32.setter
    def CoeffOnPPower32(self, value: float) -> None: ...
    @CoeffOnPPower4.setter
    def CoeffOnPPower4(self, value: float) -> None: ...
    @CoeffOnPPower6.setter
    def CoeffOnPPower6(self, value: float) -> None: ...
    @CoeffOnPPower8.setter
    def CoeffOnPPower8(self, value: float) -> None: ...
    @Conic1.setter
    def Conic1(self, value: float) -> None: ...
    @Conic2.setter
    def Conic2(self, value: float) -> None: ...
    @Edge1.setter
    def Edge1(self, value: float) -> None: ...
    @Edge2.setter
    def Edge2(self, value: float) -> None: ...
    @MaxTermNumber.setter
    def MaxTermNumber(self, value: int) -> None: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...
    @Order.setter
    def Order(self, value: float) -> None: ...
    @Radius1.setter
    def Radius1(self, value: float) -> None: ...
    @Radius2.setter
    def Radius2(self, value: float) -> None: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...

class IObjectBinary2A(IObject):
    @property
    def Coeff1OnRPower10(self) -> float: ...
    @property
    def Coeff1OnRPower10Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower12(self) -> float: ...
    @property
    def Coeff1OnRPower12Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower14(self) -> float: ...
    @property
    def Coeff1OnRPower14Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower16(self) -> float: ...
    @property
    def Coeff1OnRPower16Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower18(self) -> float: ...
    @property
    def Coeff1OnRPower18Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower2(self) -> float: ...
    @property
    def Coeff1OnRPower20(self) -> float: ...
    @property
    def Coeff1OnRPower20Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower22(self) -> float: ...
    @property
    def Coeff1OnRPower22Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower24(self) -> float: ...
    @property
    def Coeff1OnRPower24Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower4(self) -> float: ...
    @property
    def Coeff1OnRPower4Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower6(self) -> float: ...
    @property
    def Coeff1OnRPower6Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower8(self) -> float: ...
    @property
    def Coeff1OnRPower8Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower10(self) -> float: ...
    @property
    def Coeff2OnRPower10Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower12(self) -> float: ...
    @property
    def Coeff2OnRPower12Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower14(self) -> float: ...
    @property
    def Coeff2OnRPower14Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower16(self) -> float: ...
    @property
    def Coeff2OnRPower16Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower18(self) -> float: ...
    @property
    def Coeff2OnRPower18Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower2(self) -> float: ...
    @property
    def Coeff2OnRPower20(self) -> float: ...
    @property
    def Coeff2OnRPower20Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower22(self) -> float: ...
    @property
    def Coeff2OnRPower22Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower24(self) -> float: ...
    @property
    def Coeff2OnRPower24Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower4(self) -> float: ...
    @property
    def Coeff2OnRPower4Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower6(self) -> float: ...
    @property
    def Coeff2OnRPower6Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower8(self) -> float: ...
    @property
    def Coeff2OnRPower8Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower10(self) -> float: ...
    @property
    def CoeffOnPPower10Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower12(self) -> float: ...
    @property
    def CoeffOnPPower12Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower14(self) -> float: ...
    @property
    def CoeffOnPPower14Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower16(self) -> float: ...
    @property
    def CoeffOnPPower16Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower18(self) -> float: ...
    @property
    def CoeffOnPPower18Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower2(self) -> float: ...
    @property
    def CoeffOnPPower20(self) -> float: ...
    @property
    def CoeffOnPPower20Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower22(self) -> float: ...
    @property
    def CoeffOnPPower22Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower24(self) -> float: ...
    @property
    def CoeffOnPPower24Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower2Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower4(self) -> float: ...
    @property
    def CoeffOnPPower4Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower6(self) -> float: ...
    @property
    def CoeffOnPPower6Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnPPower8(self) -> float: ...
    @property
    def CoeffOnPPower8Cell(self) -> IEditorCell: ...
    @property
    def Conic1(self) -> float: ...
    @property
    def Conic1Cell(self) -> IEditorCell: ...
    @property
    def Conic2(self) -> float: ...
    @property
    def Conic2Cell(self) -> IEditorCell: ...
    @property
    def MaxTermNumber(self) -> int: ...
    @property
    def MaxTermNumberCell(self) -> IEditorCell: ...
    @property
    def NormRadius(self) -> float: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def Order(self) -> float: ...
    @property
    def OrderCell(self) -> IEditorCell: ...
    @property
    def RadialAperture(self) -> float: ...
    @property
    def RadialApertureCell(self) -> IEditorCell: ...
    @property
    def Radius1(self) -> float: ...
    @property
    def Radius1Cell(self) -> IEditorCell: ...
    @property
    def Radius2(self) -> float: ...
    @property
    def Radius2Cell(self) -> IEditorCell: ...
    @property
    def Thickness(self) -> float: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @Coeff1OnRPower10.setter
    def Coeff1OnRPower10(self, value: float) -> None: ...
    @Coeff1OnRPower12.setter
    def Coeff1OnRPower12(self, value: float) -> None: ...
    @Coeff1OnRPower14.setter
    def Coeff1OnRPower14(self, value: float) -> None: ...
    @Coeff1OnRPower16.setter
    def Coeff1OnRPower16(self, value: float) -> None: ...
    @Coeff1OnRPower18.setter
    def Coeff1OnRPower18(self, value: float) -> None: ...
    @Coeff1OnRPower2.setter
    def Coeff1OnRPower2(self, value: float) -> None: ...
    @Coeff1OnRPower20.setter
    def Coeff1OnRPower20(self, value: float) -> None: ...
    @Coeff1OnRPower22.setter
    def Coeff1OnRPower22(self, value: float) -> None: ...
    @Coeff1OnRPower24.setter
    def Coeff1OnRPower24(self, value: float) -> None: ...
    @Coeff1OnRPower4.setter
    def Coeff1OnRPower4(self, value: float) -> None: ...
    @Coeff1OnRPower6.setter
    def Coeff1OnRPower6(self, value: float) -> None: ...
    @Coeff1OnRPower8.setter
    def Coeff1OnRPower8(self, value: float) -> None: ...
    @Coeff2OnRPower10.setter
    def Coeff2OnRPower10(self, value: float) -> None: ...
    @Coeff2OnRPower12.setter
    def Coeff2OnRPower12(self, value: float) -> None: ...
    @Coeff2OnRPower14.setter
    def Coeff2OnRPower14(self, value: float) -> None: ...
    @Coeff2OnRPower16.setter
    def Coeff2OnRPower16(self, value: float) -> None: ...
    @Coeff2OnRPower18.setter
    def Coeff2OnRPower18(self, value: float) -> None: ...
    @Coeff2OnRPower2.setter
    def Coeff2OnRPower2(self, value: float) -> None: ...
    @Coeff2OnRPower20.setter
    def Coeff2OnRPower20(self, value: float) -> None: ...
    @Coeff2OnRPower22.setter
    def Coeff2OnRPower22(self, value: float) -> None: ...
    @Coeff2OnRPower24.setter
    def Coeff2OnRPower24(self, value: float) -> None: ...
    @Coeff2OnRPower4.setter
    def Coeff2OnRPower4(self, value: float) -> None: ...
    @Coeff2OnRPower6.setter
    def Coeff2OnRPower6(self, value: float) -> None: ...
    @Coeff2OnRPower8.setter
    def Coeff2OnRPower8(self, value: float) -> None: ...
    @CoeffOnPPower10.setter
    def CoeffOnPPower10(self, value: float) -> None: ...
    @CoeffOnPPower12.setter
    def CoeffOnPPower12(self, value: float) -> None: ...
    @CoeffOnPPower14.setter
    def CoeffOnPPower14(self, value: float) -> None: ...
    @CoeffOnPPower16.setter
    def CoeffOnPPower16(self, value: float) -> None: ...
    @CoeffOnPPower18.setter
    def CoeffOnPPower18(self, value: float) -> None: ...
    @CoeffOnPPower2.setter
    def CoeffOnPPower2(self, value: float) -> None: ...
    @CoeffOnPPower20.setter
    def CoeffOnPPower20(self, value: float) -> None: ...
    @CoeffOnPPower22.setter
    def CoeffOnPPower22(self, value: float) -> None: ...
    @CoeffOnPPower24.setter
    def CoeffOnPPower24(self, value: float) -> None: ...
    @CoeffOnPPower4.setter
    def CoeffOnPPower4(self, value: float) -> None: ...
    @CoeffOnPPower6.setter
    def CoeffOnPPower6(self, value: float) -> None: ...
    @CoeffOnPPower8.setter
    def CoeffOnPPower8(self, value: float) -> None: ...
    @Conic1.setter
    def Conic1(self, value: float) -> None: ...
    @Conic2.setter
    def Conic2(self, value: float) -> None: ...
    @MaxTermNumber.setter
    def MaxTermNumber(self, value: int) -> None: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...
    @Order.setter
    def Order(self, value: float) -> None: ...
    @RadialAperture.setter
    def RadialAperture(self, value: float) -> None: ...
    @Radius1.setter
    def Radius1(self, value: float) -> None: ...
    @Radius2.setter
    def Radius2(self, value: float) -> None: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...

class IObjectBoolean(IObject):
    @property
    def Mode(self) -> int: ...
    @property
    def ModeCell(self) -> IEditorCell: ...
    @property
    def NumberXminusVoxels(self) -> int: ...
    @property
    def NumberXminusVoxels_Cell(self) -> IEditorCell: ...
    @property
    def NumberYminusVoxels(self) -> int: ...
    @property
    def NumberYminusVoxels_Cell(self) -> IEditorCell: ...
    @property
    def NumberZminusVoxels(self) -> int: ...
    @property
    def NumberZminusVoxels_Cell(self) -> IEditorCell: ...
    @property
    def ObjectA(self) -> int: ...
    @property
    def ObjectACell(self) -> IEditorCell: ...
    @property
    def ObjectB(self) -> int: ...
    @property
    def ObjectBCell(self) -> IEditorCell: ...
    @property
    def ObjectC(self) -> int: ...
    @property
    def ObjectCCell(self) -> IEditorCell: ...
    @property
    def ObjectD(self) -> int: ...
    @property
    def ObjectDCell(self) -> IEditorCell: ...
    @property
    def ObjectE(self) -> int: ...
    @property
    def ObjectECell(self) -> IEditorCell: ...
    @property
    def ObjectF(self) -> int: ...
    @property
    def ObjectFCell(self) -> IEditorCell: ...
    @property
    def ObjectG(self) -> int: ...
    @property
    def ObjectGCell(self) -> IEditorCell: ...
    @property
    def ObjectH(self) -> int: ...
    @property
    def ObjectHCell(self) -> IEditorCell: ...
    @property
    def ObjectI(self) -> int: ...
    @property
    def ObjectICell(self) -> IEditorCell: ...
    @property
    def ObjectJ(self) -> int: ...
    @property
    def ObjectJCell(self) -> IEditorCell: ...
    @property
    def Spline(self) -> int: ...
    @property
    def SplineCell(self) -> IEditorCell: ...
    @Mode.setter
    def Mode(self, value: int) -> None: ...
    @NumberXminusVoxels.setter
    def NumberXminusVoxels(self, value: int) -> None: ...
    @NumberYminusVoxels.setter
    def NumberYminusVoxels(self, value: int) -> None: ...
    @NumberZminusVoxels.setter
    def NumberZminusVoxels(self, value: int) -> None: ...
    @ObjectA.setter
    def ObjectA(self, value: int) -> None: ...
    @ObjectB.setter
    def ObjectB(self, value: int) -> None: ...
    @ObjectC.setter
    def ObjectC(self, value: int) -> None: ...
    @ObjectD.setter
    def ObjectD(self, value: int) -> None: ...
    @ObjectE.setter
    def ObjectE(self, value: int) -> None: ...
    @ObjectF.setter
    def ObjectF(self, value: int) -> None: ...
    @ObjectG.setter
    def ObjectG(self, value: int) -> None: ...
    @ObjectH.setter
    def ObjectH(self, value: int) -> None: ...
    @ObjectI.setter
    def ObjectI(self, value: int) -> None: ...
    @ObjectJ.setter
    def ObjectJ(self, value: int) -> None: ...
    @Spline.setter
    def Spline(self, value: int) -> None: ...

class IObjectBooleanNative(IObject):
    @property
    def ObjectA(self) -> int: ...
    @property
    def ObjectACell(self) -> IEditorCell: ...
    @property
    def ObjectB(self) -> int: ...
    @property
    def ObjectBCell(self) -> IEditorCell: ...
    @property
    def ObjectC(self) -> int: ...
    @property
    def ObjectCCell(self) -> IEditorCell: ...
    @property
    def ObjectD(self) -> int: ...
    @property
    def ObjectDCell(self) -> IEditorCell: ...
    @property
    def ObjectE(self) -> int: ...
    @property
    def ObjectECell(self) -> IEditorCell: ...
    @property
    def ObjectF(self) -> int: ...
    @property
    def ObjectFCell(self) -> IEditorCell: ...
    @property
    def ObjectG(self) -> int: ...
    @property
    def ObjectGCell(self) -> IEditorCell: ...
    @property
    def ObjectH(self) -> int: ...
    @property
    def ObjectHCell(self) -> IEditorCell: ...
    @property
    def ObjectI(self) -> int: ...
    @property
    def ObjectICell(self) -> IEditorCell: ...
    @property
    def ObjectJ(self) -> int: ...
    @property
    def ObjectJCell(self) -> IEditorCell: ...
    @property
    def Spline(self) -> int: ...
    @property
    def SplineCell(self) -> IEditorCell: ...
    @ObjectA.setter
    def ObjectA(self, value: int) -> None: ...
    @ObjectB.setter
    def ObjectB(self, value: int) -> None: ...
    @ObjectC.setter
    def ObjectC(self, value: int) -> None: ...
    @ObjectD.setter
    def ObjectD(self, value: int) -> None: ...
    @ObjectE.setter
    def ObjectE(self, value: int) -> None: ...
    @ObjectF.setter
    def ObjectF(self, value: int) -> None: ...
    @ObjectG.setter
    def ObjectG(self, value: int) -> None: ...
    @ObjectH.setter
    def ObjectH(self, value: int) -> None: ...
    @ObjectI.setter
    def ObjectI(self, value: int) -> None: ...
    @ObjectJ.setter
    def ObjectJ(self, value: int) -> None: ...
    @Spline.setter
    def Spline(self, value: int) -> None: ...

class IObjectCADAssemblyAutodeskInventor(IObject):
    @property
    def Explode(self) -> bool: ...
    @property
    def ExplodeCell(self) -> IEditorCell: ...
    @Explode.setter
    def Explode(self, value: bool) -> None: ...

class IObjectCADAssemblyCreoParametric(IObject):
    @property
    def Explode(self) -> bool: ...
    @property
    def ExplodeCell(self) -> IEditorCell: ...
    @Explode.setter
    def Explode(self, value: bool) -> None: ...

class IObjectCADAssemblySolidWorks(IObject):
    @property
    def Explode(self) -> bool: ...
    @property
    def ExplodeCell(self) -> IEditorCell: ...
    @Explode.setter
    def Explode(self, value: bool) -> None: ...

class IObjectCADPartAutodeskInventor(IObject):
    pass

class IObjectCADPartCreoParametric(IObject):
    pass

class IObjectCADPartSolidWorks(IObject):
    pass

class IObjectCADPartSTEPIGESSAT(IObject):
    @property
    def Explode(self) -> bool: ...
    @property
    def ExplodeCell(self) -> IEditorCell: ...
    @property
    def Mode(self) -> int: ...
    @property
    def ModeCell(self) -> IEditorCell: ...
    @property
    def NumberXMinusVoxels(self) -> int: ...
    @property
    def NumberXMinusVoxelsCell(self) -> IEditorCell: ...
    @property
    def NumberYMinusVoxels(self) -> int: ...
    @property
    def NumberYMinusVoxelsCell(self) -> IEditorCell: ...
    @property
    def NumberZMinusVoxels(self) -> int: ...
    @property
    def NumberZMinusVoxelsCell(self) -> IEditorCell: ...
    @property
    def Scale(self) -> float: ...
    @property
    def ScaleCell(self) -> IEditorCell: ...
    @Explode.setter
    def Explode(self, value: bool) -> None: ...
    @Mode.setter
    def Mode(self, value: int) -> None: ...
    @NumberXMinusVoxels.setter
    def NumberXMinusVoxels(self, value: int) -> None: ...
    @NumberYMinusVoxels.setter
    def NumberYMinusVoxels(self, value: int) -> None: ...
    @NumberZMinusVoxels.setter
    def NumberZMinusVoxels(self, value: int) -> None: ...
    @Scale.setter
    def Scale(self, value: float) -> None: ...

class IObjectCADPartSTL(IObject):
    @property
    def IsVolume(self) -> bool: ...
    @property
    def IsVolumeCell(self) -> IEditorCell: ...
    @property
    def Scale(self) -> float: ...
    @property
    def ScaleCell(self) -> IEditorCell: ...
    @IsVolume.setter
    def IsVolume(self, value: bool) -> None: ...
    @Scale.setter
    def Scale(self, value: float) -> None: ...

class IObjectCADPartZPD(IObject):
    pass

class IObjectCompoundLens(IObject):
    @property
    def FrontChipRadius(self) -> float: ...
    @property
    def FrontChipRadiusCell(self) -> IEditorCell: ...
    @property
    def FrontClearHalfWidthX(self) -> float: ...
    @property
    def FrontClearHalfWidthXCell(self) -> IEditorCell: ...
    @property
    def FrontClearHalfWidthY(self) -> float: ...
    @property
    def FrontClearHalfWidthYCell(self) -> IEditorCell: ...
    @property
    def FrontClearRadius(self) -> float: ...
    @property
    def FrontClearRadiusCell(self) -> IEditorCell: ...
    @property
    def FrontEdgeRadius(self) -> float: ...
    @property
    def FrontEdgeRadiusCell(self) -> IEditorCell: ...
    @property
    def FrontSurface(self) -> int: ...
    @property
    def FrontSurfaceCell(self) -> IEditorCell: ...
    @property
    def HalfWidthX(self) -> float: ...
    @property
    def HalfWidthXCell(self) -> IEditorCell: ...
    @property
    def HalfWidthY(self) -> float: ...
    @property
    def HalfWidthYCell(self) -> IEditorCell: ...
    @property
    def IsRectangle(self) -> int: ...
    @property
    def IsRectangleCell(self) -> IEditorCell: ...
    @property
    def MirrorSpace(self) -> int: ...
    @property
    def MirrorSpaceCell(self) -> IEditorCell: ...
    @property
    def RearChipRadius(self) -> float: ...
    @property
    def RearChipRadiusCell(self) -> IEditorCell: ...
    @property
    def RearClearHalfWidthX(self) -> float: ...
    @property
    def RearClearHalfWidthXCell(self) -> IEditorCell: ...
    @property
    def RearClearHalfWidthY(self) -> float: ...
    @property
    def RearClearHalfWidthYCell(self) -> IEditorCell: ...
    @property
    def RearClearRadius(self) -> float: ...
    @property
    def RearClearRadiusCell(self) -> IEditorCell: ...
    @property
    def RearEdgeRadius(self) -> float: ...
    @property
    def RearEdgeRadiusCell(self) -> IEditorCell: ...
    @property
    def RearSurface(self) -> int: ...
    @property
    def RearSurfaceCell(self) -> IEditorCell: ...
    @property
    def Thickness(self) -> float: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @FrontChipRadius.setter
    def FrontChipRadius(self, value: float) -> None: ...
    @FrontClearHalfWidthX.setter
    def FrontClearHalfWidthX(self, value: float) -> None: ...
    @FrontClearHalfWidthY.setter
    def FrontClearHalfWidthY(self, value: float) -> None: ...
    @FrontClearRadius.setter
    def FrontClearRadius(self, value: float) -> None: ...
    @FrontEdgeRadius.setter
    def FrontEdgeRadius(self, value: float) -> None: ...
    @FrontSurface.setter
    def FrontSurface(self, value: int) -> None: ...
    @HalfWidthX.setter
    def HalfWidthX(self, value: float) -> None: ...
    @HalfWidthY.setter
    def HalfWidthY(self, value: float) -> None: ...
    @IsRectangle.setter
    def IsRectangle(self, value: int) -> None: ...
    @MirrorSpace.setter
    def MirrorSpace(self, value: int) -> None: ...
    @RearChipRadius.setter
    def RearChipRadius(self, value: float) -> None: ...
    @RearClearHalfWidthX.setter
    def RearClearHalfWidthX(self, value: float) -> None: ...
    @RearClearHalfWidthY.setter
    def RearClearHalfWidthY(self, value: float) -> None: ...
    @RearClearRadius.setter
    def RearClearRadius(self, value: float) -> None: ...
    @RearEdgeRadius.setter
    def RearEdgeRadius(self, value: float) -> None: ...
    @RearSurface.setter
    def RearSurface(self, value: int) -> None: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...

class IObjectCone(IObject):
    @property
    def Radius1(self) -> float: ...
    @property
    def Radius1Cell(self) -> IEditorCell: ...
    @property
    def Radius2(self) -> float: ...
    @property
    def Radius2Cell(self) -> IEditorCell: ...
    @property
    def Z1(self) -> float: ...
    @property
    def Z1Cell(self) -> IEditorCell: ...
    @property
    def Z2(self) -> float: ...
    @property
    def Z2Cell(self) -> IEditorCell: ...
    @Radius1.setter
    def Radius1(self, value: float) -> None: ...
    @Radius2.setter
    def Radius2(self, value: float) -> None: ...
    @Z1.setter
    def Z1(self, value: float) -> None: ...
    @Z2.setter
    def Z2(self, value: float) -> None: ...

class IObjectCPC(IObject):
    @property
    def AngleDegrees(self) -> float: ...
    @property
    def AngleDegreesCell(self) -> IEditorCell: ...
    @property
    def IsVolume(self) -> bool: ...
    @property
    def IsVolumeCell(self) -> IEditorCell: ...
    @property
    def Length(self) -> float: ...
    @property
    def LengthCell(self) -> IEditorCell: ...
    @property
    def RadialAperture(self) -> float: ...
    @property
    def RadialApertureCell(self) -> IEditorCell: ...
    @property
    def VolumeIndex(self) -> float: ...
    @property
    def VolumeIndexCell(self) -> IEditorCell: ...
    @AngleDegrees.setter
    def AngleDegrees(self, value: float) -> None: ...
    @IsVolume.setter
    def IsVolume(self, value: bool) -> None: ...
    @Length.setter
    def Length(self, value: float) -> None: ...
    @RadialAperture.setter
    def RadialAperture(self, value: float) -> None: ...
    @VolumeIndex.setter
    def VolumeIndex(self, value: float) -> None: ...

class IObjectCPCRectangular(IObject):
    @property
    def IsVolume(self) -> bool: ...
    @property
    def IsVolumeCell(self) -> IEditorCell: ...
    @property
    def Length(self) -> float: ...
    @property
    def LengthCell(self) -> IEditorCell: ...
    @property
    def VolumeIndex(self) -> float: ...
    @property
    def VolumeIndexCell(self) -> IEditorCell: ...
    @property
    def XAngleDegrees(self) -> float: ...
    @property
    def XAngleDegreesCell(self) -> IEditorCell: ...
    @property
    def XAperture(self) -> float: ...
    @property
    def XApertureCell(self) -> IEditorCell: ...
    @property
    def YAngleDegrees(self) -> float: ...
    @property
    def YAngleDegreesCell(self) -> IEditorCell: ...
    @property
    def YAperture(self) -> float: ...
    @property
    def YApertureCell(self) -> IEditorCell: ...
    @IsVolume.setter
    def IsVolume(self, value: bool) -> None: ...
    @Length.setter
    def Length(self, value: float) -> None: ...
    @VolumeIndex.setter
    def VolumeIndex(self, value: float) -> None: ...
    @XAngleDegrees.setter
    def XAngleDegrees(self, value: float) -> None: ...
    @XAperture.setter
    def XAperture(self, value: float) -> None: ...
    @YAngleDegrees.setter
    def YAngleDegrees(self, value: float) -> None: ...
    @YAperture.setter
    def YAperture(self, value: float) -> None: ...

class IObjectCylinder2Pipe(IObject):
    @property
    def BackAngleAlongX(self) -> float: ...
    @property
    def BackAngleAlongXCell(self) -> IEditorCell: ...
    @property
    def BackAngleAlongY(self) -> float: ...
    @property
    def BackAngleAlongYCell(self) -> IEditorCell: ...
    @property
    def FrontAngleAlongX(self) -> float: ...
    @property
    def FrontAngleAlongXCell(self) -> IEditorCell: ...
    @property
    def FrontAngleAlongY(self) -> float: ...
    @property
    def FrontAngleAlongYCell(self) -> IEditorCell: ...
    @property
    def RadiusA(self) -> float: ...
    @property
    def RadiusACell(self) -> IEditorCell: ...
    @property
    def ZLength(self) -> float: ...
    @property
    def ZLengthCell(self) -> IEditorCell: ...
    @BackAngleAlongX.setter
    def BackAngleAlongX(self, value: float) -> None: ...
    @BackAngleAlongY.setter
    def BackAngleAlongY(self, value: float) -> None: ...
    @FrontAngleAlongX.setter
    def FrontAngleAlongX(self, value: float) -> None: ...
    @FrontAngleAlongY.setter
    def FrontAngleAlongY(self, value: float) -> None: ...
    @RadiusA.setter
    def RadiusA(self, value: float) -> None: ...
    @ZLength.setter
    def ZLength(self, value: float) -> None: ...

class IObjectCylinder2Volume(IObject):
    @property
    def BackAngleAlongX(self) -> float: ...
    @property
    def BackAngleAlongXCell(self) -> IEditorCell: ...
    @property
    def BackAngleAlongY(self) -> float: ...
    @property
    def BackAngleAlongYCell(self) -> IEditorCell: ...
    @property
    def FrontAngleAlongX(self) -> float: ...
    @property
    def FrontAngleAlongXCell(self) -> IEditorCell: ...
    @property
    def FrontAngleAlongY(self) -> float: ...
    @property
    def FrontAngleAlongYCell(self) -> IEditorCell: ...
    @property
    def RadiusA(self) -> float: ...
    @property
    def RadiusACell(self) -> IEditorCell: ...
    @property
    def ZLength(self) -> float: ...
    @property
    def ZLengthCell(self) -> IEditorCell: ...
    @BackAngleAlongX.setter
    def BackAngleAlongX(self, value: float) -> None: ...
    @BackAngleAlongY.setter
    def BackAngleAlongY(self, value: float) -> None: ...
    @FrontAngleAlongX.setter
    def FrontAngleAlongX(self, value: float) -> None: ...
    @FrontAngleAlongY.setter
    def FrontAngleAlongY(self, value: float) -> None: ...
    @RadiusA.setter
    def RadiusA(self, value: float) -> None: ...
    @ZLength.setter
    def ZLength(self, value: float) -> None: ...

class IObjectCylinderPipe(IObject):
    @property
    def BackR(self) -> float: ...
    @property
    def BackRCell(self) -> IEditorCell: ...
    @property
    def FrontR(self) -> float: ...
    @property
    def FrontRCell(self) -> IEditorCell: ...
    @property
    def ZLength(self) -> float: ...
    @property
    def ZLengthCell(self) -> IEditorCell: ...
    @BackR.setter
    def BackR(self, value: float) -> None: ...
    @FrontR.setter
    def FrontR(self, value: float) -> None: ...
    @ZLength.setter
    def ZLength(self, value: float) -> None: ...

class IObjectCylinderVolume(IObject):
    @property
    def BackR(self) -> float: ...
    @property
    def BackRCell(self) -> IEditorCell: ...
    @property
    def FrontR(self) -> float: ...
    @property
    def FrontRCell(self) -> IEditorCell: ...
    @property
    def ZLength(self) -> float: ...
    @property
    def ZLengthCell(self) -> IEditorCell: ...
    @BackR.setter
    def BackR(self, value: float) -> None: ...
    @FrontR.setter
    def FrontR(self, value: float) -> None: ...
    @ZLength.setter
    def ZLength(self, value: float) -> None: ...

class IObjectDetector(IObject):
    def GetColCount(self) -> int: ...
    def GetDetectorDimensions(self) -> tuple[bool, int, int]: ...
    def GetDetectorSize(self) -> int: ...
    def GetRowCount(self) -> int: ...

class IObjectDetectorColor(IObject):
    @property
    def Color(self) -> int: ...
    @property
    def ColorCell(self) -> IEditorCell: ...
    @property
    def DataType(self) -> int: ...
    @property
    def DataTypeCell(self) -> IEditorCell: ...
    @property
    def FrontOnly(self) -> int: ...
    @property
    def FrontOnlyCell(self) -> IEditorCell: ...
    @property
    def Mirroring(self) -> int: ...
    @property
    def MirroringCell(self) -> IEditorCell: ...
    @property
    def NumberXPixels(self) -> int: ...
    @property
    def NumberXPixelsCell(self) -> IEditorCell: ...
    @property
    def NumberYPixels(self) -> int: ...
    @property
    def NumberYPixelsCell(self) -> IEditorCell: ...
    @property
    def PlotScale(self) -> float: ...
    @property
    def PlotScaleCell(self) -> IEditorCell: ...
    @property
    def Polarization(self) -> int: ...
    @property
    def PolarizationCell(self) -> IEditorCell: ...
    @property
    def Scale(self) -> int: ...
    @property
    def ScaleCell(self) -> IEditorCell: ...
    @property
    def Smoothing(self) -> int: ...
    @property
    def SmoothingCell(self) -> IEditorCell: ...
    @property
    def XAngleMax(self) -> float: ...
    @property
    def XAngleMaxCell(self) -> IEditorCell: ...
    @property
    def XAngleMin(self) -> float: ...
    @property
    def XAngleMinCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YAngleMax(self) -> float: ...
    @property
    def YAngleMaxCell(self) -> IEditorCell: ...
    @property
    def YAngleMin(self) -> float: ...
    @property
    def YAngleMinCell(self) -> IEditorCell: ...
    @property
    def YHalfWidth(self) -> float: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @Color.setter
    def Color(self, value: int) -> None: ...
    @DataType.setter
    def DataType(self, value: int) -> None: ...
    @FrontOnly.setter
    def FrontOnly(self, value: int) -> None: ...
    @Mirroring.setter
    def Mirroring(self, value: int) -> None: ...
    @NumberXPixels.setter
    def NumberXPixels(self, value: int) -> None: ...
    @NumberYPixels.setter
    def NumberYPixels(self, value: int) -> None: ...
    @PlotScale.setter
    def PlotScale(self, value: float) -> None: ...
    @Polarization.setter
    def Polarization(self, value: int) -> None: ...
    @Scale.setter
    def Scale(self, value: int) -> None: ...
    @Smoothing.setter
    def Smoothing(self, value: int) -> None: ...
    @XAngleMax.setter
    def XAngleMax(self, value: float) -> None: ...
    @XAngleMin.setter
    def XAngleMin(self, value: float) -> None: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @YAngleMax.setter
    def YAngleMax(self, value: float) -> None: ...
    @YAngleMin.setter
    def YAngleMin(self, value: float) -> None: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...

class IObjectDetectorPolar(IObject):
    @property
    def MaxAngle(self) -> float: ...
    @property
    def MaxAngleCell(self) -> IEditorCell: ...
    @property
    def Mirroring(self) -> bool: ...
    @property
    def MirroringCell(self) -> IEditorCell: ...
    @property
    def NumberAPixels(self) -> int: ...
    @property
    def NumberAPixelsCell(self) -> IEditorCell: ...
    @property
    def NumberPPixels(self) -> int: ...
    @property
    def NumberPPixelsCell(self) -> IEditorCell: ...
    @property
    def RadialSize(self) -> float: ...
    @property
    def RadialSizeCell(self) -> IEditorCell: ...
    @MaxAngle.setter
    def MaxAngle(self, value: float) -> None: ...
    @Mirroring.setter
    def Mirroring(self, value: bool) -> None: ...
    @NumberAPixels.setter
    def NumberAPixels(self, value: int) -> None: ...
    @NumberPPixels.setter
    def NumberPPixels(self, value: int) -> None: ...
    @RadialSize.setter
    def RadialSize(self, value: float) -> None: ...

class IObjectDetectorRectangle(IObject):
    @property
    def Color(self) -> int: ...
    @property
    def ColorCell(self) -> IEditorCell: ...
    @property
    def DataType(self) -> int: ...
    @property
    def DataTypeCell(self) -> IEditorCell: ...
    @property
    def FrontOnly(self) -> int: ...
    @property
    def FrontOnlyCell(self) -> IEditorCell: ...
    @property
    def Mirroring(self) -> int: ...
    @property
    def MirroringCell(self) -> IEditorCell: ...
    @property
    def NumberXPixels(self) -> int: ...
    @property
    def NumberXPixelsCell(self) -> IEditorCell: ...
    @property
    def NumberYPixels(self) -> int: ...
    @property
    def NumberYPixelsCell(self) -> IEditorCell: ...
    @property
    def PlotScale(self) -> float: ...
    @property
    def PlotScaleCell(self) -> IEditorCell: ...
    @property
    def Polarization(self) -> int: ...
    @property
    def PolarizationCell(self) -> IEditorCell: ...
    @property
    def PsfWaveNumber(self) -> int: ...
    @property
    def PsfWaveNumberCell(self) -> IEditorCell: ...
    @property
    def Scale(self) -> int: ...
    @property
    def ScaleCell(self) -> IEditorCell: ...
    @property
    def Smoothing(self) -> int: ...
    @property
    def SmoothingCell(self) -> IEditorCell: ...
    @property
    def XAngleMax(self) -> float: ...
    @property
    def XAngleMaxCell(self) -> IEditorCell: ...
    @property
    def XAngleMin(self) -> float: ...
    @property
    def XAngleMinCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YAngleMax(self) -> float: ...
    @property
    def YAngleMaxCell(self) -> IEditorCell: ...
    @property
    def YAngleMin(self) -> float: ...
    @property
    def YAngleMinCell(self) -> IEditorCell: ...
    @property
    def YHalfWidth(self) -> float: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @Color.setter
    def Color(self, value: int) -> None: ...
    @DataType.setter
    def DataType(self, value: int) -> None: ...
    @FrontOnly.setter
    def FrontOnly(self, value: int) -> None: ...
    @Mirroring.setter
    def Mirroring(self, value: int) -> None: ...
    @NumberXPixels.setter
    def NumberXPixels(self, value: int) -> None: ...
    @NumberYPixels.setter
    def NumberYPixels(self, value: int) -> None: ...
    @PlotScale.setter
    def PlotScale(self, value: float) -> None: ...
    @Polarization.setter
    def Polarization(self, value: int) -> None: ...
    @PsfWaveNumber.setter
    def PsfWaveNumber(self, value: int) -> None: ...
    @Scale.setter
    def Scale(self, value: int) -> None: ...
    @Smoothing.setter
    def Smoothing(self, value: int) -> None: ...
    @XAngleMax.setter
    def XAngleMax(self, value: float) -> None: ...
    @XAngleMin.setter
    def XAngleMin(self, value: float) -> None: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @YAngleMax.setter
    def YAngleMax(self, value: float) -> None: ...
    @YAngleMin.setter
    def YAngleMin(self, value: float) -> None: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...

class IObjectDetectorSurface(IObject):
    @property
    def Color(self) -> int: ...
    @property
    def ColorCell(self) -> IEditorCell: ...
    @property
    def Conic(self) -> float: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def DataType(self) -> int: ...
    @property
    def DataTypeCell(self) -> IEditorCell: ...
    @property
    def FrontOnly(self) -> bool: ...
    @property
    def FrontOnlyCell(self) -> IEditorCell: ...
    @property
    def MaxAperture(self) -> float: ...
    @property
    def MaxApertureCell(self) -> IEditorCell: ...
    @property
    def MaxScale(self) -> float: ...
    @property
    def MaxScaleCell(self) -> IEditorCell: ...
    @property
    def MinAperture(self) -> float: ...
    @property
    def MinApertureCell(self) -> IEditorCell: ...
    @property
    def NumberAZones(self) -> int: ...
    @property
    def NumberAZonesCell(self) -> IEditorCell: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    @property
    def NumberRZones(self) -> int: ...
    @property
    def NumberRZonesCell(self) -> IEditorCell: ...
    @property
    def Radius(self) -> float: ...
    @property
    def RadiusCell(self) -> IEditorCell: ...
    @property
    def Scale(self) -> int: ...
    @property
    def ScaleCell(self) -> IEditorCell: ...
    def GetRPowerI(self, i: int) -> float: ...
    def RPowerICell(self, i: int) -> IEditorCell: ...
    @Color.setter
    def Color(self, value: int) -> None: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @DataType.setter
    def DataType(self, value: int) -> None: ...
    @FrontOnly.setter
    def FrontOnly(self, value: bool) -> None: ...
    @MaxAperture.setter
    def MaxAperture(self, value: float) -> None: ...
    @MaxScale.setter
    def MaxScale(self, value: float) -> None: ...
    @MinAperture.setter
    def MinAperture(self, value: float) -> None: ...
    @NumberAZones.setter
    def NumberAZones(self, value: int) -> None: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    @NumberRZones.setter
    def NumberRZones(self, value: int) -> None: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    @Scale.setter
    def Scale(self, value: int) -> None: ...
    def SetRPowerI(self, i: int, v: float) -> None: ...

class IObjectDetectorVolume(IObject):
    @property
    def NumberXPixels(self) -> int: ...
    @property
    def NumberXPixelsCell(self) -> IEditorCell: ...
    @property
    def NumberYPixels(self) -> int: ...
    @property
    def NumberYPixelsCell(self) -> IEditorCell: ...
    @property
    def NumberZPixels(self) -> int: ...
    @property
    def NumberZPixelsCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidth(self) -> float: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @property
    def ZHalfWidth(self) -> float: ...
    @property
    def ZHalfWidthCell(self) -> IEditorCell: ...
    @NumberXPixels.setter
    def NumberXPixels(self, value: int) -> None: ...
    @NumberYPixels.setter
    def NumberYPixels(self, value: int) -> None: ...
    @NumberZPixels.setter
    def NumberZPixels(self, value: int) -> None: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...
    @ZHalfWidth.setter
    def ZHalfWidth(self, value: float) -> None: ...

class IObjectDiffractionGrating(IObject):
    @property
    def Clear1(self) -> float: ...
    @property
    def Clear1Cell(self) -> IEditorCell: ...
    @property
    def Clear2(self) -> float: ...
    @property
    def Clear2Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnYPower1(self) -> float: ...
    @property
    def CoeffOnYPower1Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnYPower2(self) -> float: ...
    @property
    def CoeffOnYPower2Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnYPower3(self) -> float: ...
    @property
    def CoeffOnYPower3Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnYPower4(self) -> float: ...
    @property
    def CoeffOnYPower4Cell(self) -> IEditorCell: ...
    @property
    def Conic1(self) -> float: ...
    @property
    def Conic1Cell(self) -> IEditorCell: ...
    @property
    def Conic2(self) -> float: ...
    @property
    def Conic2Cell(self) -> IEditorCell: ...
    @property
    def DiffOrder(self) -> float: ...
    @property
    def DiffOrderCell(self) -> IEditorCell: ...
    @property
    def Edge1(self) -> float: ...
    @property
    def Edge1Cell(self) -> IEditorCell: ...
    @property
    def Edge2(self) -> float: ...
    @property
    def Edge2Cell(self) -> IEditorCell: ...
    @property
    def Formula(self) -> int: ...
    @property
    def FormulaCell(self) -> IEditorCell: ...
    @property
    def LinesPerMicron(self) -> float: ...
    @property
    def LinesPerMicronCell(self) -> IEditorCell: ...
    @property
    def Radius1(self) -> float: ...
    @property
    def Radius1Cell(self) -> IEditorCell: ...
    @property
    def Radius2(self) -> float: ...
    @property
    def Radius2Cell(self) -> IEditorCell: ...
    @property
    def Thickness(self) -> float: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @Clear1.setter
    def Clear1(self, value: float) -> None: ...
    @Clear2.setter
    def Clear2(self, value: float) -> None: ...
    @CoeffOnYPower1.setter
    def CoeffOnYPower1(self, value: float) -> None: ...
    @CoeffOnYPower2.setter
    def CoeffOnYPower2(self, value: float) -> None: ...
    @CoeffOnYPower3.setter
    def CoeffOnYPower3(self, value: float) -> None: ...
    @CoeffOnYPower4.setter
    def CoeffOnYPower4(self, value: float) -> None: ...
    @Conic1.setter
    def Conic1(self, value: float) -> None: ...
    @Conic2.setter
    def Conic2(self, value: float) -> None: ...
    @DiffOrder.setter
    def DiffOrder(self, value: float) -> None: ...
    @Edge1.setter
    def Edge1(self, value: float) -> None: ...
    @Edge2.setter
    def Edge2(self, value: float) -> None: ...
    @Formula.setter
    def Formula(self, value: int) -> None: ...
    @LinesPerMicron.setter
    def LinesPerMicron(self, value: float) -> None: ...
    @Radius1.setter
    def Radius1(self, value: float) -> None: ...
    @Radius2.setter
    def Radius2(self, value: float) -> None: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...

class IObjectDualBEFSurface(IObject):
    @property
    def RX(self) -> float: ...
    @property
    def RXCell(self) -> IEditorCell: ...
    @property
    def RY(self) -> float: ...
    @property
    def RYCell(self) -> IEditorCell: ...
    @property
    def TX(self) -> float: ...
    @property
    def TXCell(self) -> IEditorCell: ...
    @property
    def TY(self) -> float: ...
    @property
    def TYCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidth(self) -> float: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @RX.setter
    def RX(self, value: float) -> None: ...
    @RY.setter
    def RY(self, value: float) -> None: ...
    @TX.setter
    def TX(self, value: float) -> None: ...
    @TY.setter
    def TY(self, value: float) -> None: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...

class IObjectEllipse(IObject):
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidth(self) -> float: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...

class IObjectEllipticalVolume(IObject):
    @property
    def BackXHalfWidth(self) -> float: ...
    @property
    def BackXHalfWidthCell(self) -> IEditorCell: ...
    @property
    def BackYHalfWidth(self) -> float: ...
    @property
    def BackYHalfWidthCell(self) -> IEditorCell: ...
    @property
    def FrontXHalfWidth(self) -> float: ...
    @property
    def FrontXHalfWidthCell(self) -> IEditorCell: ...
    @property
    def FrontYHalfWidth(self) -> float: ...
    @property
    def FrontYHalfWidthCell(self) -> IEditorCell: ...
    @property
    def IsVolume(self) -> bool: ...
    @property
    def IsVolumeCell(self) -> IEditorCell: ...
    @property
    def Length(self) -> float: ...
    @property
    def LengthCell(self) -> IEditorCell: ...
    @BackXHalfWidth.setter
    def BackXHalfWidth(self, value: float) -> None: ...
    @BackYHalfWidth.setter
    def BackYHalfWidth(self, value: float) -> None: ...
    @FrontXHalfWidth.setter
    def FrontXHalfWidth(self, value: float) -> None: ...
    @FrontYHalfWidth.setter
    def FrontYHalfWidth(self, value: float) -> None: ...
    @IsVolume.setter
    def IsVolume(self, value: bool) -> None: ...
    @Length.setter
    def Length(self, value: float) -> None: ...

class IObjectEvenAsphereLens(IObject):
    @property
    def Clear1(self) -> float: ...
    @property
    def Clear1Cell(self) -> IEditorCell: ...
    @property
    def Clear2(self) -> float: ...
    @property
    def Clear2Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower10(self) -> float: ...
    @property
    def Coeff1OnRPower10Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower12(self) -> float: ...
    @property
    def Coeff1OnRPower12Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower14(self) -> float: ...
    @property
    def Coeff1OnRPower14Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower16(self) -> float: ...
    @property
    def Coeff1OnRPower16Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower2(self) -> float: ...
    @property
    def Coeff1OnRPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower4(self) -> float: ...
    @property
    def Coeff1OnRPower4Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower6(self) -> float: ...
    @property
    def Coeff1OnRPower6Cell(self) -> IEditorCell: ...
    @property
    def Coeff1OnRPower8(self) -> float: ...
    @property
    def Coeff1OnRPower8Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower10(self) -> float: ...
    @property
    def Coeff2OnRPower10Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower12(self) -> float: ...
    @property
    def Coeff2OnRPower12Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower14(self) -> float: ...
    @property
    def Coeff2OnRPower14Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower16(self) -> float: ...
    @property
    def Coeff2OnRPower16Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower2(self) -> float: ...
    @property
    def Coeff2OnRPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower4(self) -> float: ...
    @property
    def Coeff2OnRPower4Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower6(self) -> float: ...
    @property
    def Coeff2OnRPower6Cell(self) -> IEditorCell: ...
    @property
    def Coeff2OnRPower8(self) -> float: ...
    @property
    def Coeff2OnRPower8Cell(self) -> IEditorCell: ...
    @property
    def Conic1(self) -> float: ...
    @property
    def Conic1Cell(self) -> IEditorCell: ...
    @property
    def Conic2(self) -> float: ...
    @property
    def Conic2Cell(self) -> IEditorCell: ...
    @property
    def Edge1(self) -> float: ...
    @property
    def Edge1Cell(self) -> IEditorCell: ...
    @property
    def Edge2(self) -> float: ...
    @property
    def Edge2Cell(self) -> IEditorCell: ...
    @property
    def Radius1(self) -> float: ...
    @property
    def Radius1Cell(self) -> IEditorCell: ...
    @property
    def Radius2(self) -> float: ...
    @property
    def Radius2Cell(self) -> IEditorCell: ...
    @property
    def Thickness(self) -> float: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @Clear1.setter
    def Clear1(self, value: float) -> None: ...
    @Clear2.setter
    def Clear2(self, value: float) -> None: ...
    @Coeff1OnRPower10.setter
    def Coeff1OnRPower10(self, value: float) -> None: ...
    @Coeff1OnRPower12.setter
    def Coeff1OnRPower12(self, value: float) -> None: ...
    @Coeff1OnRPower14.setter
    def Coeff1OnRPower14(self, value: float) -> None: ...
    @Coeff1OnRPower16.setter
    def Coeff1OnRPower16(self, value: float) -> None: ...
    @Coeff1OnRPower2.setter
    def Coeff1OnRPower2(self, value: float) -> None: ...
    @Coeff1OnRPower4.setter
    def Coeff1OnRPower4(self, value: float) -> None: ...
    @Coeff1OnRPower6.setter
    def Coeff1OnRPower6(self, value: float) -> None: ...
    @Coeff1OnRPower8.setter
    def Coeff1OnRPower8(self, value: float) -> None: ...
    @Coeff2OnRPower10.setter
    def Coeff2OnRPower10(self, value: float) -> None: ...
    @Coeff2OnRPower12.setter
    def Coeff2OnRPower12(self, value: float) -> None: ...
    @Coeff2OnRPower14.setter
    def Coeff2OnRPower14(self, value: float) -> None: ...
    @Coeff2OnRPower16.setter
    def Coeff2OnRPower16(self, value: float) -> None: ...
    @Coeff2OnRPower2.setter
    def Coeff2OnRPower2(self, value: float) -> None: ...
    @Coeff2OnRPower4.setter
    def Coeff2OnRPower4(self, value: float) -> None: ...
    @Coeff2OnRPower6.setter
    def Coeff2OnRPower6(self, value: float) -> None: ...
    @Coeff2OnRPower8.setter
    def Coeff2OnRPower8(self, value: float) -> None: ...
    @Conic1.setter
    def Conic1(self, value: float) -> None: ...
    @Conic2.setter
    def Conic2(self, value: float) -> None: ...
    @Edge1.setter
    def Edge1(self, value: float) -> None: ...
    @Edge2.setter
    def Edge2(self, value: float) -> None: ...
    @Radius1.setter
    def Radius1(self, value: float) -> None: ...
    @Radius2.setter
    def Radius2(self, value: float) -> None: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...

class IObjectExtendedOddAsphereLens(IObject):
    @property
    def FrontK(self) -> float: ...
    @property
    def FrontKCell(self) -> IEditorCell: ...
    @property
    def FrontNormRad(self) -> float: ...
    @property
    def FrontNormRadCell(self) -> IEditorCell: ...
    @property
    def FrontNumTerms(self) -> int: ...
    @property
    def FrontNumTermsCell(self) -> IEditorCell: ...
    @property
    def FrontR(self) -> float: ...
    @property
    def FrontRCell(self) -> IEditorCell: ...
    @property
    def RadialHeight(self) -> float: ...
    @property
    def RadialHeightCell(self) -> IEditorCell: ...
    @property
    def RearK(self) -> float: ...
    @property
    def RearKCell(self) -> IEditorCell: ...
    @property
    def RearNormRad(self) -> float: ...
    @property
    def RearNormRadCell(self) -> IEditorCell: ...
    @property
    def RearNumTerms(self) -> int: ...
    @property
    def RearNumTermsCell(self) -> IEditorCell: ...
    @property
    def RearR(self) -> float: ...
    @property
    def RearRCell(self) -> IEditorCell: ...
    @property
    def Thickness(self) -> float: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    def GetFrontTerm(self, termNumber: int) -> float: ...
    def GetFrontTermCell(self, termNumber: int) -> IEditorCell: ...
    def GetRearTerm(self, termNumber: int) -> float: ...
    def GetRearTermCell(self, termNumber: int) -> IEditorCell: ...
    @FrontK.setter
    def FrontK(self, value: float) -> None: ...
    @FrontNormRad.setter
    def FrontNormRad(self, value: float) -> None: ...
    @FrontNumTerms.setter
    def FrontNumTerms(self, value: int) -> None: ...
    @FrontR.setter
    def FrontR(self, value: float) -> None: ...
    @RadialHeight.setter
    def RadialHeight(self, value: float) -> None: ...
    @RearK.setter
    def RearK(self, value: float) -> None: ...
    @RearNormRad.setter
    def RearNormRad(self, value: float) -> None: ...
    @RearNumTerms.setter
    def RearNumTerms(self, value: int) -> None: ...
    @RearR.setter
    def RearR(self, value: float) -> None: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    def SetFrontTerm(self, termNumber: int, Value: float) -> None: ...
    def SetRearTerm(self, termNumber: int, Value: float) -> None: ...

class IObjectExtendedPolynomialLens(IObject):
    @property
    def FrontK(self) -> float: ...
    @property
    def FrontKCell(self) -> IEditorCell: ...
    @property
    def FrontNormRadius(self) -> float: ...
    @property
    def FrontNormRadiusCell(self) -> IEditorCell: ...
    @property
    def FrontNumTerms(self) -> int: ...
    @property
    def FrontNumTermsCell(self) -> IEditorCell: ...
    @property
    def FrontR(self) -> float: ...
    @property
    def FrontRCell(self) -> IEditorCell: ...
    @property
    def RadialHeight(self) -> float: ...
    @property
    def RadialHeightCell(self) -> IEditorCell: ...
    @property
    def RearK(self) -> float: ...
    @property
    def RearKCell(self) -> IEditorCell: ...
    @property
    def RearNormRadius(self) -> float: ...
    @property
    def RearNormRadiusCell(self) -> IEditorCell: ...
    @property
    def RearNumTerms(self) -> int: ...
    @property
    def RearNumTermsCell(self) -> IEditorCell: ...
    @property
    def RearR(self) -> float: ...
    @property
    def RearRCell(self) -> IEditorCell: ...
    @property
    def Thickness(self) -> float: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    def GetFrontTerm(self, termNumber: int) -> float: ...
    def GetFrontTermCell(self, termNumber: int) -> IEditorCell: ...
    def GetRearTerm(self, termNumber: int) -> float: ...
    def GetRearTermCell(self, termNumber: int) -> IEditorCell: ...
    @FrontK.setter
    def FrontK(self, value: float) -> None: ...
    @FrontNormRadius.setter
    def FrontNormRadius(self, value: float) -> None: ...
    @FrontNumTerms.setter
    def FrontNumTerms(self, value: int) -> None: ...
    @FrontR.setter
    def FrontR(self, value: float) -> None: ...
    @RadialHeight.setter
    def RadialHeight(self, value: float) -> None: ...
    @RearK.setter
    def RearK(self, value: float) -> None: ...
    @RearNormRadius.setter
    def RearNormRadius(self, value: float) -> None: ...
    @RearNumTerms.setter
    def RearNumTerms(self, value: int) -> None: ...
    @RearR.setter
    def RearR(self, value: float) -> None: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    def SetFrontTerm(self, termNumber: int, Value: float) -> None: ...
    def SetRearTerm(self, termNumber: int, Value: float) -> None: ...

class IObjectExtendedPolynomialSurface(IObjectXYPolynomial, IObject):
    @property
    def Conic(self) -> float: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def NormRad(self) -> float: ...
    @property
    def NormRadCell(self) -> IEditorCell: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    @property
    def RadialHeight(self) -> float: ...
    @property
    def RadialHeightCell(self) -> IEditorCell: ...
    @property
    def Radius(self) -> float: ...
    @property
    def RadiusCell(self) -> IEditorCell: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @NormRad.setter
    def NormRad(self, value: float) -> None: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    @RadialHeight.setter
    def RadialHeight(self, value: float) -> None: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...

class IObjectExtruded(IObject):
    @property
    def FrontXScale(self) -> float: ...
    @property
    def FrontXScaleCell(self) -> IEditorCell: ...
    @property
    def FrontYScale(self) -> float: ...
    @property
    def FrontYScaleCell(self) -> IEditorCell: ...
    @property
    def LengthZ(self) -> float: ...
    @property
    def LengthZCell(self) -> IEditorCell: ...
    @property
    def RearXDecenter(self) -> float: ...
    @property
    def RearXDecenterCell(self) -> IEditorCell: ...
    @property
    def RearXScale(self) -> float: ...
    @property
    def RearXScaleCell(self) -> IEditorCell: ...
    @property
    def RearYDecenter(self) -> float: ...
    @property
    def RearYDecenterCell(self) -> IEditorCell: ...
    @property
    def RearYScale(self) -> float: ...
    @property
    def RearYScaleCell(self) -> IEditorCell: ...
    @FrontXScale.setter
    def FrontXScale(self, value: float) -> None: ...
    @FrontYScale.setter
    def FrontYScale(self, value: float) -> None: ...
    @LengthZ.setter
    def LengthZ(self, value: float) -> None: ...
    @RearXDecenter.setter
    def RearXDecenter(self, value: float) -> None: ...
    @RearXScale.setter
    def RearXScale(self, value: float) -> None: ...
    @RearYDecenter.setter
    def RearYDecenter(self, value: float) -> None: ...
    @RearYScale.setter
    def RearYScale(self, value: float) -> None: ...

class IObjectFacetedSurface(IObject):
    @property
    def AngFacets(self) -> int: ...
    @property
    def AngFacetsCell(self) -> IEditorCell: ...
    @property
    def Conic(self) -> float: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def MaxAperture(self) -> float: ...
    @property
    def MaxApertureCell(self) -> IEditorCell: ...
    @property
    def MinAperture(self) -> float: ...
    @property
    def MinApertureCell(self) -> IEditorCell: ...
    @property
    def RadFacets(self) -> int: ...
    @property
    def RadFacetsCell(self) -> IEditorCell: ...
    @property
    def Radius(self) -> float: ...
    @property
    def RadiusCell(self) -> IEditorCell: ...
    @property
    def Shape(self) -> ApertureShapes: ...
    @property
    def ShapeCell(self) -> IEditorCell: ...
    @property
    def XFacets(self) -> int: ...
    @property
    def XFacetsCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YFacets(self) -> int: ...
    @property
    def YFacetsCell(self) -> IEditorCell: ...
    @property
    def YHalfWidth(self) -> float: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @AngFacets.setter
    def AngFacets(self, value: int) -> None: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @MaxAperture.setter
    def MaxAperture(self, value: float) -> None: ...
    @MinAperture.setter
    def MinAperture(self, value: float) -> None: ...
    @RadFacets.setter
    def RadFacets(self, value: int) -> None: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    @Shape.setter
    def Shape(self, value: ApertureShapes) -> None: ...
    @XFacets.setter
    def XFacets(self, value: int) -> None: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @YFacets.setter
    def YFacets(self, value: int) -> None: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...

class IObjectFreeformZ(IObject):
    @property
    def IsVolume(self) -> bool: ...
    @property
    def IsVolumeCell(self) -> IEditorCell: ...
    @property
    def NumberOfPoints(self) -> int: ...
    @property
    def NumberOfPointsCell(self) -> IEditorCell: ...
    def GetY(self, pointN: int) -> float: ...
    def GetYCell(self, pointN: int) -> IEditorCell: ...
    def GetZ(self, pointN: int) -> float: ...
    def GetZCell(self, pointN: int) -> IEditorCell: ...
    @IsVolume.setter
    def IsVolume(self, value: bool) -> None: ...
    @NumberOfPoints.setter
    def NumberOfPoints(self, value: int) -> None: ...
    def SetY(self, pointN: int, Value: float) -> None: ...
    def SetZ(self, pointN: int, Value: float) -> None: ...

class IObjectFresnel1(IObject):
    @property
    def CoeffRPower10(self) -> float: ...
    @property
    def CoeffRPower10Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower12(self) -> float: ...
    @property
    def CoeffRPower12Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower14(self) -> float: ...
    @property
    def CoeffRPower14Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower16(self) -> float: ...
    @property
    def CoeffRPower16Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower2(self) -> float: ...
    @property
    def CoeffRPower2Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower4(self) -> float: ...
    @property
    def CoeffRPower4Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower6(self) -> float: ...
    @property
    def CoeffRPower6Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower8(self) -> float: ...
    @property
    def CoeffRPower8Cell(self) -> IEditorCell: ...
    @property
    def Conic(self) -> float: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def NumberOfSegements(self) -> int: ...
    @property
    def NumberOfSegements16Cell(self) -> IEditorCell: ...
    @property
    def PitchDeg(self) -> float: ...
    @property
    def PitchDegCell(self) -> IEditorCell: ...
    @property
    def PlusDepthPerMinusFreq(self) -> float: ...
    @property
    def PlusDepthPerMinusFreqCell(self) -> IEditorCell: ...
    @property
    def RadialHeight(self) -> float: ...
    @property
    def RadialHeightCell(self) -> IEditorCell: ...
    @property
    def Radius(self) -> float: ...
    @property
    def RadiusCell(self) -> IEditorCell: ...
    @property
    def Thickness(self) -> float: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @CoeffRPower10.setter
    def CoeffRPower10(self, value: float) -> None: ...
    @CoeffRPower12.setter
    def CoeffRPower12(self, value: float) -> None: ...
    @CoeffRPower14.setter
    def CoeffRPower14(self, value: float) -> None: ...
    @CoeffRPower16.setter
    def CoeffRPower16(self, value: float) -> None: ...
    @CoeffRPower2.setter
    def CoeffRPower2(self, value: float) -> None: ...
    @CoeffRPower4.setter
    def CoeffRPower4(self, value: float) -> None: ...
    @CoeffRPower6.setter
    def CoeffRPower6(self, value: float) -> None: ...
    @CoeffRPower8.setter
    def CoeffRPower8(self, value: float) -> None: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @NumberOfSegements.setter
    def NumberOfSegements(self, value: int) -> None: ...
    @PitchDeg.setter
    def PitchDeg(self, value: float) -> None: ...
    @PlusDepthPerMinusFreq.setter
    def PlusDepthPerMinusFreq(self, value: float) -> None: ...
    @RadialHeight.setter
    def RadialHeight(self, value: float) -> None: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...

class IObjectFresnel2(IObject):
    @property
    def CoeffRPower10(self) -> float: ...
    @property
    def CoeffRPower10Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower12(self) -> float: ...
    @property
    def CoeffRPower12Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower14(self) -> float: ...
    @property
    def CoeffRPower14Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower16(self) -> float: ...
    @property
    def CoeffRPower16Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower2(self) -> float: ...
    @property
    def CoeffRPower2Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower4(self) -> float: ...
    @property
    def CoeffRPower4Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower6(self) -> float: ...
    @property
    def CoeffRPower6Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower8(self) -> float: ...
    @property
    def CoeffRPower8Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower10(self) -> float: ...
    @property
    def CoeffYPower10Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower12(self) -> float: ...
    @property
    def CoeffYPower12Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower14(self) -> float: ...
    @property
    def CoeffYPower14Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower16(self) -> float: ...
    @property
    def CoeffYPower16Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower2(self) -> float: ...
    @property
    def CoeffYPower2Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower4(self) -> float: ...
    @property
    def CoeffYPower4Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower6(self) -> float: ...
    @property
    def CoeffYPower6Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower8(self) -> float: ...
    @property
    def CoeffYPower8Cell(self) -> IEditorCell: ...
    @property
    def Conic(self) -> float: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def IsCylinder(self) -> bool: ...
    @property
    def IsCylinderCell(self) -> IEditorCell: ...
    @property
    def RadialHeight(self) -> float: ...
    @property
    def RadialHeightCell(self) -> IEditorCell: ...
    @property
    def Radius(self) -> float: ...
    @property
    def RadiusCell(self) -> IEditorCell: ...
    @property
    def Thickness(self) -> float: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @CoeffRPower10.setter
    def CoeffRPower10(self, value: float) -> None: ...
    @CoeffRPower12.setter
    def CoeffRPower12(self, value: float) -> None: ...
    @CoeffRPower14.setter
    def CoeffRPower14(self, value: float) -> None: ...
    @CoeffRPower16.setter
    def CoeffRPower16(self, value: float) -> None: ...
    @CoeffRPower2.setter
    def CoeffRPower2(self, value: float) -> None: ...
    @CoeffRPower4.setter
    def CoeffRPower4(self, value: float) -> None: ...
    @CoeffRPower6.setter
    def CoeffRPower6(self, value: float) -> None: ...
    @CoeffRPower8.setter
    def CoeffRPower8(self, value: float) -> None: ...
    @CoeffYPower10.setter
    def CoeffYPower10(self, value: float) -> None: ...
    @CoeffYPower12.setter
    def CoeffYPower12(self, value: float) -> None: ...
    @CoeffYPower14.setter
    def CoeffYPower14(self, value: float) -> None: ...
    @CoeffYPower16.setter
    def CoeffYPower16(self, value: float) -> None: ...
    @CoeffYPower2.setter
    def CoeffYPower2(self, value: float) -> None: ...
    @CoeffYPower4.setter
    def CoeffYPower4(self, value: float) -> None: ...
    @CoeffYPower6.setter
    def CoeffYPower6(self, value: float) -> None: ...
    @CoeffYPower8.setter
    def CoeffYPower8(self, value: float) -> None: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @IsCylinder.setter
    def IsCylinder(self, value: bool) -> None: ...
    @RadialHeight.setter
    def RadialHeight(self, value: float) -> None: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...

class IObjectGridSagFrontBack(IObject):
    @property
    def FrontConic(self) -> float: ...
    @property
    def FrontConicCell(self) -> IEditorCell: ...
    @property
    def FrontGridXDecenter(self) -> float: ...
    @property
    def FrontGridXDecenterCell(self) -> IEditorCell: ...
    @property
    def FrontGridYDecenter(self) -> float: ...
    @property
    def FrontGridYDecenterCell(self) -> IEditorCell: ...
    @property
    def FrontInterpolate(self) -> InterpolateChoices: ...
    @property
    def FrontInterpolateCell(self) -> IEditorCell: ...
    @property
    def FrontOrder(self) -> OrderChoices: ...
    @property
    def FrontOrderCell(self) -> IEditorCell: ...
    @property
    def FrontRadius(self) -> float: ...
    @property
    def FrontRadiusCell(self) -> IEditorCell: ...
    @property
    def FrontRPower10(self) -> float: ...
    @property
    def FrontRPower10Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower12(self) -> float: ...
    @property
    def FrontRPower12Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower14(self) -> float: ...
    @property
    def FrontRPower14Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower16(self) -> float: ...
    @property
    def FrontRPower16Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower2(self) -> float: ...
    @property
    def FrontRPower2Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower4(self) -> float: ...
    @property
    def FrontRPower4Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower6(self) -> float: ...
    @property
    def FrontRPower6Cell(self) -> IEditorCell: ...
    @property
    def FrontRPower8(self) -> float: ...
    @property
    def FrontRPower8Cell(self) -> IEditorCell: ...
    @property
    def FrontTiltX(self) -> float: ...
    @property
    def FrontTiltXCell(self) -> IEditorCell: ...
    @property
    def FrontTiltY(self) -> float: ...
    @property
    def FrontTiltYCell(self) -> IEditorCell: ...
    @property
    def FrontTiltZ(self) -> float: ...
    @property
    def FrontTiltZCell(self) -> IEditorCell: ...
    @property
    def FrontXDecenter(self) -> float: ...
    @property
    def FrontXDecenterCell(self) -> IEditorCell: ...
    @property
    def FrontYDecenter(self) -> float: ...
    @property
    def FrontYDecenterCell(self) -> IEditorCell: ...
    @property
    def RearConic(self) -> float: ...
    @property
    def RearConicCell(self) -> IEditorCell: ...
    @property
    def RearGridXDecenter(self) -> float: ...
    @property
    def RearGridXDecenterCell(self) -> IEditorCell: ...
    @property
    def RearGridYDecenter(self) -> float: ...
    @property
    def RearGridYDecenterCell(self) -> IEditorCell: ...
    @property
    def RearInterpolate(self) -> InterpolateChoices: ...
    @property
    def RearInterpolateCell(self) -> IEditorCell: ...
    @property
    def RearOrder(self) -> OrderChoices: ...
    @property
    def RearOrderCell(self) -> IEditorCell: ...
    @property
    def RearRadius(self) -> float: ...
    @property
    def RearRadiusCell(self) -> IEditorCell: ...
    @property
    def RearRPower10(self) -> float: ...
    @property
    def RearRPower10Cell(self) -> IEditorCell: ...
    @property
    def RearRPower12(self) -> float: ...
    @property
    def RearRPower12Cell(self) -> IEditorCell: ...
    @property
    def RearRPower14(self) -> float: ...
    @property
    def RearRPower14Cell(self) -> IEditorCell: ...
    @property
    def RearRPower16(self) -> float: ...
    @property
    def RearRPower16Cell(self) -> IEditorCell: ...
    @property
    def RearRPower2(self) -> float: ...
    @property
    def RearRPower2Cell(self) -> IEditorCell: ...
    @property
    def RearRPower4(self) -> float: ...
    @property
    def RearRPower4Cell(self) -> IEditorCell: ...
    @property
    def RearRPower6(self) -> float: ...
    @property
    def RearRPower6Cell(self) -> IEditorCell: ...
    @property
    def RearRPower8(self) -> float: ...
    @property
    def RearRPower8Cell(self) -> IEditorCell: ...
    @property
    def RearTiltX(self) -> float: ...
    @property
    def RearTiltXCell(self) -> IEditorCell: ...
    @property
    def RearTiltY(self) -> float: ...
    @property
    def RearTiltYCell(self) -> IEditorCell: ...
    @property
    def RearTiltZ(self) -> float: ...
    @property
    def RearTiltZCell(self) -> IEditorCell: ...
    @property
    def RearXDecenter(self) -> float: ...
    @property
    def RearXDecenterCell(self) -> IEditorCell: ...
    @property
    def RearYDecenter(self) -> float: ...
    @property
    def RearYDecenterCell(self) -> IEditorCell: ...
    @property
    def Thickness(self) -> float: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidth(self) -> float: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @FrontConic.setter
    def FrontConic(self, value: float) -> None: ...
    @FrontGridXDecenter.setter
    def FrontGridXDecenter(self, value: float) -> None: ...
    @FrontGridYDecenter.setter
    def FrontGridYDecenter(self, value: float) -> None: ...
    @FrontInterpolate.setter
    def FrontInterpolate(self, value: InterpolateChoices) -> None: ...
    @FrontOrder.setter
    def FrontOrder(self, value: OrderChoices) -> None: ...
    @FrontRadius.setter
    def FrontRadius(self, value: float) -> None: ...
    @FrontRPower10.setter
    def FrontRPower10(self, value: float) -> None: ...
    @FrontRPower12.setter
    def FrontRPower12(self, value: float) -> None: ...
    @FrontRPower14.setter
    def FrontRPower14(self, value: float) -> None: ...
    @FrontRPower16.setter
    def FrontRPower16(self, value: float) -> None: ...
    @FrontRPower2.setter
    def FrontRPower2(self, value: float) -> None: ...
    @FrontRPower4.setter
    def FrontRPower4(self, value: float) -> None: ...
    @FrontRPower6.setter
    def FrontRPower6(self, value: float) -> None: ...
    @FrontRPower8.setter
    def FrontRPower8(self, value: float) -> None: ...
    @FrontTiltX.setter
    def FrontTiltX(self, value: float) -> None: ...
    @FrontTiltY.setter
    def FrontTiltY(self, value: float) -> None: ...
    @FrontTiltZ.setter
    def FrontTiltZ(self, value: float) -> None: ...
    @FrontXDecenter.setter
    def FrontXDecenter(self, value: float) -> None: ...
    @FrontYDecenter.setter
    def FrontYDecenter(self, value: float) -> None: ...
    @RearConic.setter
    def RearConic(self, value: float) -> None: ...
    @RearGridXDecenter.setter
    def RearGridXDecenter(self, value: float) -> None: ...
    @RearGridYDecenter.setter
    def RearGridYDecenter(self, value: float) -> None: ...
    @RearInterpolate.setter
    def RearInterpolate(self, value: InterpolateChoices) -> None: ...
    @RearOrder.setter
    def RearOrder(self, value: OrderChoices) -> None: ...
    @RearRadius.setter
    def RearRadius(self, value: float) -> None: ...
    @RearRPower10.setter
    def RearRPower10(self, value: float) -> None: ...
    @RearRPower12.setter
    def RearRPower12(self, value: float) -> None: ...
    @RearRPower14.setter
    def RearRPower14(self, value: float) -> None: ...
    @RearRPower16.setter
    def RearRPower16(self, value: float) -> None: ...
    @RearRPower2.setter
    def RearRPower2(self, value: float) -> None: ...
    @RearRPower4.setter
    def RearRPower4(self, value: float) -> None: ...
    @RearRPower6.setter
    def RearRPower6(self, value: float) -> None: ...
    @RearRPower8.setter
    def RearRPower8(self, value: float) -> None: ...
    @RearTiltX.setter
    def RearTiltX(self, value: float) -> None: ...
    @RearTiltY.setter
    def RearTiltY(self, value: float) -> None: ...
    @RearTiltZ.setter
    def RearTiltZ(self, value: float) -> None: ...
    @RearXDecenter.setter
    def RearXDecenter(self, value: float) -> None: ...
    @RearYDecenter.setter
    def RearYDecenter(self, value: float) -> None: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...

class IObjectGridSagLens(IObject):
    @property
    def BackConic(self) -> float: ...
    @property
    def BackConicCell(self) -> IEditorCell: ...
    @property
    def BackRadius(self) -> float: ...
    @property
    def BackRadiusCell(self) -> IEditorCell: ...
    @property
    def CoeffRPower10(self) -> float: ...
    @property
    def CoeffRPower10Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower12(self) -> float: ...
    @property
    def CoeffRPower12Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower14(self) -> float: ...
    @property
    def CoeffRPower14Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower16(self) -> float: ...
    @property
    def CoeffRPower16Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower2(self) -> float: ...
    @property
    def CoeffRPower2Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower4(self) -> float: ...
    @property
    def CoeffRPower4Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower6(self) -> float: ...
    @property
    def CoeffRPower6Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower8(self) -> float: ...
    @property
    def CoeffRPower8Cell(self) -> IEditorCell: ...
    @property
    def DecenterX(self) -> float: ...
    @property
    def DecenterXCell(self) -> IEditorCell: ...
    @property
    def DecenterY(self) -> float: ...
    @property
    def DecenterYCell(self) -> IEditorCell: ...
    @property
    def FrontConic(self) -> float: ...
    @property
    def FrontConicCell(self) -> IEditorCell: ...
    @property
    def FrontRadius(self) -> float: ...
    @property
    def FrontRadiusCell(self) -> IEditorCell: ...
    @property
    def Interpolate(self) -> InterpolateChoices: ...
    @property
    def InterpolateCell(self) -> IEditorCell: ...
    @property
    def Thickness(self) -> float: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidth(self) -> float: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @BackConic.setter
    def BackConic(self, value: float) -> None: ...
    @BackRadius.setter
    def BackRadius(self, value: float) -> None: ...
    @CoeffRPower10.setter
    def CoeffRPower10(self, value: float) -> None: ...
    @CoeffRPower12.setter
    def CoeffRPower12(self, value: float) -> None: ...
    @CoeffRPower14.setter
    def CoeffRPower14(self, value: float) -> None: ...
    @CoeffRPower16.setter
    def CoeffRPower16(self, value: float) -> None: ...
    @CoeffRPower2.setter
    def CoeffRPower2(self, value: float) -> None: ...
    @CoeffRPower4.setter
    def CoeffRPower4(self, value: float) -> None: ...
    @CoeffRPower6.setter
    def CoeffRPower6(self, value: float) -> None: ...
    @CoeffRPower8.setter
    def CoeffRPower8(self, value: float) -> None: ...
    @DecenterX.setter
    def DecenterX(self, value: float) -> None: ...
    @DecenterY.setter
    def DecenterY(self, value: float) -> None: ...
    @FrontConic.setter
    def FrontConic(self, value: float) -> None: ...
    @FrontRadius.setter
    def FrontRadius(self, value: float) -> None: ...
    @Interpolate.setter
    def Interpolate(self, value: InterpolateChoices) -> None: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...

class IObjectGridSagSurface(IObject):
    @property
    def CoeffRPower10(self) -> float: ...
    @property
    def CoeffRPower10Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower12(self) -> float: ...
    @property
    def CoeffRPower12Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower14(self) -> float: ...
    @property
    def CoeffRPower14Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower16(self) -> float: ...
    @property
    def CoeffRPower16Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower2(self) -> float: ...
    @property
    def CoeffRPower2Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower4(self) -> float: ...
    @property
    def CoeffRPower4Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower6(self) -> float: ...
    @property
    def CoeffRPower6Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower8(self) -> float: ...
    @property
    def CoeffRPower8Cell(self) -> IEditorCell: ...
    @property
    def Conic(self) -> float: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def DecenterX(self) -> float: ...
    @property
    def DecenterXCell(self) -> IEditorCell: ...
    @property
    def DecenterY(self) -> float: ...
    @property
    def DecenterYCell(self) -> IEditorCell: ...
    @property
    def Interpolate(self) -> InterpolateChoices: ...
    @property
    def InterpolateCell(self) -> IEditorCell: ...
    @property
    def Radius(self) -> float: ...
    @property
    def RadiusCell(self) -> IEditorCell: ...
    @CoeffRPower10.setter
    def CoeffRPower10(self, value: float) -> None: ...
    @CoeffRPower12.setter
    def CoeffRPower12(self, value: float) -> None: ...
    @CoeffRPower14.setter
    def CoeffRPower14(self, value: float) -> None: ...
    @CoeffRPower16.setter
    def CoeffRPower16(self, value: float) -> None: ...
    @CoeffRPower2.setter
    def CoeffRPower2(self, value: float) -> None: ...
    @CoeffRPower4.setter
    def CoeffRPower4(self, value: float) -> None: ...
    @CoeffRPower6.setter
    def CoeffRPower6(self, value: float) -> None: ...
    @CoeffRPower8.setter
    def CoeffRPower8(self, value: float) -> None: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @DecenterX.setter
    def DecenterX(self, value: float) -> None: ...
    @DecenterY.setter
    def DecenterY(self, value: float) -> None: ...
    @Interpolate.setter
    def Interpolate(self, value: InterpolateChoices) -> None: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...

class IObjectHexagonalLensletArray(IObject):
    @property
    def CoeffRPower10(self) -> float: ...
    @property
    def CoeffRPower10Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower12(self) -> float: ...
    @property
    def CoeffRPower12Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower14(self) -> float: ...
    @property
    def CoeffRPower14Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower16(self) -> float: ...
    @property
    def CoeffRPower16Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower2(self) -> float: ...
    @property
    def CoeffRPower2Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower4(self) -> float: ...
    @property
    def CoeffRPower4Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower6(self) -> float: ...
    @property
    def CoeffRPower6Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower8(self) -> float: ...
    @property
    def CoeffRPower8Cell(self) -> IEditorCell: ...
    @property
    def Conic(self) -> float: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def DrawAsFlat(self) -> bool: ...
    @property
    def DrawAsFlatCell(self) -> IEditorCell: ...
    @property
    def NumberOfColumns(self) -> int: ...
    @property
    def NumberOfColumnsCell(self) -> IEditorCell: ...
    @property
    def NumberOfRows(self) -> int: ...
    @property
    def NumberOfRowsCell(self) -> IEditorCell: ...
    @property
    def Radius(self) -> float: ...
    @property
    def RadiusCell(self) -> IEditorCell: ...
    @property
    def Thickness(self) -> float: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def Width(self) -> float: ...
    @property
    def WidthCell(self) -> IEditorCell: ...
    @CoeffRPower10.setter
    def CoeffRPower10(self, value: float) -> None: ...
    @CoeffRPower12.setter
    def CoeffRPower12(self, value: float) -> None: ...
    @CoeffRPower14.setter
    def CoeffRPower14(self, value: float) -> None: ...
    @CoeffRPower16.setter
    def CoeffRPower16(self, value: float) -> None: ...
    @CoeffRPower2.setter
    def CoeffRPower2(self, value: float) -> None: ...
    @CoeffRPower4.setter
    def CoeffRPower4(self, value: float) -> None: ...
    @CoeffRPower6.setter
    def CoeffRPower6(self, value: float) -> None: ...
    @CoeffRPower8.setter
    def CoeffRPower8(self, value: float) -> None: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @DrawAsFlat.setter
    def DrawAsFlat(self, value: bool) -> None: ...
    @NumberOfColumns.setter
    def NumberOfColumns(self, value: int) -> None: ...
    @NumberOfRows.setter
    def NumberOfRows(self, value: int) -> None: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @Width.setter
    def Width(self, value: float) -> None: ...

class IObjectHologramLens(IObject):
    @property
    def Conic1(self) -> float: ...
    @property
    def Conic1Cell(self) -> IEditorCell: ...
    @property
    def Conic2(self) -> float: ...
    @property
    def Conic2Cell(self) -> IEditorCell: ...
    @property
    def ConsiderFresnel(self) -> int: ...
    @property
    def ConsiderFresnelCell(self) -> IEditorCell: ...
    @property
    def ConsWave(self) -> float: ...
    @property
    def ConsWaveCell(self) -> IEditorCell: ...
    @property
    def dn(self) -> float: ...
    @property
    def dnCell(self) -> IEditorCell: ...
    @property
    def HologramThickness(self) -> float: ...
    @property
    def HologramThicknessCell(self) -> IEditorCell: ...
    @property
    def HologramType(self) -> int: ...
    @property
    def HologramTypeCell(self) -> IEditorCell: ...
    @property
    def IndexShift(self) -> float: ...
    @property
    def IndexShiftCell(self) -> IEditorCell: ...
    @property
    def IsVolumeHologram(self) -> int: ...
    @property
    def IsVolumeHologramCell(self) -> IEditorCell: ...
    @property
    def n(self) -> float: ...
    @property
    def n1(self) -> float: ...
    @property
    def n1Cell(self) -> IEditorCell: ...
    @property
    def n2(self) -> float: ...
    @property
    def n2Cell(self) -> IEditorCell: ...
    @property
    def nCell(self) -> IEditorCell: ...
    @property
    def Order(self) -> float: ...
    @property
    def OrderCell(self) -> IEditorCell: ...
    @property
    def RadialHeight(self) -> float: ...
    @property
    def RadialHeightCell(self) -> IEditorCell: ...
    @property
    def Radius1(self) -> float: ...
    @property
    def Radius1Cell(self) -> IEditorCell: ...
    @property
    def Radius2(self) -> float: ...
    @property
    def Radius2Cell(self) -> IEditorCell: ...
    @property
    def Shrinkage(self) -> float: ...
    @property
    def ShrinkageCell(self) -> IEditorCell: ...
    @property
    def Thickness(self) -> float: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def X1(self) -> float: ...
    @property
    def X1Cell(self) -> IEditorCell: ...
    @property
    def X2(self) -> float: ...
    @property
    def X2Cell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def Y1(self) -> float: ...
    @property
    def Y1Cell(self) -> IEditorCell: ...
    @property
    def Y2(self) -> float: ...
    @property
    def Y2Cell(self) -> IEditorCell: ...
    @property
    def Z1(self) -> float: ...
    @property
    def Z1Cell(self) -> IEditorCell: ...
    @property
    def Z2(self) -> float: ...
    @property
    def Z2Cell(self) -> IEditorCell: ...
    @Conic1.setter
    def Conic1(self, value: float) -> None: ...
    @Conic2.setter
    def Conic2(self, value: float) -> None: ...
    @ConsiderFresnel.setter
    def ConsiderFresnel(self, value: int) -> None: ...
    @ConsWave.setter
    def ConsWave(self, value: float) -> None: ...
    @dn.setter
    def dn(self, value: float) -> None: ...
    @HologramThickness.setter
    def HologramThickness(self, value: float) -> None: ...
    @HologramType.setter
    def HologramType(self, value: int) -> None: ...
    @IndexShift.setter
    def IndexShift(self, value: float) -> None: ...
    @IsVolumeHologram.setter
    def IsVolumeHologram(self, value: int) -> None: ...
    @n.setter
    def n(self, value: float) -> None: ...
    @n1.setter
    def n1(self, value: float) -> None: ...
    @n2.setter
    def n2(self, value: float) -> None: ...
    @Order.setter
    def Order(self, value: float) -> None: ...
    @RadialHeight.setter
    def RadialHeight(self, value: float) -> None: ...
    @Radius1.setter
    def Radius1(self, value: float) -> None: ...
    @Radius2.setter
    def Radius2(self, value: float) -> None: ...
    @Shrinkage.setter
    def Shrinkage(self, value: float) -> None: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @X1.setter
    def X1(self, value: float) -> None: ...
    @X2.setter
    def X2(self, value: float) -> None: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @Y1.setter
    def Y1(self, value: float) -> None: ...
    @Y2.setter
    def Y2(self, value: float) -> None: ...
    @Z1.setter
    def Z1(self, value: float) -> None: ...
    @Z2.setter
    def Z2(self, value: float) -> None: ...

class IObjectHologramSurface(IObject):
    @property
    def Conic(self) -> float: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def ConsiderFresnel(self) -> int: ...
    @property
    def ConsiderFresnelCell(self) -> IEditorCell: ...
    @property
    def ConsWave(self) -> float: ...
    @property
    def ConsWaveCell(self) -> IEditorCell: ...
    @property
    def dn(self) -> float: ...
    @property
    def dnCell(self) -> IEditorCell: ...
    @property
    def HologramThickness(self) -> float: ...
    @property
    def HologramThicknessCell(self) -> IEditorCell: ...
    @property
    def HologramType(self) -> int: ...
    @property
    def HologramTypeCell(self) -> IEditorCell: ...
    @property
    def IndexShift(self) -> float: ...
    @property
    def IndexShiftCell(self) -> IEditorCell: ...
    @property
    def IsVolumeHologram(self) -> int: ...
    @property
    def IsVolumeHologramCell(self) -> IEditorCell: ...
    @property
    def MaxAperture(self) -> float: ...
    @property
    def MaxApertureCell(self) -> IEditorCell: ...
    @property
    def MinAperture(self) -> float: ...
    @property
    def MinApertureCell(self) -> IEditorCell: ...
    @property
    def n(self) -> float: ...
    @property
    def n1(self) -> float: ...
    @property
    def n1Cell(self) -> IEditorCell: ...
    @property
    def n2(self) -> float: ...
    @property
    def n2Cell(self) -> IEditorCell: ...
    @property
    def nCell(self) -> IEditorCell: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    @property
    def Order(self) -> float: ...
    @property
    def OrderCell(self) -> IEditorCell: ...
    @property
    def Radius(self) -> float: ...
    @property
    def RadiusCell(self) -> IEditorCell: ...
    @property
    def Shrinkage(self) -> float: ...
    @property
    def ShrinkageCell(self) -> IEditorCell: ...
    @property
    def X1(self) -> float: ...
    @property
    def X1Cell(self) -> IEditorCell: ...
    @property
    def X2(self) -> float: ...
    @property
    def X2Cell(self) -> IEditorCell: ...
    @property
    def Y1(self) -> float: ...
    @property
    def Y1Cell(self) -> IEditorCell: ...
    @property
    def Y2(self) -> float: ...
    @property
    def Y2Cell(self) -> IEditorCell: ...
    @property
    def Z1(self) -> float: ...
    @property
    def Z1Cell(self) -> IEditorCell: ...
    @property
    def Z2(self) -> float: ...
    @property
    def Z2Cell(self) -> IEditorCell: ...
    def GetRPowerI(self, i: int) -> float: ...
    def RPowerICell(self, i: int) -> IEditorCell: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @ConsiderFresnel.setter
    def ConsiderFresnel(self, value: int) -> None: ...
    @ConsWave.setter
    def ConsWave(self, value: float) -> None: ...
    @dn.setter
    def dn(self, value: float) -> None: ...
    @HologramThickness.setter
    def HologramThickness(self, value: float) -> None: ...
    @HologramType.setter
    def HologramType(self, value: int) -> None: ...
    @IndexShift.setter
    def IndexShift(self, value: float) -> None: ...
    @IsVolumeHologram.setter
    def IsVolumeHologram(self, value: int) -> None: ...
    @MaxAperture.setter
    def MaxAperture(self, value: float) -> None: ...
    @MinAperture.setter
    def MinAperture(self, value: float) -> None: ...
    @n.setter
    def n(self, value: float) -> None: ...
    @n1.setter
    def n1(self, value: float) -> None: ...
    @n2.setter
    def n2(self, value: float) -> None: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    @Order.setter
    def Order(self, value: float) -> None: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    @Shrinkage.setter
    def Shrinkage(self, value: float) -> None: ...
    @X1.setter
    def X1(self, value: float) -> None: ...
    @X2.setter
    def X2(self, value: float) -> None: ...
    @Y1.setter
    def Y1(self, value: float) -> None: ...
    @Y2.setter
    def Y2(self, value: float) -> None: ...
    @Z1.setter
    def Z1(self, value: float) -> None: ...
    @Z2.setter
    def Z2(self, value: float) -> None: ...
    def SetRPowerI(self, i: int, v: float) -> None: ...

class IObjectJonesMatrix(IObject):
    @property
    def AImag(self) -> float: ...
    @property
    def AImagCell(self) -> IEditorCell: ...
    @property
    def AReal(self) -> float: ...
    @property
    def ARealCell(self) -> IEditorCell: ...
    @property
    def BImag(self) -> float: ...
    @property
    def BImagCell(self) -> IEditorCell: ...
    @property
    def BReal(self) -> float: ...
    @property
    def BRealCell(self) -> IEditorCell: ...
    @property
    def CImag(self) -> float: ...
    @property
    def CImagCell(self) -> IEditorCell: ...
    @property
    def CReal(self) -> float: ...
    @property
    def CRealCell(self) -> IEditorCell: ...
    @property
    def DImag(self) -> float: ...
    @property
    def DImagCell(self) -> IEditorCell: ...
    @property
    def DReal(self) -> float: ...
    @property
    def DRealCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidth(self) -> float: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @AImag.setter
    def AImag(self, value: float) -> None: ...
    @AReal.setter
    def AReal(self, value: float) -> None: ...
    @BImag.setter
    def BImag(self, value: float) -> None: ...
    @BReal.setter
    def BReal(self, value: float) -> None: ...
    @CImag.setter
    def CImag(self, value: float) -> None: ...
    @CReal.setter
    def CReal(self, value: float) -> None: ...
    @DImag.setter
    def DImag(self, value: float) -> None: ...
    @DReal.setter
    def DReal(self, value: float) -> None: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...

class IObjectLensletArray1(IObject):
    @property
    def CoeffRPower10(self) -> float: ...
    @property
    def CoeffRPower10Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower12(self) -> float: ...
    @property
    def CoeffRPower12Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower14(self) -> float: ...
    @property
    def CoeffRPower14Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower16(self) -> float: ...
    @property
    def CoeffRPower16Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower2(self) -> float: ...
    @property
    def CoeffRPower2Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower4(self) -> float: ...
    @property
    def CoeffRPower4Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower6(self) -> float: ...
    @property
    def CoeffRPower6Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower8(self) -> float: ...
    @property
    def CoeffRPower8Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower10(self) -> float: ...
    @property
    def CoeffYPower10Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower12(self) -> float: ...
    @property
    def CoeffYPower12Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower14(self) -> float: ...
    @property
    def CoeffYPower14Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower16(self) -> float: ...
    @property
    def CoeffYPower16Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower2(self) -> float: ...
    @property
    def CoeffYPower2Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower4(self) -> float: ...
    @property
    def CoeffYPower4Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower6(self) -> float: ...
    @property
    def CoeffYPower6Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower8(self) -> float: ...
    @property
    def CoeffYPower8Cell(self) -> IEditorCell: ...
    @property
    def Conic(self) -> float: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def DecenterX(self) -> float: ...
    @property
    def DecenterXCell(self) -> IEditorCell: ...
    @property
    def DecenterY(self) -> float: ...
    @property
    def DecenterYCell(self) -> IEditorCell: ...
    @property
    def DiffOrder(self) -> float: ...
    @property
    def DiffOrderCell(self) -> IEditorCell: ...
    @property
    def DiffractiveFace(self) -> DiffractiveFaceChoices: ...
    @property
    def DiffractiveFaceCell(self) -> IEditorCell: ...
    @property
    def IsToric(self) -> bool: ...
    @property
    def IsToricCell(self) -> IEditorCell: ...
    @property
    def LinesPerUM(self) -> float: ...
    @property
    def LinesPerUMCell(self) -> IEditorCell: ...
    @property
    def NumberInX(self) -> int: ...
    @property
    def NumberInXCell(self) -> IEditorCell: ...
    @property
    def NumberInY(self) -> int: ...
    @property
    def NumberInYCell(self) -> IEditorCell: ...
    @property
    def Radius(self) -> float: ...
    @property
    def RadiusCell(self) -> IEditorCell: ...
    @property
    def Thickness(self) -> float: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def ToricR(self) -> float: ...
    @property
    def ToricRCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidth(self) -> float: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @CoeffRPower10.setter
    def CoeffRPower10(self, value: float) -> None: ...
    @CoeffRPower12.setter
    def CoeffRPower12(self, value: float) -> None: ...
    @CoeffRPower14.setter
    def CoeffRPower14(self, value: float) -> None: ...
    @CoeffRPower16.setter
    def CoeffRPower16(self, value: float) -> None: ...
    @CoeffRPower2.setter
    def CoeffRPower2(self, value: float) -> None: ...
    @CoeffRPower4.setter
    def CoeffRPower4(self, value: float) -> None: ...
    @CoeffRPower6.setter
    def CoeffRPower6(self, value: float) -> None: ...
    @CoeffRPower8.setter
    def CoeffRPower8(self, value: float) -> None: ...
    @CoeffYPower10.setter
    def CoeffYPower10(self, value: float) -> None: ...
    @CoeffYPower12.setter
    def CoeffYPower12(self, value: float) -> None: ...
    @CoeffYPower14.setter
    def CoeffYPower14(self, value: float) -> None: ...
    @CoeffYPower16.setter
    def CoeffYPower16(self, value: float) -> None: ...
    @CoeffYPower2.setter
    def CoeffYPower2(self, value: float) -> None: ...
    @CoeffYPower4.setter
    def CoeffYPower4(self, value: float) -> None: ...
    @CoeffYPower6.setter
    def CoeffYPower6(self, value: float) -> None: ...
    @CoeffYPower8.setter
    def CoeffYPower8(self, value: float) -> None: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @DecenterX.setter
    def DecenterX(self, value: float) -> None: ...
    @DecenterY.setter
    def DecenterY(self, value: float) -> None: ...
    @DiffOrder.setter
    def DiffOrder(self, value: float) -> None: ...
    @DiffractiveFace.setter
    def DiffractiveFace(self, value: DiffractiveFaceChoices) -> None: ...
    @IsToric.setter
    def IsToric(self, value: bool) -> None: ...
    @LinesPerUM.setter
    def LinesPerUM(self, value: float) -> None: ...
    @NumberInX.setter
    def NumberInX(self, value: int) -> None: ...
    @NumberInY.setter
    def NumberInY(self, value: int) -> None: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @ToricR.setter
    def ToricR(self, value: float) -> None: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...

class IObjectLensletArray2(IObject):
    @property
    def Conic1(self) -> float: ...
    @property
    def Conic1Cell(self) -> IEditorCell: ...
    @property
    def Conic2(self) -> float: ...
    @property
    def Conic2Cell(self) -> IEditorCell: ...
    @property
    def NumberInX(self) -> int: ...
    @property
    def NumberInXCell(self) -> IEditorCell: ...
    @property
    def NumberInY(self) -> int: ...
    @property
    def NumberInYCell(self) -> IEditorCell: ...
    @property
    def Radius1(self) -> float: ...
    @property
    def Radius1Cell(self) -> IEditorCell: ...
    @property
    def Radius2(self) -> float: ...
    @property
    def Radius2Cell(self) -> IEditorCell: ...
    @property
    def Thickness(self) -> float: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidth(self) -> float: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @Conic1.setter
    def Conic1(self, value: float) -> None: ...
    @Conic2.setter
    def Conic2(self, value: float) -> None: ...
    @NumberInX.setter
    def NumberInX(self, value: int) -> None: ...
    @NumberInY.setter
    def NumberInY(self, value: int) -> None: ...
    @Radius1.setter
    def Radius1(self, value: float) -> None: ...
    @Radius2.setter
    def Radius2(self, value: float) -> None: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...

class IObjectMEMS(IObject):
    @property
    def Angle0(self) -> float: ...
    @property
    def Angle0Cell(self) -> IEditorCell: ...
    @property
    def Angle1(self) -> float: ...
    @property
    def Angle1Cell(self) -> IEditorCell: ...
    @property
    def Angle2(self) -> float: ...
    @property
    def Angle2Cell(self) -> IEditorCell: ...
    @property
    def NumberOfXPixels(self) -> int: ...
    @property
    def NumberOfXPixelsCell(self) -> IEditorCell: ...
    @property
    def NumberOfYPixels(self) -> int: ...
    @property
    def NumberOfYPixelsCell(self) -> IEditorCell: ...
    @property
    def PFlag(self) -> PixelAddressing: ...
    @property
    def PFlagCell(self) -> IEditorCell: ...
    @property
    def RotationAngle(self) -> float: ...
    @property
    def RotationAngleCell(self) -> IEditorCell: ...
    @property
    def XMinusWidth(self) -> float: ...
    @property
    def XMinusWidthCell(self) -> IEditorCell: ...
    @property
    def YMinusWidth(self) -> float: ...
    @property
    def YMinusWidthCell(self) -> IEditorCell: ...
    def GetPixelAddressGroupN(self, n: int) -> int: ...
    def PixelAddressGroupNCell(self, n: int) -> IEditorCell: ...
    @Angle0.setter
    def Angle0(self, value: float) -> None: ...
    @Angle1.setter
    def Angle1(self, value: float) -> None: ...
    @Angle2.setter
    def Angle2(self, value: float) -> None: ...
    @NumberOfXPixels.setter
    def NumberOfXPixels(self, value: int) -> None: ...
    @NumberOfYPixels.setter
    def NumberOfYPixels(self, value: int) -> None: ...
    @PFlag.setter
    def PFlag(self, value: PixelAddressing) -> None: ...
    @RotationAngle.setter
    def RotationAngle(self, value: float) -> None: ...
    @XMinusWidth.setter
    def XMinusWidth(self, value: float) -> None: ...
    @YMinusWidth.setter
    def YMinusWidth(self, value: float) -> None: ...
    def SetPixelAddressGroupN(self, n: int, Value: int) -> None: ...

class IObjectNullObject(IObject):
    pass

class IObjectOddAsphereLens(IObject):
    @property
    def Clear1(self) -> float: ...
    @property
    def Clear1Cell(self) -> IEditorCell: ...
    @property
    def Clear2(self) -> float: ...
    @property
    def Clear2Cell(self) -> IEditorCell: ...
    @property
    def Coeff10RPower1(self) -> float: ...
    @property
    def Coeff10RPower1Cell(self) -> IEditorCell: ...
    @property
    def Coeff10RPower2(self) -> float: ...
    @property
    def Coeff10RPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff11RPower1(self) -> float: ...
    @property
    def Coeff11RPower1Cell(self) -> IEditorCell: ...
    @property
    def Coeff11RPower2(self) -> float: ...
    @property
    def Coeff11RPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff12RPower1(self) -> float: ...
    @property
    def Coeff12RPower1Cell(self) -> IEditorCell: ...
    @property
    def Coeff12RPower2(self) -> float: ...
    @property
    def Coeff12RPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff1RPower1(self) -> float: ...
    @property
    def Coeff1RPower1Cell(self) -> IEditorCell: ...
    @property
    def Coeff1RPower2(self) -> float: ...
    @property
    def Coeff1RPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff2RPower1(self) -> float: ...
    @property
    def Coeff2RPower1Cell(self) -> IEditorCell: ...
    @property
    def Coeff2RPower2(self) -> float: ...
    @property
    def Coeff2RPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff3RPower1(self) -> float: ...
    @property
    def Coeff3RPower1Cell(self) -> IEditorCell: ...
    @property
    def Coeff3RPower2(self) -> float: ...
    @property
    def Coeff3RPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff4RPower1(self) -> float: ...
    @property
    def Coeff4RPower1Cell(self) -> IEditorCell: ...
    @property
    def Coeff4RPower2(self) -> float: ...
    @property
    def Coeff4RPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff5RPower1(self) -> float: ...
    @property
    def Coeff5RPower1Cell(self) -> IEditorCell: ...
    @property
    def Coeff5RPower2(self) -> float: ...
    @property
    def Coeff5RPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff6RPower1(self) -> float: ...
    @property
    def Coeff6RPower1Cell(self) -> IEditorCell: ...
    @property
    def Coeff6RPower2(self) -> float: ...
    @property
    def Coeff6RPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff7RPower1(self) -> float: ...
    @property
    def Coeff7RPower1Cell(self) -> IEditorCell: ...
    @property
    def Coeff7RPower2(self) -> float: ...
    @property
    def Coeff7RPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff8RPower1(self) -> float: ...
    @property
    def Coeff8RPower1Cell(self) -> IEditorCell: ...
    @property
    def Coeff8RPower2(self) -> float: ...
    @property
    def Coeff8RPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff9RPower1(self) -> float: ...
    @property
    def Coeff9RPower1Cell(self) -> IEditorCell: ...
    @property
    def Coeff9RPower2(self) -> float: ...
    @property
    def Coeff9RPower2Cell(self) -> IEditorCell: ...
    @property
    def Conic1(self) -> float: ...
    @property
    def Conic1Cell(self) -> IEditorCell: ...
    @property
    def Conic2(self) -> float: ...
    @property
    def Conic2Cell(self) -> IEditorCell: ...
    @property
    def Edge1(self) -> float: ...
    @property
    def Edge1Cell(self) -> IEditorCell: ...
    @property
    def Edge2(self) -> float: ...
    @property
    def Edge2Cell(self) -> IEditorCell: ...
    @property
    def Radius1(self) -> float: ...
    @property
    def Radius1Cell(self) -> IEditorCell: ...
    @property
    def Radius2(self) -> float: ...
    @property
    def Radius2Cell(self) -> IEditorCell: ...
    @property
    def Thickness(self) -> float: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @Clear1.setter
    def Clear1(self, value: float) -> None: ...
    @Clear2.setter
    def Clear2(self, value: float) -> None: ...
    @Coeff10RPower1.setter
    def Coeff10RPower1(self, value: float) -> None: ...
    @Coeff10RPower2.setter
    def Coeff10RPower2(self, value: float) -> None: ...
    @Coeff11RPower1.setter
    def Coeff11RPower1(self, value: float) -> None: ...
    @Coeff11RPower2.setter
    def Coeff11RPower2(self, value: float) -> None: ...
    @Coeff12RPower1.setter
    def Coeff12RPower1(self, value: float) -> None: ...
    @Coeff12RPower2.setter
    def Coeff12RPower2(self, value: float) -> None: ...
    @Coeff1RPower1.setter
    def Coeff1RPower1(self, value: float) -> None: ...
    @Coeff1RPower2.setter
    def Coeff1RPower2(self, value: float) -> None: ...
    @Coeff2RPower1.setter
    def Coeff2RPower1(self, value: float) -> None: ...
    @Coeff2RPower2.setter
    def Coeff2RPower2(self, value: float) -> None: ...
    @Coeff3RPower1.setter
    def Coeff3RPower1(self, value: float) -> None: ...
    @Coeff3RPower2.setter
    def Coeff3RPower2(self, value: float) -> None: ...
    @Coeff4RPower1.setter
    def Coeff4RPower1(self, value: float) -> None: ...
    @Coeff4RPower2.setter
    def Coeff4RPower2(self, value: float) -> None: ...
    @Coeff5RPower1.setter
    def Coeff5RPower1(self, value: float) -> None: ...
    @Coeff5RPower2.setter
    def Coeff5RPower2(self, value: float) -> None: ...
    @Coeff6RPower1.setter
    def Coeff6RPower1(self, value: float) -> None: ...
    @Coeff6RPower2.setter
    def Coeff6RPower2(self, value: float) -> None: ...
    @Coeff7RPower1.setter
    def Coeff7RPower1(self, value: float) -> None: ...
    @Coeff7RPower2.setter
    def Coeff7RPower2(self, value: float) -> None: ...
    @Coeff8RPower1.setter
    def Coeff8RPower1(self, value: float) -> None: ...
    @Coeff8RPower2.setter
    def Coeff8RPower2(self, value: float) -> None: ...
    @Coeff9RPower1.setter
    def Coeff9RPower1(self, value: float) -> None: ...
    @Coeff9RPower2.setter
    def Coeff9RPower2(self, value: float) -> None: ...
    @Conic1.setter
    def Conic1(self, value: float) -> None: ...
    @Conic2.setter
    def Conic2(self, value: float) -> None: ...
    @Edge1.setter
    def Edge1(self, value: float) -> None: ...
    @Edge2.setter
    def Edge2(self, value: float) -> None: ...
    @Radius1.setter
    def Radius1(self, value: float) -> None: ...
    @Radius2.setter
    def Radius2(self, value: float) -> None: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...

class IObjectOffAxisMirror(IObject):
    @property
    def Conic1(self) -> float: ...
    @property
    def Conic1Cell(self) -> IEditorCell: ...
    @property
    def NormRadius(self) -> float: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def NumTerms(self) -> int: ...
    @property
    def NumTermsCell(self) -> IEditorCell: ...
    @property
    def OffAxis(self) -> float: ...
    @property
    def OffAxisCell(self) -> IEditorCell: ...
    @property
    def Radius1(self) -> float: ...
    @property
    def Radius1Cell(self) -> IEditorCell: ...
    @property
    def Radius2(self) -> float: ...
    @property
    def Radius2Cell(self) -> IEditorCell: ...
    @property
    def Shape(self) -> int: ...
    @property
    def ShapeCell(self) -> IEditorCell: ...
    @property
    def Thickness(self) -> float: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidth(self) -> float: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    def GetCoefficient(self, term: int) -> float: ...
    def GetCoefficientCell(self, termNumber: int) -> IEditorCell: ...
    @Conic1.setter
    def Conic1(self, value: float) -> None: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...
    @NumTerms.setter
    def NumTerms(self, value: int) -> None: ...
    @OffAxis.setter
    def OffAxis(self, value: float) -> None: ...
    @Radius1.setter
    def Radius1(self, value: float) -> None: ...
    @Radius2.setter
    def Radius2(self, value: float) -> None: ...
    @Shape.setter
    def Shape(self, value: int) -> None: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...
    def SetCoefficient(self, term: int, value: float) -> None: ...

class IObjectParaxialLens(IObject):
    @property
    def XFocalLength(self) -> float: ...
    @property
    def XFocalLengthCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YFocalLength(self) -> float: ...
    @property
    def YFocalLengthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidth(self) -> float: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @XFocalLength.setter
    def XFocalLength(self, value: float) -> None: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @YFocalLength.setter
    def YFocalLength(self, value: float) -> None: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...

class IObjectPolygon(IObject):
    @property
    def IsVolume(self) -> bool: ...
    @property
    def IsVolumeCell(self) -> IEditorCell: ...
    @property
    def Scale(self) -> float: ...
    @property
    def ScaleCell(self) -> IEditorCell: ...
    @IsVolume.setter
    def IsVolume(self, value: bool) -> None: ...
    @Scale.setter
    def Scale(self, value: float) -> None: ...

class IObjectQTypeAsphereSurface(IObject):
    def CoefficientICell(self, i: int) -> IEditorCell: ...
    @property
    def Conic(self) -> float: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def MaxAperture(self) -> float: ...
    @property
    def MaxApertureCell(self) -> IEditorCell: ...
    @property
    def MinAperture(self) -> float: ...
    @property
    def MinApertureCell(self) -> IEditorCell: ...
    @property
    def ModelType(self) -> int: ...
    @property
    def ModelTypeCell(self) -> IEditorCell: ...
    @property
    def NormRadius(self) -> float: ...
    @property
    def NormRadiusCell(self) -> IEditorCell: ...
    @property
    def NumberOfTerms(self) -> int: ...
    @property
    def NumberOfTermsCell(self) -> IEditorCell: ...
    @property
    def Radius(self) -> float: ...
    @property
    def RadiusCell(self) -> IEditorCell: ...
    def GetCoefficientI(self, i: int) -> float: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @MaxAperture.setter
    def MaxAperture(self, value: float) -> None: ...
    @MinAperture.setter
    def MinAperture(self, value: float) -> None: ...
    @ModelType.setter
    def ModelType(self, value: int) -> None: ...
    @NormRadius.setter
    def NormRadius(self, value: float) -> None: ...
    @NumberOfTerms.setter
    def NumberOfTerms(self, value: int) -> None: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    def SetCoefficientI(self, i: int, v: float) -> None: ...

class IObjectRayRotator(IObject):
    @property
    def RotateY(self) -> float: ...
    @property
    def RotateYCell(self) -> IEditorCell: ...
    @property
    def RotateZ(self) -> float: ...
    @property
    def RotateZCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidth(self) -> float: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @RotateY.setter
    def RotateY(self, value: float) -> None: ...
    @RotateZ.setter
    def RotateZ(self, value: float) -> None: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...

class IObjectRectangle(IObject):
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidth(self) -> float: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...

class IObjectRectangularCorner(IObject):
    @property
    def Length(self) -> float: ...
    @property
    def LengthCell(self) -> IEditorCell: ...
    @Length.setter
    def Length(self, value: float) -> None: ...

class IObjectRectangularPipe(IObject):
    @property
    def FrontXAngle(self) -> float: ...
    @property
    def FrontXAngleCell(self) -> IEditorCell: ...
    @property
    def FrontYAngle(self) -> float: ...
    @property
    def FrontYAngleCell(self) -> IEditorCell: ...
    @property
    def RearXAngle(self) -> float: ...
    @property
    def RearXAngleCell(self) -> IEditorCell: ...
    @property
    def RearYAngle(self) -> float: ...
    @property
    def RearYAngleCell(self) -> IEditorCell: ...
    @property
    def X1HalfWidth(self) -> float: ...
    @property
    def X1HalfWidthCell(self) -> IEditorCell: ...
    @property
    def X2HalfWidth(self) -> float: ...
    @property
    def X2HalfWidthCell(self) -> IEditorCell: ...
    @property
    def Y1HalfWidth(self) -> float: ...
    @property
    def Y1HalfWidthCell(self) -> IEditorCell: ...
    @property
    def Y2HalfWidth(self) -> float: ...
    @property
    def Y2HalfWidthCell(self) -> IEditorCell: ...
    @property
    def ZLength(self) -> float: ...
    @property
    def ZLengthCell(self) -> IEditorCell: ...
    @FrontXAngle.setter
    def FrontXAngle(self, value: float) -> None: ...
    @FrontYAngle.setter
    def FrontYAngle(self, value: float) -> None: ...
    @RearXAngle.setter
    def RearXAngle(self, value: float) -> None: ...
    @RearYAngle.setter
    def RearYAngle(self, value: float) -> None: ...
    @X1HalfWidth.setter
    def X1HalfWidth(self, value: float) -> None: ...
    @X2HalfWidth.setter
    def X2HalfWidth(self, value: float) -> None: ...
    @Y1HalfWidth.setter
    def Y1HalfWidth(self, value: float) -> None: ...
    @Y2HalfWidth.setter
    def Y2HalfWidth(self, value: float) -> None: ...
    @ZLength.setter
    def ZLength(self, value: float) -> None: ...

class IObjectRectangularPipeGrating(IObject):
    @property
    def DiffOrder(self) -> float: ...
    @property
    def DiffOrderCell(self) -> IEditorCell: ...
    @property
    def FrontXAngle(self) -> float: ...
    @property
    def FrontXAngleCell(self) -> IEditorCell: ...
    @property
    def FrontYAngle(self) -> float: ...
    @property
    def FrontYAngleCell(self) -> IEditorCell: ...
    @property
    def LinesPerUM(self) -> float: ...
    @property
    def LinesPerUMCell(self) -> IEditorCell: ...
    @property
    def RearXAngle(self) -> float: ...
    @property
    def RearXAngleCell(self) -> IEditorCell: ...
    @property
    def RearYAngle(self) -> float: ...
    @property
    def RearYAngleCell(self) -> IEditorCell: ...
    @property
    def X1HalfWidth(self) -> float: ...
    @property
    def X1HalfWidthCell(self) -> IEditorCell: ...
    @property
    def X2HalfWidth(self) -> float: ...
    @property
    def X2HalfWidthCell(self) -> IEditorCell: ...
    @property
    def Y1HalfWidth(self) -> float: ...
    @property
    def Y1HalfWidthCell(self) -> IEditorCell: ...
    @property
    def Y2HalfWidth(self) -> float: ...
    @property
    def Y2HalfWidthCell(self) -> IEditorCell: ...
    @property
    def ZLength(self) -> float: ...
    @property
    def ZLengthCell(self) -> IEditorCell: ...
    @DiffOrder.setter
    def DiffOrder(self, value: float) -> None: ...
    @FrontXAngle.setter
    def FrontXAngle(self, value: float) -> None: ...
    @FrontYAngle.setter
    def FrontYAngle(self, value: float) -> None: ...
    @LinesPerUM.setter
    def LinesPerUM(self, value: float) -> None: ...
    @RearXAngle.setter
    def RearXAngle(self, value: float) -> None: ...
    @RearYAngle.setter
    def RearYAngle(self, value: float) -> None: ...
    @X1HalfWidth.setter
    def X1HalfWidth(self, value: float) -> None: ...
    @X2HalfWidth.setter
    def X2HalfWidth(self, value: float) -> None: ...
    @Y1HalfWidth.setter
    def Y1HalfWidth(self, value: float) -> None: ...
    @Y2HalfWidth.setter
    def Y2HalfWidth(self, value: float) -> None: ...
    @ZLength.setter
    def ZLength(self, value: float) -> None: ...

class IObjectRectangularRoof(IObject):
    @property
    def Angle(self) -> float: ...
    @property
    def AngleCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidth(self) -> float: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @Angle.setter
    def Angle(self, value: float) -> None: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...

class IObjectRectangularTorusSurface(IObject):
    @property
    def InnerR(self) -> float: ...
    @property
    def InnerRCell(self) -> IEditorCell: ...
    @property
    def OuterR(self) -> float: ...
    @property
    def OuterRCell(self) -> IEditorCell: ...
    @property
    def StartAngle(self) -> float: ...
    @property
    def StartAngleCell(self) -> IEditorCell: ...
    @property
    def StopAngle(self) -> float: ...
    @property
    def StopAngleCell(self) -> IEditorCell: ...
    @property
    def Thickness(self) -> float: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @InnerR.setter
    def InnerR(self, value: float) -> None: ...
    @OuterR.setter
    def OuterR(self, value: float) -> None: ...
    @StartAngle.setter
    def StartAngle(self, value: float) -> None: ...
    @StopAngle.setter
    def StopAngle(self, value: float) -> None: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...

class IObjectRectangularTorusVolume(IObject):
    @property
    def InnerR(self) -> float: ...
    @property
    def InnerRCell(self) -> IEditorCell: ...
    @property
    def OuterR(self) -> float: ...
    @property
    def OuterRCell(self) -> IEditorCell: ...
    @property
    def StartAngle(self) -> float: ...
    @property
    def StartAngleCell(self) -> IEditorCell: ...
    @property
    def StopAngle(self) -> float: ...
    @property
    def StopAngleCell(self) -> IEditorCell: ...
    @property
    def Thickness(self) -> float: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @InnerR.setter
    def InnerR(self, value: float) -> None: ...
    @OuterR.setter
    def OuterR(self, value: float) -> None: ...
    @StartAngle.setter
    def StartAngle(self, value: float) -> None: ...
    @StopAngle.setter
    def StopAngle(self, value: float) -> None: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...

class IObjectRectangularVolume(IObject):
    @property
    def FrontXAngle(self) -> float: ...
    @property
    def FrontXAngleCell(self) -> IEditorCell: ...
    @property
    def FrontYAngle(self) -> float: ...
    @property
    def FrontYAngleCell(self) -> IEditorCell: ...
    @property
    def RearXAngle(self) -> float: ...
    @property
    def RearXAngleCell(self) -> IEditorCell: ...
    @property
    def RearYAngle(self) -> float: ...
    @property
    def RearYAngleCell(self) -> IEditorCell: ...
    @property
    def X1HalfWidth(self) -> float: ...
    @property
    def X1HalfWidthCell(self) -> IEditorCell: ...
    @property
    def X2HalfWidth(self) -> float: ...
    @property
    def X2HalfWidthCell(self) -> IEditorCell: ...
    @property
    def Y1HalfWidth(self) -> float: ...
    @property
    def Y1HalfWidthCell(self) -> IEditorCell: ...
    @property
    def Y2HalfWidth(self) -> float: ...
    @property
    def Y2HalfWidthCell(self) -> IEditorCell: ...
    @property
    def ZLength(self) -> float: ...
    @property
    def ZLengthCell(self) -> IEditorCell: ...
    @FrontXAngle.setter
    def FrontXAngle(self, value: float) -> None: ...
    @FrontYAngle.setter
    def FrontYAngle(self, value: float) -> None: ...
    @RearXAngle.setter
    def RearXAngle(self, value: float) -> None: ...
    @RearYAngle.setter
    def RearYAngle(self, value: float) -> None: ...
    @X1HalfWidth.setter
    def X1HalfWidth(self, value: float) -> None: ...
    @X2HalfWidth.setter
    def X2HalfWidth(self, value: float) -> None: ...
    @Y1HalfWidth.setter
    def Y1HalfWidth(self, value: float) -> None: ...
    @Y2HalfWidth.setter
    def Y2HalfWidth(self, value: float) -> None: ...
    @ZLength.setter
    def ZLength(self, value: float) -> None: ...

class IObjectRectangularVolumeGrating(IObject):
    @property
    def DiffOrder(self) -> float: ...
    @property
    def DiffOrderCell(self) -> IEditorCell: ...
    @property
    def FrontXAngle(self) -> float: ...
    @property
    def FrontXAngleCell(self) -> IEditorCell: ...
    @property
    def FrontYAngle(self) -> float: ...
    @property
    def FrontYAngleCell(self) -> IEditorCell: ...
    @property
    def LinesPerUM(self) -> float: ...
    @property
    def LinesPerUMCell(self) -> IEditorCell: ...
    @property
    def RearXAngle(self) -> float: ...
    @property
    def RearXAngleCell(self) -> IEditorCell: ...
    @property
    def RearYAngle(self) -> float: ...
    @property
    def RearYAngleCell(self) -> IEditorCell: ...
    @property
    def X1HalfWidth(self) -> float: ...
    @property
    def X1HalfWidthCell(self) -> IEditorCell: ...
    @property
    def X2HalfWidth(self) -> float: ...
    @property
    def X2HalfWidthCell(self) -> IEditorCell: ...
    @property
    def Y1HalfWidth(self) -> float: ...
    @property
    def Y1HalfWidthCell(self) -> IEditorCell: ...
    @property
    def Y2HalfWidth(self) -> float: ...
    @property
    def Y2HalfWidthCell(self) -> IEditorCell: ...
    @property
    def ZLength(self) -> float: ...
    @property
    def ZLengthCell(self) -> IEditorCell: ...
    @DiffOrder.setter
    def DiffOrder(self, value: float) -> None: ...
    @FrontXAngle.setter
    def FrontXAngle(self, value: float) -> None: ...
    @FrontYAngle.setter
    def FrontYAngle(self, value: float) -> None: ...
    @LinesPerUM.setter
    def LinesPerUM(self, value: float) -> None: ...
    @RearXAngle.setter
    def RearXAngle(self, value: float) -> None: ...
    @RearYAngle.setter
    def RearYAngle(self, value: float) -> None: ...
    @X1HalfWidth.setter
    def X1HalfWidth(self, value: float) -> None: ...
    @X2HalfWidth.setter
    def X2HalfWidth(self, value: float) -> None: ...
    @Y1HalfWidth.setter
    def Y1HalfWidth(self, value: float) -> None: ...
    @Y2HalfWidth.setter
    def Y2HalfWidth(self, value: float) -> None: ...
    @ZLength.setter
    def ZLength(self, value: float) -> None: ...

class IObjectReverseRadianceDetector(IObject):
    @property
    def BoundaryObject(self) -> int: ...
    @property
    def BoundaryObjectCell(self) -> IEditorCell: ...
    @property
    def NumberOfAPixels(self) -> int: ...
    @property
    def NumberOfAPixelsCell(self) -> IEditorCell: ...
    @property
    def NumberOfPPixels(self) -> int: ...
    @property
    def NumberOfPPixelsCell(self) -> IEditorCell: ...
    @property
    def NumberOfXPixels(self) -> int: ...
    @property
    def NumberOfXPixelsCell(self) -> IEditorCell: ...
    @property
    def NumberOfYPixels(self) -> int: ...
    @property
    def NumberOfYPixelsCell(self) -> IEditorCell: ...
    @property
    def ReverseRayColor(self) -> int: ...
    @property
    def ReverseRayColorCell(self) -> IEditorCell: ...
    @property
    def Shape(self) -> ShapeChoices: ...
    @property
    def ShapeCell(self) -> IEditorCell: ...
    @property
    def SourceObject(self) -> int: ...
    @property
    def SourceObjectCell(self) -> IEditorCell: ...
    @property
    def TargetObject(self) -> int: ...
    @property
    def TargetObjectCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidth(self) -> float: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @BoundaryObject.setter
    def BoundaryObject(self, value: int) -> None: ...
    @NumberOfAPixels.setter
    def NumberOfAPixels(self, value: int) -> None: ...
    @NumberOfPPixels.setter
    def NumberOfPPixels(self, value: int) -> None: ...
    @NumberOfXPixels.setter
    def NumberOfXPixels(self, value: int) -> None: ...
    @NumberOfYPixels.setter
    def NumberOfYPixels(self, value: int) -> None: ...
    @ReverseRayColor.setter
    def ReverseRayColor(self, value: int) -> None: ...
    @Shape.setter
    def Shape(self, value: ShapeChoices) -> None: ...
    @SourceObject.setter
    def SourceObject(self, value: int) -> None: ...
    @TargetObject.setter
    def TargetObject(self, value: int) -> None: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...

class IObjectReverseRadianceTarget(IObject):
    @property
    def NumberOfAPixels(self) -> int: ...
    @property
    def NumberOfAPixelsCell(self) -> IEditorCell: ...
    @property
    def NumberOfPPixels(self) -> int: ...
    @property
    def NumberOfPPixelsCell(self) -> IEditorCell: ...
    @property
    def NumberOfXPixels(self) -> int: ...
    @property
    def NumberOfXPixelsCell(self) -> IEditorCell: ...
    @property
    def NumberOfYPixels(self) -> int: ...
    @property
    def NumberOfYPixelsCell(self) -> IEditorCell: ...
    @property
    def Shape(self) -> ShapeChoices: ...
    @property
    def ShapeCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidth(self) -> float: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @NumberOfAPixels.setter
    def NumberOfAPixels(self, value: int) -> None: ...
    @NumberOfPPixels.setter
    def NumberOfPPixels(self, value: int) -> None: ...
    @NumberOfXPixels.setter
    def NumberOfXPixels(self, value: int) -> None: ...
    @NumberOfYPixels.setter
    def NumberOfYPixels(self, value: int) -> None: ...
    @Shape.setter
    def Shape(self, value: ShapeChoices) -> None: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...

class IObjectScatteringSettings:
    @property
    def _S_ABg(self) -> IOSS_ABg: ...
    @property
    def _S_ABgFile(self) -> IOSS_ABgFile: ...
    @property
    def _S_BSDF(self) -> IOSS_BSDF: ...
    @property
    def _S_Gaussian(self) -> IOSS_Gaussian: ...
    @property
    def _S_ISScatterCatalog(self) -> IOSS_ISScatterCatalog: ...
    @property
    def _S_Lambertian(self) -> IOSS_Lambertian: ...
    @property
    def _S_None(self) -> IOSS_None: ...
    @property
    def _S_User(self) -> IOSS_User: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def Type(self) -> ObjectScatteringTypes: ...

class IObjectSlide(IObject):
    @property
    def AspectRatio(self) -> float: ...
    @property
    def AspectRatioCell(self) -> IEditorCell: ...
    @property
    def XFullWidth(self) -> float: ...
    @property
    def XFullWidthCell(self) -> IEditorCell: ...
    @AspectRatio.setter
    def AspectRatio(self, value: float) -> None: ...
    @XFullWidth.setter
    def XFullWidth(self, value: float) -> None: ...

class IObjectSourceDiffractive(IObjectSources, IObject):
    @property
    def Sampling(self) -> SampleSizes: ...
    @property
    def SamplingCell(self) -> IEditorCell: ...
    @Sampling.setter
    def Sampling(self, value: SampleSizes) -> None: ...

class IObjectSourceDiode(IObjectSources, IObject):
    @property
    def Astigmatism(self) -> float: ...
    @property
    def AstigmatismCell(self) -> IEditorCell: ...
    @property
    def DeltaX(self) -> float: ...
    @property
    def DeltaXCell(self) -> IEditorCell: ...
    @property
    def DeltaY(self) -> float: ...
    @property
    def DeltaYCell(self) -> IEditorCell: ...
    @property
    def NumberX(self) -> int: ...
    @property
    def NumberXCell(self) -> IEditorCell: ...
    @property
    def NumberY(self) -> int: ...
    @property
    def NumberYCell(self) -> IEditorCell: ...
    @property
    def XMinusDivergence(self) -> float: ...
    @property
    def XMinusDivergenceCell(self) -> IEditorCell: ...
    @property
    def XMinusSigma(self) -> float: ...
    @property
    def XMinusSigmaCell(self) -> IEditorCell: ...
    @property
    def XMinusSuperGauss(self) -> float: ...
    @property
    def XMinusSuperGaussCell(self) -> IEditorCell: ...
    @property
    def XMinusWidth(self) -> float: ...
    @property
    def XMinusWidthCell(self) -> IEditorCell: ...
    @property
    def XMinusWidthHX(self) -> float: ...
    @property
    def XMinusWidthHXCell(self) -> IEditorCell: ...
    @property
    def YMinusDivergence(self) -> float: ...
    @property
    def YMinusDivergenceCell(self) -> IEditorCell: ...
    @property
    def YMinusSigma(self) -> float: ...
    @property
    def YMinusSigmaCell(self) -> IEditorCell: ...
    @property
    def YMinusSuperGauss(self) -> float: ...
    @property
    def YMinusSuperGaussCell(self) -> IEditorCell: ...
    @property
    def YMinusWidth(self) -> float: ...
    @property
    def YMinusWidthCell(self) -> IEditorCell: ...
    @property
    def YMinusWidthHY(self) -> float: ...
    @property
    def YMinusWidthHYCell(self) -> IEditorCell: ...
    @Astigmatism.setter
    def Astigmatism(self, value: float) -> None: ...
    @DeltaX.setter
    def DeltaX(self, value: float) -> None: ...
    @DeltaY.setter
    def DeltaY(self, value: float) -> None: ...
    @NumberX.setter
    def NumberX(self, value: int) -> None: ...
    @NumberY.setter
    def NumberY(self, value: int) -> None: ...
    @XMinusDivergence.setter
    def XMinusDivergence(self, value: float) -> None: ...
    @XMinusSigma.setter
    def XMinusSigma(self, value: float) -> None: ...
    @XMinusSuperGauss.setter
    def XMinusSuperGauss(self, value: float) -> None: ...
    @XMinusWidth.setter
    def XMinusWidth(self, value: float) -> None: ...
    @XMinusWidthHX.setter
    def XMinusWidthHX(self, value: float) -> None: ...
    @YMinusDivergence.setter
    def YMinusDivergence(self, value: float) -> None: ...
    @YMinusSigma.setter
    def YMinusSigma(self, value: float) -> None: ...
    @YMinusSuperGauss.setter
    def YMinusSuperGauss(self, value: float) -> None: ...
    @YMinusWidth.setter
    def YMinusWidth(self, value: float) -> None: ...
    @YMinusWidthHY.setter
    def YMinusWidthHY(self, value: float) -> None: ...

class IObjectSourceDLL(IObjectSources, IObject):
    pass

class IObjectSourceEllipse(IObjectSources, IObject):
    @property
    def CosineExponent(self) -> float: ...
    @property
    def CosineExponentCell(self) -> IEditorCell: ...
    @property
    def GaussGX(self) -> float: ...
    @property
    def GaussGXCell(self) -> IEditorCell: ...
    @property
    def GaussGY(self) -> float: ...
    @property
    def GaussGYCell(self) -> IEditorCell: ...
    @property
    def MinXHalfWidth(self) -> float: ...
    @property
    def MinXHalfWidthCell(self) -> IEditorCell: ...
    @property
    def MinYHalfWidth(self) -> float: ...
    @property
    def MinYHalfWidthCell(self) -> IEditorCell: ...
    @property
    def SourceDistance(self) -> float: ...
    @property
    def SourceDistanceCell(self) -> IEditorCell: ...
    @property
    def SourceX(self) -> float: ...
    @property
    def SourceXCell(self) -> IEditorCell: ...
    @property
    def SourceY(self) -> float: ...
    @property
    def SourceYCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidth(self) -> float: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @CosineExponent.setter
    def CosineExponent(self, value: float) -> None: ...
    @GaussGX.setter
    def GaussGX(self, value: float) -> None: ...
    @GaussGY.setter
    def GaussGY(self, value: float) -> None: ...
    @MinXHalfWidth.setter
    def MinXHalfWidth(self, value: float) -> None: ...
    @MinYHalfWidth.setter
    def MinYHalfWidth(self, value: float) -> None: ...
    @SourceDistance.setter
    def SourceDistance(self, value: float) -> None: ...
    @SourceX.setter
    def SourceX(self, value: float) -> None: ...
    @SourceY.setter
    def SourceY(self, value: float) -> None: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...

class IObjectSourceEULUMDATFile(IObjectSources, IObject):
    @property
    def LumensInFile(self) -> float: ...
    @property
    def LumensInFileCell(self) -> IEditorCell: ...
    @LumensInFile.setter
    def LumensInFile(self, value: float) -> None: ...

class IObjectSourceFilament(IObjectSources, IObject):
    @property
    def Length(self) -> float: ...
    @property
    def LengthCell(self) -> IEditorCell: ...
    @property
    def RadiusA(self) -> float: ...
    @property
    def RadiusACell(self) -> IEditorCell: ...
    @property
    def Turns(self) -> float: ...
    @property
    def TurnsCell(self) -> IEditorCell: ...
    @Length.setter
    def Length(self, value: float) -> None: ...
    @RadiusA.setter
    def RadiusA(self, value: float) -> None: ...
    @Turns.setter
    def Turns(self, value: float) -> None: ...

class IObjectSourceFile(IObjectSources, IObject):
    @property
    def MaxWave(self) -> float: ...
    @property
    def MinWave(self) -> float: ...
    @property
    def Randomize(self) -> bool: ...
    @property
    def RandomizeCell(self) -> IEditorCell: ...
    @property
    def SourceUnits(self) -> float: ...
    @Randomize.setter
    def Randomize(self, value: bool) -> None: ...

class IObjectSourceGaussian(IObjectSources, IObject):
    @property
    def BeamSize(self) -> float: ...
    @property
    def BeamSizeCell(self) -> IEditorCell: ...
    @property
    def Position(self) -> float: ...
    @property
    def PositionCell(self) -> IEditorCell: ...
    @BeamSize.setter
    def BeamSize(self, value: float) -> None: ...
    @Position.setter
    def Position(self, value: float) -> None: ...

class IObjectSourceIESNAFile(IObjectSources, IObject):
    @property
    def LumensInFile(self) -> float: ...
    @property
    def LumensInFileCell(self) -> IEditorCell: ...
    @LumensInFile.setter
    def LumensInFile(self, value: float) -> None: ...

class IObjectSourceImported(IObjectSources, IObject):
    @property
    def CosFactor(self) -> float: ...
    @property
    def CosFactorCell(self) -> IEditorCell: ...
    @property
    def Scale(self) -> float: ...
    @property
    def ScaleCell(self) -> IEditorCell: ...
    @CosFactor.setter
    def CosFactor(self, value: float) -> None: ...
    @Scale.setter
    def Scale(self, value: float) -> None: ...

class IObjectSourceObject(IObjectSources, IObject):
    @property
    def ChordTol(self) -> float: ...
    @property
    def ChordTolCell(self) -> IEditorCell: ...
    @property
    def CosFactor(self) -> float: ...
    @property
    def CosFactorCell(self) -> IEditorCell: ...
    @property
    def ParentObjectNumber(self) -> int: ...
    @property
    def ParentObjectNumberCell(self) -> IEditorCell: ...
    @ChordTol.setter
    def ChordTol(self, value: float) -> None: ...
    @CosFactor.setter
    def CosFactor(self, value: float) -> None: ...
    @ParentObjectNumber.setter
    def ParentObjectNumber(self, value: int) -> None: ...

class IObjectSourcePoint(IObjectSources, IObject):
    @property
    def ConeAngle(self) -> float: ...
    @property
    def ConeAngleCell(self) -> IEditorCell: ...
    @ConeAngle.setter
    def ConeAngle(self, value: float) -> None: ...

class IObjectSourceRadial(IObjectSources, IObject):
    @property
    def MaxAngle(self) -> float: ...
    @property
    def MaxAngleCell(self) -> IEditorCell: ...
    @property
    def MinAngle(self) -> float: ...
    @property
    def MinAngleCell(self) -> IEditorCell: ...
    @property
    def NumberOfPoints(self) -> int: ...
    @property
    def NumberOfPointsCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidth(self) -> float: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    def GetSubAngleI(self, i: int) -> float: ...
    @MaxAngle.setter
    def MaxAngle(self, value: float) -> None: ...
    @MinAngle.setter
    def MinAngle(self, value: float) -> None: ...
    @NumberOfPoints.setter
    def NumberOfPoints(self, value: int) -> None: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...
    def SetSubAngleI(self, i: int, v: float) -> None: ...
    def SubAngleICell(self, i: int) -> IEditorCell: ...

class IObjectSourceRay(IObjectSources, IObject):
    @property
    def RandomSeed(self) -> bool: ...
    @property
    def RandomSeedCell(self) -> IEditorCell: ...
    @property
    def XCosine(self) -> float: ...
    @property
    def XCosineCell(self) -> IEditorCell: ...
    @property
    def YCosine(self) -> float: ...
    @property
    def YCosineCell(self) -> IEditorCell: ...
    @property
    def ZCosine(self) -> float: ...
    @property
    def ZCosineCell(self) -> IEditorCell: ...
    @RandomSeed.setter
    def RandomSeed(self, value: bool) -> None: ...
    @XCosine.setter
    def XCosine(self, value: float) -> None: ...
    @YCosine.setter
    def YCosine(self, value: float) -> None: ...
    @ZCosine.setter
    def ZCosine(self, value: float) -> None: ...

class IObjectSourceRectangle(IObjectSources, IObject):
    @property
    def CosineExponent(self) -> float: ...
    @property
    def CosineExponentCell(self) -> IEditorCell: ...
    @property
    def GaussGX(self) -> float: ...
    @property
    def GaussGXCell(self) -> IEditorCell: ...
    @property
    def GaussGY(self) -> float: ...
    @property
    def GaussGYCell(self) -> IEditorCell: ...
    @property
    def SourceDistance(self) -> float: ...
    @property
    def SourceDistanceCell(self) -> IEditorCell: ...
    @property
    def SourceX(self) -> float: ...
    @property
    def SourceXCell(self) -> IEditorCell: ...
    @property
    def SourceY(self) -> float: ...
    @property
    def SourceYCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidth(self) -> float: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @CosineExponent.setter
    def CosineExponent(self, value: float) -> None: ...
    @GaussGX.setter
    def GaussGX(self, value: float) -> None: ...
    @GaussGY.setter
    def GaussGY(self, value: float) -> None: ...
    @SourceDistance.setter
    def SourceDistance(self, value: float) -> None: ...
    @SourceX.setter
    def SourceX(self, value: float) -> None: ...
    @SourceY.setter
    def SourceY(self, value: float) -> None: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...

class IObjectSources(IObject):
    @property
    def ColorNumber(self) -> int: ...
    @property
    def ColorNumberCell(self) -> IEditorCell: ...
    @property
    def NumberOfAnalysisRays(self) -> int: ...
    @property
    def NumberOfAnalysisRaysCell(self) -> IEditorCell: ...
    @property
    def NumberOfLayoutRays(self) -> int: ...
    @property
    def NumberOfLayoutRaysCell(self) -> IEditorCell: ...
    @property
    def Power(self) -> float: ...
    @property
    def PowerCell(self) -> IEditorCell: ...
    @property
    def WaveNumber(self) -> int: ...
    @property
    def WaveNumberCell(self) -> IEditorCell: ...
    @ColorNumber.setter
    def ColorNumber(self, value: int) -> None: ...
    @NumberOfAnalysisRays.setter
    def NumberOfAnalysisRays(self, value: int) -> None: ...
    @NumberOfLayoutRays.setter
    def NumberOfLayoutRays(self, value: int) -> None: ...
    @Power.setter
    def Power(self, value: float) -> None: ...
    @WaveNumber.setter
    def WaveNumber(self, value: int) -> None: ...

class IObjectSourceTube(IObjectSources, IObject):
    @property
    def Length(self) -> float: ...
    @property
    def LengthCell(self) -> IEditorCell: ...
    @property
    def RadiusA(self) -> float: ...
    @property
    def RadiusACell(self) -> IEditorCell: ...
    @Length.setter
    def Length(self, value: float) -> None: ...
    @RadiusA.setter
    def RadiusA(self, value: float) -> None: ...

class IObjectSourceTwoAngle(IObjectSources, IObject):
    @property
    def AngularShape(self) -> ShapeChoices: ...
    @property
    def AngularShapeCell(self) -> IEditorCell: ...
    @property
    def SpatialShape(self) -> ShapeChoices: ...
    @property
    def SpatialShapeCell(self) -> IEditorCell: ...
    @property
    def UniformAngle(self) -> UniformAngleChoices: ...
    @property
    def UniformAngleCell(self) -> IEditorCell: ...
    @property
    def XHalfAngleDegree(self) -> float: ...
    @property
    def XHalfAngleDegreeCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfAngleDegree(self) -> float: ...
    @property
    def YHalfAngleDegreeCell(self) -> IEditorCell: ...
    @property
    def YHalfWidth(self) -> float: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @AngularShape.setter
    def AngularShape(self, value: ShapeChoices) -> None: ...
    @SpatialShape.setter
    def SpatialShape(self, value: ShapeChoices) -> None: ...
    @UniformAngle.setter
    def UniformAngle(self, value: UniformAngleChoices) -> None: ...
    @XHalfAngleDegree.setter
    def XHalfAngleDegree(self, value: float) -> None: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @YHalfAngleDegree.setter
    def YHalfAngleDegree(self, value: float) -> None: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...

class IObjectSourceVolumeCylindrical(IObjectSources, IObject):
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidth(self) -> float: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @property
    def ZHalfWidth(self) -> float: ...
    @property
    def ZHalfWidthCell(self) -> IEditorCell: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...
    @ZHalfWidth.setter
    def ZHalfWidth(self, value: float) -> None: ...

class IObjectSourceVolumeElliptical(IObjectSources, IObject):
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidth(self) -> float: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @property
    def ZHalfWidth(self) -> float: ...
    @property
    def ZHalfWidthCell(self) -> IEditorCell: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...
    @ZHalfWidth.setter
    def ZHalfWidth(self, value: float) -> None: ...

class IObjectSourceVolumeRectangular(IObjectSources, IObject):
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidth(self) -> float: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @property
    def ZHalfWidth(self) -> float: ...
    @property
    def ZHalfWidthCell(self) -> IEditorCell: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...
    @ZHalfWidth.setter
    def ZHalfWidth(self, value: float) -> None: ...

class IObjectSphere(IObject):
    @property
    def IsVolume(self) -> bool: ...
    @property
    def IsVolumeCell(self) -> IEditorCell: ...
    @property
    def Radius(self) -> float: ...
    @property
    def RadiusCell(self) -> IEditorCell: ...
    @IsVolume.setter
    def IsVolume(self, value: bool) -> None: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...

class IObjectStandardLens(IObject):
    @property
    def Clear1(self) -> float: ...
    @property
    def Clear1Cell(self) -> IEditorCell: ...
    @property
    def Clear2(self) -> float: ...
    @property
    def Clear2Cell(self) -> IEditorCell: ...
    @property
    def Conic1(self) -> float: ...
    @property
    def Conic1Cell(self) -> IEditorCell: ...
    @property
    def Conic2(self) -> float: ...
    @property
    def Conic2Cell(self) -> IEditorCell: ...
    @property
    def Edge1(self) -> float: ...
    @property
    def Edge1Cell(self) -> IEditorCell: ...
    @property
    def Edge2(self) -> float: ...
    @property
    def Edge2Cell(self) -> IEditorCell: ...
    @property
    def Radius1(self) -> float: ...
    @property
    def Radius1Cell(self) -> IEditorCell: ...
    @property
    def Radius2(self) -> float: ...
    @property
    def Radius2Cell(self) -> IEditorCell: ...
    @property
    def Thickness(self) -> float: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @Clear1.setter
    def Clear1(self, value: float) -> None: ...
    @Clear2.setter
    def Clear2(self, value: float) -> None: ...
    @Conic1.setter
    def Conic1(self, value: float) -> None: ...
    @Conic2.setter
    def Conic2(self, value: float) -> None: ...
    @Edge1.setter
    def Edge1(self, value: float) -> None: ...
    @Edge2.setter
    def Edge2(self, value: float) -> None: ...
    @Radius1.setter
    def Radius1(self, value: float) -> None: ...
    @Radius2.setter
    def Radius2(self, value: float) -> None: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...

class IObjectStandardSurface(IObject):
    @property
    def Conic(self) -> float: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def MaxAperture(self) -> float: ...
    @property
    def MaxApertureCell(self) -> IEditorCell: ...
    @property
    def MinAperture(self) -> float: ...
    @property
    def MinApertureCell(self) -> IEditorCell: ...
    @property
    def Radius(self) -> float: ...
    @property
    def RadiusCell(self) -> IEditorCell: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @MaxAperture.setter
    def MaxAperture(self, value: float) -> None: ...
    @MinAperture.setter
    def MinAperture(self, value: float) -> None: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...

class IObjectSwept(IObject):
    @property
    def Angle(self) -> float: ...
    @property
    def AngleCell(self) -> IEditorCell: ...
    @property
    def AxisX(self) -> float: ...
    @property
    def AxisXCell(self) -> IEditorCell: ...
    @property
    def AxisY(self) -> float: ...
    @property
    def AxisYCell(self) -> IEditorCell: ...
    @property
    def AxisZ(self) -> float: ...
    @property
    def AxisZCell(self) -> IEditorCell: ...
    @property
    def CenterX(self) -> float: ...
    @property
    def CenterXCell(self) -> IEditorCell: ...
    @property
    def CenterY(self) -> float: ...
    @property
    def CenterYCell(self) -> IEditorCell: ...
    @property
    def CenterZ(self) -> float: ...
    @property
    def CenterZCell(self) -> IEditorCell: ...
    @property
    def EndCaps(self) -> EndCapOptions: ...
    @property
    def EndCapsCell(self) -> IEditorCell: ...
    @property
    def IsVolume(self) -> bool: ...
    @property
    def IsVolumeCell(self) -> IEditorCell: ...
    @property
    def ParentObjectNumber(self) -> int: ...
    @property
    def ParentObjectNumberCell(self) -> IEditorCell: ...
    @property
    def PlaneX(self) -> float: ...
    @property
    def PlaneXCell(self) -> IEditorCell: ...
    @property
    def PlaneY(self) -> float: ...
    @property
    def PlaneYCell(self) -> IEditorCell: ...
    @property
    def PlaneZ(self) -> float: ...
    @property
    def PlaneZCell(self) -> IEditorCell: ...
    @Angle.setter
    def Angle(self, value: float) -> None: ...
    @AxisX.setter
    def AxisX(self, value: float) -> None: ...
    @AxisY.setter
    def AxisY(self, value: float) -> None: ...
    @AxisZ.setter
    def AxisZ(self, value: float) -> None: ...
    @CenterX.setter
    def CenterX(self, value: float) -> None: ...
    @CenterY.setter
    def CenterY(self, value: float) -> None: ...
    @CenterZ.setter
    def CenterZ(self, value: float) -> None: ...
    @EndCaps.setter
    def EndCaps(self, value: EndCapOptions) -> None: ...
    @IsVolume.setter
    def IsVolume(self, value: bool) -> None: ...
    @ParentObjectNumber.setter
    def ParentObjectNumber(self, value: int) -> None: ...
    @PlaneX.setter
    def PlaneX(self, value: float) -> None: ...
    @PlaneY.setter
    def PlaneY(self, value: float) -> None: ...
    @PlaneZ.setter
    def PlaneZ(self, value: float) -> None: ...

class IObjectTabulatedFactedRadial(IObject):
    @property
    def IsVolume(self) -> bool: ...
    @property
    def IsVolumeCell(self) -> IEditorCell: ...
    @property
    def Scale(self) -> float: ...
    @property
    def ScaleCell(self) -> IEditorCell: ...
    @property
    def StartAngle(self) -> float: ...
    @property
    def StartAngleCell(self) -> IEditorCell: ...
    @property
    def StopAngle(self) -> float: ...
    @property
    def StopAngleCell(self) -> IEditorCell: ...
    def GetZoneIFacets(self, i: int) -> int: ...
    @IsVolume.setter
    def IsVolume(self, value: bool) -> None: ...
    @Scale.setter
    def Scale(self, value: float) -> None: ...
    @StartAngle.setter
    def StartAngle(self, value: float) -> None: ...
    @StopAngle.setter
    def StopAngle(self, value: float) -> None: ...
    def SetZoneIFacets(self, i: int, v: int) -> None: ...
    def ZoneIFacetsCell(self, i: int) -> IEditorCell: ...

class IObjectTabulatedFactedToroid(IObject):
    @property
    def Radius(self) -> float: ...
    @property
    def RadiusCell(self) -> IEditorCell: ...
    @property
    def Scale(self) -> float: ...
    @property
    def ScaleCell(self) -> IEditorCell: ...
    @property
    def StartAngle(self) -> float: ...
    @property
    def StartAngleCell(self) -> IEditorCell: ...
    @property
    def StopAngle(self) -> float: ...
    @property
    def StopAngleCell(self) -> IEditorCell: ...
    def GetZoneIFacets(self, i: int) -> int: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    @Scale.setter
    def Scale(self, value: float) -> None: ...
    @StartAngle.setter
    def StartAngle(self, value: float) -> None: ...
    @StopAngle.setter
    def StopAngle(self, value: float) -> None: ...
    def SetZoneIFacets(self, i: int, v: int) -> None: ...
    def ZoneIFacetsCell(self, i: int) -> IEditorCell: ...

class IObjectTabulatedFrenselRadial(IObject):
    @property
    def IsVolume(self) -> bool: ...
    @property
    def IsVolumeCell(self) -> IEditorCell: ...
    @property
    def Scale(self) -> float: ...
    @property
    def ScaleCell(self) -> IEditorCell: ...
    @IsVolume.setter
    def IsVolume(self, value: bool) -> None: ...
    @Scale.setter
    def Scale(self, value: float) -> None: ...

class IObjectToroidalHologram(IObject):
    @property
    def Coeff1YPower10(self) -> float: ...
    @property
    def Coeff1YPower10Cell(self) -> IEditorCell: ...
    @property
    def Coeff1YPower12(self) -> float: ...
    @property
    def Coeff1YPower12Cell(self) -> IEditorCell: ...
    @property
    def Coeff1YPower2(self) -> float: ...
    @property
    def Coeff1YPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff1YPower4(self) -> float: ...
    @property
    def Coeff1YPower4Cell(self) -> IEditorCell: ...
    @property
    def Coeff1YPower6(self) -> float: ...
    @property
    def Coeff1YPower6Cell(self) -> IEditorCell: ...
    @property
    def Coeff1YPower8(self) -> float: ...
    @property
    def Coeff1YPower8Cell(self) -> IEditorCell: ...
    @property
    def Coeff2YPower10(self) -> float: ...
    @property
    def Coeff2YPower10Cell(self) -> IEditorCell: ...
    @property
    def Coeff2YPower12(self) -> float: ...
    @property
    def Coeff2YPower12Cell(self) -> IEditorCell: ...
    @property
    def Coeff2YPower2(self) -> float: ...
    @property
    def Coeff2YPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff2YPower4(self) -> float: ...
    @property
    def Coeff2YPower4Cell(self) -> IEditorCell: ...
    @property
    def Coeff2YPower6(self) -> float: ...
    @property
    def Coeff2YPower6Cell(self) -> IEditorCell: ...
    @property
    def Coeff2YPower8(self) -> float: ...
    @property
    def Coeff2YPower8Cell(self) -> IEditorCell: ...
    @property
    def Conic1(self) -> float: ...
    @property
    def Conic1Cell(self) -> IEditorCell: ...
    @property
    def Conic2(self) -> float: ...
    @property
    def Conic2Cell(self) -> IEditorCell: ...
    @property
    def ConsiderFresnel(self) -> int: ...
    @property
    def ConsiderFresnelCell(self) -> IEditorCell: ...
    @property
    def dn(self) -> float: ...
    @property
    def dnCell(self) -> IEditorCell: ...
    @property
    def HologramThickness(self) -> float: ...
    @property
    def HologramThicknessCell(self) -> IEditorCell: ...
    @property
    def HologramType(self) -> int: ...
    @property
    def HoloTypeCell(self) -> IEditorCell: ...
    @property
    def IndexShift(self) -> float: ...
    @property
    def IndexShiftCell(self) -> IEditorCell: ...
    @property
    def IsVolumeHologram(self) -> int: ...
    @property
    def IsVolumeHologramCell(self) -> IEditorCell: ...
    @property
    def n(self) -> float: ...
    @property
    def n1(self) -> float: ...
    @property
    def n1Cell(self) -> IEditorCell: ...
    @property
    def n2(self) -> float: ...
    @property
    def n2Cell(self) -> IEditorCell: ...
    @property
    def nCell(self) -> IEditorCell: ...
    @property
    def Order(self) -> float: ...
    @property
    def OrderCell(self) -> IEditorCell: ...
    @property
    def RadialHeight(self) -> float: ...
    @property
    def RadialHeightCell(self) -> IEditorCell: ...
    @property
    def Radius1(self) -> float: ...
    @property
    def Radius1Cell(self) -> IEditorCell: ...
    @property
    def Radius2(self) -> float: ...
    @property
    def Radius2Cell(self) -> IEditorCell: ...
    @property
    def RotationR1(self) -> float: ...
    @property
    def RotationR1Cell(self) -> IEditorCell: ...
    @property
    def RotationR2(self) -> float: ...
    @property
    def RotationR2Cell(self) -> IEditorCell: ...
    @property
    def Shrinkage(self) -> float: ...
    @property
    def ShrinkageCell(self) -> IEditorCell: ...
    @property
    def Thickness(self) -> float: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def X1(self) -> float: ...
    @property
    def X1Cell(self) -> IEditorCell: ...
    @property
    def X2(self) -> float: ...
    @property
    def X2Cell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def Y1(self) -> float: ...
    @property
    def Y1Cell(self) -> IEditorCell: ...
    @property
    def Y2(self) -> float: ...
    @property
    def Y2Cell(self) -> IEditorCell: ...
    @property
    def Z1(self) -> float: ...
    @property
    def Z1Cell(self) -> IEditorCell: ...
    @property
    def Z2(self) -> float: ...
    @property
    def Z2Cell(self) -> IEditorCell: ...
    @Coeff1YPower10.setter
    def Coeff1YPower10(self, value: float) -> None: ...
    @Coeff1YPower12.setter
    def Coeff1YPower12(self, value: float) -> None: ...
    @Coeff1YPower2.setter
    def Coeff1YPower2(self, value: float) -> None: ...
    @Coeff1YPower4.setter
    def Coeff1YPower4(self, value: float) -> None: ...
    @Coeff1YPower6.setter
    def Coeff1YPower6(self, value: float) -> None: ...
    @Coeff1YPower8.setter
    def Coeff1YPower8(self, value: float) -> None: ...
    @Coeff2YPower10.setter
    def Coeff2YPower10(self, value: float) -> None: ...
    @Coeff2YPower12.setter
    def Coeff2YPower12(self, value: float) -> None: ...
    @Coeff2YPower2.setter
    def Coeff2YPower2(self, value: float) -> None: ...
    @Coeff2YPower4.setter
    def Coeff2YPower4(self, value: float) -> None: ...
    @Coeff2YPower6.setter
    def Coeff2YPower6(self, value: float) -> None: ...
    @Coeff2YPower8.setter
    def Coeff2YPower8(self, value: float) -> None: ...
    @Conic1.setter
    def Conic1(self, value: float) -> None: ...
    @Conic2.setter
    def Conic2(self, value: float) -> None: ...
    @ConsiderFresnel.setter
    def ConsiderFresnel(self, value: int) -> None: ...
    @dn.setter
    def dn(self, value: float) -> None: ...
    @HologramThickness.setter
    def HologramThickness(self, value: float) -> None: ...
    @HologramType.setter
    def HologramType(self, value: int) -> None: ...
    @IndexShift.setter
    def IndexShift(self, value: float) -> None: ...
    @IsVolumeHologram.setter
    def IsVolumeHologram(self, value: int) -> None: ...
    @n.setter
    def n(self, value: float) -> None: ...
    @n1.setter
    def n1(self, value: float) -> None: ...
    @n2.setter
    def n2(self, value: float) -> None: ...
    @Order.setter
    def Order(self, value: float) -> None: ...
    @RadialHeight.setter
    def RadialHeight(self, value: float) -> None: ...
    @Radius1.setter
    def Radius1(self, value: float) -> None: ...
    @Radius2.setter
    def Radius2(self, value: float) -> None: ...
    @RotationR1.setter
    def RotationR1(self, value: float) -> None: ...
    @RotationR2.setter
    def RotationR2(self, value: float) -> None: ...
    @Shrinkage.setter
    def Shrinkage(self, value: float) -> None: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @X1.setter
    def X1(self, value: float) -> None: ...
    @X2.setter
    def X2(self, value: float) -> None: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @Y1.setter
    def Y1(self, value: float) -> None: ...
    @Y2.setter
    def Y2(self, value: float) -> None: ...
    @Z1.setter
    def Z1(self, value: float) -> None: ...
    @Z2.setter
    def Z2(self, value: float) -> None: ...

class IObjectToroidalLens(IObject):
    @property
    def Coeff1YPower10(self) -> float: ...
    @property
    def Coeff1YPower10Cell(self) -> IEditorCell: ...
    @property
    def Coeff1YPower12(self) -> float: ...
    @property
    def Coeff1YPower12Cell(self) -> IEditorCell: ...
    @property
    def Coeff1YPower14(self) -> float: ...
    @property
    def Coeff1YPower14Cell(self) -> IEditorCell: ...
    @property
    def Coeff1YPower2(self) -> float: ...
    @property
    def Coeff1YPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff1YPower4(self) -> float: ...
    @property
    def Coeff1YPower4Cell(self) -> IEditorCell: ...
    @property
    def Coeff1YPower6(self) -> float: ...
    @property
    def Coeff1YPower6Cell(self) -> IEditorCell: ...
    @property
    def Coeff1YPower8(self) -> float: ...
    @property
    def Coeff1YPower8Cell(self) -> IEditorCell: ...
    @property
    def Coeff2YPower10(self) -> float: ...
    @property
    def Coeff2YPower10Cell(self) -> IEditorCell: ...
    @property
    def Coeff2YPower12(self) -> float: ...
    @property
    def Coeff2YPower12Cell(self) -> IEditorCell: ...
    @property
    def Coeff2YPower14(self) -> float: ...
    @property
    def Coeff2YPower14Cell(self) -> IEditorCell: ...
    @property
    def Coeff2YPower2(self) -> float: ...
    @property
    def Coeff2YPower2Cell(self) -> IEditorCell: ...
    @property
    def Coeff2YPower4(self) -> float: ...
    @property
    def Coeff2YPower4Cell(self) -> IEditorCell: ...
    @property
    def Coeff2YPower6(self) -> float: ...
    @property
    def Coeff2YPower6Cell(self) -> IEditorCell: ...
    @property
    def Coeff2YPower8(self) -> float: ...
    @property
    def Coeff2YPower8Cell(self) -> IEditorCell: ...
    @property
    def Conic1(self) -> float: ...
    @property
    def Conic1Cell(self) -> IEditorCell: ...
    @property
    def Conic2(self) -> float: ...
    @property
    def Conic2Cell(self) -> IEditorCell: ...
    @property
    def RadialHeight(self) -> float: ...
    @property
    def RadialHeightCell(self) -> IEditorCell: ...
    @property
    def Radius1(self) -> float: ...
    @property
    def Radius1Cell(self) -> IEditorCell: ...
    @property
    def Radius2(self) -> float: ...
    @property
    def Radius2Cell(self) -> IEditorCell: ...
    @property
    def RotationR1(self) -> float: ...
    @property
    def RotationR1Cell(self) -> IEditorCell: ...
    @property
    def RotationR2(self) -> float: ...
    @property
    def RotationR2Cell(self) -> IEditorCell: ...
    @property
    def Thickness(self) -> float: ...
    @property
    def ThicknessCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @Coeff1YPower10.setter
    def Coeff1YPower10(self, value: float) -> None: ...
    @Coeff1YPower12.setter
    def Coeff1YPower12(self, value: float) -> None: ...
    @Coeff1YPower14.setter
    def Coeff1YPower14(self, value: float) -> None: ...
    @Coeff1YPower2.setter
    def Coeff1YPower2(self, value: float) -> None: ...
    @Coeff1YPower4.setter
    def Coeff1YPower4(self, value: float) -> None: ...
    @Coeff1YPower6.setter
    def Coeff1YPower6(self, value: float) -> None: ...
    @Coeff1YPower8.setter
    def Coeff1YPower8(self, value: float) -> None: ...
    @Coeff2YPower10.setter
    def Coeff2YPower10(self, value: float) -> None: ...
    @Coeff2YPower12.setter
    def Coeff2YPower12(self, value: float) -> None: ...
    @Coeff2YPower14.setter
    def Coeff2YPower14(self, value: float) -> None: ...
    @Coeff2YPower2.setter
    def Coeff2YPower2(self, value: float) -> None: ...
    @Coeff2YPower4.setter
    def Coeff2YPower4(self, value: float) -> None: ...
    @Coeff2YPower6.setter
    def Coeff2YPower6(self, value: float) -> None: ...
    @Coeff2YPower8.setter
    def Coeff2YPower8(self, value: float) -> None: ...
    @Conic1.setter
    def Conic1(self, value: float) -> None: ...
    @Conic2.setter
    def Conic2(self, value: float) -> None: ...
    @RadialHeight.setter
    def RadialHeight(self, value: float) -> None: ...
    @Radius1.setter
    def Radius1(self, value: float) -> None: ...
    @Radius2.setter
    def Radius2(self, value: float) -> None: ...
    @RotationR1.setter
    def RotationR1(self, value: float) -> None: ...
    @RotationR2.setter
    def RotationR2(self, value: float) -> None: ...
    @Thickness.setter
    def Thickness(self, value: float) -> None: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...

class IObjectToroidalSurface(IObject):
    @property
    def CoeffYPower10(self) -> float: ...
    @property
    def CoeffYPower10Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower12(self) -> float: ...
    @property
    def CoeffYPower12Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower14(self) -> float: ...
    @property
    def CoeffYPower14Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower2(self) -> float: ...
    @property
    def CoeffYPower2Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower4(self) -> float: ...
    @property
    def CoeffYPower4Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower6(self) -> float: ...
    @property
    def CoeffYPower6Cell(self) -> IEditorCell: ...
    @property
    def CoeffYPower8(self) -> float: ...
    @property
    def CoeffYPower8Cell(self) -> IEditorCell: ...
    @property
    def Conic(self) -> float: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def Radius(self) -> float: ...
    @property
    def RadiusCell(self) -> IEditorCell: ...
    @property
    def RotationR(self) -> float: ...
    @property
    def RotationRCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidth(self) -> float: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @CoeffYPower10.setter
    def CoeffYPower10(self, value: float) -> None: ...
    @CoeffYPower12.setter
    def CoeffYPower12(self, value: float) -> None: ...
    @CoeffYPower14.setter
    def CoeffYPower14(self, value: float) -> None: ...
    @CoeffYPower2.setter
    def CoeffYPower2(self, value: float) -> None: ...
    @CoeffYPower4.setter
    def CoeffYPower4(self, value: float) -> None: ...
    @CoeffYPower6.setter
    def CoeffYPower6(self, value: float) -> None: ...
    @CoeffYPower8.setter
    def CoeffYPower8(self, value: float) -> None: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    @RotationR.setter
    def RotationR(self, value: float) -> None: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...

class IObjectToroidalSurfaceOddASphere(IObject):
    @property
    def CoeffOnYPower1(self) -> float: ...
    @property
    def CoeffOnYPower1Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnYPower2(self) -> float: ...
    @property
    def CoeffOnYPower2Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnYPower3(self) -> float: ...
    @property
    def CoeffOnYPower3Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnYPower4(self) -> float: ...
    @property
    def CoeffOnYPower4Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnYPower5(self) -> float: ...
    @property
    def CoeffOnYPower5Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnYPower6(self) -> float: ...
    @property
    def CoeffOnYPower6Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnYPower7(self) -> float: ...
    @property
    def CoeffOnYPower7Cell(self) -> IEditorCell: ...
    @property
    def CoeffOnYPower8(self) -> float: ...
    @property
    def CoeffOnYPower8Cell(self) -> IEditorCell: ...
    @property
    def Conic(self) -> float: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def Radius(self) -> float: ...
    @property
    def RadiusCell(self) -> IEditorCell: ...
    @property
    def RotationR(self) -> float: ...
    @property
    def RotationRCell(self) -> IEditorCell: ...
    @property
    def XHalfWidth(self) -> float: ...
    @property
    def XHalfWidthCell(self) -> IEditorCell: ...
    @property
    def YHalfWidth(self) -> float: ...
    @property
    def YHalfWidthCell(self) -> IEditorCell: ...
    @CoeffOnYPower1.setter
    def CoeffOnYPower1(self, value: float) -> None: ...
    @CoeffOnYPower2.setter
    def CoeffOnYPower2(self, value: float) -> None: ...
    @CoeffOnYPower3.setter
    def CoeffOnYPower3(self, value: float) -> None: ...
    @CoeffOnYPower4.setter
    def CoeffOnYPower4(self, value: float) -> None: ...
    @CoeffOnYPower5.setter
    def CoeffOnYPower5(self, value: float) -> None: ...
    @CoeffOnYPower6.setter
    def CoeffOnYPower6(self, value: float) -> None: ...
    @CoeffOnYPower7.setter
    def CoeffOnYPower7(self, value: float) -> None: ...
    @CoeffOnYPower8.setter
    def CoeffOnYPower8(self, value: float) -> None: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    @RotationR.setter
    def RotationR(self, value: float) -> None: ...
    @XHalfWidth.setter
    def XHalfWidth(self, value: float) -> None: ...
    @YHalfWidth.setter
    def YHalfWidth(self, value: float) -> None: ...

class IObjectTorusSurface(IObject):
    @property
    def RadiusR(self) -> float: ...
    @property
    def RadiusRCell(self) -> IEditorCell: ...
    @property
    def RotationR(self) -> float: ...
    @property
    def RotationRCell(self) -> IEditorCell: ...
    @property
    def StartAngle(self) -> float: ...
    @property
    def StartAngleCell(self) -> IEditorCell: ...
    @property
    def StopAngle(self) -> float: ...
    @property
    def StopAngleCell(self) -> IEditorCell: ...
    @RadiusR.setter
    def RadiusR(self, value: float) -> None: ...
    @RotationR.setter
    def RotationR(self, value: float) -> None: ...
    @StartAngle.setter
    def StartAngle(self, value: float) -> None: ...
    @StopAngle.setter
    def StopAngle(self, value: float) -> None: ...

class IObjectTorusVolume(IObject):
    @property
    def RadiusR(self) -> float: ...
    @property
    def RadiusRCell(self) -> IEditorCell: ...
    @property
    def RotationR(self) -> float: ...
    @property
    def RotationRCell(self) -> IEditorCell: ...
    @property
    def StartAngle(self) -> float: ...
    @property
    def StartAngleCell(self) -> IEditorCell: ...
    @property
    def StopAngle(self) -> float: ...
    @property
    def StopAngleCell(self) -> IEditorCell: ...
    @RadiusR.setter
    def RadiusR(self, value: float) -> None: ...
    @RotationR.setter
    def RotationR(self, value: float) -> None: ...
    @StartAngle.setter
    def StartAngle(self, value: float) -> None: ...
    @StopAngle.setter
    def StopAngle(self, value: float) -> None: ...

class IObjectTriangle(IObject):
    @property
    def X1(self) -> float: ...
    @property
    def X1Cell(self) -> IEditorCell: ...
    @property
    def X2(self) -> float: ...
    @property
    def X2Cell(self) -> IEditorCell: ...
    @property
    def X3(self) -> float: ...
    @property
    def X3Cell(self) -> IEditorCell: ...
    @property
    def Y1(self) -> float: ...
    @property
    def Y1Cell(self) -> IEditorCell: ...
    @property
    def Y2(self) -> float: ...
    @property
    def Y2Cell(self) -> IEditorCell: ...
    @property
    def Y3(self) -> float: ...
    @property
    def Y3Cell(self) -> IEditorCell: ...
    @X1.setter
    def X1(self, value: float) -> None: ...
    @X2.setter
    def X2(self, value: float) -> None: ...
    @X3.setter
    def X3(self, value: float) -> None: ...
    @Y1.setter
    def Y1(self, value: float) -> None: ...
    @Y2.setter
    def Y2(self, value: float) -> None: ...
    @Y3.setter
    def Y3(self, value: float) -> None: ...

class IObjectTriangularCorner(IObject):
    @property
    def Width(self) -> float: ...
    @property
    def WidthCell(self) -> IEditorCell: ...
    @Width.setter
    def Width(self, value: float) -> None: ...

class IObjectTypeSettings:
    @property
    def FileName1(self) -> str: ...
    @property
    def FileName2(self) -> str: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def RequiresFile1(self) -> bool: ...
    @property
    def RequiresFile2(self) -> bool: ...
    @property
    def Type(self) -> ObjectType: ...
    def GetFileNames1(self) -> list[str]: ...
    def GetFileNames2(self) -> list[str]: ...
    @FileName1.setter
    def FileName1(self, value: str) -> None: ...
    @FileName2.setter
    def FileName2(self, value: str) -> None: ...

class IObjectUserDefinedObject(IObject):
    pass

class IObjectWolterSurface(IObject):
    @property
    def Angle(self) -> float: ...
    @property
    def AngleCell(self) -> IEditorCell: ...
    @property
    def CoeffZPower2(self) -> float: ...
    @property
    def CoeffZPower2Cell(self) -> IEditorCell: ...
    @property
    def CoeffZPower3(self) -> float: ...
    @property
    def CoeffZPower3Cell(self) -> IEditorCell: ...
    @property
    def CoeffZPower4(self) -> float: ...
    @property
    def CoeffZPower4Cell(self) -> IEditorCell: ...
    @property
    def CoeffZPower5(self) -> float: ...
    @property
    def CoeffZPower5Cell(self) -> IEditorCell: ...
    @property
    def R0(self) -> float: ...
    @property
    def R0Cell(self) -> IEditorCell: ...
    @property
    def ZLength(self) -> float: ...
    @property
    def ZLengthCell(self) -> IEditorCell: ...
    @Angle.setter
    def Angle(self, value: float) -> None: ...
    @CoeffZPower2.setter
    def CoeffZPower2(self, value: float) -> None: ...
    @CoeffZPower3.setter
    def CoeffZPower3(self, value: float) -> None: ...
    @CoeffZPower4.setter
    def CoeffZPower4(self, value: float) -> None: ...
    @CoeffZPower5.setter
    def CoeffZPower5(self, value: float) -> None: ...
    @R0.setter
    def R0(self, value: float) -> None: ...
    @ZLength.setter
    def ZLength(self, value: float) -> None: ...

class IObjectXYPolynomial(IObject):
    @property
    def X0Y1(self) -> float: ...
    @property
    def X0Y10(self) -> float: ...
    @property
    def X0Y10Cell(self) -> IEditorCell: ...
    @property
    def X0Y11(self) -> float: ...
    @property
    def X0Y11Cell(self) -> IEditorCell: ...
    @property
    def X0Y12(self) -> float: ...
    @property
    def X0Y12Cell(self) -> IEditorCell: ...
    @property
    def X0Y13(self) -> float: ...
    @property
    def X0Y13Cell(self) -> IEditorCell: ...
    @property
    def X0Y14(self) -> float: ...
    @property
    def X0Y14Cell(self) -> IEditorCell: ...
    @property
    def X0Y15(self) -> float: ...
    @property
    def X0Y15Cell(self) -> IEditorCell: ...
    @property
    def X0Y16(self) -> float: ...
    @property
    def X0Y16Cell(self) -> IEditorCell: ...
    @property
    def X0Y17(self) -> float: ...
    @property
    def X0Y17Cell(self) -> IEditorCell: ...
    @property
    def X0Y18(self) -> float: ...
    @property
    def X0Y18Cell(self) -> IEditorCell: ...
    @property
    def X0Y19(self) -> float: ...
    @property
    def X0Y19Cell(self) -> IEditorCell: ...
    @property
    def X0Y1Cell(self) -> IEditorCell: ...
    @property
    def X0Y2(self) -> float: ...
    @property
    def X0Y20(self) -> float: ...
    @property
    def X0Y20Cell(self) -> IEditorCell: ...
    @property
    def X0Y2Cell(self) -> IEditorCell: ...
    @property
    def X0Y3(self) -> float: ...
    @property
    def X0Y3Cell(self) -> IEditorCell: ...
    @property
    def X0Y4(self) -> float: ...
    @property
    def X0Y4Cell(self) -> IEditorCell: ...
    @property
    def X0Y5(self) -> float: ...
    @property
    def X0Y5Cell(self) -> IEditorCell: ...
    @property
    def X0Y6(self) -> float: ...
    @property
    def X0Y6Cell(self) -> IEditorCell: ...
    @property
    def X0Y7(self) -> float: ...
    @property
    def X0Y7Cell(self) -> IEditorCell: ...
    @property
    def X0Y8(self) -> float: ...
    @property
    def X0Y8Cell(self) -> IEditorCell: ...
    @property
    def X0Y9(self) -> float: ...
    @property
    def X0Y9Cell(self) -> IEditorCell: ...
    @property
    def X10Y0(self) -> float: ...
    @property
    def X10Y0Cell(self) -> IEditorCell: ...
    @property
    def X10Y1(self) -> float: ...
    @property
    def X10Y10(self) -> float: ...
    @property
    def X10Y10Cell(self) -> IEditorCell: ...
    @property
    def X10Y11(self) -> float: ...
    @property
    def X10Y11Cell(self) -> IEditorCell: ...
    @property
    def X10Y1Cell(self) -> IEditorCell: ...
    @property
    def X10Y2(self) -> float: ...
    @property
    def X10Y2Cell(self) -> IEditorCell: ...
    @property
    def X10Y3(self) -> float: ...
    @property
    def X10Y3Cell(self) -> IEditorCell: ...
    @property
    def X10Y4(self) -> float: ...
    @property
    def X10Y4Cell(self) -> IEditorCell: ...
    @property
    def X10Y5(self) -> float: ...
    @property
    def X10Y5Cell(self) -> IEditorCell: ...
    @property
    def X10Y6(self) -> float: ...
    @property
    def X10Y6Cell(self) -> IEditorCell: ...
    @property
    def X10Y7(self) -> float: ...
    @property
    def X10Y7Cell(self) -> IEditorCell: ...
    @property
    def X10Y8(self) -> float: ...
    @property
    def X10Y8Cell(self) -> IEditorCell: ...
    @property
    def X10Y9(self) -> float: ...
    @property
    def X10Y9Cell(self) -> IEditorCell: ...
    @property
    def X11Y0(self) -> float: ...
    @property
    def X11Y0Cell(self) -> IEditorCell: ...
    @property
    def X11Y1(self) -> float: ...
    @property
    def X11Y10(self) -> float: ...
    @property
    def X11Y10Cell(self) -> IEditorCell: ...
    @property
    def X11Y1Cell(self) -> IEditorCell: ...
    @property
    def X11Y2(self) -> float: ...
    @property
    def X11Y2Cell(self) -> IEditorCell: ...
    @property
    def X11Y3(self) -> float: ...
    @property
    def X11Y3Cell(self) -> IEditorCell: ...
    @property
    def X11Y4(self) -> float: ...
    @property
    def X11Y4Cell(self) -> IEditorCell: ...
    @property
    def X11Y5(self) -> float: ...
    @property
    def X11Y5Cell(self) -> IEditorCell: ...
    @property
    def X11Y6(self) -> float: ...
    @property
    def X11Y6Cell(self) -> IEditorCell: ...
    @property
    def X11Y7(self) -> float: ...
    @property
    def X11Y7Cell(self) -> IEditorCell: ...
    @property
    def X11Y8(self) -> float: ...
    @property
    def X11Y8Cell(self) -> IEditorCell: ...
    @property
    def X11Y9(self) -> float: ...
    @property
    def X11Y9Cell(self) -> IEditorCell: ...
    @property
    def X12Y0(self) -> float: ...
    @property
    def X12Y0Cell(self) -> IEditorCell: ...
    @property
    def X12Y1(self) -> float: ...
    @property
    def X12Y1Cell(self) -> IEditorCell: ...
    @property
    def X12Y2(self) -> float: ...
    @property
    def X12Y2Cell(self) -> IEditorCell: ...
    @property
    def X12Y3(self) -> float: ...
    @property
    def X12Y3Cell(self) -> IEditorCell: ...
    @property
    def X12Y4(self) -> float: ...
    @property
    def X12Y4Cell(self) -> IEditorCell: ...
    @property
    def X12Y5(self) -> float: ...
    @property
    def X12Y5Cell(self) -> IEditorCell: ...
    @property
    def X12Y6(self) -> float: ...
    @property
    def X12Y6Cell(self) -> IEditorCell: ...
    @property
    def X12Y7(self) -> float: ...
    @property
    def X12Y7Cell(self) -> IEditorCell: ...
    @property
    def X12Y8(self) -> float: ...
    @property
    def X12Y8Cell(self) -> IEditorCell: ...
    @property
    def X12Y9(self) -> float: ...
    @property
    def X12Y9Cell(self) -> IEditorCell: ...
    @property
    def X13Y0(self) -> float: ...
    @property
    def X13Y0Cell(self) -> IEditorCell: ...
    @property
    def X13Y1(self) -> float: ...
    @property
    def X13Y1Cell(self) -> IEditorCell: ...
    @property
    def X13Y2(self) -> float: ...
    @property
    def X13Y2Cell(self) -> IEditorCell: ...
    @property
    def X13Y3(self) -> float: ...
    @property
    def X13Y3Cell(self) -> IEditorCell: ...
    @property
    def X13Y4(self) -> float: ...
    @property
    def X13Y4Cell(self) -> IEditorCell: ...
    @property
    def X13Y5(self) -> float: ...
    @property
    def X13Y5Cell(self) -> IEditorCell: ...
    @property
    def X13Y6(self) -> float: ...
    @property
    def X13Y6Cell(self) -> IEditorCell: ...
    @property
    def X13Y7(self) -> float: ...
    @property
    def X13Y7Cell(self) -> IEditorCell: ...
    @property
    def X13Y8(self) -> float: ...
    @property
    def X13Y8Cell(self) -> IEditorCell: ...
    @property
    def X14Y0(self) -> float: ...
    @property
    def X14Y0Cell(self) -> IEditorCell: ...
    @property
    def X14Y1(self) -> float: ...
    @property
    def X14Y1Cell(self) -> IEditorCell: ...
    @property
    def X14Y2(self) -> float: ...
    @property
    def X14Y2Cell(self) -> IEditorCell: ...
    @property
    def X14Y3(self) -> float: ...
    @property
    def X14Y3Cell(self) -> IEditorCell: ...
    @property
    def X14Y4(self) -> float: ...
    @property
    def X14Y4Cell(self) -> IEditorCell: ...
    @property
    def X14Y5(self) -> float: ...
    @property
    def X14Y5Cell(self) -> IEditorCell: ...
    @property
    def X14Y6(self) -> float: ...
    @property
    def X14Y6Cell(self) -> IEditorCell: ...
    @property
    def X14Y7(self) -> float: ...
    @property
    def X14Y7Cell(self) -> IEditorCell: ...
    @property
    def X15Y0(self) -> float: ...
    @property
    def X15Y0Cell(self) -> IEditorCell: ...
    @property
    def X15Y1(self) -> float: ...
    @property
    def X15Y1Cell(self) -> IEditorCell: ...
    @property
    def X15Y2(self) -> float: ...
    @property
    def X15Y2Cell(self) -> IEditorCell: ...
    @property
    def X15Y3(self) -> float: ...
    @property
    def X15Y3Cell(self) -> IEditorCell: ...
    @property
    def X15Y4(self) -> float: ...
    @property
    def X15Y4Cell(self) -> IEditorCell: ...
    @property
    def X15Y5(self) -> float: ...
    @property
    def X15Y5Cell(self) -> IEditorCell: ...
    @property
    def X15Y6(self) -> float: ...
    @property
    def X15Y6Cell(self) -> IEditorCell: ...
    @property
    def X16Y0(self) -> float: ...
    @property
    def X16Y0Cell(self) -> IEditorCell: ...
    @property
    def X16Y1(self) -> float: ...
    @property
    def X16Y1Cell(self) -> IEditorCell: ...
    @property
    def X16Y2(self) -> float: ...
    @property
    def X16Y2Cell(self) -> IEditorCell: ...
    @property
    def X16Y3(self) -> float: ...
    @property
    def X16Y3Cell(self) -> IEditorCell: ...
    @property
    def X16Y4(self) -> float: ...
    @property
    def X16Y4Cell(self) -> IEditorCell: ...
    @property
    def X16Y5(self) -> float: ...
    @property
    def X16Y5Cell(self) -> IEditorCell: ...
    @property
    def X17Y0(self) -> float: ...
    @property
    def X17Y0Cell(self) -> IEditorCell: ...
    @property
    def X17Y1(self) -> float: ...
    @property
    def X17Y1Cell(self) -> IEditorCell: ...
    @property
    def X17Y2(self) -> float: ...
    @property
    def X17Y2Cell(self) -> IEditorCell: ...
    @property
    def X17Y3(self) -> float: ...
    @property
    def X17Y3Cell(self) -> IEditorCell: ...
    @property
    def X17Y4(self) -> float: ...
    @property
    def X17Y4Cell(self) -> IEditorCell: ...
    @property
    def X18Y0(self) -> float: ...
    @property
    def X18Y0Cell(self) -> IEditorCell: ...
    @property
    def X18Y1(self) -> float: ...
    @property
    def X18Y1Cell(self) -> IEditorCell: ...
    @property
    def X18Y2(self) -> float: ...
    @property
    def X18Y2Cell(self) -> IEditorCell: ...
    @property
    def X18Y3(self) -> float: ...
    @property
    def X18Y3Cell(self) -> IEditorCell: ...
    @property
    def X19Y0(self) -> float: ...
    @property
    def X19Y0Cell(self) -> IEditorCell: ...
    @property
    def X19Y1(self) -> float: ...
    @property
    def X19Y1Cell(self) -> IEditorCell: ...
    @property
    def X19Y2(self) -> float: ...
    @property
    def X19Y2Cell(self) -> IEditorCell: ...
    @property
    def X1Y0(self) -> float: ...
    @property
    def X1Y0Cell(self) -> IEditorCell: ...
    @property
    def X1Y1(self) -> float: ...
    @property
    def X1Y10(self) -> float: ...
    @property
    def X1Y10Cell(self) -> IEditorCell: ...
    @property
    def X1Y11(self) -> float: ...
    @property
    def X1Y11Cell(self) -> IEditorCell: ...
    @property
    def X1Y12(self) -> float: ...
    @property
    def X1Y12Cell(self) -> IEditorCell: ...
    @property
    def X1Y13(self) -> float: ...
    @property
    def X1Y13Cell(self) -> IEditorCell: ...
    @property
    def X1Y14(self) -> float: ...
    @property
    def X1Y14Cell(self) -> IEditorCell: ...
    @property
    def X1Y15(self) -> float: ...
    @property
    def X1Y15Cell(self) -> IEditorCell: ...
    @property
    def X1Y16(self) -> float: ...
    @property
    def X1Y16Cell(self) -> IEditorCell: ...
    @property
    def X1Y17(self) -> float: ...
    @property
    def X1Y17Cell(self) -> IEditorCell: ...
    @property
    def X1Y18(self) -> float: ...
    @property
    def X1Y18Cell(self) -> IEditorCell: ...
    @property
    def X1Y19(self) -> float: ...
    @property
    def X1Y19Cell(self) -> IEditorCell: ...
    @property
    def X1Y1Cell(self) -> IEditorCell: ...
    @property
    def X1Y2(self) -> float: ...
    @property
    def X1Y2Cell(self) -> IEditorCell: ...
    @property
    def X1Y3(self) -> float: ...
    @property
    def X1Y3Cell(self) -> IEditorCell: ...
    @property
    def X1Y4(self) -> float: ...
    @property
    def X1Y4Cell(self) -> IEditorCell: ...
    @property
    def X1Y5(self) -> float: ...
    @property
    def X1Y5Cell(self) -> IEditorCell: ...
    @property
    def X1Y6(self) -> float: ...
    @property
    def X1Y6Cell(self) -> IEditorCell: ...
    @property
    def X1Y7(self) -> float: ...
    @property
    def X1Y7Cell(self) -> IEditorCell: ...
    @property
    def X1Y8(self) -> float: ...
    @property
    def X1Y8Cell(self) -> IEditorCell: ...
    @property
    def X1Y9(self) -> float: ...
    @property
    def X1Y9Cell(self) -> IEditorCell: ...
    @property
    def X20Y0(self) -> float: ...
    @property
    def X20Y0Cell(self) -> IEditorCell: ...
    @property
    def X20Y1(self) -> float: ...
    @property
    def X20Y1Cell(self) -> IEditorCell: ...
    @property
    def X21Y0(self) -> float: ...
    @property
    def X21Y0Cell(self) -> IEditorCell: ...
    @property
    def X2Y0(self) -> float: ...
    @property
    def X2Y0Cell(self) -> IEditorCell: ...
    @property
    def X2Y1(self) -> float: ...
    @property
    def X2Y10(self) -> float: ...
    @property
    def X2Y10Cell(self) -> IEditorCell: ...
    @property
    def X2Y11(self) -> float: ...
    @property
    def X2Y11Cell(self) -> IEditorCell: ...
    @property
    def X2Y12(self) -> float: ...
    @property
    def X2Y12Cell(self) -> IEditorCell: ...
    @property
    def X2Y13(self) -> float: ...
    @property
    def X2Y13Cell(self) -> IEditorCell: ...
    @property
    def X2Y14(self) -> float: ...
    @property
    def X2Y14Cell(self) -> IEditorCell: ...
    @property
    def X2Y15(self) -> float: ...
    @property
    def X2Y15Cell(self) -> IEditorCell: ...
    @property
    def X2Y16(self) -> float: ...
    @property
    def X2Y16Cell(self) -> IEditorCell: ...
    @property
    def X2Y17(self) -> float: ...
    @property
    def X2Y17Cell(self) -> IEditorCell: ...
    @property
    def X2Y18(self) -> float: ...
    @property
    def X2Y18Cell(self) -> IEditorCell: ...
    @property
    def X2Y19(self) -> float: ...
    @property
    def X2Y19Cell(self) -> IEditorCell: ...
    @property
    def X2Y1Cell(self) -> IEditorCell: ...
    @property
    def X2Y2(self) -> float: ...
    @property
    def X2Y2Cell(self) -> IEditorCell: ...
    @property
    def X2Y3(self) -> float: ...
    @property
    def X2Y3Cell(self) -> IEditorCell: ...
    @property
    def X2Y4(self) -> float: ...
    @property
    def X2Y4Cell(self) -> IEditorCell: ...
    @property
    def X2Y5(self) -> float: ...
    @property
    def X2Y5Cell(self) -> IEditorCell: ...
    @property
    def X2Y6(self) -> float: ...
    @property
    def X2Y6Cell(self) -> IEditorCell: ...
    @property
    def X2Y7(self) -> float: ...
    @property
    def X2Y7Cell(self) -> IEditorCell: ...
    @property
    def X2Y8(self) -> float: ...
    @property
    def X2Y8Cell(self) -> IEditorCell: ...
    @property
    def X2Y9(self) -> float: ...
    @property
    def X2Y9Cell(self) -> IEditorCell: ...
    @property
    def X3Y0(self) -> float: ...
    @property
    def X3Y0Cell(self) -> IEditorCell: ...
    @property
    def X3Y1(self) -> float: ...
    @property
    def X3Y10(self) -> float: ...
    @property
    def X3Y10Cell(self) -> IEditorCell: ...
    @property
    def X3Y11(self) -> float: ...
    @property
    def X3Y11Cell(self) -> IEditorCell: ...
    @property
    def X3Y12(self) -> float: ...
    @property
    def X3Y12Cell(self) -> IEditorCell: ...
    @property
    def X3Y13(self) -> float: ...
    @property
    def X3Y13Cell(self) -> IEditorCell: ...
    @property
    def X3Y14(self) -> float: ...
    @property
    def X3Y14Cell(self) -> IEditorCell: ...
    @property
    def X3Y15(self) -> float: ...
    @property
    def X3Y15Cell(self) -> IEditorCell: ...
    @property
    def X3Y16(self) -> float: ...
    @property
    def X3Y16Cell(self) -> IEditorCell: ...
    @property
    def X3Y17(self) -> float: ...
    @property
    def X3Y17Cell(self) -> IEditorCell: ...
    @property
    def X3Y18(self) -> float: ...
    @property
    def X3Y18Cell(self) -> IEditorCell: ...
    @property
    def X3Y1Cell(self) -> IEditorCell: ...
    @property
    def X3Y2(self) -> float: ...
    @property
    def X3Y2Cell(self) -> IEditorCell: ...
    @property
    def X3Y3(self) -> float: ...
    @property
    def X3Y3Cell(self) -> IEditorCell: ...
    @property
    def X3Y4(self) -> float: ...
    @property
    def X3Y4Cell(self) -> IEditorCell: ...
    @property
    def X3Y5(self) -> float: ...
    @property
    def X3Y5Cell(self) -> IEditorCell: ...
    @property
    def X3Y6(self) -> float: ...
    @property
    def X3Y6Cell(self) -> IEditorCell: ...
    @property
    def X3Y7(self) -> float: ...
    @property
    def X3Y7Cell(self) -> IEditorCell: ...
    @property
    def X3Y8(self) -> float: ...
    @property
    def X3Y8Cell(self) -> IEditorCell: ...
    @property
    def X3Y9(self) -> float: ...
    @property
    def X3Y9Cell(self) -> IEditorCell: ...
    @property
    def X4Y0(self) -> float: ...
    @property
    def X4Y0Cell(self) -> IEditorCell: ...
    @property
    def X4Y1(self) -> float: ...
    @property
    def X4Y10(self) -> float: ...
    @property
    def X4Y10Cell(self) -> IEditorCell: ...
    @property
    def X4Y11(self) -> float: ...
    @property
    def X4Y11Cell(self) -> IEditorCell: ...
    @property
    def X4Y12(self) -> float: ...
    @property
    def X4Y12Cell(self) -> IEditorCell: ...
    @property
    def X4Y13(self) -> float: ...
    @property
    def X4Y13Cell(self) -> IEditorCell: ...
    @property
    def X4Y14(self) -> float: ...
    @property
    def X4Y14Cell(self) -> IEditorCell: ...
    @property
    def X4Y15(self) -> float: ...
    @property
    def X4Y15Cell(self) -> IEditorCell: ...
    @property
    def X4Y16(self) -> float: ...
    @property
    def X4Y16Cell(self) -> IEditorCell: ...
    @property
    def X4Y17(self) -> float: ...
    @property
    def X4Y17Cell(self) -> IEditorCell: ...
    @property
    def X4Y1Cell(self) -> IEditorCell: ...
    @property
    def X4Y2(self) -> float: ...
    @property
    def X4Y2Cell(self) -> IEditorCell: ...
    @property
    def X4Y3(self) -> float: ...
    @property
    def X4Y3Cell(self) -> IEditorCell: ...
    @property
    def X4Y4(self) -> float: ...
    @property
    def X4Y4Cell(self) -> IEditorCell: ...
    @property
    def X4Y5(self) -> float: ...
    @property
    def X4Y5Cell(self) -> IEditorCell: ...
    @property
    def X4Y6(self) -> float: ...
    @property
    def X4Y6Cell(self) -> IEditorCell: ...
    @property
    def X4Y7(self) -> float: ...
    @property
    def X4Y7Cell(self) -> IEditorCell: ...
    @property
    def X4Y8(self) -> float: ...
    @property
    def X4Y8Cell(self) -> IEditorCell: ...
    @property
    def X4Y9(self) -> float: ...
    @property
    def X4Y9Cell(self) -> IEditorCell: ...
    @property
    def X5Y0(self) -> float: ...
    @property
    def X5Y0Cell(self) -> IEditorCell: ...
    @property
    def X5Y1(self) -> float: ...
    @property
    def X5Y10(self) -> float: ...
    @property
    def X5Y10Cell(self) -> IEditorCell: ...
    @property
    def X5Y11(self) -> float: ...
    @property
    def X5Y11Cell(self) -> IEditorCell: ...
    @property
    def X5Y12(self) -> float: ...
    @property
    def X5Y12Cell(self) -> IEditorCell: ...
    @property
    def X5Y13(self) -> float: ...
    @property
    def X5Y13Cell(self) -> IEditorCell: ...
    @property
    def X5Y14(self) -> float: ...
    @property
    def X5Y14Cell(self) -> IEditorCell: ...
    @property
    def X5Y15(self) -> float: ...
    @property
    def X5Y15Cell(self) -> IEditorCell: ...
    @property
    def X5Y16(self) -> float: ...
    @property
    def X5Y16Cell(self) -> IEditorCell: ...
    @property
    def X5Y1Cell(self) -> IEditorCell: ...
    @property
    def X5Y2(self) -> float: ...
    @property
    def X5Y2Cell(self) -> IEditorCell: ...
    @property
    def X5Y3(self) -> float: ...
    @property
    def X5Y3Cell(self) -> IEditorCell: ...
    @property
    def X5Y4(self) -> float: ...
    @property
    def X5Y4Cell(self) -> IEditorCell: ...
    @property
    def X5Y5(self) -> float: ...
    @property
    def X5Y5Cell(self) -> IEditorCell: ...
    @property
    def X5Y6(self) -> float: ...
    @property
    def X5Y6Cell(self) -> IEditorCell: ...
    @property
    def X5Y7(self) -> float: ...
    @property
    def X5Y7Cell(self) -> IEditorCell: ...
    @property
    def X5Y8(self) -> float: ...
    @property
    def X5Y8Cell(self) -> IEditorCell: ...
    @property
    def X5Y9(self) -> float: ...
    @property
    def X5Y9Cell(self) -> IEditorCell: ...
    @property
    def X6Y0(self) -> float: ...
    @property
    def X6Y0Cell(self) -> IEditorCell: ...
    @property
    def X6Y1(self) -> float: ...
    @property
    def X6Y10(self) -> float: ...
    @property
    def X6Y10Cell(self) -> IEditorCell: ...
    @property
    def X6Y11(self) -> float: ...
    @property
    def X6Y11Cell(self) -> IEditorCell: ...
    @property
    def X6Y12(self) -> float: ...
    @property
    def X6Y12Cell(self) -> IEditorCell: ...
    @property
    def X6Y13(self) -> float: ...
    @property
    def X6Y13Cell(self) -> IEditorCell: ...
    @property
    def X6Y14(self) -> float: ...
    @property
    def X6Y14Cell(self) -> IEditorCell: ...
    @property
    def X6Y15(self) -> float: ...
    @property
    def X6Y15Cell(self) -> IEditorCell: ...
    @property
    def X6Y1Cell(self) -> IEditorCell: ...
    @property
    def X6Y2(self) -> float: ...
    @property
    def X6Y2Cell(self) -> IEditorCell: ...
    @property
    def X6Y3(self) -> float: ...
    @property
    def X6Y3Cell(self) -> IEditorCell: ...
    @property
    def X6Y4(self) -> float: ...
    @property
    def X6Y4Cell(self) -> IEditorCell: ...
    @property
    def X6Y5(self) -> float: ...
    @property
    def X6Y5Cell(self) -> IEditorCell: ...
    @property
    def X6Y6(self) -> float: ...
    @property
    def X6Y6Cell(self) -> IEditorCell: ...
    @property
    def X6Y7(self) -> float: ...
    @property
    def X6Y7Cell(self) -> IEditorCell: ...
    @property
    def X6Y8(self) -> float: ...
    @property
    def X6Y8Cell(self) -> IEditorCell: ...
    @property
    def X6Y9(self) -> float: ...
    @property
    def X6Y9Cell(self) -> IEditorCell: ...
    @property
    def X7Y0(self) -> float: ...
    @property
    def X7Y0Cell(self) -> IEditorCell: ...
    @property
    def X7Y1(self) -> float: ...
    @property
    def X7Y10(self) -> float: ...
    @property
    def X7Y10Cell(self) -> IEditorCell: ...
    @property
    def X7Y11(self) -> float: ...
    @property
    def X7Y11Cell(self) -> IEditorCell: ...
    @property
    def X7Y12(self) -> float: ...
    @property
    def X7Y12Cell(self) -> IEditorCell: ...
    @property
    def X7Y13(self) -> float: ...
    @property
    def X7Y13Cell(self) -> IEditorCell: ...
    @property
    def X7Y14(self) -> float: ...
    @property
    def X7Y14Cell(self) -> IEditorCell: ...
    @property
    def X7Y1Cell(self) -> IEditorCell: ...
    @property
    def X7Y2(self) -> float: ...
    @property
    def X7Y2Cell(self) -> IEditorCell: ...
    @property
    def X7Y3(self) -> float: ...
    @property
    def X7Y3Cell(self) -> IEditorCell: ...
    @property
    def X7Y4(self) -> float: ...
    @property
    def X7Y4Cell(self) -> IEditorCell: ...
    @property
    def X7Y5(self) -> float: ...
    @property
    def X7Y5Cell(self) -> IEditorCell: ...
    @property
    def X7Y6(self) -> float: ...
    @property
    def X7Y6Cell(self) -> IEditorCell: ...
    @property
    def X7Y7(self) -> float: ...
    @property
    def X7Y7Cell(self) -> IEditorCell: ...
    @property
    def X7Y8(self) -> float: ...
    @property
    def X7Y8Cell(self) -> IEditorCell: ...
    @property
    def X7Y9(self) -> float: ...
    @property
    def X7Y9Cell(self) -> IEditorCell: ...
    @property
    def X8Y0(self) -> float: ...
    @property
    def X8Y0Cell(self) -> IEditorCell: ...
    @property
    def X8Y1(self) -> float: ...
    @property
    def X8Y10(self) -> float: ...
    @property
    def X8Y10Cell(self) -> IEditorCell: ...
    @property
    def X8Y11(self) -> float: ...
    @property
    def X8Y11Cell(self) -> IEditorCell: ...
    @property
    def X8Y12(self) -> float: ...
    @property
    def X8Y12Cell(self) -> IEditorCell: ...
    @property
    def X8Y13(self) -> float: ...
    @property
    def X8Y13Cell(self) -> IEditorCell: ...
    @property
    def X8Y1Cell(self) -> IEditorCell: ...
    @property
    def X8Y2(self) -> float: ...
    @property
    def X8Y2Cell(self) -> IEditorCell: ...
    @property
    def X8Y3(self) -> float: ...
    @property
    def X8Y3Cell(self) -> IEditorCell: ...
    @property
    def X8Y4(self) -> float: ...
    @property
    def X8Y4Cell(self) -> IEditorCell: ...
    @property
    def X8Y5(self) -> float: ...
    @property
    def X8Y5Cell(self) -> IEditorCell: ...
    @property
    def X8Y6(self) -> float: ...
    @property
    def X8Y6Cell(self) -> IEditorCell: ...
    @property
    def X8Y7(self) -> float: ...
    @property
    def X8Y7Cell(self) -> IEditorCell: ...
    @property
    def X8Y8(self) -> float: ...
    @property
    def X8Y8Cell(self) -> IEditorCell: ...
    @property
    def X8Y9(self) -> float: ...
    @property
    def X8Y9Cell(self) -> IEditorCell: ...
    @property
    def X9Y0(self) -> float: ...
    @property
    def X9Y0Cell(self) -> IEditorCell: ...
    @property
    def X9Y1(self) -> float: ...
    @property
    def X9Y10(self) -> float: ...
    @property
    def X9Y10Cell(self) -> IEditorCell: ...
    @property
    def X9Y11(self) -> float: ...
    @property
    def X9Y11Cell(self) -> IEditorCell: ...
    @property
    def X9Y12(self) -> float: ...
    @property
    def X9Y12Cell(self) -> IEditorCell: ...
    @property
    def X9Y1Cell(self) -> IEditorCell: ...
    @property
    def X9Y2(self) -> float: ...
    @property
    def X9Y2Cell(self) -> IEditorCell: ...
    @property
    def X9Y3(self) -> float: ...
    @property
    def X9Y3Cell(self) -> IEditorCell: ...
    @property
    def X9Y4(self) -> float: ...
    @property
    def X9Y4Cell(self) -> IEditorCell: ...
    @property
    def X9Y5(self) -> float: ...
    @property
    def X9Y5Cell(self) -> IEditorCell: ...
    @property
    def X9Y6(self) -> float: ...
    @property
    def X9Y6Cell(self) -> IEditorCell: ...
    @property
    def X9Y7(self) -> float: ...
    @property
    def X9Y7Cell(self) -> IEditorCell: ...
    @property
    def X9Y8(self) -> float: ...
    @property
    def X9Y8Cell(self) -> IEditorCell: ...
    @property
    def X9Y9(self) -> float: ...
    @property
    def X9Y9Cell(self) -> IEditorCell: ...
    @X0Y1.setter
    def X0Y1(self, value: float) -> None: ...
    @X0Y10.setter
    def X0Y10(self, value: float) -> None: ...
    @X0Y11.setter
    def X0Y11(self, value: float) -> None: ...
    @X0Y12.setter
    def X0Y12(self, value: float) -> None: ...
    @X0Y13.setter
    def X0Y13(self, value: float) -> None: ...
    @X0Y14.setter
    def X0Y14(self, value: float) -> None: ...
    @X0Y15.setter
    def X0Y15(self, value: float) -> None: ...
    @X0Y16.setter
    def X0Y16(self, value: float) -> None: ...
    @X0Y17.setter
    def X0Y17(self, value: float) -> None: ...
    @X0Y18.setter
    def X0Y18(self, value: float) -> None: ...
    @X0Y19.setter
    def X0Y19(self, value: float) -> None: ...
    @X0Y2.setter
    def X0Y2(self, value: float) -> None: ...
    @X0Y20.setter
    def X0Y20(self, value: float) -> None: ...
    @X0Y3.setter
    def X0Y3(self, value: float) -> None: ...
    @X0Y4.setter
    def X0Y4(self, value: float) -> None: ...
    @X0Y5.setter
    def X0Y5(self, value: float) -> None: ...
    @X0Y6.setter
    def X0Y6(self, value: float) -> None: ...
    @X0Y7.setter
    def X0Y7(self, value: float) -> None: ...
    @X0Y8.setter
    def X0Y8(self, value: float) -> None: ...
    @X0Y9.setter
    def X0Y9(self, value: float) -> None: ...
    @X10Y0.setter
    def X10Y0(self, value: float) -> None: ...
    @X10Y1.setter
    def X10Y1(self, value: float) -> None: ...
    @X10Y10.setter
    def X10Y10(self, value: float) -> None: ...
    @X10Y11.setter
    def X10Y11(self, value: float) -> None: ...
    @X10Y2.setter
    def X10Y2(self, value: float) -> None: ...
    @X10Y3.setter
    def X10Y3(self, value: float) -> None: ...
    @X10Y4.setter
    def X10Y4(self, value: float) -> None: ...
    @X10Y5.setter
    def X10Y5(self, value: float) -> None: ...
    @X10Y6.setter
    def X10Y6(self, value: float) -> None: ...
    @X10Y7.setter
    def X10Y7(self, value: float) -> None: ...
    @X10Y8.setter
    def X10Y8(self, value: float) -> None: ...
    @X10Y9.setter
    def X10Y9(self, value: float) -> None: ...
    @X11Y0.setter
    def X11Y0(self, value: float) -> None: ...
    @X11Y1.setter
    def X11Y1(self, value: float) -> None: ...
    @X11Y10.setter
    def X11Y10(self, value: float) -> None: ...
    @X11Y2.setter
    def X11Y2(self, value: float) -> None: ...
    @X11Y3.setter
    def X11Y3(self, value: float) -> None: ...
    @X11Y4.setter
    def X11Y4(self, value: float) -> None: ...
    @X11Y5.setter
    def X11Y5(self, value: float) -> None: ...
    @X11Y6.setter
    def X11Y6(self, value: float) -> None: ...
    @X11Y7.setter
    def X11Y7(self, value: float) -> None: ...
    @X11Y8.setter
    def X11Y8(self, value: float) -> None: ...
    @X11Y9.setter
    def X11Y9(self, value: float) -> None: ...
    @X12Y0.setter
    def X12Y0(self, value: float) -> None: ...
    @X12Y1.setter
    def X12Y1(self, value: float) -> None: ...
    @X12Y2.setter
    def X12Y2(self, value: float) -> None: ...
    @X12Y3.setter
    def X12Y3(self, value: float) -> None: ...
    @X12Y4.setter
    def X12Y4(self, value: float) -> None: ...
    @X12Y5.setter
    def X12Y5(self, value: float) -> None: ...
    @X12Y6.setter
    def X12Y6(self, value: float) -> None: ...
    @X12Y7.setter
    def X12Y7(self, value: float) -> None: ...
    @X12Y8.setter
    def X12Y8(self, value: float) -> None: ...
    @X12Y9.setter
    def X12Y9(self, value: float) -> None: ...
    @X13Y0.setter
    def X13Y0(self, value: float) -> None: ...
    @X13Y1.setter
    def X13Y1(self, value: float) -> None: ...
    @X13Y2.setter
    def X13Y2(self, value: float) -> None: ...
    @X13Y3.setter
    def X13Y3(self, value: float) -> None: ...
    @X13Y4.setter
    def X13Y4(self, value: float) -> None: ...
    @X13Y5.setter
    def X13Y5(self, value: float) -> None: ...
    @X13Y6.setter
    def X13Y6(self, value: float) -> None: ...
    @X13Y7.setter
    def X13Y7(self, value: float) -> None: ...
    @X13Y8.setter
    def X13Y8(self, value: float) -> None: ...
    @X14Y0.setter
    def X14Y0(self, value: float) -> None: ...
    @X14Y1.setter
    def X14Y1(self, value: float) -> None: ...
    @X14Y2.setter
    def X14Y2(self, value: float) -> None: ...
    @X14Y3.setter
    def X14Y3(self, value: float) -> None: ...
    @X14Y4.setter
    def X14Y4(self, value: float) -> None: ...
    @X14Y5.setter
    def X14Y5(self, value: float) -> None: ...
    @X14Y6.setter
    def X14Y6(self, value: float) -> None: ...
    @X14Y7.setter
    def X14Y7(self, value: float) -> None: ...
    @X15Y0.setter
    def X15Y0(self, value: float) -> None: ...
    @X15Y1.setter
    def X15Y1(self, value: float) -> None: ...
    @X15Y2.setter
    def X15Y2(self, value: float) -> None: ...
    @X15Y3.setter
    def X15Y3(self, value: float) -> None: ...
    @X15Y4.setter
    def X15Y4(self, value: float) -> None: ...
    @X15Y5.setter
    def X15Y5(self, value: float) -> None: ...
    @X15Y6.setter
    def X15Y6(self, value: float) -> None: ...
    @X16Y0.setter
    def X16Y0(self, value: float) -> None: ...
    @X16Y1.setter
    def X16Y1(self, value: float) -> None: ...
    @X16Y2.setter
    def X16Y2(self, value: float) -> None: ...
    @X16Y3.setter
    def X16Y3(self, value: float) -> None: ...
    @X16Y4.setter
    def X16Y4(self, value: float) -> None: ...
    @X16Y5.setter
    def X16Y5(self, value: float) -> None: ...
    @X17Y0.setter
    def X17Y0(self, value: float) -> None: ...
    @X17Y1.setter
    def X17Y1(self, value: float) -> None: ...
    @X17Y2.setter
    def X17Y2(self, value: float) -> None: ...
    @X17Y3.setter
    def X17Y3(self, value: float) -> None: ...
    @X17Y4.setter
    def X17Y4(self, value: float) -> None: ...
    @X18Y0.setter
    def X18Y0(self, value: float) -> None: ...
    @X18Y1.setter
    def X18Y1(self, value: float) -> None: ...
    @X18Y2.setter
    def X18Y2(self, value: float) -> None: ...
    @X18Y3.setter
    def X18Y3(self, value: float) -> None: ...
    @X19Y0.setter
    def X19Y0(self, value: float) -> None: ...
    @X19Y1.setter
    def X19Y1(self, value: float) -> None: ...
    @X19Y2.setter
    def X19Y2(self, value: float) -> None: ...
    @X1Y0.setter
    def X1Y0(self, value: float) -> None: ...
    @X1Y1.setter
    def X1Y1(self, value: float) -> None: ...
    @X1Y10.setter
    def X1Y10(self, value: float) -> None: ...
    @X1Y11.setter
    def X1Y11(self, value: float) -> None: ...
    @X1Y12.setter
    def X1Y12(self, value: float) -> None: ...
    @X1Y13.setter
    def X1Y13(self, value: float) -> None: ...
    @X1Y14.setter
    def X1Y14(self, value: float) -> None: ...
    @X1Y15.setter
    def X1Y15(self, value: float) -> None: ...
    @X1Y16.setter
    def X1Y16(self, value: float) -> None: ...
    @X1Y17.setter
    def X1Y17(self, value: float) -> None: ...
    @X1Y18.setter
    def X1Y18(self, value: float) -> None: ...
    @X1Y19.setter
    def X1Y19(self, value: float) -> None: ...
    @X1Y2.setter
    def X1Y2(self, value: float) -> None: ...
    @X1Y3.setter
    def X1Y3(self, value: float) -> None: ...
    @X1Y4.setter
    def X1Y4(self, value: float) -> None: ...
    @X1Y5.setter
    def X1Y5(self, value: float) -> None: ...
    @X1Y6.setter
    def X1Y6(self, value: float) -> None: ...
    @X1Y7.setter
    def X1Y7(self, value: float) -> None: ...
    @X1Y8.setter
    def X1Y8(self, value: float) -> None: ...
    @X1Y9.setter
    def X1Y9(self, value: float) -> None: ...
    @X20Y0.setter
    def X20Y0(self, value: float) -> None: ...
    @X20Y1.setter
    def X20Y1(self, value: float) -> None: ...
    @X21Y0.setter
    def X21Y0(self, value: float) -> None: ...
    @X2Y0.setter
    def X2Y0(self, value: float) -> None: ...
    @X2Y1.setter
    def X2Y1(self, value: float) -> None: ...
    @X2Y10.setter
    def X2Y10(self, value: float) -> None: ...
    @X2Y11.setter
    def X2Y11(self, value: float) -> None: ...
    @X2Y12.setter
    def X2Y12(self, value: float) -> None: ...
    @X2Y13.setter
    def X2Y13(self, value: float) -> None: ...
    @X2Y14.setter
    def X2Y14(self, value: float) -> None: ...
    @X2Y15.setter
    def X2Y15(self, value: float) -> None: ...
    @X2Y16.setter
    def X2Y16(self, value: float) -> None: ...
    @X2Y17.setter
    def X2Y17(self, value: float) -> None: ...
    @X2Y18.setter
    def X2Y18(self, value: float) -> None: ...
    @X2Y19.setter
    def X2Y19(self, value: float) -> None: ...
    @X2Y2.setter
    def X2Y2(self, value: float) -> None: ...
    @X2Y3.setter
    def X2Y3(self, value: float) -> None: ...
    @X2Y4.setter
    def X2Y4(self, value: float) -> None: ...
    @X2Y5.setter
    def X2Y5(self, value: float) -> None: ...
    @X2Y6.setter
    def X2Y6(self, value: float) -> None: ...
    @X2Y7.setter
    def X2Y7(self, value: float) -> None: ...
    @X2Y8.setter
    def X2Y8(self, value: float) -> None: ...
    @X2Y9.setter
    def X2Y9(self, value: float) -> None: ...
    @X3Y0.setter
    def X3Y0(self, value: float) -> None: ...
    @X3Y1.setter
    def X3Y1(self, value: float) -> None: ...
    @X3Y10.setter
    def X3Y10(self, value: float) -> None: ...
    @X3Y11.setter
    def X3Y11(self, value: float) -> None: ...
    @X3Y12.setter
    def X3Y12(self, value: float) -> None: ...
    @X3Y13.setter
    def X3Y13(self, value: float) -> None: ...
    @X3Y14.setter
    def X3Y14(self, value: float) -> None: ...
    @X3Y15.setter
    def X3Y15(self, value: float) -> None: ...
    @X3Y16.setter
    def X3Y16(self, value: float) -> None: ...
    @X3Y17.setter
    def X3Y17(self, value: float) -> None: ...
    @X3Y18.setter
    def X3Y18(self, value: float) -> None: ...
    @X3Y2.setter
    def X3Y2(self, value: float) -> None: ...
    @X3Y3.setter
    def X3Y3(self, value: float) -> None: ...
    @X3Y4.setter
    def X3Y4(self, value: float) -> None: ...
    @X3Y5.setter
    def X3Y5(self, value: float) -> None: ...
    @X3Y6.setter
    def X3Y6(self, value: float) -> None: ...
    @X3Y7.setter
    def X3Y7(self, value: float) -> None: ...
    @X3Y8.setter
    def X3Y8(self, value: float) -> None: ...
    @X3Y9.setter
    def X3Y9(self, value: float) -> None: ...
    @X4Y0.setter
    def X4Y0(self, value: float) -> None: ...
    @X4Y1.setter
    def X4Y1(self, value: float) -> None: ...
    @X4Y10.setter
    def X4Y10(self, value: float) -> None: ...
    @X4Y11.setter
    def X4Y11(self, value: float) -> None: ...
    @X4Y12.setter
    def X4Y12(self, value: float) -> None: ...
    @X4Y13.setter
    def X4Y13(self, value: float) -> None: ...
    @X4Y14.setter
    def X4Y14(self, value: float) -> None: ...
    @X4Y15.setter
    def X4Y15(self, value: float) -> None: ...
    @X4Y16.setter
    def X4Y16(self, value: float) -> None: ...
    @X4Y17.setter
    def X4Y17(self, value: float) -> None: ...
    @X4Y2.setter
    def X4Y2(self, value: float) -> None: ...
    @X4Y3.setter
    def X4Y3(self, value: float) -> None: ...
    @X4Y4.setter
    def X4Y4(self, value: float) -> None: ...
    @X4Y5.setter
    def X4Y5(self, value: float) -> None: ...
    @X4Y6.setter
    def X4Y6(self, value: float) -> None: ...
    @X4Y7.setter
    def X4Y7(self, value: float) -> None: ...
    @X4Y8.setter
    def X4Y8(self, value: float) -> None: ...
    @X4Y9.setter
    def X4Y9(self, value: float) -> None: ...
    @X5Y0.setter
    def X5Y0(self, value: float) -> None: ...
    @X5Y1.setter
    def X5Y1(self, value: float) -> None: ...
    @X5Y10.setter
    def X5Y10(self, value: float) -> None: ...
    @X5Y11.setter
    def X5Y11(self, value: float) -> None: ...
    @X5Y12.setter
    def X5Y12(self, value: float) -> None: ...
    @X5Y13.setter
    def X5Y13(self, value: float) -> None: ...
    @X5Y14.setter
    def X5Y14(self, value: float) -> None: ...
    @X5Y15.setter
    def X5Y15(self, value: float) -> None: ...
    @X5Y16.setter
    def X5Y16(self, value: float) -> None: ...
    @X5Y2.setter
    def X5Y2(self, value: float) -> None: ...
    @X5Y3.setter
    def X5Y3(self, value: float) -> None: ...
    @X5Y4.setter
    def X5Y4(self, value: float) -> None: ...
    @X5Y5.setter
    def X5Y5(self, value: float) -> None: ...
    @X5Y6.setter
    def X5Y6(self, value: float) -> None: ...
    @X5Y7.setter
    def X5Y7(self, value: float) -> None: ...
    @X5Y8.setter
    def X5Y8(self, value: float) -> None: ...
    @X5Y9.setter
    def X5Y9(self, value: float) -> None: ...
    @X6Y0.setter
    def X6Y0(self, value: float) -> None: ...
    @X6Y1.setter
    def X6Y1(self, value: float) -> None: ...
    @X6Y10.setter
    def X6Y10(self, value: float) -> None: ...
    @X6Y11.setter
    def X6Y11(self, value: float) -> None: ...
    @X6Y12.setter
    def X6Y12(self, value: float) -> None: ...
    @X6Y13.setter
    def X6Y13(self, value: float) -> None: ...
    @X6Y14.setter
    def X6Y14(self, value: float) -> None: ...
    @X6Y15.setter
    def X6Y15(self, value: float) -> None: ...
    @X6Y2.setter
    def X6Y2(self, value: float) -> None: ...
    @X6Y3.setter
    def X6Y3(self, value: float) -> None: ...
    @X6Y4.setter
    def X6Y4(self, value: float) -> None: ...
    @X6Y5.setter
    def X6Y5(self, value: float) -> None: ...
    @X6Y6.setter
    def X6Y6(self, value: float) -> None: ...
    @X6Y7.setter
    def X6Y7(self, value: float) -> None: ...
    @X6Y8.setter
    def X6Y8(self, value: float) -> None: ...
    @X6Y9.setter
    def X6Y9(self, value: float) -> None: ...
    @X7Y0.setter
    def X7Y0(self, value: float) -> None: ...
    @X7Y1.setter
    def X7Y1(self, value: float) -> None: ...
    @X7Y10.setter
    def X7Y10(self, value: float) -> None: ...
    @X7Y11.setter
    def X7Y11(self, value: float) -> None: ...
    @X7Y12.setter
    def X7Y12(self, value: float) -> None: ...
    @X7Y13.setter
    def X7Y13(self, value: float) -> None: ...
    @X7Y14.setter
    def X7Y14(self, value: float) -> None: ...
    @X7Y2.setter
    def X7Y2(self, value: float) -> None: ...
    @X7Y3.setter
    def X7Y3(self, value: float) -> None: ...
    @X7Y4.setter
    def X7Y4(self, value: float) -> None: ...
    @X7Y5.setter
    def X7Y5(self, value: float) -> None: ...
    @X7Y6.setter
    def X7Y6(self, value: float) -> None: ...
    @X7Y7.setter
    def X7Y7(self, value: float) -> None: ...
    @X7Y8.setter
    def X7Y8(self, value: float) -> None: ...
    @X7Y9.setter
    def X7Y9(self, value: float) -> None: ...
    @X8Y0.setter
    def X8Y0(self, value: float) -> None: ...
    @X8Y1.setter
    def X8Y1(self, value: float) -> None: ...
    @X8Y10.setter
    def X8Y10(self, value: float) -> None: ...
    @X8Y11.setter
    def X8Y11(self, value: float) -> None: ...
    @X8Y12.setter
    def X8Y12(self, value: float) -> None: ...
    @X8Y13.setter
    def X8Y13(self, value: float) -> None: ...
    @X8Y2.setter
    def X8Y2(self, value: float) -> None: ...
    @X8Y3.setter
    def X8Y3(self, value: float) -> None: ...
    @X8Y4.setter
    def X8Y4(self, value: float) -> None: ...
    @X8Y5.setter
    def X8Y5(self, value: float) -> None: ...
    @X8Y6.setter
    def X8Y6(self, value: float) -> None: ...
    @X8Y7.setter
    def X8Y7(self, value: float) -> None: ...
    @X8Y8.setter
    def X8Y8(self, value: float) -> None: ...
    @X8Y9.setter
    def X8Y9(self, value: float) -> None: ...
    @X9Y0.setter
    def X9Y0(self, value: float) -> None: ...
    @X9Y1.setter
    def X9Y1(self, value: float) -> None: ...
    @X9Y10.setter
    def X9Y10(self, value: float) -> None: ...
    @X9Y11.setter
    def X9Y11(self, value: float) -> None: ...
    @X9Y12.setter
    def X9Y12(self, value: float) -> None: ...
    @X9Y2.setter
    def X9Y2(self, value: float) -> None: ...
    @X9Y3.setter
    def X9Y3(self, value: float) -> None: ...
    @X9Y4.setter
    def X9Y4(self, value: float) -> None: ...
    @X9Y5.setter
    def X9Y5(self, value: float) -> None: ...
    @X9Y6.setter
    def X9Y6(self, value: float) -> None: ...
    @X9Y7.setter
    def X9Y7(self, value: float) -> None: ...
    @X9Y8.setter
    def X9Y8(self, value: float) -> None: ...
    @X9Y9.setter
    def X9Y9(self, value: float) -> None: ...

class IObjectZernikeSurface(IObject):
    @property
    def CoeffRPower10(self) -> float: ...
    @property
    def CoeffRPower10Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower12(self) -> float: ...
    @property
    def CoeffRPower12Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower14(self) -> float: ...
    @property
    def CoeffRPower14Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower16(self) -> float: ...
    @property
    def CoeffRPower16Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower2(self) -> float: ...
    @property
    def CoeffRPower2Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower4(self) -> float: ...
    @property
    def CoeffRPower4Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower6(self) -> float: ...
    @property
    def CoeffRPower6Cell(self) -> IEditorCell: ...
    @property
    def CoeffRPower8(self) -> float: ...
    @property
    def CoeffRPower8Cell(self) -> IEditorCell: ...
    @property
    def Conic(self) -> float: ...
    @property
    def ConicCell(self) -> IEditorCell: ...
    @property
    def MaxAperture(self) -> float: ...
    @property
    def MaxApertureCell(self) -> IEditorCell: ...
    @property
    def NormRad(self) -> float: ...
    @property
    def NormRadCell(self) -> IEditorCell: ...
    @property
    def NumberOfZTerms(self) -> int: ...
    @property
    def NumberOfZTermsCell(self) -> IEditorCell: ...
    @property
    def Radius(self) -> float: ...
    @property
    def RadiusCell(self) -> IEditorCell: ...
    @property
    def XDecenter(self) -> float: ...
    @property
    def XDecenterCell(self) -> IEditorCell: ...
    @property
    def YDecenter(self) -> float: ...
    @property
    def YDecenterCellCell(self) -> IEditorCell: ...
    def GetFrontTerm(self, i: int) -> float: ...
    def GetZICell(self, i: int) -> IEditorCell: ...
    @CoeffRPower10.setter
    def CoeffRPower10(self, value: float) -> None: ...
    @CoeffRPower12.setter
    def CoeffRPower12(self, value: float) -> None: ...
    @CoeffRPower14.setter
    def CoeffRPower14(self, value: float) -> None: ...
    @CoeffRPower16.setter
    def CoeffRPower16(self, value: float) -> None: ...
    @CoeffRPower2.setter
    def CoeffRPower2(self, value: float) -> None: ...
    @CoeffRPower4.setter
    def CoeffRPower4(self, value: float) -> None: ...
    @CoeffRPower6.setter
    def CoeffRPower6(self, value: float) -> None: ...
    @CoeffRPower8.setter
    def CoeffRPower8(self, value: float) -> None: ...
    @Conic.setter
    def Conic(self, value: float) -> None: ...
    @MaxAperture.setter
    def MaxAperture(self, value: float) -> None: ...
    @NormRad.setter
    def NormRad(self, value: float) -> None: ...
    @NumberOfZTerms.setter
    def NumberOfZTerms(self, value: int) -> None: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    @XDecenter.setter
    def XDecenter(self, value: float) -> None: ...
    @YDecenter.setter
    def YDecenter(self, value: float) -> None: ...
    def SetFrontTerm(self, i: int, Value: float) -> None: ...

class IOSS_ABg(IObjectScatteringSettings):
    @property
    def ReflectName(self) -> str: ...
    @property
    def TransmitName(self) -> str: ...
    def GetAvailableABgNames(self) -> list[str]: ...
    @ReflectName.setter
    def ReflectName(self, value: str) -> None: ...
    @TransmitName.setter
    def TransmitName(self, value: str) -> None: ...

class IOSS_ABgFile(IObjectScatteringSettings):
    @property
    def ReflectFile(self) -> str: ...
    @property
    def TransmitFile(self) -> str: ...
    def GetAvailableFiles(self) -> list[str]: ...
    @ReflectFile.setter
    def ReflectFile(self, value: str) -> None: ...
    @TransmitFile.setter
    def TransmitFile(self, value: str) -> None: ...

class IOSS_BSDF(IObjectScatteringSettings):
    @property
    def Angle(self) -> float: ...
    @property
    def ReflectFile(self) -> str: ...
    @property
    def ScatterFraction(self) -> float: ...
    @property
    def TransmitFile(self) -> str: ...
    def GetAvailableFileNames(self) -> list[str]: ...
    @Angle.setter
    def Angle(self, value: float) -> None: ...
    @ReflectFile.setter
    def ReflectFile(self, value: str) -> None: ...
    @ScatterFraction.setter
    def ScatterFraction(self, value: float) -> None: ...
    @TransmitFile.setter
    def TransmitFile(self, value: str) -> None: ...

class IOSS_Gaussian(IObjectScatteringSettings):
    @property
    def ScatterFraction(self) -> float: ...
    @property
    def Sigma(self) -> float: ...
    @ScatterFraction.setter
    def ScatterFraction(self, value: float) -> None: ...
    @Sigma.setter
    def Sigma(self, value: float) -> None: ...

class IOSS_ISScatterCatalog(IObjectScatteringSettings):
    @property
    def Angle(self) -> float: ...
    @property
    def SampleSideR(self) -> SampleSides: ...
    @property
    def SampleSideT(self) -> SampleSides: ...
    @property
    def SamplingR(self) -> Samplings: ...
    @property
    def SamplingT(self) -> Samplings: ...
    def GetAvailableISFiles(self) -> list[str]: ...
    def GetReflectFile(self) -> str: ...
    def GetSampleSidesR(self) -> list[SampleSides]: ...
    def GetSampleSidesT(self) -> list[SampleSides]: ...
    def GetTransmitFile(self) -> str: ...
    @Angle.setter
    def Angle(self, value: float) -> None: ...
    @SampleSideR.setter
    def SampleSideR(self, value: SampleSides) -> None: ...
    @SampleSideT.setter
    def SampleSideT(self, value: SampleSides) -> None: ...
    @SamplingR.setter
    def SamplingR(self, value: Samplings) -> None: ...
    @SamplingT.setter
    def SamplingT(self, value: Samplings) -> None: ...
    def SetReflectFile(self, File: str) -> ReflectTransmitCode: ...
    def SetTransmitFile(self, File: str) -> ReflectTransmitCode: ...

class IOSS_Lambertian(IObjectScatteringSettings):
    @property
    def ScatterFraction(self) -> float: ...
    @ScatterFraction.setter
    def ScatterFraction(self, value: float) -> None: ...

class IOSS_None(IObjectScatteringSettings):
    pass

class IOSS_User(IObjectScatteringSettings):
    @property
    def DLLName(self) -> str: ...
    @property
    def FileName(self) -> str: ...
    @property
    def FileNameRequired(self) -> bool: ...
    @property
    def NumberOfParameters(self) -> int: ...
    @property
    def ScatterFraction(self) -> float: ...
    def GetAvailableDLLNames(self) -> list[str]: ...
    def GetAvailableFileNames(self) -> list[str]: ...
    def GetParameterName(self, paramIdx: int) -> str: ...
    def GetParameterValue(self, paramIdx: int) -> float: ...
    @DLLName.setter
    def DLLName(self, value: str) -> None: ...
    @FileName.setter
    def FileName(self, value: str) -> None: ...
    @ScatterFraction.setter
    def ScatterFraction(self, value: float) -> None: ...
    def SetParameterValue(self, paramIdx: int, Value: float) -> bool: ...

class ISCS_BlackBodySpectrum(ISourceColorSettings):
    @property
    def Fit(self) -> str: ...
    @property
    def SpectrumCount(self) -> int: ...
    @property
    def TemperatureK(self) -> float: ...
    @property
    def WavelengthFrom(self) -> float: ...
    @property
    def WavelengthTo(self) -> float: ...
    @SpectrumCount.setter
    def SpectrumCount(self, value: int) -> None: ...
    @TemperatureK.setter
    def TemperatureK(self, value: float) -> None: ...
    @WavelengthFrom.setter
    def WavelengthFrom(self, value: float) -> None: ...
    @WavelengthTo.setter
    def WavelengthTo(self, value: float) -> None: ...

class ISCS_CIE1931Chromaticity(ISourceColorSettings):
    @property
    def cx(self) -> float: ...
    @property
    def cy(self) -> float: ...
    @property
    def Fit(self) -> str: ...
    @property
    def SpectrumCount(self) -> int: ...
    @property
    def WavelengthFrom(self) -> float: ...
    @property
    def WavelengthTo(self) -> float: ...
    @cx.setter
    def cx(self, value: float) -> None: ...
    @cy.setter
    def cy(self, value: float) -> None: ...
    @SpectrumCount.setter
    def SpectrumCount(self, value: int) -> None: ...
    @WavelengthFrom.setter
    def WavelengthFrom(self, value: float) -> None: ...
    @WavelengthTo.setter
    def WavelengthTo(self, value: float) -> None: ...

class ISCS_CIE1931RGB(ISourceColorSettings):
    @property
    def B(self) -> float: ...
    @property
    def Fit(self) -> str: ...
    @property
    def G(self) -> float: ...
    @property
    def R(self) -> float: ...
    @property
    def SpectrumCount(self) -> int: ...
    @property
    def WavelengthFrom(self) -> float: ...
    @property
    def WavelengthTo(self) -> float: ...
    @B.setter
    def B(self, value: float) -> None: ...
    @G.setter
    def G(self, value: float) -> None: ...
    @R.setter
    def R(self, value: float) -> None: ...
    @SpectrumCount.setter
    def SpectrumCount(self, value: int) -> None: ...
    @WavelengthFrom.setter
    def WavelengthFrom(self, value: float) -> None: ...
    @WavelengthTo.setter
    def WavelengthTo(self, value: float) -> None: ...

class ISCS_CIE1931Tristimulus(ISourceColorSettings):
    @property
    def Fit(self) -> str: ...
    @property
    def SpectrumCount(self) -> int: ...
    @property
    def WavelengthFrom(self) -> float: ...
    @property
    def WavelengthTo(self) -> float: ...
    @property
    def X(self) -> float: ...
    @property
    def Y(self) -> float: ...
    @property
    def Z(self) -> float: ...
    @SpectrumCount.setter
    def SpectrumCount(self, value: int) -> None: ...
    @WavelengthFrom.setter
    def WavelengthFrom(self, value: float) -> None: ...
    @WavelengthTo.setter
    def WavelengthTo(self, value: float) -> None: ...
    @X.setter
    def X(self, value: float) -> None: ...
    @Y.setter
    def Y(self, value: float) -> None: ...
    @Z.setter
    def Z(self, value: float) -> None: ...

class ISCS_CIE1976(ISourceColorSettings):
    @property
    def Fit(self) -> str: ...
    @property
    def SpectrumCount(self) -> int: ...
    @property
    def u(self) -> float: ...
    @property
    def v(self) -> float: ...
    @property
    def WavelengthFrom(self) -> float: ...
    @property
    def WavelengthTo(self) -> float: ...
    @SpectrumCount.setter
    def SpectrumCount(self, value: int) -> None: ...
    @u.setter
    def u(self, value: float) -> None: ...
    @v.setter
    def v(self, value: float) -> None: ...
    @WavelengthFrom.setter
    def WavelengthFrom(self, value: float) -> None: ...
    @WavelengthTo.setter
    def WavelengthTo(self, value: float) -> None: ...

class ISCS_ColorTemperature(ISourceColorSettings):
    @property
    def Fit(self) -> str: ...
    @property
    def SpectrumCount(self) -> int: ...
    @property
    def TemperatureK(self) -> float: ...
    @property
    def WavelengthFrom(self) -> float: ...
    @property
    def WavelengthTo(self) -> float: ...
    @SpectrumCount.setter
    def SpectrumCount(self, value: int) -> None: ...
    @TemperatureK.setter
    def TemperatureK(self, value: float) -> None: ...
    @WavelengthFrom.setter
    def WavelengthFrom(self, value: float) -> None: ...
    @WavelengthTo.setter
    def WavelengthTo(self, value: float) -> None: ...

class ISCS_D65White(ISourceColorSettings):
    @property
    def Fit(self) -> str: ...
    @property
    def SpectrumCount(self) -> int: ...
    @property
    def WavelengthFrom(self) -> float: ...
    @property
    def WavelengthTo(self) -> float: ...
    @SpectrumCount.setter
    def SpectrumCount(self, value: int) -> None: ...
    @WavelengthFrom.setter
    def WavelengthFrom(self, value: float) -> None: ...
    @WavelengthTo.setter
    def WavelengthTo(self, value: float) -> None: ...

class ISCS_SpectrumFile(ISourceColorSettings):
    @property
    def Fit(self) -> str: ...
    @property
    def SpectrumCount(self) -> int: ...
    @property
    def SpectrumFile(self) -> str: ...
    @property
    def WavelengthFrom(self) -> float: ...
    @property
    def WavelengthTo(self) -> float: ...
    def GetAvailableSpectrumFiles(self) -> list[str]: ...
    @SpectrumFile.setter
    def SpectrumFile(self, value: str) -> None: ...

class ISCS_SystemWavelengths(ISourceColorSettings):
    pass

class ISCS_UniformPowerSpectrum(ISourceColorSettings):
    @property
    def Fit(self) -> str: ...
    @property
    def SpectrumCount(self) -> int: ...
    @property
    def WavelengthFrom(self) -> float: ...
    @property
    def WavelengthTo(self) -> float: ...
    @SpectrumCount.setter
    def SpectrumCount(self, value: int) -> None: ...
    @WavelengthFrom.setter
    def WavelengthFrom(self, value: float) -> None: ...
    @WavelengthTo.setter
    def WavelengthTo(self, value: float) -> None: ...

class ISourceColorSettings:
    @property
    def _S_BlackBodySpectrum(self) -> ISCS_BlackBodySpectrum: ...
    @property
    def _S_CIE1931Chromaticity(self) -> ISCS_CIE1931Chromaticity: ...
    @property
    def _S_CIE1931RGB(self) -> ISCS_CIE1931RGB: ...
    @property
    def _S_CIE1931Tristimulus(self) -> ISCS_CIE1931Tristimulus: ...
    @property
    def _S_CIE1976(self) -> ISCS_CIE1976: ...
    @property
    def _S_ColorTemperature(self) -> ISCS_ColorTemperature: ...
    @property
    def _S_D65White(self) -> ISCS_D65White: ...
    @property
    def _S_SpectrumFile(self) -> ISCS_SpectrumFile: ...
    @property
    def _S_SystemWavelengths(self) -> ISCS_SystemWavelengths: ...
    @property
    def _S_UniformPowerSpectrum(self) -> ISCS_UniformPowerSpectrum: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def Mode(self) -> SourceColorMode: ...

class IVMPS_AngleScattering(IVolumePhysicsModelSettings):
    @property
    def Angle(self) -> float: ...
    @property
    def MeanPath(self) -> float: ...
    @Angle.setter
    def Angle(self, value: float) -> None: ...
    @MeanPath.setter
    def MeanPath(self, value: float) -> None: ...

class IVMPS_DLLDefinedScattering(IVolumePhysicsModelSettings):
    @property
    def Angle(self) -> float: ...
    @property
    def AngleRequired(self) -> bool: ...
    @property
    def DLL(self) -> str: ...
    @property
    def MeanPath(self) -> float: ...
    @property
    def MeanPathRequired(self) -> bool: ...
    @property
    def NumberOfParameters(self) -> int: ...
    def GetAvailableDLLs(self) -> list[str]: ...
    def GetParameterName(self, paramIdx: int) -> str: ...
    def GetParameterValue(self, paramIdx: int) -> float: ...
    @Angle.setter
    def Angle(self, value: float) -> None: ...
    @DLL.setter
    def DLL(self, value: str) -> None: ...
    @MeanPath.setter
    def MeanPath(self, value: float) -> None: ...
    def SetParameterValue(self, paramIdx: int, Value: float) -> bool: ...

class IVMPS_PhotoluminscenceModel(IVolumePhysicsModelSettings):
    @property
    def AbsorptionFile(self) -> str: ...
    @property
    def AreSettingsValid(self) -> bool: ...
    @property
    def BasicAlgorithm(self) -> bool: ...
    @property
    def ConsiderMieScattering(self) -> bool: ...
    @property
    def EfficiencySpectrum(self) -> EfficiencySpectrumType: ...
    @property
    def EmissionFile(self) -> str: ...
    @property
    def ExcitationFile(self) -> str: ...
    @property
    def ExtinctionCoefficient(self) -> float: ...
    @property
    def ExtinctionWavelength(self) -> float: ...
    @property
    def MieMeanPath(self) -> float: ...
    @property
    def ParticleDensity(self) -> float: ...
    @property
    def ParticleIndex(self) -> float: ...
    @property
    def ParticleRadius(self) -> float: ...
    @property
    def PLDensity(self) -> float: ...
    @property
    def PLMeanPath(self) -> float: ...
    @property
    def QuantumYield(self) -> str: ...
    @property
    def Threshold(self) -> float: ...
    @property
    def UseMieDensity(self) -> bool: ...
    def GetAvailableAbsorptionFiles(self) -> list[str]: ...
    def GetAvailableEmissionFiles(self) -> list[str]: ...
    def GetAvailableQuantumYieldFiles(self) -> list[str]: ...
    @AbsorptionFile.setter
    def AbsorptionFile(self, value: str) -> None: ...
    @BasicAlgorithm.setter
    def BasicAlgorithm(self, value: bool) -> None: ...
    @ConsiderMieScattering.setter
    def ConsiderMieScattering(self, value: bool) -> None: ...
    @EfficiencySpectrum.setter
    def EfficiencySpectrum(self, value: EfficiencySpectrumType) -> None: ...
    @EmissionFile.setter
    def EmissionFile(self, value: str) -> None: ...
    @ExcitationFile.setter
    def ExcitationFile(self, value: str) -> None: ...
    @ExtinctionCoefficient.setter
    def ExtinctionCoefficient(self, value: float) -> None: ...
    @ExtinctionWavelength.setter
    def ExtinctionWavelength(self, value: float) -> None: ...
    @MieMeanPath.setter
    def MieMeanPath(self, value: float) -> None: ...
    @ParticleDensity.setter
    def ParticleDensity(self, value: float) -> None: ...
    @ParticleIndex.setter
    def ParticleIndex(self, value: float) -> None: ...
    @ParticleRadius.setter
    def ParticleRadius(self, value: float) -> None: ...
    @PLDensity.setter
    def PLDensity(self, value: float) -> None: ...
    @PLMeanPath.setter
    def PLMeanPath(self, value: float) -> None: ...
    @QuantumYield.setter
    def QuantumYield(self, value: str) -> None: ...
    @Threshold.setter
    def Threshold(self, value: float) -> None: ...
    @UseMieDensity.setter
    def UseMieDensity(self, value: bool) -> None: ...

class IVolumePhysicsModelSettings:
    @property
    def _S_AngleScattering(self) -> IVMPS_AngleScattering: ...
    @property
    def _S_DLLDefinedScattering(self) -> IVMPS_DLLDefinedScattering: ...
    @property
    def _S_None(self) -> IVPMS_None: ...
    @property
    def _S_PhotoluminescenceModel(self) -> IVMPS_PhotoluminscenceModel: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def Type(self) -> VolumePhysicsModelType: ...

class IVPMS_None(IVolumePhysicsModelSettings):
    pass

class NCEIndexType:
    Isotropic = 0
    Birefringent = 1
    GRIN = 2

class ObjectColumn:
    Comment = 1
    RefObject = 2
    InsideOf = 3
    XPosition = 4
    YPosition = 5
    ZPosition = 6
    TiltX = 7
    TiltY = 8
    TiltZ = 9
    Material = 10
    Par1 = 11
    Par2 = 12
    Par3 = 13
    Par4 = 14
    Par5 = 15
    Par6 = 16
    Par7 = 17
    Par8 = 18
    Par9 = 19
    Par10 = 20
    Par11 = 21
    Par12 = 22
    Par13 = 23
    Par14 = 24
    Par15 = 25
    Par16 = 26
    Par17 = 27
    Par18 = 28
    Par19 = 29
    Par20 = 30
    Par21 = 31
    Par22 = 32
    Par23 = 33
    Par24 = 34
    Par25 = 35
    Par26 = 36
    Par27 = 37
    Par28 = 38
    Par29 = 39
    Par30 = 40
    Par31 = 41
    Par32 = 42
    Par33 = 43
    Par34 = 44
    Par35 = 45
    Par36 = 46
    Par37 = 47
    Par38 = 48
    Par39 = 49
    Par40 = 50
    Par41 = 51
    Par42 = 52
    Par43 = 53
    Par44 = 54
    Par45 = 55
    Par46 = 56
    Par47 = 57
    Par48 = 58
    Par49 = 59
    Par50 = 60
    Par51 = 61
    Par52 = 62
    Par53 = 63
    Par54 = 64
    Par55 = 65
    Par56 = 66
    Par57 = 67
    Par58 = 68
    Par59 = 69
    Par60 = 70
    Par61 = 71
    Par62 = 72
    Par63 = 73
    Par64 = 74
    Par65 = 75
    Par66 = 76
    Par67 = 77
    Par68 = 78
    Par69 = 79
    Par70 = 80
    Par71 = 81
    Par72 = 82
    Par73 = 83
    Par74 = 84
    Par75 = 85
    Par76 = 86
    Par77 = 87
    Par78 = 88
    Par79 = 89
    Par80 = 90
    Par81 = 91
    Par82 = 92
    Par83 = 93
    Par84 = 94
    Par85 = 95
    Par86 = 96
    Par87 = 97
    Par88 = 98
    Par89 = 99
    Par90 = 100
    Par91 = 101
    Par92 = 102
    Par93 = 103
    Par94 = 104
    Par95 = 105
    Par96 = 106
    Par97 = 107
    Par98 = 108
    Par99 = 109
    Par100 = 110
    Par101 = 111
    Par102 = 112
    Par103 = 113
    Par104 = 114
    Par105 = 115
    Par106 = 116
    Par107 = 117
    Par108 = 118
    Par109 = 119
    Par110 = 120
    Par111 = 121
    Par112 = 122
    Par113 = 123
    Par114 = 124
    Par115 = 125
    Par116 = 126
    Par117 = 127
    Par118 = 128
    Par119 = 129
    Par120 = 130
    Par121 = 131
    Par122 = 132
    Par123 = 133
    Par124 = 134
    Par125 = 135
    Par126 = 136
    Par127 = 137
    Par128 = 138
    Par129 = 139
    Par130 = 140
    Par131 = 141
    Par132 = 142
    Par133 = 143
    Par134 = 144
    Par135 = 145
    Par136 = 146
    Par137 = 147
    Par138 = 148
    Par139 = 149
    Par140 = 150
    Par141 = 151
    Par142 = 152
    Par143 = 153
    Par144 = 154
    Par145 = 155
    Par146 = 156
    Par147 = 157
    Par148 = 158
    Par149 = 159
    Par150 = 160
    Par151 = 161
    Par152 = 162
    Par153 = 163
    Par154 = 164
    Par155 = 165
    Par156 = 166
    Par157 = 167
    Par158 = 168
    Par159 = 169
    Par160 = 170
    Par161 = 171
    Par162 = 172
    Par163 = 173
    Par164 = 174
    Par165 = 175
    Par166 = 176
    Par167 = 177
    Par168 = 178
    Par169 = 179
    Par170 = 180
    Par171 = 181
    Par172 = 182
    Par173 = 183
    Par174 = 184
    Par175 = 185
    Par176 = 186
    Par177 = 187
    Par178 = 188
    Par179 = 189
    Par180 = 190
    Par181 = 191
    Par182 = 192
    Par183 = 193
    Par184 = 194
    Par185 = 195
    Par186 = 196
    Par187 = 197
    Par188 = 198
    Par189 = 199
    Par190 = 200
    Par191 = 201
    Par192 = 202
    Par193 = 203
    Par194 = 204
    Par195 = 205
    Par196 = 206
    Par197 = 207
    Par198 = 208
    Par199 = 209
    Par200 = 210
    Par201 = 211
    Par202 = 212
    Par203 = 213
    Par204 = 214
    Par205 = 215
    Par206 = 216
    Par207 = 217
    Par208 = 218
    Par209 = 219
    Par210 = 220
    Par211 = 221
    Par212 = 222
    Par213 = 223
    Par214 = 224
    Par215 = 225
    Par216 = 226
    Par217 = 227
    Par218 = 228
    Par219 = 229
    Par220 = 230
    Par221 = 231
    Par222 = 232
    Par223 = 233
    Par224 = 234
    Par225 = 235
    Par226 = 236
    Par227 = 237
    Par228 = 238
    Par229 = 239
    Par230 = 240
    Par231 = 241
    Par232 = 242
    Par233 = 243
    Par234 = 244
    Par235 = 245
    Par236 = 246
    Par237 = 247
    Par238 = 248
    Par239 = 249
    Par240 = 250
    Par241 = 251
    Par242 = 252
    Par243 = 253
    Par244 = 254
    Par245 = 255
    Par246 = 256
    Par247 = 257
    Par248 = 258
    Par249 = 259
    Par250 = 260

class ObjectScatteringTypes:
    # None = 0
    Lambertian = 1
    Gaussian = 2
    ABg = 3
    ABgFile = 4
    BSDF = 5
    ISScatterCatalog = 6
    User = 7

class ObjectType:
    AnnularAsphericLens = 0
    AnnularAxialLens = 1
    AnnularVolume = 2
    Annulus = 3
    Array = 4
    ArrayRing = 5
    AsphericSurface = 6
    AsphericSurface2 = 7
    AxiconSurface = 8
    BiconicLens = 9
    BiconicSurface = 10
    BiconicZernike = 11
    BiconicZernikeSurface = 12
    Binary1 = 13
    Binary2 = 14
    Binary2A = 15
    Boolean = 16
    BooleanCAD = 16
    CADAssemblyAutodeskInventor = 17
    CADAssemblyCreoParametric = 18
    CADAssemblySolidWorks = 19
    CADPartAutodeskInventor = 20
    CADPartCreoParametric = 21
    CADPartSolidWorks = 22
    CADPartSTEPIGESSAT = 23
    CADPartSTL = 24
    CADPartZPD = 25
    Cone = 26
    CPC = 27
    CPCRectangular = 28
    CylinderPipe = 29
    CylinderVolume = 30
    Cylinder2Pipe = 31
    Cylinder2Volume = 32
    DetectorColor = 33
    DetectorPolar = 34
    DetectorRectangle = 35
    DetectorSurface = 36
    DetectorVolume = 37
    DiffractionGrating = 38
    DualBEFSurface = 39
    Ellipse = 40
    EllipticalVolume = 41
    EvenAsphereLens = 42
    ExtendedOddAsphereLens = 43
    ExtendedPolynomialLens = 44
    ExtendedPolynomialSurface = 45
    Extruded = 46
    FacetedSurface = 47
    FreeformZ = 48
    Fresnel1 = 49
    Fresnel2 = 50
    GridSagLens = 51
    GridSagSurface = 52
    GridSagFrontBack = 53
    HexagonalLensletArray = 54
    HologramLens = 55
    HologramSurface = 56
    JonesMatrix = 57
    LensletArray1 = 58
    LensletArray2 = 59
    MEMS = 60
    NullObject = 61
    OddAsphereLens = 62
    ParaxialLens = 63
    PolygonObject = 64
    RayRotator = 65
    RectangularCorner = 66
    Rectangle = 67
    RectangularPipe = 68
    RectangularPipeGrating = 69
    RectangularRoof = 70
    RectangularTorusSurface = 71
    RectangularTorusVolume = 72
    RectangularVolume = 73
    RectangularVolumeGrating = 74
    ReverseRadianceDetector = 75
    ReverseRadianceTarget = 76
    Slide = 77
    SourceDiffractive = 78
    SourceDiode = 79
    SourceDLL = 80
    SourceEllipse = 81
    SourceEULUMDATFile = 82
    SourceFilament = 83
    SourceFile = 84
    SourceGaussian = 85
    SourceIESNAFile = 86
    SourceImported = 87
    SourceObject = 88
    SourcePoint = 89
    SourceRadial = 90
    SourceRay = 91
    SourceRectangle = 92
    SourceTube = 93
    SourceTwoAngle = 94
    SourceVolumeCylindrical = 95
    SourceVolumeElliptical = 96
    SourceVolumeRectangular = 97
    Sphere = 98
    StandardLens = 99
    StandardSurface = 100
    Swept = 101
    TabulatedFactedRadial = 102
    TabulatedFactedToroid = 103
    TabulatedFrenselRadial = 104
    ToroidalHologram = 105
    ToroidalLens = 106
    ToroidalSurface = 107
    ToroidalSurfaceOddASphere = 108
    TorusSurface = 109
    TorusVolume = 110
    TriangularCorner = 111
    Triangle = 112
    UserDefinedObject = 113
    WolterSurface = 114
    ZernikeSurface = 115
    BooleanNative = 116
    CompoundLens = 117
    QTypeAsphereSurface = 118
    OffAxisMirror = 119

class OrderChoices:
    Before = 0
    After = 1

class PixelAddressing:
    ByRow = 0
    ByColumn = 1
    Individually = 2

class PolarDetectorDataType:
    Power = 1
    PowerSolidAngle = 2
    Lumens = 3
    LumensSolidAngle = 4
    Cx = 5
    Cy = 6
    u_T = 7
    u_V = 8
    TriX = 9
    TriY = 10
    TriZ = 11

class RaysIgnoreObjectType:
    Never = 0
    Always = 1
    OnLaunch = 2

class RayTraceModes:
    Standard = 0
    Flat = 1
    Shaded = 2
    Kernel = 3

class ScatterToType:
    ScatterToList = 0
    ImportanceSampling = 1

class ShapeChoices:
    Rectangular = 0
    Elliptical = 1

class SourceBulkScatterMode:
    Many = 0
    Once = 1
    Never = 2

class SourceColorMode:
    SystemWavelengths = 0
    CIE1931Tristimulus = 1
    CIE1931Chromaticity = 2
    CIE1931RGB = 3
    UniformPowerSpectrum = 4
    D65White = 5
    ColorTemperature = 6
    BlackBodySpectrum = 7
    SpectrumFile = 8
    CIE1976 = 9

class SourceSamplingMethod:
    Random = 0
    Sobol = 1

class UniformAngleChoices:
    UniformIrradiance = 0
    UniformInAngleSpace = 1

class VolumePhysicsModelType:
    # None = 0
    AngleScattering = 1
    DLLDefinedScattering = 2
    PhotoluminescenceModel = 3
