"""
This file provides autocompletions for the ZOS-API and was automatically generated.
It should not be edited manually.
"""

from __future__ import annotations

from zospy.api._ZOSAPI.Common import ZemaxColor
from zospy.api._ZOSAPI.Editors import IEditor, IEditorCell, IEditorRow
from zospy.api._ZOSAPI.Wizards import INSCToleranceWizard, ISEQToleranceWizard

__all__ = ("ITDERow", "IToleranceDataEditor", "ToleranceColumn", "ToleranceOperandType")

class ITDERow(IEditorRow):
    def AvailableOperandTypes(self) -> list[ToleranceOperandType]: ...
    def ChangeType(self, type: ToleranceOperandType) -> bool: ...
    @property
    def Comment(self) -> str: ...
    @property
    def CommentCell(self) -> IEditorCell: ...
    @property
    def DoNotAdjustDuringInverseTolerancing(self) -> bool: ...
    @property
    def IgnoreThisOperandDuringTolerancing(self) -> bool: ...
    @property
    def IsActive(self) -> bool: ...
    @property
    def IsMaxUsed(self) -> bool: ...
    @property
    def IsMinUsed(self) -> bool: ...
    @property
    def IsNominalUsed(self) -> bool: ...
    @property
    def IsParam1Used(self) -> bool: ...
    @property
    def IsParam2Used(self) -> bool: ...
    @property
    def IsParam3Used(self) -> bool: ...
    @property
    def Max(self) -> float: ...
    @property
    def MaxCell(self) -> IEditorCell: ...
    @property
    def Min(self) -> float: ...
    @property
    def MinCell(self) -> IEditorCell: ...
    @property
    def Nominal(self) -> float: ...
    @property
    def NominalCell(self) -> IEditorCell: ...
    @property
    def OperandNumber(self) -> int: ...
    @property
    def Param1(self) -> int: ...
    @property
    def Param1Cell(self) -> IEditorCell: ...
    @property
    def Param2(self) -> int: ...
    @property
    def Param2Cell(self) -> IEditorCell: ...
    @property
    def Param3(self) -> int: ...
    @property
    def Param3Cell(self) -> IEditorCell: ...
    @property
    def RowColor(self) -> ZemaxColor: ...
    @property
    def Type(self) -> ToleranceOperandType: ...
    @property
    def TypeName(self) -> str: ...
    def GetOperandCell(self, Col: ToleranceColumn) -> IEditorCell: ...
    @Comment.setter
    def Comment(self, value: str) -> None: ...
    @DoNotAdjustDuringInverseTolerancing.setter
    def DoNotAdjustDuringInverseTolerancing(self, value: bool) -> None: ...
    @IgnoreThisOperandDuringTolerancing.setter
    def IgnoreThisOperandDuringTolerancing(self, value: bool) -> None: ...
    @Max.setter
    def Max(self, value: float) -> None: ...
    @Min.setter
    def Min(self, value: float) -> None: ...
    @Param1.setter
    def Param1(self, value: int) -> None: ...
    @Param2.setter
    def Param2(self, value: int) -> None: ...
    @Param3.setter
    def Param3(self, value: int) -> None: ...
    @RowColor.setter
    def RowColor(self, value: ZemaxColor) -> None: ...

class IToleranceDataEditor(IEditor):
    def AddOperand(self) -> ITDERow: ...
    def CopyOperands(self, fromOperandNumber: int, NumberOfOperands: int, toOperandNumber: int) -> int: ...
    def CopyOperandsFrom(
        self, fromEditor: IToleranceDataEditor, fromOperandNumber: int, NumberOfOperands: int, toOperandNumber: int
    ) -> int: ...
    @property
    def FirstColumn(self) -> ToleranceColumn: ...
    @property
    def LastColumn(self) -> ToleranceColumn: ...
    @property
    def NSCToleranceWizard(self) -> INSCToleranceWizard: ...
    @property
    def NumberOfOperands(self) -> int: ...
    @property
    def RowToOperandOffset(self) -> int: ...
    @property
    def SEQToleranceWizard(self) -> ISEQToleranceWizard: ...
    def GetOperandAt(self, OperandNumber: int) -> ITDERow: ...
    def HideTDE(self) -> None: ...
    def InsertNewOperandAt(self, OperandNumber: int) -> ITDERow: ...
    def LoadToleranceFile(self, fileName: str) -> bool: ...
    def RemoveOperandAt(self, OperandNumber: int) -> bool: ...
    def RemoveOperandsAt(self, OperandNumber: int, numOperands: int) -> int: ...
    def SaveToleranceFile(self, fileName: str) -> None: ...
    def ShowTDE(self) -> bool: ...

class ToleranceColumn:
    Param1 = 2
    Param2 = 3
    Param3 = 4
    Nominal = 5
    Min = 6
    Max = 7
    Comment = 8

class ToleranceOperandType:
    TOFF = 0
    TRAD = 1
    TCUR = 2
    TFRN = 3
    TTHI = 4
    TCON = 5
    TSDI = 6
    TSDX = 7
    TSDY = 8
    TSDR = 9
    TSTX = 10
    TSTY = 11
    TIRX = 12
    TIRY = 13
    TIRR = 14
    TPAR = 15
    TEDV = 16
    TEDX = 17
    TEDY = 18
    TEDR = 19
    TETX = 20
    TETY = 21
    TETZ = 22
    TUDX = 23
    TUDY = 24
    TUTX = 25
    TUTY = 26
    TUTZ = 27
    TIND = 28
    TABB = 29
    TEXI = 30
    SAVE = 31
    COMP = 32
    CPAR = 33
    CEDV = 34
    CMCO = 35
    STAT = 36
    TWAV = 37
    TNPS = 38
    TNPA = 39
    TMCO = 40
    TEZI = 41
    TCMU = 42
    SEED = 43
    COMM = 44
    TPAI = 45
    TCIO = 46
    TCEO = 47
    TNMA = 48
    CNPA = 49
    CNPS = 50
    TRLX = 51
    TRLY = 52
    TRLR = 53
    TARX = 54
    TARY = 55
    TARR = 56
