"""
This file provides autocompletions for the ZOS-API and was automatically generated.
It should not be edited manually.
"""

from __future__ import annotations

from zospy.api._ZOSAPI.Analysis import IMessage
from zospy.api._ZOSAPI.Editors import ISolveData, SolveStatus, SolveType

__all__ = (
    "FieldColumn",
    "FieldNormalizationType",
    "FieldPattern",
    "FieldType",
    "FNumberComputationType",
    "HuygensIntegralSettings",
    "IField",
    "IField",
    "IFields",
    "IFields",
    "ISDAdvancedData",
    "ISDAdvancedData",
    "ISDApertureData",
    "ISDApertureData",
    "ISDEnvironmentData",
    "ISDEnvironmentData",
    "ISDFiles",
    "ISDFiles",
    "ISDMaterialCatalogData",
    "ISDMaterialCatalogData",
    "ISDNamedFilters",
    "ISDNamedFilters",
    "ISDNonSeqData",
    "ISDNonSeqData",
    "ISDPolarizationData",
    "ISDPolarizationData",
    "ISDRayAimingData",
    "ISDRayAimingData",
    "ISDTitleNotes",
    "ISDTitleNotes",
    "ISDUnitsData",
    "ISDUnitsData",
    "ISurfaceSelection",
    "ISurfaceSelection",
    "ISystemData",
    "ISystemData",
    "IWavelength",
    "IWavelength",
    "IWavelengths",
    "IWavelengths",
    "ParaxialRaysSetting",
    "PolarizationMethod",
    "QuadratureSteps",
    "RayAimingMethod",
    "ReferenceOPDSetting",
    "WavelengthPreset",
    "ZemaxAfocalModeUnits",
    "ZemaxAnalysisUnits",
    "ZemaxApertureType",
    "ZemaxApodizationType",
    "ZemaxMTFUnits",
    "ZemaxSourceUnits",
    "ZemaxSystemUnits",
    "ZemaxUnitPrefix",
)

class FieldColumn:
    Comment = 0
    X = 1
    Y = 2
    Weight = 3
    VDX = 4
    VDY = 5
    VCX = 6
    VCY = 7
    TAN = 8
    VAN = 8

class FieldNormalizationType:
    Radial = 0
    Rectangular = 1

class FieldPattern:
    UniformY = 0
    EqualAreaY = 1
    UniformX = 2
    EqualAreaX = 3
    Grid = 4
    UniformRadial = 5
    EqualAreaRadial = 6

class FieldType:
    Angle = 0
    ObjectHeight = 1
    ParaxialImageHeight = 2
    RealImageHeight = 3
    TheodoliteAngle = 4

class FNumberComputationType:
    TracingRays = 0
    PupilSizePosition = 1

class HuygensIntegralSettings:
    Auto = 0
    Planar = 1
    Spherical = 2

class IField:
    @property
    def Comment(self) -> str: ...
    @property
    def FieldNumber(self) -> int: ...
    @property
    def Ignore(self) -> bool: ...
    @property
    def IsActive(self) -> bool: ...
    @property
    def TAN(self) -> float: ...
    @property
    def VAN(self) -> float: ...
    @property
    def VCX(self) -> float: ...
    @property
    def VCY(self) -> float: ...
    @property
    def VDX(self) -> float: ...
    @property
    def VDY(self) -> float: ...
    @property
    def Weight(self) -> float: ...
    @property
    def X(self) -> float: ...
    @property
    def XSolve(self) -> SolveType: ...
    @property
    def Y(self) -> float: ...
    @property
    def YSolve(self) -> SolveType: ...
    def GetSolveData(self, forColumn: FieldColumn) -> ISolveData: ...
    def GetXSolveData(self) -> ISolveData: ...
    def GetYSolveData(self) -> ISolveData: ...
    @Comment.setter
    def Comment(self, value: str) -> None: ...
    @Ignore.setter
    def Ignore(self, value: bool) -> None: ...
    @TAN.setter
    def TAN(self, value: float) -> None: ...
    @VAN.setter
    def VAN(self, value: float) -> None: ...
    @VCX.setter
    def VCX(self, value: float) -> None: ...
    @VCY.setter
    def VCY(self, value: float) -> None: ...
    @VDX.setter
    def VDX(self, value: float) -> None: ...
    @VDY.setter
    def VDY(self, value: float) -> None: ...
    @Weight.setter
    def Weight(self, value: float) -> None: ...
    @X.setter
    def X(self, value: float) -> None: ...
    @Y.setter
    def Y(self, value: float) -> None: ...
    def SetFixed(self, forColumn: FieldColumn) -> SolveStatus: ...
    def SetPickup(
        self, forColumn: FieldColumn, fromField: int, fromColumn: FieldColumn, scale: float, offset: float
    ) -> SolveStatus: ...
    def SetXFixed(self) -> SolveStatus: ...
    def SetXPickup(self, fromField: int, fromColumn: FieldColumn, scale: float, offset: float) -> SolveStatus: ...
    def SetYFixed(self) -> SolveStatus: ...
    def SetYPickup(self, fromField: int, fromColumn: FieldColumn, scale: float, offset: float) -> SolveStatus: ...

class IFields:
    def AddField(self, X: float, Y: float, Weight: float) -> IField: ...
    def ApplyFieldWizard(
        self,
        pattern: FieldPattern,
        numberOfYFields: int,
        maxFieldY: float,
        numberOfXFields: int,
        maxFieldX: float,
        startAt: int,
        overwrite: bool,
        includePickups: bool,
    ) -> IMessage: ...
    def ClearVignetting(self) -> None: ...
    def ConvertToFieldType(self, type: FieldType) -> IMessage: ...
    def DeleteAllFields(self) -> int: ...
    def DeleteFieldAt(self, fieldNumber: int) -> bool: ...
    def DeleteFieldsAt(self, fieldNumber: int, numberOfFields: int) -> int: ...
    @property
    def Normalization(self) -> FieldNormalizationType: ...
    @property
    def NumberOfFields(self) -> int: ...
    def GetField(self, position: int) -> IField: ...
    def GetFieldType(self) -> FieldType: ...
    def InsertFieldAt(self, fieldNumber: int) -> IField: ...
    def RemoveField(self, position: int) -> bool: ...
    @Normalization.setter
    def Normalization(self, value: FieldNormalizationType) -> None: ...
    def SetFieldType(self, type: FieldType) -> None: ...
    def SetVignetting(self) -> None: ...

class ISDAdvancedData:
    @property
    def DontPrintCoordinateBreakData(self) -> bool: ...
    @property
    def FNumMethod(self) -> FNumberComputationType: ...
    @property
    def HuygensIntegralMethod(self) -> HuygensIntegralSettings: ...
    @property
    def IncludeCalculatedDataInSessionFile(self) -> bool: ...
    @property
    def IncludeToleranceDataInSessionFile(self) -> bool: ...
    @property
    def OPDModulo2PI(self) -> bool: ...
    @property
    def ParaxialRays(self) -> ParaxialRaysSetting: ...
    @property
    def ReferenceOPD(self) -> ReferenceOPDSetting: ...
    @property
    def TurnOffThreading(self) -> bool: ...
    @DontPrintCoordinateBreakData.setter
    def DontPrintCoordinateBreakData(self, value: bool) -> None: ...
    @FNumMethod.setter
    def FNumMethod(self, value: FNumberComputationType) -> None: ...
    @HuygensIntegralMethod.setter
    def HuygensIntegralMethod(self, value: HuygensIntegralSettings) -> None: ...
    @IncludeCalculatedDataInSessionFile.setter
    def IncludeCalculatedDataInSessionFile(self, value: bool) -> None: ...
    @IncludeToleranceDataInSessionFile.setter
    def IncludeToleranceDataInSessionFile(self, value: bool) -> None: ...
    @OPDModulo2PI.setter
    def OPDModulo2PI(self, value: bool) -> None: ...
    @ParaxialRays.setter
    def ParaxialRays(self, value: ParaxialRaysSetting) -> None: ...
    @ReferenceOPD.setter
    def ReferenceOPD(self, value: ReferenceOPDSetting) -> None: ...
    @TurnOffThreading.setter
    def TurnOffThreading(self, value: bool) -> None: ...

class ISDApertureData:
    @property
    def AFocalImageSpace(self) -> bool: ...
    @property
    def ApertureType(self) -> ZemaxApertureType: ...
    @property
    def ApertureValue(self) -> float: ...
    @property
    def ApodizationFactor(self) -> float: ...
    @property
    def ApodizationFactorIsUsed(self) -> bool: ...
    @property
    def ApodizationType(self) -> ZemaxApodizationType: ...
    @property
    def CheckGRINApertures(self) -> bool: ...
    @property
    def FastSemiDiameters(self) -> bool: ...
    @property
    def GCRS(self) -> ISurfaceSelection: ...
    @property
    def IterateSolvesWhenUpdating(self) -> bool: ...
    @property
    def SemiDiameterMargin(self) -> float: ...
    @property
    def SemiDiameterMarginPct(self) -> float: ...
    @property
    def TelecentricObjectSpace(self) -> bool: ...
    @AFocalImageSpace.setter
    def AFocalImageSpace(self, value: bool) -> None: ...
    @ApertureType.setter
    def ApertureType(self, value: ZemaxApertureType) -> None: ...
    @ApertureValue.setter
    def ApertureValue(self, value: float) -> None: ...
    @ApodizationFactor.setter
    def ApodizationFactor(self, value: float) -> None: ...
    @ApodizationType.setter
    def ApodizationType(self, value: ZemaxApodizationType) -> None: ...
    @CheckGRINApertures.setter
    def CheckGRINApertures(self, value: bool) -> None: ...
    @FastSemiDiameters.setter
    def FastSemiDiameters(self, value: bool) -> None: ...
    @IterateSolvesWhenUpdating.setter
    def IterateSolvesWhenUpdating(self, value: bool) -> None: ...
    @SemiDiameterMargin.setter
    def SemiDiameterMargin(self, value: float) -> None: ...
    @SemiDiameterMarginPct.setter
    def SemiDiameterMarginPct(self, value: float) -> None: ...
    @TelecentricObjectSpace.setter
    def TelecentricObjectSpace(self, value: bool) -> None: ...

class ISDEnvironmentData:
    @property
    def AdjustIndexToEnvironment(self) -> bool: ...
    @property
    def Pressure(self) -> float: ...
    @property
    def Temperature(self) -> float: ...
    @AdjustIndexToEnvironment.setter
    def AdjustIndexToEnvironment(self, value: bool) -> None: ...
    @Pressure.setter
    def Pressure(self, value: float) -> None: ...
    @Temperature.setter
    def Temperature(self, value: float) -> None: ...

class ISDFiles:
    @property
    def ABgDataFile(self) -> str: ...
    @property
    def CoatingFile(self) -> str: ...
    @property
    def GradiumProfile(self) -> str: ...
    @property
    def ScatterProfile(self) -> str: ...
    def GetABgDataFiles(self) -> list[str]: ...
    def GetCoatingFiles(self) -> list[str]: ...
    def GetGradiumProfiles(self) -> list[str]: ...
    def GetScatterProfiles(self) -> list[str]: ...
    def ReloadFiles(self) -> None: ...
    @ABgDataFile.setter
    def ABgDataFile(self, value: str) -> None: ...
    @CoatingFile.setter
    def CoatingFile(self, value: str) -> None: ...
    @GradiumProfile.setter
    def GradiumProfile(self, value: str) -> None: ...
    @ScatterProfile.setter
    def ScatterProfile(self, value: str) -> None: ...

class ISDMaterialCatalogData:
    def AddCatalog(self, catalog: str) -> bool: ...
    def GetAvailableCatalogs(self) -> list[str]: ...
    def GetCatalogsInUse(self) -> list[str]: ...
    def GetMaterialsInCatalog(self, catalog: str) -> list[str]: ...
    def IsCatalogInUse(self, catalog: str) -> bool: ...
    def RemoveCatalog(self, catalog: str) -> bool: ...

class ISDNamedFilters:
    @property
    def NamedFilters(self) -> str: ...
    @NamedFilters.setter
    def NamedFilters(self, value: str) -> None: ...

class ISDNonSeqData:
    @property
    def GlueDistanceInLensUnits(self) -> float: ...
    @property
    def MaximumIntersectionsPerRay(self) -> int: ...
    @property
    def MaximumNestedTouchingObjects(self) -> int: ...
    @property
    def MaximumSegmentsPerRay(self) -> int: ...
    @property
    def MaximumSourceFileRaysInMemory(self) -> int: ...
    @property
    def MinimumAbsoluteRayIntensity(self) -> float: ...
    @property
    def MinimumRelativeRayIntensity(self) -> float: ...
    @property
    def MissedRayDrawDistanceInLensUnits(self) -> float: ...
    @property
    def RetraceSourceRaysUponFileOpen(self) -> bool: ...
    @property
    def SimpleRaySplitting(self) -> bool: ...
    @GlueDistanceInLensUnits.setter
    def GlueDistanceInLensUnits(self, value: float) -> None: ...
    @MaximumIntersectionsPerRay.setter
    def MaximumIntersectionsPerRay(self, value: int) -> None: ...
    @MaximumNestedTouchingObjects.setter
    def MaximumNestedTouchingObjects(self, value: int) -> None: ...
    @MaximumSegmentsPerRay.setter
    def MaximumSegmentsPerRay(self, value: int) -> None: ...
    @MaximumSourceFileRaysInMemory.setter
    def MaximumSourceFileRaysInMemory(self, value: int) -> None: ...
    @MinimumAbsoluteRayIntensity.setter
    def MinimumAbsoluteRayIntensity(self, value: float) -> None: ...
    @MinimumRelativeRayIntensity.setter
    def MinimumRelativeRayIntensity(self, value: float) -> None: ...
    @MissedRayDrawDistanceInLensUnits.setter
    def MissedRayDrawDistanceInLensUnits(self, value: float) -> None: ...
    @RetraceSourceRaysUponFileOpen.setter
    def RetraceSourceRaysUponFileOpen(self, value: bool) -> None: ...
    @SimpleRaySplitting.setter
    def SimpleRaySplitting(self, value: bool) -> None: ...

class ISDPolarizationData:
    @property
    def ConvertThinFilmPhaseToRayEquivalent(self) -> bool: ...
    @property
    def Jx(self) -> float: ...
    @property
    def Jy(self) -> float: ...
    @property
    def Method(self) -> PolarizationMethod: ...
    @property
    def Unpolarized(self) -> bool: ...
    @property
    def XPhase(self) -> float: ...
    @property
    def YPhase(self) -> float: ...
    @ConvertThinFilmPhaseToRayEquivalent.setter
    def ConvertThinFilmPhaseToRayEquivalent(self, value: bool) -> None: ...
    @Jx.setter
    def Jx(self, value: float) -> None: ...
    @Jy.setter
    def Jy(self, value: float) -> None: ...
    @Method.setter
    def Method(self, value: PolarizationMethod) -> None: ...
    @Unpolarized.setter
    def Unpolarized(self, value: bool) -> None: ...
    @XPhase.setter
    def XPhase(self, value: float) -> None: ...
    @YPhase.setter
    def YPhase(self, value: float) -> None: ...

class ISDRayAimingData:
    @property
    def AutomaticallyCalculatePupilShiftsIsChecked(self) -> bool: ...
    @property
    def NumStepsCacheSetup(self) -> int: ...
    @property
    def PupilCompressX(self) -> float: ...
    @property
    def PupilCompressY(self) -> float: ...
    @property
    def PupilShiftX(self) -> float: ...
    @property
    def PupilShiftY(self) -> float: ...
    @property
    def PupilShiftZ(self) -> float: ...
    @property
    def RayAiming(self) -> RayAimingMethod: ...
    @property
    def ScalePupilShiftFactorsByField(self) -> bool: ...
    @property
    def UseAdvancedConvergence(self) -> bool: ...
    @property
    def UseEnhancedRayAiming(self) -> bool: ...
    @property
    def UseFallBackSearchDuringCacheSetup(self) -> bool: ...
    @property
    def UseRayAimingCache(self) -> bool: ...
    @property
    def UseRobustRayAiming(self) -> bool: ...
    @AutomaticallyCalculatePupilShiftsIsChecked.setter
    def AutomaticallyCalculatePupilShiftsIsChecked(self, value: bool) -> None: ...
    @NumStepsCacheSetup.setter
    def NumStepsCacheSetup(self, value: int) -> None: ...
    @PupilCompressX.setter
    def PupilCompressX(self, value: float) -> None: ...
    @PupilCompressY.setter
    def PupilCompressY(self, value: float) -> None: ...
    @PupilShiftX.setter
    def PupilShiftX(self, value: float) -> None: ...
    @PupilShiftY.setter
    def PupilShiftY(self, value: float) -> None: ...
    @PupilShiftZ.setter
    def PupilShiftZ(self, value: float) -> None: ...
    @RayAiming.setter
    def RayAiming(self, value: RayAimingMethod) -> None: ...
    @ScalePupilShiftFactorsByField.setter
    def ScalePupilShiftFactorsByField(self, value: bool) -> None: ...
    @UseAdvancedConvergence.setter
    def UseAdvancedConvergence(self, value: bool) -> None: ...
    @UseEnhancedRayAiming.setter
    def UseEnhancedRayAiming(self, value: bool) -> None: ...
    @UseFallBackSearchDuringCacheSetup.setter
    def UseFallBackSearchDuringCacheSetup(self, value: bool) -> None: ...
    @UseRayAimingCache.setter
    def UseRayAimingCache(self, value: bool) -> None: ...
    @UseRobustRayAiming.setter
    def UseRobustRayAiming(self, value: bool) -> None: ...

class ISDTitleNotes:
    @property
    def Author(self) -> str: ...
    @property
    def Notes(self) -> str: ...
    @property
    def Title(self) -> str: ...
    @Author.setter
    def Author(self, value: str) -> None: ...
    @Notes.setter
    def Notes(self, value: str) -> None: ...
    @Title.setter
    def Title(self, value: str) -> None: ...

class ISDUnitsData:
    @property
    def AfocalModeUnits(self) -> ZemaxAfocalModeUnits: ...
    @property
    def AnalysisUnitPrefix(self) -> ZemaxUnitPrefix: ...
    @property
    def AnalysisUnits(self) -> ZemaxAnalysisUnits: ...
    @property
    def LensUnits(self) -> ZemaxSystemUnits: ...
    @property
    def MTFUnits(self) -> ZemaxMTFUnits: ...
    @property
    def SourceUnitPrefix(self) -> ZemaxUnitPrefix: ...
    @property
    def SourceUnits(self) -> ZemaxSourceUnits: ...
    @AfocalModeUnits.setter
    def AfocalModeUnits(self, value: ZemaxAfocalModeUnits) -> None: ...
    @AnalysisUnitPrefix.setter
    def AnalysisUnitPrefix(self, value: ZemaxUnitPrefix) -> None: ...
    @AnalysisUnits.setter
    def AnalysisUnits(self, value: ZemaxAnalysisUnits) -> None: ...
    @LensUnits.setter
    def LensUnits(self, value: ZemaxSystemUnits) -> None: ...
    @MTFUnits.setter
    def MTFUnits(self, value: ZemaxMTFUnits) -> None: ...
    @SourceUnitPrefix.setter
    def SourceUnitPrefix(self, value: ZemaxUnitPrefix) -> None: ...
    @SourceUnits.setter
    def SourceUnits(self, value: ZemaxSourceUnits) -> None: ...

class ISurfaceSelection:
    @property
    def FirstAllowedSurface(self) -> int: ...
    @property
    def ImageSurface(self) -> int: ...
    @property
    def LastAllowedSurface(self) -> int: ...
    @property
    def StopSurface(self) -> int: ...
    def GetSelectedSurface(self) -> int: ...
    def SetSelectedSurface(self, Surface: int) -> bool: ...
    def UseImageSurface(self) -> bool: ...
    def UseObjectSurface(self) -> bool: ...
    def UseStopSurface(self) -> bool: ...

class ISystemData:
    @property
    def Advanced(self) -> ISDAdvancedData: ...
    @property
    def Aperture(self) -> ISDApertureData: ...
    @property
    def Environment(self) -> ISDEnvironmentData: ...
    @property
    def Fields(self) -> IFields: ...
    @property
    def Files(self) -> ISDFiles: ...
    @property
    def MaterialCatalogs(self) -> ISDMaterialCatalogData: ...
    @property
    def NamedFiltersData(self) -> ISDNamedFilters: ...
    @property
    def NonSequentialData(self) -> ISDNonSeqData: ...
    @property
    def Polarization(self) -> ISDPolarizationData: ...
    @property
    def RayAiming(self) -> ISDRayAimingData: ...
    @property
    def TitleNotes(self) -> ISDTitleNotes: ...
    @property
    def Units(self) -> ISDUnitsData: ...
    @property
    def Wavelengths(self) -> IWavelengths: ...

class IWavelength:
    @property
    def IsActive(self) -> bool: ...
    @property
    def IsPrimary(self) -> bool: ...
    @property
    def Wavelength(self) -> float: ...
    @property
    def WavelengthNumber(self) -> int: ...
    @property
    def Weight(self) -> float: ...
    def MakePrimary(self) -> None: ...
    @Wavelength.setter
    def Wavelength(self, value: float) -> None: ...
    @Weight.setter
    def Weight(self, value: float) -> None: ...

class IWavelengths:
    def AddWavelength(self, Wavelength: float, Weight: float) -> IWavelength: ...
    def GaussianQuadrature(self, minWave: float, maxWave: float, numSteps: QuadratureSteps) -> bool: ...
    @property
    def NumberOfWavelengths(self) -> int: ...
    def GetWavelength(self, position: int) -> IWavelength: ...
    def RemoveWavelength(self, position: int) -> bool: ...
    def SelectWavelengthPreset(self, preset: WavelengthPreset) -> bool: ...

class ParaxialRaysSetting:
    ConsiderCoordinateBreaks = 0
    IgnoreCoordinateBreaks = 1

class PolarizationMethod:
    XAxisMethod = 0
    YAxisMethod = 1
    ZAxisMethod = 2

class QuadratureSteps:
    S2 = 0
    S4 = 1
    S6 = 2
    S8 = 3
    S10 = 4
    S12 = 5

class RayAimingMethod:
    Off = 0
    Paraxial = 1
    Real = 2

class ReferenceOPDSetting:
    Absolute = 0
    Infinity = 1
    ExitPupil = 2
    Absolute2 = 3

class WavelengthPreset:
    FdC_Visible = 0
    Photopic_Bright = 1
    Scotopic_Dark = 2
    HeNe_0p6328 = 3
    HeNe_0p5438 = 4
    Argon_0p4880 = 5
    Argon_0p5145 = 6
    NDYAG_1p0641 = 7
    NDGlass_1p054 = 8
    CO2_10p60 = 9
    CrLiSAF_0p840 = 10
    TiAl203_0p760 = 11
    Ruby_0p6943 = 12
    HeCadmium_0p4416 = 13
    HeCadmium_0p3536 = 14
    HeCadmium_0p3250 = 15
    t_1p014 = 16
    r_0p707 = 17
    C_0p656 = 18
    d_0p587 = 19
    F_0p486 = 20
    g_0p436 = 21
    i_0p365 = 22
    Fp_0p365 = 23
    e_0p54607 = 24
    Cp_0p6438469 = 25
    FpeCp_Visible = 26
    THz_193p10 = 27

class ZemaxAfocalModeUnits:
    Microradians = 0
    Milliradians = 1
    Radians = 2
    ArcSeconds = 3
    ArcMinutes = 4
    Degrees = 5

class ZemaxAnalysisUnits:
    WattsPerMMSq = 0
    WattsPerCMSq = 1
    WattsPerinSq = 2
    WattsPerMSq = 3
    WattsPerftSq = 4

class ZemaxApertureType:
    EntrancePupilDiameter = 0
    ImageSpaceFNum = 1
    ObjectSpaceNA = 2
    FloatByStopSize = 3
    ParaxialWorkingFNum = 4
    ObjectConeAngle = 5

class ZemaxApodizationType:
    Uniform = 0
    Gaussian = 1
    CosineCubed = 2

class ZemaxMTFUnits:
    CyclesPerMillimeter = 0
    CyclesPerMilliradian = 1

class ZemaxSourceUnits:
    Watts = 0
    Lumens = 1
    Joules = 2

class ZemaxSystemUnits:
    Millimeters = 0
    Centimeters = 1
    Inches = 2
    Meters = 3

class ZemaxUnitPrefix:
    Femto = 0
    Pico = 1
    Nano = 2
    Micro = 3
    Milli = 4
    # None = 5
    Kilo = 6
    Mega = 7
    Giga = 8
    Tera = 9
