"""
This file provides autocompletions for the ZOS-API and was automatically generated.
It should not be edited manually.
"""

from __future__ import annotations

from typing import overload

from zospy.api._ZOSAPI import IOpticalSystem
from zospy.api._ZOSAPI.Common import IMatrixData, IVectorData
from zospy.api._ZOSAPI.SystemData import ISDRayAimingData
from zospy.api._ZOSAPI.Tools import ISystemTool

__all__ = (
    "ACISExportVersion",
    "ArchiveFileStatus",
    "CADAngularToleranceType",
    "CADFileType",
    "CADToleranceType",
    "DataTypes",
    "EntryCompressionModes",
    "IComputeRMSSpotSize",
    "ICovarianceData",
    "ICovarianceData",
    "ICreateArchive",
    "IDataDictionary",
    "IDataDictionary",
    "IDataEntry",
    "IDataEntry",
    "IExportCAD",
    "IHullTools",
    "IHullTools",
    "ILensCatalogLens",
    "ILensCatalogLens",
    "ILensCatalogs",
    "IPoint3D",
    "IPoint3D",
    "IPointList3D",
    "IPointList3D",
    "IPointTools",
    "IPointTools",
    "IQuickAdjust",
    "IQuickFocus",
    "IRayAimingWizard",
    "IRestoreArchive",
    "IScale",
    "LensShape",
    "LensType",
    "QuickAdjustCriterion",
    "QuickAdjustType",
    "QuickFocusCriterion",
    "RayPatternType",
    "ScaleToUnits",
    "SplineSegmentsType",
    "ZemaxFileTypes",
)

class ACISExportVersion:
    Current = 0
    V25 = 1
    V26 = 2
    V27 = 3
    V28 = 4
    V29 = 5
    V30 = 6

class ArchiveFileStatus:
    Okay = 0
    InvalidVersion = -3
    InvalidFile = -2
    UnableToOpen = -1

class CADAngularToleranceType:
    Low = 0
    Medium = 1
    High = 2
    Presentation = 3

class CADFileType:
    IGES = 0
    STEP = 1
    SAT = 2
    STL = 3
    SAB = 4
    ASAT = 5
    ASAB = 6
    MODEL = 7
    CATPART = 8
    CATPRODUCT = 9
    XCGM = 10

class CADToleranceType:
    N_TenEMinus4 = 0
    N_TenEMinus5 = 1
    N_TenEMinus6 = 2
    N_TenEMinus7 = 3

class DataTypes:
    NotSet = 0
    Boolean = 1
    Integer = 2
    IntegerArray = 3
    IntegerMatrix = 4
    Float = 5
    FloatArray = 6
    FloatMatrix = 7
    Double = 8
    DoubleArray = 9
    DoubleMatrix = 10
    String = 11
    StringArray = 12
    StringMatrix = 13
    ByteArray = 14
    Dictionary = 15
    Serializable = 16
    File = 17

class EntryCompressionModes:
    Auto = 0
    On = 1
    Off = 2

class IComputeRMSSpotSize(ISystemTool):
    @property
    def AssumeAxialSymmetry(self) -> bool: ...
    @property
    def DeleteVignetted(self) -> bool: ...
    @property
    def GridSampling(self) -> int: ...
    @property
    def IgnoreLateralColor(self) -> bool: ...
    @property
    def NumberOfArms(self) -> int: ...
    @property
    def NumberOfConfigurations(self) -> int: ...
    @property
    def NumberOfFields(self) -> int: ...
    @property
    def NumberOfRings(self) -> int: ...
    @property
    def ObscuredFration(self) -> float: ...
    @property
    def RMSSpotRadii(self) -> list[list[float]]: ...
    @property
    def UseGaussianQuadrature(self) -> bool: ...
    @property
    def UseRectangularArray(self) -> bool: ...
    def GetSpotRadius(self, configuration: int, field: int) -> float: ...
    @AssumeAxialSymmetry.setter
    def AssumeAxialSymmetry(self, value: bool) -> None: ...
    @IgnoreLateralColor.setter
    def IgnoreLateralColor(self, value: bool) -> None: ...
    def SetMethodGaussianQuadrature(self, numberOfRings: int, numberOfArms: int, obscuredFraction: float) -> None: ...
    def SetMethodRectangularArray(self, gridSampling: int, deleteVignetted: bool) -> None: ...

class ICovarianceData:
    @property
    def Cov(self) -> list[list[float]]: ...
    @property
    def V(self) -> list[list[float]]: ...
    @property
    def W(self) -> list[float]: ...
    def GetCovariance(self) -> IMatrixData: ...
    def GetValues(self) -> IVectorData: ...
    def GetVectors(self) -> IMatrixData: ...

class ICreateArchive(ISystemTool):
    @property
    def UseDataCompression(self) -> bool: ...
    def GetArchiveFileName(self) -> str: ...
    @UseDataCompression.setter
    def UseDataCompression(self, value: bool) -> None: ...
    def SetArchiveFileName(self, fullFileName: str) -> bool: ...

class IDataDictionary:
    def Close(self) -> None: ...
    def CreateEntry(self, key: str) -> IDataEntry: ...
    @property
    def Entries(self) -> list[IDataEntry]: ...
    @property
    def FileData1(self) -> int: ...
    @property
    def FileData2(self) -> int: ...
    @property
    def FileName(self) -> str: ...
    @property
    def FileType(self) -> ZemaxFileTypes: ...
    @property
    def FileVersion(self) -> int: ...
    @property
    def Keys(self) -> list[str]: ...
    @property
    def NumberOfEntries(self) -> int: ...
    def GetEntry(self, key: str) -> IDataEntry: ...
    def GetKey(self, keyIndex: int) -> str: ...
    def Save(self) -> None: ...

class IDataEntry:
    def Delete(self) -> None: ...
    @property
    def CompressionMode(self) -> EntryCompressionModes: ...
    @property
    def DataType(self) -> DataTypes: ...
    @property
    def IsSet(self) -> bool: ...
    @property
    def Key(self) -> str: ...
    def GetBooleanValue(self) -> bool: ...
    def GetByteArray(self) -> list[Byte]: ...
    def GetDoubleArray(self) -> list[float]: ...
    def GetDoubleMatrix(self) -> list[list[float]]: ...
    def GetDoubleValue(self) -> float: ...
    def GetFile(self, fileName: str) -> None: ...
    def GetFloatArray(self) -> list[float]: ...
    def GetFloatMatrix(self) -> list[list[float]]: ...
    def GetFloatValue(self) -> float: ...
    def GetIntegerArray(self) -> list[int]: ...
    def GetIntegerMatrix(self) -> list[list[int]]: ...
    def GetIntegerValue(self) -> int: ...
    def GetSerializableValue(self) -> Object: ...
    def GetStringArray(self) -> list[str]: ...
    def GetStringMatrix(self) -> list[list[str]]: ...
    def GetStringValue(self) -> str: ...
    @CompressionMode.setter
    def CompressionMode(self, value: EntryCompressionModes) -> None: ...
    def SetBooleanValue(self, val: bool) -> bool: ...
    def SetByteArray(self, val: list[Byte]) -> bool: ...
    def SetDoubleArray(self, val: list[float]) -> bool: ...
    def SetDoubleMatrix(self, val: list[list[float]]) -> bool: ...
    def SetDoubleValue(self, val: float) -> bool: ...
    def SetFile(self, fileName: str) -> bool: ...
    def SetFloatArray(self, val: list[float]) -> bool: ...
    def SetFloatMatrix(self, val: list[list[float]]) -> bool: ...
    def SetFloatValue(self, val: float) -> bool: ...
    def SetIntegerArray(self, val: list[int]) -> bool: ...
    def SetIntegerMatrix(self, val: list[list[int]]) -> bool: ...
    def SetIntegerValue(self, val: int) -> bool: ...
    def SetSerializableValue(self, val: Object) -> bool: ...
    def SetStringArray(self, val: list[str]) -> bool: ...
    def SetStringMatrix(self, val: list[list[str]]) -> bool: ...
    def SetStringValue(self, val: str) -> bool: ...

class IExportCAD(ISystemTool):
    @property
    def AngularTolerance(self) -> CADAngularToleranceType: ...
    @property
    def AutoNameFaces(self) -> bool: ...
    @property
    def CanChangeSurface(self) -> bool: ...
    @property
    def Configuration(self) -> int: ...
    @property
    def DeleteVignetted(self) -> bool: ...
    @property
    def DummyThickness(self) -> float: ...
    @property
    def ExportDummySurfaces(self) -> bool: ...
    @property
    def Field(self) -> int: ...
    @property
    def FileType(self) -> CADFileType: ...
    @property
    def FileVersion(self) -> ACISExportVersion: ...
    @property
    def FirstObject(self) -> int: ...
    @property
    def FirstSurface(self) -> int: ...
    @property
    def LastObject(self) -> int: ...
    @property
    def LastSurface(self) -> int: ...
    @property
    def LensLayer(self) -> int: ...
    @property
    def NumberOfRays(self) -> int: ...
    @property
    def OutputFileName(self) -> str: ...
    @property
    def RayLayer(self) -> int: ...
    @property
    def RayPattern(self) -> RayPatternType: ...
    @property
    def ScatterNSCRays(self) -> bool: ...
    @property
    def SequentialSettingsEnabled(self) -> bool: ...
    @property
    def SplineSegments(self) -> SplineSegmentsType: ...
    @property
    def SplitNSCRays(self) -> bool: ...
    @property
    def SurfacesAsSolids(self) -> bool: ...
    @property
    def Tolerance(self) -> CADToleranceType: ...
    @property
    def UsePolarization(self) -> bool: ...
    @property
    def Wavelength(self) -> int: ...
    @AngularTolerance.setter
    def AngularTolerance(self, value: CADAngularToleranceType) -> None: ...
    @AutoNameFaces.setter
    def AutoNameFaces(self, value: bool) -> None: ...
    @DeleteVignetted.setter
    def DeleteVignetted(self, value: bool) -> None: ...
    @DummyThickness.setter
    def DummyThickness(self, value: float) -> None: ...
    @ExportDummySurfaces.setter
    def ExportDummySurfaces(self, value: bool) -> None: ...
    @Field.setter
    def Field(self, value: int) -> None: ...
    @FileType.setter
    def FileType(self, value: CADFileType) -> None: ...
    @FileVersion.setter
    def FileVersion(self, value: ACISExportVersion) -> None: ...
    @FirstObject.setter
    def FirstObject(self, value: int) -> None: ...
    @FirstSurface.setter
    def FirstSurface(self, value: int) -> None: ...
    @LastObject.setter
    def LastObject(self, value: int) -> None: ...
    @LastSurface.setter
    def LastSurface(self, value: int) -> None: ...
    @LensLayer.setter
    def LensLayer(self, value: int) -> None: ...
    @NumberOfRays.setter
    def NumberOfRays(self, value: int) -> None: ...
    @OutputFileName.setter
    def OutputFileName(self, value: str) -> None: ...
    @RayLayer.setter
    def RayLayer(self, value: int) -> None: ...
    @RayPattern.setter
    def RayPattern(self, value: RayPatternType) -> None: ...
    @ScatterNSCRays.setter
    def ScatterNSCRays(self, value: bool) -> None: ...
    @SplineSegments.setter
    def SplineSegments(self, value: SplineSegmentsType) -> None: ...
    @SplitNSCRays.setter
    def SplitNSCRays(self, value: bool) -> None: ...
    @SurfacesAsSolids.setter
    def SurfacesAsSolids(self, value: bool) -> None: ...
    @Tolerance.setter
    def Tolerance(self, value: CADToleranceType) -> None: ...
    @UsePolarization.setter
    def UsePolarization(self, value: bool) -> None: ...
    @Wavelength.setter
    def Wavelength(self, value: int) -> None: ...
    def SetConfigurationAllAtOnce(self) -> None: ...
    def SetConfigurationAllByFile(self) -> None: ...
    def SetConfigurationAllByLayer(self) -> None: ...
    def SetCurrentConfiguration(self) -> None: ...
    def SetFieldAll(self) -> None: ...
    def SetSingleConfiguration(self, ConfigurationNumber: int) -> None: ...
    def SetWavelengthAll(self) -> None: ...

class IHullTools:
    def Compute2DHull(
        self, points: IPointList3D, planeOrigin: IPoint3D, planeX: IPoint3D, planeY: IPoint3D
    ) -> IPointList3D: ...
    def ComputeCovData(self, points: IPointList3D, center: IPoint3D) -> ICovarianceData: ...

class ILensCatalogLens:
    @property
    def EFL(self) -> float: ...
    @property
    def EPD(self) -> float: ...
    @property
    def LensName(self) -> str: ...
    @property
    def NumberOfElements(self) -> int: ...
    @property
    def Shape(self) -> LensShape: ...
    @property
    def Telecentric(self) -> bool: ...
    @property
    def Type(self) -> LensType: ...
    @property
    def Vendor(self) -> str: ...
    def InsertLensNonSeq(self) -> bool: ...
    def InsertLensSeq(self, atSurface: int, ignoreObject: bool, reverseSurfGeom: bool) -> bool: ...
    def LoadLens(self, saveIfNeeded: bool) -> None: ...
    def LoadNewLensNonSeq(self) -> IOpticalSystem: ...
    def LoadNewLensSeq(self) -> IOpticalSystem: ...

class ILensCatalogs(ISystemTool):
    @property
    def IncShapeBi(self) -> bool: ...
    @property
    def IncShapeEqui(self) -> bool: ...
    @property
    def IncShapeMeniscus(self) -> bool: ...
    @property
    def IncShapePlano(self) -> bool: ...
    @property
    def IncTypeAspheric(self) -> bool: ...
    @property
    def IncTypeGRIN(self) -> bool: ...
    @property
    def IncTypeSpherical(self) -> bool: ...
    @property
    def IncTypeToroidal(self) -> bool: ...
    @property
    def LensesForVendor(self) -> int: ...
    @property
    def MatchingLenses(self) -> int: ...
    @property
    def MaxEFL(self) -> float: ...
    @property
    def MaxEPD(self) -> float: ...
    @property
    def MinEFL(self) -> float: ...
    @property
    def MinEPD(self) -> float: ...
    @property
    def NumberOfElements(self) -> int: ...
    @property
    def SelectedVendor(self) -> str: ...
    @property
    def UseEFL(self) -> bool: ...
    @property
    def UseEPD(self) -> bool: ...
    def GetAllVendors(self) -> list[str]: ...
    def GetResult(self, index: int) -> ILensCatalogLens: ...
    @IncShapeBi.setter
    def IncShapeBi(self, value: bool) -> None: ...
    @IncShapeEqui.setter
    def IncShapeEqui(self, value: bool) -> None: ...
    @IncShapeMeniscus.setter
    def IncShapeMeniscus(self, value: bool) -> None: ...
    @IncShapePlano.setter
    def IncShapePlano(self, value: bool) -> None: ...
    @IncTypeAspheric.setter
    def IncTypeAspheric(self, value: bool) -> None: ...
    @IncTypeGRIN.setter
    def IncTypeGRIN(self, value: bool) -> None: ...
    @IncTypeSpherical.setter
    def IncTypeSpherical(self, value: bool) -> None: ...
    @IncTypeToroidal.setter
    def IncTypeToroidal(self, value: bool) -> None: ...
    @MaxEFL.setter
    def MaxEFL(self, value: float) -> None: ...
    @MaxEPD.setter
    def MaxEPD(self, value: float) -> None: ...
    @MinEFL.setter
    def MinEFL(self, value: float) -> None: ...
    @MinEPD.setter
    def MinEPD(self, value: float) -> None: ...
    @NumberOfElements.setter
    def NumberOfElements(self, value: int) -> None: ...
    @SelectedVendor.setter
    def SelectedVendor(self, value: str) -> None: ...
    @UseEFL.setter
    def UseEFL(self, value: bool) -> None: ...
    @UseEPD.setter
    def UseEPD(self, value: bool) -> None: ...
    def SetNumberOfElementsAny(self) -> None: ...

class IPoint3D:
    def Add(self, p: IPoint3D) -> None: ...
    @property
    def X(self) -> float: ...
    @property
    def Y(self) -> float: ...
    @property
    def Z(self) -> float: ...
    def GetDim(self, Dim: int) -> float: ...
    def GetSortedDims(self) -> list[int]: ...
    def Magnitude(self) -> float: ...
    def MagnitudeSq(self) -> float: ...
    @X.setter
    def X(self, value: float) -> None: ...
    @Y.setter
    def Y(self, value: float) -> None: ...
    @Z.setter
    def Z(self, value: float) -> None: ...
    def SetDim(self, Dim: int, Value: float) -> None: ...
    def VectorAndScalar(self) -> tuple[bool, IPoint3D, float]: ...

class IPointList3D:
    @overload
    def AddPoint(self, p: IPoint3D) -> None: ...
    @overload
    def AddPoint(self, X: float, Y: float, Z: float) -> None: ...
    def Clear(self) -> None: ...
    @property
    def NumberOfPoints(self) -> int: ...
    def GetPoint(self, Index: int) -> IPoint3D: ...
    def RemovePoint(self, Index: int) -> None: ...

class IPointTools:
    def Add(self, p1: IPoint3D, p2: IPoint3D) -> IPoint3D: ...
    def ComputeCentroid(self, points: IPointList3D) -> IPoint3D: ...
    def CreatePoint(self, x: float, y: float, z: float) -> IPoint3D: ...
    def CreatePointList(self) -> IPointList3D: ...
    def Cross(self, p1: IPoint3D, p2: IPoint3D) -> IPoint3D: ...
    def Divide(self, p: IPoint3D, s: float) -> IPoint3D: ...
    def Dot(self, p1: IPoint3D, p2: IPoint3D) -> float: ...
    def Multiply(self, p: IPoint3D, s: float) -> IPoint3D: ...
    def Subtract(self, p1: IPoint3D, p2: IPoint3D) -> IPoint3D: ...

class IQuickAdjust(ISystemTool):
    @property
    def AdjustSurface(self) -> int: ...
    @property
    def Criterion(self) -> QuickAdjustCriterion: ...
    @property
    def EvaluateSurface(self) -> int: ...
    @property
    def SurfaceParameter(self) -> QuickAdjustType: ...
    @AdjustSurface.setter
    def AdjustSurface(self, value: int) -> None: ...
    @Criterion.setter
    def Criterion(self, value: QuickAdjustCriterion) -> None: ...
    @EvaluateSurface.setter
    def EvaluateSurface(self, value: int) -> None: ...
    @SurfaceParameter.setter
    def SurfaceParameter(self, value: QuickAdjustType) -> None: ...
    def SetEvaluateSurfaceImage(self) -> None: ...

class IQuickFocus(ISystemTool):
    @property
    def Criterion(self) -> QuickFocusCriterion: ...
    @property
    def UseCentroid(self) -> bool: ...
    @Criterion.setter
    def Criterion(self, value: QuickFocusCriterion) -> None: ...
    @UseCentroid.setter
    def UseCentroid(self, value: bool) -> None: ...

class IRayAimingWizard(ISystemTool):
    def ApplyRecommendedSettings(self) -> None: ...
    def GetRecommendedSettings(self) -> ISDRayAimingData: ...

class IRestoreArchive(ISystemTool):
    @property
    def ArchiveFile(self) -> str: ...
    @property
    def ExtractAllFilesToProjectDirectory(self) -> bool: ...
    @property
    def NumberOfFilesInArchive(self) -> int: ...
    def GetFileNameInArchive(self, fileNumber: int) -> str: ...
    def GetOutputFolder(self) -> str: ...
    @ExtractAllFilesToProjectDirectory.setter
    def ExtractAllFilesToProjectDirectory(self, value: bool) -> None: ...
    def SetFileName(self, archiveFile: str) -> ArchiveFileStatus: ...
    def SetFileOverwrite(self, fileNumber: int, allowOverwrite: bool) -> None: ...
    def SetFilesAllOverwrite(self) -> None: ...
    def SetFilesNoOverwrite(self) -> None: ...
    def SetOutputFolder(self, folder: str) -> bool: ...

class IScale(ISystemTool):
    @property
    def FirstComponent(self) -> int: ...
    @property
    def LastComponent(self) -> int: ...
    @property
    def NumberOfComponents(self) -> int: ...
    @property
    def ScaleByFactor(self) -> bool: ...
    @property
    def ScaleByUnits(self) -> bool: ...
    @property
    def ScaleFactor(self) -> float: ...
    @property
    def ScaleToUnit(self) -> ScaleToUnits: ...
    def GetComponentAt(self, idx: int) -> str: ...
    @FirstComponent.setter
    def FirstComponent(self, value: int) -> None: ...
    @LastComponent.setter
    def LastComponent(self, value: int) -> None: ...
    @ScaleByFactor.setter
    def ScaleByFactor(self, value: bool) -> None: ...
    @ScaleByUnits.setter
    def ScaleByUnits(self, value: bool) -> None: ...
    @ScaleFactor.setter
    def ScaleFactor(self, value: float) -> None: ...
    @ScaleToUnit.setter
    def ScaleToUnit(self, value: ScaleToUnits) -> None: ...

class LensShape:
    Unknown = 0
    Equi = 1
    Bi = 2
    Plano = 3
    Meniscus = 4

class LensType:
    Other = 0
    Spherical = 1
    GRIN = 2
    Aspheric = 3
    Toroidal = 4

class QuickAdjustCriterion:
    SpotSizeRadial = 0
    SpotSizeXOnly = 1
    SpotSizeYOnly = 2
    AngularRadial = 3
    AngularXOnly = 4
    AngularYOnly = 5

class QuickAdjustType:
    Radius = 0
    Thickness = 1

class QuickFocusCriterion:
    SpotSizeRadial = 0
    SpotSizeXOnly = 1
    SpotSizeYOnly = 2
    RMSWavefront = 3

class RayPatternType:
    XYFan = 0
    XFan = 1
    YFan = 2
    Ring = 3
    List = 4
    Random = 5
    Grid = 6
    SolidRing = 7

class ScaleToUnits:
    Millimeters = 0
    Centimeters = 1
    Inches = 2
    Meters = 3

class SplineSegmentsType:
    N_016 = 0
    N_032 = 1
    N_064 = 2
    N_128 = 3
    N_256 = 4
    N_512 = 5

class ZemaxFileTypes:
    Unknown = 0
    LMX = 1
    User = 2
