"""
This file provides autocompletions for the ZOS-API and was automatically generated.
It should not be edited manually.
"""

from __future__ import annotations

from zospy.api._ZOSAPI.Tools import HPCRunState, ISystemTool

__all__ = (
    "IGlobalOptimization",
    "IHammerOptimization",
    "ILocalOptimization",
    "OptimizationAlgorithm",
    "OptimizationCycles",
    "OptimizationSaveCount",
)

class IGlobalOptimization(ISystemTool):
    def CurrentMeritFunction(self, N: int) -> float: ...
    def EstimateHPCTime(self) -> bool: ...
    @property
    def Algorithm(self) -> OptimizationAlgorithm: ...
    @property
    def CurrentMeritFunction01(self) -> float: ...
    @property
    def CurrentMeritFunction02(self) -> float: ...
    @property
    def CurrentMeritFunction03(self) -> float: ...
    @property
    def CurrentMeritFunction04(self) -> float: ...
    @property
    def CurrentMeritFunction05(self) -> float: ...
    @property
    def CurrentMeritFunction06(self) -> float: ...
    @property
    def CurrentMeritFunction07(self) -> float: ...
    @property
    def CurrentMeritFunction08(self) -> float: ...
    @property
    def CurrentMeritFunction09(self) -> float: ...
    @property
    def CurrentMeritFunction10(self) -> float: ...
    @property
    def Cycles(self) -> int: ...
    @property
    def HPCEstimatedTimeS(self) -> float: ...
    @property
    def HPCHasTimeEstimate(self) -> bool: ...
    @property
    def HPCQueuePosition(self) -> int: ...
    @property
    def HPCRemainingTimeS(self) -> float: ...
    @property
    def HPCState(self) -> HPCRunState: ...
    @property
    def HPCTimeToStartS(self) -> float: ...
    @property
    def InitialMeritFunction(self) -> float: ...
    @property
    def IsHPCEnabled(self) -> bool: ...
    @property
    def MaxCores(self) -> int: ...
    @property
    def NumberOfCores(self) -> int: ...
    @property
    def NumberToSave(self) -> OptimizationSaveCount: ...
    @property
    def Systems(self) -> int: ...
    @property
    def TargetRunTimeM(self) -> float: ...
    @property
    def Targets(self) -> int: ...
    @property
    def Variables(self) -> int: ...
    @Algorithm.setter
    def Algorithm(self, value: OptimizationAlgorithm) -> None: ...
    @NumberOfCores.setter
    def NumberOfCores(self, value: int) -> None: ...
    @NumberToSave.setter
    def NumberToSave(self, value: OptimizationSaveCount) -> None: ...
    @TargetRunTimeM.setter
    def TargetRunTimeM(self, value: float) -> None: ...

class IHammerOptimization(ISystemTool):
    def EstimateHPCTime(self) -> bool: ...
    @property
    def Algorithm(self) -> OptimizationAlgorithm: ...
    @property
    def AutomaticOptimization(self) -> bool: ...
    @property
    def CurrentMeritFunction(self) -> float: ...
    @property
    def HPCEstimatedTimeS(self) -> float: ...
    @property
    def HPCHasTimeEstimate(self) -> bool: ...
    @property
    def HPCQueuePosition(self) -> int: ...
    @property
    def HPCRemainingTimeS(self) -> float: ...
    @property
    def HPCState(self) -> HPCRunState: ...
    @property
    def HPCTimeToStartS(self) -> float: ...
    @property
    def InitialMeritFunction(self) -> float: ...
    @property
    def IsHPCEnabled(self) -> bool: ...
    @property
    def MaxCores(self) -> int: ...
    @property
    def NumberOfCores(self) -> int: ...
    @property
    def Systems(self) -> int: ...
    @property
    def TargetRunTimeM(self) -> float: ...
    @property
    def Targets(self) -> int: ...
    @property
    def Variables(self) -> int: ...
    @Algorithm.setter
    def Algorithm(self, value: OptimizationAlgorithm) -> None: ...
    @AutomaticOptimization.setter
    def AutomaticOptimization(self, value: bool) -> None: ...
    @NumberOfCores.setter
    def NumberOfCores(self, value: int) -> None: ...
    @TargetRunTimeM.setter
    def TargetRunTimeM(self, value: float) -> None: ...

class ILocalOptimization(ISystemTool):
    @property
    def Algorithm(self) -> OptimizationAlgorithm: ...
    @property
    def CurrentMeritFunction(self) -> float: ...
    @property
    def Cycles(self) -> OptimizationCycles: ...
    @property
    def InitialMeritFunction(self) -> float: ...
    @property
    def MaxCores(self) -> int: ...
    @property
    def NumberOfCores(self) -> int: ...
    @property
    def Targets(self) -> int: ...
    @property
    def Variables(self) -> int: ...
    @Algorithm.setter
    def Algorithm(self, value: OptimizationAlgorithm) -> None: ...
    @Cycles.setter
    def Cycles(self, value: OptimizationCycles) -> None: ...
    @NumberOfCores.setter
    def NumberOfCores(self, value: int) -> None: ...

class OptimizationAlgorithm:
    DampedLeastSquares = 0
    OrthogonalDescent = 1

class OptimizationCycles:
    Automatic = 0
    Fixed_1_Cycle = 1
    Fixed_5_Cycles = 2
    Fixed_10_Cycles = 3
    Fixed_50_Cycles = 4
    Infinite = 5

class OptimizationSaveCount:
    Save_10 = 0
    Save_20 = 1
    Save_30 = 2
    Save_40 = 3
    Save_50 = 4
    Save_60 = 5
    Save_70 = 6
    Save_80 = 7
    Save_90 = 8
    Save_100 = 9
