"""
This file provides autocompletions for the ZOS-API and was automatically generated.
It should not be edited manually.
"""

from __future__ import annotations

from zospy.api._ZOSAPI.Analysis import I_Analyses, IMessage, IUserAnalysisData
from zospy.api._ZOSAPI.Common import IMetadata, ISettingsData, IVectorData
from zospy.api._ZOSAPI.Editors.LDE import ILensDataEditor
from zospy.api._ZOSAPI.Editors.MCE import IMultiConfigEditor
from zospy.api._ZOSAPI.Editors.MFE import IMeritFunctionEditor
from zospy.api._ZOSAPI.Editors.NCE import INonSeqEditor
from zospy.api._ZOSAPI.Editors.TDE import IToleranceDataEditor
from zospy.api._ZOSAPI.Preferences import IPreferencesFolders, IPreferencesGeneral
from zospy.api._ZOSAPI.SystemData import ISystemData
from zospy.api._ZOSAPI.Tools import IOpticalSystemTools
from zospy.api._ZOSAPI.Tools.General import IDataDictionary, ZemaxFileTypes

from . import Analysis, Common, Editors, Preferences, SystemData, Tools, Wizards

__all__ = (
    "Analysis",
    "Common",
    "Editors",
    "Preferences",
    "SystemData",
    "Tools",
    "Wizards",
    "IOpticalSystem",
    "IOpticalSystem",
    "IPreferences",
    "IPreferences",
    "ISTARMaterials",
    "ISTARMaterials",
    "ISTARSubsystem",
    "ISTARSubsystem",
    "IZAPI_BaseObject",
    "IZAPI_BaseObject",
    "IZOSAPI_Application",
    "IZOSAPI_Application",
    "IZOSAPI_Callback",
    "IZOSAPI_Callback",
    "IZOSAPI_Connection",
    "IZOSAPI_Connection",
    "LensUpdateMode",
    "LicenseStatusType",
    "OpticalSystemStatusChangedHandler",
    "OpticalSystemStatusChangedHandler",
    "SessionModes",
    "STARUpdateMode",
    "SystemType",
    "UpdateStatus",
    "ZOSAPI_Mode",
)

class IOpticalSystem:
    def Close(self, saveIfNeeded: bool) -> bool: ...
    def ConvertToProjectDirectory(self, folderPath: str) -> bool: ...
    def CopySystem(self) -> IOpticalSystem: ...
    @property
    def Analyses(self) -> I_Analyses: ...
    @property
    def IsNonAxial(self) -> bool: ...
    @property
    def IsProjectDirectory(self) -> bool: ...
    @property
    def LDE(self) -> ILensDataEditor: ...
    @property
    def MCE(self) -> IMultiConfigEditor: ...
    @property
    def MFE(self) -> IMeritFunctionEditor: ...
    @property
    def Mode(self) -> SystemType: ...
    @property
    def NCE(self) -> INonSeqEditor: ...
    @property
    def NeedsSave(self) -> bool: ...
    @property
    def SessionMode(self) -> SessionModes: ...
    @property
    def STARSubsystem(self) -> ISTARSubsystem: ...
    @property
    def SystemData(self) -> ISystemData: ...
    @property
    def SystemFile(self) -> str: ...
    @property
    def SystemID(self) -> int: ...
    @property
    def SystemName(self) -> str: ...
    @property
    def TDE(self) -> IToleranceDataEditor: ...
    @property
    def TheApplication(self) -> IZOSAPI_Application: ...
    @property
    def Tools(self) -> IOpticalSystemTools: ...
    @property
    def UpdateMode(self) -> LensUpdateMode: ...
    def GetCurrentStatus(self) -> str: ...
    def GetMetadata(self) -> IMetadata: ...
    def LoadFile(self, LensFile: str, saveIfNeeded: bool) -> bool: ...
    def MakeNonSequential(self) -> bool: ...
    def MakeSequential(self) -> bool: ...
    def New(self, saveIfNeeded: bool) -> None: ...
    def Save(self) -> None: ...
    def SaveAs(self, fileName: str) -> None: ...
    @SessionMode.setter
    def SessionMode(self, value: SessionModes) -> None: ...
    @SystemName.setter
    def SystemName(self, value: str) -> None: ...
    @UpdateMode.setter
    def UpdateMode(self, value: LensUpdateMode) -> None: ...
    def TurnOffProjectDirectory(self) -> bool: ...
    def UpdateFileLists(self) -> None: ...
    def UpdateStatus(self) -> str: ...

class IPreferences:
    @property
    def Folders(self) -> IPreferencesFolders: ...
    @property
    def General(self) -> IPreferencesGeneral: ...
    @property
    def IsReadOnly(self) -> bool: ...
    def ResetToDefaults(self) -> None: ...

class ISTARMaterials:
    def GetDNDT(
        self,
        MaterialCatalog: str,
        Material: str,
        Wavelength: float,
        EnvironmentPressure: float,
        EnvironmentTemperature: float,
        MaterialPressure: float,
        MaterialTemperature: float,
        DeltaT: float,
    ) -> float: ...
    def GetRefractiveIndex(
        self,
        MaterialCatalog: str,
        Material: str,
        Wavelength: float,
        EnvironmentPressure: float,
        EnvironmentTemperature: float,
        MaterialPressure: float,
        MaterialTemperature: float,
    ) -> float: ...

class ISTARSubsystem:
    def DoManualUpdate(self) -> None: ...
    @property
    def Materials(self) -> ISTARMaterials: ...
    @property
    def UpdateMode(self) -> STARUpdateMode: ...
    @UpdateMode.setter
    def UpdateMode(self, value: STARUpdateMode) -> None: ...

class IZAPI_BaseObject:
    def AddChild(self, child: IZAPI_BaseObject) -> None: ...
    def Disconnect(self) -> None: ...
    @property
    def Parent(self) -> IZAPI_BaseObject: ...
    def RemoveChild(self, child: IZAPI_BaseObject) -> None: ...

class IZOSAPI_Application:
    def BeginMessageLogging(self) -> bool: ...
    def CheckForUpdates(self) -> None: ...
    def ClearMessageLog(self) -> None: ...
    def CloseApplication(self) -> None: ...
    def CloseSystemAt(self, pos: int, saveIfNeeded: bool) -> bool: ...
    def CopySettingsData(self, from_: ISettingsData, to: ISettingsData) -> bool: ...
    def CreateDataFile(self, fileName: str, type: ZemaxFileTypes, data1: int, data2: int) -> IDataDictionary: ...
    def CreateNewSystem(self, mode: SystemType) -> IOpticalSystem: ...
    def CreateSettings(self) -> ISettingsData: ...
    def CreateSettingsFromParent(self, parent: IZAPI_BaseObject) -> ISettingsData: ...
    def EndMessageLogging(self) -> bool: ...
    @property
    def AutodeskInventorFilesDir(self) -> str: ...
    @property
    def CheckForUpdatesData(self) -> str: ...
    @property
    def CheckForUpdatesStatus(self) -> UpdateStatus: ...
    @property
    def CheckForUpdatesVersion(self) -> int: ...
    @property
    def CoatingDir(self) -> str: ...
    @property
    def CreoParametricFilesDir(self) -> str: ...
    @property
    def ExpirationDay(self) -> int: ...
    @property
    def ExpirationMonth(self) -> int: ...
    @property
    def ExpirationYear(self) -> int: ...
    @property
    def GlassDir(self) -> str: ...
    @property
    def ImagesDir(self) -> str: ...
    @property
    def InitializationErrorCode(self) -> str: ...
    @property
    def InitializationErrors(self) -> str: ...
    @property
    def IsLoggingMessages(self) -> bool: ...
    @property
    def IsSTARModuleEnabled(self) -> bool: ...
    @property
    def IsSubscriptionLicense(self) -> bool: ...
    @property
    def IsValidLicenseForAPI(self) -> bool: ...
    @property
    def LensDir(self) -> str: ...
    @property
    def LicenseStatus(self) -> LicenseStatusType: ...
    @property
    def MATLABFilesDir(self) -> str: ...
    @property
    def Mode(self) -> ZOSAPI_Mode: ...
    @property
    def NumberOfCPUs(self) -> int: ...
    @property
    def NumberOfOpticalSystems(self) -> int: ...
    @property
    def ObjectsDir(self) -> str: ...
    @property
    def OperandArgument1(self) -> float: ...
    @property
    def OperandArgument2(self) -> float: ...
    @property
    def OperandArgument3(self) -> float: ...
    @property
    def OperandArgument4(self) -> float: ...
    @property
    def OperandResults(self) -> IVectorData: ...
    @property
    def OpticStudioVersion(self) -> int: ...
    @property
    def POPDir(self) -> str: ...
    @property
    def Preferences(self) -> IPreferences: ...
    @property
    def PrimarySystem(self) -> IOpticalSystem: ...
    @property
    def ProgramDir(self) -> str: ...
    @property
    def ProgressMessage(self) -> str: ...
    @property
    def ProgressPercent(self) -> float: ...
    @property
    def SamplesDir(self) -> str: ...
    @property
    def ScatterDir(self) -> str: ...
    @property
    def SerialCode(self) -> str: ...
    @property
    def ShowChangesInUI(self) -> bool: ...
    @property
    def SolidWorksFilesDir(self) -> str: ...
    @property
    def TerminateRequested(self) -> bool: ...
    @property
    def UndoDir(self) -> str: ...
    @property
    def UserAnalysisData(self) -> IUserAnalysisData: ...
    @property
    def ZemaxDataDir(self) -> str: ...
    @property
    def ZOSMajorVersion(self) -> int: ...
    @property
    def ZOSMinorVersion(self) -> int: ...
    @property
    def ZOSSPVersion(self) -> int: ...
    @property
    def ZPLDir(self) -> str: ...
    def GetDate(self) -> str: ...
    def GetSystemAt(self, pos: int) -> IOpticalSystem: ...
    def LoadCCallback(self, cLib: str, callbackName: str, settings: ISettingsData) -> IZOSAPI_Callback: ...
    def LoadNETCallback(self, fromAssembly: str, typeName: str, settings: ISettingsData) -> IZOSAPI_Callback: ...
    def LoadNewSystem(self, LensFile: str) -> IOpticalSystem: ...
    def OpenDataFile(self, fileName: str) -> IDataDictionary: ...
    def RegisterCOperandCallback(self, cLib: str, callbackName: str, settings: ISettingsData) -> IMessage: ...
    def RegisterNETOperandCallback(self, fromAssembly: str, typeName: str, settings: ISettingsData) -> IMessage: ...
    def RetrieveLogMessages(self) -> str: ...
    def RunCommand(self, command: str) -> str: ...
    @ProgressMessage.setter
    def ProgressMessage(self, value: str) -> None: ...
    @ProgressPercent.setter
    def ProgressPercent(self, value: float) -> None: ...
    @ShowChangesInUI.setter
    def ShowChangesInUI(self, value: bool) -> None: ...
    def UpdateFileLists(self) -> None: ...

class IZOSAPI_Callback:
    def Copy(self, app: IZOSAPI_Application) -> IZOSAPI_Callback: ...
    def Execute(self) -> int: ...
    @property
    def IsLocal(self) -> bool: ...
    @property
    def Name(self) -> str: ...
    @property
    def Settings(self) -> ISettingsData: ...
    @property
    def TheApp(self) -> IZOSAPI_Application: ...
    @Name.setter
    def Name(self, value: str) -> None: ...

class IZOSAPI_Connection:
    def ConnectAsExtension(self, zemaxInstance: int) -> IZOSAPI_Application: ...
    def ConnectToApplication(self) -> IZOSAPI_Application: ...
    def CreateNewApplication(self) -> IZOSAPI_Application: ...
    def CreateZemaxServer(self, applicationName: str) -> IZOSAPI_Application: ...
    def CreateZemaxServerEx(self, applicationName: str, libraryPath: str) -> IZOSAPI_Application: ...
    @property
    def ConnectionTimeoutSeconds(self) -> float: ...
    @property
    def FormattingCulture(self) -> str: ...
    @property
    def InitializationSettings(self) -> str: ...
    @property
    def IntializationProgress(self) -> list[int]: ...
    @property
    def IsAlive(self) -> bool: ...
    @property
    def PreferencesFile(self) -> str: ...
    def GetConfigSetting(self, setting: str) -> str: ...
    def RunCommand(self, command: str) -> str: ...
    @ConnectionTimeoutSeconds.setter
    def ConnectionTimeoutSeconds(self, value: float) -> None: ...
    @FormattingCulture.setter
    def FormattingCulture(self, value: str) -> None: ...
    @InitializationSettings.setter
    def InitializationSettings(self, value: str) -> None: ...
    @PreferencesFile.setter
    def PreferencesFile(self, value: str) -> None: ...
    def SetConfigSetting(self, setting: str, Value: str) -> None: ...
    def SetCreoInstallPath(self, path: str) -> None: ...

class LensUpdateMode:
    # None = 0
    EditorsOnly = 1
    AllWindows = 2

class LicenseStatusType:
    Unknown = 0
    KeyNotWorking = 1
    NewLicenseNeeded = 2
    StandardEdition = 3
    ProfessionalEdition = 4
    PremiumEdition = 5
    TooManyInstances = 6
    NotAuthorized = 7
    KeyNotFound = 8
    KeyExpired = 9
    Timeout = 10
    InstanceConflict = 11
    OpticsViewer = 12
    OpticStudioHPCEdition = 13
    EnterpriseEdition = 14

class OpticalSystemStatusChangedHandler:
    def __init__(self, object: Object, method: IntPtr): ...
    def BeginInvoke(self, systemId: int, newStatus: str, callback: AsyncCallback, object: Object) -> IAsyncResult: ...
    def EndInvoke(self, result: IAsyncResult) -> None: ...
    def Invoke(self, systemId: int, newStatus: str) -> None: ...

class SessionModes:
    FromPreferences = 0
    SessionOn = 1
    SessionOff = 2

class STARUpdateMode:
    Normal = 0
    Suspended = 1

class SystemType:
    Sequential = 0
    NonSequential = 1

class UpdateStatus:
    NotChecked = 0
    UpToDate = 1
    AvailableEligible = 2
    AvailableIneligible = 3
    CheckFailed = -2
    NotSupported = -1

class ZOSAPI_Mode:
    Server = 0
    Operand = 1
    Plugin = 2
    UserAnalysis = 3
    UserAnalysisSettings = 4
