from __future__ import annotations

from typing import Any

from pingsafe_cli.psgraph.common.models.enums import CheckCategories, CheckResult
from pingsafe_cli.psgraph.kubernetes.checks.resource.base_spec_check import BaseK8Check


class WildcardRoles(BaseK8Check):
    # CIS-1.6 5.1.3
    def __init__(self) -> None:
        name = "Minimize wildcard use in Roles and ClusterRoles"
        id = "CKV_K8S_49"
        categories = (CheckCategories.KUBERNETES,)
        supported_kind = ('Role', 'ClusterRole',)
        super().__init__(name=name, id=id, categories=categories, supported_entities=supported_kind)

    def scan_spec_conf(self, conf: dict[str, Any]) -> CheckResult:
        if isinstance(conf.get("rules"), list) and len(conf.get("rules")) > 0:
            if "apiGroups" in conf["rules"][0]:
                if any("*" in s for s in conf["rules"][0]["apiGroups"]):
                    return CheckResult.FAILED
            if "resources" in conf["rules"][0]:
                if any("*" in s for s in conf["rules"][0]["resources"]):
                    return CheckResult.FAILED
            if "verbs" in conf["rules"][0]:
                if any("*" in s for s in conf["rules"][0]["verbs"]):
                    return CheckResult.FAILED

        return CheckResult.PASSED


check = WildcardRoles()
