from pingsafe_cli.psgraph.common.models.enums import CheckCategories, CheckResult
from pingsafe_cli.psgraph.terraform.checks.resource.base_resource_value_check import BaseResourceValueCheck


class AppServiceSlotMinTLS(BaseResourceValueCheck):
    def __init__(self):
        name = "Ensure the App service slot is using the latest version of TLS encryption"
        id = "CKV_AZURE_154"
        supported_resources = ['azurerm_app_service_slot']
        categories = [CheckCategories.NETWORKING]
        super().__init__(name=name, id=id, categories=categories, supported_resources=supported_resources,
                         missing_block_result=CheckResult.PASSED)

    def get_inspected_key(self):
        return "site_config/[0]/min_tls_version/[0]"

    def get_expected_value(self):
        return '1.2'


check = AppServiceSlotMinTLS()
