from __future__ import annotations

from typing import Any

from pingsafe_cli.psgraph.common.models.enums import CheckCategories
from pingsafe_cli.psgraph.terraform.checks.resource.base_resource_negative_value_check import BaseResourceNegativeValueCheck


class K8SNodeGroupAutoUpgrade(BaseResourceNegativeValueCheck):
    def __init__(self) -> None:
        name = "Ensure Kubernetes node group auto-upgrade is enabled."
        id = "CKV_YC_8"
        categories = (CheckCategories.GENERAL_SECURITY,)
        supported_resources = ("yandex_kubernetes_node_group",)
        super().__init__(
            name=name,
            id=id,
            categories=categories,
            supported_resources=supported_resources,
        )

    def get_inspected_key(self) -> str:
        return "maintenance_policy/[0]/auto_upgrade"

    def get_forbidden_values(self) -> list[Any]:
        return [False]


check = K8SNodeGroupAutoUpgrade()
