# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['swarms',
 'swarms.agents',
 'swarms.agents.models',
 'swarms.agents.models.groundingdino',
 'swarms.agents.models.groundingdino.config',
 'swarms.agents.models.groundingdino.datasets',
 'swarms.agents.models.groundingdino.models',
 'swarms.agents.models.groundingdino.models.GroundingDINO',
 'swarms.agents.models.groundingdino.models.GroundingDINO.backbone',
 'swarms.agents.models.groundingdino.util',
 'swarms.agents.models.segment_anything',
 'swarms.agents.models.segment_anything.scripts',
 'swarms.agents.models.segment_anything.segment_anything',
 'swarms.agents.models.segment_anything.segment_anything.modeling',
 'swarms.agents.models.segment_anything.segment_anything.utils',
 'swarms.agents.multi_modal_workers',
 'swarms.agents.multi_modal_workers.omni_agent',
 'swarms.artifacts',
 'swarms.boss',
 'swarms.embeddings',
 'swarms.hivemind',
 'swarms.memory',
 'swarms.models',
 'swarms.models.prompts',
 'swarms.models.prompts.prebuild',
 'swarms.structs',
 'swarms.swarms',
 'swarms.tools',
 'swarms.utils',
 'swarms.workers']

package_data = \
{'': ['*'],
 'swarms.agents.models.groundingdino.models.GroundingDINO': ['csrc/*',
                                                             'csrc/MsDeformAttn/*'],
 'swarms.agents.models.segment_anything': ['assets/*',
                                           'demo/*',
                                           'demo/configs/webpack/*',
                                           'demo/src/*',
                                           'demo/src/assets/*',
                                           'demo/src/assets/data/*',
                                           'demo/src/assets/scss/*',
                                           'demo/src/components/*',
                                           'demo/src/components/helpers/*',
                                           'demo/src/components/hooks/*',
                                           'notebooks/*',
                                           'notebooks/images/*']}

install_requires = \
['Pillow',
 'agent-protocol',
 'asyncio',
 'beautifulsoup4',
 'chromadb',
 'duckduckgo-search',
 'einops',
 'exxa',
 'faiss-cpu',
 'ggl',
 'google-generativeai',
 'httpx',
 'langchain',
 'langchain-experimental',
 'nest_asyncio',
 'open-interpreter',
 'openai',
 'pegasusx',
 'playwright',
 'pydantic',
 'redis',
 'tabulate',
 'tenacity',
 'termcolor',
 'torch',
 'transformers',
 'wget']

setup_kwargs = {
    'name': 'swarms',
    'version': '1.7.6',
    'description': 'Swarms - Pytorch',
    'long_description': '![Swarming banner icon](images/swarmsbanner.png)\n\n<div align="center">\n\nSwarms is a modular framework that enables reliable and useful multi-agent collaboration at scale to automate real-world tasks.\n\n\n[![GitHub issues](https://img.shields.io/github/issues/kyegomez/swarms)](https://github.com/kyegomez/swarms/issues) [![GitHub forks](https://img.shields.io/github/forks/kyegomez/swarms)](https://github.com/kyegomez/swarms/network) [![GitHub stars](https://img.shields.io/github/stars/kyegomez/swarms)](https://github.com/kyegomez/swarms/stargazers) [![GitHub license](https://img.shields.io/github/license/kyegomez/swarms)](https://github.com/kyegomez/swarms/blob/main/LICENSE)[![GitHub star chart](https://img.shields.io/github/stars/kyegomez/swarms?style=social)](https://star-history.com/#kyegomez/swarms)[![Dependency Status](https://img.shields.io/librariesio/github/kyegomez/swarms)](https://libraries.io/github/kyegomez/swarms) [![Downloads](https://static.pepy.tech/badge/swarms/month)](https://pepy.tech/project/swarms)\n\n\n### Share on Social Media\n\n[![Join the Agora discord](https://img.shields.io/discord/1110910277110743103?label=Discord&logo=discord&logoColor=white&style=plastic&color=d7b023)![Share on Twitter](https://img.shields.io/twitter/url/https/twitter.com/cloudposse.svg?style=social&label=Share%20%40kyegomez/swarms)](https://twitter.com/intent/tweet?text=Check%20out%20this%20amazing%20AI%20project:%20&url=https%3A%2F%2Fgithub.com%2Fkyegomez%2Fswarms) [![Share on Facebook](https://img.shields.io/badge/Share-%20facebook-blue)](https://www.facebook.com/sharer/sharer.php?u=https%3A%2F%2Fgithub.com%2Fkyegomez%2Fswarms) [![Share on LinkedIn](https://img.shields.io/badge/Share-%20linkedin-blue)](https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fgithub.com%2Fkyegomez%2Fswarms&title=&summary=&source=)\n\n[![Share on Reddit](https://img.shields.io/badge/-Share%20on%20Reddit-orange)](https://www.reddit.com/submit?url=https%3A%2F%2Fgithub.com%2Fkyegomez%2Fswarms&title=Swarms%20-%20the%20future%20of%20AI) [![Share on Hacker News](https://img.shields.io/badge/-Share%20on%20Hacker%20News-orange)](https://news.ycombinator.com/submitlink?u=https%3A%2F%2Fgithub.com%2Fkyegomez%2Fswarms&t=Swarms%20-%20the%20future%20of%20AI) [![Share on Pinterest](https://img.shields.io/badge/-Share%20on%20Pinterest-red)](https://pinterest.com/pin/create/button/?url=https%3A%2F%2Fgithub.com%2Fkyegomez%2Fswarms&media=https%3A%2F%2Fexample.com%2Fimage.jpg&description=Swarms%20-%20the%20future%20of%20AI) [![Share on WhatsApp](https://img.shields.io/badge/-Share%20on%20WhatsApp-green)](https://api.whatsapp.com/send?text=Check%20out%20Swarms%20-%20the%20future%20of%20AI%20%23swarms%20%23AI%0A%0Ahttps%3A%2F%2Fgithub.com%2Fkyegomez%2Fswarms)\n\n</div>\n\n\n## Purpose\nAt Swarms, we\'re transforming the landscape of AI from siloed AI agents to a unified \'swarm\' of intelligence. Through relentless iteration and the power of collective insight from our 1500+ Agora researchers, we\'re developing a groundbreaking framework for AI collaboration. Our mission is to catalyze a paradigm shift, advancing Humanity with the power of unified autonomous AI agent swarms.\n\n-----\n\n# 🤝 Schedule a 1-on-1 Session\nBook a [1-on-1 Session with Kye](https://calendly.com/apacai/agora), the Creator, to discuss any issues, provide feedback, or explore how we can improve Swarms for you.\n\n\n## Hiring\nWe\'re hiring: Engineers, Researchers, Interns And, salesprofessionals to work on democratizing swarms, email me at with your story at `kye@apac.ai`\n\n----------\n\n## Installation\n* `pip3 install swarms`\n\n---\n\n## Usage\nWe have a small gallery of examples to run here, [for more check out the docs to build your own agent and or swarms!](https://docs.apac.ai)\n\n### `MultiAgentDebate`\n\n- `MultiAgentDebate` is a simple class that enables multi agent collaboration.\n\n```python\nfrom swarms import Worker, MultiAgentDebate, select_speaker\n\n# Initialize agents\nworker1 = Worker(openai_api_key="", ai_name="Optimus Prime")\nworker2 = Worker(openai_api_key="", ai_name="Bumblebee")\nworker3 = Worker(openai_api_key="", ai_name="Megatron")\n\nagents = [\n    worker1,\n    worker2,\n    worker3\n]\n\n# Initialize multi-agent debate with the selection function\ndebate = MultiAgentDebate(agents, select_speaker)\n\n# Run task\ntask = "What were the winning boston marathon times for the past 5 years (ending in 2022)? Generate a table of the year, name, country of origin, and times."\nresults = debate.run(task, max_iters=4)\n\n# Print results\nfor result in results:\n    print(f"Agent {result[\'agent\']} responded: {result[\'response\']}")\n```\n\n----\n\n### `Worker`\n- The `Worker` is an fully feature complete agent with an llm, tools, and a vectorstore for long term memory!\n\n```python\nfrom langchain.models import ChatOpenAI\nfrom swarms import Worker\n\nllm = ChatOpenAI(\n    model_name=\'gpt-4\', \n    openai_api_key="api-key", \n    temperature=0.5\n)\n\nnode = Worker(\n    llm=llm,\n    ai_name="Optimus Prime",\n    ai_role="Worker in a swarm",\n    external_tools = None,\n    human_in_the_loop = False,\n    temperature = 0.5,\n)\n\ntask = "What were the winning boston marathon times for the past 5 years (ending in 2022)? Generate a table of the year, name, country of origin, and times."\nresponse = node.run(task)\nprint(response)\n\n```\n\n------\n\n### `OmniModalAgent`\n- OmniModal Agent is an LLM that access to 10+ multi-modal encoders and diffusers! It can generate images, videos, speech, music and so much more, get started with:\n\n```python\nfrom langchain.llms import OpenAIChat\nfrom swarms.agents import OmniModalAgent\n\n\nllm = OpenAIChat(model_name="gpt-4")\n\nagent = OmniModalAgent(llm)\n\nagent.run("Create a video of a swarm of fish")\n\n```\n\n- OmniModal Agent has a ui in the root called `python3 omni_ui.py`\n\n---\n\n# Documentation\nFor documentation, go here, [swarms.apac.ai](https://swarms.apac.ai)\n\n**NOTE: We need help building the documentation**\n\n-----\n\n# Docker Setup\nThe docker file is located in the docker folder in the `infra` folder, [click here and navigate here in your environment](/infra/Docker)\n\n* Build the Docker image\n\n* You can build the Docker image using the provided Dockerfile. Navigate to the infra/Docker directory where the Dockerfiles are located.\n\n* For the CPU version, use:\n\n```bash\ndocker build -t swarms-api:latest -f Dockerfile.cpu .\n```\nFor the GPU version, use:\n\n```bash\ndocker build -t swarms-api:gpu -f Dockerfile.gpu .\n```\n### Run the Docker container\n\nAfter building the Docker image, you can run the Swarms API in a Docker container. Replace your_redis_host and your_redis_port with your actual Redis host and port.\n\nFor the CPU version:\n\n```bash\ndocker run -p 8000:8000 -e REDIS_HOST=your_redis_host -e REDIS_PORT=your_redis_port swarms-api:latest\n```\n\n## For the GPU version:\n```bash\ndocker run --gpus all -p 8000:8000 -e REDIS_HOST=your_redis_host -e REDIS_PORT=your_redis_port swarms-api:gpu\n```\n\n## Access the Swarms API\n\n* The Swarms API will be accessible at http://localhost:8000. You can use tools like curl or Postman to send requests to the API.\n\nHere\'s an example curl command to send a POST request to the /chat endpoint:\n\n```bash\ncurl -X POST -H "Content-Type: application/json" -d \'{"api_key": "your_openai_api_key", "objective": "your_objective"}\' http://localhost:8000/chat\n```\nReplace your_openai_api_key and your_objective with your actual OpenAI API key and objective.\n\n----\n\n\n# ✨ Features\n* Easy to use Base LLMs, `OpenAI` `Palm` `Anthropic` `HuggingFace`\n* Enterprise Grade, Production Ready with robust Error Handling\n* Multi-Modality Native with Multi-Modal LLMs as tools\n* Infinite Memory Processing: Store infinite sequences of infinite Multi-Modal data, text, images, videos, audio\n* Usability: Extreme emphasis on useability, code is at it\'s theortical minimum simplicity factor to use\n* Reliability: Outputs that accomplish tasks and activities you wish to execute.\n* Fluidity: A seamless all-around experience to build production grade workflows\n* Speed: Lower the time to automate tasks by 90%. \n* Simplicity: Swarms is extremely simple to use, if not thee simplest agent framework of all time\n* Powerful: Swarms is capable of building entire software apps, to large scale data analysis, and handling chaotic situations\n\n\n-----\n\n## Contribute\nWe\'re always looking for contributors to help us improve and expand this project. If you\'re interested, please check out our [Contributing Guidelines](DOCS/C0NTRIBUTING.md).\n\nThank you for being a part of our project!\n\n---\n# Roadmap\n\nPlease checkout our [Roadmap](DOCS/ROADMAP.md) and consider contributing to make the dream of Swarms real to advance Humanity.\n\n## Optimization Priorities\n\n1. **Reliability**: Increase the reliability of the swarm - obtaining the desired output with a basic and un-detailed input.\n\n2. **Speed**: Reduce the time it takes for the swarm to accomplish tasks by improving the communication layer, critiquing, and self-alignment with meta prompting.\n\n3. **Scalability**: Ensure that the system is asynchronous, concurrent, and self-healing to support scalability.\n\nOur goal is to continuously improve Swarms by following this roadmap, while also being adaptable to new needs and opportunities as they arise.\n\n---\n\n# Bounty Program\n\nOur bounty program is an exciting opportunity for contributors to help us build the future of Swarms. By participating, you can earn rewards while contributing to a project that aims to revolutionize digital activity.\n\nHere\'s how it works:\n\n1. **Check out our Roadmap**: We\'ve shared our roadmap detailing our short and long-term goals. These are the areas where we\'re seeking contributions.\n\n2. **Pick a Task**: Choose a task from the roadmap that aligns with your skills and interests. If you\'re unsure, you can reach out to our team for guidance.\n\n3. **Get to Work**: Once you\'ve chosen a task, start working on it. Remember, quality is key. We\'re looking for contributions that truly make a difference.\n\n4. **Submit your Contribution**: Once your work is complete, submit it for review. We\'ll evaluate your contribution based on its quality, relevance, and the value it brings to Swarms.\n\n5. **Earn Rewards**: If your contribution is approved, you\'ll earn a bounty. The amount of the bounty depends on the complexity of the task, the quality of your work, and the value it brings to Swarms.\n\n---\n\n## The Plan\n\n### Phase 1: Building the Foundation\nIn the first phase, our focus is on building the basic infrastructure of Swarms. This includes developing key components like the Swarms class, integrating essential tools, and establishing task completion and evaluation logic. We\'ll also start developing our testing and evaluation framework during this phase. If you\'re interested in foundational work and have a knack for building robust, scalable systems, this phase is for you.\n\n### Phase 2: Optimizing the System\nIn the second phase, we\'ll focus on optimizng Swarms by integrating more advanced features, improving the system\'s efficiency, and refining our testing and evaluation framework. This phase involves more complex tasks, so if you enjoy tackling challenging problems and contributing to the development of innovative features, this is the phase for you.\n\n### Phase 3: Towards Super-Intelligence\nThe third phase of our bounty program is the most exciting - this is where we aim to achieve super-intelligence. In this phase, we\'ll be working on improving the swarm\'s capabilities, expanding its skills, and fine-tuning the system based on real-world testing and feedback. If you\'re excited about the future of AI and want to contribute to a project that could potentially transform the digital world, this is the phase for you.\n\nRemember, our roadmap is a guide, and we encourage you to bring your own ideas and creativity to the table. We believe that every contribution, no matter how small, can make a difference. So join us on this exciting journey and help us create the future of Swarms.\n\n<!-- **To participate in our bounty program, visit the [Swarms Bounty Program Page](https://swarms.ai/bounty).** Let\'s build the future together! -->\n\n\n\n---\n\n# EcoSystem\n\n* [The-Compiler, compile natural language into serene, reliable, and secure programs](https://github.com/kyegomez/the-compiler)\n\n*[The Replicator, an autonomous swarm that conducts Multi-Modal AI research by creating new underlying mathematical operations and models](https://github.com/kyegomez/The-Replicator)\n\n* Make a swarm that checks arxviv for papers -> checks if there is a github link -> then implements them and checks them\n\n* [SwarmLogic, where a swarm is your API, database, and backend!](https://github.com/kyegomez/SwarmLogic)\n\n---\n\n# Demos\n\n![Swarms Demo](images/Screenshot_48.png)\n\n## Swarm Video Demo {Click for more}\n\n[![Watch the swarm video](https://img.youtube.com/vi/Br62cDMYXgc/maxresdefault.jpg)](https://youtu.be/Br62cDMYXgc)\n\n---\n\n# Contact \nFor enterprise and production ready deployments, allow us to discover more about you and your story, [book a call with us here](https://www.apac.ai/Setup-Call)',
    'author': 'Kye Gomez',
    'author_email': 'kye@apac.ai',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/kyegomez/swarms',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8.1,<4.0.0',
}


setup(**setup_kwargs)
