# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ConnectionAdditionalAttributeArgs',
    'ConnectionIngressIpArgs',
    'JobProgressArgs',
    'JobProgressPhaseArgs',
    'JobProgressPhaseExtractArgs',
    'JobProgressPhaseLogLocationArgs',
    'JobUnsupportedObjectArgs',
    'MigrationAdvisorSettingsArgs',
    'MigrationDataTransferMediumDetailsArgs',
    'MigrationDataTransferMediumDetailsObjectStorageBucketArgs',
    'MigrationDataTransferMediumDetailsSourceArgs',
    'MigrationDataTransferMediumDetailsTargetArgs',
    'MigrationExcludeObjectArgs',
    'MigrationGgsDetailsArgs',
    'MigrationGgsDetailsExtractArgs',
    'MigrationGgsDetailsGgsDeploymentArgs',
    'MigrationGgsDetailsReplicatArgs',
    'MigrationHubDetailsArgs',
    'MigrationHubDetailsExtractArgs',
    'MigrationHubDetailsReplicatArgs',
    'MigrationHubDetailsRestAdminCredentialsArgs',
    'MigrationIncludeObjectArgs',
    'MigrationInitialLoadSettingsArgs',
    'MigrationInitialLoadSettingsDataPumpParametersArgs',
    'MigrationInitialLoadSettingsExportDirectoryObjectArgs',
    'MigrationInitialLoadSettingsImportDirectoryObjectArgs',
    'MigrationInitialLoadSettingsMetadataRemapArgs',
    'MigrationInitialLoadSettingsTablespaceDetailsArgs',
    'GetConnectionsFilterArgs',
    'GetMigrationObjectTypesFilterArgs',
]

@pulumi.input_type
class ConnectionAdditionalAttributeArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: (Updatable) The name of the property entry.
        :param pulumi.Input[str] value: (Updatable) The value of the property entry.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name of the property entry.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The value of the property entry.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ConnectionIngressIpArgs:
    def __init__(__self__, *,
                 ingress_ip: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] ingress_ip: A Private Endpoint IPv4 or IPv6 Address created in the customer's subnet.
        """
        if ingress_ip is not None:
            pulumi.set(__self__, "ingress_ip", ingress_ip)

    @property
    @pulumi.getter(name="ingressIp")
    def ingress_ip(self) -> Optional[pulumi.Input[str]]:
        """
        A Private Endpoint IPv4 or IPv6 Address created in the customer's subnet.
        """
        return pulumi.get(self, "ingress_ip")

    @ingress_ip.setter
    def ingress_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ingress_ip", value)


@pulumi.input_type
class JobProgressArgs:
    def __init__(__self__, *,
                 current_phase: Optional[pulumi.Input[str]] = None,
                 current_status: Optional[pulumi.Input[str]] = None,
                 phases: Optional[pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseArgs']]]] = None):
        """
        :param pulumi.Input[str] current_phase: Current phase of the job.
        :param pulumi.Input[str] current_status: Current status of the job.
        :param pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseArgs']]] phases: List of phase status for the job.
        """
        if current_phase is not None:
            pulumi.set(__self__, "current_phase", current_phase)
        if current_status is not None:
            pulumi.set(__self__, "current_status", current_status)
        if phases is not None:
            pulumi.set(__self__, "phases", phases)

    @property
    @pulumi.getter(name="currentPhase")
    def current_phase(self) -> Optional[pulumi.Input[str]]:
        """
        Current phase of the job.
        """
        return pulumi.get(self, "current_phase")

    @current_phase.setter
    def current_phase(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "current_phase", value)

    @property
    @pulumi.getter(name="currentStatus")
    def current_status(self) -> Optional[pulumi.Input[str]]:
        """
        Current status of the job.
        """
        return pulumi.get(self, "current_status")

    @current_status.setter
    def current_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "current_status", value)

    @property
    @pulumi.getter
    def phases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseArgs']]]]:
        """
        List of phase status for the job.
        """
        return pulumi.get(self, "phases")

    @phases.setter
    def phases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseArgs']]]]):
        pulumi.set(self, "phases", value)


@pulumi.input_type
class JobProgressPhaseArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[str]] = None,
                 duration_in_ms: Optional[pulumi.Input[int]] = None,
                 extracts: Optional[pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseExtractArgs']]]] = None,
                 is_advisor_report_available: Optional[pulumi.Input[bool]] = None,
                 issue: Optional[pulumi.Input[str]] = None,
                 log_locations: Optional[pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseLogLocationArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 progress: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] action: The text describing the action required to fix the issue
        :param pulumi.Input[int] duration_in_ms: Duration of the phase in milliseconds
        :param pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseExtractArgs']]] extracts: Summary of phase status results.
        :param pulumi.Input[bool] is_advisor_report_available: True if a Pre-Migration Advisor report is available for this phase. False or null if no report is available.
        :param pulumi.Input[str] issue: The text describing the root cause of the reported issue
        :param pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseLogLocationArgs']]] log_locations: Details to access log file in the specified Object Storage bucket, if any.
        :param pulumi.Input[str] name: Phase name
        :param pulumi.Input[int] progress: Percent progress of job phase.
        :param pulumi.Input[str] status: Phase status
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if duration_in_ms is not None:
            pulumi.set(__self__, "duration_in_ms", duration_in_ms)
        if extracts is not None:
            pulumi.set(__self__, "extracts", extracts)
        if is_advisor_report_available is not None:
            pulumi.set(__self__, "is_advisor_report_available", is_advisor_report_available)
        if issue is not None:
            pulumi.set(__self__, "issue", issue)
        if log_locations is not None:
            pulumi.set(__self__, "log_locations", log_locations)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if progress is not None:
            pulumi.set(__self__, "progress", progress)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        The text describing the action required to fix the issue
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="durationInMs")
    def duration_in_ms(self) -> Optional[pulumi.Input[int]]:
        """
        Duration of the phase in milliseconds
        """
        return pulumi.get(self, "duration_in_ms")

    @duration_in_ms.setter
    def duration_in_ms(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "duration_in_ms", value)

    @property
    @pulumi.getter
    def extracts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseExtractArgs']]]]:
        """
        Summary of phase status results.
        """
        return pulumi.get(self, "extracts")

    @extracts.setter
    def extracts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseExtractArgs']]]]):
        pulumi.set(self, "extracts", value)

    @property
    @pulumi.getter(name="isAdvisorReportAvailable")
    def is_advisor_report_available(self) -> Optional[pulumi.Input[bool]]:
        """
        True if a Pre-Migration Advisor report is available for this phase. False or null if no report is available.
        """
        return pulumi.get(self, "is_advisor_report_available")

    @is_advisor_report_available.setter
    def is_advisor_report_available(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_advisor_report_available", value)

    @property
    @pulumi.getter
    def issue(self) -> Optional[pulumi.Input[str]]:
        """
        The text describing the root cause of the reported issue
        """
        return pulumi.get(self, "issue")

    @issue.setter
    def issue(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issue", value)

    @property
    @pulumi.getter(name="logLocations")
    def log_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseLogLocationArgs']]]]:
        """
        Details to access log file in the specified Object Storage bucket, if any.
        """
        return pulumi.get(self, "log_locations")

    @log_locations.setter
    def log_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseLogLocationArgs']]]]):
        pulumi.set(self, "log_locations", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Phase name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def progress(self) -> Optional[pulumi.Input[int]]:
        """
        Percent progress of job phase.
        """
        return pulumi.get(self, "progress")

    @progress.setter
    def progress(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "progress", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Phase status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class JobProgressPhaseExtractArgs:
    def __init__(__self__, *,
                 message: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] message: Message in entry.
        :param pulumi.Input[str] type: Type of unsupported object
        """
        if message is not None:
            pulumi.set(__self__, "message", message)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        Message in entry.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of unsupported object
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class JobProgressPhaseLogLocationArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 object: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket: Name of the bucket containing the log file.
        :param pulumi.Input[str] namespace: Object Storage namespace.
        :param pulumi.Input[str] object: Name of the object (regular expression is allowed)
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the bucket containing the log file.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the object (regular expression is allowed)
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object", value)


@pulumi.input_type
class JobUnsupportedObjectArgs:
    def __init__(__self__, *,
                 object: Optional[pulumi.Input[str]] = None,
                 owner: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] object: Name of the object (regular expression is allowed)
        :param pulumi.Input[str] owner: Owner of the object (regular expression is allowed)
        :param pulumi.Input[str] type: Type of unsupported object
        """
        if object is not None:
            pulumi.set(__self__, "object", object)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the object (regular expression is allowed)
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[str]]:
        """
        Owner of the object (regular expression is allowed)
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of unsupported object
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class MigrationAdvisorSettingsArgs:
    def __init__(__self__, *,
                 is_ignore_errors: Optional[pulumi.Input[bool]] = None,
                 is_skip_advisor: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] is_ignore_errors: (Updatable) True to not interrupt migration execution due to Pre-Migration Advisor errors. Default is false.
        :param pulumi.Input[bool] is_skip_advisor: (Updatable) True to skip the Pre-Migration Advisor execution. Default is false.
        """
        if is_ignore_errors is not None:
            pulumi.set(__self__, "is_ignore_errors", is_ignore_errors)
        if is_skip_advisor is not None:
            pulumi.set(__self__, "is_skip_advisor", is_skip_advisor)

    @property
    @pulumi.getter(name="isIgnoreErrors")
    def is_ignore_errors(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) True to not interrupt migration execution due to Pre-Migration Advisor errors. Default is false.
        """
        return pulumi.get(self, "is_ignore_errors")

    @is_ignore_errors.setter
    def is_ignore_errors(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_ignore_errors", value)

    @property
    @pulumi.getter(name="isSkipAdvisor")
    def is_skip_advisor(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) True to skip the Pre-Migration Advisor execution. Default is false.
        """
        return pulumi.get(self, "is_skip_advisor")

    @is_skip_advisor.setter
    def is_skip_advisor(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_skip_advisor", value)


@pulumi.input_type
class MigrationDataTransferMediumDetailsArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 access_key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 object_storage_bucket: Optional[pulumi.Input['MigrationDataTransferMediumDetailsObjectStorageBucketArgs']] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 secret_access_key: Optional[pulumi.Input[str]] = None,
                 shared_storage_mount_target_id: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input['MigrationDataTransferMediumDetailsSourceArgs']] = None,
                 target: Optional[pulumi.Input['MigrationDataTransferMediumDetailsTargetArgs']] = None):
        """
        :param pulumi.Input[str] type: (Updatable) Type of the data transfer medium to use.
        :param pulumi.Input[str] access_key_id: (Updatable) AWS access key credentials identifier Details: https://docs.aws.amazon.com/general/latest/gr/aws-sec-cred-types.html#access-keys-and-secret-access-keys
        :param pulumi.Input[str] name: (Updatable) Name of database link from Oracle Cloud Infrastructure database to on-premise database. ODMS will create link,  if the link does not already exist.
        :param pulumi.Input['MigrationDataTransferMediumDetailsObjectStorageBucketArgs'] object_storage_bucket: (Updatable) In lieu of a network database link, Oracle Cloud Infrastructure Object Storage bucket will be used to store Data Pump dump files for the migration. Additionally, it can be specified alongside a database link data transfer medium.
        :param pulumi.Input[str] region: (Updatable) AWS region code where the S3 bucket is located. Region code should match the documented available regions: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-available-regions
        :param pulumi.Input[str] secret_access_key: (Updatable) AWS secret access key credentials Details: https://docs.aws.amazon.com/general/latest/gr/aws-sec-cred-types.html#access-keys-and-secret-access-keys
        :param pulumi.Input[str] shared_storage_mount_target_id: (Updatable) OCID of the shared storage mount target
        :param pulumi.Input['MigrationDataTransferMediumDetailsSourceArgs'] source: (Updatable) Optional additional properties for dump transfer in source or target host. Default kind is CURL.
        :param pulumi.Input['MigrationDataTransferMediumDetailsTargetArgs'] target: (Updatable) Optional additional properties for dump transfer in source or target host. Default kind is CURL.
        """
        pulumi.set(__self__, "type", type)
        if access_key_id is not None:
            pulumi.set(__self__, "access_key_id", access_key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_storage_bucket is not None:
            pulumi.set(__self__, "object_storage_bucket", object_storage_bucket)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_access_key is not None:
            pulumi.set(__self__, "secret_access_key", secret_access_key)
        if shared_storage_mount_target_id is not None:
            pulumi.set(__self__, "shared_storage_mount_target_id", shared_storage_mount_target_id)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        (Updatable) Type of the data transfer medium to use.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) AWS access key credentials identifier Details: https://docs.aws.amazon.com/general/latest/gr/aws-sec-cred-types.html#access-keys-and-secret-access-keys
        """
        return pulumi.get(self, "access_key_id")

    @access_key_id.setter
    def access_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_key_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of database link from Oracle Cloud Infrastructure database to on-premise database. ODMS will create link,  if the link does not already exist.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="objectStorageBucket")
    def object_storage_bucket(self) -> Optional[pulumi.Input['MigrationDataTransferMediumDetailsObjectStorageBucketArgs']]:
        """
        (Updatable) In lieu of a network database link, Oracle Cloud Infrastructure Object Storage bucket will be used to store Data Pump dump files for the migration. Additionally, it can be specified alongside a database link data transfer medium.
        """
        return pulumi.get(self, "object_storage_bucket")

    @object_storage_bucket.setter
    def object_storage_bucket(self, value: Optional[pulumi.Input['MigrationDataTransferMediumDetailsObjectStorageBucketArgs']]):
        pulumi.set(self, "object_storage_bucket", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) AWS region code where the S3 bucket is located. Region code should match the documented available regions: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-available-regions
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) AWS secret access key credentials Details: https://docs.aws.amazon.com/general/latest/gr/aws-sec-cred-types.html#access-keys-and-secret-access-keys
        """
        return pulumi.get(self, "secret_access_key")

    @secret_access_key.setter
    def secret_access_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_access_key", value)

    @property
    @pulumi.getter(name="sharedStorageMountTargetId")
    def shared_storage_mount_target_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) OCID of the shared storage mount target
        """
        return pulumi.get(self, "shared_storage_mount_target_id")

    @shared_storage_mount_target_id.setter
    def shared_storage_mount_target_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_storage_mount_target_id", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['MigrationDataTransferMediumDetailsSourceArgs']]:
        """
        (Updatable) Optional additional properties for dump transfer in source or target host. Default kind is CURL.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['MigrationDataTransferMediumDetailsSourceArgs']]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input['MigrationDataTransferMediumDetailsTargetArgs']]:
        """
        (Updatable) Optional additional properties for dump transfer in source or target host. Default kind is CURL.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input['MigrationDataTransferMediumDetailsTargetArgs']]):
        pulumi.set(self, "target", value)


@pulumi.input_type
class MigrationDataTransferMediumDetailsObjectStorageBucketArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket: (Updatable) Bucket name.
        :param pulumi.Input[str] namespace: (Updatable) Namespace name of the object store bucket.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Bucket name.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Namespace name of the object store bucket.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)


@pulumi.input_type
class MigrationDataTransferMediumDetailsSourceArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[str],
                 oci_home: Optional[pulumi.Input[str]] = None,
                 wallet_location: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] kind: (Updatable) Type of dump transfer to use during migration in source or target host. Default kind is CURL
        :param pulumi.Input[str] oci_home: (Updatable) Path to the Oracle Cloud Infrastructure CLI installation in the node.
        :param pulumi.Input[str] wallet_location: (Updatable) Directory path to Oracle Cloud Infrastructure SSL wallet location on Db server node.
        """
        pulumi.set(__self__, "kind", kind)
        if oci_home is not None:
            pulumi.set(__self__, "oci_home", oci_home)
        if wallet_location is not None:
            pulumi.set(__self__, "wallet_location", wallet_location)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        """
        (Updatable) Type of dump transfer to use during migration in source or target host. Default kind is CURL
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="ociHome")
    def oci_home(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Path to the Oracle Cloud Infrastructure CLI installation in the node.
        """
        return pulumi.get(self, "oci_home")

    @oci_home.setter
    def oci_home(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oci_home", value)

    @property
    @pulumi.getter(name="walletLocation")
    def wallet_location(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Directory path to Oracle Cloud Infrastructure SSL wallet location on Db server node.
        """
        return pulumi.get(self, "wallet_location")

    @wallet_location.setter
    def wallet_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wallet_location", value)


@pulumi.input_type
class MigrationDataTransferMediumDetailsTargetArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[str],
                 oci_home: Optional[pulumi.Input[str]] = None,
                 wallet_location: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] kind: (Updatable) Type of dump transfer to use during migration in source or target host. Default kind is CURL
        :param pulumi.Input[str] oci_home: (Updatable) Path to the Oracle Cloud Infrastructure CLI installation in the node.
        :param pulumi.Input[str] wallet_location: (Updatable) Directory path to Oracle Cloud Infrastructure SSL wallet location on Db server node.
        """
        pulumi.set(__self__, "kind", kind)
        if oci_home is not None:
            pulumi.set(__self__, "oci_home", oci_home)
        if wallet_location is not None:
            pulumi.set(__self__, "wallet_location", wallet_location)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        """
        (Updatable) Type of dump transfer to use during migration in source or target host. Default kind is CURL
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="ociHome")
    def oci_home(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Path to the Oracle Cloud Infrastructure CLI installation in the node.
        """
        return pulumi.get(self, "oci_home")

    @oci_home.setter
    def oci_home(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oci_home", value)

    @property
    @pulumi.getter(name="walletLocation")
    def wallet_location(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Directory path to Oracle Cloud Infrastructure SSL wallet location on Db server node.
        """
        return pulumi.get(self, "wallet_location")

    @wallet_location.setter
    def wallet_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wallet_location", value)


@pulumi.input_type
class MigrationExcludeObjectArgs:
    def __init__(__self__, *,
                 object: pulumi.Input[str],
                 is_omit_excluded_table_from_replication: Optional[pulumi.Input[bool]] = None,
                 owner: Optional[pulumi.Input[str]] = None,
                 schema: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] object: Name of the object (regular expression is allowed)
        :param pulumi.Input[bool] is_omit_excluded_table_from_replication: Whether an excluded table should be omitted from replication. Only valid for database objects  that have are of type TABLE and object status EXCLUDE.
        :param pulumi.Input[str] owner: Owner of the object (regular expression is allowed)
        :param pulumi.Input[str] schema: Schema of the object (regular expression is allowed)
        :param pulumi.Input[str] type: Type of object to exclude. If not specified, matching owners and object names of type TABLE would be excluded.
        """
        pulumi.set(__self__, "object", object)
        if is_omit_excluded_table_from_replication is not None:
            pulumi.set(__self__, "is_omit_excluded_table_from_replication", is_omit_excluded_table_from_replication)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def object(self) -> pulumi.Input[str]:
        """
        Name of the object (regular expression is allowed)
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: pulumi.Input[str]):
        pulumi.set(self, "object", value)

    @property
    @pulumi.getter(name="isOmitExcludedTableFromReplication")
    def is_omit_excluded_table_from_replication(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether an excluded table should be omitted from replication. Only valid for database objects  that have are of type TABLE and object status EXCLUDE.
        """
        return pulumi.get(self, "is_omit_excluded_table_from_replication")

    @is_omit_excluded_table_from_replication.setter
    def is_omit_excluded_table_from_replication(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_omit_excluded_table_from_replication", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[str]]:
        """
        Owner of the object (regular expression is allowed)
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[str]]:
        """
        Schema of the object (regular expression is allowed)
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of object to exclude. If not specified, matching owners and object names of type TABLE would be excluded.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class MigrationGgsDetailsArgs:
    def __init__(__self__, *,
                 acceptable_lag: Optional[pulumi.Input[int]] = None,
                 extract: Optional[pulumi.Input['MigrationGgsDetailsExtractArgs']] = None,
                 ggs_deployments: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationGgsDetailsGgsDeploymentArgs']]]] = None,
                 replicat: Optional[pulumi.Input['MigrationGgsDetailsReplicatArgs']] = None):
        """
        :param pulumi.Input[int] acceptable_lag: (Updatable) ODMS will monitor GoldenGate end-to-end latency until the lag time is lower than the specified value in seconds.
        :param pulumi.Input['MigrationGgsDetailsExtractArgs'] extract: (Updatable) Parameters for GoldenGate Extract processes.
        :param pulumi.Input[Sequence[pulumi.Input['MigrationGgsDetailsGgsDeploymentArgs']]] ggs_deployments: Details about Oracle GoldenGate GGS Deployment.
        :param pulumi.Input['MigrationGgsDetailsReplicatArgs'] replicat: (Updatable) Parameters for GoldenGate Replicat processes.
        """
        if acceptable_lag is not None:
            pulumi.set(__self__, "acceptable_lag", acceptable_lag)
        if extract is not None:
            pulumi.set(__self__, "extract", extract)
        if ggs_deployments is not None:
            pulumi.set(__self__, "ggs_deployments", ggs_deployments)
        if replicat is not None:
            pulumi.set(__self__, "replicat", replicat)

    @property
    @pulumi.getter(name="acceptableLag")
    def acceptable_lag(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) ODMS will monitor GoldenGate end-to-end latency until the lag time is lower than the specified value in seconds.
        """
        return pulumi.get(self, "acceptable_lag")

    @acceptable_lag.setter
    def acceptable_lag(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "acceptable_lag", value)

    @property
    @pulumi.getter
    def extract(self) -> Optional[pulumi.Input['MigrationGgsDetailsExtractArgs']]:
        """
        (Updatable) Parameters for GoldenGate Extract processes.
        """
        return pulumi.get(self, "extract")

    @extract.setter
    def extract(self, value: Optional[pulumi.Input['MigrationGgsDetailsExtractArgs']]):
        pulumi.set(self, "extract", value)

    @property
    @pulumi.getter(name="ggsDeployments")
    def ggs_deployments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MigrationGgsDetailsGgsDeploymentArgs']]]]:
        """
        Details about Oracle GoldenGate GGS Deployment.
        """
        return pulumi.get(self, "ggs_deployments")

    @ggs_deployments.setter
    def ggs_deployments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationGgsDetailsGgsDeploymentArgs']]]]):
        pulumi.set(self, "ggs_deployments", value)

    @property
    @pulumi.getter
    def replicat(self) -> Optional[pulumi.Input['MigrationGgsDetailsReplicatArgs']]:
        """
        (Updatable) Parameters for GoldenGate Replicat processes.
        """
        return pulumi.get(self, "replicat")

    @replicat.setter
    def replicat(self, value: Optional[pulumi.Input['MigrationGgsDetailsReplicatArgs']]):
        pulumi.set(self, "replicat", value)


@pulumi.input_type
class MigrationGgsDetailsExtractArgs:
    def __init__(__self__, *,
                 long_trans_duration: Optional[pulumi.Input[int]] = None,
                 performance_profile: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] long_trans_duration: (Updatable) Length of time (in seconds) that a transaction can be open before Extract generates a warning message that the transaction is long-running. If not specified, Extract will not generate a warning on long-running transactions.
        :param pulumi.Input[str] performance_profile: (Updatable) Extract performance.
        """
        if long_trans_duration is not None:
            pulumi.set(__self__, "long_trans_duration", long_trans_duration)
        if performance_profile is not None:
            pulumi.set(__self__, "performance_profile", performance_profile)

    @property
    @pulumi.getter(name="longTransDuration")
    def long_trans_duration(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Length of time (in seconds) that a transaction can be open before Extract generates a warning message that the transaction is long-running. If not specified, Extract will not generate a warning on long-running transactions.
        """
        return pulumi.get(self, "long_trans_duration")

    @long_trans_duration.setter
    def long_trans_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "long_trans_duration", value)

    @property
    @pulumi.getter(name="performanceProfile")
    def performance_profile(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Extract performance.
        """
        return pulumi.get(self, "performance_profile")

    @performance_profile.setter
    def performance_profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "performance_profile", value)


@pulumi.input_type
class MigrationGgsDetailsGgsDeploymentArgs:
    def __init__(__self__, *,
                 deployment_id: Optional[pulumi.Input[str]] = None,
                 ggs_admin_credentials_secret_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] deployment_id: The OCID of the resource being referenced.
        :param pulumi.Input[str] ggs_admin_credentials_secret_id: The OCID of the resource being referenced.
        """
        if deployment_id is not None:
            pulumi.set(__self__, "deployment_id", deployment_id)
        if ggs_admin_credentials_secret_id is not None:
            pulumi.set(__self__, "ggs_admin_credentials_secret_id", ggs_admin_credentials_secret_id)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the resource being referenced.
        """
        return pulumi.get(self, "deployment_id")

    @deployment_id.setter
    def deployment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_id", value)

    @property
    @pulumi.getter(name="ggsAdminCredentialsSecretId")
    def ggs_admin_credentials_secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the resource being referenced.
        """
        return pulumi.get(self, "ggs_admin_credentials_secret_id")

    @ggs_admin_credentials_secret_id.setter
    def ggs_admin_credentials_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ggs_admin_credentials_secret_id", value)


@pulumi.input_type
class MigrationGgsDetailsReplicatArgs:
    def __init__(__self__, *,
                 performance_profile: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] performance_profile: (Updatable) Replicat performance.
        """
        if performance_profile is not None:
            pulumi.set(__self__, "performance_profile", performance_profile)

    @property
    @pulumi.getter(name="performanceProfile")
    def performance_profile(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Replicat performance.
        """
        return pulumi.get(self, "performance_profile")

    @performance_profile.setter
    def performance_profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "performance_profile", value)


@pulumi.input_type
class MigrationHubDetailsArgs:
    def __init__(__self__, *,
                 key_id: pulumi.Input[str],
                 rest_admin_credentials: pulumi.Input['MigrationHubDetailsRestAdminCredentialsArgs'],
                 url: pulumi.Input[str],
                 vault_id: pulumi.Input[str],
                 acceptable_lag: Optional[pulumi.Input[int]] = None,
                 compute_id: Optional[pulumi.Input[str]] = None,
                 extract: Optional[pulumi.Input['MigrationHubDetailsExtractArgs']] = None,
                 replicat: Optional[pulumi.Input['MigrationHubDetailsReplicatArgs']] = None):
        """
        :param pulumi.Input[str] key_id: (Updatable) The OCID of the resource being referenced.
        :param pulumi.Input['MigrationHubDetailsRestAdminCredentialsArgs'] rest_admin_credentials: (Updatable) Database Administrator Credentials details.
        :param pulumi.Input[str] url: (Updatable) Endpoint URL.
        :param pulumi.Input[str] vault_id: (Updatable) The OCID of the resource being referenced.
        :param pulumi.Input[int] acceptable_lag: (Updatable) ODMS will monitor GoldenGate end-to-end latency until the lag time is lower than the specified value in seconds.
        :param pulumi.Input[str] compute_id: (Updatable) The OCID of the resource being referenced.
        :param pulumi.Input['MigrationHubDetailsExtractArgs'] extract: (Updatable) Parameters for GoldenGate Extract processes.
        :param pulumi.Input['MigrationHubDetailsReplicatArgs'] replicat: (Updatable) Parameters for GoldenGate Replicat processes.
        """
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "rest_admin_credentials", rest_admin_credentials)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "vault_id", vault_id)
        if acceptable_lag is not None:
            pulumi.set(__self__, "acceptable_lag", acceptable_lag)
        if compute_id is not None:
            pulumi.set(__self__, "compute_id", compute_id)
        if extract is not None:
            pulumi.set(__self__, "extract", extract)
        if replicat is not None:
            pulumi.set(__self__, "replicat", replicat)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the resource being referenced.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_id", value)

    @property
    @pulumi.getter(name="restAdminCredentials")
    def rest_admin_credentials(self) -> pulumi.Input['MigrationHubDetailsRestAdminCredentialsArgs']:
        """
        (Updatable) Database Administrator Credentials details.
        """
        return pulumi.get(self, "rest_admin_credentials")

    @rest_admin_credentials.setter
    def rest_admin_credentials(self, value: pulumi.Input['MigrationHubDetailsRestAdminCredentialsArgs']):
        pulumi.set(self, "rest_admin_credentials", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        (Updatable) Endpoint URL.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the resource being referenced.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vault_id", value)

    @property
    @pulumi.getter(name="acceptableLag")
    def acceptable_lag(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) ODMS will monitor GoldenGate end-to-end latency until the lag time is lower than the specified value in seconds.
        """
        return pulumi.get(self, "acceptable_lag")

    @acceptable_lag.setter
    def acceptable_lag(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "acceptable_lag", value)

    @property
    @pulumi.getter(name="computeId")
    def compute_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the resource being referenced.
        """
        return pulumi.get(self, "compute_id")

    @compute_id.setter
    def compute_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_id", value)

    @property
    @pulumi.getter
    def extract(self) -> Optional[pulumi.Input['MigrationHubDetailsExtractArgs']]:
        """
        (Updatable) Parameters for GoldenGate Extract processes.
        """
        return pulumi.get(self, "extract")

    @extract.setter
    def extract(self, value: Optional[pulumi.Input['MigrationHubDetailsExtractArgs']]):
        pulumi.set(self, "extract", value)

    @property
    @pulumi.getter
    def replicat(self) -> Optional[pulumi.Input['MigrationHubDetailsReplicatArgs']]:
        """
        (Updatable) Parameters for GoldenGate Replicat processes.
        """
        return pulumi.get(self, "replicat")

    @replicat.setter
    def replicat(self, value: Optional[pulumi.Input['MigrationHubDetailsReplicatArgs']]):
        pulumi.set(self, "replicat", value)


@pulumi.input_type
class MigrationHubDetailsExtractArgs:
    def __init__(__self__, *,
                 long_trans_duration: Optional[pulumi.Input[int]] = None,
                 performance_profile: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] long_trans_duration: (Updatable) Length of time (in seconds) that a transaction can be open before Extract generates a warning message that the transaction is long-running. If not specified, Extract will not generate a warning on long-running transactions.
        :param pulumi.Input[str] performance_profile: (Updatable) Extract performance.
        """
        if long_trans_duration is not None:
            pulumi.set(__self__, "long_trans_duration", long_trans_duration)
        if performance_profile is not None:
            pulumi.set(__self__, "performance_profile", performance_profile)

    @property
    @pulumi.getter(name="longTransDuration")
    def long_trans_duration(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Length of time (in seconds) that a transaction can be open before Extract generates a warning message that the transaction is long-running. If not specified, Extract will not generate a warning on long-running transactions.
        """
        return pulumi.get(self, "long_trans_duration")

    @long_trans_duration.setter
    def long_trans_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "long_trans_duration", value)

    @property
    @pulumi.getter(name="performanceProfile")
    def performance_profile(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Extract performance.
        """
        return pulumi.get(self, "performance_profile")

    @performance_profile.setter
    def performance_profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "performance_profile", value)


@pulumi.input_type
class MigrationHubDetailsReplicatArgs:
    def __init__(__self__, *,
                 performance_profile: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] performance_profile: (Updatable) Replicat performance.
        """
        if performance_profile is not None:
            pulumi.set(__self__, "performance_profile", performance_profile)

    @property
    @pulumi.getter(name="performanceProfile")
    def performance_profile(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Replicat performance.
        """
        return pulumi.get(self, "performance_profile")

    @performance_profile.setter
    def performance_profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "performance_profile", value)


@pulumi.input_type
class MigrationHubDetailsRestAdminCredentialsArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[str],
                 username: pulumi.Input[str]):
        """
        :param pulumi.Input[str] password: (Updatable) Administrator password
        :param pulumi.Input[str] username: (Updatable) Administrator username
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        (Updatable) Administrator password
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        (Updatable) Administrator username
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class MigrationIncludeObjectArgs:
    def __init__(__self__, *,
                 object: pulumi.Input[str],
                 is_omit_excluded_table_from_replication: Optional[pulumi.Input[bool]] = None,
                 owner: Optional[pulumi.Input[str]] = None,
                 schema: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] object: Name of the object (regular expression is allowed)
        :param pulumi.Input[bool] is_omit_excluded_table_from_replication: Whether an excluded table should be omitted from replication. Only valid for database objects  that have are of type TABLE and object status EXCLUDE.
        :param pulumi.Input[str] owner: Owner of the object (regular expression is allowed)
        :param pulumi.Input[str] schema: Schema of the object (regular expression is allowed)
        :param pulumi.Input[str] type: Type of object to exclude. If not specified, matching owners and object names of type TABLE would be excluded.
        """
        pulumi.set(__self__, "object", object)
        if is_omit_excluded_table_from_replication is not None:
            pulumi.set(__self__, "is_omit_excluded_table_from_replication", is_omit_excluded_table_from_replication)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def object(self) -> pulumi.Input[str]:
        """
        Name of the object (regular expression is allowed)
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: pulumi.Input[str]):
        pulumi.set(self, "object", value)

    @property
    @pulumi.getter(name="isOmitExcludedTableFromReplication")
    def is_omit_excluded_table_from_replication(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether an excluded table should be omitted from replication. Only valid for database objects  that have are of type TABLE and object status EXCLUDE.
        """
        return pulumi.get(self, "is_omit_excluded_table_from_replication")

    @is_omit_excluded_table_from_replication.setter
    def is_omit_excluded_table_from_replication(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_omit_excluded_table_from_replication", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[str]]:
        """
        Owner of the object (regular expression is allowed)
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[str]]:
        """
        Schema of the object (regular expression is allowed)
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of object to exclude. If not specified, matching owners and object names of type TABLE would be excluded.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class MigrationInitialLoadSettingsArgs:
    def __init__(__self__, *,
                 job_mode: pulumi.Input[str],
                 compatibilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 data_pump_parameters: Optional[pulumi.Input['MigrationInitialLoadSettingsDataPumpParametersArgs']] = None,
                 export_directory_object: Optional[pulumi.Input['MigrationInitialLoadSettingsExportDirectoryObjectArgs']] = None,
                 handle_grant_errors: Optional[pulumi.Input[str]] = None,
                 import_directory_object: Optional[pulumi.Input['MigrationInitialLoadSettingsImportDirectoryObjectArgs']] = None,
                 is_consistent: Optional[pulumi.Input[bool]] = None,
                 is_ignore_existing_objects: Optional[pulumi.Input[bool]] = None,
                 is_tz_utc: Optional[pulumi.Input[bool]] = None,
                 metadata_remaps: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationInitialLoadSettingsMetadataRemapArgs']]]] = None,
                 primary_key_compatibility: Optional[pulumi.Input[str]] = None,
                 tablespace_details: Optional[pulumi.Input['MigrationInitialLoadSettingsTablespaceDetailsArgs']] = None):
        """
        :param pulumi.Input[str] job_mode: (Updatable) Oracle Job Mode
        :param pulumi.Input[Sequence[pulumi.Input[str]]] compatibilities: (Updatable) Apply the specified requirements for compatibility with MySQL Database Service for all tables in the dump  output, altering the dump files as necessary.
        :param pulumi.Input['MigrationInitialLoadSettingsDataPumpParametersArgs'] data_pump_parameters: (Updatable) Optional parameters for Data Pump Export and Import.
        :param pulumi.Input['MigrationInitialLoadSettingsExportDirectoryObjectArgs'] export_directory_object: (Updatable) Directory object details, used to define either import or export directory objects in Data Pump Settings. Import directory is required for Non-Autonomous target connections. If specified for an autonomous target, it will show an error. Export directory will error if there are database link details specified.
        :param pulumi.Input[str] handle_grant_errors: (Updatable) The action taken in the event of errors related to GRANT or REVOKE errors.
        :param pulumi.Input['MigrationInitialLoadSettingsImportDirectoryObjectArgs'] import_directory_object: (Updatable) Directory object details, used to define either import or export directory objects in Data Pump Settings. Import directory is required for Non-Autonomous target connections. If specified for an autonomous target, it will show an error. Export directory will error if there are database link details specified.
        :param pulumi.Input[bool] is_consistent: (Updatable) Enable (true) or disable (false) consistent data dumps by locking the instance for backup during the dump.
        :param pulumi.Input[bool] is_ignore_existing_objects: (Updatable) Import the dump even if it contains objects that already exist in the target schema in the MySQL instance.
        :param pulumi.Input[bool] is_tz_utc: (Updatable) Include a statement at the start of the dump to set the time zone to UTC.
        :param pulumi.Input[Sequence[pulumi.Input['MigrationInitialLoadSettingsMetadataRemapArgs']]] metadata_remaps: (Updatable) Defines remapping to be applied to objects as they are processed.
        :param pulumi.Input[str] primary_key_compatibility: (Updatable) Primary key compatibility option
        :param pulumi.Input['MigrationInitialLoadSettingsTablespaceDetailsArgs'] tablespace_details: (Updatable) Migration tablespace settings.
        """
        pulumi.set(__self__, "job_mode", job_mode)
        if compatibilities is not None:
            pulumi.set(__self__, "compatibilities", compatibilities)
        if data_pump_parameters is not None:
            pulumi.set(__self__, "data_pump_parameters", data_pump_parameters)
        if export_directory_object is not None:
            pulumi.set(__self__, "export_directory_object", export_directory_object)
        if handle_grant_errors is not None:
            pulumi.set(__self__, "handle_grant_errors", handle_grant_errors)
        if import_directory_object is not None:
            pulumi.set(__self__, "import_directory_object", import_directory_object)
        if is_consistent is not None:
            pulumi.set(__self__, "is_consistent", is_consistent)
        if is_ignore_existing_objects is not None:
            pulumi.set(__self__, "is_ignore_existing_objects", is_ignore_existing_objects)
        if is_tz_utc is not None:
            pulumi.set(__self__, "is_tz_utc", is_tz_utc)
        if metadata_remaps is not None:
            pulumi.set(__self__, "metadata_remaps", metadata_remaps)
        if primary_key_compatibility is not None:
            pulumi.set(__self__, "primary_key_compatibility", primary_key_compatibility)
        if tablespace_details is not None:
            pulumi.set(__self__, "tablespace_details", tablespace_details)

    @property
    @pulumi.getter(name="jobMode")
    def job_mode(self) -> pulumi.Input[str]:
        """
        (Updatable) Oracle Job Mode
        """
        return pulumi.get(self, "job_mode")

    @job_mode.setter
    def job_mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_mode", value)

    @property
    @pulumi.getter
    def compatibilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Apply the specified requirements for compatibility with MySQL Database Service for all tables in the dump  output, altering the dump files as necessary.
        """
        return pulumi.get(self, "compatibilities")

    @compatibilities.setter
    def compatibilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "compatibilities", value)

    @property
    @pulumi.getter(name="dataPumpParameters")
    def data_pump_parameters(self) -> Optional[pulumi.Input['MigrationInitialLoadSettingsDataPumpParametersArgs']]:
        """
        (Updatable) Optional parameters for Data Pump Export and Import.
        """
        return pulumi.get(self, "data_pump_parameters")

    @data_pump_parameters.setter
    def data_pump_parameters(self, value: Optional[pulumi.Input['MigrationInitialLoadSettingsDataPumpParametersArgs']]):
        pulumi.set(self, "data_pump_parameters", value)

    @property
    @pulumi.getter(name="exportDirectoryObject")
    def export_directory_object(self) -> Optional[pulumi.Input['MigrationInitialLoadSettingsExportDirectoryObjectArgs']]:
        """
        (Updatable) Directory object details, used to define either import or export directory objects in Data Pump Settings. Import directory is required for Non-Autonomous target connections. If specified for an autonomous target, it will show an error. Export directory will error if there are database link details specified.
        """
        return pulumi.get(self, "export_directory_object")

    @export_directory_object.setter
    def export_directory_object(self, value: Optional[pulumi.Input['MigrationInitialLoadSettingsExportDirectoryObjectArgs']]):
        pulumi.set(self, "export_directory_object", value)

    @property
    @pulumi.getter(name="handleGrantErrors")
    def handle_grant_errors(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The action taken in the event of errors related to GRANT or REVOKE errors.
        """
        return pulumi.get(self, "handle_grant_errors")

    @handle_grant_errors.setter
    def handle_grant_errors(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "handle_grant_errors", value)

    @property
    @pulumi.getter(name="importDirectoryObject")
    def import_directory_object(self) -> Optional[pulumi.Input['MigrationInitialLoadSettingsImportDirectoryObjectArgs']]:
        """
        (Updatable) Directory object details, used to define either import or export directory objects in Data Pump Settings. Import directory is required for Non-Autonomous target connections. If specified for an autonomous target, it will show an error. Export directory will error if there are database link details specified.
        """
        return pulumi.get(self, "import_directory_object")

    @import_directory_object.setter
    def import_directory_object(self, value: Optional[pulumi.Input['MigrationInitialLoadSettingsImportDirectoryObjectArgs']]):
        pulumi.set(self, "import_directory_object", value)

    @property
    @pulumi.getter(name="isConsistent")
    def is_consistent(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Enable (true) or disable (false) consistent data dumps by locking the instance for backup during the dump.
        """
        return pulumi.get(self, "is_consistent")

    @is_consistent.setter
    def is_consistent(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_consistent", value)

    @property
    @pulumi.getter(name="isIgnoreExistingObjects")
    def is_ignore_existing_objects(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Import the dump even if it contains objects that already exist in the target schema in the MySQL instance.
        """
        return pulumi.get(self, "is_ignore_existing_objects")

    @is_ignore_existing_objects.setter
    def is_ignore_existing_objects(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_ignore_existing_objects", value)

    @property
    @pulumi.getter(name="isTzUtc")
    def is_tz_utc(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Include a statement at the start of the dump to set the time zone to UTC.
        """
        return pulumi.get(self, "is_tz_utc")

    @is_tz_utc.setter
    def is_tz_utc(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_tz_utc", value)

    @property
    @pulumi.getter(name="metadataRemaps")
    def metadata_remaps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MigrationInitialLoadSettingsMetadataRemapArgs']]]]:
        """
        (Updatable) Defines remapping to be applied to objects as they are processed.
        """
        return pulumi.get(self, "metadata_remaps")

    @metadata_remaps.setter
    def metadata_remaps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationInitialLoadSettingsMetadataRemapArgs']]]]):
        pulumi.set(self, "metadata_remaps", value)

    @property
    @pulumi.getter(name="primaryKeyCompatibility")
    def primary_key_compatibility(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Primary key compatibility option
        """
        return pulumi.get(self, "primary_key_compatibility")

    @primary_key_compatibility.setter
    def primary_key_compatibility(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_key_compatibility", value)

    @property
    @pulumi.getter(name="tablespaceDetails")
    def tablespace_details(self) -> Optional[pulumi.Input['MigrationInitialLoadSettingsTablespaceDetailsArgs']]:
        """
        (Updatable) Migration tablespace settings.
        """
        return pulumi.get(self, "tablespace_details")

    @tablespace_details.setter
    def tablespace_details(self, value: Optional[pulumi.Input['MigrationInitialLoadSettingsTablespaceDetailsArgs']]):
        pulumi.set(self, "tablespace_details", value)


@pulumi.input_type
class MigrationInitialLoadSettingsDataPumpParametersArgs:
    def __init__(__self__, *,
                 estimate: Optional[pulumi.Input[str]] = None,
                 exclude_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 export_parallelism_degree: Optional[pulumi.Input[int]] = None,
                 import_parallelism_degree: Optional[pulumi.Input[int]] = None,
                 is_cluster: Optional[pulumi.Input[bool]] = None,
                 table_exists_action: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] estimate: (Updatable) Estimate size of dumps that will be generated.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exclude_parameters: (Updatable) Exclude paratemers for Export and Import.
        :param pulumi.Input[int] export_parallelism_degree: (Updatable) Maximum number of worker processes that can be used for a Data Pump Export job.
        :param pulumi.Input[int] import_parallelism_degree: (Updatable) Maximum number of worker processes that can be used for a Data Pump Import job. For an Autonomous Database, ODMS will automatically query its CPU core count and set this property.
        :param pulumi.Input[bool] is_cluster: (Updatable) Set to false to force Data Pump worker process to run on one instance.
        :param pulumi.Input[str] table_exists_action: (Updatable) IMPORT: Specifies the action to be performed when data is loaded into a preexisting table.
        """
        if estimate is not None:
            pulumi.set(__self__, "estimate", estimate)
        if exclude_parameters is not None:
            pulumi.set(__self__, "exclude_parameters", exclude_parameters)
        if export_parallelism_degree is not None:
            pulumi.set(__self__, "export_parallelism_degree", export_parallelism_degree)
        if import_parallelism_degree is not None:
            pulumi.set(__self__, "import_parallelism_degree", import_parallelism_degree)
        if is_cluster is not None:
            pulumi.set(__self__, "is_cluster", is_cluster)
        if table_exists_action is not None:
            pulumi.set(__self__, "table_exists_action", table_exists_action)

    @property
    @pulumi.getter
    def estimate(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Estimate size of dumps that will be generated.
        """
        return pulumi.get(self, "estimate")

    @estimate.setter
    def estimate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "estimate", value)

    @property
    @pulumi.getter(name="excludeParameters")
    def exclude_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Exclude paratemers for Export and Import.
        """
        return pulumi.get(self, "exclude_parameters")

    @exclude_parameters.setter
    def exclude_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exclude_parameters", value)

    @property
    @pulumi.getter(name="exportParallelismDegree")
    def export_parallelism_degree(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Maximum number of worker processes that can be used for a Data Pump Export job.
        """
        return pulumi.get(self, "export_parallelism_degree")

    @export_parallelism_degree.setter
    def export_parallelism_degree(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "export_parallelism_degree", value)

    @property
    @pulumi.getter(name="importParallelismDegree")
    def import_parallelism_degree(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Maximum number of worker processes that can be used for a Data Pump Import job. For an Autonomous Database, ODMS will automatically query its CPU core count and set this property.
        """
        return pulumi.get(self, "import_parallelism_degree")

    @import_parallelism_degree.setter
    def import_parallelism_degree(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "import_parallelism_degree", value)

    @property
    @pulumi.getter(name="isCluster")
    def is_cluster(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Set to false to force Data Pump worker process to run on one instance.
        """
        return pulumi.get(self, "is_cluster")

    @is_cluster.setter
    def is_cluster(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_cluster", value)

    @property
    @pulumi.getter(name="tableExistsAction")
    def table_exists_action(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) IMPORT: Specifies the action to be performed when data is loaded into a preexisting table.
        """
        return pulumi.get(self, "table_exists_action")

    @table_exists_action.setter
    def table_exists_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table_exists_action", value)


@pulumi.input_type
class MigrationInitialLoadSettingsExportDirectoryObjectArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: (Updatable) Name of directory object in database
        :param pulumi.Input[str] path: (Updatable) Absolute path of directory on database server
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of directory object in database
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Absolute path of directory on database server
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class MigrationInitialLoadSettingsImportDirectoryObjectArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: (Updatable) Name of directory object in database
        :param pulumi.Input[str] path: (Updatable) Absolute path of directory on database server
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of directory object in database
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Absolute path of directory on database server
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class MigrationInitialLoadSettingsMetadataRemapArgs:
    def __init__(__self__, *,
                 new_value: Optional[pulumi.Input[str]] = None,
                 old_value: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] new_value: (Updatable) Specifies the new value that oldValue should be translated into.
        :param pulumi.Input[str] old_value: (Updatable) Specifies the value which needs to be reset.
        :param pulumi.Input[str] type: (Updatable) Type of remap. Refer to [METADATA_REMAP Procedure ](https://docs.oracle.com/en/database/oracle/oracle-database/19/arpls/DBMS_DATAPUMP.html#GUID-0FC32790-91E6-4781-87A3-229DE024CB3D)
        """
        if new_value is not None:
            pulumi.set(__self__, "new_value", new_value)
        if old_value is not None:
            pulumi.set(__self__, "old_value", old_value)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="newValue")
    def new_value(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specifies the new value that oldValue should be translated into.
        """
        return pulumi.get(self, "new_value")

    @new_value.setter
    def new_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "new_value", value)

    @property
    @pulumi.getter(name="oldValue")
    def old_value(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specifies the value which needs to be reset.
        """
        return pulumi.get(self, "old_value")

    @old_value.setter
    def old_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "old_value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Type of remap. Refer to [METADATA_REMAP Procedure ](https://docs.oracle.com/en/database/oracle/oracle-database/19/arpls/DBMS_DATAPUMP.html#GUID-0FC32790-91E6-4781-87A3-229DE024CB3D)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class MigrationInitialLoadSettingsTablespaceDetailsArgs:
    def __init__(__self__, *,
                 target_type: pulumi.Input[str],
                 block_size_in_kbs: Optional[pulumi.Input[str]] = None,
                 extend_size_in_mbs: Optional[pulumi.Input[int]] = None,
                 is_auto_create: Optional[pulumi.Input[bool]] = None,
                 is_big_file: Optional[pulumi.Input[bool]] = None,
                 remap_target: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] target_type: (Updatable) Type of Database Base Migration Target.
        :param pulumi.Input[str] block_size_in_kbs: (Updatable) Size of Oracle database blocks in KB.
        :param pulumi.Input[int] extend_size_in_mbs: (Updatable) Size to extend the tablespace in MB.  Note: Only applicable if 'isBigFile' property is set to true.
        :param pulumi.Input[bool] is_auto_create: (Updatable) Set this property to true to auto-create tablespaces in the target Database. Note: This is not applicable for Autonomous Database Serverless databases.
        :param pulumi.Input[bool] is_big_file: (Updatable) Set this property to true to enable tablespace of the type big file.
        :param pulumi.Input[str] remap_target: (Updatable) Name of the tablespace on the target database to which the source database tablespace is to be remapped.
        """
        pulumi.set(__self__, "target_type", target_type)
        if block_size_in_kbs is not None:
            pulumi.set(__self__, "block_size_in_kbs", block_size_in_kbs)
        if extend_size_in_mbs is not None:
            pulumi.set(__self__, "extend_size_in_mbs", extend_size_in_mbs)
        if is_auto_create is not None:
            pulumi.set(__self__, "is_auto_create", is_auto_create)
        if is_big_file is not None:
            pulumi.set(__self__, "is_big_file", is_big_file)
        if remap_target is not None:
            pulumi.set(__self__, "remap_target", remap_target)

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> pulumi.Input[str]:
        """
        (Updatable) Type of Database Base Migration Target.
        """
        return pulumi.get(self, "target_type")

    @target_type.setter
    def target_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_type", value)

    @property
    @pulumi.getter(name="blockSizeInKbs")
    def block_size_in_kbs(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Size of Oracle database blocks in KB.
        """
        return pulumi.get(self, "block_size_in_kbs")

    @block_size_in_kbs.setter
    def block_size_in_kbs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "block_size_in_kbs", value)

    @property
    @pulumi.getter(name="extendSizeInMbs")
    def extend_size_in_mbs(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Size to extend the tablespace in MB.  Note: Only applicable if 'isBigFile' property is set to true.
        """
        return pulumi.get(self, "extend_size_in_mbs")

    @extend_size_in_mbs.setter
    def extend_size_in_mbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "extend_size_in_mbs", value)

    @property
    @pulumi.getter(name="isAutoCreate")
    def is_auto_create(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Set this property to true to auto-create tablespaces in the target Database. Note: This is not applicable for Autonomous Database Serverless databases.
        """
        return pulumi.get(self, "is_auto_create")

    @is_auto_create.setter
    def is_auto_create(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_auto_create", value)

    @property
    @pulumi.getter(name="isBigFile")
    def is_big_file(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Set this property to true to enable tablespace of the type big file.
        """
        return pulumi.get(self, "is_big_file")

    @is_big_file.setter
    def is_big_file(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_big_file", value)

    @property
    @pulumi.getter(name="remapTarget")
    def remap_target(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of the tablespace on the target database to which the source database tablespace is to be remapped.
        """
        return pulumi.get(self, "remap_target")

    @remap_target.setter
    def remap_target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remap_target", value)


@pulumi.input_type
class GetConnectionsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name of the property entry.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the property entry.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetMigrationObjectTypesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Object type name
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Object type name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


