# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetNamespaceIngestTimeRulesResult',
    'AwaitableGetNamespaceIngestTimeRulesResult',
    'get_namespace_ingest_time_rules',
    'get_namespace_ingest_time_rules_output',
]

@pulumi.output_type
class GetNamespaceIngestTimeRulesResult:
    """
    A collection of values returned by getNamespaceIngestTimeRules.
    """
    def __init__(__self__, compartment_id=None, condition_kind=None, display_name=None, field_name=None, field_value=None, filters=None, id=None, ingest_time_rule_summary_collections=None, namespace=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if condition_kind and not isinstance(condition_kind, str):
            raise TypeError("Expected argument 'condition_kind' to be a str")
        pulumi.set(__self__, "condition_kind", condition_kind)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if field_name and not isinstance(field_name, str):
            raise TypeError("Expected argument 'field_name' to be a str")
        pulumi.set(__self__, "field_name", field_name)
        if field_value and not isinstance(field_value, str):
            raise TypeError("Expected argument 'field_value' to be a str")
        pulumi.set(__self__, "field_value", field_value)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ingest_time_rule_summary_collections and not isinstance(ingest_time_rule_summary_collections, list):
            raise TypeError("Expected argument 'ingest_time_rule_summary_collections' to be a list")
        pulumi.set(__self__, "ingest_time_rule_summary_collections", ingest_time_rule_summary_collections)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment Identifier [OCID] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="conditionKind")
    def condition_kind(self) -> Optional[str]:
        return pulumi.get(self, "condition_kind")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The ingest time rule display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="fieldName")
    def field_name(self) -> Optional[str]:
        """
        The field name to be evaluated.
        """
        return pulumi.get(self, "field_name")

    @property
    @pulumi.getter(name="fieldValue")
    def field_value(self) -> Optional[str]:
        """
        The field value to be evaluated.
        """
        return pulumi.get(self, "field_value")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetNamespaceIngestTimeRulesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ingestTimeRuleSummaryCollections")
    def ingest_time_rule_summary_collections(self) -> Sequence['outputs.GetNamespaceIngestTimeRulesIngestTimeRuleSummaryCollectionResult']:
        """
        The list of ingest_time_rule_summary_collection.
        """
        return pulumi.get(self, "ingest_time_rule_summary_collections")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The namespace of the extracted metric. A valid value starts with an alphabetical character and includes only alphanumeric characters and underscores (_).
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the ingest time rule.
        """
        return pulumi.get(self, "state")


class AwaitableGetNamespaceIngestTimeRulesResult(GetNamespaceIngestTimeRulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNamespaceIngestTimeRulesResult(
            compartment_id=self.compartment_id,
            condition_kind=self.condition_kind,
            display_name=self.display_name,
            field_name=self.field_name,
            field_value=self.field_value,
            filters=self.filters,
            id=self.id,
            ingest_time_rule_summary_collections=self.ingest_time_rule_summary_collections,
            namespace=self.namespace,
            state=self.state)


def get_namespace_ingest_time_rules(compartment_id: Optional[str] = None,
                                    condition_kind: Optional[str] = None,
                                    display_name: Optional[str] = None,
                                    field_name: Optional[str] = None,
                                    field_value: Optional[str] = None,
                                    filters: Optional[Sequence[pulumi.InputType['GetNamespaceIngestTimeRulesFilterArgs']]] = None,
                                    namespace: Optional[str] = None,
                                    state: Optional[str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNamespaceIngestTimeRulesResult:
    """
    This data source provides the list of Namespace Ingest Time Rules in Oracle Cloud Infrastructure Log Analytics service.

    Returns a list of ingest time rules in a compartment. You may limit the number of rules, provide sorting options, and filter the results.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_namespace_ingest_time_rules = oci.LogAnalytics.get_namespace_ingest_time_rules(compartment_id=compartment_id,
        namespace=namespace_ingest_time_rule_namespace,
        condition_kind=namespace_ingest_time_rule_condition_kind,
        display_name=namespace_ingest_time_rule_display_name,
        field_name=namespace_ingest_time_rule_field_name,
        field_value=namespace_ingest_time_rule_field_value,
        state=namespace_ingest_time_rule_state)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str condition_kind: The ingest time rule condition kind used for filtering. Only rules with conditions of the specified kind will be returned.
    :param str display_name: A filter to return rules whose displayName matches in whole or in part the specified value. The match is case-insensitive.
    :param str field_name: The field name used for filtering. Only rules using the specified field name will be returned.
    :param str field_value: The field value used for filtering. Only rules using the specified field value will be returned.
    :param str namespace: The Logging Analytics namespace used for the request.
    :param str state: The rule lifecycle state used for filtering. Currently supported values are ACTIVE and DELETED.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['conditionKind'] = condition_kind
    __args__['displayName'] = display_name
    __args__['fieldName'] = field_name
    __args__['fieldValue'] = field_value
    __args__['filters'] = filters
    __args__['namespace'] = namespace
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LogAnalytics/getNamespaceIngestTimeRules:getNamespaceIngestTimeRules', __args__, opts=opts, typ=GetNamespaceIngestTimeRulesResult).value

    return AwaitableGetNamespaceIngestTimeRulesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        condition_kind=pulumi.get(__ret__, 'condition_kind'),
        display_name=pulumi.get(__ret__, 'display_name'),
        field_name=pulumi.get(__ret__, 'field_name'),
        field_value=pulumi.get(__ret__, 'field_value'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        ingest_time_rule_summary_collections=pulumi.get(__ret__, 'ingest_time_rule_summary_collections'),
        namespace=pulumi.get(__ret__, 'namespace'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_namespace_ingest_time_rules)
def get_namespace_ingest_time_rules_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                           condition_kind: Optional[pulumi.Input[Optional[str]]] = None,
                                           display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                           field_name: Optional[pulumi.Input[Optional[str]]] = None,
                                           field_value: Optional[pulumi.Input[Optional[str]]] = None,
                                           filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetNamespaceIngestTimeRulesFilterArgs']]]]] = None,
                                           namespace: Optional[pulumi.Input[str]] = None,
                                           state: Optional[pulumi.Input[Optional[str]]] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNamespaceIngestTimeRulesResult]:
    """
    This data source provides the list of Namespace Ingest Time Rules in Oracle Cloud Infrastructure Log Analytics service.

    Returns a list of ingest time rules in a compartment. You may limit the number of rules, provide sorting options, and filter the results.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_namespace_ingest_time_rules = oci.LogAnalytics.get_namespace_ingest_time_rules(compartment_id=compartment_id,
        namespace=namespace_ingest_time_rule_namespace,
        condition_kind=namespace_ingest_time_rule_condition_kind,
        display_name=namespace_ingest_time_rule_display_name,
        field_name=namespace_ingest_time_rule_field_name,
        field_value=namespace_ingest_time_rule_field_value,
        state=namespace_ingest_time_rule_state)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str condition_kind: The ingest time rule condition kind used for filtering. Only rules with conditions of the specified kind will be returned.
    :param str display_name: A filter to return rules whose displayName matches in whole or in part the specified value. The match is case-insensitive.
    :param str field_name: The field name used for filtering. Only rules using the specified field name will be returned.
    :param str field_value: The field value used for filtering. Only rules using the specified field value will be returned.
    :param str namespace: The Logging Analytics namespace used for the request.
    :param str state: The rule lifecycle state used for filtering. Currently supported values are ACTIVE and DELETED.
    """
    ...
