# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetSystemMediaWorkflowResult',
    'AwaitableGetSystemMediaWorkflowResult',
    'get_system_media_workflow',
    'get_system_media_workflow_output',
]

@pulumi.output_type
class GetSystemMediaWorkflowResult:
    """
    A collection of values returned by getSystemMediaWorkflow.
    """
    def __init__(__self__, compartment_id=None, id=None, items=None, name=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSystemMediaWorkflowItemResult']:
        """
        List of SytemMediaWorkflow items.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        System provided unique identifier for this static media workflow.
        """
        return pulumi.get(self, "name")


class AwaitableGetSystemMediaWorkflowResult(GetSystemMediaWorkflowResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSystemMediaWorkflowResult(
            compartment_id=self.compartment_id,
            id=self.id,
            items=self.items,
            name=self.name)


def get_system_media_workflow(compartment_id: Optional[str] = None,
                              name: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSystemMediaWorkflowResult:
    """
    This data source provides details about a specific System Media Workflow resource in Oracle Cloud Infrastructure Media Services service.

    Lists the SystemMediaWorkflows that can be used to run a job by name or as a template to create a MediaWorkflow.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_system_media_workflow = oci.MediaServices.get_system_media_workflow(compartment_id=compartment_id,
        name=system_media_workflow_name)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str name: A filter to return only the resources with their system defined, unique name matching the given name.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:MediaServices/getSystemMediaWorkflow:getSystemMediaWorkflow', __args__, opts=opts, typ=GetSystemMediaWorkflowResult).value

    return AwaitableGetSystemMediaWorkflowResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        name=pulumi.get(__ret__, 'name'))


@_utilities.lift_output_func(get_system_media_workflow)
def get_system_media_workflow_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                     name: Optional[pulumi.Input[Optional[str]]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSystemMediaWorkflowResult]:
    """
    This data source provides details about a specific System Media Workflow resource in Oracle Cloud Infrastructure Media Services service.

    Lists the SystemMediaWorkflows that can be used to run a job by name or as a template to create a MediaWorkflow.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_system_media_workflow = oci.MediaServices.get_system_media_workflow(compartment_id=compartment_id,
        name=system_media_workflow_name)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str name: A filter to return only the resources with their system defined, unique name matching the given name.
    """
    ...
