# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMaskingPolicyMaskingObjectsResult',
    'AwaitableGetMaskingPolicyMaskingObjectsResult',
    'get_masking_policy_masking_objects',
    'get_masking_policy_masking_objects_output',
]

@pulumi.output_type
class GetMaskingPolicyMaskingObjectsResult:
    """
    A collection of values returned by getMaskingPolicyMaskingObjects.
    """
    def __init__(__self__, filters=None, id=None, masking_object_collections=None, masking_policy_id=None, object_types=None, objects=None, schema_names=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if masking_object_collections and not isinstance(masking_object_collections, list):
            raise TypeError("Expected argument 'masking_object_collections' to be a list")
        pulumi.set(__self__, "masking_object_collections", masking_object_collections)
        if masking_policy_id and not isinstance(masking_policy_id, str):
            raise TypeError("Expected argument 'masking_policy_id' to be a str")
        pulumi.set(__self__, "masking_policy_id", masking_policy_id)
        if object_types and not isinstance(object_types, list):
            raise TypeError("Expected argument 'object_types' to be a list")
        pulumi.set(__self__, "object_types", object_types)
        if objects and not isinstance(objects, list):
            raise TypeError("Expected argument 'objects' to be a list")
        pulumi.set(__self__, "objects", objects)
        if schema_names and not isinstance(schema_names, list):
            raise TypeError("Expected argument 'schema_names' to be a list")
        pulumi.set(__self__, "schema_names", schema_names)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetMaskingPolicyMaskingObjectsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maskingObjectCollections")
    def masking_object_collections(self) -> Sequence['outputs.GetMaskingPolicyMaskingObjectsMaskingObjectCollectionResult']:
        """
        The list of masking_object_collection.
        """
        return pulumi.get(self, "masking_object_collections")

    @property
    @pulumi.getter(name="maskingPolicyId")
    def masking_policy_id(self) -> str:
        return pulumi.get(self, "masking_policy_id")

    @property
    @pulumi.getter(name="objectTypes")
    def object_types(self) -> Optional[Sequence[str]]:
        """
        The type of the database object that contains the masking column.
        """
        return pulumi.get(self, "object_types")

    @property
    @pulumi.getter
    def objects(self) -> Optional[Sequence[str]]:
        """
        The database object that contains the masking column.
        """
        return pulumi.get(self, "objects")

    @property
    @pulumi.getter(name="schemaNames")
    def schema_names(self) -> Optional[Sequence[str]]:
        """
        The database schema that contains the masking column.
        """
        return pulumi.get(self, "schema_names")


class AwaitableGetMaskingPolicyMaskingObjectsResult(GetMaskingPolicyMaskingObjectsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMaskingPolicyMaskingObjectsResult(
            filters=self.filters,
            id=self.id,
            masking_object_collections=self.masking_object_collections,
            masking_policy_id=self.masking_policy_id,
            object_types=self.object_types,
            objects=self.objects,
            schema_names=self.schema_names)


def get_masking_policy_masking_objects(filters: Optional[Sequence[pulumi.InputType['GetMaskingPolicyMaskingObjectsFilterArgs']]] = None,
                                       masking_policy_id: Optional[str] = None,
                                       object_types: Optional[Sequence[str]] = None,
                                       objects: Optional[Sequence[str]] = None,
                                       schema_names: Optional[Sequence[str]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMaskingPolicyMaskingObjectsResult:
    """
    This data source provides the list of Masking Policy Masking Objects in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of masking objects present in the specified masking policy and based on the specified query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_masking_policy_masking_objects = oci.DataSafe.get_masking_policy_masking_objects(masking_policy_id=test_masking_policy["id"],
        objects=masking_policy_masking_object_object,
        object_types=masking_policy_masking_object_object_type,
        schema_names=masking_policy_masking_object_schema_name)
    ```


    :param str masking_policy_id: The OCID of the masking policy.
    :param Sequence[str] object_types: A filter to return only items related to a specific object type.
    :param Sequence[str] objects: A filter to return only items related to a specific object name.
    :param Sequence[str] schema_names: A filter to return only items related to specific schema name.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['maskingPolicyId'] = masking_policy_id
    __args__['objectTypes'] = object_types
    __args__['objects'] = objects
    __args__['schemaNames'] = schema_names
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getMaskingPolicyMaskingObjects:getMaskingPolicyMaskingObjects', __args__, opts=opts, typ=GetMaskingPolicyMaskingObjectsResult).value

    return AwaitableGetMaskingPolicyMaskingObjectsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        masking_object_collections=pulumi.get(__ret__, 'masking_object_collections'),
        masking_policy_id=pulumi.get(__ret__, 'masking_policy_id'),
        object_types=pulumi.get(__ret__, 'object_types'),
        objects=pulumi.get(__ret__, 'objects'),
        schema_names=pulumi.get(__ret__, 'schema_names'))


@_utilities.lift_output_func(get_masking_policy_masking_objects)
def get_masking_policy_masking_objects_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetMaskingPolicyMaskingObjectsFilterArgs']]]]] = None,
                                              masking_policy_id: Optional[pulumi.Input[str]] = None,
                                              object_types: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                              objects: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                              schema_names: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMaskingPolicyMaskingObjectsResult]:
    """
    This data source provides the list of Masking Policy Masking Objects in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of masking objects present in the specified masking policy and based on the specified query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_masking_policy_masking_objects = oci.DataSafe.get_masking_policy_masking_objects(masking_policy_id=test_masking_policy["id"],
        objects=masking_policy_masking_object_object,
        object_types=masking_policy_masking_object_object_type,
        schema_names=masking_policy_masking_object_schema_name)
    ```


    :param str masking_policy_id: The OCID of the masking policy.
    :param Sequence[str] object_types: A filter to return only items related to a specific object type.
    :param Sequence[str] objects: A filter to return only items related to a specific object name.
    :param Sequence[str] schema_names: A filter to return only items related to specific schema name.
    """
    ...
