#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['fastapi',
 'fastapi.dependencies',
 'fastapi.middleware',
 'fastapi.openapi',
 'fastapi.security']

package_data = \
{'': ['*']}

install_requires = \
['starlette ==0.13.6', 'pydantic >=1.0.0,<2.0.0']

extras_require = \
{'all': ['requests >=2.24.0,<3.0.0',
         'aiofiles >=0.5.0,<0.6.0',
         'jinja2 >=2.11.2,<3.0.0',
         'python-multipart >=0.0.5,<0.0.6',
         'itsdangerous >=1.1.0,<2.0.0',
         'pyyaml >=5.3.1,<6.0.0',
         'graphene >=2.1.8,<3.0.0',
         'ujson >=3.0.0,<4.0.0',
         'orjson >=3.2.1,<4.0.0',
         'email_validator >=1.1.1,<2.0.0',
         'uvicorn >=0.11.5,<0.12.0',
         'async_exit_stack >=1.0.1,<2.0.0',
         'async_generator >=1.10,<2.0.0'],
 'dev': ['python-jose[cryptography] >=3.1.0,<4.0.0',
         'passlib[bcrypt] >=1.7.2,<2.0.0',
         'autoflake >=1.3.1,<2.0.0',
         'flake8 >=3.8.3,<4.0.0',
         'uvicorn >=0.11.5,<0.12.0',
         'graphene >=2.1.8,<3.0.0'],
 'doc': ['mkdocs >=1.1.2,<2.0.0',
         'mkdocs-material >=5.5.0,<6.0.0',
         'markdown-include >=0.5.1,<0.6.0',
         'mkdocs-markdownextradata-plugin >=0.1.7,<0.2.0',
         'typer >=0.3.0,<0.4.0',
         'typer-cli >=0.0.9,<0.0.10',
         'pyyaml >=5.3.1,<6.0.0'],
 'test': ['pytest ==5.4.3',
          'pytest-cov ==2.10.0',
          'pytest-asyncio >=0.14.0,<0.15.0',
          'mypy ==0.782',
          'flake8 >=3.8.3,<4.0.0',
          'black ==19.10b0',
          'isort >=5.0.6,<6.0.0',
          'requests >=2.24.0,<3.0.0',
          'httpx >=0.14.0,<0.15.0',
          'email_validator >=1.1.1,<2.0.0',
          'sqlalchemy >=1.3.18,<2.0.0',
          'peewee >=3.13.3,<4.0.0',
          'databases[sqlite] >=0.3.2,<0.4.0',
          'orjson >=3.2.1,<4.0.0',
          'async_exit_stack >=1.0.1,<2.0.0',
          'async_generator >=1.10,<2.0.0',
          'python-multipart >=0.0.5,<0.0.6',
          'aiofiles >=0.5.0,<0.6.0',
          'flask >=1.1.2,<2.0.0']}

setup(name='fastapi',
      version='0.61.0',
      description='FastAPI framework, high performance, easy to learn, fast to code, ready for production',
      author='Sebastián Ramírez',
      author_email='tiangolo@gmail.com',
      url='https://github.com/tiangolo/fastapi',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>=3.6',
     )
