# -*- coding: utf-8 -*-
# (c) Copyright 2021 Sensirion AG, Switzerland

##############################################################################
##############################################################################
#                 _____         _    _ _______ _____ ____  _   _
#                / ____|   /\  | |  | |__   __|_   _/ __ \| \ | |
#               | |       /  \ | |  | |  | |    | || |  | |  \| |
#               | |      / /\ \| |  | |  | |    | || |  | | . ` |
#               | |____ / ____ \ |__| |  | |   _| || |__| | |\  |
#                \_____/_/    \_\____/   |_|  |_____\____/|_| \_|
#
#     THIS FILE IS AUTOMATICALLY GENERATED AND MUST NOT BE EDITED MANUALLY!
#
# Generator:    sensirion-shdlc-interface-generator 0.8.1
# Product:      SFA3x
# Version:      0.1.0
#
##############################################################################
##############################################################################

# flake8: noqa

from __future__ import absolute_import, division, print_function
from sensirion_shdlc_driver.command import ShdlcCommand
from struct import pack, unpack

import logging
log = logging.getLogger(__name__)


class Sfa3xCmdReadMeasuredValuesBase(ShdlcCommand):
    """
    SHDLC command 0x03: "Read Measured Values".
    """

    def __init__(self, *args, **kwargs):
        """
        Constructor.
        """
        super(Sfa3xCmdReadMeasuredValuesBase, self).__init__(
            0x03, *args, **kwargs)


class Sfa3xCmdReadMeasuredValuesOutputFormat2(Sfa3xCmdReadMeasuredValuesBase):
    """
    Read Measured Values Output Format 2 Command

    Read measured values integer.
    """

    def __init__(self):
        """
        Constructor.
        """
        super(Sfa3xCmdReadMeasuredValuesOutputFormat2, self).__init__(
            data=b"".join([bytes(bytearray([0x02]))]),
            max_response_time=0.1,
            post_processing_time=0.0,
            min_response_length=6,
            max_response_length=6
        )

    @staticmethod
    def interpret_response(data):
        """
        :return:
            - hcho (int) -
              Formaldehyde concentration in ppb as a 16-bit signed integer.
              Positive values only, negative values are coerced to zero. Scale
              factor 5 ppb^(-1).
            - relative_humidity (int) -
              Relative humidity in %. Values between 0 and 100 only. With
              internal correction for temperature offset (if configured). Scale
              factor 100 %^(-1).
            - temperature (int) -
              Temperature in °C. With internal correction for temperature
              offset (if configured). Scale factor 200 °C^(-1).
        :rtype: tuple
        """
        hcho = int(unpack(">h", data[0:2])[0])  # int16
        relative_humidity = int(unpack(">h", data[2:4])[0])  # int16
        temperature = int(unpack(">h", data[4:6])[0])  # int16
        return hcho,\
            relative_humidity,\
            temperature
