# -*- coding: utf-8 -*-
# (c) Copyright 2021 Sensirion AG, Switzerland

##############################################################################
##############################################################################
#                 _____         _    _ _______ _____ ____  _   _
#                / ____|   /\  | |  | |__   __|_   _/ __ \| \ | |
#               | |       /  \ | |  | |  | |    | || |  | |  \| |
#               | |      / /\ \| |  | |  | |    | || |  | | . ` |
#               | |____ / ____ \ |__| |  | |   _| || |__| | |\  |
#                \_____/_/    \_\____/   |_|  |_____\____/|_| \_|
#
#     THIS FILE IS AUTOMATICALLY GENERATED AND MUST NOT BE EDITED MANUALLY!
#
# Generator:    sensirion-shdlc-interface-generator 0.8.1
# Product:      SFA3x
# Version:      0.1.0
#
##############################################################################
##############################################################################

# flake8: noqa

from __future__ import absolute_import, division, print_function
from sensirion_shdlc_driver.errors import ShdlcDeviceError

import logging
log = logging.getLogger(__name__)


class Sfa3xNoMeasurementDataAvailable(ShdlcDeviceError):
    """
    No measurement data is available at the moment.
    """
    def __init__(self):
        super(Sfa3xNoMeasurementDataAvailable, self).__init__(
            0x20,
            "No measurement data is available at the moment."
        )


class Sfa3xCommandNotAllowedInCurrentState(ShdlcDeviceError):
    """
    The requested command is not allowed in the current device state.
    """
    def __init__(self):
        super(Sfa3xCommandNotAllowedInCurrentState, self).__init__(
            0x43,
            "The requested command is not allowed in the current device "
            "state."
        )


class Sfa3xFileError(ShdlcDeviceError):
    """
    A file error occurred (init/read/write error).
    """
    def __init__(self):
        super(Sfa3xFileError, self).__init__(
            0x44,
            "A file error occurred (init/read/write error)."
        )


class Sfa3xFatalError(ShdlcDeviceError):
    """
    An error without specific error code occurred.
    """
    def __init__(self):
        super(Sfa3xFatalError, self).__init__(
            0x7F,
            "An error without specific error code occurred."
        )


"""
List containing all device errors specified in this file.
"""
SFA3X_DEVICE_ERROR_LIST = [
    Sfa3xNoMeasurementDataAvailable(),
    Sfa3xCommandNotAllowedInCurrentState(),
    Sfa3xFileError(),
    Sfa3xFatalError(),
]
