import pytest
from . import *


@pytest.mark.parametrize(
    "input, output",
    [
        ("Hell9o, world!", "hell9oWorld"),
        ("0Hello, world!", "0helloWorld"),
        ("Hello, world!0", "helloWorld0"),
    ],
)
def test_with_numbers(input, output):
    assert camelcase(input) == output


@pytest.mark.parametrize(
    "input, output",
    [
        ("Hello, world!", "hello,World!"),
    ],
)
def test_no_strip_punctuation(input, output):
    assert camelcase(input, strip_punctuation=False) == output
