import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermBillingMcaAccountScopeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/billing_mca_account_scope#billing_account_name DataAzurermBillingMcaAccountScope#billing_account_name}
    */
    readonly billingAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/billing_mca_account_scope#billing_profile_name DataAzurermBillingMcaAccountScope#billing_profile_name}
    */
    readonly billingProfileName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/billing_mca_account_scope#invoice_section_name DataAzurermBillingMcaAccountScope#invoice_section_name}
    */
    readonly invoiceSectionName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/billing_mca_account_scope#timeouts DataAzurermBillingMcaAccountScope#timeouts}
    */
    readonly timeouts?: DataAzurermBillingMcaAccountScopeTimeouts;
}
export interface DataAzurermBillingMcaAccountScopeTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/billing_mca_account_scope#read DataAzurermBillingMcaAccountScope#read}
    */
    readonly read?: string;
}
export declare function dataAzurermBillingMcaAccountScopeTimeoutsToTerraform(struct?: DataAzurermBillingMcaAccountScopeTimeoutsOutputReference | DataAzurermBillingMcaAccountScopeTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermBillingMcaAccountScopeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermBillingMcaAccountScopeTimeouts | undefined;
    set internalValue(value: DataAzurermBillingMcaAccountScopeTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/billing_mca_account_scope azurerm_billing_mca_account_scope}
*/
export declare class DataAzurermBillingMcaAccountScope extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_billing_mca_account_scope";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/billing_mca_account_scope azurerm_billing_mca_account_scope} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermBillingMcaAccountScopeConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermBillingMcaAccountScopeConfig);
    private _billingAccountName?;
    get billingAccountName(): string;
    set billingAccountName(value: string);
    get billingAccountNameInput(): string | undefined;
    private _billingProfileName?;
    get billingProfileName(): string;
    set billingProfileName(value: string);
    get billingProfileNameInput(): string | undefined;
    get id(): string;
    private _invoiceSectionName?;
    get invoiceSectionName(): string;
    set invoiceSectionName(value: string);
    get invoiceSectionNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermBillingMcaAccountScopeTimeoutsOutputReference;
    putTimeouts(value: DataAzurermBillingMcaAccountScopeTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermBillingMcaAccountScopeTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
